/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.clu;

import com.huawei.db.migration.common.handlers.MigrationProcessor;
import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.splitter.SqlStatementRangeGenerator;
import com.huawei.db.migration.util.CommandInjectionChecker;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.PropertyLoader;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GaussDBVerificationUtility {
    private static final Logger logger = LogManager.getLogger(GaussDBVerificationUtility.class);
    private static final long PROC_WAIT_TIME_OUT = 2000L;
    private static String preExecutionPath = null;

    public static void configValidation(String gaussDBPassword, String targetDB, String preExecutePath) {
        Map<String, String> map = PropertyLoader.loadPropertyFile("gaussdb");
        String user = map.get("gaussdb-user");
        preExecutionPath = preExecutePath;
        if (gaussDBPassword == null || gaussDBPassword.isEmpty()) {
            throw new MigrationServiceException("[DSC_ERR_004_027] " + MessageLoader.getMessage("DSC_ERR_004_027"));
        }
        if (targetDB.isEmpty() || !"gaussdba".equals(targetDB) && !"gaussdbt".equals(targetDB)) {
            throw new MigrationServiceException("[DSC_ERR_004_028] " + MessageLoader.getMessage("DSC_ERR_004_028"));
        }
        if (user == null || user.isEmpty()) {
            throw new MigrationServiceException("[DSC_ERR_004_029] " + MessageLoader.getMessage("DSC_ERR_004_029"));
        }
        String port = map.get("gaussdb-port");
        if (port == null || port.isEmpty() || !port.matches("\\d+") || Integer.parseInt(port) > 65535) {
            throw new MigrationServiceException("[DSC_ERR_004_030] " + MessageLoader.getMessage("DSC_ERR_004_030"));
        }
        String ip = map.get("gaussdb-ip");
        if (ip == null || ip.isEmpty() || !ip.matches("\\d+\\.\\d+\\.\\d+\\.\\d+")) {
            throw new MigrationServiceException("[DSC_ERR_004_031] " + MessageLoader.getMessage("DSC_ERR_004_031"));
        }
        String dbname = map.get("gaussdb-name");
        if (targetDB.equals("gaussdba") && (dbname == null || dbname.isEmpty())) {
            throw new MigrationServiceException("[DSC_ERR_004_032] " + MessageLoader.getMessage("DSC_ERR_004_032"));
        }
        GaussDBVerificationUtility.configDataValidation(map, targetDB, gaussDBPassword);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void configDataValidation(Map<String, String> map, String targetDB, String gaussDbPass) {
        File dir;
        String user = map.get("gaussdb-user");
        String port = map.get("gaussdb-port");
        String ip = map.get("gaussdb-ip");
        String testConFile = "scripts/verifyGaussPython/src/testconn.sql";
        ArrayList<String> command = new ArrayList<String>();
        if (targetDB.equalsIgnoreCase("gaussdba")) {
            String dbname = map.get("gaussdb-name");
            GaussDBVerificationUtility.gaussDbCommand(user, port, ip, command, dbname);
            command.add(testConFile);
            if (CommandInjectionChecker.isExistsCommandInjection((String)((Object)command).toString())) throw new MigrationServiceException("[DSC_ERR_005_002] " + MessageLoader.getMessage("DSC_ERR_005_002"));
            command.add("-W");
            command.add(gaussDbPass);
        } else {
            command.add(user + "@" + ip + ":" + port);
            if (CommandInjectionChecker.isExistsCommandInjection((String)((Object)command).toString())) {
                throw new MigrationServiceException("[DSC_ERR_005_002] " + MessageLoader.getMessage("DSC_ERR_005_002"));
            }
            command.clear();
            command.add("zsql");
            command.add(user + File.separator + gaussDbPass + "@" + ip + ":" + port);
            command.add("-q");
            command.add("-f");
            command.add(testConFile);
        }
        String result = GaussDBVerificationUtility.gaussDbExecutionCheck(command, false);
        if (null == result || !result.toUpperCase(Locale.ROOT).contains("RESULTCOL")) {
            throw new MigrationServiceException("[DSC_ERR_005_028] " + MessageLoader.getMessage("DSC_ERR_005_028"));
        }
        GaussDBVerificationUtility.pythonVersionCheck();
        if (!(preExecutionPath == null || (dir = new File(preExecutionPath)).exists() && dir.isDirectory())) {
            throw new MigrationServiceException("Pre query execution path does not exist : " + preExecutionPath);
        }
        String threadcount = map.get("gaussdbathreadcount");
        if (threadcount != null && !threadcount.isEmpty() && threadcount.matches("\\d+") && Integer.parseInt(threadcount) >= 1) return;
        throw new MigrationServiceException("[DSC_ERR_004_049] " + MessageLoader.getMessage("DSC_ERR_004_049"));
    }

    private static void gaussDbCommand(String user, String port, String ip, List<String> command, String dbname) {
        command.add("gsql");
        command.add("-d");
        command.add(dbname);
        command.add("-p");
        command.add(port);
        command.add("-U");
        command.add(user);
        command.add("-h");
        command.add(ip);
        command.add("-q");
        command.add("-f");
    }

    private static void pythonVersionCheck() {
        ArrayList<String> command = new ArrayList<String>();
        command.add("python3");
        command.add("-V");
        String result = GaussDBVerificationUtility.gaussDbExecutionCheck(command, false);
        if (null == result || !result.trim().matches("Python\\s+3\\.\\d+\\.\\d+")) {
            throw new MigrationServiceException("Incompatible Python version found ");
        }
    }

    private static String gaussDbExecutionCheck(List<String> command, boolean needRedirectStdout) throws MigrationServiceException {
        String result = null;
        StringBuffer stdOutBuffer = null;
        try {
            ProcessBuilder pb = null;
            if (CommandInjectionChecker.isExistsCommandInjection((String)command.toString())) {
                throw new MigrationServiceException("[DSC_ERR_005_002] " + MessageLoader.getMessage("DSC_ERR_005_002"));
            }
            pb = needRedirectStdout ? new ProcessBuilder("Command_execution").redirectError(ProcessBuilder.Redirect.INHERIT).redirectOutput(ProcessBuilder.Redirect.INHERIT).command(command) : new ProcessBuilder("Command_execution").redirectErrorStream(true).command(command);
            Process proc = pb.start();
            if (!needRedirectStdout) {
                stdOutBuffer = new StringBuffer();
                GaussDBVerificationUtility.readBuffer(stdOutBuffer, proc);
            }
            proc.waitFor(2000L, TimeUnit.MILLISECONDS);
            if (!needRedirectStdout) {
                result = stdOutBuffer.toString();
            }
        }
        catch (InterruptedException e) {
            MigrationProcessor.interrupt();
            logger.error(e.getMessage());
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        return result;
    }

    private static void executeMigrationCommand(String targetDir, String gausspass, String targetDB, String logPath) throws MigrationServiceException {
        ArrayList<String> command = new ArrayList<String>();
        String homePath = new File(FilenameUtils.normalize((String)System.getProperty("config.dir"))).getParent();
        command.add("python3");
        command.add(homePath.concat(File.separator).concat("scripts").concat(File.separator).concat("verifyGaussPython").concat(File.separator).concat("src").concat(File.separator).concat("python").concat(File.separator).concat("verify.py"));
        command.add(homePath);
        command.add(targetDir);
        command.add(targetDB);
        command.add(logPath);
        if (preExecutionPath != null) {
            command.add(preExecutionPath);
        }
        GaussDBVerificationUtility.executeCmd(command, true, gausspass);
    }

    private static String executeCmd(List<String> command, boolean bRedirectStdout, String gausspass) throws MigrationServiceException {
        String result;
        block6: {
            result = null;
            StringBuffer stdOutBuffer = null;
            String commandStr = String.join((CharSequence)" ", command);
            try {
                if (!CommandInjectionChecker.isExistsCommandInjection((String)command.toString())) {
                    ProcessBuilder pb = null;
                    pb = bRedirectStdout ? new ProcessBuilder("Command_execution").redirectError(ProcessBuilder.Redirect.INHERIT).redirectOutput(ProcessBuilder.Redirect.INHERIT).command(command) : new ProcessBuilder("Command_execution").redirectErrorStream(true).command(command);
                    Map<String, String> env = pb.environment();
                    env.put("gaussdb-password", gausspass);
                    Process proc = pb.start();
                    if (!bRedirectStdout) {
                        stdOutBuffer = new StringBuffer();
                        GaussDBVerificationUtility.readBuffer(stdOutBuffer, proc);
                    }
                    proc.waitFor(QueryConversionUtility.getApplicationTimeout(), TimeUnit.HOURS);
                    if (!bRedirectStdout) {
                        result = stdOutBuffer.toString();
                    }
                    break block6;
                }
                throw new MigrationServiceException("[DSC_ERR_005_002] " + MessageLoader.getMessage("DSC_ERR_005_002") + " " + commandStr);
            }
            catch (InterruptedException e) {
                MigrationProcessor.interrupt();
                logger.error(e.getMessage());
                logger.error("[DSC_ERR_005_001] " + MessageLoader.getMessage("DSC_ERR_005_001") + " " + commandStr);
            }
            catch (IOException e) {
                logger.error(e.getMessage());
                logger.error("[DSC_ERR_005_001] " + MessageLoader.getMessage("DSC_ERR_005_001") + " " + commandStr);
            }
        }
        return result;
    }

    public static String getPassword(String prompt) {
        Console console = System.console();
        char[] password = console.readPassword(prompt, new Object[0]);
        return new String(password);
    }

    private static void readBuffer(StringBuffer stdOutBuffer, Process proc) throws IOException {
        try (InputStream is = proc.getInputStream();){
            int ulChar;
            int ulCharMax = 65535;
            while ((ulChar = is.read()) != -1) {
                if (ulChar == 10 || ulChar == 13 || ulChar > ulCharMax) continue;
                stdOutBuffer.append((char)ulChar);
            }
        }
    }

    public static void executeVerificationCmd(String targetDir, String migrationType, String dbType, boolean executevalue, String applicationlang, String gaussDbPass) {
        if (!"perl".equals(applicationlang) && executevalue) {
            String logPath = System.getProperty("LOGFILE_PATH");
            QueryConversionUtility.printConsoleMessage("********************** Verification Started ******************************" + System.lineSeparator());
            if (dbType.equals("gaussdbt")) {
                SqlStatementRangeGenerator.generateSqlStatementRanges(targetDir, migrationType);
            }
            GaussDBVerificationUtility.executeMigrationCommand(targetDir, gaussDbPass, dbType, logPath);
        }
    }
}

