/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.common.handlers;

import com.huawei.db.migration.common.handlers.CommentsHandler;
import com.huawei.db.migration.common.handlers.MigrationProcessor;
import com.huawei.db.migration.common.handlers.RunFileUtility;
import com.huawei.db.migration.exception.FileException;
import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.sqlformatter.GaussSQLQueryFormatter;
import com.huawei.db.migration.util.ApplicationProperty;
import com.huawei.db.migration.util.ApplicationPropertyLoader;
import com.huawei.db.migration.util.CommandInjectionChecker;
import com.huawei.db.migration.util.ErrorLoggerUtility;
import com.huawei.db.migration.util.FeatureLoader;
import com.huawei.db.migration.util.IGaussDBConstants;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.ProgressUtil;
import com.huawei.db.migration.util.PropertyConstants;
import com.huawei.db.migration.util.QueryConversionUtility;
import com.huawei.db.migration.util.SetFilePermission;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileHandler {
    private static final Logger logger = LogManager.getLogger(FileHandler.class);
    private static final Logger READLOGGER = LogManager.getLogger("readlogger");
    private static final Logger WRITELOGGER = LogManager.getLogger("writelogger");
    private static final long PROC_WAIT_TIME_OUT = 2000L;
    private static final int SIMLINK_DEPTH = 5;
    private int fileNo = 1;
    private Map<Integer, List<String>> commentMap = null;
    private Set<String> unsupportExt = new HashSet<String>();
    private Map<String, String> promptMap = null;
    private boolean commentFlag = false;
    private int unsupportedFileCount = 0;
    private String separatorPattern;
    private String lastComment;
    private String migrateTask;
    private boolean postProcessCheck;
    private boolean isInActivityCountBlock = false;
    private Queue<String> actCountParams = new LinkedList<String>();
    private boolean isInMIDotBlock = false;

    public Map<String, String> processSQLFiles(String srcFolder, Map<String, String> filesMap) {
        File folder;
        File[] files;
        String[] validExt = this.getValidFileExtension();
        Map<String, String> fileMap = filesMap;
        String src = FilenameUtils.normalize((String)srcFolder);
        if (src != null && (files = (folder = new File(src)).listFiles()) != null && files.length != 0) {
            for (File file : files) {
                this.updateMapWithFile(fileMap, file, validExt);
            }
        }
        return fileMap;
    }

    public String[] getValidFileExtension() {
        String ext = ApplicationPropertyLoader.getStringProperty("fileExtension");
        if ((ext = ext.replace(".", "")).matches("[a-zA-Z0-9-_,\\s]+")) {
            if (!ext.trim().isEmpty()) {
                return ext.split("\\s*,\\s*");
            }
        } else {
            logger.error("Invalid configurable file extensions, default to SQL");
        }
        return new String[]{"sql"};
    }

    private boolean isValidFile(String filename, String[] validExt) {
        for (String ext : validExt) {
            if (!filename.endsWith("." + ext)) continue;
            return true;
        }
        return false;
    }

    public void updateMapWithFile(Map<String, String> fileMap, File file, String[] validExt) {
        if (file.isDirectory()) {
            this.processSQLFiles(file.toString(), fileMap);
        } else if (file.isFile() && this.isValidFile(QueryConversionUtility.toLower(file.getName()), validExt)) {
            try {
                fileMap.put("File" + this.fileNo, file.getCanonicalPath());
            }
            catch (IOException e) {
                logger.error("Error occured while getting path of the file:" + file.toString());
            }
            ++this.fileNo;
        } else {
            ++this.unsupportedFileCount;
            String fileExt = "";
            try {
                if (!file.getCanonicalPath().endsWith(".pl")) {
                    int ext1;
                    String fileName = file.getCanonicalPath();
                    if (logger.isInfoEnabled()) {
                        logger.info(" File is not supported. " + fileName);
                    }
                    if ((ext1 = (fileExt = file.getName()).lastIndexOf(".")) != -1) {
                        fileExt = fileExt.substring(ext1, fileExt.length());
                        this.unsupportExt.add(fileExt);
                    }
                }
            }
            catch (IOException e) {
                logger.error("Error occured while getting unsupported Extension file path of the file:" + file.toString());
            }
        }
    }

    public List<String> readInputFile(String fileName, String targetFolder, String srcFolder, String migrationTask, boolean postProcessor) {
        this.separatorPattern = ".*?(;)\\s*\\/?";
        this.migrateTask = "query";
        if (migrationTask.equalsIgnoreCase("blogic")) {
            this.migrateTask = "blogic";
            this.separatorPattern = "(?i).*end\\s*(\\w+\\s*)?;\\s*(?:#s#\\d+#e#\\s*)*?\\/";
        }
        ArrayList<String> sqlList = new ArrayList(10);
        int iIndex = 1;
        long fileInitLstModifd = 0L;
        try {
            boolean runFileFlag;
            File file = new File(fileName);
            String encodingFormat = this.getEncodingFormat(file);
            fileInitLstModifd = file.lastModified();
            List lines = FileUtils.readLines((File)file, (String)encodingFormat);
            boolean replaceSlash = "/".equals(ApplicationPropertyLoader.getStringProperty("queryDelimiter")) && migrationTask.equalsIgnoreCase("bulk");
            String delimiter = this.getDelimiter(this.migrateTask, replaceSlash);
            StringBuffer sqlQuery = new StringBuffer(128);
            this.commentFlag = false;
            int jIndex = 1;
            int fileSize = lines.size();
            int line = 0;
            boolean bl = runFileFlag = FeatureLoader.getBooleanProperty("terdataUtilities") && "teradata".equalsIgnoreCase(ApplicationProperty.getStringProperty("SourceDB"));
            while (lines.size() > 0) {
                String trimCtLine = this.addAtToQry(lines, replaceSlash, runFileFlag, file.getPath());
                jIndex = this.doChkfileModified(fileInitLstModifd, file, jIndex, fileSize, line);
                iIndex = this.readInputFileComment(trimCtLine, sqlList, sqlQuery, delimiter, iIndex);
                line = this.takeProgress(line);
            }
            this.getActCountQueue(sqlQuery);
            this.replaceActivityCount(sqlQuery);
            sqlQuery = this.qryWithComments(sqlList, sqlQuery, this.migrateTask, iIndex);
            this.lastComment = this.getLastCmnt(sqlList, sqlQuery);
            sqlList = this.doGetSqlLstWOCmnts(fileName, targetFolder, srcFolder, sqlList, postProcessor);
            this.updQryAndLog(fileName, migrationTask, sqlList, sqlQuery);
        }
        catch (RuntimeException e) {
            sqlList = this.runtimeExc(fileName, e);
        }
        catch (FileNotFoundException e) {
            sqlList = this.fileNotFoundExc(fileName, e);
        }
        catch (IOException e) {
            sqlList = this.ioExc(fileName, e);
        }
        return sqlList;
    }

    private void replaceActivityCount(StringBuffer sqlQuery) {
        Pattern actPattern = Pattern.compile("###ACTIVITY_COUNT###(\\w+)###");
        Matcher actMatcher = actPattern.matcher(sqlQuery.toString());
        int startIdx = -1;
        int endIdx = -1;
        StringBuffer setQuery = new StringBuffer(64);
        int nullVarCnt = 1;
        String varName = null;
        while (actMatcher.find()) {
            String s1 = actMatcher.group();
            startIdx = actMatcher.start();
            endIdx = actMatcher.end();
            varName = this.actCountParams.poll();
            if (varName == null) {
                varName = "ACTIVITYCOUNT" + Integer.toString(nullVarCnt);
                ++nullVarCnt;
            }
            setQuery.append("SELECT ${ROW_COUNT} AS " + varName + ";");
            sqlQuery.replace(startIdx, endIdx, setQuery.toString());
            String actMarkStr = actMatcher.group(1);
            if (actMarkStr.equals("DELETE")) {
                this.addTransBlockQuery(sqlQuery, true, startIdx);
            } else if (actMarkStr.equals("INSERT")) {
                this.addTransBlockQuery(sqlQuery, false, startIdx + 1 + setQuery.length());
            }
            setQuery.delete(0, setQuery.length());
            actMatcher = actPattern.matcher(sqlQuery.toString());
        }
    }

    private void addTransBlockQuery(StringBuffer sqlQueryBuffer, boolean forwardSearch, int position) {
        int startIdx = 0;
        int endIdx = 0;
        String sqlQuery = sqlQueryBuffer.toString();
        if (forwardSearch) {
            endIdx = sqlQuery.lastIndexOf(59, position);
            endIdx = sqlQuery.lastIndexOf(59, endIdx - 1);
            startIdx = sqlQuery.lastIndexOf(59, endIdx - 1);
            String prepQuery = sqlQuery.substring(startIdx + 1, endIdx + 1);
            Pattern transBeginPattern = Pattern.compile("\\s*BT\\s*;\\s*");
            Matcher transBeginMatcher = transBeginPattern.matcher(prepQuery);
            if (endIdx < 0) {
                sqlQueryBuffer.insert(endIdx + 1, "BT; " + IGaussDBConstants.NEW_LINE);
            } else if (!transBeginMatcher.find()) {
                sqlQueryBuffer.insert(endIdx + 1 + IGaussDBConstants.NEW_LINE.length(), "BT; " + IGaussDBConstants.NEW_LINE);
            }
        } else {
            startIdx = position + 1;
            endIdx = sqlQuery.indexOf(59, startIdx);
            String suffQuery = sqlQuery.substring(startIdx, endIdx + 1);
            Pattern transEndPattern = Pattern.compile("\\s*ET\\s*;\\s*");
            Matcher transEndMatcher = transEndPattern.matcher(suffQuery);
            if (!transEndMatcher.find()) {
                sqlQueryBuffer.insert(startIdx, "ET; " + IGaussDBConstants.NEW_LINE);
            }
        }
    }

    private void getActCountQueue(StringBuffer sqlQuery) {
        Pattern actCountPattern = Pattern.compile("(?i)(?:DeleteRows|InsertRows|UpdateRows)\\s*=\\s*(?:.*)\\s*+\\s*\\$\\{?(ACTIVITYCOUNT\\d+)}?\\s*,?");
        Matcher actCountMatcher = actCountPattern.matcher(sqlQuery.toString());
        while (actCountMatcher.find()) {
            String actCountName = actCountMatcher.group(1);
            this.actCountParams.offer(actCountName);
        }
        this.updateVarsWithoutBraces(sqlQuery, "\\$(ACTIVITYCOUNT\\d+)");
    }

    private void updateVarsWithoutBraces(StringBuffer query, String varRegex) {
        Pattern varRegexPattern = Pattern.compile(varRegex);
        Matcher varRegexMatcher = varRegexPattern.matcher(query.toString());
        int startIdx = -1;
        int endIdx = -1;
        while (varRegexMatcher.find()) {
            String varName = varRegexMatcher.group(1);
            startIdx = varRegexMatcher.start(1);
            endIdx = varRegexMatcher.end(1);
            query.replace(startIdx, endIdx, "{" + varName + "}");
            varRegexMatcher = varRegexPattern.matcher(query.toString());
        }
    }

    private String getDelimiter(String migrateTask, boolean replaceSlash) {
        String delimiter = ApplicationPropertyLoader.getStringProperty(migrateTask + "Delimiter");
        if (replaceSlash) {
            delimiter = ";";
        }
        return delimiter;
    }

    private void updQryAndLog(String fileName, String migrationTask, List<String> sqlList, StringBuffer sqlQuery) {
        this.updateQueryCount(migrationTask, sqlList);
        READLOGGER.info("{} is read successfully.", (Object)fileName);
        sqlQuery.setLength(0);
    }

    private int takeProgress(int lineNo) {
        int line = lineNo;
        if (++line % 100 == 0) {
            ProgressUtil.printProgress();
        }
        return line;
    }

    private List<String> ioExc(String fileName, IOException e) {
        logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " IOException occurred. [DSC_ERR_004_044] " + MessageLoader.getMessage("DSC_ERR_004_044") + " " + fileName);
        List<String> sqlList = null;
        return sqlList;
    }

    private List<String> fileNotFoundExc(String fileName, FileNotFoundException e) {
        logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " FileNotFoundException occurred. [DSC_ERR_004_044] " + MessageLoader.getMessage("DSC_ERR_004_044") + " " + fileName);
        List<String> sqlList = null;
        return sqlList;
    }

    private List<String> runtimeExc(String fileName, RuntimeException e) {
        logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " Runtime exception occurred. [DSC_ERR_004_044] " + MessageLoader.getMessage("DSC_ERR_004_044") + " " + fileName);
        List<String> sqlList = null;
        return sqlList;
    }

    public String addAtToQry(List<String> lines, boolean replaceSlash, boolean runFileFlag, String filePath) {
        String trimCtLine = lines.remove(0);
        if (runFileFlag && trimCtLine.matches("(?i).*(\\.RUN\\s+FILE\\s*(=?)\\s*(.*?\\.D?SQL)).*")) {
            RunFileUtility runUtility = new RunFileUtility();
            trimCtLine = runUtility.getDsqlScriptFile(trimCtLine, lines, filePath);
        }
        if (trimCtLine.matches("(?i)(?<!\\w)(?:^\\$\\s*\\{.\\w+?\\})(?!\\w|\\.)")) {
            trimCtLine = "@@" + trimCtLine + "@@";
        }
        trimCtLine = trimCtLine.trim();
        if (replaceSlash && "/".equals(trimCtLine)) {
            trimCtLine = ";";
        }
        return trimCtLine;
    }

    public StringBuffer qryWithComments(List<String> sqlList, StringBuffer sb, String migrateTask, int iIndex) {
        String query;
        StringBuffer sqlQuery = sb;
        if (iIndex == 1 && !(query = sqlQuery.toString()).isEmpty()) {
            sqlList.add(query);
            return new StringBuffer(128);
        }
        return sqlQuery;
    }

    private void updateQueryCount(String migrationTask, List<String> sqlList) {
        if (!migrationTask.equalsIgnoreCase("blogic")) {
            int count = sqlList.size();
            for (int k = 0; k < count; ++k) {
                ErrorLoggerUtility.updateQryCnt();
            }
        }
    }

    public String getEncodingFormat(File file) {
        String encodingFormat = this.getEncodingFormat();
        if (encodingFormat.isEmpty()) {
            encodingFormat = this.getEncodingFormat(file.getPath());
            logger.info("File {} will be read with charset : {}", (Object)file.getPath(), (Object)encodingFormat);
        }
        return encodingFormat;
    }

    private int readInputFileComment(String trimCtLine, List<String> sqlList, StringBuffer sqlQuery, String delimiter, int cnt) {
        boolean tCondition;
        int count = cnt;
        String trimCounttLine = trimCtLine;
        String commentQuery = "";
        String queryWOComment = trimCtLine;
        Pattern pattern = Pattern.compile("(--.*)");
        Matcher matcher = pattern.matcher(trimCtLine);
        if (matcher.find()) {
            commentQuery = matcher.group(1);
            queryWOComment = trimCtLine.substring(0, matcher.start()).trim();
        }
        if (!trimCtLine.isEmpty()) {
            if (ApplicationPropertyLoader.getBooleanProperty("commentSeparatorFlag")) {
                trimCounttLine = this.getSqlQry(sqlQuery, trimCtLine);
                this.commentFlag = this.getCommentFlag(trimCounttLine);
            } else {
                sqlQuery.append(trimCounttLine).append(" ");
            }
        }
        trimCounttLine = QueryConversionUtility.canonicalizeString(trimCounttLine);
        boolean fCondition = !this.commentFlag;
        boolean sCondition = trimCounttLine.matches(this.separatorPattern) && !commentQuery.trim().endsWith(delimiter);
        boolean bl = tCondition = queryWOComment.trim().endsWith(delimiter) && !queryWOComment.trim().endsWith("*/");
        if (fCondition && (sCondition || tCondition)) {
            String query = sqlQuery.toString();
            if (queryWOComment.trim().endsWith(delimiter) && query.matches(this.separatorPattern)) {
                sqlList.add(query);
                sqlQuery.setLength(0);
                ++count;
            }
        }
        return count;
    }

    private int doChkfileModified(long fileInitLstModifd, File file, int count, int fileSize, int index) throws MigrationServiceException {
        int cnt = count;
        if (index == 100 * cnt || index == fileSize - 1) {
            long fileLinesLstModifd = file.lastModified();
            if (fileInitLstModifd != fileLinesLstModifd) {
                throw new MigrationServiceException("[DSC_ERR_004_019] " + MessageLoader.getMessage("DSC_ERR_004_019"));
            }
            ++cnt;
        }
        return cnt;
    }

    private List<String> doGetSqlLstWOCmnts(String fileName, String targetFolder, String srcFolder, List<String> sqlList, boolean postProcessor) throws MigrationServiceException, FileException {
        String lastCommentQry = this.lastComment;
        this.postProcessCheck = postProcessor;
        List<String> sqlListWOCmnts = new ArrayList<String>(10);
        this.commentMap = new LinkedHashMap<Integer, List<String>>(10);
        CommentsHandler commentHandle = new CommentsHandler();
        commentHandle.setCommentMap(this.commentMap);
        if (ApplicationPropertyLoader.getBooleanProperty("commentSeparatorFlag")) {
            lastCommentQry = this.addSqlIntoFormatSrcdir(fileName, targetFolder, srcFolder, lastCommentQry, sqlList);
            sqlListWOCmnts = commentHandle.readWithComments(sqlList, lastCommentQry, this.migrateTask);
            this.commentMap = commentHandle.getCommentMap();
            this.promptMap = commentHandle.getPromptMap();
        } else {
            sqlListWOCmnts.addAll(sqlList);
        }
        sqlList.clear();
        return sqlListWOCmnts;
    }

    private String addSqlIntoFormatSrcdir(String fileName, String targetFolder, String srcFolder, String lastComment, List<String> formattedSqlList) throws MigrationServiceException, FileException {
        String lastCommentQry = lastComment;
        String defaultFormatSource = "true";
        if ("false".equalsIgnoreCase(ApplicationPropertyLoader.getStringProperty("formattedSourceRequired"))) {
            defaultFormatSource = "false";
        }
        if ("true".equalsIgnoreCase(defaultFormatSource) && !this.postProcessCheck) {
            this.formatInputFile(fileName, formattedSqlList, targetFolder, srcFolder);
        }
        if ((lastCommentQry = QueryConversionUtility.canonicalizeString(lastCommentQry)) != null && lastCommentQry.startsWith("/") && !lastCommentQry.startsWith("/*")) {
            lastCommentQry = lastCommentQry.substring(1);
        }
        return lastCommentQry;
    }

    private String getSqlQry(StringBuffer sqlQuery, String trimCtLn) {
        StringBuffer trimCtLine = new StringBuffer(trimCtLn);
        this.addEndMarkForBteqQuery(trimCtLine);
        Pattern semicLinePattern = Pattern.compile("(?i)^(;)(INSERT|DELETE|UPDATE)");
        Matcher semicLineMatcher = semicLinePattern.matcher(trimCtLine);
        if (semicLineMatcher.find()) {
            int idxAfterSemic = semicLineMatcher.end(1);
            trimCtLine = trimCtLine.insert(idxAfterSemic, IGaussDBConstants.NEW_LINE);
            int newLineLen = IGaussDBConstants.NEW_LINE.length();
            if (semicLineMatcher.group(2) != null) {
                this.isInActivityCountBlock = true;
                trimCtLine = trimCtLine.insert(idxAfterSemic + newLineLen, "###ACTIVITY_COUNT###DELETE###" + IGaussDBConstants.NEW_LINE);
            }
        } else if (this.isInActivityCountBlock && trimCtLine.toString().contains(";")) {
            int endIdx = trimCtLine.toString().indexOf(";");
            trimCtLine = trimCtLine.insert(endIdx + 1, IGaussDBConstants.NEW_LINE + "###ACTIVITY_COUNT###INSERT###");
            this.isInActivityCountBlock = false;
        }
        sqlQuery.append(trimCtLine).append(IGaussDBConstants.NEW_LINE);
        return trimCtLine.toString();
    }

    private void addEndMarkForBteqQuery(StringBuffer trimCtLine) {
        Pattern siDotCmdPattern;
        Matcher siDotCmdMatcher;
        Pattern miDotCmdPattern = Pattern.compile("(?i)(\\.\\.(?<!\\w)IF(?!\\w+)\\s+(\\w+)\\s*(<>|!=|=|>|<|>=|<=)\\s*'?(\\w+|\\d+)'?\\s+(THEN))|(\\.\\.(?<!\\w)(ELSE|END-IF|ENDIF|END-FOR|DO|END)(?!\\w);?)|(^(?<!\\.)\\.(?<!\\w)(END-IF|ENDIF)(?!\\w);?)");
        Matcher miDotCmdMatcher = miDotCmdPattern.matcher(trimCtLine);
        if (miDotCmdMatcher.find() && !miDotCmdMatcher.group().endsWith(";")) {
            trimCtLine.insert(miDotCmdMatcher.end(), ";");
        }
        if ((siDotCmdMatcher = (siDotCmdPattern = Pattern.compile("(?i)^((?<!\\.)\\.(?<!\\w)(IF)(?!\\w+)\\s+(\\w+)\\s*(<>|!=|=|>|<|>=|<=)\\s*(\\w+|\\d+)\\s+(THEN)\\s+\\.(QUIT|GOTO|EXIT-FOR)\\s*(\\w+|\\d+)?)\\s*;?|(\\.(?<!\\w)(GOTO|QUIT|RETURN|LABEL)(?!\\w+)\\s*(\\w*|\\d*)\\s*)\\s*;?|(\\.(?<!\\w)(RUN\\s+FILE|EXTRACT\\s+FILE)(?!\\w+)\\s*=\\s*'?(.*(?!\\s))'?\\s*;?)|(\\.(?<!\\w)(?:SET)(?!\\w)\\s+'?(\\w+)'?\\s+'?(\\$\\{\\w+\\})'?;?)")).matcher(trimCtLine.toString())).find()) {
            if (!this.isInMIDotBlock) {
                if (!siDotCmdMatcher.group().endsWith(";")) {
                    trimCtLine.insert(siDotCmdMatcher.end(), ";");
                }
            } else if (siDotCmdMatcher.group().endsWith(";")) {
                trimCtLine.replace(siDotCmdMatcher.end(), siDotCmdMatcher.end() + 1, "###MIEND###");
            } else {
                trimCtLine.insert(siDotCmdMatcher.end(), "###MIEND###");
            }
        }
    }

    private boolean getCommentFlag(String trimCtLine) {
        String trimCountLine = trimCtLine;
        if ((trimCountLine = QueryConversionUtility.canonicalizeString(trimCountLine)).contains("/*") && !trimCountLine.contains("*/")) {
            this.commentFlag = true;
        }
        if (this.commentFlag && trimCountLine.contains("*/")) {
            this.commentFlag = false;
        }
        return this.commentFlag;
    }

    private String getLastCmnt(List<String> sqlList, StringBuffer sqlQuery) {
        this.lastComment = null;
        if (!sqlQuery.toString().isEmpty()) {
            this.lastComment = sqlQuery.toString().trim();
            this.lastComment = QueryConversionUtility.canonicalizeString(this.lastComment);
            if (this.lastComment.contains(";")) {
                sqlList.add(this.lastComment);
                this.lastComment = null;
            }
        }
        return this.lastComment;
    }

    private String getEncodingFormat() {
        String encodingFormat = null;
        encodingFormat = ApplicationPropertyLoader.getStringProperty("encodingFormat");
        if (!encodingFormat.isEmpty()) {
            logger.info("Files encoding is set from configuration in Application properties file : {}", (Object)encodingFormat);
        }
        return encodingFormat;
    }

    private String getEncodingFormat(String filePath) {
        String encodingFormat;
        block16: {
            encodingFormat = null;
            try {
                if (!CommandInjectionChecker.isExistsCommandInjection((String)filePath)) {
                    ProcessBuilder pb = this.getProcessBuilder(filePath);
                    Process proc = pb.start();
                    StringBuffer stdOutBuffer = new StringBuffer(128);
                    try (InputStream is = proc.getInputStream();){
                        int cData;
                        int charMaxVal = 65535;
                        while ((cData = is.read()) != -1) {
                            if (cData == 10 || cData == 13 || cData > charMaxVal) continue;
                            stdOutBuffer.append((char)cData);
                        }
                    }
                    boolean retStatus = proc.waitFor(2000L, TimeUnit.MILLISECONDS);
                    if (!retStatus) {
                        QueryConversionUtility.printConsoleMessage("Error while waiting for other threads to complete.");
                    }
                    String stdOutput = stdOutBuffer.toString();
                    stdOutBuffer.setLength(0);
                    logger.info("guessencoding command output = {} , for file= {}", (Object)stdOutput, (Object)filePath);
                    if (stdOutput.contains("=")) {
                        String[] encFormatArray = stdOutput.split("=");
                        String string = encodingFormat = encFormatArray.length > 1 ? encFormatArray[1] : "unknown";
                        if (QueryConversionUtility.toLower(encodingFormat).startsWith("unknown") || encodingFormat.equalsIgnoreCase("binary")) {
                            encodingFormat = Charset.defaultCharset().toString();
                            logger.info("Unable to detect charset for {}", (Object)filePath);
                        }
                    }
                    break block16;
                }
                logger.error("Unable to detect charset for {}, due to possibility of command injection", (Object)filePath);
            }
            catch (InterruptedException ex) {
                MigrationProcessor.interrupt();
                logger.error(ErrorLoggerUtility.getExceptionDetails(ex) + " Unable to detect charset for " + filePath + ". Hence setting default charset " + Charset.defaultCharset() + ".");
            }
            catch (IOException ex) {
                logger.error(ErrorLoggerUtility.getExceptionDetails(ex) + " Unable to detect charset for " + filePath + ". Hence setting default charset " + Charset.defaultCharset() + ".");
            }
        }
        if (encodingFormat == null) {
            logger.info("couldn't get the encoding format, so using the default charset for {}", (Object)filePath);
            encodingFormat = Charset.defaultCharset().toString();
        }
        return encodingFormat;
    }

    private ProcessBuilder getProcessBuilder(String filePath) {
        ProcessBuilder pb;
        if (QueryConversionUtility.containsCheck(System.getProperty("os.name"), "windows")) {
            File currentJarFilePath = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath());
            String toolHome = currentJarFilePath.getParent();
            if (toolHome == null) {
                toolHome = "";
            }
            pb = new ProcessBuilder("file_header_reader").redirectErrorStream(true).command("java", "-jar", toolHome.concat(File.separator).concat("dsctool.jar"), "guessencoding", "-F", filePath);
        } else {
            pb = new ProcessBuilder("file_header_reader").redirectErrorStream(true).command("file", "-pi", filePath);
        }
        return pb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeOutputFile(String targetFileAbsPath, List<String> outputQueries, String tgtFolder, boolean isOutPutQuery, String srcfolder) {
        BufferedWriter writer = null;
        File targetFile = null;
        File file = new File(targetFileAbsPath.replace("dsql", "gsql"));
        String[] folder = new String[]{};
        ArrayList<String> dir = new ArrayList<String>(10);
        FileOutputStream fout = null;
        SetFilePermission filePer = new SetFilePermission();
        try {
            targetFile = this.createTargetFolderStructure(targetFileAbsPath, tgtFolder, srcfolder, file.getName(), folder, dir, isOutPutQuery);
            String encodingFormat = this.getFileCreate(targetFile, file, filePer);
            if (targetFile.exists() && targetFile.canWrite()) {
                fout = new FileOutputStream(targetFile);
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fout, encodingFormat));
                String query = this.getFormattedQuery(outputQueries, isOutPutQuery);
                this.getWriteInfo(isOutPutQuery, writer, targetFile, query);
            } else {
                this.logError(targetFile);
            }
        }
        catch (FileException e) {
            logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " File exception occurred. [DSC_ERR_004_043] " + MessageLoader.getMessage("DSC_ERR_004_043") + " " + file.getName());
        }
        catch (RuntimeException e) {
            logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " Runtime exception occurred. [DSC_ERR_004_043] " + MessageLoader.getMessage("DSC_ERR_004_043") + " " + file.getName());
        }
        catch (UnsupportedEncodingException e) {
            logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " UnsupportedEncodingException occurred. [DSC_ERR_004_043] " + MessageLoader.getMessage("DSC_ERR_004_043") + " " + file.getName());
        }
        catch (FileNotFoundException e) {
            logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " FileNotFoundException occurred. [DSC_ERR_004_043] " + MessageLoader.getMessage("DSC_ERR_004_043") + " " + file.getName());
        }
        catch (IOException e) {
            logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " IOException occurred. [DSC_ERR_004_043] " + MessageLoader.getMessage("DSC_ERR_004_043") + " " + file.getName());
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
                if (fout != null) {
                    fout.close();
                }
            }
            catch (IOException e) {
                logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " IOException occurred. [DSC_ERR_004_043] " + MessageLoader.getMessage("DSC_ERR_004_043") + " " + file.getName());
            }
        }
    }

    private String getFileCreate(File targetFile, File file, SetFilePermission filePer) {
        String encodingFormat;
        boolean isFileCreated = false;
        logger.debug("Target File Name: {}", (Object)targetFile);
        isFileCreated = QueryConversionUtility.containsCheck(System.getProperty("os.name"), "win") ? filePer.createFileWithPermissionInWin(targetFile.getPath()) : filePer.createFileWithPermissionInLinux(targetFile.getPath());
        if (!isFileCreated && targetFile.exists()) {
            logger.info("{} - File already exists/Failed to create target file", (Object)targetFile);
        }
        if ((encodingFormat = this.getEncodingFormat()).isEmpty()) {
            encodingFormat = this.getEncodingFormat(file.getPath());
            logger.info("File {} will be written with charset : {}", (Object)file.getPath(), (Object)encodingFormat);
        }
        return encodingFormat;
    }

    private void getWriteInfo(boolean isOutPutQuery, BufferedWriter writer, File targetFile, String query) throws IOException {
        writer.write(query);
        writer.newLine();
        if (isOutPutQuery) {
            WRITELOGGER.info("{} has written successfully.", (Object)targetFile.toString());
        }
    }

    private void logError(File targetFile) {
        logger.error("[DSC_ERR_004_001] " + MessageLoader.getMessage("DSC_ERR_004_001") + " " + targetFile);
        throw new MigrationServiceException("[DSC_ERR_004_001] " + MessageLoader.getMessage("DSC_ERR_004_001") + " " + targetFile);
    }

    private String getFormattedQuery(List<String> outputQueries, boolean isOutPutQuery) {
        int queryCount = 1;
        String query = null;
        if (isOutPutQuery) {
            StringBuffer outBuff = this.getOutBuffer(isOutPutQuery, outputQueries, queryCount);
            query = outBuff.toString();
            outBuff.setLength(0);
        } else {
            query = String.join((CharSequence)"", outputQueries);
            if (ApplicationPropertyLoader.getBooleanProperty("formatterrequired")) {
                query = GaussSQLQueryFormatter.format(query, isOutPutQuery);
            }
        }
        return query;
    }

    private StringBuffer getOutBuffer(boolean isOutPutQuery, List<String> outputQueries, int queryCount) {
        String outputQuery = null;
        StringBuffer outBuff = new StringBuffer(128);
        for (int iIndex = 0; iIndex < outputQueries.size(); ++iIndex) {
            String newline;
            outputQuery = outputQueries.get(iIndex);
            if (outputQuery.isEmpty()) continue;
            int index = outputQueries.size() - 2;
            String string = newline = !outputQuery.endsWith(IGaussDBConstants.NEW_LINE) && iIndex <= index ? IGaussDBConstants.NEW_LINE : "";
            if (isOutPutQuery && ApplicationPropertyLoader.getBooleanProperty("formatterrequired")) {
                outputQuery = this.doRetrieveCmntsBackInScript(queryCount, outputQuery, isOutPutQuery);
            }
            if (isOutPutQuery) {
                outputQuery = this.doRplPromptMap(outputQuery, this.promptMap);
            }
            outBuff.append(outputQuery).append(newline);
            if (iIndex % 100 != 0) continue;
            ProgressUtil.printProgress();
        }
        return outBuff;
    }

    private String doRetrieveCmntsBackInScript(int queryCount, String outputQuery, boolean isOutPutQuery) {
        String outQry = outputQuery;
        List<String> commentList = null;
        if (outQry.trim().isEmpty()) {
            commentList = this.commentMap.get(queryCount);
            outQry = CommentsHandler.commentAdder(commentList, outQry);
        } else {
            commentList = this.commentMap.get(queryCount);
            outQry = commentList != null ? CommentsHandler.commentAdder(commentList, outQry) : outQry;
            outQry = GaussSQLQueryFormatter.format(outQry, isOutPutQuery);
            Pattern pattern = Pattern.compile(PropertyConstants.GAUSS_SQL_STMT);
            Matcher matcher = pattern.matcher(outQry);
            if (matcher.find()) {
                String expectedVariableStr = matcher.group(1);
                String replacedString = expectedVariableStr.replaceAll("(?is)(\\$.*?\\s+)|(\\$\\{.*?\\}\\s+)", "$1" + IGaussDBConstants.NEW_LINE);
                outQry = outQry.replace(expectedVariableStr, replacedString);
            }
        }
        return outQry;
    }

    private File createTargetFolderStructure(String tgtAbsolutePath, String targetFldr, String srcfolder, String fileName, String[] fldr, List<String> dir, boolean isOutPutQuery) throws MigrationServiceException, FileException {
        String targetFileAbsPath = tgtAbsolutePath;
        String[] folder = fldr;
        String tgtFolder = targetFldr;
        SetFilePermission filePer = new SetFilePermission();
        boolean isFolCreated = false;
        if (isOutPutQuery) {
            tgtFolder = this.getTgtFldr(tgtFolder, filePer, isFolCreated);
        }
        if (targetFileAbsPath.trim().contains(srcfolder.trim())) {
            folder = this.getFolder(srcfolder, targetFileAbsPath);
        }
        this.getOutputDir(dir, folder);
        targetFileAbsPath = fileName;
        int dircnt = 0;
        int dirLength = dir.size();
        boolean newFolCreated = false;
        StringBuffer target = new StringBuffer(tgtFolder);
        File newFolder = null;
        for (int kIndex = 0; kIndex < dirLength; ++kIndex) {
            target.append("/").append(dir.get(kIndex));
            newFolder = new File(target.toString());
            try {
                newFolCreated = QueryConversionUtility.containsCheck(System.getProperty("os.name"), "win") ? filePer.createFolderWithPermissionInWin(newFolder.getCanonicalPath(), false) : filePer.createFolderWithPermissionInLinux(newFolder.getCanonicalPath(), false);
            }
            catch (IOException e) {
                logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " Error occurred while getting path of the file:" + newFolder.toString());
            }
            if (newFolCreated) {
                if (++dircnt != dir.size()) continue;
                break;
            }
            logger.info("Folder already exists / Error occurred while creating File at filepath : {}", (Object)target.toString());
        }
        target.append("/").append(targetFileAbsPath);
        File targetFile = new File(target.toString());
        return targetFile;
    }

    private String[] getFolder(String srcfolder, String targetFileAbsPath) {
        int index = targetFileAbsPath.lastIndexOf(srcfolder.trim());
        int length = srcfolder.trim().length();
        String sub = targetFileAbsPath.substring(index + length);
        String[] folder = sub.split("\\\\|/");
        return folder;
    }

    private String getTgtFldr(String targetFldr, SetFilePermission filePer, boolean isFolder) {
        boolean isFolCreated = isFolder;
        String tgtFolder = targetFldr;
        File targetFolder = new File(tgtFolder + "/" + "output");
        try {
            isFolCreated = QueryConversionUtility.containsCheck(System.getProperty("os.name"), "win") ? filePer.createFolderWithPermissionInWin(targetFolder.getCanonicalPath(), false) : filePer.createFolderWithPermissionInLinux(targetFolder.getCanonicalPath(), false);
        }
        catch (IOException e) {
            logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " Error occurred while getting path of the file:" + targetFolder.toString());
        }
        if (isFolCreated) {
            logger.debug("Target Folder has been created: {}", (Object)tgtFolder);
        }
        tgtFolder = targetFolder.toString();
        return tgtFolder;
    }

    private void getOutputDir(List<String> dir, String[] folder) {
        String[] validExt = this.getValidFileExtension();
        for (int iIndex = 0; iIndex < folder.length; ++iIndex) {
            if (folder[iIndex].isEmpty() || this.isValidFile(QueryConversionUtility.toLower(folder[iIndex]), validExt)) continue;
            dir.add(folder[iIndex]);
        }
    }

    public void formatInputFile(String targetFileAbsPath, List<String> outputQueries, String targetFolder, String srcfolder) throws MigrationServiceException, FileException {
        block5: {
            SetFilePermission filePer = new SetFilePermission();
            File targetFile = new File(targetFolder + "/" + "formattedSource");
            if (FileHandler.isInSecureDir(Paths.get(targetFolder, new String[0]))) {
                try {
                    boolean isFolCreated = false;
                    isFolCreated = QueryConversionUtility.containsCheck(System.getProperty("os.name"), "win") ? filePer.createFolderWithPermissionInWin(targetFile.getCanonicalPath(), false) : filePer.createFolderWithPermissionInLinux(targetFile.getCanonicalPath(), false);
                    if (isFolCreated) {
                        logger.debug("Formatted Dir Creation is Successful");
                        this.writeOutputFile(targetFileAbsPath, outputQueries, targetFile.getCanonicalPath(), false, srcfolder);
                        break block5;
                    }
                    logger.debug("Formatted Dir Already Exists");
                    this.writeOutputFile(targetFileAbsPath, outputQueries, targetFile.getCanonicalPath(), false, srcfolder);
                }
                catch (IOException e) {
                    logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " Error occurred while getting path of the file:" + targetFile.toString());
                }
            } else {
                throw new MigrationServiceException("[DSC_ERR_004_022] " + MessageLoader.getMessage("DSC_ERR_004_022") + " " + targetFolder);
            }
        }
    }

    public static boolean isInSecureDir(Path file) {
        return FileHandler.isInSecureDir(file, null);
    }

    private static boolean isInSecureDir(Path file, UserPrincipal userName) {
        return FileHandler.isInSecureDir(file, userName, 5);
    }

    private static boolean isInSecureDir(Path dest, UserPrincipal usrNme, int symlinkDepth) {
        UserPrincipal userName = usrNme;
        Path file = dest;
        if (file == null) {
            return false;
        }
        try {
            file = FileHandler.getFileAbsPath(file);
        }
        catch (SecurityException s) {
            logger.error(ErrorLoggerUtility.getExceptionDetails(s) + " Security Error occurred while reading the file path. ");
            return false;
        }
        if (symlinkDepth <= 0 || file == null) {
            return false;
        }
        UserPrincipal[] result = FileHandler.parseFilePath(null, file, userName);
        userName = result[0];
        UserPrincipal root = result[1];
        if (userName == null && root == null) {
            return false;
        }
        return FileHandler.parseParentPath(root, file, userName, symlinkDepth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static UserPrincipal[] parseFilePath(UserPrincipal rootQry, Path file, UserPrincipal usrNme) {
        UserPrincipal[] userPrincipalArray;
        UserPrincipal userName = usrNme;
        UserPrincipal root = rootQry;
        FileSystem fileSystem = null;
        try {
            Path path = file.getRoot();
            if (path != null) {
                UserPrincipalLookupService upls;
                fileSystem = Paths.get(path.toString(), new String[0]).getFileSystem();
                if (fileSystem != null && (upls = fileSystem.getUserPrincipalLookupService()) != null) {
                    root = !QueryConversionUtility.containsCheck(System.getProperty("os.name"), "win") ? upls.lookupPrincipalByName("root") : upls.lookupPrincipalByName("Administrators");
                    if (userName == null) {
                        userName = upls.lookupPrincipalByName(System.getProperty("user.name"));
                        UserPrincipal[] userPrincipalArray2 = new UserPrincipal[]{userName, root};
                        return userPrincipalArray2;
                    }
                }
                if (root == null || userName == null) {
                    userPrincipalArray = new UserPrincipal[]{null, null};
                    return userPrincipalArray;
                }
            }
        }
        catch (UnsupportedOperationException a) {
            logger.error(ErrorLoggerUtility.getExceptionDetails(a) + " Unsupported operation error occurred in parsing the file. ");
            userPrincipalArray = new UserPrincipal[]{null, null};
            return userPrincipalArray;
        }
        catch (IOException x) {
            logger.error(ErrorLoggerUtility.getExceptionDetails(x) + " IO Error occurred in parsing the file. ");
            userPrincipalArray = new UserPrincipal[]{null, null};
            return userPrincipalArray;
        }
        finally {
            try {
                if (fileSystem != null) {
                    fileSystem.close();
                }
            }
            catch (IOException | UnsupportedOperationException e) {
                logger.error("{} IO Error occurred in close the resource. ", (Object)ErrorLoggerUtility.getExceptionDetails(e));
            }
        }
        return new UserPrincipal[]{userName, root};
    }

    private static boolean parseParentPath(UserPrincipal root, Path file, UserPrincipal userName, int symlinkDepth) {
        Path partialPath = Paths.get(file.toString(), new String[0]);
        try {
            if (Files.isSymbolicLink(partialPath)) {
                if (!FileHandler.isInSecureDir(Files.readSymbolicLink(partialPath), userName, symlinkDepth - 1)) {
                    return false;
                }
            } else {
                PosixFileAttributes attr;
                Set<PosixFilePermission> perms;
                UserPrincipal owner = Files.getOwner(partialPath, new LinkOption[0]);
                if (userName != null && !userName.equals(owner) && root != null && !root.equals(owner)) {
                    logger.error("Output directory not owned by root/correct user ");
                    return false;
                }
                if (!QueryConversionUtility.containsCheck(System.getProperty("os.name"), "win") && (perms = (attr = Files.readAttributes(partialPath, PosixFileAttributes.class, new LinkOption[0])).permissions()) != null && (perms.contains((Object)PosixFilePermission.GROUP_WRITE) || perms.contains((Object)PosixFilePermission.OTHERS_WRITE))) {
                    return false;
                }
            }
        }
        catch (IOException x) {
            logger.error(ErrorLoggerUtility.getExceptionDetails(x) + " IO error in parsing the path. ");
            return false;
        }
        return true;
    }

    private static Path getFileAbsPath(Path dest) {
        Path file = dest;
        if (!file.isAbsolute()) {
            file = file.toAbsolutePath();
        }
        return file;
    }

    private String doRplPromptMap(String query, Map<String, String> proMap) {
        String output = query;
        if (proMap != null) {
            for (Map.Entry<String, String> globalTab : proMap.entrySet()) {
                String quotekey = globalTab.getKey();
                if (quotekey == null || !output.contains(quotekey)) continue;
                output = output.replace(quotekey, globalTab.getValue() + System.lineSeparator());
            }
        }
        return output;
    }

    public Set<String> getUnsupportedFileExtensionList() {
        return this.unsupportExt;
    }

    public int getUnsupportedCount() {
        return this.unsupportedFileCount;
    }
}

