/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.common.handlers;

import com.huawei.db.migration.bo.IMigrationInputBO;
import com.huawei.db.migration.common.handlers.FileHandler;
import com.huawei.db.migration.factory.MigrationAbstractFactory;
import com.huawei.db.migration.factory.MigrationFactoryProducer;
import com.huawei.db.migration.interfaces.IMigrationTaskService;
import com.huawei.db.migration.util.ErrorLoggerUtility;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.ProgressUtil;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MigrationProcessor
implements Runnable {
    private static final Logger logger = LogManager.getLogger(MigrationProcessor.class);
    private String fileName = null;
    private String srcFolder = null;
    private String targetFolder = null;
    private String migrationTask = null;
    private String sourceDb = null;
    private List<?> patterns = null;
    private List<?> splitterPatterns = null;
    private static final ThreadLocal<Boolean> INTERRUPTED = ThreadLocal.withInitial(() -> false);

    public MigrationProcessor(String fileName, IMigrationInputBO objInputData, int fileMapSize, List<?> patterns, List<?> splitterPatterns) {
        this.fileName = fileName;
        this.srcFolder = objInputData.getSourceFolderLoc();
        this.targetFolder = objInputData.getTargetFolderLoc();
        this.sourceDb = objInputData.getSourceDb();
        this.migrationTask = objInputData.getMigTaskName();
        this.patterns = patterns;
        this.splitterPatterns = splitterPatterns;
    }

    @Override
    public void run() {
        logger.info(MessageLoader.getMessage("fileInfo"), (Object)this.fileName, (Object)" ", (Object)MessageLoader.getMessage("startInfo"));
        List<String> inputStatements = null;
        List<String> outputList = null;
        FileHandler objFilehandler = new FileHandler();
        boolean postProcessor = false;
        boolean isOutOfMemoryError = false;
        boolean isInterruptedException = false;
        try {
            inputStatements = objFilehandler.readInputFile(this.fileName, this.targetFolder, this.srcFolder, this.migrationTask, postProcessor);
            if (inputStatements == null) {
                ErrorLoggerUtility.failedFileCnt(this.fileName);
            }
            if (inputStatements != null) {
                MigrationAbstractFactory objAbtFactory = MigrationFactoryProducer.getDataBaseFactory(this.sourceDb);
                IMigrationTaskService objMigTaskService = objAbtFactory.getMigrationTaskService(this.migrationTask);
                outputList = objMigTaskService.handleMigrationTask(inputStatements, this.fileName, this.patterns, this.splitterPatterns);
                objFilehandler.writeOutputFile(this.fileName, outputList, this.targetFolder, true, this.srcFolder);
            }
        }
        catch (RuntimeException re) {
            String errorStr = ErrorLoggerUtility.getExceptionDetails(re) + " Error occurred in DSC Processor";
            logger.error(errorStr);
            ErrorLoggerUtility.failedFileCnt(this.fileName);
        }
        catch (InterruptedException ie) {
            MigrationProcessor.interrupt();
            logger.error(ie.getMessage());
            ErrorLoggerUtility.failedFileCnt(this.fileName);
            isInterruptedException = true;
        }
        catch (OutOfMemoryError e) {
            QueryConversionUtility.printConsoleMessage("Less space available to run the tool. Please refer trouble shooting section in User manual and re-run the tool for remaining files.");
            logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " Less space available to run the tool. Please refer trouble shooting section in User manual and re-run the tool for remaining files.");
            isOutOfMemoryError = true;
        }
        if (!isInterruptedException) {
            ProgressUtil.incrementFileCount();
            if (!isOutOfMemoryError) {
                logger.info(MessageLoader.getMessage("fileInfo"), (Object)this.fileName, (Object)" ", (Object)MessageLoader.getMessage("successProcess"));
            }
        }
    }

    public static void interrupt() {
        INTERRUPTED.set(true);
    }

    public static Boolean isInterrupted() {
        return INTERRUPTED.get();
    }
}

