/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.common.handlers;

import com.huawei.db.migration.bo.IMigrationInputBO;
import com.huawei.db.migration.common.handlers.FileHandler;
import com.huawei.db.migration.services.TeradataMigrationService;
import com.huawei.db.migration.teradata.TeradataBteqHandler;
import com.huawei.db.migration.util.ApplicationProperty;
import com.huawei.db.migration.util.FeatureLoader;
import com.huawei.db.migration.util.IGaussDBConstants;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RunFileUtility {
    private static final Logger logger = LogManager.getLogger(RunFileUtility.class);
    private static final Pattern DSQL_VAR_PATTERN = Pattern.compile("(?i)'?(\\$\\s*(\\w+|\\{\\s*(\\w+)\\s*\\}))'?", 40);
    private static final Pattern CHECK_DSQL_VAR = Pattern.compile("(?i)(lv_mig_\\w+)\\s+", 40);
    private static final Pattern DECLARE_PAT = Pattern.compile("(?i)(?<!\\w)DECLARE\\s+", 40);
    private static final Pattern RUN_FILE_PAT = Pattern.compile("(?i)(\\.RUN\\s+FILE\\s*(=?)\\s*.*?\\.D?SQL)\\s*(;)?", 40);
    private static Map<String, String> runFileScriptPath = new ConcurrentHashMap<String, String>();

    public static void setRunFileProcMap(String runFileLine, String path) {
        runFileScriptPath.put(runFileLine, path);
    }

    public static Map<String, String> getRunFileScriptPath() {
        return runFileScriptPath;
    }

    public void submitParallelTaskForRunFileReplacement(Collection<String> runFileset, IMigrationInputBO objInputData, ExecutorService teradataExecutor, ArrayList<Future<?>> futureList, Collection<String> actualFiles) {
        if (runFileScriptPath.size() != 0) {
            Map<String, String> runFilePathMap = runFileScriptPath;
            for (Map.Entry<String, String> entry : runFilePathMap.entrySet()) {
                String val = entry.getValue();
                String key = entry.getKey();
                File folderLoc = new File(objInputData.getTargetFolderLoc());
                File folder = new File(folderLoc, "output");
                File runFileName = new File(val);
                File runFile = null;
                String checkSameDir = runFileName.getPath().replace(objInputData.getSourceFolderLoc(), "");
                checkSameDir = checkSameDir.replace(File.separator, "");
                if (!runFileName.getName().equals(checkSameDir.trim())) {
                    String absPath = runFileName.getPath();
                    folder = new File(folderLoc, "output");
                    absPath = absPath.replaceFirst("(?i)\\s*input\\s*", "Output");
                    absPath = absPath.replace(folderLoc.getPath(), folder.getPath());
                    runFile = new File(absPath.trim());
                } else {
                    runFile = new File(folder + File.separator + runFileName.getName());
                }
                FileHandler fileHandler = new FileHandler();
                String encodingFormat = fileHandler.getEncodingFormat(runFile);
                try {
                    List lines = FileUtils.readLines((File)runFile, (String)encodingFormat);
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < lines.size(); ++i) {
                        sb.append((String)lines.get(i)).append(IGaussDBConstants.NEW_LINE);
                    }
                    HashSet<String> lvList = new HashSet<String>();
                    String input = this.replaceAllDSQLVariable(sb.toString(), lvList);
                    input = this.getDsqlReplacementQuery(key, runFile, input, lvList);
                    File outFile = new File(runFile.getPath());
                    try (FileOutputStream outStream = new FileOutputStream(outFile);
                         OutputStreamWriter osw = new OutputStreamWriter((OutputStream)outStream, encodingFormat);
                         BufferedWriter writeBuffer = new BufferedWriter(osw);){
                        writeBuffer.write(input);
                        writeBuffer.newLine();
                        this.deleteFile(runFileName, actualFiles);
                    }
                }
                catch (FileNotFoundException e) {
                    logger.error("DSC_ERR_003_019 getting error while loading the .RUN File in Post Migration Process." + runFileName.getPath());
                }
                catch (IOException e) {
                    logger.error("DSC_ERR_003_021 Unable to delete the file, failed with IOEXception" + runFileName.getPath());
                }
            }
        }
    }

    private void deleteFile(File runFileName, Collection<String> actualFiles) {
        boolean deleteCheck;
        boolean deleteFile = true;
        for (String file : actualFiles) {
            if (!file.contains(runFileName.getName())) continue;
            deleteFile = false;
        }
        if (runFileName != null && deleteFile && !(deleteCheck = runFileName.delete())) {
            logger.error("DSC_ERR_003_020  Unable to delete the file, file not found." + runFileName.getPath());
        }
    }

    private String replaceAllDSQLVariable(String output, Set<String> lvList) {
        String input = output;
        Matcher matcher = DSQL_VAR_PATTERN.matcher(input);
        int startIndex = 0;
        int endIndex = 0;
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String grpString = matcher.group(1);
            int beginIndex = matcher.start();
            endIndex = matcher.end();
            sb.append(input.substring(startIndex, beginIndex));
            String replace = matcher.group(3) != null ? matcher.group(3) : matcher.group(2);
            String checkQuote = matcher.group();
            if (checkQuote.contains("'")) {
                lvList.add("'lv_mig_" + replace + "'");
                grpString = checkQuote.replace(checkQuote, "'lv_mig_" + replace + "'");
            } else {
                lvList.add("lv_mig_" + replace);
                grpString = grpString.replace(grpString, "lv_mig_" + replace + "");
            }
            sb.append(grpString);
            startIndex = endIndex;
        }
        sb.append(input.substring(endIndex));
        input = sb.toString();
        Matcher checkDsqlVarMatcher = CHECK_DSQL_VAR.matcher(input);
        while (checkDsqlVarMatcher.find()) {
            boolean sCondition;
            String matcherString = checkDsqlVarMatcher.group();
            boolean fCondition = !matcherString.contains("lv_mig_obj_exists_check") && !matcherString.contains("lv_mig_activitycount") && !matcherString.contains("lv_mig_errorcode");
            boolean bl = sCondition = !matcherString.contains("lv_mig_view_basetable") && !QueryConversionUtility.containsCheck(lvList.toString(), matcherString.trim());
            if (!fCondition || !sCondition) continue;
            lvList.add(matcherString);
        }
        return input;
    }

    private String getDsqlReplacementQuery(String runFileLine, File runFile, String sb, Set<String> lvList) {
        String input = sb;
        String lvVarList = QueryConversionUtility.getLvVariableList(input, "(lv_mig_\\w+)\\s+(?:TEXT)");
        if (lvList.size() > 0) {
            lvVarList = lvVarList.replaceFirst("\\)$", "");
            StringBuffer buf = new StringBuffer();
            buf.append(lvVarList).append(lvVarList.equals("(") ? "" : "|");
            for (String str : lvList) {
                if (lvVarList.contains(str.trim())) continue;
                buf.append(str + "|");
            }
            lvVarList = buf.append("").toString();
            lvVarList = lvVarList.substring(0, lvVarList.length() - 1) + " )";
        }
        if (!lvVarList.trim().equals("()")) {
            lvVarList = lvVarList.replaceFirst("\\)$", "");
            lvVarList = lvVarList.replaceAll("\\|", " IN OUT TEXT ,") + " IN OUT TEXT )";
        }
        String fileName = runFile.getName();
        String procName = "mig_td_runfile_" + fileName.substring(0, fileName.lastIndexOf("."));
        lvVarList = this.replaceInParameter(lvVarList);
        String val = this.replaceEnvParameter(lvVarList);
        RunFileUtility.setRunFileProcMap(runFileLine, procName + val.replaceAll("\\s*(IN|IN\\s+OUT)\\s+TEXT\\s*", ""));
        lvVarList = lvVarList.replace("'", "");
        input = this.addDsqlParameterInActualFile(input, lvVarList.replace("IN OUT TEXT", ""));
        input = this.doProcessChieldFile(input, lvVarList.substring(1, lvVarList.length() - 1));
        input = this.removeDsqlParameter(input, lvVarList.substring(1, lvVarList.length() - 1));
        String replaceString = "CREATE OR REPLACE PROCEDURE " + procName + lvVarList + " AS " + System.lineSeparator();
        Matcher matcher = DECLARE_PAT.matcher(input);
        input = matcher.find() ? input.replace("DECLARE", replaceString + "\nlv_mig_view_basetable TEXT;") : replaceString + "BEGIN\n" + input + "END; \n/";
        return input;
    }

    private String replaceInParameter(String lvVarList) {
        String lvList = lvVarList;
        Map<String, String> envParameter = TeradataMigrationService.getDSQLScriptFilePath();
        for (Map.Entry<String, String> entry : envParameter.entrySet()) {
            String key = entry.getKey();
            lvList = lvList.replaceAll("(?i)('?lv_mig_" + key + "'?\\s+IN)\\s+(OUT)\\s+(TEXT)", "$1 $3");
        }
        return lvList;
    }

    private String doProcessChieldFile(String input, String lvList) {
        String output = input;
        TeradataBteqHandler btq = new TeradataBteqHandler();
        String lvVarList = QueryConversionUtility.getLvVariableList(input, "(lv_mig_\\w+)\\s+(?:TEXT)");
        lvVarList = lvVarList.equals("()") ? "lv_mig_view_basetable" : lvVarList;
        output = btq.addQuoteToInsert(output, lvVarList);
        output = btq.addQuoteToSelect(output, lvVarList);
        output = btq.addQuoteToDelete(output, lvVarList);
        output = btq.addQuoteToCreate(output, lvVarList);
        output = btq.addQuoteToUpdate(output, lvVarList);
        return output;
    }

    private String removeDsqlParameter(String input, String splitLvParameter) {
        String declareBegin = "(?i)(?<!\\w)declare(?!\\w).*?(?<!\\w)begin(?!\\w)";
        Pattern pattern = Pattern.compile(declareBegin, 40);
        Matcher matcher = pattern.matcher(input);
        int startIndex = 0;
        int endIndex = 0;
        String splitLvVar = splitLvParameter.replace("IN OUT ", "");
        splitLvVar = splitLvVar.replaceAll("IN ", "");
        String[] dsqlRplVar = splitLvVar.split(",");
        StringBuffer sb = new StringBuffer();
        if (matcher.find()) {
            String grpString = matcher.group();
            int beginIndex = matcher.start();
            endIndex = matcher.end();
            sb.append(input.substring(startIndex, beginIndex));
            for (String str : dsqlRplVar) {
                String[] lvParam = str.split(" ");
                grpString = grpString.replaceAll("(?i)(?<!\\w)" + lvParam[0].trim() + "\\s*\\w+\\s*;", "");
            }
            sb.append(grpString);
        }
        sb.append(input.substring(endIndex));
        return sb.toString();
    }

    public void getReplaceProcName(Collection<String> filesetdsql2, IMigrationInputBO objInputData) {
        for (Map.Entry<String, String> entry : runFileScriptPath.entrySet()) {
            File folderLoc = new File(objInputData.getTargetFolderLoc());
            String sourcePath = objInputData.getSourceFolderLoc();
            File folder = new File(folderLoc, "output");
            String targetFolder = folder.getPath();
            Set<String> result = TeradataMigrationService.getRunFileContainList();
            for (String filePath : result) {
                try {
                    FileHandler fileHandler = new FileHandler();
                    filePath = filePath.replace(sourcePath, targetFolder);
                    File actualFile = new File(filePath);
                    String encodingFormat = fileHandler.getEncodingFormat(actualFile);
                    StringBuffer sb = new StringBuffer();
                    List lines = FileUtils.readLines((File)actualFile, (String)encodingFormat);
                    for (int i = 0; i < lines.size(); ++i) {
                        sb.append((String)lines.get(i)).append(IGaussDBConstants.NEW_LINE);
                    }
                    String input = sb.toString();
                    String val = entry.getValue();
                    String key = entry.getKey();
                    Matcher matcher = RUN_FILE_PAT.matcher(input);
                    File runFileName = new File(key.replace(";", ""));
                    if (!matcher.find()) continue;
                    String matcherString = matcher.group();
                    if (matcherString.contains("-")) {
                        String spaceRemovedRunFilePath = matcherString.replace(" ", "");
                        input = input.replace(matcherString, spaceRemovedRunFilePath);
                    }
                    input = matcherString.contains(";") ? input : input.replace(matcherString, matcherString + ";");
                    input = input.replaceAll("(?i)(\\.RUN\\s*FILE\\s*(=?)\\s*.*?\\s*)" + runFileName.getName().trim(), Matcher.quoteReplacement(val));
                    input = this.addDsqlParameterInActualFile(input, val);
                    input = input.replace(key, val);
                    File outFile = new File(actualFile.getPath());
                    try (FileOutputStream outStream = new FileOutputStream(outFile);
                         OutputStreamWriter osw = new OutputStreamWriter((OutputStream)outStream, encodingFormat);
                         BufferedWriter writeBuffer = new BufferedWriter(osw);){
                        writeBuffer.write(input);
                    }
                }
                catch (IOException e) {
                    logger.error("Error while loading the actual File. " + filePath);
                }
            }
        }
    }

    private String replaceEnvParameter(String val) {
        String lvList = val;
        Map<String, String> envParameter = TeradataMigrationService.getDSQLScriptFilePath();
        for (Map.Entry<String, String> entry : envParameter.entrySet()) {
            String key = entry.getKey();
            lvList = lvList.replaceAll("(?i)(lv_mig_" + key + "\\s*)", Matcher.quoteReplacement("${" + key + "}"));
        }
        return lvList;
    }

    private String addDsqlParameterInActualFile(String input, String val) {
        String variable = val.replace("IN TEXT", "");
        String lvList = variable.substring(variable.indexOf("(") + 1, variable.indexOf(")"));
        String[] list = lvList.split(",");
        String output = input;
        String beginDeclare = "(?i)(?<!\\w)declare(?!\\w).*?(?<!\\w)begin(?!\\w)";
        Pattern pattern = Pattern.compile(beginDeclare, 40);
        Matcher matcher = pattern.matcher(output);
        int startIndex = 0;
        int endIndex = 0;
        StringBuffer sb = new StringBuffer();
        if (matcher.find()) {
            String matcherString = matcher.group();
            matcherString = matcherString.replace("BEGIN", "");
            int beginIndex = matcher.start();
            endIndex = matcher.end();
            sb.append(input.substring(startIndex, beginIndex));
            sb.append(matcherString.trim());
            for (String str : list) {
                Pattern pattern1;
                Matcher matcher1;
                if (!(str = str.replace("'", "")).contains("lv_mig") || (matcher1 = (pattern1 = Pattern.compile("(?i)(?<!\\w)(" + str.trim() + ")", 40)).matcher(matcherString)).find()) continue;
                sb.append(IGaussDBConstants.NEW_LINE).append(str.trim()).append(" TEXT;");
            }
            sb.append(IGaussDBConstants.NEW_LINE).append("BEGIN ");
        }
        sb.append(input.substring(endIndex));
        return sb.toString();
    }

    public String getDsqlScriptFile(String queryLine, List<String> line, String path) {
        String input;
        block10: {
            String envPath = FeatureLoader.getStringProperty("enviroment_file_path");
            input = queryLine;
            if (!envPath.isEmpty() && !input.matches("(?i)\\/\\*\\s*(\\.RUN\\s+FILE\\s*(=?)\\s*(.*?\\.D?SQL)).*?\\*\\/")) {
                String filePath = "";
                Pattern pattern = Pattern.compile("(?i).*(\\.RUN\\s+FILE\\s*(=?)\\s*(.*?\\.D?SQL)).*");
                Matcher matcher = pattern.matcher(input);
                String runFileline = "";
                if (matcher.find()) {
                    filePath = this.getRemoteFilePath(input, matcher);
                    runFileline = matcher.group(1);
                    runFileline = runFileline.replace(" ", "");
                }
                FileHandler fileHandler = new FileHandler();
                File file = null;
                try {
                    String sourcePath = ApplicationProperty.getStringProperty("sourceFolderLoc");
                    file = new File(filePath.replace(" ", ""));
                    if (file != null && file.exists()) {
                        String runFilelinePath = runFileScriptPath.get(runFileline);
                        TeradataMigrationService.setRunFileContainList(path);
                        if (runFilelinePath == null) {
                            if (QueryConversionUtility.containsCheck(file.getPath(), sourcePath)) {
                                runFileScriptPath.put(runFileline, filePath);
                            } else {
                                runFileScriptPath.put(runFileline, sourcePath + File.separator + file.getName());
                            }
                            String encodingFormat = fileHandler.getEncodingFormat(file);
                            List lines = FileUtils.readLines((File)file, (String)encodingFormat);
                            if (!filePath.isEmpty() && !file.getPath().contains(sourcePath) && path.contains(sourcePath) && lines.size() > 0) {
                                this.writeDsqlScriptFile(filePath, runFileline, file, encodingFormat, lines);
                            }
                        }
                        break block10;
                    }
                    logger.error("DSC_ERR_003_019 Error while loading the .RUN FILE from given location. " + filePath);
                }
                catch (IOException e) {
                    logger.error("DSC_ERR_003_019 Error while loading the .RUN FILE from given location. " + filePath);
                }
            } else {
                logger.error("[DSC_ERR_003_022] " + MessageLoader.getMessage("DSC_ERR_003_022"));
            }
        }
        return input;
    }

    private void writeDsqlScriptFile(String filePath, String runFileline, File file, String encodingFormat, List<String> lines) {
        block23: {
            try {
                String sourcePath = ApplicationProperty.getStringProperty("sourceFolderLoc");
                File folder = new File(sourcePath);
                File[] files = folder.listFiles();
                if (files == null || files.length <= 0) break block23;
                boolean fileCheck = false;
                for (File nameFile : files) {
                    if (!filePath.contains(nameFile.getName())) continue;
                    fileCheck = true;
                    break;
                }
                String fileName = fileCheck ? "RunFile" + file.getName() : file.getName();
                String sourceFilename = sourcePath + File.separator + fileName;
                File fileTemp = new File(sourceFilename);
                boolean fileStatus = true;
                if (!fileTemp.exists()) {
                    fileStatus = fileTemp.createNewFile();
                }
                if (fileStatus && FileHandler.isInSecureDir(Paths.get(sourceFilename, new String[0]))) {
                    runFileScriptPath.put(runFileline, sourceFilename);
                    try (FileOutputStream outStream = new FileOutputStream(sourceFilename);
                         OutputStreamWriter osw = new OutputStreamWriter((OutputStream)outStream, encodingFormat);
                         BufferedWriter writeBuffer = new BufferedWriter(osw);){
                        for (int i = 0; i < lines.size(); ++i) {
                            writeBuffer.write(lines.get(i));
                            writeBuffer.newLine();
                        }
                        break block23;
                    }
                }
                logger.error("[DSC_ERR_005_029] " + MessageLoader.getMessage("DSC_ERR_005_029") + " Unable to load RunFile.");
            }
            catch (FileNotFoundException e) {
                logger.error(" Error while loading the file from given location." + filePath);
            }
            catch (UnsupportedEncodingException e) {
                logger.error(" Error while loading the file from given location." + filePath);
            }
            catch (IOException e) {
                logger.error("Error while loading the file from given location." + filePath);
            }
        }
    }

    private String getRemoteFilePath(String input, Matcher matcher) {
        String filePath = matcher.group(3);
        if (filePath.matches("(?i).*\\$\\s*\\{\\s*\\w+\\s*\\}.*")) {
            Map<String, String> partTable = TeradataMigrationService.getDSQLScriptFilePath();
            for (Map.Entry<String, String> entry : partTable.entrySet()) {
                String key = entry.getKey();
                if (!QueryConversionUtility.containsCheck(input, key)) continue;
                String val = entry.getValue();
                filePath = filePath.replaceFirst("(?i)(=\\s*)?\\$\\s*\\{\\s*" + key + "\\s*\\}", Matcher.quoteReplacement(val));
            }
        } else {
            filePath = filePath.replace("=", "").trim();
        }
        if (filePath.matches("(?i).*\\$\\s*\\{\\s*\\w+\\s*\\}.*")) {
            filePath = filePath.replaceAll("(?i).*(\\$\\s*\\{\\s*\\w+\\s*\\}).*", "$1");
            logger.error(" Please set the value for the environment variable " + filePath + " in the environment file. ");
        }
        return filePath;
    }
}

