/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.db2;

import com.huawei.db.migration.db2.DB2PatternHandler;
import com.huawei.db.migration.db2.DB2PreQueryChanges;
import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.util.ErrorLoggerUtility;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DB2QueryHandler {
    private static final Logger logger = LogManager.getLogger(DB2QueryHandler.class);

    public List<String> doMigProcess(List<String> inputList, String fileName, List<?> patterns, List<?> splitterPatterns) {
        ArrayList<String> outputList = new ArrayList<String>(10);
        int position = 0;
        String output = null;
        for (String input : inputList) {
            try {
                String[] inputQry;
                ++position;
                if (input.contains("~#~") && (inputQry = input.split("~#~")).length > 1) {
                    input = inputQry[0];
                    position = Integer.parseInt(inputQry[1].trim());
                }
                String forInput = QueryConversionUtility.doRemoveExtraSpace(input);
                boolean isProperInput = QueryConversionUtility.preQueryValidator(input);
                String unSupportedCheck = QueryConversionUtility.supportedValidator(forInput);
                if (unSupportedCheck.equals(forInput) && isProperInput) {
                    output = forInput;
                    output = DB2PreQueryChanges.doPreQueryChanges(output);
                    DB2PatternHandler objPatternHandler = new DB2PatternHandler();
                    output = objPatternHandler.doSplit(output, patterns, splitterPatterns, position);
                }
            }
            catch (MigrationServiceException e) {
                output = input;
                this.printException(fileName, outputList, output, e, MessageLoader.getMessage("queryProcessingError") + " " + fileName + " " + MessageLoader.getMessage("queryPosInfo") + position);
                logger.error(e.getMessage());
            }
            catch (RuntimeException e) {
                output = input;
                this.printException(fileName, outputList, output, e, MessageLoader.getMessage("queryProcessingError") + " " + fileName + " " + MessageLoader.getMessage("queryPosInfo") + position);
            }
            outputList.add(output);
        }
        return outputList;
    }

    private void printException(String fileName, List<String> outputList, String output, Exception e, String message) {
        ErrorLoggerUtility.failedQryCnt();
        ErrorLoggerUtility.failedFileCnt(fileName);
        logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " " + message);
        outputList.add(output);
    }
}

