/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.factory;

import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.factory.DB2MigrationFactory;
import com.huawei.db.migration.factory.MigrationAbstractFactory;
import com.huawei.db.migration.factory.NetezzaMigrationFactory;
import com.huawei.db.migration.factory.OracleMigrationFactory;
import com.huawei.db.migration.factory.TeradataMigrationFactory;
import com.huawei.db.migration.util.MessageLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MigrationFactoryProducer {
    private static final Logger logger = LogManager.getLogger(MigrationFactoryProducer.class);

    public static MigrationAbstractFactory getDataBaseFactory(String sourceDb) throws MigrationServiceException {
        MigrationAbstractFactory dbFactoryObj = null;
        switch (sourceDb) {
            case "teradata": {
                dbFactoryObj = new TeradataMigrationFactory();
                break;
            }
            case "oracle": {
                dbFactoryObj = new OracleMigrationFactory();
                break;
            }
            case "netezza": {
                dbFactoryObj = new NetezzaMigrationFactory();
                break;
            }
            case "db2": {
                dbFactoryObj = new DB2MigrationFactory();
                break;
            }
            default: {
                logger.error("[DSC_ERR_004_026] " + MessageLoader.getMessage("DSC_ERR_004_026"));
                throw new MigrationServiceException("[DSC_ERR_004_026] " + MessageLoader.getMessage("DSC_ERR_004_026"));
            }
        }
        return dbFactoryObj;
    }
}

