/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.factory;

import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.factory.MigrationAbstractFactory;
import com.huawei.db.migration.interfaces.IDBMigrationService;
import com.huawei.db.migration.interfaces.IMigrationTaskService;
import com.huawei.db.migration.interfaces.IPostMigrationService;
import com.huawei.db.migration.netezza.NetezzaBLogicMigrationService;
import com.huawei.db.migration.netezza.NetezzaBulkMigrationService;
import com.huawei.db.migration.netezza.NetezzaPostMigrationService;
import com.huawei.db.migration.netezza.NetezzaQueryMigrationService;
import com.huawei.db.migration.netezza.NetezzaSchemaMigrationService;
import com.huawei.db.migration.services.NetezzaMigrationService;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.QueryConversionUtility;

public class NetezzaMigrationFactory
implements MigrationAbstractFactory {
    @Override
    public IMigrationTaskService getMigrationTaskService(String taskName) throws MigrationServiceException {
        String task;
        IMigrationTaskService objMigStrategy = null;
        switch (task = QueryConversionUtility.toUpper(taskName)) {
            case "QUERY": {
                objMigStrategy = new NetezzaQueryMigrationService();
                break;
            }
            case "SCHEMA": {
                objMigStrategy = new NetezzaSchemaMigrationService();
                break;
            }
            case "BLOGIC": {
                objMigStrategy = new NetezzaBLogicMigrationService();
                break;
            }
            case "BULK": {
                objMigStrategy = new NetezzaBulkMigrationService();
                break;
            }
            default: {
                throw new MigrationServiceException("[DSC_ERR_004_025] " + MessageLoader.getMessage("DSC_ERR_004_025"));
            }
        }
        return objMigStrategy;
    }

    @Override
    public IDBMigrationService getDBMigrationService() throws MigrationServiceException {
        return new NetezzaMigrationService();
    }

    @Override
    public IPostMigrationService getPostMigrationService() {
        return new NetezzaPostMigrationService();
    }
}

