/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.factory;

import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.factory.MigrationAbstractFactory;
import com.huawei.db.migration.interfaces.IDBMigrationService;
import com.huawei.db.migration.interfaces.IMigrationTaskService;
import com.huawei.db.migration.interfaces.IPostMigrationService;
import com.huawei.db.migration.oracle.OracleBLogicMigrationService;
import com.huawei.db.migration.oracle.OracleBulkMigrationService;
import com.huawei.db.migration.oracle.OraclePostMigrationService;
import com.huawei.db.migration.oracle.OracleQueryMigrationService;
import com.huawei.db.migration.oracle.OracleSchemaMigrationService;
import com.huawei.db.migration.services.OracleMigrationService;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.QueryConversionUtility;

public class OracleMigrationFactory
implements MigrationAbstractFactory {
    @Override
    public IMigrationTaskService getMigrationTaskService(String taskName) throws MigrationServiceException {
        String task;
        IMigrationTaskService objMigStrategy = null;
        switch (task = QueryConversionUtility.toUpper(taskName)) {
            case "QUERY": {
                objMigStrategy = new OracleQueryMigrationService();
                break;
            }
            case "SCHEMA": {
                objMigStrategy = new OracleSchemaMigrationService();
                break;
            }
            case "BLOGIC": {
                objMigStrategy = new OracleBLogicMigrationService();
                break;
            }
            case "BULK": {
                objMigStrategy = new OracleBulkMigrationService();
                break;
            }
            default: {
                throw new MigrationServiceException("[DSC_ERR_004_025] " + MessageLoader.getMessage("DSC_ERR_004_025"));
            }
        }
        return objMigStrategy;
    }

    @Override
    public IDBMigrationService getDBMigrationService() throws MigrationServiceException {
        return new OracleMigrationService();
    }

    @Override
    public IPostMigrationService getPostMigrationService() {
        return new OraclePostMigrationService();
    }
}

