/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.filemerger;

import com.huawei.db.migration.common.handlers.MigrationProcessor;
import com.huawei.db.migration.filemerger.FileMerger;
import com.huawei.db.migration.splitter.FileSplitterUtil;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileMergerExecutor {
    private static final Logger logger = LogManager.getLogger(FileMergerExecutor.class);

    public static void mergeFiles(String targetFolderPath, String srcFolder, String formattedSrcorOutput) {
        logger.debug("Started merging the splitted files");
        String srcPath = srcFolder;
        String outPathStr = targetFolderPath + File.separator + formattedSrcorOutput;
        int configuredProcessors = QueryConversionUtility.doGetAppThreadCnt();
        ExecutorService fileMergerProcessExecutor = Executors.newFixedThreadPool(configuredProcessors);
        if (FileSplitterUtil.getSplitFileMap().size() == 0) {
            logger.debug("No files found to merge the splitted files:{}");
            return;
        }
        for (Map.Entry<String, Integer> fileDetails : FileSplitterUtil.getSplitFileMap().entrySet()) {
            FileMerger mergerTask = new FileMerger(fileDetails.getKey(), outPathStr, srcPath, fileDetails.getValue());
            fileMergerProcessExecutor.execute(mergerTask);
        }
        fileMergerProcessExecutor.shutdown();
        try {
            fileMergerProcessExecutor.awaitTermination(QueryConversionUtility.getApplicationTimeout(), TimeUnit.HOURS);
        }
        catch (InterruptedException e) {
            MigrationProcessor.interrupt();
            logger.error("Exception while waiting for the termination of exeutor, exception is:{}", (Object)e.getMessage());
        }
        logger.debug("Completed merging the splitted files");
    }
}

