/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.netezza;

import com.huawei.db.migration.database.bo.IBulkSplitPatternsBO;
import com.huawei.db.migration.database.bo.IQueryPatternsBO;
import com.huawei.db.migration.database.bo.IQuerySplitterPatternsBO;
import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.interfaces.IMigrationTaskService;
import com.huawei.db.migration.netezza.NetezzaPreQueryChanges;
import com.huawei.db.migration.netezza.NetezzaQueryMigrationService;
import com.huawei.db.migration.netezza.NetezzaSchemaMigrationService;
import com.huawei.db.migration.parser.GenericJSONParser;
import com.huawei.db.migration.util.ErrorLoggerUtility;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.ProgressUtil;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetezzaBLogicHandler {
    private static final Logger logger = LogManager.getLogger(NetezzaBLogicHandler.class);
    private static final Pattern CALL_PATTERN = Pattern.compile("(?i)begin.*(?<!\\w)(CALL)(?!\\w).*END");
    private static final Pattern BEGIN_PROC_PAT = Pattern.compile("(?i)(?<!\\w)begin_proc(?!\\w).*?(?<!\\w)begin(?!\\w)");
    private List<IQueryPatternsBO> queryPatterns;
    private String migrationType;

    public List<String> doBLogicProcess(List<String> inputList, String fileName, List<?> bLogicPatterns) {
        ArrayList<String> outputList = new ArrayList<String>(inputList.size());
        String output = null;
        String input = null;
        List<IBulkSplitPatternsBO> bLogicSplitPatterns = bLogicPatterns;
        for (int position = 0; position < inputList.size(); ++position) {
            try {
                input = inputList.get(position);
                output = QueryConversionUtility.doRemoveExtraSpace(input);
                output = this.doProcessFnProc(fileName, bLogicSplitPatterns, position, input);
                output = output.replaceAll("\\'(\\w+)\\s*-\\s*(\\w+)\\s*-\\s*(\\w+)\\'", "'$1-$2-$3'");
                outputList.add(output);
            }
            catch (RuntimeException e) {
                this.handleException(e, fileName, position);
                outputList.add(input);
            }
            ProgressUtil.printProgress();
        }
        return outputList;
    }

    private void handleException(Exception e, String fileName, int position) {
        ErrorLoggerUtility.updateQryCnt();
        ErrorLoggerUtility.failedQryCnt();
        ErrorLoggerUtility.failedFileCnt(fileName);
        logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " Error occurred while processing input in BLogic Migration. " + fileName + " " + MessageLoader.getMessage("queryPosInfo") + (position + 1));
    }

    private String doProcessFnProc(String fileName, List<IBulkSplitPatternsBO> bLogicSplitPatterns, int position, String input) {
        Matcher matcher;
        String output = input;
        output = this.doProcedureChanges(output);
        HashMap<String, String> map = new HashMap<String, String>(10);
        output = QueryConversionUtility.getSingleQuoteMap(output, map);
        output = output.replaceAll("(?i)(?<!\\w)NVARCHAR(?!\\w)", "NCHAR VARYING");
        output = output.replaceAll("(?i)(?<!\\w)ROW_COUNT(?!\\w)", "SQL%ROWCOUNT");
        output = output.replaceAll("(?i)(?<!\\w)EXECUTE\\s+AS\\s+CALLER(?!\\w)", "SECURITY INVOKER");
        if ((output = output.replaceAll("(?i)(?<!\\w)EXECUTE\\s+AS\\s+OWNER(?!\\w)", "SECURITY DEFINER")).matches("(?i).*begin.*(?<!\\w)(CALL)(?!\\w).*END.*") && (matcher = CALL_PATTERN.matcher(output)).find()) {
            String matcherString = matcher.group();
            String replace = matcherString.replaceAll("(?i)(?<!\\w)CALL(?!\\w)", "");
            output = output.replace(matcherString, replace);
        }
        output = QueryConversionUtility.getRplFromMap(output, map, "(##QUOTE##\\d+#)");
        map.clear();
        if (QueryConversionUtility.containsCheck(output, "TRANSACTION_ABORTED")) {
            LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
            output = QueryConversionUtility.getSingleDoubleQuoteMap(output, quoteMap);
            output = output.replaceAll("(?i)(?<!\\w)TRANSACTION_ABORTED(?!\\w)", "INVALID_TRANSACTION_TERMINATION");
            output = QueryConversionUtility.getRplFromMap(output, quoteMap, "(##QUOTE##\\d+#)");
        }
        output = output.replaceAll("(?i)((?:(?:(?:NATIONAL\\s+)?(?:CHARACTER|CHAR)\\s*(?:\\s+VARYING)?)|NVARCHAR|NCHAR|VARCHAR|CHAR|NUMERIC))\\s*\\(\\s*ANY\\s*\\)", "$1");
        output = NetezzaPreQueryChanges.doPreBLogicChanges(output);
        for (IBulkSplitPatternsBO typeBO : bLogicSplitPatterns) {
            HashMap<String, String> quoteList = new HashMap<String, String>(10);
            output = QueryConversionUtility.getSingleOrDoubleQuoteMap(output, quoteList, "'", "\\'.*?\\'", "~#~~#~~");
            boolean isExcludePatternValidation = QueryConversionUtility.excludePatternValidation(typeBO.getExcludePattern(), output);
            output = QueryConversionUtility.getRplFromMap(output, quoteList, "(~#~~#~~\\d+#)");
            if (!isExcludePatternValidation) continue;
            output = this.doMigrateDBObjects(fileName, position, output, typeBO);
            break;
        }
        output = NetezzaPreQueryChanges.doAddCommonChangesForBothBulkAndBlogic(output);
        return output;
    }

    private String doProcedureChanges(String input) {
        String output = input;
        if (QueryConversionUtility.toUpper(output).contains("CREATE")) {
            output = this.doRemoveDBName(output);
        }
        output = output.replaceAll("(?i)(?<!\\w)PROCEDURE(?!\\w)", "FUNCTION");
        output = output.replaceAll("(?i)(?<!\\w)RETURNS(?!\\w)", "RETURN");
        output = output.replaceAll("(?i)(?<!\\w)LANGUAGE\\s+NZPLSQL(?!\\w)", "");
        output = this.doPreChangesOnInput(output);
        output = this.removeDeclareBeforeBegin(output);
        output = output.replaceAll("(?i)(?<!\\w)BEGIN_PROC(?!\\w)", "");
        output = output.replaceAll("(?i)(?<!\\w)END(?!\\w)((?:#S#\\d+#E#\\s)*)\\s*(;)?\\s*((?:#S#\\d+#E#\\s)*)(?<!\\w)END_PROC(?!\\w)\\s*((?:#S#\\d+#E#\\s)*);", "END$1;$3$4/");
        return output;
    }

    private String doRemoveDBName(String output) {
        String input = output;
        Pattern pattern = Pattern.compile("(?i)(?<!\\w)((?:create\\s+(?:or\\s+)?|(?:replace\\s+)))(procedure|function|package)(?!\\w)\\s+(\"?\\w*\"?\\.)(\"?\\w*\"?\\.)");
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            String dbname = matcher.group(3);
            input = input.replace(dbname, "");
        }
        return input;
    }

    private String doPreChangesOnInput(String output) {
        String input = output;
        String beginEnd = QueryConversionUtility.doGetPatternMatch("(?<!\\w)begin_proc(?!\\w).*?(?<!\\w)END_PROC(?!\\w)", input);
        String rplbegnEnd = beginEnd.replace("**", "^");
        input = input.replace(beginEnd, rplbegnEnd);
        return input;
    }

    public String removeDeclareBeforeBegin(String output) {
        Matcher declareMatch = BEGIN_PROC_PAT.matcher(output);
        String firstBegin = "";
        int startIdx = 0;
        StringBuffer sb = new StringBuffer();
        while (declareMatch.find()) {
            int tempIdx = declareMatch.start();
            int endIdx = declareMatch.end();
            firstBegin = declareMatch.group();
            if (QueryConversionUtility.containsCheck(firstBegin, "declare")) {
                firstBegin = firstBegin.replaceAll("(?i)(?<!\\w)DECLARE(?!\\w)", "");
            }
            sb.append(output.substring(startIdx, tempIdx));
            sb.append(firstBegin);
            startIdx = endIdx;
        }
        sb.append(output.substring(startIdx));
        output = sb.toString();
        return output;
    }

    private String doMigrateDBObjects(String fileName, int position, String inputQuery, IBulkSplitPatternsBO typeBO) throws MigrationServiceException {
        String output = inputQuery;
        String taskName = typeBO.getName();
        if ("DML Pattern".equals(taskName)) {
            output = this.doHandleDMLPattern(fileName, position, inputQuery, typeBO);
        }
        return output;
    }

    private String doHandleDMLPattern(String fileName, int position, String inputQuery, IBulkSplitPatternsBO typeBO) {
        String output = inputQuery;
        GenericJSONParser objJSONParser = new GenericJSONParser();
        this.queryPatterns = objJSONParser.getJSONObject("netezza-query");
        List<IQuerySplitterPatternsBO> querySplitterPatterns = objJSONParser.getJSONObject("netezza-query-splitter");
        List<IBulkSplitPatternsBO> bLogicSplitter = objJSONParser.getJSONObject("netezza-blogic-splitter");
        List<IQueryPatternsBO> schemaPatterns = objJSONParser.getJSONObject("netezza-schema");
        Pattern pattern = Pattern.compile(typeBO.getFinderPattern(), 2);
        Matcher matcher = pattern.matcher(output);
        while (matcher.find()) {
            String tempQuery;
            String query = tempQuery = matcher.group(2);
            boolean isQuoted = false;
            if (tempQuery.matches("'.*'\\s*;")) {
                query = tempQuery.replaceFirst("\\'(.*)\\'(\\s*);", "$1$2;");
                isQuoted = true;
            }
            this.migrationType = this.getMigrationType(bLogicSplitter, query);
            String outputSQL = this.doCallMigrationTypeService(query, fileName, querySplitterPatterns, schemaPatterns, position);
            if (tempQuery.startsWith(" ") && !outputSQL.startsWith(" ")) {
                outputSQL = " " + outputSQL;
            }
            if (isQuoted) {
                query = query.replaceFirst("\\s*;\\s*$", "");
                outputSQL = outputSQL.replaceFirst("\\s*;\\s*$", "");
            }
            output = output.replace(query, outputSQL);
            ProgressUtil.printProgress();
        }
        return output;
    }

    private String getMigrationType(List<IBulkSplitPatternsBO> bLogicSplitter, String query) {
        boolean isExcludePatternValidation = false;
        this.migrationType = "";
        for (IBulkSplitPatternsBO identifierBO : bLogicSplitter) {
            Pattern patternSplitter;
            Matcher matcherSplitter;
            isExcludePatternValidation = QueryConversionUtility.excludePatternValidation(identifierBO.getExcludePattern(), query);
            if (!isExcludePatternValidation || !(matcherSplitter = (patternSplitter = Pattern.compile(identifierBO.getFinderPattern(), 2)).matcher(query)).find()) continue;
            this.migrationType = identifierBO.getName();
            break;
        }
        return this.migrationType;
    }

    private String doCallMigrationTypeService(String inputSql, String fileName, List<IQuerySplitterPatternsBO> querySplitterPatterns, List<IQueryPatternsBO> schemaPatterns, int position) throws MigrationServiceException {
        int queryCnt = 0;
        String outputSQL = inputSql;
        StringBuffer inputQuery = new StringBuffer(inputSql);
        inputQuery.append("~#~").append(position);
        IMigrationTaskService objTaskService = null;
        switch (this.migrationType) {
            case "Query": {
                objTaskService = new NetezzaQueryMigrationService();
                outputSQL = objTaskService.handleMigrationTask(inputQuery.toString(), fileName, this.queryPatterns, querySplitterPatterns);
                break;
            }
            case "Schema": {
                objTaskService = new NetezzaSchemaMigrationService();
                outputSQL = objTaskService.handleMigrationTask(inputQuery.toString(), fileName, schemaPatterns, querySplitterPatterns);
                break;
            }
            case "Schema with Query": {
                Map<String, String> queryMap = new LinkedHashMap<String, String>(10);
                String input = QueryConversionUtility.doGetSchemaQueries(inputQuery.toString(), queryMap, queryCnt);
                objTaskService = new NetezzaSchemaMigrationService();
                outputSQL = objTaskService.handleMigrationTask(input, fileName, schemaPatterns, querySplitterPatterns);
                queryMap = QueryConversionUtility.doMigrateSchemaQueries(fileName, this.queryPatterns, querySplitterPatterns, queryMap, new NetezzaQueryMigrationService());
                outputSQL = QueryConversionUtility.doReplaceFunctionVariables(outputSQL, queryMap, "##QUERY##");
                break;
            }
            default: {
                throw new MigrationServiceException("[DSC_ERR_004_023] " + MessageLoader.getMessage("DSC_ERR_004_023") + "." + " " + fileName + " " + MessageLoader.getMessage("queryPosInfo") + position);
            }
        }
        if (outputSQL.contains("~#~")) {
            outputSQL = outputSQL.split("~#~")[0];
        }
        return outputSQL;
    }
}

