/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.netezza;

import com.huawei.db.migration.database.bo.IBulkSplitPatternsBO;
import com.huawei.db.migration.database.bo.IQueryPatternsBO;
import com.huawei.db.migration.database.bo.IQuerySplitterPatternsBO;
import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.interfaces.IMigrationTaskService;
import com.huawei.db.migration.netezza.NetezzaPreQueryChanges;
import com.huawei.db.migration.netezza.NetezzaQueryMigrationService;
import com.huawei.db.migration.netezza.NetezzaSchemaMigrationService;
import com.huawei.db.migration.parser.GenericJSONParser;
import com.huawei.db.migration.util.ErrorLoggerUtility;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.ProgressUtil;
import com.huawei.db.migration.util.QueryConversionUtility;
import com.huawei.db.migration.util.QueryUtilityExt;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetezzaBulkHandler {
    private static final Logger logger = LogManager.getLogger(NetezzaBulkHandler.class);
    private String migrationType = null;
    private List<IQueryPatternsBO> queryPatterns = null;

    public List<String> doBulkProcess(List<String> inputList, String fileName, List<?> bulkPatterns) throws InterruptedException {
        GenericJSONParser objJSONParser = new GenericJSONParser();
        this.queryPatterns = objJSONParser.getJSONObject("netezza-query");
        List<IQuerySplitterPatternsBO> querySplitterPatterns = objJSONParser.getJSONObject("netezza-query-splitter");
        List<IQueryPatternsBO> schemaPatterns = objJSONParser.getJSONObject("netezza-schema");
        List<IBulkSplitPatternsBO> bulkSplitPatterns = bulkPatterns;
        int position = 0;
        String output = null;
        ArrayList<String> outputList = new ArrayList<String>(inputList.size());
        for (String input : inputList) {
            try {
                output = QueryConversionUtility.doRemoveExtraSpace(input);
                String unSupportedCheck = QueryConversionUtility.supportedValidator(output);
                if (QueryConversionUtility.preQueryValidator(output) && unSupportedCheck.equals(output)) {
                    this.migrationType = QueryUtilityExt.findMigrationType(bulkSplitPatterns, this.migrationType, output);
                    output = this.doCallMigrationTypeService(output, fileName, querySplitterPatterns, schemaPatterns, position);
                    output = NetezzaPreQueryChanges.doAddCommonChangesForBothBulkAndBlogic(output);
                }
                output = output.replaceAll("\\'(\\w+)\\s*-\\s*(\\w+)\\s*-\\s*(\\w+)\\'", "'$1-$2-$3'");
            }
            catch (RuntimeException msg) {
                QueryUtilityExt.handleInterruptedException(fileName, msg);
                output = input;
                logger.error(ErrorLoggerUtility.getExceptionDetails(msg) + " " + msg.getMessage());
                this.handleRunTimeException(fileName, outputList, position);
            }
            outputList.add(output);
            ProgressUtil.printProgress();
        }
        return outputList;
    }

    private String doCallMigrationTypeService(String inputSql, String fileName, List<IQuerySplitterPatternsBO> querySplitterPatterns, List<IQueryPatternsBO> schemaPatterns, int position) throws MigrationServiceException {
        String output = inputSql;
        IMigrationTaskService objTaskService = null;
        Map<String, String> queryMap = null;
        String input = null;
        int queryCount = 0;
        StringBuffer inputQuery = new StringBuffer(inputSql);
        inputQuery.append("~#~").append(position);
        switch (this.migrationType) {
            case "Query": {
                objTaskService = new NetezzaQueryMigrationService();
                output = objTaskService.handleMigrationTask(inputQuery.toString(), fileName, this.queryPatterns, querySplitterPatterns);
                break;
            }
            case "Schema": {
                objTaskService = new NetezzaSchemaMigrationService();
                output = objTaskService.handleMigrationTask(inputQuery.toString(), fileName, schemaPatterns, querySplitterPatterns);
                break;
            }
            case "Schema with Query": {
                queryMap = new LinkedHashMap<String, String>(10);
                input = QueryConversionUtility.doGetSchemaQueries(inputQuery.toString(), queryMap, queryCount);
                objTaskService = new NetezzaSchemaMigrationService();
                output = objTaskService.handleMigrationTask(input, fileName, schemaPatterns, querySplitterPatterns);
                queryMap = QueryConversionUtility.doMigrateSchemaQueries(fileName, this.queryPatterns, querySplitterPatterns, queryMap, new NetezzaQueryMigrationService());
                output = QueryConversionUtility.doReplaceFunctionVariables(output, queryMap, "##QUERY##");
                break;
            }
        }
        output = QueryConversionUtility.canonicalizeString(output);
        if (output.contains("~#~")) {
            output = output.split("~#~")[0];
        }
        return output;
    }

    private void handleRunTimeException(String fileName, List<String> outputList, int position) {
        ErrorLoggerUtility.failedFileCnt(fileName);
        ErrorLoggerUtility.failedQryCnt();
        logger.error("[DSC_ERR_004_039] " + MessageLoader.getMessage("DSC_ERR_004_039") + " " + fileName + " " + MessageLoader.getMessage("queryPosInfo") + position);
    }
}

