/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.netezza;

import com.huawei.db.migration.util.FeatureLoaderExtended;
import com.huawei.db.migration.util.QueryConversionUtility;
import com.huawei.db.migration.util.QueryUtilityExt;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NetezzaPreQueryChanges {
    public static String doPreQueryChanges(String input) {
        String output = input;
        if (QueryConversionUtility.containsCheck(output, "DISTRIBUTE")) {
            output = output.replaceFirst("(?i)DISTRIBUTE\\s+ON", "DISTRIBUTE BY HASH");
        }
        if (QueryConversionUtility.containsCheck(output = NetezzaPreQueryChanges.doPreTableChanges(output), "ORGANIZE")) {
            output = output.replaceFirst("(?i)(ORGANIZE\\s+ON\\s*\\(.*?\\))", "/* $1 */");
        }
        return output;
    }

    public static String doPreTableChanges(String output) {
        HashMap<String, String> commentMap = new HashMap<String, String>(10);
        if (FeatureLoaderExtended.getBooleanProperty("rowstoreToColumnstore")) {
            Matcher blobMatch;
            if (QueryConversionUtility.containsCheck(output, "ALTER")) {
                output = output.replaceFirst("(?i)alter\\s+table.*?;", "/* $0 */");
            }
            if (QueryConversionUtility.containsCheck(output = QueryConversionUtility.getSingleOrDoubleQuoteMap(output, commentMap, "/*", "\\/\\*.*?\\*\\/", "##COMMENT##"), "PRESERVE") || QueryConversionUtility.containsCheck(output, "DISTRIBUTE")) {
                output = QueryConversionUtility.doReplaceSpecificGrp(output, "(.*?)(on\\s*commit\\s*preserve\\s*rows.*|distribute\\s*by\\s*hash.*|;)", "", "with (ORIENTATION = column) ", 1, true);
            }
            if (FeatureLoaderExtended.getStringProperty("cstore_blob").equalsIgnoreCase("BYTEA") && QueryConversionUtility.containsCheck(output, "WITH") && (blobMatch = Pattern.compile("(?i)create\\s+table\\s+\\w+\\s*\\((.*?)\\)\\s*with.*?;").matcher(output)).find()) {
                output = QueryConversionUtility.replace(output, "(?<!\\w)blob(?!\\w)", "BYTEA", false);
            }
            output = output.replaceFirst("(?i)unique|primary\\s+key|(?:\\,\\s*)?constraint.*?(?:unique|primary\\s+key)(?:\\s+\\(.*?\\))?", "/* $0 */");
            output = QueryConversionUtility.getRplFromMap(output, commentMap, "(##COMMENT##\\d+#)");
        }
        return output;
    }

    public static String doPreBLogicChanges(String input) {
        String output = input;
        output = NetezzaPreQueryChanges.doChangeTableToParams(output);
        if (QueryConversionUtility.containsCheck(output = QueryConversionUtility.replace(output, "(?i)(?<!\\w)_V_SYS_COLUMNS(?!\\w)", "information_schema.columns", false), "table_") || QueryConversionUtility.containsCheck(output, "column_name")) {
            Matcher rplTableMatcher = Pattern.compile("(?i)(?:(table_name|table_schema?|column_name)\\s*=\\s*)(\\'.*?\\')").matcher(output);
            while (rplTableMatcher.find()) {
                String tableName = rplTableMatcher.group(1);
                output = QueryConversionUtility.replace(output, tableName, QueryConversionUtility.toLower(tableName), false);
                output = output.replaceAll("(?i)(?:(table_name|table_schema?|column_name)\\s*=\\s*)(\\'.*?\\')", QueryConversionUtility.toLower("$1") + " = " + "LOWER" + "(" + "$2" + ")");
            }
        }
        output = NetezzaPreQueryChanges.doConvertThreeDot(output);
        output = NetezzaPreQueryChanges.removeDuplicateSemiColon(output);
        output = NetezzaPreQueryChanges.doConvertVariableToInto(output);
        output = NetezzaPreQueryChanges.doReplaceCursorKeywordInForLoop(output);
        return output;
    }

    static String doChangeTableToParams(String output) {
        Matcher extTable = Pattern.compile("(?i)create\\s+external\\s+table\\s+(\\'.*?\\').*?delimiter\\s+\\'(.*?)\\'.*?nullvalue\\s+(\\'.*?\\').*?encoding\\s+(\\'.*?\\').*?escapechar\\s+(\\'.*?\\').*?(?:includeheader\\s+(\\'.*?\\').*?)?as\\s+(select.*?);").matcher(output);
        StringBuffer sb = new StringBuffer();
        int startIdx = 0;
        while (extTable.find()) {
            String ftblLocation = extTable.group(1);
            String ftblAsciiDelimiter = extTable.group(2);
            String ftblNullval = extTable.group(3);
            String ftblEncoding = extTable.group(4);
            String ftblEscapechar = extTable.group(5);
            String ftblIncHeader = "";
            if (null != extTable.group(6)) {
                ftblIncHeader = extTable.group(6);
            }
            String selectQry = extTable.group(7);
            int tempIdx = extTable.start();
            int endIdx = extTable.end();
            sb.append(output.substring(startIdx, tempIdx));
            sb.append("mig_ntz_ext.mig_fn_ntz_external_table").append("(").append("null").append(",").append(" ").append("'").append(selectQry).append("'").append(",").append(" ").append(ftblLocation).append(",").append(" ").append(ftblAsciiDelimiter).append(",").append(" ").append(ftblNullval).append(",").append(" ").append(ftblEncoding).append(",").append(" ").append(ftblEscapechar).append(",").append(" ");
            if (!ftblIncHeader.isEmpty()) {
                sb.append(ftblIncHeader);
            } else {
                sb.append("null");
            }
            sb.append(")").append(";");
            startIdx = endIdx;
        }
        sb.append(output.substring(startIdx));
        return sb.toString();
    }

    private static String doReplaceCursorKeywordInForLoop(String input) {
        String output = input;
        if (output.matches("(?i).*(?<!\\w)CURSOR(?!\\w)\\s*(?:(?:#S#\\d+#E#\\s*)*)(?<!\\w)(RECORD)(?!\\w).*")) {
            output = output.replaceAll("(?i)(?<!\\w)CURSOR(?!\\w)\\s*((?:#s#\\d+#e#\\s*)*(?<!\\w)RECORD(?!\\w))", "MIG_CURSOR $1");
            Pattern pattern = Pattern.compile("(?i)((?<!\\w)end(?!\\w)\\s*(?:#s#\\d+#e#\\s*)*(?<!\\w)LOOP(?!\\w))");
            Matcher matcher = pattern.matcher(output);
            String inputLower = QueryConversionUtility.toLower(output);
            StringBuffer sbuf = new StringBuffer();
            int tmpIdx = 0;
            while (matcher.find()) {
                int endIndex = matcher.start(1);
                int cursIdx = inputLower.lastIndexOf(" cursor ", endIndex);
                sbuf.append(output.substring(tmpIdx, cursIdx));
                if (cursIdx != -1) {
                    String cursorLoop = output.substring(cursIdx, endIndex);
                    String cursorLoopRpl = cursorLoop.replaceAll("(?i)(?<!\\w)CURSOR(?!\\w)", "MIG_CURSOR");
                    sbuf.append(cursorLoopRpl);
                }
                tmpIdx = endIndex;
            }
            sbuf.append(output.substring(tmpIdx));
            return sbuf.toString();
        }
        return output;
    }

    static String doConvertThreeDot(String input) {
        String output = input;
        if (output.contains("...")) {
            output = output.replace("...", "..");
        }
        return output;
    }

    static String removeDuplicateSemiColon(String input) {
        String output = input.replaceAll("(?i)(;)\\s*(?:(?:#S#\\d+#E#\\s*)*);", "$1");
        return output;
    }

    static String doConvertVariableToInto(String input) {
        String output = input;
        if (output.contains(":=")) {
            output = output.replaceAll("(?i)((\\w+)\\s*:=)\\s*(SELECT(?!\\w).*?)((?<!\\w)FROM)", "$3 INTO $2 $4");
        }
        return output;
    }

    public static String doAddCommonChangesForBothBulkAndBlogic(String input) {
        String checkKeyForQuotes;
        String output = input;
        LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
        if (QueryConversionUtility.containsCheck(output = QueryConversionUtility.getSingleDoubleQuoteMap(output, quoteMap), "nvl")) {
            output = NetezzaPreQueryChanges.doCheckNvlFuncSingleParamter(output);
        }
        if (output.matches("(?i).*(?<!\\w)ISNULL(?!\\w)\\s*\\(.*")) {
            output = output.replaceAll("(?i)(?<!\\w)ISNULL(?!\\w)\\s*\\(", "NVL(");
        }
        if (QueryConversionUtility.containsCheck(output = QueryConversionUtility.getRplFromMap(output, quoteMap, "(##QUOTE##\\d+#)"), "group_concat")) {
            output = NetezzaPreQueryChanges.doRplGroupConcatToStringAgg(output, "group_concat", "STRING_AGG");
        }
        if (QueryConversionUtility.containsCheck(output, checkKeyForQuotes = FeatureLoaderExtended.getStringProperty("keywords_addressed_using_doublequote"))) {
            output = QueryConversionUtility.replaceAll(output, "(?i)(?<!as\\s|\\w|\\.)" + FeatureLoaderExtended.getStringProperty("keywords_addressed_using_doublequote"), "\"" + FeatureLoaderExtended.getStringProperty("keywords_addressed_using_doublequote") + "\"");
        }
        return output;
    }

    private static String doRplGroupConcatToStringAgg(String input, String funName, String replaceString) {
        int indexGroupConcat = 0;
        String output = input;
        do {
            String check;
            if ((check = output.substring((indexGroupConcat = QueryConversionUtility.getIndex(output, funName, indexGroupConcat)) - 6, indexGroupConcat)).startsWith("admin")) {
                indexGroupConcat -= 6;
            }
            if (indexGroupConcat == -1) continue;
            String groupConcat = QueryUtilityExt.doGetStringFromGivenIndex(indexGroupConcat, output);
            String replaceGroup = groupConcat.substring(0, groupConcat.lastIndexOf(")")) + "," + "',') ";
            replaceGroup = replaceGroup.replaceFirst("(?i)((?:admin\\.)?group_concat)", replaceString);
            output = output.replace(groupConcat, replaceGroup);
        } while (QueryConversionUtility.getIndex(output, funName, indexGroupConcat) != -1);
        return output;
    }

    private static String doCheckNvlFuncSingleParamter(String input) {
        int indexNvl = 0;
        String output = input;
        do {
            String params;
            String[] paramsArr;
            String inputLower;
            if ((indexNvl = QueryConversionUtility.getIndex(inputLower = QueryConversionUtility.toLower(output), "nvl", indexNvl)) == -1) continue;
            String nvlFunc = QueryUtilityExt.doGetStringFromGivenIndex(indexNvl, inputLower);
            if (nvlFunc.trim().matches("(?i)(?<!\\w)NVL(?!\\w)\\s*(?:#S#\\d+#E#\\s*)*\\(.*") && (paramsArr = (params = nvlFunc.substring(nvlFunc.indexOf("(") + 1, nvlFunc.lastIndexOf(")"))).trim().split(",(?![^(]*\\))")).length == 1) {
                int substringIndex = indexNvl + nvlFunc.length() - 1;
                output = output.substring(0, indexNvl + nvlFunc.length() - 1) + "," + "null" + output.substring(substringIndex);
            }
            indexNvl += 3;
        } while (QueryConversionUtility.getIndex(output, "nvl", indexNvl) != -1);
        return output;
    }
}

