/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.netezza;

import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.netezza.NetezzaPatternHandler;
import com.huawei.db.migration.util.ColumnSplitter;
import com.huawei.db.migration.util.ErrorLoggerUtility;
import com.huawei.db.migration.util.FeatureLoaderExtended;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.QueryConversionUtility;
import com.huawei.db.migration.util.QueryUtilityExt;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetezzaQueryHandler {
    private static final Logger logger = LogManager.getLogger(NetezzaQueryHandler.class);
    private static final Pattern DATE_PAT = Pattern.compile("(?i)(?<!\\w)(date)(?!\\w)\\s*\\((.*?)\\)");
    private static final Pattern SELECT_WHERE_PAT = Pattern.compile("(?i)(?<!\\w)select(?!\\w).*?(?<!\\w)where(?!\\w)(.*?);");
    private static final Pattern SELECT_FROM_PAT = Pattern.compile("(?i)(.*?(?<!\\w)select(?!\\w))(.*?)(?<!\\w)from(?!\\w)");

    public List<String> doMigProcess(List<String> inputList, String fileName, List<?> patterns, List<?> splitterPatterns) {
        ArrayList<String> outputList = new ArrayList<String>(10);
        int position = 0;
        String output = null;
        NetezzaPatternHandler patternHandler = new NetezzaPatternHandler();
        for (String input : inputList) {
            try {
                String[] inputQry;
                ++position;
                if (input.contains("~#~") && (inputQry = input.split("~#~")).length > 1) {
                    input = inputQry[0];
                    position = Integer.parseInt(inputQry[1].trim());
                }
                String forInput = QueryConversionUtility.doRemoveExtraSpace(input);
                boolean isProperInput = QueryConversionUtility.preQueryValidator(input);
                String unSupportedCheck = QueryConversionUtility.supportedValidator(forInput);
                if (!unSupportedCheck.equals(forInput) || !isProperInput) {
                    output = unSupportedCheck;
                    forInput = unSupportedCheck;
                    if (!isProperInput && forInput.matches("\\s*\\'.*?\\'\\s*\\;")) {
                        outputList.add(output);
                        continue;
                    }
                } else {
                    output = this.getTranslatedOut(forInput);
                }
                output = patternHandler.doSplit(output, patterns, splitterPatterns, position);
                output = this.doQueryProcess(output);
            }
            catch (MigrationServiceException e) {
                output = input;
                this.migServiceExc(fileName, outputList, position, output, e);
            }
            catch (RuntimeException e) {
                output = input;
                this.runtimeExc(fileName, outputList, position, output, e);
            }
            outputList.add(output);
        }
        return outputList;
    }

    private void runtimeExc(String fileName, List<String> outputList, int position, String output, RuntimeException e) {
        this.printException(fileName, outputList, output, e, MessageLoader.getMessage("queryProcessingError") + " " + fileName + " " + MessageLoader.getMessage("queryPosInfo") + position);
    }

    private void migServiceExc(String fileName, List<String> outputList, int position, String output, MigrationServiceException e) {
        this.printException(fileName, outputList, output, e, MessageLoader.getMessage("queryProcessingError") + " " + fileName + " " + MessageLoader.getMessage("queryPosInfo") + position);
        logger.error(e.getMessage());
    }

    private String getTranslatedOut(String forInput) {
        String output = forInput;
        output = this.doMigrateTranslate(output);
        return output;
    }

    private String doQueryProcess(String input) {
        String output = input;
        if (QueryConversionUtility.toUpper(output).endsWith("LOOP")) {
            StringBuffer sb = new StringBuffer(output);
            sb.insert(0, "(");
            output = sb.toString();
            output = output.replace(output.substring(output.lastIndexOf(" ") + 1), ") " + output.substring(output.lastIndexOf(" ") + 1));
        }
        output = this.handleGaussKeywords(output);
        output = this.doColumnMap(output);
        output = this.doDateConversion(output);
        return output;
    }

    private String doDateConversion(String input) {
        Pattern pattern;
        Matcher matcherFormat;
        Pattern datepattern;
        Matcher matcher;
        String output = input;
        if (output.matches("(?i).*?(CURRENT_DATE)?\\s*\\-\\s*(DATE\\s*('\\s*\\d.*')).*") && (matcher = (datepattern = Pattern.compile("(?i).*?(CURRENT_DATE)?\\s*\\-\\s*(DATE\\s*('\\s*\\d.*')).*")).matcher(output)).find()) {
            output = output.replaceAll(matcher.group(2), "CAST ( " + matcher.group(3) + " AS DATE)");
        }
        if (QueryConversionUtility.containsCheck(output, "DATE_PART")) {
            output = this.dateTypeCasting(output);
        }
        if ((matcherFormat = (pattern = Pattern.compile("(?i)AS\\s+(#S#\\d+#E#\\s*)*DATE\\s*((#S#\\d+#E#\\s*)*)FORMAT", 2)).matcher(output)).find()) {
            output = this.doRplNetezzaDateFormatAsDate(output, matcherFormat);
        }
        output = this.doNetezzaDateSubstraction(output);
        return output;
    }

    public String dateTypeCasting(String input) {
        String output = input;
        Matcher dateMatch = DATE_PAT.matcher(output);
        String date = "";
        String dateCol = "";
        int tempIdx = 0;
        int endIdx = 0;
        int startIdx = 0;
        StringBuffer sb = new StringBuffer();
        while (dateMatch.find()) {
            date = dateMatch.group(1);
            dateCol = dateMatch.group(2);
            tempIdx = dateMatch.start(1);
            endIdx = dateMatch.end();
            sb.append(output.substring(startIdx, tempIdx));
            sb.append("CAST").append("(").append(dateCol).append(" ").append("as ").append(date).append(")");
            startIdx = endIdx;
        }
        sb.append(output.substring(endIdx));
        output = sb.toString();
        return output;
    }

    String doColumnMap(String input) {
        String output = input;
        Matcher colMatch = SELECT_WHERE_PAT.matcher(output);
        if (colMatch.find()) {
            String whereClass = colMatch.group(1);
            if (QueryConversionUtility.containsCheck(whereClass, "table_schem")) {
                output = QueryConversionUtility.replaceAll(output, "(?i)(?<!\\w)table_schem(?!\\w)", "table_schema");
            }
            if (QueryConversionUtility.containsCheck(whereClass, "type_name")) {
                output = QueryConversionUtility.replaceAll(output, "(?i)(?<!\\w)type_name(?!\\w)", "data_type");
            }
        }
        return output;
    }

    private String handleGaussKeywords(String input) {
        String output = input;
        StringBuffer sb = new StringBuffer();
        StringBuffer sbOut = new StringBuffer();
        String checkKeyForAs = FeatureLoaderExtended.getStringProperty("keywords_addressed_using_as");
        if (QueryConversionUtility.containsCheck(output, checkKeyForAs)) {
            output = this.doAddAsAlias(output, sb, sbOut, checkKeyForAs);
        }
        return output;
    }

    public String doAddAsAlias(String input, StringBuffer sb, StringBuffer sbOut, String check) {
        String output = input;
        Matcher colMatch = SELECT_FROM_PAT.matcher(output);
        int endIdx = 0;
        String sel = "";
        String columns = "";
        while (colMatch.find()) {
            endIdx = colMatch.end();
            sel = colMatch.group(1);
            columns = colMatch.group(2);
            ColumnSplitter splitter = new ColumnSplitter();
            List<String> colNames = splitter.doGetAllColumns(columns);
            List<String> aliasNames = QueryConversionUtility.doGetAliasList(colNames);
            this.getListOfCols(sb, check, colNames, aliasNames);
            columns = sb.toString();
            sb.delete(0, sb.length());
            columns = columns.substring(0, columns.length() - 1);
            sbOut.append(sel).append(" ").append(columns).append(" ").append(" ").append("from").append(" ");
        }
        sbOut.append(output.substring(endIdx));
        output = sbOut.toString();
        return output;
    }

    private void getListOfCols(StringBuffer sb, String check, List<String> colNames, List<String> aliasNames) {
        for (int i = 0; i < aliasNames.size(); ++i) {
            if (!colNames.get(i).contains(" AS ") && aliasNames.get(i).equalsIgnoreCase(check)) {
                String temp = aliasNames.get(i).replace(aliasNames.get(i), "AS " + FeatureLoaderExtended.getStringProperty("keywords_addressed_using_as"));
                String tempCol = colNames.get(i).substring(0, colNames.get(i).lastIndexOf(" "));
                sb.append(tempCol).append(" ").append(temp).append(",");
                continue;
            }
            sb.append(colNames.get(i)).append(",");
        }
    }

    private String doRplNetezzaDateFormatAsDate(String input, Matcher matcherFormat) {
        String inputQuery = input;
        String pattern = "(?i)\\s*(?<!\\w)AS\\s+((#S#\\d+#E#\\s*)*)DATE\\s*((#S#\\d+#E#\\s*)*)FORMAT\\s*((#S#\\d+#E#\\s*)*).*?\\s*((#S#\\d+#E#\\s*)*)\\)";
        inputQuery = inputQuery.replaceAll(pattern, " AS DATE)");
        return inputQuery;
    }

    String doNetezzaDateSubstraction(String input) {
        Pattern datePattern = Pattern.compile("(?i)(CAST)?\\s*(#S#\\d+#E#\\s*)*\\(?\\s*(#S#\\d+#E#\\s*)*((\\w+\\s*\\([\\w\\,\\s]+\\)|\\'\\d+?\\'|\\'?#*\\w+\\.?\\w*#*\\d*#*\\'?|\\$?\\'\\$?\\{?\\w+\\}?\\')\\s*(#S#\\d+#E#\\s*)*(AS\\s*DATE\\))?(#S#\\d+#E#\\s*)*\\s*-\\s*(#S#\\d+#E#\\s*)*(CAST)?\\s*(#S#\\d+#E#\\s*)*\\(?\\s*(#S#\\d+#E#\\s*)*(case(?:.*?)end|\\w+\\s*\\([\\w\\,\\s]+\\)|MAX\\s*\\(.*?\\)|\\'\\d.*?\\'|\\'?#*\\w+(?:\\(.*?\\)\\s*\\))?\\.?\\w*#*\\d*#*\\'?|\\$?\\'\\$?\\{?\\w+\\}?\\')\\s*(#S#\\d+#E#\\s*)*(AS\\s*DATE\\))?)(#S#\\d+#E#\\s*)*\\s*");
        Matcher matcher = datePattern.matcher(input);
        int endIndex = 0;
        int startIndex = 0;
        String matcherStr = null;
        StringBuffer buffer = new StringBuffer(128);
        while (matcher.find()) {
            int beginIndex = matcher.start();
            buffer.append(input.substring(startIndex, beginIndex));
            endIndex = matcher.end();
            matcherStr = input.substring(beginIndex, endIndex);
            if (matcherStr.startsWith("'") && !matcherStr.endsWith("'")) {
                buffer.append(input.substring(beginIndex, endIndex));
                startIndex = endIndex;
                continue;
            }
            String replacementString = null;
            if (!(matcher.group(7) == null && matcher.group(15) == null || matcher.group(13).matches("\\d+") || matcher.group(5).matches("\\d+"))) {
                String inputData = null;
                inputData = matcher.group(7) != null ? matcherStr : matcher.group(4);
                StringBuffer replaceBuffer = new StringBuffer(128);
                replaceBuffer.append(" ").append("~EXT~SB~PTRN~").append("(").append("'DAY' ").append("~DT~SB~PTRN~").append(" ").append("(").append(inputData).append(")").append(")");
                replacementString = matcherStr.replace(inputData, replaceBuffer.toString());
            } else {
                replacementString = matcherStr;
            }
            buffer.append(replacementString);
            startIndex = endIndex;
        }
        buffer.append(input.substring(endIndex));
        String output = buffer.toString();
        output = output.replace("~DT~SB~PTRN~", "from");
        output = output.replace("~EXT~SB~PTRN~", "EXTRACT");
        return output;
    }

    public String doMigrateTranslate(String input) throws MigrationServiceException {
        String output = input;
        Matcher matchTranslate = Pattern.compile("(?i)(translate\\s*\\()(.*?)\\)").matcher(output);
        String cols = "";
        ColumnSplitter splitter = new ColumnSplitter();
        StringBuffer sb = new StringBuffer();
        int startIdx = 0;
        int endIdx = 0;
        String pos1 = "";
        String pos2 = "";
        int indexTranslate = 0;
        List<String> colsLst = null;
        while (matchTranslate.find()) {
            if ((indexTranslate = QueryConversionUtility.getIndex(output, "TRANSLATE", indexTranslate)) != -1) {
                cols = QueryUtilityExt.doGetStringFromGivenIndex(indexTranslate, output);
                endIdx = indexTranslate + cols.length() - 1;
                cols = cols.substring(cols.indexOf("(") + 1, cols.lastIndexOf(")"));
            }
            sb.append(output.substring(startIdx, indexTranslate));
            colsLst = splitter.doGetAllColumns(cols);
            if (colsLst.size() == 1) {
                sb.append("UPPER(").append(cols).append("");
            } else if (colsLst.size() == 3) {
                pos1 = colsLst.get(1);
                pos2 = colsLst.get(2);
                sb.append(matchTranslate.group(1)).append(colsLst.get(0)).append(",").append(pos2).append(",").append("RPAD(").append(pos1).append(",").append("LENGTH(").append(pos2).append(")").append(",").append("''").append(")");
            } else if (colsLst.size() == 4) {
                pos1 = colsLst.get(1);
                pos2 = colsLst.get(2);
                sb.append(matchTranslate.group(1)).append(colsLst.get(0)).append(",").append(pos2).append(",").append("RPAD(").append(pos1).append(",").append("LENGTH(").append(pos2).append(")").append(",").append(colsLst.get(3)).append(")");
            } else {
                throw new MigrationServiceException("[DSC_ERR_001_001] " + MessageLoader.getMessage("DSC_ERR_001_001"));
            }
            startIdx = endIdx;
            indexTranslate = endIdx;
        }
        sb.append(output.substring(endIdx));
        output = sb.toString();
        return output;
    }

    private void printException(String fileName, List<String> outputList, String output, Exception e, String message) {
        ErrorLoggerUtility.failedQryCnt();
        ErrorLoggerUtility.failedFileCnt(fileName);
        logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " " + message);
        outputList.add(output);
    }
}

