/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.oracle;

import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.oracle.OracleBulkHandler;
import com.huawei.db.migration.oracle.OracleQueryKeywordReplacer;
import com.huawei.db.migration.oracle.OracleQueryKeywordReplacerExt;
import com.huawei.db.migration.oracle.OracleUtility;
import com.huawei.db.migration.services.OracleMigrationService;
import com.huawei.db.migration.util.ColumnSplitter;
import com.huawei.db.migration.util.FeatureLoader;
import com.huawei.db.migration.util.FeatureLoaderExtended;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.QueryConversionUtility;
import com.huawei.db.migration.util.QueryUtilityExt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Gauss100Preprocessor {
    private static final Pattern TABLE_NAME_PAT = Pattern.compile("(?i)select.*?from\\s+(\\w+\\.?\\w+\\@\\w+)");
    private static final Pattern TRUNCATE_PAT = Pattern.compile("(?i)truncate\\s+(\\w+)");
    private static final Pattern RPL_VERSION_PAT = Pattern.compile("(?i)(?<!\\w)(from\\s+(v\\$version)\\s+where\\s+(banner)\\s+like)(?!\\w)");
    private static final Pattern CONSTANT_PAT = Pattern.compile("(?i)(?<!\\w)create(?!\\w).*?(?<!\\w)(constant)(?!\\w).*?(?<!\\w)begin(?!\\w)");
    private static final Pattern STORAGE_PATTERN = Pattern.compile("(?i)(?<!\\w)(Storage\\s*\\(.*?\\))(?!\\w)");
    private static final Pattern PARTITION_MAXTRANS_PAT = Pattern.compile("(?i)(\\(\\s*(?<!\\w)partition(?!\\w).*?(?<!\\w)(MAXTRANS\\s*\\d*)(?!\\w).*\\))");
    private static final Pattern TABLESPACE_PAT = Pattern.compile("(?i)TABLESPACE\\s+(\\w+)");
    private static final Logger logger = LogManager.getLogger(Gauss100Preprocessor.class);
    private static ReentrantLock reentrantLock = new ReentrantLock();
    private static List<String> all_nologging = new ArrayList<String>();
    private static List<String> desired_nologging = new ArrayList<String>();
    private static List<String> desired_logging = new ArrayList<String>();

    static String doMigrateForGaussHundred(String input) throws MigrationServiceException {
        String output = input;
        output = Gauss100Preprocessor.doPreMigChanges(output);
        output = Gauss100Preprocessor.doMigrateDBMSLockAndExceptionInit(output);
        output = Gauss100Preprocessor.doMigrateAlter(output);
        output = Gauss100Preprocessor.doMigrateDate(output);
        LinkedHashMap<String, String> commentMap = new LinkedHashMap<String, String>(10);
        output = QueryConversionUtility.getSingleOrDoubleQuoteMap(output, commentMap, "/*", "\\/\\*.*?\\*\\/", "##COMMENT##");
        if (QueryConversionUtility.toLower(output = Gauss100Preprocessor.addTableToTruncate(output, commentMap)).contains("constant")) {
            output = Gauss100Preprocessor.doRemoveConstant(output);
        }
        output = Gauss100Preprocessor.doTablespaceNoLogging(output);
        if (QueryConversionUtility.toLower(output = QueryConversionUtility.getRplFromMap(output, commentMap, "(##COMMENT##\\d+#)")).contains("instance_number")) {
            output = Gauss100Preprocessor.doReplaceInstaceNumber(output);
        }
        if (QueryConversionUtility.containsCheck(output, "v$version")) {
            output = Gauss100Preprocessor.doRplVersionTable(output);
        }
        if (QueryConversionUtility.containsCheck(output, "gv$parameter")) {
            output = Gauss100Preprocessor.doRplParameterTable(output);
        }
        output = OracleQueryKeywordReplacer.doReplaceSystemUnsupportedParameter(output, input);
        HashMap<String, String> map = new HashMap<String, String>(10);
        output = QueryConversionUtility.getSingleQuoteMap(output, map);
        output = Gauss100Preprocessor.doCommentStorage(output);
        Gauss100Preprocessor.doAddColsDataTypeToMap(output);
        output = Gauss100Preprocessor.dbLinkForGaussdbt(output);
        output = QueryConversionUtility.getRplFromMap(output, map, "(##QUOTE##\\d+#)");
        map.clear();
        return output;
    }

    public static String dbLinkForGaussdbt(String input) {
        String output = input;
        String dbLinkConfigu = FeatureLoaderExtended.getStringProperty("dblink_table_mapping");
        String[] multilink = dbLinkConfigu.split(",");
        Matcher tblMatch = TABLE_NAME_PAT.matcher(output);
        String tableName = "";
        while (tblMatch.find()) {
            for (String dbLink : multilink) {
                String[] dataSource = (dbLink = dbLink.trim()).split(":");
                if (!dataSource[0].equalsIgnoreCase(tableName = tblMatch.group(1))) continue;
                output = output.replace(tableName, dataSource[1]);
            }
        }
        return output;
    }

    public static String addTableToTruncate(String input, Map<String, String> commentMap) {
        String output = input;
        if (QueryConversionUtility.containsCheck(output = QueryConversionUtility.getSingleDoubleQuoteMap(output, commentMap), "TRUNCATE")) {
            Matcher match = TRUNCATE_PAT.matcher(output);
            while (match.find()) {
                if ("table".equalsIgnoreCase(match.group(1))) continue;
                output = output.replace(match.group(1), "TABLE " + match.group(1));
            }
        }
        output = QueryConversionUtility.getRplFromMap(output, commentMap, "(##QUOTE##\\d+#)");
        return output;
    }

    public static void doAddColsDataTypeToMap(String output) {
        if (output.matches("(?i).*(?<!\\w)CREATE\\s+TABLE(?!\\w).*")) {
            String tableName = "";
            String tableColumns = "";
            Pattern tableColsPat = Pattern.compile("(?i).*CREATE\\s+.*?(?<!\\w)TABLE\\s+(\\w*\\.?\\w+)\\s*\\((.*)\\).*?;?");
            Matcher tableColsMat = tableColsPat.matcher(output);
            if (tableColsMat.find()) {
                tableName = tableColsMat.group(1).trim();
                tableColumns = tableColsMat.group(2).trim();
            }
            if (tableName != null && !tableName.isEmpty()) {
                Pattern columnDataTypePat = Pattern.compile("(?i)(\\w+)\\s+((?!null)\\w+(?:\\(.*?\\))?).*?,?");
                Matcher colDataTypeMat = columnDataTypePat.matcher(tableColumns);
                while (colDataTypeMat.find()) {
                    StringBuffer tableColumn = new StringBuffer();
                    String column = colDataTypeMat.group(1).trim();
                    String colDataType = colDataTypeMat.group(2).trim();
                    tableColumn.append(tableName).append(".").append(column).append("_").append("DATATYPE");
                    OracleMigrationService.addCreateTypeMap(QueryConversionUtility.toUpper(tableColumn.toString()), colDataType);
                }
            }
        }
    }

    private static String doRplParameterTable(String input) {
        String output = input;
        Pattern pattern = Pattern.compile("(?i)(?<!\\w)(select.*?from\\s*(GV\\$Parameter).*?(?:(name)\\s*\\=\\s*('SESSIONS'|'PROCESSES')))");
        Matcher matcherTable = pattern.matcher(output);
        StringBuffer buffer = new StringBuffer();
        StringBuffer replaceString = new StringBuffer();
        int endIndex = 0;
        int startIndex = 0;
        while (matcherTable.find()) {
            int beginIndex = matcherTable.start();
            buffer.append(output.substring(startIndex, beginIndex));
            endIndex = matcherTable.end();
            String matcherString = matcherTable.group();
            String tableString = matcherTable.group(2);
            replaceString.append("(").append(" ").append("select").append(" UPPER").append("(").append(matcherTable.group(3)).append(")").append(" AS ").append(matcherTable.group(3)).append(",").append("VALUE").append(",").append(" CAST(0 AS INTEGER) AS inst_id FROM v$parameter").append(")");
            buffer.append(matcherString.replace(tableString, replaceString));
            replaceString.setLength(0);
            startIndex = endIndex;
        }
        buffer.append(output.substring(endIndex));
        output = buffer.toString();
        output = output.replace("gv$parameter", " v$parameter ");
        return output;
    }

    private static String doRplVersionTable(String output) {
        String input = output;
        Matcher tableMatcher = RPL_VERSION_PAT.matcher(output);
        StringBuffer buffer = new StringBuffer();
        StringBuffer replaceString = new StringBuffer();
        int endIndex = 0;
        int startIndex = 0;
        while (tableMatcher.find()) {
            int beginIndex = tableMatcher.start();
            buffer.append(output.substring(startIndex, beginIndex));
            endIndex = tableMatcher.end();
            String matcherString = tableMatcher.group();
            String tableString = tableMatcher.group(2);
            replaceString.append("(").append("select").append(" VERSION AS ").append(tableMatcher.group(3)).append(" ").append("from").append(" ").append(tableMatcher.group(2)).append(" ").append(")");
            buffer.append(matcherString.replace(tableString, replaceString.toString()));
            replaceString.setLength(0);
            startIndex = endIndex;
        }
        buffer.append(input.substring(endIndex));
        return buffer.toString();
    }

    private static String doReplaceInstaceNumber(String output) {
        String input = output;
        input = input.replaceAll("(?i)(?<!\\w)(select(?!\\w).*?)(?<!\\w)(instance_number)(?!\\w)(.*?(?:v\\$instance))", "$1 instance_id $3");
        return input;
    }

    private static String doRemoveConstant(String output) {
        String input = output;
        Matcher matcher = CONSTANT_PAT.matcher(input);
        while (matcher.find()) {
            String matchergroup = matcher.group();
            String constantKey = matcher.group(1);
            constantKey = matchergroup.replaceAll(constantKey, " /* " + constantKey + " */ ");
            input = input.replace(matchergroup, constantKey);
        }
        return input;
    }

    public static String doPreMigChanges(String input) {
        String output = input;
        output = Gauss100Preprocessor.rplPrcttypeDBT(output);
        boolean migTaskType = OracleBulkHandler.isBulkHandlerFlag();
        if (!migTaskType) {
            output = Gauss100Preprocessor.doDotWithHash(output);
        }
        if (QueryConversionUtility.containsCheck(output = output.replaceAll("(?i)(?<!\\w)end\\s+(SUBTYPE.*?;)", "END"), "EDITIONABLE")) {
            output = output.replaceFirst("(?i)EDITIONABLE", "");
        }
        if (QueryConversionUtility.containsCheck(output, "parallel")) {
            output = Gauss100Preprocessor.commentParallel(output);
        }
        output = Gauss100Preprocessor.doKeywordOperation(output);
        output = output.replaceAll("(?i)(?<!\\w)pls_integer(?!\\w)", "INTEGER");
        output = output.replaceAll("(?i)(?<!\\w)(return)(?!\\w)\\s+(\\w+\\s+(?:\\>|\\<|\\=|\\>\\=|\\<\\=)\\s*\\d+)", "IF $2 THEN $1 TRUE; ELSE $1 FALSE; END IF");
        HashMap<String, String> map = new HashMap<String, String>(10);
        output = QueryConversionUtility.getSingleQuoteMap(output, map);
        output = output.replaceAll("(?i)(?<!\\w)(DETERMINISTIC)(?!\\w)", "/* $1 */");
        output = QueryConversionUtility.getRplFromMap(output, map, "(##QUOTE##\\d+#)");
        map.clear();
        output = Gauss100Preprocessor.doCommentEnable(output);
        return output;
    }

    private static String doKeywordOperation(String input) {
        String output = input;
        if (QueryConversionUtility.containsCheck(output, "pkg_type.refcur")) {
            output = output.replaceAll("(?i)(?<!\\w)pkg_type.refcur(?!\\w)", "sys_refcursor");
        }
        if (QueryConversionUtility.containsCheck(output = output.replaceAll("(?i)(?<!\\w)(INTEGER)\\s*\\(\\s*\\d+\\s*\\)", "$1"), "subpartition")) {
            output = output.replaceAll("(?i)(\\(\\s*(?<!\\w)subpartition(?!\\w).*?\\)|(?<!\\w)subpartition(?!\\w)\\s+by\\s+hash.*?(?<!\\w)subpartitions(?!\\w)\\s+\\w+)", "/* $1 */");
        }
        if (QueryConversionUtility.containsCheck(output, "nls_database_parameters")) {
            output = output.replaceAll("(?i)(?<!\\w)(nls_database_parameters.value%type)(?!\\w)", "VARCHAR2(60)");
            output = output.replaceAll("(?i)(?<!\\w)nls_database_parameters(?!\\w)", "nls_session_parameters");
        }
        if (QueryConversionUtility.containsCheck(output, "PCTFREE")) {
            output = Gauss100Preprocessor.rplPctfreeNumberIfZero(output);
        }
        if (QueryConversionUtility.containsCheck(output, "lob")) {
            output = Gauss100Preprocessor.doCommentLobClause(output);
        }
        if (QueryConversionUtility.containsCheck(output, "number")) {
            output = QueryConversionUtility.doReplaceSpecificGrp(output, "(?i)(?<!\\w)NUMBER(?!\\w)\\s*\\(\\s*(\\*)\\s*,\\s*\\d+\\s*\\)", "", "38", 1, false);
        }
        return output;
    }

    private static String doCommentEnable(String input) {
        String output = input;
        if (output.matches("(?i).*create\\s+(table|index|unique\\s+index).*")) {
            output = Gauss100Preprocessor.doCommentEnableInConstraints(output);
        }
        return output;
    }

    public static String rplPrcttypeDBT(String input) {
        String output = input;
        if (QueryConversionUtility.containsCheck(output, "%type") && FeatureLoaderExtended.getBooleanProperty("supportPkgSplitDBT")) {
            OracleUtility oracleUtil = new OracleUtility();
            output = Gauss100Preprocessor.replacePercentType(output, oracleUtil);
        } else {
            Matcher pkgVarComm = Pattern.compile("(?i)((?<!\\w)create\\s+or\\s+replace\\s+package\\s+body.*?(?<!\\w)(?:as|is))(.*?)(function|procedure)").matcher(output);
            String pkgVar = "";
            if (pkgVarComm.find() && !(pkgVar = pkgVarComm.group(2).trim()).isEmpty()) {
                output = output.replaceAll("(?i)((?<!\\w)create\\s+or\\s+replace\\s+package\\s+body.*?(?:as|is))(.*?)(function|procedure)", "$1 /* $2 */ $3");
            }
        }
        return output;
    }

    public static String doDotWithHash(String output) {
        Pattern patternType = Pattern.compile("(?i)(.*?(?<!\\w)declare|.*?(?<!\\w)(?:as|is)(?!\\w))(?!\\w)(.*?)((?<!\\w)begin(?!\\w).*)");
        Matcher matcherType = patternType.matcher(output);
        StringBuffer sb = new StringBuffer();
        if (matcherType.find()) {
            String header = matcherType.group(1);
            String declare = matcherType.group(2);
            String begin = matcherType.group(3);
            HashMap<String, String> quoteList = new HashMap<String, String>(5);
            begin = QueryConversionUtility.getSingleOrDoubleQuoteMap(begin, quoteList, "'", "\\'.*?\\'", "~#~~#~~");
            begin = Gauss100Preprocessor.doReplaceDotWithHash100(begin);
            begin = QueryConversionUtility.getRplFromMap(begin, quoteList, "(~#~~#~~\\d+#)");
            sb.append(header).append(declare).append(begin);
            return sb.toString();
        }
        return output;
    }

    public static String replacePercentType(String output, OracleUtility oracleUtil) {
        StringBuffer sb = new StringBuffer();
        Pattern patternType = Pattern.compile("(?i)(.*?(?<!\\w)declare|.*?(?<!\\w)(?:as|is)(?!\\w))(?!\\w)(.*?)((?<!\\w)begin(?!\\w).*)");
        Matcher matcherType = patternType.matcher(output);
        if (matcherType.find()) {
            String header = matcherType.group(1);
            String declare = matcherType.group(2);
            String begin = matcherType.group(3);
            if (!QueryConversionUtility.containsCheck(header, "declare")) {
                declare = oracleUtil.doRplPercentageType(declare, "");
            }
            sb.append(header).append(declare).append(begin);
        }
        return sb.toString();
    }

    public static String doReplaceDotWithHash100(String input) {
        String output = input;
        String pkg = null;
        String pkgReplacement = null;
        Map<String, String> packageMap = OracleMigrationService.getPackageNameMap();
        for (Map.Entry<String, String> pckgNameMap : packageMap.entrySet()) {
            pkg = pckgNameMap.getKey();
            pkgReplacement = pckgNameMap.getValue().trim();
            if (!FeatureLoaderExtended.getBooleanProperty("supportPkgSplitDBT") && (FeatureLoaderExtended.getBooleanProperty("supportPkgSplitDBT") || !QueryConversionUtility.containsCheck(pkgReplacement, "SYS_REFCURSOR"))) continue;
            output = QueryConversionUtility.doReplaceExactStr(QueryConversionUtility.santizePattern(pkg), pkgReplacement, output);
        }
        return output;
    }

    public static String doMigrateDBMSLockAndExceptionInit(String input) {
        Matcher pragnaMatcher;
        String output = input;
        if (QueryConversionUtility.containsCheck(output, "dbms_lock.release")) {
            output = output.replaceAll("(?i)(?<!\\w)dbms_lock.release(?!\\w)", "Release_Lock");
        }
        if (QueryConversionUtility.containsCheck(output, "dbms_lock.request")) {
            output = output.replaceAll("(?i)(?<!\\w)dbms_lock.request(?!\\w)", "Get_Lock");
        }
        if (QueryConversionUtility.containsCheck(output, "exception_init") && (pragnaMatcher = Pattern.compile("(?i).*(?<!\\w)pragma(?!\\w)\\s+(?<!\\w)exception_init(?!\\w)\\s*\\(.*?(\\-)\\d+\\s*\\).*").matcher(output)).find()) {
            output = output.replaceAll(pragnaMatcher.group(1), "");
        }
        return output;
    }

    public static String doMigrateAlter(String input) {
        String output = input;
        if (!output.matches("(?i).*(?<!\\w)alter\\s+session(?!\\w).*")) {
            output = Gauss100Preprocessor.doCommentUnsupportedKeywordsGauss100(output);
        }
        if (output.matches("(?i)alter\\s+table.*?;")) {
            output = output.replaceAll("(?i)((?<!\\w)(maxtrans)(?!\\w)(?:\\s+\\d+)?)", "/* $1 */");
        }
        return output;
    }

    private static String doCommentStorage(String input) {
        String output = input;
        Matcher storageMatcher = STORAGE_PATTERN.matcher(output);
        StringBuffer sb = new StringBuffer();
        int indexStoarage = 0;
        int startIdx = 0;
        int endIdx = 0;
        while (storageMatcher.find()) {
            indexStoarage = QueryConversionUtility.getIndex(output, "storage", indexStoarage);
            sb.append(output.substring(startIdx, indexStoarage));
            if (indexStoarage != -1) {
                String storageString = QueryUtilityExt.doGetStringFromGivenIndex(indexStoarage, output);
                endIdx = indexStoarage + storageString.length();
                sb.append("/*").append(storageString).append("*/");
            }
            startIdx = endIdx;
            indexStoarage = endIdx;
        }
        sb.append(output.substring(endIdx));
        output = sb.toString();
        return output;
    }

    public static String doMigrateDate(String input) {
        String output = input;
        if ((output = output.replaceAll("SYYYY-MM-DD", "YYYY-MM-DD")).contains("\u4e0b\u5348") || output.contains("\u6708") || output.contains("\u4e0a\u5348")) {
            output = output.replace("\u4e0b\u5348", "PM");
            output = output.replace("\u4e0a\u5348", "AM");
            output = output.replace("\u6708", "").trim();
            output = Gauss100Preprocessor.changeDateFormat(output.trim());
        }
        output = OracleQueryKeywordReplacerExt.checkdoSupportTwoArgsDate(output);
        return output;
    }

    static String rplPctfreeNumberIfZero(String input) {
        Pattern pctfreeNumber = Pattern.compile("(?i)((?<!\\w)pctfree(?!\\w)\\s+(\\d+))");
        Matcher pctfreeNumberMatcher = pctfreeNumber.matcher(input);
        String pctnumber = "";
        while (pctfreeNumberMatcher.find()) {
            pctnumber = pctfreeNumberMatcher.group(1).trim();
            if (!pctnumber.matches("(?i)((?<!\\w)pctfree(?!\\w)\\s+(\\d+))")) continue;
            String pctnumberStr = pctfreeNumberMatcher.group(2).trim();
            int number = Integer.parseInt(pctnumberStr);
            if (number > 80) {
                input = input.replace(pctnumber, "PCTFREE 80");
                continue;
            }
            if (number >= 8) continue;
            input = input.replace(pctnumber, "PCTFREE 8");
        }
        return input;
    }

    private static String commentParallel(String output) {
        Pattern parallelComm = Pattern.compile("(?i)(?<!\\w)parallel(?!\\w)\\s*(?:\\(.*?\\)|\\d+)");
        Matcher parallelCommMatcher = parallelComm.matcher(output);
        int startIdx = 0;
        StringBuffer sb = new StringBuffer();
        while (parallelCommMatcher.find()) {
            String parallelKey = parallelCommMatcher.group();
            String parallelKeyCommemt = "/*" + parallelKey + "*/";
            int tempIdx = parallelCommMatcher.start();
            int endIdx = parallelCommMatcher.end();
            sb.append(output.substring(startIdx, tempIdx));
            sb.append(parallelKeyCommemt);
            startIdx = endIdx;
        }
        sb.append(output.substring(startIdx));
        return sb.toString();
    }

    private static String doCommentUnsupportedKeywordsGauss100(String inputQry) {
        Pattern segmentPattern = Pattern.compile("(?i)(?<!\\w)(?:SEGMENT\\s+CREATION\\s+IMMEDIATE|SEGMENT\\s+CREATION\\s+DEFERRED|PCTUSED(?!\\s+STORAGE\\s+IN\\s+ROW)|CACHE\\s+READS|CACHE|COMPUTE\\s+STATISTICS)(?!\\w)(?:\\s+\\d+)?");
        Matcher segmentMatcher = segmentPattern.matcher(inputQry);
        int temp = 0;
        StringBuffer outbuff = new StringBuffer();
        while (segmentMatcher.find()) {
            int start = segmentMatcher.start();
            int end = segmentMatcher.end();
            String segment = segmentMatcher.group();
            outbuff.append(inputQry.substring(temp, start));
            String segmentWithCmnt = "/*" + segment + "*/";
            outbuff.append(segmentWithCmnt);
            temp = end;
        }
        outbuff.append(inputQry.substring(temp));
        return outbuff.toString();
    }

    private static String doCommentLobClause(String inputVal) {
        String input = inputVal;
        Pattern pattern = Pattern.compile("(?i)(?<!\\w)Lob\\s+\\(.*?\\)\\s+STORE");
        Pattern lobUnsuppoertedKeywords = Pattern.compile("(?i)(?<!\\w)(?:NOCACHE|RETENTION|CHUNK|LOGGING|NOCOMPRESS|NOLOGGING)(?!\\w)(?:\\s+\\d+)?");
        Matcher matcher = pattern.matcher(input);
        int startIdx = 0;
        int endIndex = 0;
        StringBuffer sb = new StringBuffer();
        int lobCount = 0;
        while (matcher.find()) {
            if (lobCount > 0) {
                startIdx = matcher.start();
            }
            endIndex = matcher.end();
            sb.append(input.substring(startIdx, endIndex));
            String column = QueryConversionUtility.doGetReplaceString(input.substring(endIndex));
            column = Gauss100Preprocessor.commentColsInLob(lobUnsuppoertedKeywords, endIndex, column);
            sb.append(column);
            ++lobCount;
        }
        if (sb.length() > 0) {
            sb.append(";");
            input = sb.toString();
        }
        return input;
    }

    private static String commentColsInLob(Pattern lobUnsuppoertedKeywords, int endIndex, String column) {
        Matcher lobMatch = lobUnsuppoertedKeywords.matcher(column);
        StringBuffer sb = new StringBuffer();
        int startIdx = 0;
        while (lobMatch.find()) {
            String keyword = lobMatch.group();
            int tempIdx = lobMatch.start();
            int endIdx = lobMatch.end();
            sb.append(column.substring(startIdx, tempIdx));
            String keywordWC = "/*" + keyword + "*/";
            sb.append(keywordWC);
            startIdx = endIdx;
        }
        sb.append(column.substring(startIdx));
        return sb.toString();
    }

    private static String doCommentMaxtran(String input) {
        String output = input;
        Matcher matcher = PARTITION_MAXTRANS_PAT.matcher(output);
        StringBuffer buffer = new StringBuffer();
        String matcherGrp = null;
        String matcherGrp2 = null;
        int endIndex = 0;
        int startIndex = 0;
        while (matcher.find()) {
            int beginIndex = matcher.start();
            buffer.append(output.substring(startIndex, beginIndex));
            endIndex = matcher.end();
            matcherGrp = matcher.group(1);
            matcherGrp2 = matcher.group(2);
            buffer.append(matcherGrp.replaceAll(matcherGrp2, "/*" + matcherGrp2 + "*/"));
            startIndex = endIndex;
        }
        buffer.append(input.substring(endIndex));
        return buffer.toString();
    }

    private static String changeDateFormat(String inputQuery) {
        String output = inputQuery;
        Pattern pattern = Pattern.compile("(?i)(?:\\d{2}|\\d{4})\\s*\\-\\s*\\d{1,2}\\s*\\-\\s*\\d{1,2}\\s+((\\d{2})\\.\\d{1,2}\\.\\d{1,2})\\.\\d+\\s+(am|pm)");
        Matcher matcher = pattern.matcher(output);
        StringBuffer buffer = new StringBuffer();
        int endIndex = 0;
        int startIndex = 0;
        while (matcher.find()) {
            int beginIndex = matcher.start();
            buffer.append(output.substring(startIndex, beginIndex));
            endIndex = matcher.end();
            String matcherFullGrp = matcher.group();
            String timeStampGrp = matcher.group(1);
            String hours = matcher.group(2);
            String amPmCheck = matcher.group(3);
            String temp = timeStampGrp;
            if ("PM".equalsIgnoreCase(amPmCheck)) {
                Integer hour = Integer.parseInt(hours) + 12;
                timeStampGrp = timeStampGrp.replace(hours, hour.toString());
            }
            matcherFullGrp = matcherFullGrp.replace(temp, timeStampGrp.replace(".", ":")).replace(amPmCheck, "");
            buffer.append(matcherFullGrp.trim());
            startIndex = endIndex;
        }
        buffer.append(output.substring(endIndex));
        return buffer.toString();
    }

    private static String doCommentEnableInConstraints(String input) {
        String output = input;
        String partialInput = QueryUtilityExt.doGetStringFromGivenIndex(0, output);
        String restofInput = output.substring(partialInput.length(), output.length());
        if (QueryConversionUtility.containsCheck(restofInput, "partition ")) {
            if (QueryConversionUtility.containsCheck(output, "MAXTRANS ")) {
                restofInput = Gauss100Preprocessor.doCommentMaxtran(restofInput);
            }
            restofInput = QueryConversionUtility.doReplaceSpecificGrp(restofInput, "(?i)(?<!\\w)(COMPRESS\\s+BASIC|NOCOMPRESS|COMPRESS|NOLOGGING|LOGGING)(?!\\w)", "/*", "*/", 0, true);
        } else {
            restofInput = restofInput.replaceAll("(?i)((?<!\\w)(maxtrans)(?!\\w)(?:\\s+\\d+)?)", "/* $1 */");
        }
        Pattern pattern = Pattern.compile("(?i)((.*create\\s+table.*?\\())(.*)(\\).*)");
        Matcher matcher = pattern.matcher(partialInput);
        String createTab = null;
        String columns = null;
        String restQry = null;
        if (matcher.find()) {
            createTab = matcher.group(2);
            columns = matcher.group(3);
            restQry = matcher.group(4);
            partialInput = Gauss100Preprocessor.colCheckForEnableKeyword(createTab, columns, restQry);
        }
        return partialInput + " " + restofInput;
    }

    private static String colCheckForEnableKeyword(String createTab, String columns, String restQry) {
        StringBuffer outBuf = new StringBuffer();
        ColumnSplitter splitter = new ColumnSplitter();
        List<String> colList = splitter.doGetAllColumns(columns);
        String tempColumn = null;
        outBuf.append(createTab);
        StringBuffer colBuf = new StringBuffer();
        int counter = 0;
        for (String col : colList) {
            tempColumn = col.replaceAll("(?i)\\s+(ENABLE)\\s*", "/*$1*/");
            colBuf.append(tempColumn);
            if (!tempColumn.startsWith("/*") || counter != 0) {
                colBuf.append(",");
            }
            ++counter;
        }
        colBuf = colBuf.charAt(colBuf.length() - 1) == ',' ? colBuf.deleteCharAt(colBuf.length() - 1) : colBuf;
        outBuf.append(colBuf);
        outBuf.append(restQry);
        String output = outBuf.toString();
        return output;
    }

    private static String doTablespaceNoLogging(String input) throws MigrationServiceException {
        String output = input;
        if (output.matches("(?i).*(?<!\\w)CREATE(?!\\w).*?(?<!\\w)TABLE(?!\\w).*?;")) {
            boolean isLogging;
            Gauss100Preprocessor.initializeLoggingList();
            boolean bl = isLogging = !input.matches("(?i).*(?<!\\w)NOLOGGING(?!\\w).*");
            if (desired_nologging.size() < 2 && !isLogging && logger.isInfoEnabled()) {
                throw new MigrationServiceException("[DSC_ERR_002_011] " + MessageLoader.getMessage("DSC_ERR_002_011"));
            }
            Matcher matcher = TABLESPACE_PAT.matcher(output);
            String tablespace = null;
            while (matcher.find()) {
                tablespace = matcher.group(1);
                output = Gauss100Preprocessor.replaceTablespace(output, isLogging, tablespace);
            }
            if (tablespace == null) {
                output = Gauss100Preprocessor.replaceNoTablespace(output, isLogging);
            }
        }
        return output;
    }

    private static void initializeLoggingList() {
        reentrantLock.lock();
        try {
            if (all_nologging.size() == 0) {
                all_nologging = Gauss100Preprocessor.getConfigList("all_nologging_tablespaces");
            }
            if (desired_nologging.size() == 0) {
                desired_nologging = Gauss100Preprocessor.getConfigList("desired_data_index_nolog_tablespace");
            }
            if (desired_logging.size() == 0) {
                desired_logging = Gauss100Preprocessor.getConfigList("desired_data_index_log_tablespace");
            }
        }
        finally {
            reentrantLock.unlock();
        }
    }

    private static String replaceTablespace(String input, boolean isLogging, String tablespace) {
        String output = input;
        if (!isLogging) {
            if (!all_nologging.contains(tablespace) && output.matches(".*(?<!\\w)" + tablespace + "(?!\\w).*")) {
                output = output.replaceAll("(?i)(?<!\\w)" + tablespace + "(?!\\w)", desired_nologging.get(0));
            }
        } else if (all_nologging.contains(tablespace) && output.matches(".*(?<!\\w)" + tablespace + "(?!\\w).*") && desired_logging.size() == 2) {
            output = output.replaceAll("(?i)(?<!\\w)" + tablespace + "(?!\\w)", desired_logging.get(0));
        }
        return output;
    }

    private static String replaceNoTablespace(String input, boolean isLogging) {
        String output = input;
        if (!isLogging) {
            if (desired_nologging.size() == 2) {
                output = output.replaceAll("(?i)(?<!\\w)(NOLOGGING)(?!\\w)", "tablespace " + desired_nologging.get(0) + " $1");
            }
        } else if (desired_logging.size() == 2) {
            output = output.replaceAll(";\\s*$", "tablespace " + desired_logging.get(0) + ";");
        }
        return output;
    }

    private static List<String> getConfigList(String param) {
        String value = FeatureLoader.getStringProperty(param);
        String[] valArray = value.split(",");
        return Arrays.stream(valArray).map(str -> str.trim()).collect(Collectors.toList());
    }
}

