/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.oracle;

import com.huawei.db.migration.database.bo.IBulkSplitPatternsBO;
import com.huawei.db.migration.database.bo.IQueryPatternsBO;
import com.huawei.db.migration.database.bo.IQuerySplitterPatternsBO;
import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.interfaces.IMigrationTaskService;
import com.huawei.db.migration.oracle.OracleQueryMigrationService;
import com.huawei.db.migration.oracle.OracleSchemaMigrationService;
import com.huawei.db.migration.services.OracleMigrationService;
import com.huawei.db.migration.util.FeatureLoader;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.ProgressUtil;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OracleBLogicDDLHandler {
    private static final Pattern NEXT_CURR_VAL_PAT = Pattern.compile("(?i)(MIG_ORA_EXT\\.)?(NEXTVAL|CURRVAL)\\(\\s*\\'(.*?)\\'\\s*\\)");
    private static final Pattern ROW_TYPE_PAT = Pattern.compile("(?i)(?<!\\w)(?:IN|OUT|RETURN)\\s+((\\w*\\.?\\w+)%rowtype(?!\\w))");
    private static final Pattern COMMENT_PATTERN = Pattern.compile("\\/\\*.*?\\*\\/");
    private static final Pattern PROC_FINDER_PAT = Pattern.compile("(?i)(?<!\\w)(?:PROCEDURE|FUNCTION)(?!\\w)(.*?)\\(");
    private static final Pattern PROCEDURE_PAT = Pattern.compile("(?i)PROCEDURE(.*?)\\(");
    private List<IQueryPatternsBO> queryPatterns;
    private List<IQuerySplitterPatternsBO> querySplitterPatterns;
    private List<IQueryPatternsBO> schemaPatterns;
    private List<IBulkSplitPatternsBO> bLogicSplitter;

    public OracleBLogicDDLHandler() {
        this(null, null, null, null);
    }

    public OracleBLogicDDLHandler(List<IQueryPatternsBO> queryPatterns, List<IQuerySplitterPatternsBO> querySplitterPatterns, List<IQueryPatternsBO> schemaPatterns, List<IBulkSplitPatternsBO> bLogicSplitter) {
        this.queryPatterns = queryPatterns;
        this.querySplitterPatterns = querySplitterPatterns;
        this.schemaPatterns = schemaPatterns;
        this.bLogicSplitter = bLogicSplitter;
    }

    public String doMigrateDBObjects(String fileName, int position, String inputQuery, IBulkSplitPatternsBO typeBO) throws MigrationServiceException {
        String output = inputQuery;
        String taskName = typeBO.getName();
        Matcher matcher = null;
        LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
        switch (taskName) {
            case "DMLPattern": {
                output = this.dmlPattern(fileName, position, typeBO, output, quoteMap);
                break;
            }
            case "View with Query": {
                Map<String, String> queryMap = new LinkedHashMap<String, String>(10);
                String tempOutput = inputQuery;
                if (tempOutput.contains(".")) {
                    matcher = Pattern.compile("(?i)create.*?(?<!\\w)view(?!\\w)\\s+(?:(\\w*|\".*?\")\\.)?\\s*\\w+.*?(?:;|;\\s*\\/)").matcher(tempOutput);
                    tempOutput = this.qryToMap(queryMap, matcher, inputQuery);
                }
                queryMap = QueryConversionUtility.doMigrateSchemaQueries(fileName, this.queryPatterns, this.querySplitterPatterns, queryMap, new OracleQueryMigrationService());
                String outputSQL = QueryConversionUtility.doReplaceFunctionVariables(tempOutput, queryMap, "##QUERY##");
                if ((outputSQL = outputSQL.trim()).matches("(?i).*CREATE\\s+(?:OR\\s+REPLACE\\s+)?VIEW.*?SELECT.*.*")) {
                    outputSQL = outputSQL.replaceAll("(?i)(CREATE\\s+(?:OR\\s+REPLACE\\s+)?VIEW.*?SELECT.*?;)(\\s*\\/?)", "$1");
                } else if (!outputSQL.isEmpty() && outputSQL.charAt(outputSQL.length() - 1) == '/') {
                    outputSQL = outputSQL.substring(0, outputSQL.length() - 1);
                }
                output = outputSQL;
                break;
            }
        }
        return output;
    }

    private String qryToMap(Map<String, String> queryMap, Matcher matcher, String inputQuery) {
        String output = inputQuery;
        String schemaViewName = "";
        int queryCnt = 1;
        while (matcher.find()) {
            schemaViewName = matcher.group(1);
            String matcherQuery = matcher.group();
            LinkedHashMap<String, String> tempMap = new LinkedHashMap<String, String>(10);
            String queryStr = QueryConversionUtility.doGetSchemaQueries(matcherQuery, tempMap, queryCnt);
            for (Map.Entry<String, String> querySet : tempMap.entrySet()) {
                LinkedHashMap<String, String> unionMap;
                String outputQry = null;
                String placeHolder = querySet.getKey();
                String query = querySet.getValue();
                if (QueryConversionUtility.unionSplitter(query, unionMap = new LinkedHashMap<String, String>(10), 0)) {
                    StringBuffer unionQry = new StringBuffer();
                    for (Map.Entry singleQuery : unionMap.entrySet()) {
                        String unionTemp = ((String)singleQuery.getKey()).replaceFirst("#\\d+#", "");
                        unionTemp = this.addSchema2Queries(schemaViewName, unionTemp);
                        unionQry.append(" ").append(unionTemp).append(" ").append((String)singleQuery.getValue()).append(" ");
                    }
                    outputQry = unionQry.toString();
                } else {
                    outputQry = this.addSchema2Queries(schemaViewName, query);
                }
                queryMap.put(placeHolder, outputQry);
                ++queryCnt;
            }
            output = output.replace(matcherQuery, queryStr);
        }
        return output;
    }

    private String dmlPattern(String fileName, int position, IBulkSplitPatternsBO typeBO, String outputVal, Map<String, String> quoteMap) {
        String output = outputVal;
        Pattern pattern = Pattern.compile(typeBO.getFinderPattern(), 2);
        Matcher matcher = pattern.matcher(output);
        while (matcher.find()) {
            boolean flag = true;
            String tempQuery = matcher.group(2);
            String group = matcher.group();
            String subGrp = group.replace(tempQuery, "");
            if (tempQuery.startsWith("'") && tempQuery.matches(".*?(\\'{1,})\\s*;")) {
                String tempQueryWithoutQuote = tempQuery.substring(1, tempQuery.lastIndexOf("'"));
                if (!subGrp.matches("(?i).*(?<!\\w)execute\\s+(#S#\\d+#E#\\s*)?immediate\\s*(#S#\\d+#E#\\s*)?$") || subGrp.matches("(?i).*(?<!\\w)execute\\s+(#S#\\d+#E#\\s*)?immediate\\s*(#S#\\d+#E#\\s*)?$") && (QueryConversionUtility.containsCheck(tempQuery, "||") || QueryConversionUtility.finderGroup(tempQueryWithoutQuote, "(?<!')'(?!')", 0) != null)) {
                    flag = false;
                }
            } else {
                boolean sCondition;
                boolean fCondition = subGrp.trim().endsWith("$q$") && !subGrp.matches("(?i).*(?<!\\w)execute\\s+(#S#\\d+#E#\\s*)?immediate\\s*(#S#\\d+#E#\\s*)?\\$q\\$\\s*$");
                boolean bl = sCondition = tempQuery.startsWith("'") && !tempQuery.matches(".*\\'{1,}\\s*;") && QueryConversionUtility.containsCheck(tempQuery, "||");
                if (fCondition || sCondition) {
                    flag = false;
                }
            }
            Map<String, String> partTable = OracleMigrationService.getCreateTypeMap();
            String tableName = QueryConversionUtility.getTableName(tempQuery).trim();
            for (Map.Entry<String, String> entry : partTable.entrySet()) {
                String type = entry.getKey();
                String val = entry.getValue();
                if (!type.equalsIgnoreCase(tableName) || !val.equalsIgnoreCase("list")) continue;
                output = this.commentNonPartitionTable(output, tempQuery, tableName);
                break;
            }
            if (flag) {
                String outputSQL = this.doProcessQrySchema(fileName, position, tempQuery);
                outputSQL = this.getOutSql(tempQuery, outputSQL);
                output = output.replace(tempQuery, outputSQL);
            }
            ProgressUtil.printProgress();
        }
        return output;
    }

    public String getOutSql(String tempQuery, String input) {
        String outputSQL = input;
        if (tempQuery.startsWith(" ") && !outputSQL.startsWith(" ")) {
            outputSQL = " " + outputSQL;
        }
        return outputSQL;
    }

    public String commentNonPartitionTable(String input, String tempQuery, String tableName) {
        String output = input;
        LinkedHashMap<String, String> commentMap = new LinkedHashMap<String, String>(10);
        output = QueryConversionUtility.getSingleOrDoubleQuoteMap(output, commentMap, "/*", "\\/\\*.*?\\*\\/", "##COMMENT##");
        if (!(QueryConversionUtility.isExactMatch(tempQuery, "table") && QueryConversionUtility.containsCheck(tempQuery, "range") && QueryConversionUtility.containsCheck(tempQuery, "partition") || !QueryConversionUtility.containsCheck(tempQuery, "ALTER "))) {
            Pattern pat = Pattern.compile("(?i)execute\\s+immediate\\s*\\'\\s*alter\\s+table.*?truncate\\s+partition(.*?);");
            Matcher match = pat.matcher(output);
            String altTable = "";
            String partName = "";
            StringBuffer sb = new StringBuffer();
            int startIdx = 0;
            int tempIdx = 0;
            while (match.find()) {
                altTable = match.group();
                partName = match.group(1);
                if (!altTable.contains("||")) {
                    partName = partName.replace("'", "").trim();
                }
                tempIdx = match.start();
                sb.append(output.substring(startIdx, tempIdx));
                sb.append("/*").append(altTable).append("*/");
                startIdx = match.end();
                Map<String, String> partTable = OracleMigrationService.getCreateTypeMap();
                this.tableWithoutConcat(tableName, partTable, altTable, partName, sb);
                this.tableWithConcat(tableName, partTable, altTable, partName, sb);
            }
            sb.append(output.substring(startIdx));
            output = sb.toString();
        }
        output = QueryConversionUtility.getRplFromMap(output, commentMap, "(##COMMENT##\\d+#)");
        return output;
    }

    public void tableWithConcat(String tableName, Map<String, String> partTable, String altTable, String partName, StringBuffer sb) {
        ArrayList<String> list = new ArrayList<String>();
        String join = "";
        int count = 0;
        if (altTable.contains("||")) {
            String type = "";
            String valName = "";
            for (Map.Entry<String, String> entry : partTable.entrySet()) {
                String typeName = entry.getKey();
                if (!typeName.equalsIgnoreCase(tableName + "_name")) continue;
                valName = entry.getValue();
            }
            for (Map.Entry<String, String> entry : partTable.entrySet()) {
                type = entry.getKey();
                if (!type.endsWith("_PARTITION_NAME")) continue;
                String value = "";
                ++count;
                type = type.replace("_PARTITION_NAME", "");
                value = entry.getValue();
                if (value.contains("DEFAULT")) continue;
                if (count == 1) {
                    sb.append("IF '").append(partName).append(" = '").append(type).append("' THEN DELETE FROM ").append(tableName).append(" WHERE ").append(valName).append(" IN ").append(value).append(";\n");
                } else {
                    sb.append("ELSIF '").append(partName).append(" = '").append(type).append("' THEN DELETE FROM ").append(tableName).append(" WHERE ").append(valName).append(" IN ").append(value).append(";\n");
                }
                value = value.replace("(", "");
                value = value.replace(")", "");
                list.add(value);
            }
            join = String.join((CharSequence)",", list);
            sb.append("ELSE DELETE FROM ").append(tableName).append(" WHERE ").append(valName).append(" NOT IN (").append(join).append(");");
            sb.append("END IF;");
        }
    }

    public void tableWithoutConcat(String tableName, Map<String, String> partTable, String altTable, String partName, StringBuffer sb) {
        if (!altTable.contains("||")) {
            String valName = "";
            String value = "";
            for (Map.Entry<String, String> entry : partTable.entrySet()) {
                String type;
                String typeName = entry.getKey();
                if (typeName.equalsIgnoreCase(tableName + "_name")) {
                    valName = entry.getValue();
                }
                if (!(type = entry.getKey()).equalsIgnoreCase(partName + "_PARTITION_NAME")) continue;
                value = entry.getValue();
            }
            if (!valName.isEmpty() && !value.isEmpty()) {
                sb.append("DELETE FROM " + tableName + " WHERE " + valName + " IN" + value + ";");
            }
        }
    }

    private String doProcessQrySchema(String fileName, int position, String input) throws MigrationServiceException {
        int lastIndex;
        boolean isExcludePatternValidation = false;
        String migrationType = "";
        String output = input;
        boolean isExeImmediate = false;
        boolean isExeImmedStart = false;
        String quotes = "";
        for (IBulkSplitPatternsBO identifierBO : this.bLogicSplitter) {
            Pattern pattern;
            Matcher matcher;
            isExcludePatternValidation = QueryConversionUtility.excludePatternValidation(identifierBO.getExcludePattern(), input);
            if (!isExcludePatternValidation || !(matcher = (pattern = Pattern.compile(identifierBO.getFinderPattern(), 2)).matcher(input)).find()) continue;
            migrationType = identifierBO.getName();
            break;
        }
        if (output.startsWith("'") && output.matches(".*?(\\'{1,})\\s*;")) {
            isExeImmediate = true;
            int idx = 0;
            Pattern quotePat = Pattern.compile(".*?(\\'{1,})\\s*;");
            Matcher quoteMatch = quotePat.matcher(output);
            while (quoteMatch.find()) {
                idx = quoteMatch.start(1);
                quotes = quoteMatch.group(1);
            }
            output = output.substring(1, idx);
        }
        if (output.startsWith("'") && !output.matches(".*\\'{1,}\\s*;") && (lastIndex = output.lastIndexOf("'")) != -1) {
            isExeImmedStart = true;
            quotes = output.substring(lastIndex);
            output = output.substring(1, lastIndex);
        }
        output = this.doCallMigrationTypeService(migrationType, output, fileName, position);
        if (isExeImmediate || isExeImmedStart) {
            output = this.doHandleNextValInExecuteImmediate(output);
            output = "'" + output.trim() + quotes;
            output = isExeImmediate ? output + ";" : output;
        }
        return output;
    }

    private String doHandleNextValInExecuteImmediate(String outputVal) {
        String output = outputVal;
        if (QueryConversionUtility.containsCheck(output, "CURRVAL") || QueryConversionUtility.containsCheck(output, "NEXTVAL")) {
            Matcher matcher = NEXT_CURR_VAL_PAT.matcher(output);
            StringBuffer sb = new StringBuffer();
            int tempIndex = 0;
            while (matcher.find()) {
                String group = matcher.group();
                int startIndex = matcher.start();
                sb.append(output.substring(tempIndex, startIndex));
                group = QueryConversionUtility.replaceAll(group, "(?i)(\\('\\s*)", "($q$");
                group = QueryConversionUtility.replaceAll(group, "(?i)(\\s*'\\))", "$q$)");
                sb.append(group);
                tempIndex = matcher.end();
            }
            sb.append(output.substring(tempIndex));
            output = sb.toString();
        }
        return output;
    }

    private String doCallMigrationTypeService(String migrationtype, String inputSql, String fileName, int position) throws MigrationServiceException {
        int queryCnt = 0;
        String outputSQL = inputSql;
        StringBuffer inputQuery = new StringBuffer(inputSql);
        inputQuery.append("~#~").append(position);
        IMigrationTaskService objTaskService = null;
        switch (migrationtype) {
            case "Query": {
                objTaskService = new OracleQueryMigrationService();
                outputSQL = objTaskService.handleMigrationTask(inputQuery.toString(), fileName, this.queryPatterns, this.querySplitterPatterns);
                break;
            }
            case "Schema": {
                objTaskService = new OracleSchemaMigrationService();
                outputSQL = objTaskService.handleMigrationTask(inputQuery.toString(), fileName, this.schemaPatterns, this.querySplitterPatterns);
                break;
            }
            case "Schema with Query": {
                Map<String, String> queryMap = new LinkedHashMap<String, String>(10);
                String input = QueryConversionUtility.doGetSchemaQueries(inputQuery.toString(), queryMap, queryCnt);
                objTaskService = new OracleSchemaMigrationService();
                outputSQL = objTaskService.handleMigrationTask(input, fileName, this.schemaPatterns, this.querySplitterPatterns);
                queryMap = QueryConversionUtility.doMigrateSchemaQueries(fileName, this.queryPatterns, this.querySplitterPatterns, queryMap, new OracleQueryMigrationService());
                outputSQL = QueryConversionUtility.doReplaceFunctionVariables(outputSQL, queryMap, "##QUERY##");
                break;
            }
            default: {
                throw new MigrationServiceException("[DSC_ERR_004_023] " + MessageLoader.getMessage("DSC_ERR_004_023") + "." + " " + fileName + " " + MessageLoader.getMessage("queryPosInfo") + position);
            }
        }
        if (outputSQL.contains("~#~")) {
            outputSQL = outputSQL.split("~#~")[0];
        }
        return outputSQL;
    }

    private String addSchema2Queries(String schemaViewName, String query) {
        if (schemaViewName == null) {
            return query;
        }
        Pattern fromPattern = Pattern.compile("(?i)(.*)(?<!\\w)from(?!\\w)(.*?)((?<!\\w)where(?!\\w).*|$)");
        Matcher fromMatcher = fromPattern.matcher(query);
        StringBuffer outputQry = new StringBuffer(query);
        if (fromMatcher.find()) {
            outputQry = new StringBuffer(fromMatcher.group(1));
            String[] tableSplit = fromMatcher.group(2).split("\\s*,\\s*");
            String table = null;
            outputQry.append(" ").append("from").append(" ");
            String whereClause = fromMatcher.group(3);
            for (int iIndex = 0; iIndex < tableSplit.length; ++iIndex) {
                table = tableSplit[iIndex].trim();
                table = this.addSchemaViewName(table, schemaViewName);
                outputQry.append(table).append(",");
            }
            outputQry.deleteCharAt(outputQry.length() - 1);
            if (whereClause != null) {
                outputQry.append(" ").append(whereClause);
            }
        }
        return outputQry.toString();
    }

    private String addSchemaViewName(String tabNam, String schemaViewName) {
        String tableName = tabNam;
        if (!(tableName.matches("(#S#\\d+#E#)?\\s*(?:\\w+|\".*?\")\\s*\\.\\s*\\w+.*") || tableName.contains("##QUERY##") || tableName.equalsIgnoreCase("DUAL"))) {
            tableName = this.checkForJoinsAndAppendPckName(tableName, schemaViewName);
            tableName = tableName.replaceFirst("(\\w{2,})", schemaViewName + "." + "$1");
        }
        return tableName;
    }

    private String checkForJoinsAndAppendPckName(String tableNameStr, String schemaViewName) {
        String tableNameString = tableNameStr;
        if (tableNameString.matches("(?i).*(?<!\\w)JOIN(?!\\w).*")) {
            Pattern joinPattern = Pattern.compile("(?i)(?<!\\w)(join|left|right|outer|inner|cross|full)(\\s+outer)?\\s+join\\s+(\\w+)");
            Matcher joinMatcher = joinPattern.matcher(tableNameString);
            while (joinMatcher.find()) {
                String tabName = joinMatcher.group(3);
                tableNameString = tableNameString.replace(tabName, schemaViewName + "." + tabName);
            }
        }
        return tableNameString;
    }

    public void handlePackageName(String packageNameParam, String packageSchemaName, String varNme, Set<String> tempVarSet, String datatype) {
        String woQuotesPkgNme;
        if (packageNameParam.startsWith("\"") && (woQuotesPkgNme = packageNameParam.substring(1, packageNameParam.length() - 1).trim()).equals(QueryConversionUtility.toUpper(woQuotesPkgNme))) {
            tempVarSet.add(QueryConversionUtility.toLower(woQuotesPkgNme + "." + varNme));
            OracleMigrationService.addPackageNameMap(QueryConversionUtility.toLower(woQuotesPkgNme + "." + varNme), packageSchemaName + "-" + packageNameParam + "-" + datatype);
        }
    }

    public void setBufferContentExt(boolean isConstant, String datatype, String defaultVal, boolean expressionInd, StringBuffer sbuff) {
        sbuff.append("UPPER(").append("'").append(datatype).append("'").append(")").append(",");
        sbuff.append(isConstant).append(",");
        sbuff.append(defaultVal).append(",");
        sbuff.append(expressionInd).append(")").append(";");
    }

    public void setBufferConent(String packageNameParam, String packageSchemaName, String specOrBody, String varNme, StringBuffer sbuff) {
        sbuff.append("INSERT INTO ").append("MIG_ORA_EXT.").append("MIG_PKG_VARIABLES").append("(");
        if (!FeatureLoader.getBooleanProperty("pkgSchemaNaming")) {
            sbuff.append("USER_NAME").append(",");
        }
        sbuff.append("PACKAGE").append("_").append(QueryConversionUtility.toUpper("name"));
        sbuff.append(",").append("SPEC_OR_BODY");
        sbuff.append(",").append("VARIABLE").append("_").append(QueryConversionUtility.toUpper("name"));
        sbuff.append(",").append("VARIABLE").append("_").append("TYPE");
        sbuff.append(",").append("CONSTANT_I");
        sbuff.append(",").append(QueryConversionUtility.toUpper("default")).append("_").append("VALUE");
        sbuff.append(",").append(QueryConversionUtility.toUpper("RUNTIME_EXEC_I"));
        sbuff.append(")").append(QueryConversionUtility.toUpper("values")).append("(");
        if (!FeatureLoader.getBooleanProperty("pkgSchemaNaming") && !QueryConversionUtility.isGaus100()) {
            if ("current_user".equalsIgnoreCase(packageSchemaName)) {
                sbuff.append("current_schema()").append(",");
            } else {
                sbuff.append("UPPER(").append("'").append(packageSchemaName).append("'").append(")").append(",");
            }
        }
        if (QueryConversionUtility.isGaus100()) {
            if ("current_user".equalsIgnoreCase(packageSchemaName)) {
                sbuff.append("USER").append(",");
            } else {
                sbuff.append("UPPER(").append("'").append(packageSchemaName).append("'").append(")").append(",");
            }
        }
        sbuff.append("UPPER(").append("'").append(packageNameParam).append("'").append(")").append(",");
        sbuff.append("'").append(specOrBody).append("'").append(",");
        sbuff.append("UPPER(").append("'").append(varNme).append("'").append(")").append(",");
    }

    public String checkAndReplaceDataType(String datatype) {
        String datatypeQry = datatype;
        List<String> subTypeKeyList = this.getSubTypeMapKey();
        for (String key : subTypeKeyList) {
            if (!QueryConversionUtility.equalCheck(key, datatypeQry)) continue;
            String value = OracleMigrationService.getPackageReplacement(key);
            datatypeQry = (value = QueryConversionUtility.finderGroup(value, "(?i)(subtype\\s+(\\w+)\\s+(?:is|as)\\s+(.*?)(;|$))", 3)) != null ? value : datatypeQry;
            break;
        }
        return datatypeQry;
    }

    public List<String> getSubTypeMapKey() {
        Map<String, String> packageMap = OracleMigrationService.getPackageNameMap();
        ArrayList<String> keyList = new ArrayList<String>(10);
        for (Map.Entry<String, String> entry : packageMap.entrySet()) {
            String value = entry.getValue();
            if (value == null || !value.matches("(?i)(subtype\\s+(\\w+)\\s+(?:is|as)\\s+(.*?)(;|$))")) continue;
            keyList.add(entry.getKey());
        }
        return keyList;
    }

    public String migrateRowtype(Map<String, String> createTypesDDLParam, String header, Set<String> tableNameSet) {
        String output = header;
        String schemaName = QueryConversionUtility.finderGroup(header, "(?i)(?<!\\w)(?:procedure|function)\\s+(?:\\w+\\.)?((\\w+)[\\.#]\\w+)\\s+", 2);
        Matcher rowTypeMatch = ROW_TYPE_PAT.matcher(header);
        StringBuffer headerBuf = new StringBuffer();
        int tempIndex = 0;
        while (rowTypeMatch.find()) {
            String tableName = rowTypeMatch.group(2);
            int startIndex = rowTypeMatch.start(1);
            int endIndex = rowTypeMatch.end(1);
            headerBuf.append(header.substring(tempIndex, startIndex));
            headerBuf.append(schemaName).append(".").append(tableName);
            tempIndex = endIndex;
            tableNameSet.add(tableName + "~~" + schemaName);
        }
        headerBuf.append(header.substring(tempIndex));
        output = headerBuf.toString();
        return output;
    }

    public String createTypeForPercRowType(Map<String, String> createTypesDDLParam, Set<String> tableNameSet) {
        StringBuffer sb = new StringBuffer();
        for (String tblName : tableNameSet) {
            String[] arr = tblName.split("~~");
            tblName = arr[0];
            String schemaName = arr[1];
            StringBuffer typeBuf = new StringBuffer();
            for (Map.Entry<String, String> entry : createTypesDDLParam.entrySet()) {
                String key = entry.getKey();
                if (!key.matches("(?i)" + tblName + "." + "\\w+_" + "DATATYPE")) continue;
                key = key.replace(tblName.toUpperCase(Locale.ROOT) + ".", "");
                key = key.replace("_DATATYPE", "");
                String val = entry.getValue();
                typeBuf.append(key).append(" ").append(val).append(",").append(" ");
            }
            if (typeBuf.toString().isEmpty()) continue;
            typeBuf.deleteCharAt(typeBuf.length() - 2);
            typeBuf.insert(0, "CREATE TYPE " + schemaName + "." + tblName + " AS ( ");
            typeBuf.insert(typeBuf.length(), ");");
            sb.append(typeBuf.toString());
        }
        return sb.toString();
    }

    public String doGetNewProcFnNme(String packageNameParam, String procFnNme, String delimiter) {
        String packageNameVar = packageNameParam;
        String newProcName = "";
        String schemaName = "";
        int dotIndex = (packageNameVar = QueryConversionUtility.canonicalizeString(packageNameVar)).indexOf(46);
        if (dotIndex != -1 && dotIndex + 1 < packageNameVar.length()) {
            schemaName = packageNameVar.substring(0, dotIndex + 1);
            packageNameVar = packageNameVar.substring(dotIndex + 1);
        }
        if (packageNameVar.contains("\"") && procFnNme.contains("\"")) {
            String quotePackageName = packageNameVar.trim();
            String quoteProcFnNme = procFnNme.trim();
            if (quoteProcFnNme.length() > 1) {
                newProcName = quotePackageName.substring(0, quotePackageName.length() - 1) + delimiter + quoteProcFnNme.substring(1);
            }
        } else if (packageNameVar.contains("\"")) {
            String quotePackageName = packageNameVar.trim();
            newProcName = quotePackageName.substring(0, quotePackageName.length() - 1) + delimiter + procFnNme + "\"";
        } else {
            newProcName = packageNameVar + delimiter + procFnNme;
        }
        return schemaName + newProcName;
    }

    public List<String> localFnProcNameReplacer(List<String> fnProcList, List<String> fnProcNameList, String delimiter, String packageNameParam) {
        ArrayList<String> retFnsList = new ArrayList<String>(fnProcList.size());
        int fnProcSize = fnProcList.size();
        for (int iIndex = 0; iIndex < fnProcSize; ++iIndex) {
            String function = fnProcList.get(iIndex);
            for (String fnName : fnProcNameList) {
                HashMap<String, String> selectList;
                String newProcName = this.doGetNewProcFnNme(packageNameParam, fnName, delimiter);
                if (fnName.contains("$")) {
                    fnName = fnName.replace("$", "\\$");
                }
                if ((function = QueryConversionUtility.getSingleOrDoubleQuoteMap(function, selectList = new HashMap<String, String>(10), "select", "(?i)(?<!\\w)(?:INSERT|UPDATE)(?!\\w)(.*?(FROM.*?)?)(;|LOOP)", "~#~~#~~")).matches(".*\"(?<!\\w|\\.|#|\\$)" + fnName + "(?!\\w)\".*")) {
                    String procNameWithQuote = newProcName.replaceFirst(fnName, "\"" + fnName + "\"");
                    function = QueryConversionUtility.replaceAll(function, "(?<!\\w|\\.|#|\\$)\"" + fnName + "\"(?!\\w)", procNameWithQuote);
                } else {
                    function = function.replaceAll("\\s+", " ");
                    function = QueryConversionUtility.replaceAll(function, "(?i)(?<!\\w|#|\\.|\\$|END\\s)" + fnName + "(?!\\w|\\\"\\(|\\s\\(|\\(|\\.|\\sIS|\\sAS|\\sRETURN)", fnName + "()");
                    function = QueryConversionUtility.replaceAll(function, "(?<!\\w|\\.|#|\\$)" + fnName + "(?!\\w)", newProcName);
                }
                function = QueryConversionUtility.getRplFromMap(function, selectList, "(~#~~#~~\\d+#)");
            }
            retFnsList.add(function);
        }
        return retFnsList;
    }

    public String localRefCursorReplacement(String function, List<String> refCursorVariableList) {
        String outFunction = function;
        if (!refCursorVariableList.isEmpty()) {
            Matcher commentMatcher = COMMENT_PATTERN.matcher(function);
            LinkedHashMap<String, String> varCommentMap = new LinkedHashMap<String, String>(10);
            int counter = 0;
            String cursorComment = "##Var##";
            while (commentMatcher.find()) {
                outFunction = outFunction.replace(commentMatcher.group(0), cursorComment + counter + "##");
                varCommentMap.put(cursorComment + counter + "##", commentMatcher.group(0));
                ++counter;
            }
            for (String refVariable : refCursorVariableList) {
                outFunction = QueryConversionUtility.doReplaceExactStr(refVariable, "SYS_REFCURSOR", outFunction);
            }
            if (!varCommentMap.isEmpty()) {
                outFunction = QueryConversionUtility.doReplaceFunctionVariables(outFunction, varCommentMap, "##Var##");
            }
        }
        return outFunction;
    }

    public String findEndProcNameInMapAndRpl(String finalInput, StringBuffer outBuf, LinkedHashMap<String, Integer> liMap, String endProc, String endProcNmeFull) {
        String input = finalInput;
        if (endProc != null && !endProc.isEmpty() && liMap.containsKey(endProc.trim())) {
            int index = liMap.get(endProc.trim());
            int endProcIndex = input.indexOf(endProcNmeFull) + endProcNmeFull.trim().length();
            if (endProcIndex < input.length()) {
                String rplStr = input.substring(index, endProcIndex);
                String oldStr = outBuf.toString().trim();
                if (oldStr.endsWith("#E#")) {
                    oldStr = oldStr.substring(0, oldStr.lastIndexOf("#S#"));
                }
                input = input.replace(rplStr, oldStr);
            }
            outBuf.setLength(0);
        }
        return input;
    }

    public String findNestedAndSplit(String innerInput, StringBuffer outBuf) {
        String input = innerInput;
        Pattern procFinder = Pattern.compile("(?i)(?<!\\w|\\.)(procedure|function)(?!\\w|\\.)(?:(?!procedure|function).)*?(?<!\\w)end(?!\\w)\\s*(?:(?!if|loop|case)\"?\\$?\\w+\"?)?\\s*?;\\s*(?:#s#\\d+#e#\\s*)*");
        Matcher prMatcher = procFinder.matcher(input);
        while (prMatcher.find()) {
            String nestedProc = prMatcher.group();
            nestedProc = this.checkProcEndedProperly(nestedProc, input);
            outBuf.append(nestedProc).append(" ");
            input = input.replace(nestedProc, "");
            prMatcher = procFinder.matcher(input);
        }
        return input;
    }

    private String checkProcEndedProperly(String nestedProc, String fullInput) {
        String pattrnStr;
        String input = nestedProc;
        Matcher prMatcher = PROC_FINDER_PAT.matcher(input);
        String procName = null;
        if (prMatcher.find()) {
            procName = prMatcher.group(1).trim();
            procName = QueryConversionUtility.santizePattern(procName);
        }
        if (input.matches(pattrnStr = "(?i)(?<!\\w)(?:PROCEDURE|FUNCTION)(?!\\w)\\s+" + procName + "\\(.*?end\\s+" + procName + "\\s*;")) {
            return input;
        }
        String regexPattrn = "(?i)(?<!\\w)(procedure|function)(?!\\w|\\.)(?:(?!procedure|function).)*?(?<!\\w)end(?!\\w)\\s*(?:(?!if|loop|case)\"?\\$?" + procName + "\"?)\\s*?;\\s*(?:#s#\\d+#e#\\s*)*";
        Pattern nestFinder = Pattern.compile(regexPattrn);
        Matcher nestMatcher = nestFinder.matcher(fullInput);
        if (nestMatcher.find()) {
            return nestMatcher.group();
        }
        return input;
    }

    public void doAddProcNameInMap(String function, Map<String, Integer> liMap, String input) {
        Matcher prMatcher = PROCEDURE_PAT.matcher(function);
        if (prMatcher.find()) {
            String procName = prMatcher.group(1);
            String procNmeMtch = prMatcher.group();
            int srtProcIndex = input.indexOf(procNmeMtch.trim());
            liMap.put(procName.trim(), srtProcIndex);
        }
    }

    public void doHandleSubType(String packageNameParam, String packageVariables) {
        String packageVar = packageNameParam;
        HashMap<String, String> tableVarrayVariable = new HashMap<String, String>(10);
        String packageSchemaName = null;
        int dotIdx = packageVar.indexOf(46);
        if (dotIdx != -1 && dotIdx + 1 < packageVar.length()) {
            packageSchemaName = packageVar.substring(0, dotIdx).trim();
            packageVar = packageVar.substring(dotIdx + 1).trim();
        }
        Pattern pattern = Pattern.compile("(?i)(subtype\\s+(\\w+)\\s+(?:is|as)\\s+(.*?)(;|$))", 2);
        Matcher matcher = pattern.matcher(packageVariables);
        while (matcher.find()) {
            tableVarrayVariable.put(matcher.group(2), matcher.group(1));
        }
        for (Map.Entry entry : tableVarrayVariable.entrySet()) {
            String type = (String)entry.getKey();
            String typeValue = (String)entry.getValue();
            OracleMigrationService.addPackageNameMap(QueryConversionUtility.toLower(type), typeValue);
            OracleMigrationService.addPackageNameMap(QueryConversionUtility.toLower(packageVar + "." + type), typeValue);
            if (packageSchemaName == null || QueryConversionUtility.equalCheck(packageSchemaName, packageVar)) continue;
            OracleMigrationService.addPackageNameMap(QueryConversionUtility.toLower(packageSchemaName + "." + type), typeValue);
        }
    }
}

