/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.oracle;

import com.huawei.db.migration.database.bo.IBulkSplitPatternsBO;
import com.huawei.db.migration.database.bo.IQueryPatternsBO;
import com.huawei.db.migration.database.bo.IQuerySplitterPatternsBO;
import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.oracle.Gauss100Preprocessor;
import com.huawei.db.migration.oracle.OracleBLogicDDLHandler;
import com.huawei.db.migration.oracle.OracleBulkHandler;
import com.huawei.db.migration.oracle.OraclePostProcessing;
import com.huawei.db.migration.oracle.OraclePreQueryProcessing;
import com.huawei.db.migration.oracle.OracleQueryKeywordReplacer;
import com.huawei.db.migration.oracle.OracleQueryKeywordReplacerExt;
import com.huawei.db.migration.oracle.OracleUtility;
import com.huawei.db.migration.parser.GenericJSONParser;
import com.huawei.db.migration.services.OracleMigrationService;
import com.huawei.db.migration.util.ApplicationProperty;
import com.huawei.db.migration.util.ErrorLoggerUtility;
import com.huawei.db.migration.util.FeatureLoader;
import com.huawei.db.migration.util.FeatureLoaderExtended;
import com.huawei.db.migration.util.IGaussDBConstants;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.ProgressUtil;
import com.huawei.db.migration.util.QueryConversionUtility;
import com.huawei.db.migration.util.QueryUtilityExt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OracleBLogicHandler {
    private static final Logger logger = LogManager.getLogger(OracleBLogicHandler.class);
    private static final Pattern FUNC_FINDER_PAT = Pattern.compile("(?i)(?:FUNCTION|PROCEDURE)\\s+(\"?\\w*\"?\\.?\"?\\w+\"?)");
    private static final Pattern CREATE_PROCEDURE_PAT = Pattern.compile("(?i).*create\\s+(?:or\\s+replace\\s+procedure\\s+)(\"?\\w*\"?\\.?\"?\\w+\"?)");
    private static final Pattern DECLARE_TYPE_PAT = Pattern.compile("(?i)declare.*?type.*?is\\s+record.*;");
    private static final Pattern END_PAT = Pattern.compile("(?i)(?<!\\w)end(?!\\w)\\s*((?!if|loop|case)\"?\\$?\\w+\"?)?\\s*;");
    private static final Pattern PROC_WORD_PAT = Pattern.compile("(\\w+)\\.(\\w+)");
    private static final Pattern RECORD_PAT = Pattern.compile("(?i)(?<!\\w)type\\s+(\\w+)\\s+(?:is|as)\\s+RECORD\\s*\\(.*?;");
    private static final Pattern FUNCTION_PROCEDURE_PAT = Pattern.compile("(?i)(?:FUNCTION|PROCEDURE)\\s+(\"?\\w*\"?\\.?\\s*\"?\\w+\"?)");
    private static final Pattern FN_CREATE_PATTERN = Pattern.compile("(?i).*(create\\s+(or\\s+replace\\s+))");
    private static final Pattern SQLERRM_PAT = Pattern.compile("(?i)SQLERRM\\s*(\\(\\s*[\\w\\s\\,]*\\s*\\))");
    private static final Pattern GRANT_DATA_TYPES_PAT = Pattern.compile("(?i)\\w+\\s+(?:in\\s+|inout\\s+)?(\\w+(?:\\.\\w+\\%\\w+)?)");
    private static final Pattern GRANT_LINE_PAT = Pattern.compile("(?i)grant\\s+execute\\s+on\\s+(.*?)\\s+to(.*?);");
    public static final String SELECT_RPL_PATTERN = "(~#~~#~~\\d+#)";
    public static final String SELECT_REPLACE_STR = "~#~~#~~";
    private static String packageWithSchemaName = "";
    private static Pattern declarePattern = Pattern.compile("(?i).*?(?<!\\w)declare|.*?(?<!\\w)(?:as|is(?!\\w))(?!\\w)(.*?)(?<!\\w)(?:begin|\\/)(?!\\w).*");
    private static final String SELECT_PATTERN = "(?i)(?<!\\w)(?:INSERT|SELECT|UPDATE)(?!\\w)(.*?(FROM.*?)?)(;|LOOP)";
    private static Set<String> listUser = ConcurrentHashMap.newKeySet(10);
    private Pattern packageFinderPattern;
    private Pattern cursorReturnPattern;
    private Pattern packageNameFinder;
    private Pattern funcFinderPatten;
    private Pattern schemaFinderPattern;
    private Pattern declareTypePattern;
    private Pattern endFinderPattern;
    private Pattern procWordPattern;
    private Pattern funcReturnPattern;
    private Pattern grantFuncPattern;
    private Pattern grantDataTypesPattern;
    private Pattern grantLinePattern;
    private Pattern addPackagePattern;
    private Pattern setPackagePattern;
    private Set<String> listFunc = new HashSet<String>(10);
    private Set<String> listGrant = new HashSet<String>(10);
    private Matcher declareMatcher = null;
    private Pattern varrayTablePat = Pattern.compile("(?i)(?<!\\w)TYPE\\s+.*?(\"?\\w*\"?\\.?\"?\\w+\"?).*?(?:IS|AS)\\s+(?:TABLE|VARRAY\\s*\\(\\s*\\d+\\s*\\))\\s+OF\\s+(.*?)\\/?;(.*)");
    private Matcher varrayTablematcher = null;
    private String tableDataType = "";
    private boolean isPackage = false;
    private String createSchema = null;
    private String pkgSchemaName = null;
    private String packageName = "";
    private int queryCount = 0;
    private Map<String, String> createTypesDDL = null;
    private String pkgCommentStr = null;
    private String schema = "";
    private String pkgName = "";
    private boolean isAnonymousBlck;
    private OracleBLogicDDLHandler ddlHandler;
    private List<IQueryPatternsBO> queryPatterns;
    private List<IBulkSplitPatternsBO> bLogicSplitPatterns;
    private List<IQuerySplitterPatternsBO> querySplitterPatterns;
    private List<IBulkSplitPatternsBO> bLogicSplitter;
    private List<IQueryPatternsBO> schemaPatterns;
    private String delimiterFnProc;
    private String fileName;
    private String packageNameFnProc;

    public List<String> doBLogicPkgSplitProcess(List<String> inputList, String fileNameParam, List<?> bLogicPatterns) throws MigrationServiceException {
        this.fileName = fileNameParam;
        ArrayList<String> outputList = new ArrayList<String>(inputList.size());
        String output = null;
        String input = null;
        this.patternForPackage();
        for (int position = 0; position < inputList.size(); ++position) {
            try {
                input = inputList.get(position);
                output = this.getMigOutput(input);
                ProgressUtil.printProgress();
                outputList.add(output);
                continue;
            }
            catch (RuntimeException e) {
                ErrorLoggerUtility.failedQryCnt();
                ErrorLoggerUtility.failedFileCnt(this.fileName);
                logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " Error occurred while processing input in BLogic Migration. " + this.fileName + " " + MessageLoader.getMessage("queryPosInfo") + (position + 1));
                outputList.add(input);
            }
        }
        return outputList;
    }

    private String getMigOutput(String input) {
        String output = QueryConversionUtility.doRemoveExtraSpace(input);
        if (QueryConversionUtility.containsCheck(output, "EDITIONABLE")) {
            output = output.replaceFirst("(?i)EDITIONABLE", "");
        }
        OracleUtility utility = new OracleUtility();
        output = utility.doRplParallelEnable(output);
        if (FeatureLoader.getBooleanProperty("pkgSchemaNaming")) {
            Matcher packageMatcher = this.packageFinderPattern.matcher(input);
            output = this.packageName(output, input, packageMatcher);
        }
        if ((output = this.checkPackage(output)).trim().matches("(?i).*(?<!\\w)begin(?!\\w).*") && !QueryConversionUtility.isGaus100()) {
            output = OraclePostProcessing.doGetUDTChanges(output, true);
        }
        if (FeatureLoader.getBooleanProperty("pkgSchemaNaming")) {
            if (this.createSchema != null) {
                output = this.createSchema + output;
                this.createSchema = null;
            }
            if (this.pkgCommentStr != null) {
                output = this.pkgCommentStr + output;
            }
        }
        return output;
    }

    private void patternForPackage() {
        if (FeatureLoader.getBooleanProperty("pkgSchemaNaming") && this.packageFinderPattern == null) {
            this.packageFinderPattern = Pattern.compile("(?i).*create\\s+(?:or\\s+replace\\s+(?:EDITIONABLE\\s+)?(package|function)\\s+(body\\s+)?)(\\\"?\\w*\\\"?\\.?\\\"?\\w+\\\"?)\\s+(?:(?:IS|AS)\\s+(?:#S#\\d+#E#\\s*)?(?:FUNCTION|PROCEDURE)?(.*?)\\()?");
        }
    }

    private String checkPackage(String outputVal) {
        String output = outputVal;
        if (output.matches("(?i).*(?<!\\w)PACKAGE(?!\\w).*")) {
            StringBuffer outputBuff = new StringBuffer();
            output = this.removePkgEnd(output);
            output = this.splitNestedProc(output);
            StringBuffer recordTypeBodyDec = new StringBuffer();
            List<String> packageFuncProc = this.getFnProcPackage(output, recordTypeBodyDec);
            this.spliPkgVars(output, packageFuncProc, outputBuff);
            output = outputBuff.toString();
        } else {
            Set<String> getPkgNames = QueryConversionUtility.getUniqueMatchedGrpsInSet(output, "(?:\"?\\w+\"?\\s*\\.)?(\"?\\w+\"?\\s*\\.\\s*\"?\\w+\"?)", 1);
            if (!getPkgNames.isEmpty()) {
                OracleMigrationService.addPackageFileMapFrmSet(this.fileName, getPkgNames);
            }
        }
        return output;
    }

    private void spliPkgVars(String output, List<String> packageFuncProc, StringBuffer outputBuff) {
        if (packageFuncProc != null) {
            ArrayList<String> pkgVarsList = new ArrayList<String>(10);
            while (!packageFuncProc.isEmpty() && packageFuncProc.get(0).startsWith("INSERT")) {
                pkgVarsList.add(packageFuncProc.remove(0));
            }
            if (!pkgVarsList.isEmpty()) {
                outputBuff.append("BEGIN").append(IGaussDBConstants.NEW_LINE);
                for (String insert : pkgVarsList) {
                    outputBuff.append(insert).append(IGaussDBConstants.NEW_LINE);
                }
                outputBuff.append("END").append(";");
                outputBuff.append(IGaussDBConstants.NEW_LINE).append("/");
                outputBuff.append(IGaussDBConstants.NEW_LINE);
            }
            for (String singleFn : packageFuncProc) {
                String singleFnOut = singleFn.replaceAll("(?i)(?<!\\w)end\\s+(?!if|loop|case)(\\w+|\\w*\\.?\\w*\\.?\\w*|\\w*.?##QUOTE##\\d+#)\\s*;", "END;");
                outputBuff.append(singleFnOut).append(IGaussDBConstants.NEW_LINE);
            }
        } else {
            this.fillOutPutBuff(output, outputBuff);
        }
    }

    private void fillOutPutBuff(String output, StringBuffer outputBuff) {
        List<String> varList = this.processPkgSpecification(output, this.pkgSchemaName);
        if (varList != null && !varList.isEmpty()) {
            outputBuff.append("BEGIN").append(IGaussDBConstants.NEW_LINE);
            for (String insert : varList) {
                outputBuff.append(insert).append(IGaussDBConstants.NEW_LINE);
            }
            outputBuff.append("END").append(";");
            outputBuff.append(IGaussDBConstants.NEW_LINE).append("/");
        }
    }

    private String packageName(String outputVal, String input, Matcher packageMatcher) {
        String output = outputVal;
        if (packageMatcher.find()) {
            int index;
            String functionName;
            this.pkgSchemaName = this.packageName = packageMatcher.group(3);
            if (this.packageName != null && this.packageName.contains("\"")) {
                String packageNameWithoutQuote = this.packageName.replaceAll("\"", "");
                output = output.replace(this.packageName, packageNameWithoutQuote);
                this.packageName = packageNameWithoutQuote;
            }
            if ((functionName = packageMatcher.group(4)) != null && functionName.contains("\"")) {
                String functionNameWithoutQuote = functionName.replaceAll("\"", "");
                output = output.replace(functionName, functionNameWithoutQuote);
            }
            String schemaName = null;
            if (this.packageName != null && (index = this.packageName.indexOf(46)) != -1 && index + 1 < this.packageName.length()) {
                schemaName = this.packageName.substring(0, index + 1);
                output = output.replace(schemaName, "");
                this.packageName = this.packageName.replace(schemaName, "");
            }
            String sqlType = packageMatcher.group(1);
            String body = packageMatcher.group(2);
            if ("PACKAGE".equalsIgnoreCase(sqlType) && (body == null || body.isEmpty())) {
                this.pkgCommentStr = "/*~~" + this.packageName + "~~" + "*/";
            }
            if (!QueryConversionUtility.containsCheck(input, "body") && functionName != null) {
                this.createSchema = "CREATE SCHEMA " + this.packageName + "; ";
            }
        }
        return output;
    }

    public List<String> doBLogicProcess(List<String> inputList, String fileNameParam, List<?> bLogicPatterns) throws MigrationServiceException, InterruptedException {
        this.fileName = fileNameParam;
        ArrayList<String> outputList = new ArrayList<String>(inputList.size());
        this.initializeJsonParserObjects(bLogicPatterns);
        String plsqlCollection = FeatureLoader.getStringProperty("plsqlCollection");
        boolean percTypeFlag = false;
        for (int position = 0; position < inputList.size(); ++position) {
            String input;
            String output = input = inputList.get(position);
            try {
                this.isAnonymousBlck = true;
                percTypeFlag = this.getPercTypeFlag(input, percTypeFlag);
                output = this.getOutput(input);
                HashSet<String> percRowTypeSet = new HashSet<String>(10);
                if (output.matches("(?i).*(?<!\\w)PACKAGE(?!\\w).*")) {
                    output = this.handlePackageProc(output);
                    StringBuffer recordTypeBodyDec = new StringBuffer();
                    List<String> packageFuncProc = this.getFnProcPackage(output, recordTypeBodyDec);
                    StringBuffer outputBuff = new StringBuffer();
                    output = this.computeOutput(this.queryPatterns, this.bLogicSplitPatterns, this.querySplitterPatterns, this.bLogicSplitter, this.schemaPatterns, output, input, packageFuncProc, plsqlCollection, position, percRowTypeSet, outputBuff, recordTypeBodyDec);
                    this.isAnonymousBlck = false;
                } else {
                    output = this.fillOutBuffer(this.queryPatterns, this.bLogicSplitPatterns, this.querySplitterPatterns, this.bLogicSplitter, this.schemaPatterns, output, plsqlCollection, position, percRowTypeSet);
                }
                this.getOutListAndLogError(outputList, percTypeFlag, output);
            }
            catch (RuntimeException e) {
                this.handleException(e, position);
                outputList.add(input);
            }
            ProgressUtil.printProgress();
        }
        return outputList;
    }

    private void initializeJsonParserObjects(List<?> bLogicPatterns) {
        GenericJSONParser objJSONParser = new GenericJSONParser();
        this.queryPatterns = objJSONParser.getJSONObject("oracle-query");
        this.bLogicSplitPatterns = bLogicPatterns;
        this.querySplitterPatterns = objJSONParser.getJSONObject("oracle-query-splitter");
        this.bLogicSplitter = objJSONParser.getJSONObject("oracle-blogic-splitter");
        this.schemaPatterns = objJSONParser.getJSONObject("oracle-schema");
        this.ddlHandler = new OracleBLogicDDLHandler(this.queryPatterns, this.querySplitterPatterns, this.schemaPatterns, this.bLogicSplitter);
        if (this.packageNameFinder == null) {
            this.packageNameFinder = Pattern.compile("(?i)create\\s+(?:or\\s+replace\\s+(?:EDITIONABLE\\s+)?(package|function)\\s+(body\\s+)?|SEQUENCE\\s+)(\"?\\w*\"?(\\s*\\.\\s*)?\"?\\w+\"?)");
        }
    }

    private boolean getPercTypeFlag(String input, boolean flag) {
        boolean percTypeFlag = flag;
        if (QueryConversionUtility.containsCheck(input, "%type")) {
            percTypeFlag = true;
        }
        return percTypeFlag;
    }

    private void getOutListAndLogError(List<String> outputList, boolean percTypeFlag, String output) {
        output = this.getMigratedOutput(percTypeFlag, output);
        outputList.add(output);
        for (int i = 0; i < this.queryCount; ++i) {
            ErrorLoggerUtility.updateQryCnt();
        }
    }

    private String getMigratedOutput(boolean percTypeFlag, String input) {
        String output = input;
        output = this.doChangesInSpec(output);
        if (!QueryConversionUtility.isGaus100()) {
            output = this.handlePkgSchemaNaming(output, percTypeFlag);
        }
        output = this.handleGrant(output, percTypeFlag);
        output = this.addPackageTag(output);
        if (ApplicationProperty.getBooleanProperty("executesqlingauss") && this.isAnonymousBlck && !QueryConversionUtility.isGaus100() && !QueryConversionUtility.containsCheck(output, "TRIGGER")) {
            output = this.doChckForAnonymousBlckAndPutComment(output);
        }
        return output;
    }

    private String getOutput(String input) {
        String output = this.doPreBlogicChanges(input);
        output = this.doExtractPackageName(output, input);
        output = this.anonymousFunc(output);
        return output;
    }

    private String doChckForAnonymousBlckAndPutComment(String input) {
        String output = input;
        if (output.matches("(?i).*(?!<\\w)begin(?!\\w).*")) {
            output = "/*~#~AnonymousBlock~#~*/" + System.lineSeparator() + output;
        }
        return output;
    }

    public String doChangesInSpec(String input) {
        String output = input;
        if (QueryConversionUtility.isGaus100() && !QueryConversionUtility.containsCheck(output, "body")) {
            Matcher refCursor = Pattern.compile("(?i)(?<!\\w)create\\s+or\\s+replace\\s+package\\s+(\\w+(?:\\.\\w+)?)\\s+as\\s+((?<!\\w)type\\s+(ref_cursor)\\s+is\\s+ref\\s+cursor(?!\\w).*?;)").matcher(output);
            String refCur = "";
            if (refCursor.find()) {
                refCur = refCursor.group(3);
                output = output.replaceAll("(?i)((?<!\\w)type\\s+ref_cursor\\s+is\\s+ref\\s+cursor(?!\\w).*?;)", "/* $1 */");
                LinkedHashMap<String, String> commentMap = new LinkedHashMap<String, String>(10);
                output = QueryConversionUtility.getSingleOrDoubleQuoteMap(output, commentMap, "/*", "\\/\\*.*?\\*\\/", "##COMMENT##");
                output = output.replaceAll("(?<!\\w)" + refCur + "(?!\\w)", "SYS_REFCURSOR");
                output = QueryConversionUtility.getRplFromMap(output, commentMap, "(##COMMENT##\\d+#)");
            }
            if (output.matches("(?i).*?(?<!\\w)create\\s+or\\s+replace\\s+package(?!\\w).*?")) {
                String pkg = null;
                String pkgReplacement = null;
                Map<String, String> packageMap = OracleMigrationService.getPackageNameMap();
                for (Map.Entry<String, String> pckgNameMap : packageMap.entrySet()) {
                    pkg = pckgNameMap.getKey();
                    pkgReplacement = pckgNameMap.getValue().trim();
                    if (!QueryConversionUtility.containsCheck(output, pkg) || !pkg.contains(".")) continue;
                    output = output.replaceAll("(?i)(?<!\\w)" + pkg, pkgReplacement);
                }
                output = output.replaceAll("(?i)(?<!\\w)is\\s+(SUBTYPE(?!\\w).*?(?<!\\w)is(?!\\w).*?;)", "IS /* $1 */");
                output = output.replaceAll("(?i)((?<!\\w)function(?!\\w).*?(?<!\\w)return(?!\\w).*?)((?<!\\w)PIPELINED(?!\\w))", "$1 /* $2 */");
            }
        }
        return output;
    }

    public String doPreBlogicChanges(String input) throws MigrationServiceException {
        String output;
        if (!QueryConversionUtility.isGaus100()) {
            output = this.doPreQueryChanges(input);
        } else {
            OracleBulkHandler.setBulkHandlerFlag(false);
            output = Gauss100Preprocessor.doMigrateForGaussHundred(input);
        }
        return output;
    }

    public String handlePackageProc(String input) {
        String output = input;
        this.isPackage = true;
        if (!QueryConversionUtility.isGaus100() || FeatureLoaderExtended.getBooleanProperty("supportPkgSplitDBT")) {
            output = this.handleCursorPart(output);
            output = this.removePkgEnd(output);
        }
        output = this.splitNestedProc(output);
        return output;
    }

    public String handleGrant(String input, boolean percTypeFlag) {
        String output = input;
        if (!QueryConversionUtility.isGaus100() && FeatureLoader.getBooleanProperty("addGrantLine")) {
            this.addGrantLine(output);
            output = this.addGrantLineFinal(output);
        }
        return output;
    }

    private void handleException(Exception e, int position) {
        ErrorLoggerUtility.updateQryCnt();
        ErrorLoggerUtility.failedQryCnt();
        ErrorLoggerUtility.failedFileCnt(this.fileName);
        logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " [DSC_ERR_004_040] " + MessageLoader.getMessage("DSC_ERR_004_040") + " " + this.fileName + " " + MessageLoader.getMessage("queryPosInfo") + (position + 1));
    }

    private String handlePkgSchemaNaming(String outputVal, boolean percTypeFlag) {
        String schemaName;
        String output = outputVal;
        if (FeatureLoader.getBooleanProperty("pkgSchemaNaming") && this.createSchema != null) {
            output = this.createSchema + output;
            this.createSchema = null;
        }
        if ((schemaName = this.addSetPackageName(output, percTypeFlag)) != null) {
            output = schemaName + output + System.lineSeparator() + "reset package_name_list;";
        }
        if (FeatureLoader.getBooleanProperty("pkgSchemaNaming") && this.pkgCommentStr != null) {
            output = this.pkgCommentStr + output;
        }
        return output;
    }

    private String computeOutput(List<IQueryPatternsBO> queryPatterns, List<IBulkSplitPatternsBO> bLogicSplitPatterns, List<IQuerySplitterPatternsBO> querySplitterPatterns, List<IBulkSplitPatternsBO> bLogicSplitter, List<IQueryPatternsBO> schemaPatterns, String outputVal, String input, List<String> packageFuncProc, String plsqlCollection, int position, Set<String> percRowTypeSet, StringBuffer outputBuff, StringBuffer recordTypeBodyDec) throws InterruptedException {
        String output = outputVal;
        if (packageFuncProc != null) {
            this.fillOutputBuff(queryPatterns, bLogicSplitPatterns, querySplitterPatterns, bLogicSplitter, schemaPatterns, packageFuncProc, plsqlCollection, position, percRowTypeSet, outputBuff, recordTypeBodyDec);
        } else {
            this.fillOutBuffer(output, outputBuff);
            if (QueryConversionUtility.isGaus100() && !FeatureLoaderExtended.getBooleanProperty("supportPkgSplitDBT") && outputBuff.toString().isEmpty()) {
                outputBuff.append(output);
            }
        }
        String recordDec = "";
        if (!QueryConversionUtility.isGaus100()) {
            if (QueryConversionUtility.equalCheck(plsqlCollection, "VARRAY") && QueryConversionUtility.containsCheck(input, "body")) {
                recordDec = this.doProcessRecordTypeInSpec(output);
            }
            OracleUtility oracleUtil = new OracleUtility();
            recordDec = oracleUtil.doRplPercentageType(recordDec, this.schema);
        }
        output = recordDec + outputBuff.toString();
        return output;
    }

    private String handleCursorPart(String outputVal) {
        String output = outputVal;
        if (QueryConversionUtility.containsCheck(output, "CURSOR")) {
            if (this.cursorReturnPattern == null) {
                this.cursorReturnPattern = Pattern.compile("(?i)type\\s+\\w+\\s+(?:is|as)\\s+ref\\s+cursor(?!\\w)(\\s*RETURN\\s*.*?);");
            }
            Matcher matcher = this.cursorReturnPattern.matcher(output);
            while (matcher.find()) {
                output = QueryConversionUtility.replace(output, matcher.group(1), "", true);
            }
        }
        return output;
    }

    private String fillOutBuffer(List<IQueryPatternsBO> queryPatterns, List<IBulkSplitPatternsBO> bLogicSplitPatterns, List<IQuerySplitterPatternsBO> querySplitterPatterns, List<IBulkSplitPatternsBO> bLogicSplitter, List<IQueryPatternsBO> schemaPatterns, String outputVal, String plsqlCollection, int position, Set<String> percRowTypeSet) throws InterruptedException {
        String output = outputVal;
        if (!QueryConversionUtility.isGaus100()) {
            if (QueryConversionUtility.equalCheck(plsqlCollection, "VARRAY")) {
                StringBuffer recordTypeBodyDec = new StringBuffer();
                output = this.doRecordAndTableDecInPkgBody(this.packageName, recordTypeBodyDec, output, true);
                OracleUtility oracleUtil = new OracleUtility();
                String recordTypeBodyDecRpl = oracleUtil.doRplPercentageType(recordTypeBodyDec.toString(), this.schema);
                output = recordTypeBodyDecRpl + output;
            }
            if (QueryConversionUtility.containsCheck(output, "rowtype")) {
                output = this.ddlHandler.migrateRowtype(this.createTypesDDL, output, percRowTypeSet);
            }
        }
        output = this.doProcessFnProc(queryPatterns, querySplitterPatterns, schemaPatterns, bLogicSplitPatterns, bLogicSplitter, position + 1, output);
        if (!QueryConversionUtility.isGaus100()) {
            Set<String> getPkgNames;
            String createTypeStr;
            if (!percRowTypeSet.isEmpty() && (createTypeStr = this.ddlHandler.createTypeForPercRowType(this.createTypesDDL, percRowTypeSet)) != null) {
                output = createTypeStr + IGaussDBConstants.NEW_LINE + output;
            }
            if (!(getPkgNames = QueryConversionUtility.getUniqueMatchedGrpsInSet(output, "(?:\"?\\w+\"?\\s*\\.)?(\"?\\w+\"?\\s*\\.\\s*\"?\\w+\"?)", 1)).isEmpty()) {
                OracleMigrationService.addPackageFileMapFrmSet(this.fileName, getPkgNames);
            }
        }
        return output;
    }

    private void fillOutBuffer(String output, StringBuffer outputBuff) {
        List<String> varList = this.processPkgSpecification(output, this.pkgSchemaName);
        if (varList != null && !varList.isEmpty()) {
            if (ApplicationProperty.getBooleanProperty("executesqlingauss")) {
                outputBuff.append("/*~#~AnonymousBlock~#~*/");
                outputBuff.append(System.lineSeparator());
            }
            outputBuff.append("BEGIN").append(IGaussDBConstants.NEW_LINE);
            for (String insert : varList) {
                outputBuff.append(insert).append(IGaussDBConstants.NEW_LINE);
            }
            outputBuff.append("END").append(";");
            outputBuff.append(IGaussDBConstants.NEW_LINE).append("/");
        }
    }

    private void fillOutputBuff(List<IQueryPatternsBO> queryPatterns, List<IBulkSplitPatternsBO> bLogicSplitPatterns, List<IQuerySplitterPatternsBO> querySplitterPatterns, List<IBulkSplitPatternsBO> bLogicSplitter, List<IQueryPatternsBO> schemaPatterns, List<String> packageFuncProc, String plsqlCollection, int position, Set<String> percRowTypeSet, StringBuffer outputBuff, StringBuffer recordTypeBodyDec) throws InterruptedException {
        ArrayList<String> pkgVarsList = new ArrayList<String>(10);
        while (!packageFuncProc.isEmpty() && packageFuncProc.get(0).startsWith("INSERT")) {
            pkgVarsList.add(packageFuncProc.remove(0));
        }
        if (!pkgVarsList.isEmpty()) {
            if (ApplicationProperty.getBooleanProperty("executesqlingauss")) {
                outputBuff.append("/*~#~AnonymousBlock~#~*/");
                outputBuff.append(System.lineSeparator());
            }
            outputBuff.append("BEGIN").append(IGaussDBConstants.NEW_LINE);
            for (String insert : pkgVarsList) {
                outputBuff.append(insert).append(IGaussDBConstants.NEW_LINE);
            }
            outputBuff.append("END").append(";");
            outputBuff.append(IGaussDBConstants.NEW_LINE).append("/");
            outputBuff.append(IGaussDBConstants.NEW_LINE);
        }
        for (String singleFn : packageFuncProc) {
            if (!QueryConversionUtility.isGaus100() && QueryConversionUtility.equalCheck(plsqlCollection, "VARRAY")) {
                singleFn = this.doRecordAndTableDecInPkgBody(this.packageName, recordTypeBodyDec, singleFn, false);
            }
            String singleFnOut = this.doProcessFnProc(queryPatterns, querySplitterPatterns, schemaPatterns, bLogicSplitPatterns, bLogicSplitter, position + 1, singleFn);
            if (!QueryConversionUtility.isGaus100() && QueryConversionUtility.containsCheck(singleFnOut, "rowtype")) {
                singleFnOut = this.ddlHandler.migrateRowtype(this.createTypesDDL, singleFnOut, percRowTypeSet);
            }
            outputBuff.append(singleFnOut).append(IGaussDBConstants.NEW_LINE);
        }
        if (!QueryConversionUtility.isGaus100()) {
            String createTypeStr;
            if (!percRowTypeSet.isEmpty() && (createTypeStr = this.ddlHandler.createTypeForPercRowType(this.createTypesDDL, percRowTypeSet)) != null) {
                outputBuff.insert(0, createTypeStr + IGaussDBConstants.NEW_LINE);
            }
            OracleUtility oracleUtil = new OracleUtility();
            String recordTypeBodyDecRpl = oracleUtil.doRplPercentageType(recordTypeBodyDec.toString(), this.schema);
            outputBuff.insert(0, recordTypeBodyDecRpl);
        }
    }

    private String doExtractPackageName(String outputVal, String input) {
        String output = outputVal;
        Matcher packageMatcher = this.packageNameFinder.matcher(input);
        if (packageMatcher.find()) {
            int index;
            this.pkgSchemaName = this.packageName = packageMatcher.group(3);
            packageWithSchemaName = this.packageName;
            output = this.removeSpaceInSchemaPkgName(output);
            if (this.funcFinderPatten == null) {
                this.funcFinderPatten = FUNC_FINDER_PAT;
            }
            Matcher funcMatcher = this.funcFinderPatten.matcher(input);
            String functionName = null;
            while (funcMatcher.find()) {
                functionName = funcMatcher.group(1);
                output = this.addToCreateTypeMap(output, functionName);
                ++this.queryCount;
            }
            if (this.packageName != null && (index = this.packageName.indexOf(46)) != -1 && index + 1 < this.packageName.length()) {
                this.schema = this.packageName.substring(0, index + 1);
            }
            this.createTypesDDL = OracleMigrationService.getCreateTypeMap();
            if (FeatureLoader.getBooleanProperty("pkgSchemaNaming")) {
                output = this.handlePkgSchemaName(output);
                String sqlType = packageMatcher.group(1);
                String body = packageMatcher.group(2);
                if ("PACKAGE".equalsIgnoreCase(sqlType) && (body == null || body.isEmpty())) {
                    this.pkgCommentStr = "/*~~" + this.packageName + "~~" + "*/";
                }
                if (!QueryConversionUtility.containsCheck(input, "body") && QueryConversionUtility.containsCheck(input, "package") && functionName != null) {
                    this.createSchema = "CREATE SCHEMA " + this.packageName + "; ";
                }
                String schemaPkgName = this.packageName;
                if (!"PACKAGE".equalsIgnoreCase(sqlType)) {
                    schemaPkgName = "";
                }
                this.doAddPackageNamesToSet(input, schemaPkgName, functionName);
                if ("FUNCTION".equalsIgnoreCase(sqlType)) {
                    OracleMigrationService.addPackageBodyFileMap(QueryConversionUtility.toLower(this.packageName), this.fileName);
                }
            }
        } else {
            this.doGetSchema(input);
        }
        return output;
    }

    private String addToCreateTypeMap(String output, String functionName) {
        if (functionName != null && functionName.contains("\"")) {
            String functionNameWithoutQuote = functionName.replaceAll("\"", "");
            output = output.replace(functionName, functionNameWithoutQuote);
            if (this.packageName != null) {
                OracleMigrationService.addCreateTypeMap(this.packageName + "." + functionNameWithoutQuote + "_MIG_PROC", "_MIG_PROC".substring(1));
            }
        } else if (functionName != null && this.packageName != null) {
            OracleMigrationService.addCreateTypeMap(this.packageName + "." + functionName + "_MIG_PROC", "_MIG_PROC".substring(1));
        }
        return output;
    }

    private String removeSpaceInSchemaPkgName(String output) {
        if (this.packageName != null && QueryConversionUtility.containsCheck(this.packageName, " ")) {
            String packageNameParam = QueryConversionUtility.replaceAll(this.packageName, "(?i)\\s", "");
            output = output.replace(this.packageName, packageNameParam);
            this.packageName = packageNameParam;
        }
        if (this.packageName != null && this.packageName.contains("\"")) {
            String packageNameWithoutQuote = this.packageName.replaceAll("\"", "");
            output = output.replace(this.packageName, packageNameWithoutQuote);
            this.packageName = packageNameWithoutQuote;
        }
        return output;
    }

    private String handlePkgSchemaName(String outputVal) {
        int index;
        String output = outputVal;
        if (this.packageName != null && (index = this.packageName.indexOf(46)) != -1 && index + 1 < this.packageName.length()) {
            String schemaName = this.packageName.substring(0, index + 1);
            for (Map.Entry<String, String> entry : this.createTypesDDL.entrySet()) {
                int dotIndex;
                String procOrFun = entry.getKey();
                if (!procOrFun.endsWith("_MIG_PROC") || !procOrFun.startsWith(schemaName)) continue;
                int lastIndex = procOrFun.lastIndexOf(".");
                if (lastIndex != -1) {
                    procOrFun = procOrFun.substring(0, lastIndex);
                }
                if ((dotIndex = procOrFun.indexOf(".")) == -1 || dotIndex + 1 >= procOrFun.length()) continue;
                String replacement = procOrFun.substring(dotIndex + 1);
                output = QueryConversionUtility.replaceAll(output, procOrFun, replacement);
            }
            this.packageName = this.packageName.replace(schemaName, "");
        }
        return output;
    }

    private void doGetSchema(String input) {
        int index;
        String schemaProc;
        Matcher schemaMatcher;
        if (this.schemaFinderPattern == null) {
            this.schemaFinderPattern = CREATE_PROCEDURE_PAT;
        }
        if ((schemaMatcher = this.schemaFinderPattern.matcher(input)).find() && (schemaProc = schemaMatcher.group(1)) != null && (index = schemaProc.indexOf(46)) != -1 && index + 1 < schemaProc.length()) {
            this.schema = schemaProc.substring(0, index + 1);
        }
    }

    private void doAddPackageNamesToSet(String input, String schemaPkgName, String functionName) {
        if (!QueryConversionUtility.containsCheck(input, "body") && QueryConversionUtility.containsCheck(input, "package") && functionName != null) {
            this.createSchema = "CREATE SCHEMA " + this.packageName + "; ";
            OracleMigrationService.addPkgSpecToSet(QueryConversionUtility.toLower(schemaPkgName));
        } else if (schemaPkgName != null && !schemaPkgName.isEmpty()) {
            OracleMigrationService.addSchemaPkgBodyToSet(QueryConversionUtility.toLower(schemaPkgName));
        }
    }

    private String doPreQueryChanges(String input) {
        String output = QueryConversionUtility.doRemoveExtraSpace(input);
        output = OracleBLogicHandler.removeSqlerrmArgs(output);
        if (QueryConversionUtility.containsCheck(output = output.replaceAll("(?i)SYS\\s*.\\s*UTL_FILE\\s*.\\s*", "UTL_FILE."), "SERVEROUTPUT")) {
            output = QueryConversionUtility.replaceAll(output, "(?i)(?<!\\w)SET(?!\\w)\\s+(?<!\\w)serveroutput\\s+on(?!\\w)\\s*;", "/* SET serveroutput on; */");
        }
        if (QueryConversionUtility.containsCheck(output, "EDITIONABLE")) {
            output = output.replaceFirst("(?i)EDITIONABLE", "");
        }
        OracleUtility utility = new OracleUtility();
        output = utility.doRplParallelEnable(output);
        return output;
    }

    private String anonymousFunc(String output) {
        String outputQry = output;
        if (this.declareTypePattern == null) {
            this.declareTypePattern = DECLARE_TYPE_PAT;
        }
        Matcher matchDeclareType = this.declareTypePattern.matcher(outputQry);
        StringBuffer sb = new StringBuffer();
        if (matchDeclareType.find()) {
            outputQry = this.doRecordAndTableDecInPkgBody("", sb, outputQry, true);
            if (ApplicationProperty.getBooleanProperty("executesqlingauss")) {
                sb.append("/*~#~AnonymousBlock~#~*/");
                sb.append(System.lineSeparator());
            }
            sb.append(outputQry);
            outputQry = sb.toString();
        }
        return outputQry;
    }

    private String splitNestedProc(String output) {
        Pattern packageFinder = Pattern.compile("(?i).*(create\\s+(or\\s+replace\\s+)?package\\s+body\\s+(\"?\\w*\"?\\.?\"?\\w+\"?)\\s+((?:(?<!\\w)as|(?<!\\w)is)\\s+)?(.*?))(?<!\\w)(function|begin|procedure)(?!\\w)");
        Matcher packageMatcher = packageFinder.matcher(output);
        String input = output;
        if (packageMatcher.find()) {
            String tempInput = input;
            Pattern funcFinder = Pattern.compile("(?i)((?:(?<!\\w|\\.)procedure(?!\\w)|function(?=\\s|$)).*?)(?:(?<!\\w|\\.)procedure(?!\\w)|function(?=\\s|$)|$)");
            Matcher fnMatcher = funcFinder.matcher(tempInput);
            String function = null;
            StringBuffer strbuf = new StringBuffer();
            StringBuffer outBuf = new StringBuffer();
            LinkedHashMap<String, Integer> liMap = new LinkedHashMap<String, Integer>(10);
            while (fnMatcher.find()) {
                function = fnMatcher.group(1);
                if (function.trim().matches("(?i).*(?<!\\w)end(?!\\w)\\s*((?!if|loop|case)\"?\\$?\\w+\"?)?\\s*;\\s*(?:#s#\\d+#e#\\s*)*")) {
                    strbuf.append(function);
                    String innerInput = strbuf.toString();
                    if (this.endFinderPattern == null) {
                        this.endFinderPattern = END_PAT;
                    }
                    Matcher endMatcher = this.endFinderPattern.matcher(innerInput);
                    String endProc = null;
                    String endProcNmeFull = "";
                    while (endMatcher.find()) {
                        if (endMatcher.group(1) != null) {
                            endProc = endMatcher.group(1).trim();
                        }
                        endProcNmeFull = endMatcher.group();
                    }
                    innerInput = this.ddlHandler.findNestedAndSplit(innerInput, outBuf);
                    strbuf.setLength(0);
                    strbuf.append(innerInput);
                    innerInput = innerInput.replaceAll("(?i)#S#\\d+#E#", "");
                    if (innerInput.isEmpty() || innerInput.matches("(?i).*(?<!\\w)end(?!\\w)\\s*;")) {
                        input = this.ddlHandler.findEndProcNameInMapAndRpl(input, outBuf, liMap, endProc, endProcNmeFull);
                    }
                } else {
                    strbuf.append(function);
                    this.ddlHandler.doAddProcNameInMap(function, liMap, input);
                    outBuf.setLength(0);
                }
                tempInput = tempInput.replace(function, "");
                fnMatcher = funcFinder.matcher(tempInput);
            }
        }
        return input;
    }

    private String doProcessRecordTypeInSpec(String output) {
        Map<String, String> packageMap = OracleMigrationService.getPackageNameMap();
        Iterator<Map.Entry<String, String>> iter = packageMap.entrySet().iterator();
        StringBuffer recordCreateDeclare = new StringBuffer();
        String packageNm = "";
        while (iter.hasNext()) {
            Matcher matcher;
            Map.Entry<String, String> entry = iter.next();
            String key = entry.getKey();
            String value = entry.getValue();
            if (this.procWordPattern == null) {
                this.procWordPattern = PROC_WORD_PAT;
            }
            if (!(matcher = this.procWordPattern.matcher(key)).find()) continue;
            packageNm = matcher.group(1);
            String typeName = matcher.group(2);
            if (!QueryConversionUtility.containsCheck(value, " record") || !QueryConversionUtility.containsCheck(key, ".")) continue;
            this.doCreateRecordTypeDec(output, recordCreateDeclare, packageNm, key, value, typeName);
        }
        String recordDec = recordCreateDeclare.toString().replaceAll("(?i)#S#\\d+#E#", "");
        return recordDec;
    }

    private void doCreateRecordTypeDec(String output, StringBuffer recordCreateDeclare, String packageNm, String key, String value, String typeName) {
        String valueQry = value;
        if (packageNm != null && output.matches("(?i).*?CREATE\\s+OR\\s+REPLACE\\s+PACKAGE\\s+BODY\\s+" + packageNm.trim() + "\\s+.*")) {
            valueQry = valueQry.replaceFirst("(?i)(?<!\\w)RECORD(?!\\w)", "").replaceFirst("(?i)" + typeName.trim(), key).replaceFirst("(?i)(?<!\\w)IS(?!\\w)", "AS");
            recordCreateDeclare.append("CREATE").append(" ").append(valueQry).append(IGaussDBConstants.NEW_LINE);
        }
    }

    private String doRecordAndTableDecInPkgBody(String packageNameParam, StringBuffer recordTypeBodyDec, String singleFnOrPckgVar, boolean isPkgVar) {
        String singleFnOrPckgVariable = singleFnOrPckgVar;
        String pkgVar = packageNameParam;
        String declareBody = null;
        String declareModified = null;
        declareBody = this.getDeclare(singleFnOrPckgVar, isPkgVar, singleFnOrPckgVariable, declareBody);
        pkgVar = this.getPkgVar(pkgVar);
        if (declareBody != null) {
            declareModified = declareBody;
            Pattern patternType = Pattern.compile("(?i)((?<!\\w)type\\s+(\\w+)\\s+(?:is|as)\\s+(?:RECORD|table|varray)\\s*\\(?.*?;)");
            Matcher matcherType = patternType.matcher(declareBody);
            String recordType = null;
            String typeName = null;
            while (matcherType.find()) {
                recordType = matcherType.group(1);
                if (recordType.matches("(?i).*(?<!\\w)RECORD(?!\\w).*") && !QueryConversionUtility.isGaus100()) {
                    typeName = matcherType.group(2);
                    OracleMigrationService.addCreateTypeMap(QueryConversionUtility.toUpper(typeName.trim() + "_" + "record"), "RECORD_DATATYPE");
                    declareModified = this.doDecRecordTypesInPckgBody(pkgVar, recordTypeBodyDec, typeName, declareModified, recordType);
                    continue;
                }
                declareModified = this.getUpdDeclare(declareModified, recordType);
                if (FeatureLoaderExtended.getBooleanProperty("pkgSchemaNaming")) continue;
                declareModified = declareModified.replaceAll("(?<!\\w)" + typeName + "(?!\\w)", packageNameParam + "#" + typeName);
            }
            singleFnOrPckgVariable = singleFnOrPckgVariable.replace(declareBody, declareModified);
        }
        return singleFnOrPckgVariable;
    }

    private String getUpdDeclare(String updDeclare, String recordType) {
        String declareModified = updDeclare;
        String varrayOrRecordMod = "";
        varrayOrRecordMod = recordType;
        if (recordType.matches("(?i).*\\s+INDEX\\s+BY.*")) {
            varrayOrRecordMod = recordType.substring(0, QueryConversionUtility.toLower(recordType).indexOf("index"));
        }
        if (!varrayOrRecordMod.trim().endsWith(";")) {
            varrayOrRecordMod = varrayOrRecordMod + ";";
        }
        this.varrayTablematcher = this.varrayTablePat.matcher(varrayOrRecordMod);
        if (this.varrayTablematcher.find()) {
            this.tableDataType = this.varrayTablematcher.group(2);
        }
        this.doAddVarrayVarsToCreateMap(varrayOrRecordMod);
        OracleUtility oracleUtil = new OracleUtility();
        String varraySize = oracleUtil.doGetVarraySize(this.tableDataType);
        varrayOrRecordMod = varrayOrRecordMod.replaceFirst("(?i)(?<!\\w)TABLE(?!\\w)", "VARRAY(" + varraySize + ")");
        declareModified = declareModified.replace(recordType, varrayOrRecordMod);
        return declareModified;
    }

    private String getPkgVar(String input) {
        int dotIndex;
        String pkgVar = input;
        if (pkgVar != null && (dotIndex = pkgVar.indexOf(46)) != -1 && dotIndex + 1 < pkgVar.length()) {
            String schemaName = pkgVar.substring(0, dotIndex + 1);
            if (FeatureLoader.getBooleanProperty("pkgSchemaNaming")) {
                pkgVar = pkgVar.replace(schemaName, "");
            }
        }
        return pkgVar;
    }

    private String getDeclare(String singleFnOrPckgVar, boolean isPkgVar, String singleFnOrPckgVariable, String input) {
        String declareBody = input;
        if (!isPkgVar) {
            this.declareMatcher = declarePattern.matcher(singleFnOrPckgVariable);
            if (this.declareMatcher.find()) {
                declareBody = this.declareMatcher.group(1);
            }
        } else {
            declareBody = singleFnOrPckgVar;
        }
        return declareBody;
    }

    private String doDecRecordTypesInPckgBody(String packageNameParam, StringBuffer recordTypeBodyDec, String typeName, String declareModified, String recordType) {
        String declareQryModified = declareModified.replace(recordType, "");
        String typeStr = recordType.replaceFirst("(?i)(?<!\\w)RECORD(?!\\w)", "").replaceFirst("(?i)(?<!\\w)IS(?!\\w)", "AS");
        if (packageNameParam != null && !QueryConversionUtility.equalCheck(packageNameParam, "") && typeName != null) {
            String separator = ".";
            if (!FeatureLoader.getBooleanProperty("pkgSchemaNaming")) {
                separator = "#";
            }
            typeStr = typeStr.replaceFirst("(?i)" + typeName.trim(), packageNameParam + separator + typeName);
        }
        recordTypeBodyDec.append("CREATE").append(" ").append(typeStr).append(IGaussDBConstants.NEW_LINE);
        return declareQryModified;
    }

    private String removePkgEnd(String input) {
        String output = QueryConversionUtility.doReplaceSpecificGrp(input, "(?i).*((?<!\\w)end(?!\\w).*)", "", "", 1, false);
        return output;
    }

    private List<String> processPkgSpecification(String output, String pkgSchemaNameParam) throws MigrationServiceException {
        List<String> refCursorVariableList = this.getRefCurList(output);
        HashMap<String, String> tableVarrayVariable = new HashMap<String, String>(10);
        this.getVarrayVariableMap(output, tableVarrayVariable);
        Pattern getPkgName = Pattern.compile("(?i)(?<!\\w)package\\s+(\"?\\w*\"?\\.?\"?\\w+\"?)");
        Matcher getPkgMatcher = getPkgName.matcher(output);
        String packageNameStr = "";
        if (getPkgMatcher.find()) {
            packageNameStr = this.getTempSet(refCursorVariableList, getPkgMatcher);
        }
        for (Map.Entry entry : tableVarrayVariable.entrySet()) {
            String type = (String)entry.getKey();
            String typeValue = (String)entry.getValue();
            OracleMigrationService.addPackageNameMap(QueryConversionUtility.toLower(type), typeValue);
            OracleMigrationService.addPackageNameMap(QueryConversionUtility.toLower(packageNameStr + "." + type), typeValue);
            int dotIndex = packageNameStr.indexOf(46);
            if (dotIndex != -1 && dotIndex + 1 < packageNameStr.length()) {
                OracleMigrationService.addPackageNameMap(QueryConversionUtility.toLower(packageNameStr.substring(dotIndex + 1) + "." + type), typeValue);
            }
            if (pkgSchemaNameParam != null && !QueryConversionUtility.equalCheck(pkgSchemaNameParam, packageNameStr)) {
                OracleMigrationService.addPackageNameMap(QueryConversionUtility.toLower(pkgSchemaNameParam + "." + type), typeValue);
            }
            HashSet<String> tempSet = new HashSet<String>(10);
            tempSet.add(QueryConversionUtility.toLower(type));
            OracleMigrationService.addRefCursorFileMap(QueryConversionUtility.toLower(packageNameStr), tempSet);
            this.doAddVarrayVarsToCreateMap(typeValue);
            this.doAddRecordVarsToCreateMap(typeValue);
        }
        HashSet<String> subTypeSet = new HashSet<String>(10);
        subTypeSet.addAll(this.ddlHandler.getSubTypeMapKey());
        OracleMigrationService.addRefCursorFileMap(QueryConversionUtility.toLower(packageNameStr), subTypeSet);
        List<String> pkgVarsList = this.getPkgVarList(output, packageNameStr);
        return pkgVarsList;
    }

    private String getTempSet(List<String> refCursorVariableList, Matcher getPkgMatcher) {
        String packageNameStr = getPkgMatcher.group(1);
        packageNameStr = packageNameStr != null ? packageNameStr : "";
        int dotIndex = 0;
        for (String refCursor : refCursorVariableList) {
            OracleMigrationService.addPackageNameMap(QueryConversionUtility.toLower(refCursor), "SYS_REFCURSOR");
            OracleMigrationService.addPackageNameMap(QueryConversionUtility.toLower(packageNameStr + "." + refCursor), "SYS_REFCURSOR");
            if (!FeatureLoader.getBooleanProperty("pkgSchemaNaming") && (dotIndex = packageNameStr.indexOf(".")) != -1 && dotIndex + 1 < packageNameStr.length()) {
                OracleMigrationService.addPackageNameMap(QueryConversionUtility.toLower(packageNameStr.substring(dotIndex + 1) + "." + refCursor), "SYS_REFCURSOR");
            }
            HashSet<String> tempSet = new HashSet<String>(10);
            tempSet.add(QueryConversionUtility.toLower(refCursor));
            OracleMigrationService.addRefCursorFileMap(QueryConversionUtility.toLower(packageNameStr), tempSet);
        }
        return packageNameStr;
    }

    private List<String> getRefCurList(String output) {
        List<String> refCursorVariableList = new ArrayList<String>(10);
        refCursorVariableList = QueryConversionUtility.getMatchedGrpsInLst(output, "(?i)(type\\s+(\\w+)\\s+(?:is|as)\\s+ref\\s+cursor(?!\\w).*?;)", 2, refCursorVariableList);
        return refCursorVariableList;
    }

    private List<String> getPkgVarList(String output, String packageNameParam) throws MigrationServiceException {
        List<String> pkgVarsList = null;
        Pattern getPkgVar = Pattern.compile("(?i)(?<!\\w)package\\s+\"?\\w*\"?\\.?\"?\\w+\"?.*?(?<!\\w)(AS|IS)(?!\\w)(.*)");
        Matcher pkgVarMatcher = getPkgVar.matcher(output);
        if (pkgVarMatcher.find()) {
            String declaredPkgVars = pkgVarMatcher.group(2);
            declaredPkgVars = declaredPkgVars.replaceAll("(?i)#S#\\d+#E#", "");
            LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
            declaredPkgVars = QueryConversionUtility.getSingleQuoteMap(declaredPkgVars, quoteMap);
            pkgVarsList = this.doGetPkgVarLst(packageNameParam, declaredPkgVars, "S");
            for (int iIndex = 0; iIndex < pkgVarsList.size(); ++iIndex) {
                String insertScript = QueryConversionUtility.getRplFromMap(pkgVarsList.get(iIndex), quoteMap, "(##QUOTE##\\d+#)");
                if (insertScript.contains("trunc")) {
                    insertScript = QueryConversionUtility.doReplaceTrunc(insertScript);
                }
                if (insertScript.matches("(?i).*(?<!\\w)q\\s*\\'.*")) {
                    insertScript = OracleQueryKeywordReplacerExt.doPutQuoteChange(insertScript);
                }
                pkgVarsList.set(iIndex, insertScript);
            }
        }
        return pkgVarsList;
    }

    private void getVarrayVariableMap(String output, Map<String, String> tableVarrayVariable) {
        String[] patternList;
        for (String patternStr : patternList = new String[]{"(?i)(type\\s+(\\w+)\\s+(?:is|as)\\s+(table|varray|RECORD)(?!\\w).*?;)", "(?i)(subtype\\s+(\\w+)\\s+(?:is|as)\\s+(.*?)(;|$))"}) {
            Pattern pattern = Pattern.compile(patternStr, 2);
            Matcher matcher = pattern.matcher(output);
            while (matcher.find()) {
                tableVarrayVariable.put(matcher.group(2), matcher.group(1));
            }
        }
    }

    private void doAddRecordVarsToCreateMap(String typeValue) {
        Matcher recordMat = RECORD_PAT.matcher(typeValue);
        while (recordMat.find()) {
            OracleMigrationService.addCreateTypeMap(QueryConversionUtility.toUpper(recordMat.group(1) + "_" + "record"), "RECORD_DATATYPE");
        }
    }

    private void doAddVarrayVarsToCreateMap(String typeValue) {
        this.varrayTablematcher = this.varrayTablePat.matcher(typeValue);
        if (this.varrayTablematcher.find()) {
            this.tableDataType = this.varrayTablematcher.group(2);
            if (this.tableDataType.matches("(?i).*\\s+INDEX\\s+BY.*")) {
                this.tableDataType = this.tableDataType.substring(0, QueryConversionUtility.toLower(this.tableDataType).indexOf("index"));
            }
            this.tableDataType = this.ddlHandler.checkAndReplaceDataType(this.tableDataType);
            OracleMigrationService.addCreateTypeMap(QueryConversionUtility.toUpper(this.varrayTablematcher.group(1).trim()) + "_VARRAY", this.tableDataType);
        }
    }

    private List<String> doGetPkgVarLst(String packageNameParam, String declaredPkgVars, String specOrBody) throws MigrationServiceException {
        int dotIdx;
        String pkgNameVar = packageNameParam;
        String declaredPackageVars = OracleUtility.doChangeDataType(declaredPkgVars);
        declaredPackageVars = OracleQueryKeywordReplacer.changePlsIntegerToInteger(declaredPackageVars);
        declaredPackageVars = OracleUtility.doChangeDefaultFunctions(declaredPackageVars);
        String packageSchemaName = "current_user";
        if (pkgNameVar.contains(".") && (dotIdx = pkgNameVar.indexOf(46)) != -1) {
            packageSchemaName = pkgNameVar.substring(0, dotIdx).trim();
            pkgNameVar = pkgNameVar.substring(dotIdx + 1).trim();
        }
        ArrayList<String> pkgVarsList = new ArrayList<String>(10);
        String[] varArray = QueryConversionUtility.doGetArrSplit(declaredPackageVars, ";");
        for (int iIndex = 0; iIndex < varArray.length; ++iIndex) {
            String var = varArray[iIndex].trim() + ";";
            if (QueryConversionUtility.containsCheck(var, "END")) continue;
            this.getPkgVarLstFromDeclaredPkgLst(pkgNameVar, specOrBody, packageSchemaName, var);
            pkgVarsList.addAll(this.getPkgVarLstFromDeclaredPkgLst(pkgNameVar, specOrBody, packageSchemaName, var));
        }
        return pkgVarsList;
    }

    private List<String> getPkgVarLstFromDeclaredPkgLst(String packageNameParam, String specOrBody, String packageSchemaName, String var) {
        Pattern varPat;
        Matcher match;
        String variable = var;
        ArrayList<String> pkgVarsList = new ArrayList<String>(10);
        if (this.isVarFuncProcCursor(variable = this.getVar(variable)) && (match = (varPat = Pattern.compile("(?i)(\\w+)\\s+(\\/?\\*?\\s*constant\\s*\\*?\\/?\\s+)?(.*?)((?::=\\s*|default\\s+)(.*)|;)")).matcher(variable)).find()) {
            String varNme = match.group(1);
            Set<String> tempVarSet = this.getTempVarSet(packageNameParam, varNme);
            String datatype = match.group(3).trim();
            datatype = this.ddlHandler.checkAndReplaceDataType(datatype);
            if (this.isType(varNme)) {
                datatype = this.addPkgNmeToMap(packageNameParam, packageSchemaName, varNme, datatype);
                this.ddlHandler.handlePackageName(packageNameParam, packageSchemaName, varNme, tempVarSet, datatype);
                OracleMigrationService.setPackageVarMap(QueryConversionUtility.toLower(packageNameParam), tempVarSet);
                String constant = match.group(2);
                boolean isConstant = constant != null;
                boolean expressionInd = false;
                String defaultVal = match.group(5);
                if (defaultVal != null && this.isDefaultValueHasExpr(defaultVal = this.getDefVal(defaultVal))) {
                    expressionInd = true;
                    defaultVal = this.getDefValForGaussDBA(defaultVal);
                }
                defaultVal = defaultVal == null ? "NULL" : defaultVal;
                StringBuffer sbuff = new StringBuffer();
                if (this.isPackageVarLocalTable(datatype)) {
                    this.ddlHandler.setBufferConent(packageNameParam, packageSchemaName, specOrBody, varNme, sbuff);
                    this.ddlHandler.setBufferContentExt(isConstant, datatype, defaultVal, expressionInd, sbuff);
                    pkgVarsList.add(sbuff.toString());
                }
                if (QueryConversionUtility.isGaus100() && FeatureLoader.getStringProperty("pkgvariable100").equalsIgnoreCase("localtable") && !datatype.equalsIgnoreCase("EXCEPTION") && !"NULL".equalsIgnoreCase(datatype)) {
                    this.ddlHandler.setBufferConent(packageNameParam, packageSchemaName, specOrBody, varNme, sbuff);
                    this.ddlHandler.setBufferContentExt(isConstant, datatype, defaultVal, expressionInd, sbuff);
                    pkgVarsList.add(sbuff.toString());
                }
            }
        }
        return pkgVarsList;
    }

    private boolean isVarFuncProcCursor(String variable) {
        return !QueryConversionUtility.toLower(variable).startsWith("cursor") && !QueryConversionUtility.toLower(variable).startsWith("function") && !QueryConversionUtility.toLower(variable).startsWith("procedure") && !variable.matches("(?i)type\\s+.*?\\s+(is|as)\\s+(record|ref).*");
    }

    private boolean isPackageVarLocalTable(String datatype) {
        return FeatureLoader.getStringProperty("pkgvariable").equalsIgnoreCase("localtable") && !datatype.equalsIgnoreCase("EXCEPTION") && !"NULL".equalsIgnoreCase(datatype);
    }

    private boolean isType(String varNme) {
        return !varNme.equalsIgnoreCase("TYPE") && !varNme.equalsIgnoreCase("SUBTYPE") && !varNme.equalsIgnoreCase("PRAGMA");
    }

    private boolean isDefaultValueHasExpr(String defaultVal) {
        return defaultVal.matches("(?i).*(?<!\\w)(SYSDATE|CURRENT_DATE|TIMESTAMP|LOCALTIMESTAMP|NEXTVAL|CURRVAL|CURRENT_TIMESTAMP|DBTIMEZONE|SESSIONTIMEZONE|SYSTIMESTAMP)(?!\\w).*") || defaultVal.contains("(") && defaultVal.contains(")");
    }

    private Set<String> getTempVarSet(String packageNameParam, String varNme) {
        HashSet<String> tempVarSet = new HashSet<String>(10);
        tempVarSet.add(QueryConversionUtility.toLower(varNme));
        tempVarSet.add(QueryConversionUtility.toLower(packageNameParam + "." + varNme));
        return tempVarSet;
    }

    private String addPkgNmeToMap(String packageNameParam, String packageSchemaName, String varNme, String input) {
        String datatype = input;
        OracleUtility oracleUtil = new OracleUtility();
        datatype = oracleUtil.doRplPercentageType(datatype, this.schema);
        if (!varNme.equalsIgnoreCase("end")) {
            OracleMigrationService.addPackageNameMap(QueryConversionUtility.toLower(packageNameParam + "." + varNme), packageSchemaName + "-" + packageNameParam + "-" + datatype);
        }
        return datatype;
    }

    private String getDefValForGaussDBA(String defValue) {
        String defaultVal = defValue;
        if (!QueryConversionUtility.isGaus100()) {
            defaultVal = "$q$" + defaultVal + "$q$";
        }
        return defaultVal;
    }

    private String getDefVal(String defValue) {
        String defaultVal = defValue;
        defaultVal = (defaultVal = defaultVal.trim()).endsWith(";") ? defaultVal.substring(0, defaultVal.length() - 1) : defaultVal;
        return defaultVal;
    }

    private String getVar(String var) {
        String variable = var;
        if (QueryConversionUtility.toLower(variable).contains("not ") && QueryConversionUtility.toLower(variable).contains(" null")) {
            variable = variable.replaceAll("(?i)(?<!\\w)\\s*not\\s+null(?!\\w)", "");
        }
        return variable;
    }

    private String doProcessFnProc(List<IQueryPatternsBO> queryPatterns, List<IQuerySplitterPatternsBO> querySplitterPatterns, List<IQueryPatternsBO> schemaPatterns, List<IBulkSplitPatternsBO> bLogicSplitPatterns, List<IBulkSplitPatternsBO> bLogicSplitter, int position, String input) throws InterruptedException {
        String output = input;
        try {
            Matcher funcMatcher = FUNCTION_PROCEDURE_PAT.matcher(input);
            while (funcMatcher.find()) {
                output = this.getOutForMatch(output, funcMatcher);
            }
            if (!QueryConversionUtility.isGaus100()) {
                output = this.doMigGaussDBA(bLogicSplitPatterns, position, output);
            }
            output = OraclePostProcessing.doPostBLogicChanges(output, this.fileName);
        }
        catch (MigrationServiceException e) {
            QueryUtilityExt.handleInterruptedException(this.fileName, e);
            output = this.catchMigSerExc(this.fileName, position, input, e);
        }
        return output;
    }

    private String getOutForMatch(String input, Matcher funcMatcher) {
        String output = input;
        String functionName = funcMatcher.group(1);
        if (functionName != null && functionName.contains("\"")) {
            String functionNameWithoutQuote = functionName.replaceAll("\"", "");
            output = output.replace(functionName, functionNameWithoutQuote);
            if (!this.isPackage && functionNameWithoutQuote.contains(".")) {
                OracleMigrationService.addCreateTypeMap(functionNameWithoutQuote + "_MIG_PROC", "_MIG_PROC".substring(1));
            }
        } else if (functionName != null && !this.isPackage && functionName.contains(".")) {
            OracleMigrationService.addCreateTypeMap(functionName + "_MIG_PROC", "_MIG_PROC".substring(1));
        }
        this.isAnonymousBlck = false;
        return output;
    }

    private String doMigGaussDBA(List<IBulkSplitPatternsBO> bLogicSplitPatterns, int position, String input) {
        String output = input;
        output = OraclePreQueryProcessing.doPreBLogicChanges(output);
        for (IBulkSplitPatternsBO typeBO : bLogicSplitPatterns) {
            HashMap<String, String> quoteList = new HashMap<String, String>(10);
            output = QueryConversionUtility.getSingleOrDoubleQuoteMap(output, quoteList, "'", "\\'.*?\\'", SELECT_REPLACE_STR);
            boolean isExcludePatternValidation = QueryConversionUtility.excludePatternValidation(typeBO.getExcludePattern(), output);
            output = QueryConversionUtility.getRplFromMap(output, quoteList, SELECT_RPL_PATTERN);
            if (!isExcludePatternValidation) continue;
            output = this.ddlHandler.doMigrateDBObjects(this.fileName, position, output, typeBO);
            break;
        }
        return output;
    }

    private String catchMigSerExc(String fileName, int position, String input, MigrationServiceException e) {
        ErrorLoggerUtility.failedQryCnt();
        ErrorLoggerUtility.failedFileCnt(fileName);
        logger.error(e.getMessage());
        logger.error("[DSC_ERR_004_040] " + MessageLoader.getMessage("DSC_ERR_004_040") + " " + fileName + " " + MessageLoader.getMessage("queryPosInfo") + position);
        String output = input;
        return output;
    }

    private List<String> getFnProcPackage(String input, StringBuffer recordTypeBodyDec) throws MigrationServiceException {
        List<String> fnProcList = null;
        LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
        String inputQry = QueryConversionUtility.getSingleQuoteMap(input, quoteMap);
        Matcher packageMatcher = this.getPkgFinderMatcher(inputQry);
        if (packageMatcher.find()) {
            String packageVariables = packageMatcher.group(5);
            this.packageNameFnProc = this.getPackageName(packageMatcher);
            packageVariables = this.doRecordAndTableDecInPkgBody(this.packageNameFnProc, recordTypeBodyDec, packageVariables, true);
            this.addPkgBodyFileMap(this.packageNameFnProc);
            fnProcList = new ArrayList<String>(10);
            String output = inputQry;
            ArrayList<String> fnProcNameList = new ArrayList<String>(10);
            List<String> refCursorVariableList = this.getRefCursVariablesList(fnProcList, packageVariables, this.packageNameFnProc);
            this.getFnProcPackageSub(fnProcList, quoteMap, output, fnProcNameList, refCursorVariableList);
            if (!QueryConversionUtility.isGaus100() || FeatureLoaderExtended.getBooleanProperty("supportPkgSplitDBT")) {
                fnProcList = this.getFnProcList(fnProcList, quoteMap, this.packageNameFnProc, this.delimiterFnProc, fnProcNameList);
            }
        } else {
            this.doProcessSubtypeInSpec(inputQry);
        }
        return fnProcList;
    }

    private void getFnProcPackageSub(List<String> fnProcList, Map<String, String> quoteMap, String input, List<String> fnProcNameList, List<String> refCursorVariableList) {
        String output = input;
        this.delimiterFnProc = this.getDelimeter();
        boolean isFirstPkgOrFunc = true;
        Pattern funcFinder = Pattern.compile("(?i)((?:(?<!\\w|\\.)procedure(?!\\w)|(?<=\\s|^)function(?=\\s|$)).*?)(?:(?<!\\w|\\.)procedure(?!\\w)|(?<=\\s|^)function(?=\\s|$)|$)");
        Matcher fnMatcher = funcFinder.matcher(output);
        StringBuffer rplProcName = new StringBuffer();
        while (fnMatcher.find()) {
            String function = fnMatcher.group(1);
            output = this.removeFunction(output, function);
            int idx = function.indexOf(32);
            String pkgProcFn = function.substring(idx).trim();
            String procFn = function.substring(0, idx);
            int procNmIndex = this.getProcNmIndex(pkgProcFn);
            String procFnNme = pkgProcFn.substring(0, procNmIndex).trim();
            function = procFn + " " + procFnNme + " " + pkgProcFn.substring(procNmIndex);
            function = this.getFnProcName(fnProcNameList, rplProcName, function, procFnNme);
            if (!QueryConversionUtility.isGaus100() || FeatureLoaderExtended.getBooleanProperty("supportPkgSplitDBT")) {
                isFirstPkgOrFunc = this.addFnProcListData(fnProcList, output, function, refCursorVariableList, isFirstPkgOrFunc);
                fnMatcher = funcFinder.matcher(output);
                continue;
            }
            output = QueryConversionUtility.getRplFromMap(output, quoteMap, "(##QUOTE##\\d+#)");
            fnProcList.add(output);
            break;
        }
    }

    private String getFnProcName(List<String> fnProcNameList, StringBuffer rplProcName, String functionParam, String procFnNmeParam) {
        String function = functionParam;
        String procFnNme = procFnNmeParam;
        if (procFnNme.contains(".")) {
            StringBuffer funcBuff = new StringBuffer(function);
            procFnNme = this.getFuncBuffValue(function, procFnNme, funcBuff);
            function = funcBuff.toString();
        }
        String newProcName = this.getNewProcName(this.packageNameFnProc, this.delimiterFnProc, procFnNme);
        fnProcNameList.add(procFnNme);
        if (!QueryConversionUtility.isGaus100() || FeatureLoaderExtended.getBooleanProperty("supportPkgSplitDBT")) {
            function = this.getReplacedFnName(function, procFnNme, newProcName, rplProcName, this.delimiterFnProc);
        }
        this.addPkgNameMap(this.packageNameFnProc, procFnNme, newProcName, this.delimiterFnProc);
        this.addPkgFileMapFrmSet(function);
        return function;
    }

    public String removeFunction(String input, String function) {
        String output = input;
        if (!QueryConversionUtility.isGaus100() || FeatureLoaderExtended.getBooleanProperty("supportPkgSplitDBT")) {
            output = output.replace(function, "");
        }
        return output;
    }

    public String getNewProcName(String packageNameStr, String delimiter, String procFnNme) {
        String newProcName = "";
        if (!QueryConversionUtility.isGaus100() || FeatureLoaderExtended.getBooleanProperty("supportPkgSplitDBT")) {
            newProcName = this.ddlHandler.doGetNewProcFnNme(packageNameStr, procFnNme, delimiter);
        }
        return newProcName;
    }

    public String getDelimeter() {
        String delimiter = "";
        delimiter = !QueryConversionUtility.isGaus100() ? (FeatureLoader.getBooleanProperty("pkgSchemaNaming") ? "." : "#") : "#";
        return delimiter;
    }

    private void doProcessSubtypeInSpec(String inputQry) {
        Pattern packageSchemaFinder = Pattern.compile("(?i).*create\\s+(?:or\\s+replace\\s+)?package\\s+(\"?\\w*\"?\\.?\"?\\w+\"?)\\s+(?:(?<!\\w)as|(?<!\\w)is)\\s+?(.*)");
        Matcher schemaMatcher = packageSchemaFinder.matcher(inputQry);
        if (schemaMatcher.find()) {
            String packageNameStr = schemaMatcher.group(1);
            String packageVariables = schemaMatcher.group(2);
            if (packageNameStr != null && packageVariables != null) {
                this.ddlHandler.doHandleSubType(packageNameStr, packageVariables);
            }
        }
    }

    private List<String> getFnProcList(List<String> fnProcList, Map<String, String> quoteMap, String packageNameParam, String delimiter, List<String> fnProcNameList) {
        List<String> functionProcList = this.ddlHandler.localFnProcNameReplacer(fnProcList, fnProcNameList, delimiter, packageNameParam);
        this.getFnReturnType(functionProcList);
        functionProcList = this.getfunProcLst(functionProcList, quoteMap);
        return functionProcList;
    }

    private boolean addFnProcListData(List<String> fnProcList, String output, String function, List<String> refCursorVariableList, boolean isPackageOrFunc) {
        boolean isFirstPkgOrFunc = isPackageOrFunc;
        String functionQry = this.ddlHandler.localRefCursorReplacement(function, refCursorVariableList);
        Matcher matcher = FN_CREATE_PATTERN.matcher(output);
        String createStr = null;
        createStr = matcher.find() ? (isFirstPkgOrFunc ? matcher.group() : matcher.group(1)) : "CREATE OR REPLACE ";
        isFirstPkgOrFunc = false;
        functionQry = !QueryConversionUtility.isGaus100() || QueryConversionUtility.isGaus100() && FeatureLoaderExtended.getBooleanProperty("supportPkgSplitDBT") ? createStr + functionQry + "/" : createStr + functionQry;
        fnProcList.add(functionQry);
        return isFirstPkgOrFunc;
    }

    private void addPkgFileMapFrmSet(String function) {
        Set<String> getPkgNames = QueryConversionUtility.getUniqueMatchedGrpsInSet(function, "(?:\"?\\w+\"?\\s*\\.)?(\"?\\w+\"?\\s*\\.\\s*\"?\\w+\"?)", 1);
        if (!getPkgNames.isEmpty()) {
            OracleMigrationService.addPackageFileMapFrmSet(this.fileName, getPkgNames);
        }
    }

    private void addPkgNameMap(String packageNameParam, String procFnNme, String newProcName, String delimiter) {
        int dotIndex = packageNameParam.indexOf(46);
        if (dotIndex != -1) {
            if (dotIndex + 1 < packageNameParam.length()) {
                String tempPkg = packageNameParam.substring(dotIndex + 1);
                OracleMigrationService.addPackageNameMap(QueryConversionUtility.toLower(tempPkg + "." + procFnNme), this.ddlHandler.doGetNewProcFnNme(tempPkg, procFnNme, delimiter));
            }
        } else {
            OracleMigrationService.addPackageNameMap(QueryConversionUtility.toLower(packageNameParam + "." + procFnNme), newProcName);
        }
    }

    private String getReplacedFnName(String function, String procFnNme, String newProcName, StringBuffer rplProcName, String delimiter) {
        String functionQry = function;
        rplProcName.append("(?i)(?<!\\w|\\.|").append(QueryConversionUtility.santizePattern(delimiter)).append(")").append(QueryConversionUtility.santizePattern(procFnNme)).append("(?!\\w)");
        HashMap<String, String> selectList = new HashMap<String, String>(10);
        functionQry = QueryConversionUtility.getSingleOrDoubleQuoteMap(functionQry, selectList, "select", SELECT_PATTERN, SELECT_REPLACE_STR);
        functionQry = QueryConversionUtility.replaceAll(functionQry, rplProcName.toString(), newProcName);
        functionQry = QueryConversionUtility.getRplFromMap(functionQry, selectList, SELECT_RPL_PATTERN);
        rplProcName.setLength(0);
        return functionQry;
    }

    private String getFuncBuffValue(String function, String procFnNme, StringBuffer funcBuff) {
        String procFuncName = procFnNme;
        int index = function.indexOf(procFuncName);
        String tempFnName = procFuncName;
        int dotIndex = procFuncName.indexOf(46);
        if (dotIndex != -1 && dotIndex + 1 < procFuncName.length()) {
            procFuncName = procFuncName.substring(dotIndex + 1);
        }
        if (index != -1) {
            funcBuff.delete(index, index + tempFnName.length());
            funcBuff.insert(index, procFuncName);
        }
        return procFuncName;
    }

    private int getProcNmIndex(String pkgProcFn) {
        int braceIndex;
        int spaceIndex = pkgProcFn.indexOf(32);
        return spaceIndex > (braceIndex = pkgProcFn.indexOf(40)) && braceIndex != -1 ? braceIndex : spaceIndex;
    }

    private List<String> getRefCursVariablesList(List<String> fnProcList, String packageVariables, String packageNameParam) throws MigrationServiceException {
        String packageVar = packageVariables;
        List<String> refCursorVariableList = new ArrayList<String>(10);
        if (!packageVar.isEmpty()) {
            packageVar = !(packageVar = packageVar.replaceAll("(?i)#S#\\d+#E#", "").trim()).endsWith(";") && !packageVar.isEmpty() ? packageVar + ";" : packageVar;
            List<String> pkgVarsList = this.doGetPkgVarLst(packageNameParam, packageVar, "B");
            fnProcList.addAll(pkgVarsList);
            refCursorVariableList = QueryConversionUtility.getMatchedGrpsInLst(packageVar, "(?i)(type\\s+(\\w+)\\s+(?:is|as)\\s+ref\\s+cursor(?!\\w).*?;)", 2, refCursorVariableList);
            if (!refCursorVariableList.isEmpty()) {
                QueryConversionUtility.doCommentSpecificGrp(packageVar, "(?i)(type\\s+(\\w+)\\s+(?:is|as)\\s+ref\\s+cursor(?!\\w).*?;)", 1);
            }
        }
        return refCursorVariableList;
    }

    private void addPkgBodyFileMap(String packageNameParam) {
        String packageParam = packageNameParam;
        if (packageParam != null) {
            int dotIndex = packageParam.indexOf(46);
            if (dotIndex != -1 && dotIndex + 1 < packageParam.length()) {
                String schemaName = packageParam.substring(0, dotIndex + 1);
                if (!FeatureLoader.getBooleanProperty("pkgSchemaNaming")) {
                    packageParam = packageParam.replace(schemaName, "");
                }
            }
            OracleMigrationService.addPackageBodyFileMap(QueryConversionUtility.toLower(packageParam), this.fileName);
        }
    }

    private String getPackageName(Matcher packageMatcher) {
        String packageNameStr = packageMatcher.group(3);
        if (packageNameStr == null) {
            packageNameStr = "";
        }
        return packageNameStr;
    }

    private Matcher getPkgFinderMatcher(String input) {
        Pattern packageFinder = Pattern.compile("(?i).*(create\\s+(or\\s+replace\\s+)?package\\s+body\\s+(\"?\\w*\"?\\.?\"?\\w+\"?)\\s+((?:(?<!\\w)as|(?<!\\w)is)\\s+)?(.*?))(?<!\\w)(function|begin|procedure)(?!\\w)");
        return packageFinder.matcher(input);
    }

    private void getFnReturnType(List<String> fnProcList) {
        int fnProcSize = fnProcList.size();
        if (this.funcReturnPattern == null) {
            this.funcReturnPattern = Pattern.compile("(?i).*?(?<!\\w)function(?!\\w)\\s*(.*?)\\(.*?\\s*(?<!\\w)return(?!\\w)\\s+(.*?)(?<!\\w)(?:I|A)S(?!\\w)");
        }
        for (int iIndex = 0; iIndex < fnProcSize; ++iIndex) {
            String func = fnProcList.get(iIndex);
            Matcher funcParamMat = this.funcReturnPattern.matcher(func);
            if (funcParamMat.find()) {
                OracleMigrationService.addCreateTypeMap(QueryConversionUtility.toUpper(funcParamMat.group(1).trim() + "FUNC"), funcParamMat.group(2).trim());
            }
            ProgressUtil.printProgress();
        }
    }

    private List<String> getfunProcLst(List<String> funcProcedureList, Map<String, String> quoteMap) {
        List<String> fnProcList = funcProcedureList;
        if (fnProcList.isEmpty()) {
            fnProcList = null;
        } else {
            for (int iIndex = 0; iIndex < fnProcList.size(); ++iIndex) {
                String insertScript = QueryConversionUtility.getRplFromMap(fnProcList.get(iIndex), quoteMap, "(##QUOTE##\\d+#)");
                if (QueryConversionUtility.toUpper(insertScript).startsWith("INSERT INTO ")) {
                    if (insertScript.contains("trunc")) {
                        insertScript = QueryConversionUtility.doReplaceTrunc(insertScript);
                    }
                    if (insertScript.matches("(?i).*(?<!\\w)q\\s*\\'.*")) {
                        insertScript = OracleQueryKeywordReplacerExt.doPutQuoteChange(insertScript);
                    }
                }
                fnProcList.set(iIndex, insertScript);
            }
        }
        return fnProcList;
    }

    private static String removeSqlerrmArgs(String output) {
        String outputQry = output;
        outputQry = QueryConversionUtility.canonicalizeString(outputQry);
        Matcher matcher = SQLERRM_PAT.matcher(outputQry);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(buffer, "SQLERRM");
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private String addSetPackageName(String input, boolean percTypeFlag) {
        if (FeatureLoader.getBooleanProperty("addPackageNameList") && percTypeFlag) {
            Matcher matcher;
            if (this.setPackagePattern == null) {
                this.setPackagePattern = Pattern.compile("(?i).*?create\\s+or\\s+replace\\s+(?:procedure|function)\\s+(?:#S#\\d+#E#\\s*)?(?<schema>\\\"?\\w*\\\"?\\.?\\\"?\\w+\\\"?#?)");
            }
            if ((matcher = this.setPackagePattern.matcher(input)).find()) {
                String schemaName = matcher.group("schema");
                if (schemaName != null && !schemaName.isEmpty() && schemaName.contains(".") && FeatureLoader.getBooleanProperty("pkgSchemaNaming")) {
                    schemaName = schemaName.substring(0, schemaName.indexOf(46));
                    return "set package_name_list='" + schemaName + "';" + System.lineSeparator();
                }
                if (schemaName != null && !schemaName.isEmpty() && !FeatureLoader.getBooleanProperty("pkgSchemaNaming") && schemaName.endsWith("#")) {
                    schemaName = QueryConversionUtility.finderGroup(schemaName, "(?i)(\\w+)#", 1);
                    return "set package_name_list='" + schemaName + "';" + System.lineSeparator();
                }
            }
        }
        return null;
    }

    private String addPackageTag(String input) {
        boolean sCondition;
        boolean fCondition = FeatureLoader.getBooleanProperty("addPackageTag") && !QueryConversionUtility.isGaus100();
        boolean bl = sCondition = QueryConversionUtility.isGaus100() && FeatureLoader.getBooleanProperty("addPackageTag100");
        if ((fCondition || sCondition) && this.isPackage) {
            if (this.addPackagePattern == null) {
                this.addPackagePattern = Pattern.compile("(?i)(?:FUNCTION|PROCEDURE)\\s+(?:#S#\\d+#E#\\s*)?\\\"?\\w*\\\"?\\.?\\\"?\\w+\\\"?(.*?)(?<!\\w)(AS|IS)(?!\\w)", 2);
            }
            Matcher matcher = this.addPackagePattern.matcher(input);
            int tempEnd = 0;
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                int startindex = matcher.start(1);
                int endIndex = matcher.end(1);
                sb.append(input.substring(tempEnd, startindex));
                sb.append(input.substring(startindex, endIndex));
                sb.append("PACKAGE ");
                sb.append(matcher.group(2));
                tempEnd = matcher.end(2);
            }
            sb.append(input.substring(tempEnd));
            return sb.toString();
        }
        return input;
    }

    public void addGrantLine(String input) {
        if (this.grantFuncPattern == null) {
            this.grantFuncPattern = Pattern.compile("(?i)(?:FUNCTION|PROCEDURE)\\s+(?:#S#\\d+#E#\\s*)?((?:\\w+\\.)?\\w+(?:\\#|\\.)\\w+)\\s*(?:\\((.*?)\\))?");
        }
        Matcher matcher = this.grantFuncPattern.matcher(input);
        if (this.grantDataTypesPattern == null) {
            this.grantDataTypesPattern = GRANT_DATA_TYPES_PAT;
        }
        ArrayList<String> listType = new ArrayList<String>(10);
        String joinFuncType = null;
        while (matcher.find()) {
            String name = matcher.group(1);
            String parenthesis = matcher.group(2);
            if (parenthesis != null && !QueryConversionUtility.isGaus100()) {
                String[] commaSplitArrays;
                for (String type : commaSplitArrays = QueryConversionUtility.doGetArrSplit(parenthesis, ",")) {
                    Matcher dataTypesMatch;
                    if (QueryConversionUtility.containsCheck(type, " out ") || !(dataTypesMatch = this.grantDataTypesPattern.matcher(type)).find()) continue;
                    listType.add(dataTypesMatch.group(1));
                }
                String joinType = String.join((CharSequence)", ", listType);
                joinFuncType = "GRANT EXECUTE ON FUNCTION " + name + "(" + joinType + ")" + " " + "TO ";
                this.listFunc.add(joinFuncType);
            } else {
                joinFuncType = "GRANT EXECUTE ON FUNCTION " + name + "()" + " " + "TO ";
                this.listFunc.add(joinFuncType);
            }
            listType.clear();
        }
    }

    private String addGrantLineFinal(String input) {
        Map<String, String> createTypesDDLMap = OracleMigrationService.getCreateTypeMap();
        this.updateGrantList(createTypesDDLMap);
        String inputQry = input;
        if (QueryConversionUtility.containsCheck(inputQry, "grant")) {
            inputQry = this.handleGrantClause(inputQry);
        } else {
            this.pkgName = OraclePostProcessing.getPackageName(inputQry);
            if (this.pkgName != null && !this.pkgName.isEmpty() && (this.pkgName.trim().endsWith("#") || this.pkgName.trim().endsWith("."))) {
                this.pkgName = this.pkgName.substring(0, this.pkgName.length() - 1);
            }
            StringBuffer sb = new StringBuffer();
            boolean isLooped = false;
            for (Map.Entry<String, String> entry : createTypesDDLMap.entrySet()) {
                if (!entry.getKey().endsWith("_pkggrant") || packageWithSchemaName.isEmpty() || this.pkgName == null || this.pkgName.isEmpty() || !entry.getValue().equalsIgnoreCase(packageWithSchemaName)) continue;
                isLooped = true;
                sb.append(inputQry);
                for (String user : this.listGrant) {
                    for (String func : this.listFunc) {
                        if (!func.contains(this.pkgName) || !listUser.contains(user.trim())) continue;
                        sb.append(func).append(" ").append(user).append(";");
                    }
                }
            }
            if (isLooped) {
                inputQry = sb.toString();
            }
        }
        return inputQry;
    }

    private String handleGrantClause(String inputQry) {
        if (this.grantLinePattern == null) {
            this.grantLinePattern = GRANT_LINE_PAT;
        }
        Matcher grantMatch = this.grantLinePattern.matcher(inputQry);
        String userName = null;
        StringBuffer sb = new StringBuffer();
        while (grantMatch.find()) {
            this.pkgName = grantMatch.group(1);
            OracleMigrationService.addCreateTypeMap(this.pkgName + "_pkggrant", this.pkgName);
            userName = grantMatch.group(2);
            listUser.add(userName.trim());
            if (!this.listGrant.contains(userName.trim())) {
                this.listGrant.add(userName);
                for (String user : this.listGrant) {
                    for (String func : this.listFunc) {
                        if (OracleMigrationService.getCreateTypeMap().containsKey(userName + "_" + "grant") || inputQry.contains(func)) continue;
                        sb.append(func).append(" ").append(user).append(";");
                    }
                }
                this.listGrant.clear();
            }
            if (OracleMigrationService.getCreateTypeMap().containsKey(userName + "_" + "grant")) continue;
            OracleMigrationService.addCreateTypeMap(userName + "_" + "grant", userName);
        }
        inputQry = sb.toString();
        return inputQry;
    }

    private void updateGrantList(Map<String, String> createTypesDDLMap) {
        for (Map.Entry<String, String> entry : createTypesDDLMap.entrySet()) {
            if (!entry.getKey().endsWith("_grant") || this.listGrant.contains(entry.getValue())) continue;
            this.listGrant.add(entry.getValue());
        }
    }
}

