/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.oracle;

import com.huawei.db.migration.oracle.OracleMapHelper;
import com.huawei.db.migration.services.OracleMigrationService;
import com.huawei.db.migration.util.ColumnSplitter;
import com.huawei.db.migration.util.FeatureLoader;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OracleMapHelperExt {
    private static final Logger logger = LogManager.getLogger(OracleMapHelperExt.class);

    public static String doRplNoLogging(String output) {
        String outputQry = output;
        Pattern pattern = Pattern.compile("(?i)(?<!\\w)nologging(?!\\w)");
        Matcher matcher = pattern.matcher(outputQry);
        if (matcher.find()) {
            boolean containsIndex = outputQry.matches("(?i).*(?<!\\w)index(?!\\w).*");
            if (containsIndex) {
                boolean containsAlter = outputQry.matches("(?i).*(?<!\\w)alter(?!\\w).*");
                outputQry = containsAlter ? "/* " + outputQry + " " + "*/" : QueryConversionUtility.replace(outputQry, "(?i)(?<!\\w)nologging(?!\\w)", "/* nologging */", true);
            } else {
                outputQry = outputQry.replaceAll("(?i)(?<!\\w)nologging(?!\\w)", "");
                outputQry = QueryConversionUtility.replace(outputQry, "(?i)create\\s", "CREATE UNLOGGED ", true);
            }
        }
        return outputQry;
    }

    public boolean insertAllFn(Map<String, String> parserMap) {
        logger.debug("Insert All Function enabled");
        String selectQry = parserMap.get("selectquery");
        int count = 1;
        StringBuffer outputQry = new StringBuffer("With Sel as (");
        outputQry.append(selectQry).append(")");
        String column = this.getColumnQry(parserMap);
        String intoCond = parserMap.get("insertcond");
        intoCond = intoCond + " ";
        String intoUpper = QueryConversionUtility.toUpper(intoCond);
        boolean isValid = false;
        boolean whenFlag = false;
        boolean elseFlag = false;
        List<Object> intoArr = null;
        List<String> whenArr = null;
        if (!intoUpper.startsWith("INTO")) {
            intoArr = new ArrayList(10);
            whenArr = new ArrayList<String>(10);
            elseFlag = this.chkElseWithSpace(intoUpper, elseFlag);
            intoArr = QueryConversionUtility.getMatchedGrpsInLst(intoCond, "(?<!\\w)into\\s+(.*?)(?<!\\w)(when\\s*|else\\s+|$)", 1, intoArr);
            whenArr = QueryConversionUtility.getMatchedGrpsInLst(intoCond, "(?<!\\w)when\\s*(.*?)(?<!\\w)(then\\s+)", 1, whenArr);
            isValid = true;
            whenFlag = true;
        } else {
            isValid = true;
            intoArr = this.getIntoArry(intoCond);
        }
        StringBuffer output = null;
        for (int iIndex = 0; iIndex < intoArr.size() - 1; ++iIndex) {
            outputQry.append(",").append("ins").append(count++).append(" as ");
            output = new StringBuffer("(");
            output.append(OracleMapHelperExt.getInsertQry(column, (String)intoArr.get(iIndex)));
            this.handleWhenFlag(outputQry, whenArr, whenFlag, output, iIndex);
        }
        String lastQry = OracleMapHelperExt.getInsertQry(column, (String)intoArr.get(intoArr.size() - 1));
        outputQry.append(" ").append(lastQry);
        this.handleElseClause(outputQry, whenArr, whenFlag, elseFlag, lastQry);
        String outputQuery = outputQry.toString().trim();
        String selectComment = parserMap.get("comments");
        outputQuery = OracleMapHelperExt.getInsertOutQuery(outputQuery, selectComment);
        parserMap.put("outputqry", outputQuery);
        return isValid;
    }

    private List<String> getIntoArry(String intoCond) {
        String[] intoArray = intoCond.split("(?i)(?<!\\w)into\\s+");
        ArrayList<String> intoArr = new ArrayList<String>(Arrays.asList(intoArray));
        this.removeElementFromList(intoArr);
        return intoArr;
    }

    private boolean chkElseWithSpace(String intoUpper, boolean flag) {
        boolean elseFlag = flag;
        if (intoUpper.contains(" ELSE ")) {
            elseFlag = true;
        }
        return elseFlag;
    }

    private String getColumnQry(Map<String, String> parserMap) {
        String column = parserMap.get("columns");
        ColumnSplitter splitter = new ColumnSplitter();
        List<String> cols = splitter.doGetAllColumns(column);
        cols = QueryConversionUtility.doGetAliasList(cols);
        StringBuffer colBuff = new StringBuffer();
        colBuff.append("select").append(" ").append(QueryConversionUtility.doGetStrFrmListWithComma(cols)).append(" ").append("from").append(" ");
        column = colBuff.toString();
        return column;
    }

    private void removeElementFromList(List<String> intoArr) {
        if (!intoArr.isEmpty()) {
            intoArr.remove(0);
        }
    }

    private void handleWhenFlag(StringBuffer outputQry, List<String> whenArr, boolean whenFlag, StringBuffer output, int iIndex) {
        if (whenFlag && whenArr != null) {
            output.insert(output.length() - 1, " where " + whenArr.get(iIndex));
        }
        output.append(" ").append("returning").append(" ").append("*").append(")");
        outputQry.append(" ").append(output);
    }

    private void handleElseClause(StringBuffer outputQry, List<String> whenArr, boolean whenFlag, boolean elseFlag, String lastQry) {
        List<String> whenArrayQry = whenArr;
        if (elseFlag) {
            outputQry.append(" ").append("MINUS").append(" ").append(lastQry.substring(lastQry.indexOf("select"), lastQry.lastIndexOf(41)));
            whenArrayQry = OracleMapHelperExt.appendBraceToElements(whenArrayQry);
            outputQry.append(" where ").append(QueryConversionUtility.doGetStrFrmListWithSeparator(whenArrayQry, " or "));
        } else if (whenFlag && whenArrayQry != null) {
            outputQry.insert(outputQry.length() - 1, " where " + whenArrayQry.get(whenArrayQry.size() - 1));
        }
    }

    private static List<String> appendBraceToElements(List<String> inputList) {
        ArrayList<String> outputList = new ArrayList<String>(10);
        for (String element : inputList) {
            if (!element.startsWith("(")) {
                outputList.add("(" + element + ")");
                continue;
            }
            outputList.add(element);
        }
        return outputList;
    }

    private static String getInsertQry(String selectQry, String cond) {
        StringBuffer output = new StringBuffer();
        if (!QueryConversionUtility.containsCheck(cond, "values")) {
            output.append("INSERT INTO ").append(" ").append(cond).append(" ").append("(").append(selectQry.substring(0, QueryConversionUtility.toLower(selectQry).indexOf("from") + 5)).append(" ").append("Sel").append(")");
        } else {
            String[] splitValues = cond.split("(?i)(?<!\\w)values(?!\\w)");
            if (splitValues.length > 1) {
                String values = splitValues[1].trim();
                if (values.startsWith("(")) {
                    values = QueryConversionUtility.removeParenthesis(values);
                }
                output.append("INSERT INTO ").append(" ").append(splitValues[0]).append(" ").append("(").append("select").append(" ").append(values).append(" ").append("from").append(" ").append("Sel").append(")");
            }
        }
        return output.toString();
    }

    private static String getInsertOutQuery(String outputQuery, String selectComment) {
        String selectCommentQry = selectComment;
        String outQry = outputQuery;
        if (!selectCommentQry.isEmpty()) {
            if (selectCommentQry.contains("#S#")) {
                selectCommentQry = selectCommentQry.replaceAll("(?i)#S#\\d+#E#", "");
            }
            if (QueryConversionUtility.toLower(selectCommentQry).startsWith("with")) {
                outQry = "," + outQry.substring(4).trim();
            }
        }
        return outQry;
    }

    public boolean insertFirstFn(Map<String, String> parserMap) {
        logger.debug("Insert First Function enabled");
        String intoCond = parserMap.get("insertcond");
        String selectQry = parserMap.get("selectquery");
        String column = parserMap.get("columns");
        StringBuffer outputQry = new StringBuffer("With Sel as (");
        boolean elseFlag = false;
        Pattern pattern = Pattern.compile("(?i)(?<!\\w)else(?!\\w)");
        if (pattern.matcher(intoCond).find()) {
            elseFlag = true;
        }
        ColumnSplitter splitter = new ColumnSplitter();
        List<String> cols = splitter.doGetAllColumns(column);
        List<String> aliasCols = QueryConversionUtility.doGetAliasList(cols);
        String colFrmLst = QueryConversionUtility.doGetStrFrmListWithComma(cols);
        selectQry = selectQry.replace(column, colFrmLst);
        outputQry.append(selectQry).append(")");
        int index = QueryConversionUtility.getIndex(outputQry.toString(), "select", 0);
        outputQry.insert(index + 7, "ROW_NUMBER() OVER () AS Ins_First_RN,");
        StringBuffer columnBuff = new StringBuffer();
        columnBuff.append("select").append(" ").append(QueryConversionUtility.doGetStrFrmListWithComma(aliasCols)).append(" ").append("from").append(" ");
        column = columnBuff.toString();
        intoCond = intoCond + " ";
        int count = 1;
        this.getOutputQuery(intoCond, column, count, outputQry, elseFlag);
        String outputQuery = outputQry.toString().trim();
        String selectComment = parserMap.get("comments");
        outputQuery = OracleMapHelperExt.getInsertOutQuery(outputQuery, selectComment);
        parserMap.put("outputqry", outputQuery);
        boolean isValid = true;
        return isValid;
    }

    private void getOutputQuery(String intoCond, String column, int cnt, StringBuffer outputQry, boolean elseFlag) {
        List<String> whenArr = new ArrayList<String>(10);
        List<String> intoArr = new ArrayList<String>(10);
        whenArr = QueryConversionUtility.getMatchedGrpsInLst(intoCond, "(?<!\\w)when\\s*(.*?)(?<!\\w)(then\\s+)", 1, whenArr);
        intoArr = QueryConversionUtility.getMatchedGrpsInLst(intoCond, "(?<!\\w)into\\s+(.*?)(?<!\\w)(when\\s*|else\\s+|$)", 1, intoArr);
        int count = cnt;
        for (int iIndex = 0; iIndex < intoArr.size() - 1; ++iIndex) {
            outputQry.append(",").append("ins").append(count++).append(" as ");
            StringBuffer output = new StringBuffer("(");
            output.append(OracleMapHelperExt.getInsertQry(column, intoArr.get(iIndex)));
            output.insert(output.length() - 1, " where " + whenArr.get(iIndex));
            if (iIndex >= 1) {
                output.insert(output.length() - 11 - whenArr.get(iIndex).length(), "( select * from ");
                output.append("s1").append(" LEFT JOIN ").append("(");
                output.append(OracleMapHelperExt.getInsertLimitQry(this.getSubList(whenArr, iIndex)));
                output.append(")").append("s2").append(" ");
                output.append(" ON s1.Ins_First_RN = s2.Ins_First_RN WHERE s2.Ins_First_RN IS NULL");
                output.append(")");
            }
            output.append(" ").append("returning").append(" ").append(1).append(")");
            outputQry.append(" ").append(output);
        }
        StringBuffer output = new StringBuffer();
        if (!elseFlag) {
            output.append(OracleMapHelperExt.getInsertQry(column, intoArr.get(intoArr.size() - 1)));
            output.insert(output.length() - 4, "( select * from ");
            output.insert(output.length() - 1, " where " + whenArr.get(whenArr.size() - 1));
        } else {
            output.append(OracleMapHelperExt.getInsertQry(column, intoArr.get(intoArr.size() - 1)));
            output.deleteCharAt(output.length() - 1);
            output.append(" ");
        }
        outputQry.append(output);
        outputQry.append("s1").append(" LEFT JOIN ").append("(");
        outputQry.append(OracleMapHelperExt.getInsertLimitQry(this.getSubList(count, whenArr)));
        outputQry.append(")").append("s2");
        outputQry.append(" ON s1.Ins_First_RN = s2.Ins_First_RN WHERE s2.Ins_First_RN IS NULL");
        outputQry.append(")");
    }

    private List<String> getSubList(List<String> whenArr, int iIndex) {
        if (iIndex <= whenArr.size()) {
            return whenArr.subList(0, iIndex);
        }
        return new ArrayList<String>(0);
    }

    private List<String> getSubList(int count, List<String> whenArr) {
        if (count - 1 <= whenArr.size()) {
            return whenArr.subList(0, count - 1);
        }
        return new ArrayList<String>(0);
    }

    private static String getInsertLimitQry(List<String> cond) {
        StringBuffer output = new StringBuffer();
        for (String condition : cond) {
            output.append("select").append(" ").append("Ins_First_RN").append(" ").append("from").append(" ").append("Sel").append(" where ").append(condition);
            output.append(" ").append("union all").append(" ");
        }
        output.delete(output.length() - 11, output.length());
        return output.toString();
    }

    public static String doCommentForeignKey(String input) {
        String output = input;
        if (!"false".equalsIgnoreCase(FeatureLoader.getStringProperty("foreignKeyHandler")) && (QueryConversionUtility.containsCheck(output, " references ") || QueryConversionUtility.containsCheck(output, "foreign "))) {
            Pattern pattern = Pattern.compile("(?i)((.*create\\s+table.*?\\(|.*alter\\s+table.*(?<!\\w)(?:add|modify)\\s*\\())(.*)(\\).*)");
            Matcher matcher = pattern.matcher(output);
            String createTab = null;
            String columns = null;
            String restQry = null;
            StringBuffer outBuff = new StringBuffer();
            if (matcher.find()) {
                createTab = matcher.group(2);
                columns = matcher.group(3);
                restQry = matcher.group(4);
                output = OracleMapHelperExt.colCheckForeignKey(createTab, columns, restQry);
            } else if (output.matches("(?i).*alter(?!\\w).*(?<!\\w)(references|foreign\\s+key)(?!\\w).*")) {
                if (output.matches("(?i).*(?<!\\w)modify(?!\\w).*")) {
                    output = QueryConversionUtility.doCommentSpecificGrp(output, "(?i)((?<!\\w)CONSTRAINT\\s+.*\\s+references\\s+.*|(?<!\\w)references(?!\\w).*);", 1);
                    outBuff.append(output).append(";");
                    output = outBuff.toString();
                } else {
                    outBuff.append("/*").append(output).append("*/");
                    output = outBuff.toString();
                }
            }
        }
        return output;
    }

    private static String colCheckForeignKey(String createTab, String columns, String restQry) {
        StringBuffer outBuf = new StringBuffer();
        ColumnSplitter splitter = new ColumnSplitter();
        List<String> colList = splitter.doGetAllColumns(columns);
        String tempColumn = null;
        outBuf.append(createTab);
        StringBuffer colBuf = new StringBuffer();
        int counter = 0;
        for (String col : colList) {
            int tempIndex;
            if (col.matches("(?i)CONSTRAINT\\s+.*FOREIGN\\s+key.*?(?<!\\w)references\\s+.*")) {
                tempColumn = "/*" + col + "*/";
                colBuf = colBuf.length() == 0 ? colBuf : colBuf.deleteCharAt(colBuf.length() - 1);
                colBuf.append(tempColumn);
            } else if (col.matches("(?i).*FOREIGN\\s+key.*(?<!\\w)references\\s+.*")) {
                tempIndex = QueryConversionUtility.getStartIndex(col, "(?i)(?<!\\w)(FOREIGN\\s+key)(?!\\w)", 1);
                colBuf = tempIndex == 0 && colBuf.length() > 0 ? colBuf.deleteCharAt(colBuf.length() - 1) : colBuf;
                tempColumn = col.substring(0, tempIndex) + "/*" + col.substring(tempIndex) + "*/";
                colBuf.append(tempColumn);
            } else if (col.matches("(?i).*CONSTRAINT\\s+.*\\s+references\\s+.*")) {
                tempIndex = QueryConversionUtility.getStartIndex(col, "(?i)(?<!\\w)(CONSTRAINT)(?!\\w)", 1);
                colBuf = tempIndex == 0 && colBuf.length() > 0 ? colBuf.deleteCharAt(colBuf.length() - 1) : colBuf;
                tempColumn = col.substring(0, tempIndex) + "/*" + col.substring(tempIndex) + "*/";
                colBuf.append(tempColumn);
            } else if (col.matches("(?i).*\\s+references\\s+.*")) {
                tempIndex = QueryConversionUtility.getStartIndex(col, "(?i)(?<!\\w)(REFERENCES)(?!\\w)", 1);
                colBuf = tempIndex == 0 && colBuf.length() > 0 ? colBuf.deleteCharAt(colBuf.length() - 1) : colBuf;
                tempColumn = col.substring(0, tempIndex) + "/*" + col.substring(tempIndex) + "*/";
                colBuf.append(tempColumn);
            } else {
                tempColumn = col;
                colBuf.append(col);
            }
            if (!tempColumn.startsWith("/*") || counter != 0) {
                colBuf.append(",");
            }
            ++counter;
        }
        colBuf = colBuf.charAt(colBuf.length() - 1) == ',' ? colBuf.deleteCharAt(colBuf.length() - 1) : colBuf;
        OracleMapHelperExt.changeForAlterTbl(createTab, restQry, outBuf, colList, colBuf.toString());
        String output = outBuf.toString();
        return output;
    }

    private static void changeForAlterTbl(String createTab, String restQry, StringBuffer outBuf, List<String> colList, String colBuf) {
        if (createTab.matches("(?i).*(?<!\\w)alter(?!\\w).*") && colList.size() == 1 && colBuf.startsWith("/*")) {
            outBuf.insert(0, "/*");
            outBuf.append(colList.get(0));
            outBuf.append(restQry);
            outBuf.append("*/");
        } else {
            outBuf.append(colBuf);
            outBuf.append(restQry);
        }
    }

    public static String doRmvResultCache(String input) {
        String output = input;
        if (input.matches("(?i).*(?<!\\w)create(?!\\w).*")) {
            output = output.replaceAll("\\s*\\(\\s*", "(");
            if (QueryConversionUtility.containsCheck(output = output.replaceAll("(?i)(?<!\\w)RESULT_CACHE(?!\\()", ""), "RESULT_CACHE")) {
                int resultIdx = QueryConversionUtility.getIndex(output, "RESULT_CACHE", 0);
                String temp = QueryConversionUtility.doGetReplaceString(output.substring(resultIdx));
                output = output.replace(temp, "");
            }
        } else if (input.matches("(?i).*(?<!\\w)alter(?!\\w).*")) {
            output = "/*" + output + "*/";
        }
        return output;
    }

    public static String doChangeGlobalTmpTbl(String input) {
        String output = input;
        String tempVar = null;
        String sessionReplace = null;
        String defaultRpl = null;
        Pattern globalTempPattern = Pattern.compile("(?i)((?:#s#\\d+#e#\\s*)?(?<!\\w)Create\\s+.*)(?<!\\w)(global)\\s+((?:#s#\\d+#e#\\s*)?temporary\\s+(?:#s#\\d+#e#\\s*)?table\\s+(?:#s#\\d+#e#\\s*)?)((?:\"?\\w*\"?\\.)?\"?\\w+\"?)(.*)");
        Matcher globalMatcher = globalTempPattern.matcher(output);
        if (globalMatcher.find()) {
            sessionReplace = FeatureLoader.getStringProperty("globalTempTable");
            defaultRpl = "LOCAL";
            if (sessionReplace.equalsIgnoreCase("global")) {
                defaultRpl = "global";
            }
            tempVar = globalMatcher.group(4);
            StringBuffer outString = new StringBuffer();
            outString.append(globalMatcher.group(1)).append(" ").append(defaultRpl).append(" ").append(globalMatcher.group(3)).append(" ");
            tempVar = QueryConversionUtility.replace(tempVar, "\"?\\.\"?", "_", true);
            OracleMigrationService.addGlobalTempMap(QueryConversionUtility.toUpper(globalMatcher.group(4)), QueryConversionUtility.toUpper(tempVar));
            outString.append(tempVar).append(globalMatcher.group(5));
            output = outString.toString();
            if (QueryConversionUtility.containsCheck(output, "delete ")) {
                output = OracleMapHelper.doChangeOnCommitRows(output);
            }
        }
        return output;
    }

    public static String getKey(String valToSearch, Map<String, String> partByColsQryMap) {
        for (Map.Entry<String, String> entry : partByColsQryMap.entrySet()) {
            String key = entry.getKey();
            String val = entry.getValue();
            if (valToSearch == null || !valToSearch.equals(val)) continue;
            return key;
        }
        return "";
    }
}

