/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.oracle;

import com.huawei.db.migration.database.bo.IQueryPatternsBO;
import com.huawei.db.migration.database.bo.IQuerySplitterPatternsBO;
import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.handlers.OracleMigrationTaskHandler;
import com.huawei.db.migration.interfaces.IMigrationMapper;
import com.huawei.db.migration.interfaces.IMigrationParser;
import com.huawei.db.migration.interfaces.IMigrationPatternHandler;
import com.huawei.db.migration.interfaces.IReplacerMap;
import com.huawei.db.migration.oracle.OracleConnectBy;
import com.huawei.db.migration.oracle.OraclePostProcessing;
import com.huawei.db.migration.oracle.OracleQueryKeywordReplacer;
import com.huawei.db.migration.oracle.OracleQueryKeywordReplacerExt;
import com.huawei.db.migration.oracle.OracleRowId;
import com.huawei.db.migration.oracle.OracleRownum;
import com.huawei.db.migration.replacer.ReplacerMap;
import com.huawei.db.migration.services.OracleMigrationService;
import com.huawei.db.migration.util.ColumnSplitter;
import com.huawei.db.migration.util.ErrorLoggerUtility;
import com.huawei.db.migration.util.FeatureLoader;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.ProgressUtil;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OraclePatternHandler
implements IMigrationPatternHandler {
    private static final Logger logger = LogManager.getLogger(OraclePatternHandler.class);
    private static final Pattern SUB_SELECT_PAT = Pattern.compile("(?i)(\\(\\s*select\\s+)");
    private static final Pattern SELECT_PAT = Pattern.compile("(?i)\\#\\#\\s*(select\\s+)");
    private static final Pattern MINUS_PAT = Pattern.compile("(?i)(.*)(?<!\\w)minus(?!\\w)(.*)");
    private static final Pattern UPDATE_SET_WHERE_PAT = Pattern.compile("(?i)((?<!\\w)(update)(?!\\w)(.*?)set.*?(where))(.*?)limit.*?;");
    private static final Pattern DELETE_FROM_WHERE_PAT = Pattern.compile("(?i)((?<!\\w)(delete)(?!\\w).*?from(.*?)(where))(.*?)limit.*?;");
    private static final Pattern AS_PAT = Pattern.compile("(?i)(?<!\\w)\\s+AS\\s+(\\w+)(?!\\w)");
    private static Map<String, String> subQueryConnectByMap = null;
    private TreeMap<String, String> subQueryTrackMap = null;
    private int counter = 0;
    private OracleConnectBy oracleConnectBy = new OracleConnectBy();

    @Override
    public String doSplit(String input, List<?> mapper, List<?> splitterPatterns, int position) throws MigrationServiceException {
        String inputQry = input;
        this.subQueryTrackMap = new TreeMap();
        List<?> querySplitterPatterns = splitterPatterns;
        List<String> subQueryList = QueryConversionUtility.getSubQueryList(inputQry);
        IQuerySplitterPatternsBO splitterPatternBO = null;
        if (querySplitterPatterns.size() == 1) {
            splitterPatternBO = (IQuerySplitterPatternsBO)querySplitterPatterns.get(0);
        }
        while (subQueryList.size() > 0) {
            inputQry = this.replaceSubqueries(inputQry, subQueryList);
            subQueryList = QueryConversionUtility.getSubQueryList(inputQry);
        }
        if (inputQry.matches("(?i).*(?<!\\w)with\\s+.*(?<!\\w)as\\s+##SUBQUERY##.*")) {
            inputQry = inputQry.replaceAll("(?i)(?<!\\w)as\\s+##SUBQUERY##", "AS##SUBQUERY##");
        }
        List<IQueryPatternsBO> queryPattern = mapper;
        boolean isMerge = false;
        boolean isInsertFn = false;
        if (QueryConversionUtility.containsCheck(inputQry, "merge") || QueryConversionUtility.containsCheck(inputQry, "all") || QueryConversionUtility.containsCheck(inputQry, "first")) {
            String mergeInput = QueryConversionUtility.toLower(inputQry).replaceAll("(?i)#S#\\d+#E#", "").trim();
            isMerge = (mergeInput = QueryConversionUtility.doRemoveExtraSpace(mergeInput)).startsWith("merge");
            isInsertFn = mergeInput.startsWith("insert all") || mergeInput.startsWith("insert first");
        }
        String inputQuery = inputQry;
        String[] splittedQry = new String[]{null, input};
        if (!isMerge && (FeatureLoader.getBooleanProperty("migInsertWithTableAlias") || inputQuery.matches("(?i)^\\s*INSERT\\s*ALL.*"))) {
            inputQuery = this.handleIfItIsNotMerge(splittedQry, splitterPatternBO, inputQuery);
        }
        inputQuery = this.doUnionCheck(queryPattern, inputQuery, true);
        if (isInsertFn) {
            inputQuery = this.handleIncaseInsertFn(splittedQry, queryPattern, inputQuery);
        }
        inputQuery = this.doSubQryConversionReplace(queryPattern, inputQuery);
        String outputQuery = QueryConversionUtility.doReplaceFunctionVariables(inputQuery, this.subQueryTrackMap, "##SUBQUERY##").trim();
        outputQuery = this.changeWithKeywordToComma(outputQuery, splittedQry);
        return outputQuery;
    }

    private String doMigrateConnectByUnnest(String inputQuery) throws MigrationServiceException {
        String inputQry = inputQuery;
        if (FeatureLoader.getBooleanProperty("migSupportUnnest")) {
            inputQry = QueryConversionUtility.doChangeTableToUnnest(inputQry);
        }
        if (FeatureLoader.getBooleanProperty("migSupportConnectBy") && QueryConversionUtility.containsCheck(inputQry, "CONNECT BY") && QueryConversionUtility.containsCheck(inputQry = this.oracleConnectBy.doHandleConnectBy(inputQry, this.subQueryTrackMap), "ORDER SIBLINGS BY")) {
            inputQry = QueryConversionUtility.doCommentPatternGrp(inputQry, "(?i)(?<!\\w)ORDER\\s+(SIBLINGS)\\s+BY", 1);
        }
        return inputQry;
    }

    private void doMigrateConnectByUnnestInSubQuery(Map<String, String> map) throws MigrationServiceException {
        String temp = null;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            LinkedHashMap<String, String> unionMap = new LinkedHashMap<String, String>(10);
            String subQuery = entry.getValue();
            if (subQuery.matches("(?i)(?<!\\w)SELECT(.*?)FROM\\s+.*?(TABLE)\\s*\\(") || QueryConversionUtility.containsCheck(subQuery, "CONNECT BY")) {
                if (QueryConversionUtility.unionSplitter(subQuery = subQuery.substring(1, subQuery.length() - 1), unionMap, 0)) {
                    StringBuffer unionQry = new StringBuffer();
                    for (Map.Entry singleQuery : unionMap.entrySet()) {
                        temp = QueryConversionUtility.replace((String)singleQuery.getKey(), "#\\d+#", "", true);
                        subQuery = QueryConversionUtility.doChangeTableToUnnest(temp);
                        subQuery = this.oracleConnectBy.doHandleConnectBy(subQuery, map);
                        unionQry.append(" ").append(subQuery).append(" ").append((String)singleQuery.getValue()).append(" ");
                    }
                    subQuery = unionQry.toString();
                } else {
                    subQuery = QueryConversionUtility.doChangeTableToUnnest(subQuery);
                    subQuery = this.oracleConnectBy.doHandleConnectBy(subQuery, map);
                }
                subQuery = "(" + subQuery + ")";
            }
            if (QueryConversionUtility.containsCheck(subQuery, "ORDER SIBLINGS BY")) {
                subQuery = QueryConversionUtility.doCommentPatternGrp(subQuery, "(?i)(?<!\\w)ORDER\\s+(SIBLINGS)\\s+BY", 1);
            }
            map.put(entry.getKey(), subQuery);
        }
    }

    private String changeWithKeywordToComma(String outputQuery, String[] splittedQry) {
        String outputQry = outputQuery;
        if (splittedQry[0] != null && splittedQry[1] != null) {
            String out1 = QueryConversionUtility.doReplaceFunctionVariables(splittedQry[0], this.subQueryTrackMap, "##SUBQUERY##");
            outputQry = QueryConversionUtility.toLower(out1).startsWith("with") && outputQry.startsWith("with") ? out1 + " " + "," + outputQry.substring(5) : out1 + " " + outputQry;
        }
        return outputQry;
    }

    private String handleIfItIsNotMerge(String[] splittedQry, IQuerySplitterPatternsBO splitterPatternBO, String inputQuery) {
        String inputQry = inputQuery;
        String[] splittedQuery = splittedQry;
        boolean flag = false;
        IReplacerMap splitterPatternMap = QueryConversionUtility.doGetInrOutrQry(inputQry, splitterPatternBO, flag);
        splittedQuery[0] = (String)splitterPatternMap.get("outterquery");
        splittedQuery[1] = (String)splitterPatternMap.get("innerquery");
        String outerQry = splittedQuery[0];
        String innerQry = splittedQuery[1];
        if (outerQry != null && outerQry.matches("(?i).*(?<!\\w)insert(?!\\w).*")) {
            splittedQuery[0] = outerQry = OraclePatternHandler.removeTabAliasInInsert(outerQry);
        } else if (innerQry != null && innerQry.matches("(?i).*(?<!\\w)insert(?!\\w).*")) {
            splittedQuery[1] = innerQry = OraclePatternHandler.removeTabAliasInInsert(innerQry);
        }
        inputQry = splittedQuery[1] == null ? splittedQuery[0] : splittedQuery[1];
        return inputQry;
    }

    private String handleIncaseInsertFn(String[] splittedQry, List<IQueryPatternsBO> queryPattern, String inQry) throws MigrationServiceException {
        String inputQuery = inQry;
        String subSelectStr = "##SUBSELECT##";
        int subSelectCnt = 1;
        HashMap<String, String> subQryInsertFnMap = new HashMap<String, String>(5);
        while (inputQuery.matches("(?i).*\\(\\s*select\\s+.*")) {
            Matcher subMatchPat = SUB_SELECT_PAT.matcher(inputQuery);
            if (!subMatchPat.find()) continue;
            int idx = subMatchPat.start(1);
            String select = QueryConversionUtility.doGetReplaceString(inputQuery.substring(idx));
            subQryInsertFnMap.put(subSelectStr + subSelectCnt + "##", select);
            inputQuery = inputQuery.replace(select, subSelectStr + subSelectCnt++ + "##");
        }
        String startIPQry = "";
        if (inputQuery.trim().startsWith("with")) {
            Matcher matchPat = SELECT_PAT.matcher(inputQuery);
            int selectIdx = 0;
            if (matchPat.find()) {
                selectIdx = matchPat.start(1);
                startIPQry = inputQuery.substring(0, selectIdx);
                inputQuery = inputQuery.substring(selectIdx);
            }
        }
        if (splittedQry[0] != null) {
            inputQuery = startIPQry + splittedQry[0] + inputQuery;
        }
        splittedQry[0] = null;
        inputQuery = this.doUnionCheck(queryPattern, inputQuery, false);
        inputQuery = QueryConversionUtility.doReplaceFunctionVariables(inputQuery, subQryInsertFnMap, subSelectStr);
        return inputQuery;
    }

    private static String removeTabAliasInInsert(String qry) {
        StringBuffer outerQry = new StringBuffer(qry);
        String tabAlias = null;
        String insertCols = null;
        Pattern insertAliasPat = Pattern.compile("(?i)(.*insert\\s+(?:#S#\\d+#E#\\s*)?into\\s+\"?\\w*\"?\\s*\\.?\\s*\"?\\w+\"?\\s+)(\".*?\"|\\w+)(.*)");
        Matcher insertMatcher = insertAliasPat.matcher(qry);
        if (insertMatcher.find()) {
            outerQry = new StringBuffer(insertMatcher.group(1));
            tabAlias = insertMatcher.group(2);
            insertCols = insertMatcher.group(3);
            insertCols = insertCols.replaceAll("(?i)(?<!\\w|\\.)" + tabAlias + "\\.", "");
            if (tabAlias.equalsIgnoreCase("nologging")) {
                outerQry.append("/*").append(" ").append(tabAlias).append(" ").append("*/");
            }
            outerQry.append(" ");
            outerQry.append(insertCols);
        }
        return outerQry.toString();
    }

    private String doSubQryConversionReplace(List<IQueryPatternsBO> mapper, String innerQry) throws MigrationServiceException {
        TreeMap<String, String> clone = new TreeMap<String, String>((SortedMap<String, String>)this.subQueryTrackMap);
        String innerQuery = innerQry;
        for (Map.Entry<String, String> subIndividualQuery : clone.entrySet()) {
            String subQuery = subIndividualQuery.getValue();
            subQuery = QueryConversionUtility.replace(subQuery, "\\(", "", true);
            int index = (subQuery = QueryConversionUtility.canonicalizeString(subQuery)).lastIndexOf(41);
            subQuery = index != -1 ? subQuery.substring(0, index) : subQuery;
            String intermSubQuery = this.doUnionCheck(mapper, subQuery, true);
            this.subQueryTrackMap.put(subIndividualQuery.getKey(), "(" + intermSubQuery + ")");
        }
        innerQuery = QueryConversionUtility.doReplaceFunctionVariables(innerQuery, this.subQueryTrackMap, "##SUBQUERY##");
        return innerQuery;
    }

    private String doUnionCheck(List<IQueryPatternsBO> mapper, String inputQuery, boolean unionChkEnabler) throws MigrationServiceException {
        Map<String, String> createTypesDDL;
        String outputQuery = null;
        String temp = null;
        String input = inputQuery;
        OracleMigrationTaskHandler taskHandler = new OracleMigrationTaskHandler();
        IMigrationMapper objMapper = taskHandler.getMapper();
        IMigrationParser objParser = taskHandler.getParser();
        int qryCnt = 1;
        LinkedHashMap<String, String> unionMap = new LinkedHashMap<String, String>(10);
        List<IQueryPatternsBO> decideMappers = QueryConversionUtility.getMajorPatterns(mapper, inputQuery, "(?<!\\w)insert(?!\\w)|(?<!\\w)Merge(?!\\w)", "Merge|Insert");
        if (!input.matches("(?i)group\\s+by\\s+(cube|rollup|grouping\\s+sets)")) {
            input = this.rplRownumFunc(input);
        }
        if (input.matches("(?i).*?(?<!\\w)minus(?!\\w).*?")) {
            input = OraclePatternHandler.addBrcktsForQryWithMinus(input);
        }
        if (QueryConversionUtility.unionSplitter(input = OraclePostProcessing.replaceSynonym(input, createTypesDDL = OracleMigrationService.getCreateTypeMap()), unionMap, 0) && unionChkEnabler) {
            StringBuffer unionQry = new StringBuffer();
            for (Map.Entry<String, String> entry : unionMap.entrySet()) {
                temp = ((String)entry.getKey()).replaceFirst("#\\d+#", "");
                temp = this.doPatternSplitter(temp, decideMappers, qryCnt, objMapper, objParser);
                ++qryCnt;
                this.updateOutputQuery(temp, unionQry, entry);
            }
            outputQuery = unionQry.toString();
        } else {
            outputQuery = this.doPatternSplitter(input, decideMappers, qryCnt, objMapper, objParser);
            outputQuery = this.doQueryConversion(outputQuery);
            outputQuery = this.doMigrateConnectByUnnest(outputQuery);
        }
        this.doMigrateConnectByUnnestInSubQuery(this.subQueryTrackMap);
        if (subQueryConnectByMap != null) {
            this.doMigrateConnectByUnnestInSubQuery(subQueryConnectByMap);
            this.subQueryTrackMap.putAll(subQueryConnectByMap);
            subQueryConnectByMap = null;
        }
        return outputQuery;
    }

    private String rplRownumFunc(String inputQry) {
        String input = inputQry;
        if (QueryConversionUtility.containsCheck(input, "rownum")) {
            input = OracleQueryKeywordReplacerExt.doReplaceColRownumFn(input);
            Pattern rownumPat = Pattern.compile("(?i).*(?<!\\w)SELECT(?!\\w).*?row_number\\s*\\(\\s*\\)\\s+over\\s*\\(\\s*\\).*?FROM\\s+(##SUBQUERY##\\d+__)?\\s*(\\w*).*");
            Matcher rownumMatcher = rownumPat.matcher(input);
            while (rownumMatcher.find()) {
                OracleRownum oracleRownum = new OracleRownum();
                input = oracleRownum.doProcessRowNumber(input, rownumMatcher.group(1), this.subQueryTrackMap, rownumMatcher.group(2));
            }
            try {
                input = OracleQueryKeywordReplacerExt.doReplaceRownumFn(input);
            }
            catch (NumberFormatException e) {
                logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " Error while converting from string to int");
                throw new MigrationServiceException("[DSC_ERR_004_018] " + MessageLoader.getMessage("DSC_ERR_004_018"));
            }
            if (input.trim().matches("(?i)update.*?limit.*?;")) {
                input = this.updRownum(input);
            } else if (input.trim().matches("(?i)delete.*?limit.*?;")) {
                input = this.delRownum(input);
            }
        }
        return input;
    }

    private void updateOutputQuery(String temp, StringBuffer unionQry, Map.Entry<String, String> singleQuery) {
        String outputQuery = this.doQueryConversion(temp);
        outputQuery = this.doMigrateConnectByUnnest(outputQuery);
        unionQry.append(" ").append(outputQuery).append(" ").append(singleQuery.getValue()).append(" ");
    }

    private static String addBrcktsForQryWithMinus(String output) {
        Matcher matcher;
        String outputQry = output.trim();
        boolean hasSemiColon = outputQry.endsWith(";");
        if (hasSemiColon) {
            outputQry = outputQry.substring(0, outputQry.length() - 1);
        }
        if ((matcher = MINUS_PAT.matcher(outputQry)).find()) {
            String qry1 = matcher.group(1);
            String qry2 = matcher.group(2);
            outputQry = "(" + qry1 + ")" + "MINUS" + "(" + qry2 + ")";
        }
        if (hasSemiColon) {
            outputQry = outputQry + ";";
        }
        return outputQry;
    }

    private String updRownum(String input) {
        String inputQry = input;
        Matcher rownumWithUpdMatch = UPDATE_SET_WHERE_PAT.matcher(inputQry);
        StringBuffer sb = new StringBuffer();
        while (rownumWithUpdMatch.find()) {
            String updClass = rownumWithUpdMatch.group(1);
            String tableName = rownumWithUpdMatch.group(3);
            String whereKey = rownumWithUpdMatch.group(4);
            String assign = rownumWithUpdMatch.group(5);
            int endIdx = rownumWithUpdMatch.end(5);
            String updCode = "(xc_node_id,ctid) = (select xc_node_id,ctid from";
            sb.append(updClass).append(updCode).append(" ").append(tableName).append(" ").append(whereKey).append(" ").append(assign);
            sb.append(inputQry.substring(endIdx));
            sb.insert(sb.length() - 1, ")");
        }
        inputQry = sb.toString();
        return inputQry;
    }

    private String delRownum(String input) {
        String inputQry = input;
        Matcher rownumWithDelMatch = DELETE_FROM_WHERE_PAT.matcher(inputQry);
        StringBuffer sb = new StringBuffer();
        while (rownumWithDelMatch.find()) {
            String delClass = rownumWithDelMatch.group(1);
            String tableName = rownumWithDelMatch.group(3);
            String whereKey = rownumWithDelMatch.group(4);
            String assign = rownumWithDelMatch.group(5);
            int endIdx = rownumWithDelMatch.end(5);
            String delCode = "(xc_node_id,ctid) in (select xc_node_id,ctid from";
            sb.append(delClass).append(delCode).append(" ").append(tableName).append(" ").append(whereKey).append(" ").append(assign);
            sb.append(inputQry.substring(endIdx));
            sb.insert(sb.length() - 1, ")");
        }
        inputQry = sb.toString();
        return inputQry;
    }

    private String doAddAliasForGaussKeywordsOnebyOne(String input) {
        String output = input;
        Pattern colPattern = Pattern.compile("(?i)select(.*?)(?<!\\w)from(?!\\w)");
        Matcher colMatcher = colPattern.matcher(output);
        while (colMatcher.find()) {
            String[] colArr;
            String colmns;
            String colmnsReplment = colmns = colMatcher.group(1);
            for (String col : colArr = colmns.split(",(?![^(]*\\))")) {
                if (col.matches("(?i).*(?<!\\w)into(?!\\w).*")) continue;
                col = col.trim();
                String colsWithOutCmmts = QueryConversionUtility.replace(col, "(?i)#S#\\d+#E#", "", true).trim();
                colmnsReplment = this.getRplForCols(colmnsReplment, col, colsWithOutCmmts);
            }
            output = output.replace(colmns, colmnsReplment);
        }
        return output;
    }

    private String getRplForCols(String colmnsReplment, String col, String colsWithOutCmmts) {
        String colReplacemnt = null;
        if (!QueryConversionUtility.containsCheck(colsWithOutCmmts, " AS ") && colsWithOutCmmts.contains(" ")) {
            int spaceIndex = colsWithOutCmmts.lastIndexOf(32);
            String colName = colsWithOutCmmts.substring(0, spaceIndex).trim();
            if (!colName.equalsIgnoreCase("distinct")) {
                String colAlias = colsWithOutCmmts.substring(spaceIndex).trim();
                String colm = colsWithOutCmmts.substring(0, colsWithOutCmmts.indexOf(32)).trim();
                StringBuffer colBuf = new StringBuffer();
                if (colAlias.matches("(?i)(?<!\\w)(VERSION|LABEL|POSITION|TEXT|YEAR|APP|NONE|SHOW|ROLE|FILEHEADER|COMMENTS|ACTION|VALUE|TIME|NAME|CONTENT|LANGUAGE|RANGE|ACCOUNT|OWNER|LIMIT)(?!\\w)")) {
                    colReplacemnt = colName + " " + "AS" + " " + colAlias;
                    colmnsReplment = colmnsReplment.replace(colsWithOutCmmts, colReplacemnt);
                }
                colAlias = colAlias.replace("\"", "");
                if (colm.matches("(?i)(?<!\\w)limit|function|left|right|xmin|xmax|maxvalue(?!\\w)") && !colAlias.matches("(?i)(?<!\\w)limit|function|left|right|xmin|xmax|maxvalue(?!\\w)")) {
                    colBuf.append("\"").append(colm).append("\"");
                    colmnsReplment = colmnsReplment.replace(colm, colBuf);
                }
            }
        } else {
            colReplacemnt = OracleQueryKeywordReplacerExt.doAddQuotesForGuassKeyowrds(col);
            colmnsReplment = colmnsReplment.replace(col, colReplacemnt);
        }
        return colmnsReplment;
    }

    public String doPatternSplitter(String query, List<IQueryPatternsBO> mappers, int qryCnt, IMigrationMapper objMapper, IMigrationParser objParser) throws MigrationServiceException {
        IReplacerMap parserMap = new ReplacerMap();
        boolean breakLoop = false;
        String outputQry = query;
        for (IQueryPatternsBO replaceBO : mappers) {
            parserMap = objParser.doParsing(query, replaceBO, parserMap);
            if (parserMap.size() != 0) {
                parserMap.put("QryCnt", qryCnt + "");
                outputQry = this.doCheckConstraintForInput(query, objMapper, parserMap, replaceBO);
                breakLoop = true;
            }
            if (!breakLoop) continue;
            break;
        }
        return outputQry;
    }

    private String doCheckConstraintForInput(String query, IMigrationMapper objMapper, IReplacerMap parserMap, IQueryPatternsBO replaceBO) throws MigrationServiceException {
        String outputQry = null;
        if (replaceBO.isConstraintFlag()) {
            outputQry = this.doCheckMapping(query, objMapper, parserMap, replaceBO);
        } else {
            logger.debug("No Constraint Flag - Direct Replacement Logic will be applied");
            outputQry = parserMap.doSqlReplacement(replaceBO.getReplacementPattern());
        }
        return outputQry;
    }

    private String doCheckMapping(String query, IMigrationMapper objMapper, IReplacerMap parserMap, IQueryPatternsBO replaceBO) throws MigrationServiceException {
        String outputQry = null;
        if (objMapper.doMapping(query, replaceBO, parserMap)) {
            logger.debug("Constraint validation case success- Replacement Logic need to be applied");
            outputQry = parserMap.doSqlReplacement(replaceBO.getReplacementPattern());
        } else {
            outputQry = query;
            logger.debug("Constraint validation case failed - Query Migration not Required");
        }
        return outputQry;
    }

    private String replaceSubqueries(String sqlQry, List<String> subQueryList) {
        String sql = sqlQry;
        Collections.reverse(subQueryList);
        String noSpaceString = null;
        for (String subSelect : subQueryList) {
            noSpaceString = QueryConversionUtility.toLower(subSelect).replace("select ", "select#").replace(" ", "");
            if (noSpaceString.lastIndexOf("(select#") == noSpaceString.indexOf("(select#")) {
                ++this.counter;
                sql = QueryConversionUtility.replaceQueryWithCommonPattern(sql, subSelect, this.counter, this.subQueryTrackMap, "##SUBQUERY##");
            }
            ProgressUtil.printProgress();
        }
        return sql;
    }

    public String doCnsrtConnectBySubQry(String outputQuery, String tableName, List<String> columnList, String startWithStr, String connectByStr, Set<String> aliasSet, Map<String, String> subQryTrackMap) {
        String[] tabNameArray;
        String outputQry = outputQuery;
        for (String arr : tabNameArray = tableName.split("(?i)(,|(INNER|LEFT|RIGHT|FULL)?\\s+JOIN)")) {
            String[] tablNameSplit = arr.trim().split(" ");
            String tblAlias = tablNameSplit[tablNameSplit.length - 1];
            if (!aliasSet.contains(tblAlias)) continue;
            StringBuffer selBuf = new StringBuffer();
            if (QueryConversionUtility.containsCheck(arr, "##SUBQUERY##")) {
                this.putSubQryToMap(startWithStr, connectByStr, subQryTrackMap, tablNameSplit);
                continue;
            }
            int countr = this.appendBufWithCount(columnList, subQryTrackMap, tblAlias, selBuf);
            selBuf.append(" ").append("from").append(" ").append(arr);
            selBuf.append(" ").append(startWithStr).append(" ").append(connectByStr).append(")");
            String subString = selBuf.toString();
            selBuf.append(" ").append(tblAlias).append(" ");
            outputQry = QueryConversionUtility.replaceAll(outputQry, arr, selBuf.toString());
            if (subQueryConnectByMap == null) {
                subQueryConnectByMap = new TreeMap<String, String>();
            }
            outputQry = QueryConversionUtility.replaceQueryWithCommonPattern(outputQry, subString, countr, subQueryConnectByMap, "##SUBQUERY##");
        }
        return outputQry;
    }

    private int appendBufWithCount(List<String> columnList, Map<String, String> subQryTrackMap, String tblAlias, StringBuffer selBuf) {
        int countr = subQryTrackMap.size() + 1;
        selBuf.append("(").append("SELECT").append(" ");
        for (String col : columnList) {
            if (!col.startsWith(tblAlias + ".")) continue;
            if (countr > subQryTrackMap.size() + 1) {
                selBuf.append(",");
            }
            selBuf.append(" ").append(col);
            ++countr;
        }
        return countr;
    }

    private void putSubQryToMap(String startWithStr, String connectByStr, Map<String, String> subQryTrackMap, String[] tablNameSplit) {
        String key = tablNameSplit[0];
        String subQry = subQryTrackMap.get(key);
        Pattern fromPattern = Pattern.compile("(?i).*?(?<!\\w)select(?!\\w).*?(?<!\\w)from(?!\\w)(.*?)((?<!\\w)(?:where|qualify|group\\s+by|having|order\\s+by|connect\\s+by|start\\s+with)(?!\\w)|;|$).*", 2);
        Matcher fromMatch = fromPattern.matcher(subQry);
        StringBuffer sbQryBuff = new StringBuffer();
        int endIndex = 0;
        if (fromMatch.find()) {
            endIndex = fromMatch.end(1);
            sbQryBuff.append(subQry.substring(0, endIndex - 1));
            sbQryBuff.append(" ").append(startWithStr);
            sbQryBuff.append(" ").append(connectByStr);
        }
        sbQryBuff.append(subQry.substring(endIndex - 1));
        subQry = sbQryBuff.toString();
        subQryTrackMap.put(key, subQry);
    }

    public String doQueryConversion(String query) {
        String outputQry = query;
        outputQry = this.doDBLinkQueryMigration(outputQry);
        outputQry = this.doAddAliasForGaussKeywordsOnebyOne(outputQry);
        outputQry = OracleQueryKeywordReplacer.doChangeOrderofClause(outputQry);
        outputQry = OracleQueryKeywordReplacer.doChangeOptrInJoins(outputQry);
        outputQry = this.doConvertStrFunctions(outputQry);
        outputQry = OracleQueryKeywordReplacerExt.doRplBracesFrmTable(outputQry);
        OracleRowId oracleRowId = new OracleRowId();
        outputQry = oracleRowId.doRplRowID(outputQry, this.subQueryTrackMap);
        return outputQry;
    }

    private String doDBLinkQueryMigration(String input) {
        String output = input;
        String dbLinkConfigu = FeatureLoader.getStringProperty("dblink_mapping");
        String[] multilink = dbLinkConfigu.split(",");
        String tableName = QueryConversionUtility.doGetTableName(output);
        if (tableName.contains("@")) {
            int atIndex = tableName.indexOf("@");
            String[] tableAlias = tableName.split(" ");
            String tempTableName = tableName.substring(0, atIndex) + " " + (tableAlias.length == 2 ? tableAlias[1] : "");
            String dbLinkName = tableName.substring(atIndex + 1);
            int dbIndex = dbLinkName.indexOf(32);
            dbLinkName = dbLinkName.substring(0, dbIndex != -1 ? dbLinkName.indexOf(32) : dbLinkName.length()).trim();
            String inputString = input.endsWith(";") ? input.trim().substring(0, input.length() - 1) : input;
            inputString = inputString.replace(tableName, tempTableName);
            Pattern selPattern = Pattern.compile("(?i)select(.*?)(?<!\\w)from(?!\\w)");
            Matcher matcher = selPattern.matcher(output);
            String fromQuery = "";
            if (matcher.find()) {
                fromQuery = matcher.group();
                output = output.matches("(?i).*(?<!\\w)(MAX|MIN|SUM|AVG|COUNT|STDDEV)\\s*\\(.*") ? this.checkAggFunction(multilink, inputString, dbLinkName, matcher, fromQuery) : this.checkNormalDbLinkQuery(output, tableName, inputString, matcher, fromQuery);
            }
        }
        return output;
    }

    private String checkNormalDbLinkQuery(String output, String tableName, String inputString, Matcher matcher, String fromQuery) {
        int atIndex = tableName.indexOf("@");
        String[] tableAlias = tableName.split(" ");
        String tempTableName = tableName.substring(0, atIndex) + " " + (tableAlias.length == 2 ? tableAlias[1] : "");
        String dbLinkName = tableName.substring(atIndex + 1);
        int dbIndex = dbLinkName.indexOf(32);
        dbLinkName = dbLinkName.substring(0, dbIndex != -1 ? dbLinkName.indexOf(32) : dbLinkName.length()).trim();
        String colms = matcher.group(1);
        String colAliasName = "";
        String dbLinkConfigu = FeatureLoader.getStringProperty("dblink_mapping");
        String[] multilink = dbLinkConfigu.split(",");
        ColumnSplitter splitter = new ColumnSplitter();
        List<String> colList = splitter.doGetAllColumns(colms);
        List<String> updatedcolLst = QueryConversionUtility.doGetAliasList(colList);
        OracleConnectBy obj = new OracleConnectBy();
        List<String> check = obj.doGetWhereClauseList(inputString, "", tempTableName);
        List<String> list = updatedcolLst = updatedcolLst.contains("*") ? check : updatedcolLst;
        if (updatedcolLst.contains("*") || updatedcolLst.isEmpty()) {
            updatedcolLst.clear();
            updatedcolLst.add("a");
        }
        for (String alias : updatedcolLst) {
            if (colAliasName.contains(".")) {
                colAliasName = colAliasName.replaceAll("\\w+\\.", "");
            }
            colAliasName = colAliasName.concat(alias).concat(" TEXT").concat(" , ");
        }
        colAliasName = colAliasName.substring(0, colAliasName.length() - 2);
        StringBuffer outPutBuffer = new StringBuffer();
        for (String dbLink : multilink) {
            String[] dataSource = dbLink.split(":");
            if (!dataSource[0].equalsIgnoreCase(dbLinkName.trim())) continue;
            outPutBuffer = outPutBuffer.append(fromQuery).append(" exec_on_extension('").append(dataSource[1]).append("'").append(",$q$").append(inputString).append("$q$)").append(" AS ( ").append(colAliasName).append(")");
        }
        outPutBuffer = output.endsWith(";") ? outPutBuffer.append(";") : outPutBuffer;
        return outPutBuffer.toString();
    }

    private String checkAggFunction(String[] multilink, String inputString, String dbLinkName, Matcher matcher, String query) {
        String colAliasName = "";
        String fromQuery = query;
        String colms = matcher.group(1);
        if (colms.matches("(?i).*?(?<!\\w)\\s+AS\\s+(\\w+)(?!\\w).*")) {
            Matcher asMatcher = AS_PAT.matcher(colms);
            if (asMatcher.find()) {
                colAliasName = asMatcher.group(1);
            }
        } else {
            colAliasName = "aggfn";
        }
        StringBuffer outputBuffer = new StringBuffer();
        fromQuery = fromQuery.replaceAll("(?i)(?<!\\w)(MAX|MIN|SUM|AVG|COUNT|STDDEV)\\s*\\(\\d*\\w*\\)(?!\\w)", colAliasName);
        for (String dbLink : multilink) {
            String[] dataSource = dbLink.split(":");
            if (!dataSource[0].equalsIgnoreCase(dbLinkName)) continue;
            outputBuffer = outputBuffer.append(fromQuery).append(" exec_on_extension('").append(dataSource[1]).append("'").append(", $q$").append(inputString).append("$q$)").append(" AS ").append(" (" + colAliasName + " TEXT)").append(";");
        }
        return outputBuffer.toString();
    }

    private String doConvertStrFunctions(String inputQry) {
        String outputQry = inputQry;
        String outputQryLwr = QueryConversionUtility.toLower(outputQry);
        LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
        outputQry = QueryConversionUtility.getSingleDoubleQuoteMap(outputQry, quoteMap);
        if (outputQryLwr.contains("stragg") || outputQryLwr.contains("wm_concat")) {
            outputQry = OracleQueryKeywordReplacerExt.doReplaceStragg(outputQry);
        }
        outputQry = QueryConversionUtility.getRplFromMap(outputQry, quoteMap, "(##QUOTE##\\d+#)");
        if (outputQryLwr.contains("listagg") && FeatureLoader.getBooleanProperty("MigSupportForListAgg")) {
            outputQry = OracleQueryKeywordReplacerExt.doReplaceListagg(outputQry);
        }
        if (QueryConversionUtility.containsCheck(outputQry, "nvl2")) {
            outputQry = OracleQueryKeywordReplacerExt.doReplaceNVLFn(outputQry);
        }
        return outputQry;
    }
}

