/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.oracle;

import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.oracle.OracleQueryKeywordReplacer;
import com.huawei.db.migration.oracle.OracleQueryKeywordReplacerExt;
import com.huawei.db.migration.oracle.OracleUtility;
import com.huawei.db.migration.services.OracleMigrationService;
import com.huawei.db.migration.util.ColumnSplitter;
import com.huawei.db.migration.util.FeatureLoader;
import com.huawei.db.migration.util.FeatureLoaderExtended;
import com.huawei.db.migration.util.InterruptCharSequence;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OraclePostProcessing {
    private static final Pattern OPEN_FOR_SELECT = Pattern.compile("(?i)open\\s+.*?\\s+for(?:\\s#s#\\d+#e#)?\\s+(with\\s+.*?as\\s*(?:#s#\\d+#e#\\s*)?\\(\\s*select.*?);");
    private static final Pattern REMOVE_NEW_PATTERN = Pattern.compile("(?i):=\\s*(new).*;");
    private static final Pattern PATTERN_IDENTIFIER = Pattern.compile("(&\\w+)");
    private static final Pattern PKG_FINDER = Pattern.compile("(?i)(?<!\\w)(?:FUNCTION|PROCEDURE)(?!\\w)\\s+(\\w*\\.?\\w*(?:\\.|#)?)(?<!\\w)\\w+(?!\\w)");
    private static final Pattern PARAMETER_LESS_PROC = Pattern.compile("(?i)(?<!\\w|=|#|return\\s)\\s*(\\w*(?:\\.|#)?\\w*(?:\\.|#)?\\w+)(?!\\w)\\s*(;|into|=)");
    private static final Pattern BULK_INTO = Pattern.compile("(?i)(select|fetch)(.*?)bulk\\s+collect\\s+(into)\\s+(.*?)(?:from|;)");
    private static final Pattern GET_CUR_WHEN_SEL_WITH_FETCH = Pattern.compile("(?i)fetch\\s+(\\w+)");
    private static final Pattern BEGIN_WHEN_SEL = Pattern.compile("(?i)bulk\\s+collect\\s+into.*?(from.*?;)");
    private static final Pattern RPL_SYN_IN_TYPE = Pattern.compile("(?i)(\\w+)\\..*?%type");
    private static final Pattern GET_WHERE_SYN = Pattern.compile("(?i)select.*where\\s+(\\w+)");
    private static final Pattern GET_FROM_COLS = Pattern.compile("(?i)SELECT.*?from\\s+(.*)where");
    private static final Pattern FUNC_RET = Pattern.compile("(?i)((?<!\\w)return(?!\\w)\\s+(\\w+\\.\\w+#?\\w*)\\s*\\(.*?\\)\\s*(?:\\.|#)\\w+\\s*;)");
    private static final Pattern RET_BODY_PATTERN = Pattern.compile("((?<!\\w)return\\s+(\\w+)\\s*;)", 2);
    private static final Pattern PATTERN_EXTEND = Pattern.compile("(?i)\\w+\\.(extend\\s*(\\(\\s*\\)\\s*))?;");
    private static final Pattern CHANGE_DUP_VAL_IDX = Pattern.compile("(?i)(?:exception)?\\s*(?:#S#\\d+#E#\\s*)?when\\s+(DUP_VAL_ON_INDEX)");

    public static String doPostBulkChanges(String outputSQL) {
        String output = outputSQL;
        if (QueryConversionUtility.containsCheck(output, "RATIO_TO_REPORT")) {
            output = OracleUtility.doChangeRatioToReport(output);
        }
        return output;
    }

    public static String doPostBLogicChanges(String input, String fileName) throws MigrationServiceException {
        String output = input;
        OracleUtility util = new OracleUtility();
        if (!QueryConversionUtility.isGaus100()) {
            output = OraclePostProcessing.migrateForDBA(fileName, output, util);
        }
        LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
        output = QueryConversionUtility.getSingleDoubleQuoteMap(output, quoteMap);
        if (QueryConversionUtility.isGaus100()) {
            output = output.replaceAll("(?i)((?<!\\w)function(?!\\w).*?(?<!\\w)return(?!\\w).*?)(?<!\\w)(PIPELINED)(?!\\w)(.*?(?<!\\w)begin(?!\\w))", "$1 /* $2 */ $3");
        }
        String delimiter = OraclePostProcessing.getDelimiter();
        if (!QueryConversionUtility.isGaus100() || QueryConversionUtility.isGaus100() && FeatureLoaderExtended.getBooleanProperty("supportPkgSplitDBT")) {
            output = output.replaceAll("(?i)(?<!\\w)end\\s+(?!if|loop|case)(\\w+|\\w*\\.?\\w*" + delimiter + "?\\w*|\\w*.?##QUOTE##\\d+#)\\s*;", "END;");
        }
        output = QueryConversionUtility.getRplFromMap(output, quoteMap, "(##QUOTE##\\d+#)");
        output = output.replaceAll("[" + System.lineSeparator() + "]+", " ");
        if (!QueryConversionUtility.isGaus100()) {
            output = OraclePostProcessing.migrateForGaussDBA(output, util);
        }
        return output;
    }

    private static String migrateForGaussDBA(String input, OracleUtility util) {
        String schemaName;
        String output = input;
        if (output.matches("(?i).*(?<!\\w)begin(?!\\w).*")) {
            output = OraclePostProcessing.doGetUDTChanges(output, false);
        }
        if (output.matches("(?i).*(?<!\\w)TRUNCATE(?!\\w).*") && (schemaName = QueryConversionUtility.finderGroup(output, "(?i)(?<!\\w)(?:procedure|function)\\s+(?:\\w+\\.)?((\\w+)[\\.#]\\w+)\\s+", 2)) != null) {
            output = util.doRplSchemaInTruncTab(output, schemaName);
        }
        output = OracleQueryKeywordReplacer.doReplacePromptKeywordToEcho(output);
        return output;
    }

    private static String getDelimiter() {
        String delimiter = "";
        delimiter = !QueryConversionUtility.isGaus100() ? (FeatureLoader.getBooleanProperty("pkgSchemaNaming") ? "." : "#") : "#";
        return delimiter;
    }

    private static String migrateForDBA(String fileName, String input, OracleUtility util) {
        HashMap<String, String> map;
        String output = input;
        if (output.contains("NEW")) {
            output = OraclePostProcessing.doRemoveNewKeyword(output);
        }
        if (QueryConversionUtility.containsCheck(output, "RATIO_TO_REPORT")) {
            output = OracleUtility.doChangeRatioToReport(output);
        }
        if (output.contains("&")) {
            OraclePostProcessing.doPutCompileTypeVarInFile(fileName, output);
        }
        if (QueryConversionUtility.containsCheck(output = QueryConversionUtility.getSingleQuoteMap(output, map = new HashMap<String, String>(10)), "dbms_lob")) {
            output = util.stringFunctions(output);
            output = util.tempFunctionCursor(output);
            output = util.appendFunction(output, "blogic");
        }
        output = QueryConversionUtility.getRplFromMap(output, map, "(##QUOTE##\\d+#)");
        map.clear();
        output = OraclePostProcessing.doAddSelectOpenWith(output);
        output = QueryConversionUtility.replaceAll(output, "(?i)\\.COUNT\\s*(\\(\\s*\\))", ".COUNT");
        return output;
    }

    private static String doAddSelectOpenWith(String output) {
        Matcher matcher = OPEN_FOR_SELECT.matcher(output);
        int tempIndex = 0;
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            int startIndex = matcher.start(1);
            int endIndex = matcher.end(1);
            sb.append(output.substring(tempIndex, startIndex));
            String openWithStr = matcher.group(1);
            sb.append("SELECT * FROM ( ").append(openWithStr).append(" ").append(")");
            tempIndex = endIndex;
        }
        sb.append(output.substring(tempIndex));
        return sb.toString();
    }

    private static String doRemoveNewKeyword(String inputQuery) {
        String inputQry = inputQuery;
        Matcher removeNewMatcher = REMOVE_NEW_PATTERN.matcher(inputQry);
        if (removeNewMatcher.find()) {
            inputQry = inputQry.replace(removeNewMatcher.group(1), "");
        }
        return inputQry;
    }

    private static void doPutCompileTypeVarInFile(String fileName, String output) {
        Matcher matcherIdentifier = PATTERN_IDENTIFIER.matcher(output);
        while (matcherIdentifier.find()) {
            OracleMigrationService.addUserAttentionMap(matcherIdentifier.group(1), fileName);
        }
    }

    public static String doGetUDTChanges(String outputQry, boolean isPkgSplit) {
        String output = outputQry;
        Map<String, String> createTypesDDL = OracleMigrationService.getCreateTypeMap();
        Pattern patternType = Pattern.compile("(?i)(.*?(?<!\\w)declare|.*?(?<!\\w)(?:as|is)(?!\\w))(?!\\w)(.*?)((?<!\\w)begin(?!\\w).*)");
        Matcher matcherType = patternType.matcher(output);
        LinkedHashMap<String, String> declareTypes = new LinkedHashMap<String, String>(10);
        HashMap<String, String> recordTypes = new HashMap<String, String>(10);
        String header = null;
        String declare = null;
        String begin = null;
        int beginIndex = 0;
        OracleUtility util = new OracleUtility();
        if (matcherType.find()) {
            header = OraclePostProcessing.getHeader(isPkgSplit, matcherType, util);
            String declareBeforeMig = declare = OraclePostProcessing.getDeclareValue(matcherType, header);
            StringBuffer varrayDecVars = new StringBuffer();
            declare = OraclePostProcessing.longToText(isPkgSplit, declare, util, varrayDecVars);
            declare = OraclePostProcessing.doMigrateDeclareStmt(createTypesDDL, declareTypes, recordTypes, header, declare);
            if (matcherType.group(3) != null) {
                begin = OraclePostProcessing.getBegin(output, matcherType, varrayDecVars);
                String inputQry = OraclePostProcessing.returnRecordCol(declare, begin);
                int indexDblNegate = inputQry.indexOf("~~");
                declare = inputQry.substring(0, indexDblNegate);
                begin = OraclePostProcessing.handleDupOnIdx(begin, inputQry, indexDblNegate);
                StringBuilder updBegin = new StringBuilder();
                String[] semiColonSplitArrays = QueryConversionUtility.doGetArrSplit(begin, ";");
                declare = OraclePostProcessing.getUpdBeginDeclareValue(createTypesDDL, declare, updBegin, semiColonSplitArrays);
                begin = updBegin.toString();
            }
            if (!isPkgSplit) {
                declare = OraclePostProcessing.doCommentRecordTypeReturnInCursor(declare, recordTypes);
                begin = OraclePostProcessing.handleReturnInCursor(recordTypes, begin, declareBeforeMig);
            }
        } else {
            beginIndex = QueryConversionUtility.getStartIndex(output, "(?i)(?<!\\w)begin(?!\\w)", 0);
            header = OraclePostProcessing.getHeaderVal(output, isPkgSplit, beginIndex, util);
            begin = OraclePostProcessing.getBeginSubValue(output, isPkgSplit, begin, beginIndex);
        }
        output = OraclePostProcessing.getFinalOutputValue(output, isPkgSplit, createTypesDDL, declareTypes, recordTypes, header, declare, begin);
        return output;
    }

    private static String handleDupOnIdx(String beginQry, String inputQry, int indexDblNegate) {
        String begin = beginQry;
        if (indexDblNegate + 2 <= inputQry.length()) {
            begin = inputQry.substring(indexDblNegate + 2);
        }
        begin = OraclePostProcessing.getBeginClause(begin);
        return begin;
    }

    private static String getBegin(String output, Matcher matcherType, StringBuffer varrayDecVars) {
        String begin = matcherType.group(3).replaceFirst("(?i)begin", "BEGIN " + varrayDecVars.toString());
        String pckgName = OraclePostProcessing.getPackageName(output);
        begin = OraclePostProcessing.doAddBracktsToProc(begin, pckgName);
        return begin;
    }

    private static String longToText(boolean isPkgSplit, String dec, OracleUtility util, StringBuffer varrayDecVars) {
        String declare = dec;
        if (!isPkgSplit) {
            declare = util.doMigrateDeclareStmt(declare, varrayDecVars);
        }
        return declare;
    }

    public static String getBeginClause(String beginQry) {
        String begin = beginQry;
        begin = OraclePostProcessing.supportDupValOnIndex(begin);
        begin = OracleQueryKeywordReplacer.removeSys(begin);
        HashMap<String, String> quoteList = new HashMap<String, String>(5);
        begin = QueryConversionUtility.getSingleOrDoubleQuoteMap(begin, quoteList, "'", "\\'.*?\\'", "~#~~#~~");
        begin = OraclePostProcessing.doReplaceDotWithHash(begin);
        begin = QueryConversionUtility.getRplFromMap(begin, quoteList, "(~#~~#~~\\d+#)");
        return begin;
    }

    private static String doReplaceDotWithHash(String input) {
        String output = input;
        if (!FeatureLoader.getBooleanProperty("pkgSchemaNaming")) {
            String pkg = null;
            String pkgReplacement = null;
            Map<String, String> packageMap = OracleMigrationService.getPackageNameMap();
            for (Map.Entry<String, String> pckgNameMap : packageMap.entrySet()) {
                pkg = pckgNameMap.getKey();
                pkgReplacement = pckgNameMap.getValue().trim();
                if (pkgReplacement.matches("(?i)(type\\s+(\\w+)\\s+(?:is|as)\\s+(table|varray|RECORD)(?!\\w).*?;)|(?i)(subtype\\s+(\\w+)\\s+(?:is|as)\\s+(.*?)(;|$))") || pkgReplacement.contains("-")) continue;
                output = QueryConversionUtility.doReplaceExactStr(QueryConversionUtility.santizePattern(pkg), pkgReplacement, output);
            }
        }
        return output;
    }

    public static String getPackageName(String output) {
        String input = output;
        Matcher pkgMatcher = PKG_FINDER.matcher(input);
        String pkgName = null;
        pkgName = OraclePostProcessing.getCursor(pkgName, pkgMatcher);
        return pkgName;
    }

    private static String doAddBracktsToProc(String begin, String pkgName) {
        String packageNm = pkgName;
        String beginQry = begin;
        Matcher procMatch = PARAMETER_LESS_PROC.matcher(beginQry);
        int startIndex = 0;
        StringBuffer sb = new StringBuffer();
        if (packageNm != null) {
            packageNm = packageNm.replace("#", ".");
        }
        block0: while (procMatch.find()) {
            boolean isValidProc = false;
            String proc = procMatch.group(1);
            if (proc == null) continue;
            String procWithPackage = "";
            procWithPackage = proc.trim().matches("\\w+") && packageNm != null ? packageNm + proc : proc;
            Map<String, String> getProcOrFunc = OracleMigrationService.getCreateTypeMap();
            for (Map.Entry<String, String> entry : getProcOrFunc.entrySet()) {
                int count;
                String procOrFun = entry.getKey();
                if (!procOrFun.endsWith("_MIG_PROC") || !(isValidProc = OraclePostProcessing.isValidProc(isValidProc, procWithPackage, procOrFun))) continue;
                String rplmnt = proc;
                if (FeatureLoader.getBooleanProperty("pkgSchemaNaming") && (count = QueryConversionUtility.countOccurrencesOfSubstring(rplmnt, ".")) > 1) {
                    rplmnt = rplmnt.substring(rplmnt.indexOf(".") + 1);
                }
                rplmnt = rplmnt.trim() + "(" + ")" + procMatch.group(2);
                int beginIndex = procMatch.start();
                sb.append(beginQry.substring(startIndex, beginIndex));
                sb.append(rplmnt);
                startIndex = procMatch.end();
                continue block0;
            }
        }
        sb.append(beginQry.substring(startIndex));
        return sb.toString();
    }

    private static boolean isValidProc(boolean isValProcedure, String procWithPkg, String procOrFunQry) {
        boolean isValidProc = isValProcedure;
        String procOrFun = procOrFunQry;
        String procWithPackage = procWithPkg;
        if (QueryConversionUtility.equalCheck(procOrFun = procOrFun.replace("_MIG_PROC", ""), (procWithPackage = procWithPackage.replace("#", ".")).trim())) {
            isValidProc = true;
        } else if (procOrFun.matches(".*(?i)\\.?(?<!\\w)" + procWithPackage.trim() + "(?!\\w)")) {
            isValidProc = true;
        }
        return isValidProc;
    }

    private static String getUpdBeginDeclareValue(Map<String, String> createTypesDDL, String declareQry, StringBuilder updBegin, String[] semiColonSplitArrays) {
        int c3 = 0;
        int varCount = 0;
        int countDec = 0;
        int countInto = 0;
        String declare = declareQry;
        for (String beginQry : semiColonSplitArrays) {
            if ((QueryConversionUtility.containsCheck(beginQry = OraclePostProcessing.getBeginQry(beginQry), " FETCH") || QueryConversionUtility.containsCheck(beginQry, "SELECT")) && QueryConversionUtility.containsCheck(beginQry, "BULK")) {
                Matcher bulkIntoMatch = BULK_INTO.matcher(beginQry);
                StringBuffer sb = new StringBuffer();
                declare = OraclePostProcessing.getDeclare(countDec, declare, beginQry);
                if (bulkIntoMatch.find()) {
                    String[] commaSplitColumns;
                    sb.append(beginQry.substring(0, bulkIntoMatch.start()));
                    String fetch = bulkIntoMatch.group(1);
                    String cur = bulkIntoMatch.group(2);
                    if (QueryConversionUtility.containsCheck(cur, " FETCH")) {
                        Matcher matchSelWithFetch = GET_CUR_WHEN_SEL_WITH_FETCH.matcher(cur);
                        fetch = " FETCH";
                        cur = OraclePostProcessing.getCursor(cur, matchSelWithFetch);
                    }
                    String into = bulkIntoMatch.group(3);
                    String var = bulkIntoMatch.group(4);
                    for (String col : commaSplitColumns = QueryConversionUtility.doGetArrSplit(var, ",")) {
                        String value = OraclePostProcessing.getVal(createTypesDDL, col);
                        declare = OraclePostProcessing.getDeclareWhenFetchOrSel(declare, countDec, value, beginQry);
                        ++countDec;
                    }
                    OraclePostProcessing.getBegin(beginQry, sb, fetch, cur, into, commaSplitColumns, countInto, varCount, c3);
                    countInto = commaSplitColumns.length;
                    varCount = commaSplitColumns.length;
                    c3 = commaSplitColumns.length;
                }
                beginQry = sb.toString();
            }
            OraclePostProcessing.modifyUpdBegin(updBegin, beginQry);
        }
        return declare;
    }

    private static String getVal(Map<String, String> createTypesDDL, String col) {
        String varCheck = col.trim() + "_VARRAYVAR";
        String value = createTypesDDL.get(varCheck);
        return value;
    }

    private static String getCursor(String cursor, Matcher matchSelWithFetch) {
        String cur = cursor;
        if (matchSelWithFetch.find()) {
            cur = matchSelWithFetch.group(1);
        }
        return cur;
    }

    private static String getBeginQry(String begin) {
        String beginQry = begin;
        if (!(beginQry.contains(";") || beginQry.trim().endsWith("/") || beginQry.matches(" "))) {
            beginQry = beginQry + ";";
        }
        return beginQry;
    }

    private static String getDeclare(int countDec, String decQry, String beginQry) {
        String declare = decQry;
        if (QueryConversionUtility.containsCheck(beginQry, "select") && !QueryConversionUtility.containsCheck(beginQry, " FETCH") && countDec == 0) {
            declare = declare + "MIG_REF_CUR" + " " + "SYS_REFCURSOR" + ";";
        }
        return declare;
    }

    private static String getDeclareWhenFetchOrSel(String declareQry, int count, String value, String begin) {
        String declare = declareQry;
        if (value != null) {
            declare = declare + "mig_rec" + "_" + count + " " + value + ";" + " " + "mig_rec_idx" + "_" + count + " " + "INTEGER" + " := " + 0 + ";";
        }
        return declare;
    }

    private static void getBegin(String begin, StringBuffer sb, String fetch, String cur, String into, String[] commaSplitColumns, int cntInto, int count1, int count3) {
        int countInto = cntInto;
        int c1 = count1;
        int c3 = count3;
        if (QueryConversionUtility.containsCheck(begin, "SELECT") && !QueryConversionUtility.containsCheck(begin, " FETCH")) {
            Matcher matchBeginWhenSel = BEGIN_WHEN_SEL.matcher(begin);
            String fromClass = null;
            if (matchBeginWhenSel.find()) {
                fromClass = matchBeginWhenSel.group(1);
                sb.append("OPEN").append(" ").append("MIG_REF_CUR").append(" ").append("FOR").append(" ").append("SELECT").append(" ").append(cur).append(" ").append(fromClass);
                int c2 = 0;
                OraclePostProcessing.getTillMigRefCur(sb, into, commaSplitColumns, c1);
                OraclePostProcessing.getTillNotFound(sb, commaSplitColumns, countInto, c2);
            }
        } else {
            int c2 = 0;
            for (String col : commaSplitColumns) {
                sb.append(" ").append("mig_rec_idx").append("_").append(c1).append(" := ").append(col).append(".").append("COUNT").append(" ").append(";");
                ++c1;
            }
            sb.append("LOOP").append(" ").append(fetch).append(" ").append(cur).append(" ").append(into).append(" ");
            while (c2 < commaSplitColumns.length) {
                countInto = OraclePostProcessing.getCountInto(sb, countInto, c2);
                ++c2;
            }
            sb.append(";");
            sb.append("EXIT WHEN").append(" ").append(cur).append("%NOTFOUND").append(";");
        }
        OraclePostProcessing.getQryTillEnd(begin, sb, commaSplitColumns, c3);
    }

    private static void getQryTillEnd(String begin, StringBuffer sb, String[] commaSplitColumns, int count3) {
        int c3 = count3;
        for (String col : commaSplitColumns) {
            sb.append("mig_rec_idx").append("_").append(c3).append(" ").append(" := ").append(" ").append("mig_rec_idx").append("_").append(c3).append("+").append(1).append(";");
            sb.append(col).append("(").append("mig_rec_idx").append("_").append(c3).append(")").append(" ").append(" := ").append(" ").append("mig_rec").append("_").append(c3).append(";");
            ++c3;
        }
        sb.append("end").append(" ").append("LOOP").append(";");
        if (!QueryConversionUtility.containsCheck(begin, " FETCH")) {
            sb.append("CLOSE").append(" ").append("MIG_REF_CUR").append(";");
        }
    }

    private static int getCountInto(StringBuffer sb, int intoCount, int c2) {
        int countInto = intoCount;
        if (c2 == 0) {
            sb.append("mig_rec").append("_").append(countInto);
            ++countInto;
        } else {
            sb.append(",").append("mig_rec").append("_").append(countInto);
            ++countInto;
        }
        return countInto;
    }

    private static void getTillNotFound(StringBuffer sb, String[] commaSplitColumns, int intoCount, int c2) {
        int countInto = intoCount;
        while (c2 < commaSplitColumns.length) {
            countInto = OraclePostProcessing.getCountInto(sb, countInto, c2);
            ++c2;
        }
        sb.append(";");
        sb.append("EXIT WHEN").append(" ").append("MIG_REF_CUR").append("%NOTFOUND").append(";");
    }

    private static void getTillMigRefCur(StringBuffer sb, String into, String[] commaSplitColumns, int count1) {
        int c1 = count1;
        for (String col : commaSplitColumns) {
            col = col.trim();
            sb.append(" ").append("mig_rec_idx").append("_").append(c1).append(" := ").append(col).append(".").append("COUNT").append(" ").append(";");
            ++c1;
        }
        sb.append("LOOP").append(" ");
        sb.append(" FETCH").append(" ").append("MIG_REF_CUR").append(" ").append(into);
        sb.append(" ");
    }

    private static void modifyUpdBegin(StringBuilder updBegin, String beginQry) {
        updBegin.append(beginQry);
        if (!QueryConversionUtility.containsCheck(updBegin.toString(), "BEGIN")) {
            updBegin.insert(0, "BEGIN ");
        }
    }

    private static String handleReturnInCursor(Map<String, String> recordTypes, String beginQry, String declareBeforeMig) {
        String begin = beginQry;
        if (QueryConversionUtility.equalCheck(FeatureLoader.getStringProperty("plsqlCollection"), "localtable") && begin != null) {
            begin = OraclePostProcessing.doReplaceRecordinFetchCursor(begin, declareBeforeMig, recordTypes);
        }
        return begin;
    }

    private static String getBeginSubValue(String output, boolean isPkgSplit, String beginQry, int beginIndex) {
        String begin = beginQry;
        if (!isPkgSplit) {
            begin = output.substring(beginIndex);
        }
        return begin;
    }

    private static String getHeaderVal(String output, boolean isPkgSplit, int beginIndex, OracleUtility util) {
        String header = output.substring(0, beginIndex);
        if (!isPkgSplit) {
            header = OraclePostProcessing.doRplResultCache(header);
            header = util.doMigrateHeaderStmt(header);
        }
        return header;
    }

    private static String getFinalOutputValue(String outputQry, boolean isPkgSplit, Map<String, String> createTypesDDL, Map<String, String> declareTypes, Map<String, String> recordTypes, String header, String declare, String beginQry) {
        String begin = beginQry;
        String output = outputQry;
        String tblCreationStr = OracleQueryKeywordReplacerExt.doGetCreateTblForTypes(declareTypes, recordTypes);
        StringBuffer sbOut = new StringBuffer();
        if (begin != null && !begin.contains("FETCH")) {
            sbOut.append(begin.substring(0, 5)).append(" ").append(tblCreationStr).append(" ").append(begin.substring(6));
            begin = sbOut.toString();
        }
        if (begin != null) {
            begin = OraclePostProcessing.updateBeginVal(isPkgSplit, createTypesDDL, declareTypes, begin);
            output = OraclePostProcessing.computeOutput(createTypesDDL, declareTypes, header, declare, begin);
        }
        output = OraclePostProcessing.getFinalOutput(output, createTypesDDL);
        return output;
    }

    private static String updateBeginVal(boolean isPkgSplit, Map<String, String> createTypesDDL, Map<String, String> declareTypes, String beginQry) {
        String begin = beginQry;
        if (!isPkgSplit) {
            begin = OraclePostProcessing.doChngeExtend(begin);
        }
        begin = OraclePostProcessing.doUDTAssignments(isPkgSplit, createTypesDDL, declareTypes, begin);
        return begin;
    }

    private static String getFinalOutput(String outputQry, Map<String, String> createTypesDDL) {
        String output = outputQry;
        output = OraclePostProcessing.replaceSynonym(output, createTypesDDL);
        output = OraclePostProcessing.replaceSynInDeclaration(output, createTypesDDL);
        return output;
    }

    private static String replaceSynInDeclaration(String outputQry, Map<String, String> createTypesDDL) {
        String output = outputQry;
        Matcher matchrplSynType = RPL_SYN_IN_TYPE.matcher(output);
        while (matchrplSynType.find()) {
            String key = matchrplSynType.group(1);
            output = OracleQueryKeywordReplacer.doRplSynWithTable(output, createTypesDDL, key);
        }
        return output;
    }

    public static String replaceSynonym(String outputQry, Map<String, String> createTypesDDL) {
        String key;
        String output = outputQry;
        Pattern synonymName = Pattern.compile("(?i)(?:(?:insert\\s+into\\s+)|(?:update\\s+)|(?:delete.*from\\s+))(\\w+)");
        Matcher matcher = synonymName.matcher(output);
        Matcher matcherSyn = GET_WHERE_SYN.matcher(output);
        while (matcher.find()) {
            key = matcher.group(1);
            output = OracleQueryKeywordReplacer.doRplSynWithTable(output, createTypesDDL, key);
        }
        while (matcherSyn.find()) {
            key = matcherSyn.group(1);
            output = OracleQueryKeywordReplacer.doRplSynWithTable(output, createTypesDDL, key);
        }
        output = OraclePostProcessing.rplSynFromClass(output, createTypesDDL);
        output = OracleQueryKeywordReplacer.synonymPackage(output, createTypesDDL);
        return output;
    }

    private static String rplSynFromClass(String outputQry, Map<String, String> createTypesDDL) {
        String output = outputQry;
        Matcher getColsM = GET_FROM_COLS.matcher(output);
        ColumnSplitter splitter = new ColumnSplitter();
        List<String> recordCols = null;
        if (getColsM.find()) {
            String cols = getColsM.group(1);
            recordCols = splitter.doGetAllColumns(cols);
            for (String col : recordCols) {
                String[] commaSplitArrays = QueryConversionUtility.doGetArrSplit(col, " ");
                String key = commaSplitArrays[0];
                output = OracleQueryKeywordReplacer.doRplSynWithTable(output, createTypesDDL, key);
            }
        }
        return output;
    }

    private static String doUDTAssignments(boolean isPkgSplit, Map<String, String> createTypesDDL, Map<String, String> declareTypes, String beginQry) {
        String begin = beginQry;
        for (Map.Entry<String, String> tableEntry : declareTypes.entrySet()) {
            String table = tableEntry.getKey();
            String typeName = tableEntry.getValue().trim();
            begin = OraclePostProcessing.doCommentTypeDeclaration(table, typeName, begin);
            begin = OraclePostProcessing.doUDTFnAssign(begin, table, typeName);
            begin = OraclePostProcessing.singleRecordIns(begin, table);
            begin = begin.replaceAll("(?<!\\w)\\s*:", ":");
            Pattern patternFetchMore = Pattern.compile("(?i)(\\(\\s*" + table + "\\s*\\(\\s*(\\d+)\\s*\\)\\s*,)");
            Matcher matchFetchMore = patternFetchMore.matcher(begin);
            while (matchFetchMore.find()) {
                String subStr = QueryConversionUtility.doGetReplaceString(begin.substring(matchFetchMore.start(1)));
                String outStr = "(" + OraclePostProcessing.formMultiUDTQry(subStr.substring(1, subStr.length() - 1), table, createTypesDDL, declareTypes) + ")";
                begin = begin.replace(subStr, outStr);
                matchFetchMore = patternFetchMore.matcher(begin);
            }
            if (!isPkgSplit) {
                begin = OracleQueryKeywordReplacer.replaceAssignmentWithInsert(begin, table);
            }
            Pattern patternFetch = Pattern.compile("(?i)((?<!\\w)" + table + "\\s*\\(\\s*(\\w+)\\s*\\)(\\s*\\.\\w+)?(?!:))");
            Matcher match = patternFetch.matcher(begin);
            String colValue = null;
            while (match.find()) {
                if (match.group(3) == null) {
                    colValue = createTypesDDL.get(QueryConversionUtility.toUpper(tableEntry.getValue()));
                    begin = begin.replace(match.group(1), OraclePostProcessing.formUDTQry(table, match.group(2), colValue));
                } else {
                    begin = begin.replace(match.group(1), OraclePostProcessing.formUDTQry(table, match.group(2), match.group(3).trim().substring(1)));
                }
                match = patternFetch.matcher(begin);
            }
            begin = OracleQueryKeywordReplacerExt.doUDTCount(begin, table);
        }
        return begin;
    }

    private static String doMigrateDeclareStmt(Map<String, String> createTypesDDL, Map<String, String> declareTypes, Map<String, String> recordTypes, String header, String declareQry) {
        String declare = declareQry;
        declare = OracleQueryKeywordReplacerExt.doCommentDeclareTypes(declareTypes, declare, createTypesDDL, header, recordTypes);
        declare = OracleQueryKeywordReplacer.doputQuotesforGuassKeywords(declare);
        if (QueryConversionUtility.containsCheck(declare = OracleQueryKeywordReplacer.changePlsIntegerToInteger(declare), "nocopy")) {
            declare = OracleQueryKeywordReplacer.commentNocopy(declare);
        }
        if (QueryConversionUtility.containsCheck(declare, "POSITION")) {
            declare = OracleQueryKeywordReplacer.positionWithQuotes(declare);
        }
        return declare;
    }

    private static String getDeclareValue(Matcher matcherType, String header) {
        String declare = matcherType.group(2);
        OracleUtility oracleUtil = new OracleUtility();
        if (!QueryConversionUtility.containsCheck(header, "declare")) {
            declare = oracleUtil.doRplPercentageType(declare, "");
        }
        HashMap<String, String> commentMap = new HashMap<String, String>(10);
        declare = QueryConversionUtility.getSingleOrDoubleQuoteMap(declare, commentMap, "/*", "\\/\\*.*?\\*\\/", "##COMMENT##");
        int startIndex = 0;
        StringBuffer declareBuff = new StringBuffer();
        Matcher matcher = Pattern.compile(";").matcher(declare);
        while (matcher.find()) {
            int endIndex = matcher.start();
            String var = declare.substring(startIndex, endIndex);
            if (!var.trim().matches("(?i)(#S#\\d+#E#|##COMMENT##\\d+#)") && !var.isEmpty() && QueryConversionUtility.containsCheck(var = var + ";", "NULL")) {
                var = OracleQueryKeywordReplacerExt.doCommentNullConstraint(var);
            }
            declareBuff.append(" ").append(var);
            startIndex = endIndex + 1;
        }
        declareBuff.append(declare.substring(startIndex));
        declare = declareBuff.toString();
        declare = QueryConversionUtility.getRplFromMap(declare, commentMap, "(##COMMENT##\\d+#)");
        return declare;
    }

    private static String getHeader(boolean isPkgSplit, Matcher matcherType, OracleUtility util) {
        String header = matcherType.group(1);
        if (!isPkgSplit) {
            header = OraclePostProcessing.doRplResultCache(header);
            header = util.doMigrateHeaderStmt(header);
        }
        return header;
    }

    private static String returnRecordCol(String declareQry, String beginQry) {
        String begin = beginQry;
        String declare = declareQry;
        StringBuffer declareBuf = new StringBuffer(declare);
        Matcher funcMat = FUNC_RET.matcher(begin);
        int iIndex = 1;
        while (funcMat.find()) {
            StringBuffer replacement = new StringBuffer();
            String funcWithPack = funcMat.group(2).trim();
            String returnfunc = funcMat.group(1).trim();
            Map<String, String> createTypesFunc = OracleMigrationService.getCreateTypeMap();
            String dataType = createTypesFunc.get(funcWithPack.toUpperCase(Locale.ROOT) + "FUNC");
            if (dataType == null) continue;
            declareBuf.append("MIG_FUNC" + iIndex).append(" ").append(dataType).append(";").append(" ");
            declare = declareBuf.toString();
            int startIndex = returnfunc.indexOf(funcWithPack);
            int lastIndex = returnfunc.lastIndexOf(".");
            String fun = startIndex != -1 && lastIndex != -1 ? returnfunc.substring(startIndex, lastIndex) : "";
            replacement.append("MIG_FUNC" + iIndex).append(" ").append(" := ").append(" ").append(fun).append(";").append("RETURN").append(" ").append("MIG_FUNC" + iIndex).append(returnfunc.substring(returnfunc.lastIndexOf(".")));
            begin = begin.replace(returnfunc, replacement.toString());
            ++iIndex;
        }
        String beginDeclare = declare + "~~" + begin;
        return beginDeclare;
    }

    private static String computeOutput(Map<String, String> createTypesDDL, Map<String, String> declareTypes, String header, String declare, String beginQry) {
        String output;
        String begin = beginQry;
        if (declare != null) {
            begin = OraclePostProcessing.doReturnTypeInBody(createTypesDDL, declareTypes, begin);
            output = declare + " " + begin;
        } else {
            output = header + " " + begin;
        }
        return output;
    }

    private static String doRplResultCache(String header) {
        String headerOp = header;
        if (QueryConversionUtility.containsCheck(headerOp, "RESULT_CACHE")) {
            String patternResultCache = "(?i).*((?<!\\w)RESULT_CACHE\\s+RELIES_ON\\s*\\(.*?\\)).*";
            headerOp = QueryConversionUtility.doReplaceSpecificGrp(headerOp, patternResultCache, "", "", 1, false);
            headerOp = QueryConversionUtility.doReplaceExactStr("RESULT_CACHE", "", headerOp);
        }
        return headerOp;
    }

    private static String doReturnTypeInBody(Map<String, String> createTypesDDL, Map<String, String> declareTypes, String begin) {
        Matcher retBodyMatcher = RET_BODY_PATTERN.matcher(begin);
        StringBuffer beginBuf = new StringBuffer(begin);
        int offSet = 0;
        while (retBodyMatcher.find()) {
            String variableName = retBodyMatcher.group(2);
            StringBuffer returnRpl = new StringBuffer();
            String typeName = declareTypes.get(variableName);
            if (typeName != null) {
                typeName = QueryConversionUtility.toUpper(typeName);
                String columns = createTypesDDL.get(typeName);
                returnRpl.append("QUERY").append(" ");
                returnRpl.append("select").append(" ");
                returnRpl.append(columns).append(" ");
                returnRpl.append("from").append(" ");
                returnRpl.append(variableName);
                beginBuf.replace(retBodyMatcher.start(2) + offSet, retBodyMatcher.end(2) + offSet, returnRpl.toString());
                offSet += returnRpl.length() - variableName.length();
                continue;
            }
            Pattern pattern = Pattern.compile("(?i)(?<!\\w)" + QueryConversionUtility.santizePattern(variableName) + "=(.*?)(,|})");
            Matcher matcher = pattern.matcher(declareTypes.toString());
            if (!matcher.find()) continue;
            String type = matcher.group(1).trim();
            String columns = createTypesDDL.get(type);
            returnRpl.append("QUERY").append(" ");
            returnRpl.append("select").append(" ");
            returnRpl.append(columns).append(" ");
            returnRpl.append("from").append(" ");
            returnRpl.append(variableName);
            beginBuf.replace(retBodyMatcher.start(2) + offSet, retBodyMatcher.end(2) + offSet, returnRpl.toString());
            offSet += returnRpl.length() - variableName.length();
        }
        return beginBuf.toString();
    }

    private static String doChngeExtend(String inputBegin) {
        String beginStr = inputBegin;
        String rplStr = "EXTEND(1)";
        Matcher matcherExtend = PATTERN_EXTEND.matcher(beginStr);
        if (matcherExtend.find()) {
            beginStr = beginStr.replace(matcherExtend.group(1), rplStr);
        }
        return beginStr;
    }

    static String doUDTFnAssign(String begin, String table, String typeName) {
        String input = begin;
        Pattern patternUDTAssign = Pattern.compile("(?i)((?<!\\w)" + table + "\\s*:=\\s*((\\w+)\\s*\\((.*?)\\)\\s*;))");
        StringBuffer tempTable = null;
        Matcher match = patternUDTAssign.matcher(input);
        while (match.find()) {
            if (match.group(3).trim().equals(typeName)) continue;
            tempTable = new StringBuffer();
            tempTable.append("INSERT INTO ").append(" ");
            tempTable.append(table).append(" ").append("select");
            tempTable.append(" ").append("*").append(",");
            tempTable.append(" ").append("ROW_NUMBER").append("()");
            tempTable.append(" ").append("over").append("()");
            tempTable.append(" ").append("from").append(" ");
            tempTable.append(match.group(2));
            input = input.replace(match.group(1), tempTable.toString());
        }
        return input;
    }

    private static String formMultiUDTQry(String query, String typeVar, Map<String, String> createTypesDBMap, Map<String, String> declareTypeMap) {
        String[] commaSplittr = query.split("\\s*,\\s*");
        StringBuffer output = new StringBuffer();
        ArrayList<String> indices = new ArrayList<String>(10);
        LinkedHashMap<String, String> tableIdxMap = new LinkedHashMap<String, String>(10);
        int counter = 0;
        int openIdx = 0;
        int closeIdx = 0;
        String index = null;
        for (String typeInBracket : commaSplittr) {
            openIdx = typeInBracket.indexOf(40);
            closeIdx = typeInBracket.indexOf(41);
            index = typeInBracket.substring(openIdx + 1, closeIdx);
            if (QueryConversionUtility.isExactMatch(typeInBracket, typeVar)) {
                indices.add(index);
                continue;
            }
            if (typeInBracket.startsWith("(") && typeInBracket.endsWith(")")) {
                tableIdxMap.put("##" + counter++, typeInBracket);
                continue;
            }
            String variable = typeInBracket.substring(0, openIdx).trim();
            if (declareTypeMap.get(variable) == null) {
                tableIdxMap.put("##" + counter++, typeInBracket);
                continue;
            }
            tableIdxMap.put(variable + "@~@" + counter++, index);
        }
        String colValue = createTypesDBMap.get(QueryConversionUtility.toUpper(declareTypeMap.get(typeVar)));
        output.append(OraclePostProcessing.formUDTQry(typeVar, indices, colValue));
        for (Map.Entry keys : tableIdxMap.entrySet()) {
            if (((String)keys.getKey()).startsWith("##")) {
                output.append(",").append((String)keys.getValue());
                continue;
            }
            String[] typeVariable = ((String)keys.getKey()).split("@~@");
            if (typeVariable.length <= 0) continue;
            String typeVariableNme = typeVariable[0];
            colValue = createTypesDBMap.get(QueryConversionUtility.toUpper(declareTypeMap.get(typeVariableNme)));
            output.append(",").append(OraclePostProcessing.formUDTQry(typeVariableNme, (String)keys.getValue(), colValue));
        }
        return output.toString();
    }

    private static String formUDTQry(String table, String index, String column) {
        StringBuffer output = new StringBuffer("(");
        output.append("SELECT").append(" ").append(column);
        output.append(" ").append("FROM").append(" ").append(table);
        output.append(" where ");
        output.append("typ_idx_col").append(" ");
        output.append("=").append(" ");
        if (index != null) {
            output.append(index).append(")");
        }
        return output.toString();
    }

    private static String formUDTQry(String typeVar, List<String> indices, String typeColumnValue) {
        StringBuffer output = new StringBuffer("SELECT ");
        output.append(typeColumnValue).append(" ");
        output.append("from").append(" ");
        output.append(typeVar).append(" where ");
        output.append("typ_idx_col").append(" ");
        int indexSize = indices.size();
        if (indexSize == 1) {
            output.append("=").append(" ").append(indices.get(0));
        } else {
            output.append("in").append(" ").append("(");
            for (String idx : indices) {
                output.append(idx).append(",");
            }
            output.deleteCharAt(output.length() - 1);
            output.append(")");
        }
        return output.toString();
    }

    private static String singleRecordIns(String begin, String table) {
        String input = begin;
        Pattern patternVarAssign = Pattern.compile("(?i)((?<!\\w)" + table + "\\s*\\(\\s*(\\w*.?\\w+)\\s*\\)\\s*:=\\s*(\\'.*?\\'|\\w+)\\s*;)");
        Matcher match = patternVarAssign.matcher(input);
        StringBuffer tempTable = null;
        while (match.find()) {
            tempTable = new StringBuffer();
            tempTable.append("INSERT INTO ").append(" ");
            tempTable.append(table).append(" ");
            tempTable.append("values").append(" ").append("(");
            tempTable.append(match.group(3)).append(",");
            tempTable.append(match.group(2)).append(")");
            tempTable.append(";");
            input = input.replace(match.group(1), tempTable.toString());
        }
        return input;
    }

    private static String doCommentTypeDeclaration(String typeVar, String typeNme, String input) {
        Pattern patternUDTdeclar = Pattern.compile("(?i)((?<!\\w)" + typeVar + "\\s*:=\\s*((\\w+\\.\\s*)?\\w+)\\s*\\(\\s*\\)\\s*;)");
        Matcher match = patternUDTdeclar.matcher(input);
        int temp = 0;
        int start = 0;
        int end = 0;
        StringBuffer outbuff = new StringBuffer();
        while (match.find()) {
            start = match.start(1);
            end = match.end(1);
            if (!input.substring(match.start(2), match.end(2)).equals(typeNme)) continue;
            outbuff.append(input.substring(temp, start)).append("/*").append(match.group(1)).append("*/");
            temp = end + 1;
        }
        outbuff.append(input.substring(temp));
        return outbuff.toString();
    }

    private static String doCommentRecordTypeReturnInCursor(String declareQry, Map<String, String> recordTypes) {
        String declare = declareQry;
        Pattern patternFetchCursor = Pattern.compile("(?i)(?<!\\w)cursor\\s+(\\w+)\\s+(return\\s+(\\w+))\\s+is\\s+");
        Matcher matcher = patternFetchCursor.matcher(declare);
        while (matcher.find()) {
            String recordTypeName = matcher.group(3);
            if (!recordTypes.containsKey(QueryConversionUtility.toUpper(recordTypeName))) continue;
            int startIndex = matcher.start(2);
            int endIndex = matcher.end(2);
            declare = declare.substring(0, startIndex) + "/*" + matcher.group(2) + "*/" + declare.substring(endIndex);
            matcher = patternFetchCursor.matcher(declare);
        }
        return declare;
    }

    private static String doReplaceRecordinFetchCursor(String beginQry, String declareBeforeMig, Map<String, String> recordTypes) {
        String begin = beginQry;
        ArrayList<String> recVarNames = new ArrayList<String>(10);
        String allCursorPattern = "(?i)(?<!\\w)(fetch\\s+.*?into.*?\\s+(\\w+).*?;)";
        Pattern patternAllCursor = Pattern.compile(allCursorPattern);
        Matcher cursorMatcher = patternAllCursor.matcher(begin);
        while (cursorMatcher.find()) {
            recVarNames.add(cursorMatcher.group(2));
        }
        for (String recVarName : recVarNames) {
            String pattern = "(?i)(?<!\\w)((fetch\\s+.*?(\\w+)\\s+.*?(?<!\\w)into(?!\\w).*?(?<!\\w))" + recVarName + "(?!\\w).*?;)";
            Pattern patternCursor = Pattern.compile(pattern);
            Matcher matcher = patternCursor.matcher(new InterruptCharSequence(begin));
            StringBuffer sb = new StringBuffer();
            int startIndex = 0;
            int beginIndex = 0;
            while (matcher.find()) {
                String recTypeName = OraclePostProcessing.getRecordTypeName(declareBeforeMig, recVarName);
                String recFields = recordTypes.get(QueryConversionUtility.toUpper(recTypeName));
                List<String> recFieldNames = OraclePostProcessing.getRecordFields(recFields);
                String qualifiedFieldName = OraclePostProcessing.getQualifiedFieldName(recVarName, recFieldNames);
                if (qualifiedFieldName.length() <= 0) continue;
                String replacement = matcher.group(2) + " " + qualifiedFieldName + ";";
                startIndex = matcher.start(1);
                int endIndex = matcher.end(1);
                String startStr = begin.substring(beginIndex, startIndex);
                sb.append(startStr);
                sb.append(replacement);
                beginIndex = endIndex;
            }
            String endStr = beginIndex != -1 ? begin.substring(beginIndex) : "";
            sb.append(endStr);
            begin = sb.toString();
        }
        return begin;
    }

    private static String getRecordTypeName(String declareBeforeMig, String recTypeVarName) {
        Pattern pattern = Pattern.compile("(?i)(?<!\\w)" + recTypeVarName + "\\s+(\\w*?)\\s*;");
        Matcher matcher = pattern.matcher(new InterruptCharSequence(declareBeforeMig));
        String recordTypeName = "";
        if (matcher.find()) {
            recordTypeName = matcher.group(1).trim();
        }
        return recordTypeName;
    }

    private static List<String> getRecordFields(String recFields) {
        ColumnSplitter splitter = new ColumnSplitter();
        ArrayList<String> fieldNames = new ArrayList<String>(10);
        List<String> cols = splitter.doGetAllColumns(recFields);
        for (String col : cols) {
            int spaceIndex = col.indexOf(32);
            if (spaceIndex != -1) {
                col = col.substring(0, spaceIndex);
            }
            fieldNames.add(col);
        }
        return fieldNames;
    }

    private static String getQualifiedFieldName(String recVarName, List<String> recFields) {
        StringBuffer sb = new StringBuffer();
        for (String field : recFields) {
            sb.append(recVarName).append(".").append(field).append(",");
        }
        String qualifiedFields = sb.toString();
        if (qualifiedFields.length() > 1 && qualifiedFields.endsWith(",")) {
            qualifiedFields = qualifiedFields.substring(0, qualifiedFields.length() - 1);
        }
        return qualifiedFields;
    }

    private static String supportDupValOnIndex(String beginQry) {
        String begin = beginQry;
        if (QueryConversionUtility.containsCheck(begin, "EXCEPTION")) {
            begin = QueryConversionUtility.equalCheck(FeatureLoader.getStringProperty("supportDupValOnIndex"), "UNIQUE_VIOLATION") ? OraclePostProcessing.changeDupValIdx(begin) : OracleQueryKeywordReplacerExt.doHandleUnsupportedException(begin);
        }
        return begin;
    }

    private static String changeDupValIdx(String beginQry) {
        String begin = beginQry;
        Matcher matchChngeDupVal = CHANGE_DUP_VAL_IDX.matcher(begin);
        String dupVal = null;
        if (matchChngeDupVal.find()) {
            dupVal = matchChngeDupVal.group(1);
            begin = begin.replace(dupVal, "UNIQUE_VIOLATION");
        }
        return begin;
    }
}

