/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.oracle;

import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.oracle.OracleQueryKeywordReplacer;
import com.huawei.db.migration.oracle.OracleQueryKeywordReplacerExt;
import com.huawei.db.migration.oracle.OracleUtility;
import com.huawei.db.migration.services.OracleMigrationService;
import com.huawei.db.migration.util.ErrorLoggerUtility;
import com.huawei.db.migration.util.FeatureLoader;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OraclePreQueryProcessing {
    private static final Logger logger = LogManager.getLogger(OraclePreQueryProcessing.class);
    private static final Pattern FUNC_PROC_PAT = Pattern.compile("(?i)(?:FUNCTION|PROCEDURE)\\s+(?:#S#\\d+#E#\\s*)?\\\"?\\w*\\\"?\\.?\\\"?\\w+\\\"?(.*?)(AS|IS)", 2);
    private static final Pattern KEYWORDS_PATTERN = Pattern.compile("(?i)(?<!\\w)(NOORDER|NOKEEP|NOSCALE|GLOBAL|NOCACHE|ORDER)(?!\\w)");

    public static String doPreBulkChanges(String inputQry) throws MigrationServiceException {
        Pattern tableColsPat = Pattern.compile("(?i).*CREATE\\s+.*?(?<!\\w)TABLE\\s+(\\w*\\.?\\w+)\\s*\\((.*)\\).*?;?");
        Pattern tableColsWithPartition = Pattern.compile("(?i).*CREATE\\s+.*?(?<!\\w)TABLE\\s+(\\w*\\.?\\w+)\\s*\\((.*)\\).*?(?:PARTITION\\s+BY)");
        Pattern columnDataTypePat = Pattern.compile("(?i)(\\w+)\\s+((?!null)\\w+(?:\\(.*?\\))?).*?,?");
        String output = inputQry;
        if (QueryConversionUtility.containsCheck(output, "number")) {
            output = QueryConversionUtility.doReplaceSpecificGrp(output, "(?i)(?<!\\w)NUMBER(?!\\w)\\s*\\(\\s*(\\*)\\s*,\\s*\\d+\\s*\\)", "", "38", 1, false);
        }
        output = OraclePreQueryProcessing.doAddColsDataTypeToMap(output, tableColsPat, tableColsWithPartition, columnDataTypePat);
        output = OracleQueryKeywordReplacer.doReplaceSystemUnsupportedParameter(output, inputQry);
        output = OracleQueryKeywordReplacerExt.doPreOracleChanges(output);
        if (FeatureLoader.getBooleanProperty("TxHandler") && !output.matches("(?i).*(alter\\s+session\\s+(?:ADVISE\\s+(?:COMMIT|ROLLBACK|NOTHING)|CLOSE\\s+DATABASE\\s+LINK|(?:ENABLE|DISABLE)\\s+(?:RESUMABLE|COMMIT\\s+IN\\s+PROCEDURE|GUARD|PARALLEL\\s+(?:DML|DDL|QUERY))|FORCE\\s+PARALLEL\\s+(?:DML|DDL|QUERY)).*)")) {
            output = QueryConversionUtility.doReplaceSpecificGrp(output, "(?i)((?:^|(?<=;))\\s*commit\\s*;|(?<!\\w)rollback\\s*(?:work\\s*)?;)", "/*", "*/ null;", 1, true);
        }
        return output;
    }

    public static String doPreQueryChanges(String input) throws MigrationServiceException {
        String output = input;
        if (QueryConversionUtility.containsCheck(output, "TRUNC")) {
            output = QueryConversionUtility.doReplaceTrunc(output);
        }
        if (QueryConversionUtility.containsCheck(output, "FORCE VIEW")) {
            output = OraclePreQueryProcessing.doCmntForce(output);
        }
        if (output.matches("(?i).*purge.*")) {
            output = OraclePreQueryProcessing.doRplPurgedQry(output);
        }
        LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
        output = QueryConversionUtility.getSingleDoubleQuoteMap(output, quoteMap);
        OracleUtility util = new OracleUtility();
        if (QueryConversionUtility.containsCheck(output, "dbms_lob")) {
            output = util.stringFunctions(output);
            output = util.appendFunction(output, "query");
        }
        if (QueryConversionUtility.containsCheck(output = OracleQueryKeywordReplacerExt.toAddSchemaNameInFunc(output), "Replace")) {
            output = util.doModifyReplaceFunction(output);
        }
        if (QueryConversionUtility.containsCheck(output, "to_clob")) {
            output = util.doReplaceClob(output);
        }
        if (QueryConversionUtility.containsCheck(output, "CURRVAL") || QueryConversionUtility.containsCheck(output, "NEXTVAL")) {
            output = OracleUtility.doChangeNextCurrVal(output);
        }
        output = QueryConversionUtility.getRplFromMap(output, quoteMap, "(##QUOTE##\\d+#)");
        return output;
    }

    private static String doRplPurgedQry(String input) {
        String output = input;
        String cmntRmvdOp = output.replaceAll("(?i)#S#\\d+#E#", "").trim();
        if (QueryConversionUtility.toLower(cmntRmvdOp).startsWith("purge")) {
            output = "/*" + output.trim() + "*/";
        } else if (QueryConversionUtility.toLower(cmntRmvdOp).startsWith("drop")) {
            output = output.replaceAll("(?i)(?<!\\w)purge(?!\\w)", "");
        }
        return output;
    }

    private static String doAddColsDataTypeToMap(String outputQry, Pattern tableColsPat, Pattern tableColsWithPartition, Pattern columnDataTypePat) {
        String output;
        String outputSql = output = outputQry;
        Matcher tableColsMat = tableColsPat.matcher(outputSql);
        Matcher tableColsWithParMat = tableColsWithPartition.matcher(outputSql);
        String tableName = "";
        String tableColumns = "";
        StringBuffer sb = new StringBuffer();
        String ctStr = "";
        if (tableColsWithParMat.find()) {
            tableName = tableColsWithParMat.group(1).trim();
            tableColumns = tableColsWithParMat.group(2).trim();
            sb.append(outputSql.substring(0, tableColsWithParMat.start(2)));
            ctStr = outputSql.substring(tableColsWithParMat.end(2));
        } else if (tableColsMat.find()) {
            tableName = tableColsMat.group(1).trim();
            tableColumns = tableColsMat.group(2).trim();
            sb.append(outputSql.substring(0, tableColsMat.start(2)));
            ctStr = outputSql.substring(tableColsMat.end(2));
        }
        tableColumns = QueryConversionUtility.doCommentPatternGrp(tableColumns, "(?i)(,\\s*SUPPLEMENTAL\\s+LOG\\s+DATA.*?)(,|$)", 1);
        sb.append(tableColumns).append(ctStr);
        Matcher colDataTypeMat = columnDataTypePat.matcher(tableColumns);
        while (colDataTypeMat.find()) {
            StringBuffer tableColumn = new StringBuffer();
            String column = colDataTypeMat.group(1).trim();
            String colDataType = colDataTypeMat.group(2).trim();
            tableColumn.append(tableName).append(".").append(column).append("_").append("DATATYPE");
            OracleMigrationService.addCreateTypeMap(QueryConversionUtility.toUpper(tableColumn.toString()), colDataType);
        }
        output = sb.toString().isEmpty() ? output : sb.toString();
        return output;
    }

    private static String doCmntForce(String input) {
        Pattern cmntForce = Pattern.compile("(?i).*?replace\\s+(?<!\\w)(force)(?!\\w)\\s+view.*;");
        Matcher matcher = cmntForce.matcher(input);
        StringBuffer sb = new StringBuffer();
        String forceWOCmnt = null;
        String rplForce = null;
        int startIdx = 0;
        int tempIdx = 0;
        int endIdx = 0;
        while (matcher.find()) {
            startIdx = matcher.start();
            tempIdx = matcher.start(1);
            endIdx = matcher.end(1);
            forceWOCmnt = matcher.group(1);
            rplForce = "/*" + forceWOCmnt + "*/";
        }
        sb.append(input.substring(startIdx, tempIdx));
        sb.append(rplForce);
        sb.append(input.substring(endIdx));
        return sb.toString();
    }

    public static String doPreBLogicChanges(String inputQry) throws MigrationServiceException {
        String output = inputQry;
        output = OracleQueryKeywordReplacer.doReplaceSystemUnsupportedParameter(output, inputQry);
        output = OracleQueryKeywordReplacerExt.doPreOracleChanges(output);
        if (FeatureLoader.getBooleanProperty("exceptionHandler")) {
            output = QueryConversionUtility.doReplaceSpecificGrp(output, "(?i)((?<!\\w)exception\\s+when\\s+.*?(?<!\\w))end(?!\\s+if(?!\\w+)|\\s+loop(?!\\w+)|\\w+)", "/*", "*/", 1, true);
        }
        if (FeatureLoader.getBooleanProperty("TxHandler")) {
            output = QueryConversionUtility.doReplaceSpecificGrp(output, "(?i)(?<!\\w)(commit\\s*;|rollback\\s*(?:work\\s*)?;)", "/*", "*/ null;", 1, true);
        }
        if (QueryConversionUtility.containsCheck(output, "TRUNC")) {
            output = QueryConversionUtility.doReplaceTrunc(output);
        }
        output = output.replaceAll("\\s*\\.\\s*", ".");
        output = OraclePreQueryProcessing.replaceROWIDParam(output);
        return output;
    }

    private static String replaceROWIDParam(String input) {
        if (!QueryConversionUtility.toLower(input).contains("rowid")) {
            return input;
        }
        Matcher matcher = FUNC_PROC_PAT.matcher(input);
        int tempEnd = 0;
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            int startindex = matcher.start(1);
            int endIndex = matcher.end(1);
            sb.append(input.substring(tempEnd, startindex));
            String param = input.substring(startindex, endIndex);
            if (QueryConversionUtility.toLower(param).contains("rowid")) {
                sb.append(param.replaceAll("(?i)(?<!\\w)ROWID(?!\\w)", "VARCHAR2(32)"));
            } else {
                sb.append(param);
            }
            tempEnd = endIndex;
        }
        sb.append(input.substring(tempEnd));
        return sb.toString();
    }

    public static String doPreSequenceChanges(String inputQry) throws MigrationServiceException {
        String output = inputQry;
        if (QueryConversionUtility.containsCheck(output, "maxvalue")) {
            String gaussMaxValue = FeatureLoader.getStringProperty("maxValInSequence");
            String defaultMaxVal = "9223372036854775807";
            if (gaussMaxValue.isEmpty()) {
                gaussMaxValue = defaultMaxVal;
            }
            BigInteger gaussMaxInt = null;
            try {
                gaussMaxInt = new BigInteger(gaussMaxValue);
            }
            catch (NumberFormatException e) {
                logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " Error occurred in number format. " + e.toString());
                gaussMaxInt = new BigInteger(defaultMaxVal);
            }
            Pattern pattern = Pattern.compile("(?i)(?<!\\w)MAXVALUE\\s+(\\d+)");
            Matcher matcher = pattern.matcher(output);
            String maxvalue = null;
            BigInteger inputMaxInt = null;
            int compareResult = 0;
            while (matcher.find()) {
                maxvalue = matcher.group(1);
                inputMaxInt = new BigInteger(maxvalue);
                compareResult = inputMaxInt.compareTo(gaussMaxInt);
                if (compareResult != 1) continue;
                output = output.replace(maxvalue, gaussMaxValue);
            }
        }
        if (output.matches("(?i).*?(?<!\\w)(NOORDER|NOKEEP|NOSCALE|GLOBAL|NOCACHE|ORDER)(?!\\w).*?;")) {
            output = OraclePreQueryProcessing.commentUnsupportedKeywords(output);
        }
        if (!"false".equalsIgnoreCase(FeatureLoader.getStringProperty("MigSupportSequence")) && QueryConversionUtility.containsCheck(output, "SEQUENCE")) {
            output = OracleUtility.doChangeSequence(output);
        }
        return output;
    }

    private static String commentUnsupportedKeywords(String outputQry) {
        String output = outputQry;
        Matcher matcher = KEYWORDS_PATTERN.matcher(output);
        int startIdx = 0;
        int tempIdx = 0;
        int endIdx = 0;
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String match = matcher.group(1);
            String commentMatch = "/*" + match + "*/";
            tempIdx = matcher.start(1);
            endIdx = matcher.end(1);
            sb.append(output.substring(startIdx, tempIdx));
            sb.append(commentMatch);
            startIdx = endIdx;
        }
        sb.append(output.substring(endIdx));
        output = sb.toString();
        return output;
    }
}

