/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.oracle;

import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.oracle.OracleBulkHandler;
import com.huawei.db.migration.oracle.OraclePatternHandler;
import com.huawei.db.migration.oracle.OraclePreQueryProcessing;
import com.huawei.db.migration.oracle.OracleQueryKeywordReplacerExt;
import com.huawei.db.migration.util.ErrorLoggerUtility;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.ProgressUtil;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OracleQueryHandler {
    private static final Logger logger = LogManager.getLogger(OracleQueryHandler.class);

    public List<String> doMigProcess(List<String> inputList, String fileName, List<?> patterns, List<?> splitterPatterns) {
        ArrayList<String> outputList = new ArrayList<String>(10);
        int position = 0;
        String output = null;
        for (String input : inputList) {
            try {
                String forInput;
                String[] inputQry;
                ++position;
                if (input.contains("~#~") && (inputQry = input.split("~#~")).length > 1) {
                    input = inputQry[0];
                    position = Integer.parseInt(inputQry[1].trim());
                }
                output = forInput = QueryConversionUtility.doRemoveExtraSpace(input);
                boolean isProperInput = true;
                String unSupportedCheck = forInput;
                if (!OracleBulkHandler.isBulkHandlerFlag()) {
                    isProperInput = QueryConversionUtility.preQueryValidator(input);
                    unSupportedCheck = QueryConversionUtility.supportedValidator(forInput);
                }
                if (unSupportedCheck.equals(forInput) && isProperInput) {
                    output = forInput;
                    forInput = this.getOutputQry(forInput);
                    OraclePatternHandler objPatternHandler = new OraclePatternHandler();
                    output = objPatternHandler.doSplit(forInput, patterns, splitterPatterns, position);
                }
                outputList.add(output);
            }
            catch (MigrationServiceException e) {
                this.migServiceExc(fileName, position, e);
                outputList.add(input);
            }
            catch (RuntimeException e) {
                this.runtimeExc(fileName, position, e);
                outputList.add(input);
            }
            ProgressUtil.printProgress();
        }
        return outputList;
    }

    private void runtimeExc(String fileName, int position, RuntimeException e) {
        ErrorLoggerUtility.failedQryCnt();
        ErrorLoggerUtility.failedFileCnt(fileName);
        logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " " + MessageLoader.getMessage("queryProcessingError") + " " + fileName + " " + MessageLoader.getMessage("queryPosInfo") + position);
    }

    private void migServiceExc(String fileName, int position, MigrationServiceException e) {
        ErrorLoggerUtility.failedQryCnt();
        ErrorLoggerUtility.failedFileCnt(fileName);
        logger.error(e.getMessage());
        logger.error(MessageLoader.getMessage("queryProcessingError") + " " + fileName + " " + MessageLoader.getMessage("queryPosInfo") + position);
    }

    private String getOutputQry(String input) {
        String forInput = input;
        if ((forInput = OraclePreQueryProcessing.doPreQueryChanges(forInput)).matches("(?i)(.*)group\\s+by\\s+(cube|rollup|grouping\\s+sets)(.*)") && QueryConversionUtility.containsCheck(forInput, "rownum")) {
            forInput = OracleQueryKeywordReplacerExt.doReplaceColRownumFn(forInput);
            forInput = OracleQueryKeywordReplacerExt.doReplaceRownumFn(forInput);
        }
        return forInput;
    }
}

