/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.oracle;

import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.util.FeatureLoader;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OracleQueryKeywordReplacer {
    private static final Pattern PAT_SELECT = Pattern.compile("(?i).*?(\\(\\s*select\\s+.*)");
    private static final Pattern TABLE_PAT = Pattern.compile(".*?(\\w+)\\.");
    private static final Pattern PROC_FUNC_POSITION_PAT = Pattern.compile("(?i)(?:procedure|function).*?\\(.*(?:position).*\\).*");
    private static final Pattern PROC_FUNC_PAT = Pattern.compile("(?i)(?:procedure|function).*?\\((.*?)\\).*");
    private static final Pattern SELECT_FROM_PAT = Pattern.compile("(?i)select.*?from");
    private static final Pattern PCKG_PAT = Pattern.compile("(?i)(pckg\\w+)\\.");
    private static final Pattern SYS_DBMS_PAT = Pattern.compile("(?i)((?<!\\w)sys\\.dbms_job(?!\\w))");
    private static final Pattern GEOMETRY_PAT = Pattern.compile("(?i)GEOMETRY(\\s+(?:#s#\\d+#e#\\s*)?\\w+)?");
    private static String tablesJoin = "";

    public static String doChangeOrderofClause(String query) {
        Pattern pattern;
        Matcher matcher;
        int groupIdx;
        int havingIdx;
        String output = query;
        boolean isHaving = false;
        boolean isGroupBy = false;
        StringBuffer sbuf = new StringBuffer();
        if (QueryConversionUtility.isExactMatch(output, "having")) {
            isHaving = true;
        }
        if (QueryConversionUtility.isExactMatch(output, "group")) {
            isGroupBy = true;
        }
        if (isGroupBy && isHaving && (havingIdx = QueryConversionUtility.getIndex(query, "having", 0)) < (groupIdx = QueryConversionUtility.getIndex(query, " group ", 0)) && (matcher = (pattern = Pattern.compile("(?i)(having\\s+.*?)(group\\s+by\\s+(.*?))(order\\s+by\\s+.*|;|$)")).matcher(output)).find()) {
            String havingStr = matcher.group(1);
            String groupbByStr = matcher.group(2);
            String endStr = matcher.group(4);
            sbuf.append(output.substring(0, matcher.start(1))).append(groupbByStr).append(" ").append(havingStr).append(endStr);
            output = sbuf.toString();
        }
        return output;
    }

    public static String doChangeOptrInJoins(String query) {
        if (!FeatureLoader.getBooleanProperty("supportJoinOperator")) {
            return query;
        }
        String output = query;
        HashMap<String, String> subQryMap = new HashMap<String, String>(10);
        int joinQryCnt = 1;
        String joinString = "##JOINQRY##";
        while (output.matches("(?i).*?\\(\\s*select\\s+.*?")) {
            Matcher matchSelect = PAT_SELECT.matcher(output);
            String subQry = null;
            if (!matchSelect.find()) continue;
            subQry = QueryConversionUtility.doGetReplaceString(matchSelect.group(1));
            subQryMap.put(joinString + joinQryCnt, subQry);
            output = output.replace(subQry, joinString + joinQryCnt);
            ++joinQryCnt;
        }
        if (output.matches(".*?\\(\\s*\\+\\s*\\).*")) {
            output = OracleQueryKeywordReplacer.doProcessJoinMd(output);
        }
        for (Map.Entry joinSubQry : subQryMap.entrySet()) {
            String joinSubQuery = (String)joinSubQry.getValue();
            String key = (String)joinSubQry.getKey();
            if (!joinSubQuery.matches(".*?\\(\\s*\\+\\s*\\).*")) continue;
            joinSubQuery = OracleQueryKeywordReplacer.doProcessJoinMd(joinSubQuery);
            subQryMap.put(key, joinSubQuery);
        }
        output = QueryConversionUtility.doReplaceFunctionVariables(output, subQryMap, joinString);
        return output;
    }

    private static String doProcessJoinMd(String outputQry) {
        Pattern queryPattern;
        Matcher queryMatcher;
        StringBuffer outStr = new StringBuffer();
        String output = outputQry;
        int fromIndex = QueryConversionUtility.toUpper(output).indexOf("FROM");
        if (fromIndex != -1) {
            outStr.append(output.substring(0, fromIndex + 5));
            output = output.substring(fromIndex + 5);
        }
        if ((queryMatcher = (queryPattern = Pattern.compile("(?i)(.*?)where\\s+(.*?)(group\\s+by\\s+.*|order\\s+by\\s+.*|$|;)")).matcher(output)).find()) {
            String fromStr = queryMatcher.group(1);
            String whereStr = queryMatcher.group(2);
            String remainStr = queryMatcher.group(3);
            String tempWhere = whereStr;
            ArrayList<String> fromTables = new ArrayList<String>(Arrays.asList((fromStr = fromStr.replaceAll("(?i)(##SUBQUERY##\\d+__)", "$1 ")).split(",")));
            if (fromTables.size() > 1) {
                OracleQueryKeywordReplacer.doGetJoinStr(outStr, remainStr, tempWhere, fromTables, fromStr);
                output = outStr.toString();
            }
        }
        return output;
    }

    private static void doGetJoinStr(StringBuffer outStr, String remainStr, String tempWhereQry, ArrayList<String> fromTables, String fromStr) {
        String tempWhere = tempWhereQry;
        List<String> tablesList = new ArrayList<String>(10);
        String patternJoin = "(?i).*?(?:^|(?<!\\w)and\\s|(?<!\\w)or\\s)(.*?\\(\\s*\\+\\s*\\).*?)(?:(?<!\\w)and\\s|(?<!\\w)or\\s|$)";
        Pattern joinPattern = Pattern.compile(patternJoin);
        Matcher joinMatcher = joinPattern.matcher(tempWhere);
        String tempoWhereMatch = tempWhere;
        boolean tableJoinFlag = false;
        Matcher matcherTable = null;
        while (joinMatcher.find()) {
            String onStr = OracleQueryKeywordReplacer.getOnStr(joinMatcher);
            matcherTable = TABLE_PAT.matcher(onStr);
            LinkedHashSet<String> tabSet = new LinkedHashSet<String>(10);
            tableJoinFlag = OracleQueryKeywordReplacer.appendTableSet(tableJoinFlag, matcherTable, tabSet);
            if (tabSet.size() > 0) {
                String tab1 = null;
                String tab2 = null;
                ArrayList<String> list = new ArrayList<String>(tabSet);
                int equalIdx = OracleQueryKeywordReplacer.doGetEqualIdx(onStr);
                if (list.size() > 1) {
                    tab1 = (String)list.get(0);
                    tab2 = (String)list.get(1);
                } else if (onStr.indexOf((String)list.get(0)) < equalIdx) {
                    tab1 = (String)list.get(0);
                    tab2 = null;
                } else {
                    tab1 = null;
                    tab2 = (String)list.get(0);
                }
                String joinType = OracleQueryKeywordReplacer.getJoinType(onStr, equalIdx);
                tablesList = OracleQueryKeywordReplacer.updateTableJoin(tab1, tab2, fromTables, onStr, joinType);
                tempWhere = OracleQueryKeywordReplacer.getTempWhere(tempWhere, onStr);
            }
            tempoWhereMatch = OracleQueryKeywordReplacer.getTempWhere(tempoWhereMatch, onStr);
            joinMatcher = joinPattern.matcher(tempoWhereMatch);
        }
        tablesJoin = OracleQueryKeywordReplacer.updateTablesJoin(tablesList);
        tempWhere = OracleQueryKeywordReplacer.rplAnd(tempWhere);
        OracleQueryKeywordReplacer.doGetJoinOutStr(outStr, remainStr, tempWhere, fromStr, tableJoinFlag);
    }

    private static String rplAnd(String tempInput) {
        String tempWhere = tempInput;
        while (tempWhere.matches("(?i).*(?<!\\w)(and\\s+and)(?!\\w).*")) {
            tempWhere = tempWhere.replaceAll("(?i)(?<!\\w)(and\\s+and)(?!\\w)", "AND");
        }
        return tempWhere;
    }

    private static String getTempWhere(String tempInput, String onStr) {
        String tempWhere = tempInput;
        tempWhere = tempWhere.replace(onStr, "").trim();
        tempWhere = OracleQueryKeywordReplacer.doGetWhere(tempWhere);
        return tempWhere;
    }

    private static String getJoinType(String onStr, int equalIdx) {
        String joinType = "LEFT";
        if (onStr.indexOf(43) < equalIdx) {
            joinType = "RIGHT";
        }
        return joinType;
    }

    private static boolean appendTableSet(boolean tableJoinFlag, Matcher matcherTable, Set<String> tabSet) {
        while (matcherTable.find()) {
            tableJoinFlag = true;
            tabSet.add(matcherTable.group(1));
        }
        return tableJoinFlag;
    }

    private static String getOnStr(Matcher joinMatcher) {
        String onStr = joinMatcher.group(1).trim();
        if (onStr.matches("(?i).*(\\s+and\\s+|\\s+or\\s+).*")) {
            onStr = onStr.replaceAll("(?i).*(\\s+and\\s+|\\s+or\\s+)", "");
        }
        return onStr;
    }

    private static String updateTablesJoin(List<String> tablesList) {
        tablesJoin = null;
        StringBuffer tables = new StringBuffer();
        for (String table : tablesList) {
            if (table.isEmpty()) continue;
            tables.append(table).append(",");
        }
        tablesJoin = tables.toString();
        if (tablesJoin.endsWith(",")) {
            tablesJoin = tablesJoin.substring(0, tablesJoin.length() - 1);
        }
        return tablesJoin;
    }

    private static void doGetJoinOutStr(StringBuffer outStr, String remainStr, String tempWhere, String fromStr, boolean tableJoinFlag) {
        if (tableJoinFlag) {
            if (!tempWhere.isEmpty()) {
                outStr.append(tablesJoin).append(" ").append(" where ").append(tempWhere).append(" ").append(remainStr);
            } else {
                outStr.append(tablesJoin).append(" ").append(remainStr);
            }
        } else {
            outStr.append(fromStr).append(" ").append(" where ").append(tempWhere).append(" ").append(remainStr);
        }
    }

    private static int doGetEqualIdx(String onStr) {
        int equalIdx = onStr.indexOf(61);
        if (equalIdx == -1) {
            equalIdx = onStr.indexOf(60);
        }
        if (equalIdx == -1) {
            equalIdx = onStr.indexOf(62);
        }
        return equalIdx;
    }

    private static String doGetWhere(String tempWhereQry) {
        String tempWhere = tempWhereQry;
        if (!tempWhere.isEmpty() && !tempWhere.equals(";")) {
            int spaceIndex;
            String tmpWhereTolwr = QueryConversionUtility.toLower(tempWhere);
            while ((tmpWhereTolwr.startsWith("and") || tmpWhereTolwr.startsWith("or")) && (spaceIndex = tempWhere.indexOf(32)) != -1) {
                tempWhere = tempWhere.trim().substring(spaceIndex);
                tmpWhereTolwr = QueryConversionUtility.toLower(tempWhere).trim();
            }
            while ((tmpWhereTolwr.endsWith("and") || tmpWhereTolwr.endsWith("or")) && (spaceIndex = tempWhere.lastIndexOf(32)) != -1) {
                tempWhere = tempWhere.trim().substring(0, spaceIndex);
                tmpWhereTolwr = QueryConversionUtility.toLower(tempWhere).trim();
            }
        }
        return tempWhere;
    }

    private static List<String> updateTableJoin(String table1, String table2, List<String> tabList, String onCondQry, String joinType) {
        String onCond = onCondQry;
        int tabIndex1 = 1000;
        int tabIndex2 = 1000;
        int tabSize = tabList.size();
        String tab = null;
        for (int iIndex = 0; iIndex < tabSize; ++iIndex) {
            tab = tabList.get(iIndex);
            if (tabIndex1 == 1000 && QueryConversionUtility.isExactMatch(tab, table1)) {
                tabIndex1 = iIndex;
            }
            if (tabIndex2 != 1000 || !QueryConversionUtility.isExactMatch(tab, table2)) continue;
            tabIndex2 = iIndex;
        }
        onCond = onCond.replaceAll("\\(\\s*\\+\\s*\\)", "");
        OracleQueryKeywordReplacer.updTblLstUsingJoin(tabList, onCond, joinType, tabIndex1, tabIndex2);
        tabList.remove("");
        return tabList;
    }

    private static void updTblLstUsingJoin(List<String> tabList, String onCond, String joinType, int tabIndex1, int tabIndex2) {
        String tempTable = null;
        if (tabIndex1 == 1000) {
            if (tabList.get(tabIndex2).contains("OUTER JOIN")) {
                tempTable = tabList.get(tabIndex2) + " " + "and" + " " + onCond;
                tabList.set(tabIndex2, tempTable);
            } else {
                tempTable = tabList.get(0) + " " + joinType + " OUTER JOIN " + tabList.get(tabIndex2) + " on " + onCond;
                tabList.set(tabIndex2, "");
                tabList.set(0, tempTable);
                tempTable = "";
            }
        } else if (tabIndex2 == 1000) {
            if (tabList.get(tabIndex1).contains("OUTER JOIN")) {
                tempTable = tabList.get(tabIndex1) + " " + "and" + " " + onCond;
                tabList.set(tabIndex1, tempTable);
            } else {
                tempTable = tabList.get(tabIndex1) + " " + joinType + " OUTER JOIN " + tabList.get(0) + " on " + onCond;
                tabList.set(tabIndex1, "");
                tabList.set(0, tempTable);
                tempTable = "";
            }
        } else if (tabIndex1 != tabIndex2) {
            tempTable = tabList.get(tabIndex1) + " " + joinType + " OUTER JOIN " + tabList.get(tabIndex2) + " on " + onCond;
            tabList.set(tabIndex2, "");
            tabList.set(tabIndex1, tempTable);
        } else {
            tempTable = tabList.get(tabIndex1) + " " + "and" + " " + onCond;
            tabList.set(tabIndex2, "");
            tabList.set(tabIndex1, tempTable);
        }
    }

    public static String positionWithQuotes(String declareQry) {
        String declare = declareQry;
        StringBuffer sb = new StringBuffer();
        int tempIdx = 0;
        int endIdx = 0;
        Matcher getParemsMatcher = PROC_FUNC_POSITION_PAT.matcher(declare);
        String params = null;
        if (getParemsMatcher.find()) {
            params = getParemsMatcher.group();
            tempIdx = getParemsMatcher.start();
            endIdx = getParemsMatcher.end();
            params = QueryConversionUtility.doReplaceSpecificGrp(params, "(?<!\\w)position(?!\\w)", "\"", "\"", 0, true).trim();
            int startIdx = 0;
            sb.append(declare.substring(startIdx, tempIdx));
            sb.append(params).append(declare.substring(endIdx));
        }
        declare = sb.toString();
        return declare;
    }

    public static String commentNocopy(String declareQry) {
        String declare = declareQry;
        StringBuffer sb = new StringBuffer();
        int tempIdx = 0;
        int endIdx = 0;
        Matcher getParemsMatcher = PROC_FUNC_PAT.matcher(declare);
        String params = null;
        if (getParemsMatcher.find()) {
            params = getParemsMatcher.group(1);
            tempIdx = getParemsMatcher.start(1);
            endIdx = getParemsMatcher.end(1);
            if (QueryConversionUtility.containsCheck(params, "nocopy")) {
                params = QueryConversionUtility.doReplaceSpecificGrp(params, "(?<!\\w)nocopy(?!\\w)", "/*", "*/", 0, true);
            }
            int startIdx = 0;
            sb.append(declare.substring(startIdx, tempIdx));
            sb.append(params).append(declare.substring(endIdx));
        }
        declare = sb.toString();
        return declare;
    }

    public static String changePlsIntegerToInteger(String declareQry) {
        String declare = declareQry;
        if (QueryConversionUtility.containsCheck(declare, "PLS_INTEGER")) {
            declare = declare.replaceAll("(?i)\\sPLS_INTEGER\\s*", " INTEGER ");
        }
        return declare;
    }

    public static String synonymPackage(String outputQry, Map<String, String> createTypesDDL) {
        String output = outputQry;
        Matcher matcherFrom = SELECT_FROM_PAT.matcher(output);
        String selFrom = null;
        while (matcherFrom.find()) {
            selFrom = matcherFrom.group();
            Matcher match = PCKG_PAT.matcher(selFrom);
            if (!match.find()) continue;
            String key = match.group(1);
            output = OracleQueryKeywordReplacer.doRplSynWithTable(output, createTypesDDL, key);
        }
        return output;
    }

    public static String doRplSynWithTable(String outputQry, Map<String, String> createTypesDDL, String key) {
        String output = outputQry;
        String synonym = QueryConversionUtility.toUpper(key) + "_SYNONYM";
        String value = createTypesDDL.get(synonym);
        if (value != null) {
            output = QueryConversionUtility.replaceAll(output, "(?<!\\w)" + key + "(?!\\w)", value);
        }
        return output;
    }

    public static String replaceAssignmentWithInsert(String beginQry, String table) {
        String begin = beginQry;
        Pattern patternFetchAssignment = Pattern.compile("(?i)((?<!\\w)" + table + "\\s*\\(\\s*(\\w+)\\s*\\)\\s*\\.(\\w+)\\s*:=(.+?);)");
        Matcher assignmentMatcher = patternFetchAssignment.matcher(begin);
        HashMap<String, LinkedHashMap<String, String>> assignmentMap = new HashMap<String, LinkedHashMap<String, String>>(10);
        String typeIdxCol = null;
        LinkedHashMap<String, String> colMap = null;
        while (assignmentMatcher.find()) {
            typeIdxCol = assignmentMatcher.group(2).trim();
            String colName = assignmentMatcher.group(3).trim();
            String colValue = assignmentMatcher.group(4).trim();
            colMap = (LinkedHashMap<String, String>)assignmentMap.get(typeIdxCol);
            if (colMap == null) {
                colMap = new LinkedHashMap<String, String>(10);
                assignmentMap.put(typeIdxCol, colMap);
            }
            colMap.put(colName, colValue);
        }
        assignmentMatcher = patternFetchAssignment.matcher(begin);
        HashSet<String> processed = new HashSet<String>(10);
        while (assignmentMatcher.find()) {
            typeIdxCol = assignmentMatcher.group(2).trim();
            int index = assignmentMatcher.start();
            if (!processed.contains(typeIdxCol)) {
                colMap = (Map)assignmentMap.get(typeIdxCol);
                String insertQuery = OracleQueryKeywordReplacer.formUDTInsertQuery(table, typeIdxCol, colMap);
                begin = begin.substring(0, index) + insertQuery + begin.substring(index);
                processed.add(typeIdxCol);
            } else {
                begin = begin.replace(assignmentMatcher.group(1), "");
            }
            assignmentMatcher = patternFetchAssignment.matcher(begin);
        }
        return begin;
    }

    static String formUDTInsertQuery(String table, String typeIdxCol, Map<String, String> colMap) {
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ").append(" ").append(table).append(" ").append("(");
        for (Map.Entry<String, String> col : colMap.entrySet()) {
            String colName = col.getKey();
            sb.append(colName);
            sb.append(",");
            sb.append(" ");
        }
        sb.append("typ_idx_col").append(")").append(" ").append("values").append(" ").append("(");
        for (Map.Entry<String, String> col : colMap.entrySet()) {
            String colValue = col.getValue();
            sb.append(colValue);
            sb.append(",");
            sb.append(" ");
        }
        sb.append(typeIdxCol).append(")").append(";");
        return sb.toString();
    }

    public static String removeSys(String beginQry) {
        String begin = beginQry;
        Matcher sysDbmsMatch = SYS_DBMS_PAT.matcher(begin);
        String sysDbms = null;
        if (sysDbmsMatch.find()) {
            sysDbms = sysDbmsMatch.group(1);
            begin = begin.replace(sysDbms, "dbms_job");
        }
        return begin;
    }

    public static String doputQuotesforGuassKeywords(String declare) {
        String output = declare;
        String outputLowr = QueryConversionUtility.toLower(output);
        if (outputLowr.contains(" is ") || outputLowr.contains(" as ")) {
            String[] arr = output.split("(?i)(?<!\\w)(is|as)(?!\\w)(?![^\\/*]*\\*\\/)");
            if (arr.length < 2) {
                return output;
            }
            String varibles = arr[1];
            String[] varLst = varibles.split(";(?![^\\/*]*\\*\\/)");
            String typeStr = null;
            String typeStrBtw = "";
            for (String var : varLst) {
                String dataType;
                if (var.trim().isEmpty() || var.startsWith("/*") || var.startsWith("*/") || !(var = var.replaceAll("(?i)#S#\\d+#E#", "").trim()).contains(" ") || (dataType = var.substring(var.lastIndexOf(32)).trim()).isEmpty() || !dataType.contains("%")) continue;
                String typeStrBfrPercent = dataType.substring(0, dataType.indexOf("%"));
                String typeStrAftrPercent = dataType.substring(dataType.indexOf("%"));
                typeStr = OracleQueryKeywordReplacer.getTypeStr(typeStr, typeStrBfrPercent);
                typeStrBtw = OracleQueryKeywordReplacer.getTypeStrBtw(typeStrBtw, typeStrBfrPercent);
                output = OracleQueryKeywordReplacer.getOutputStr(output, typeStr, typeStrBtw, dataType, typeStrAftrPercent);
            }
        }
        return output;
    }

    private static String getTypeStrBtw(String typeString, String typeStrBfrPercent) {
        String typeStrBtw = typeString;
        if (typeStrBfrPercent.contains(".")) {
            typeStrBtw = typeStrBfrPercent.substring(0, typeStrBfrPercent.indexOf(46) + 1).trim();
        }
        return typeStrBtw;
    }

    private static String getTypeStr(String typeString, String typeStrBfrPercent) {
        String typeStr = typeString;
        if (typeStrBfrPercent.contains(".")) {
            typeStr = typeStrBfrPercent.substring(typeStrBfrPercent.indexOf(46) + 1).trim();
        }
        return typeStr;
    }

    private static String getOutputStr(String outputQry, String typeStr, String typeStrBtw, String dataType, String typeStrAftrPercent) {
        String output = outputQry;
        if (typeStr != null && typeStr.matches("(?i)(?<!\\w)(type|minvalue|maxvalue|begin|end|function|offset)(?!\\w)")) {
            String varLowr = QueryConversionUtility.toLower(typeStr).trim();
            varLowr = "\"" + varLowr + "\"";
            String varRpl = typeStrBtw + varLowr + typeStrAftrPercent;
            String varReplacement = dataType.replace(dataType, varRpl);
            output = output.replace(dataType, varReplacement);
        }
        return output;
    }

    public static String doReplaceSystemUnsupportedParameter(String input, String originalInput) {
        String replaceString;
        String output = input;
        String fileName = "";
        fileName = !QueryConversionUtility.isGaus100() ? "features-oracle.properties" : "features-oracle-gaussdbt.properties";
        LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
        if (QueryConversionUtility.containsCheck(output = QueryConversionUtility.getSingleDoubleQuoteMap(output, quoteMap), "MDSYS.MBRCOORDLIST")) {
            if (!"None".equalsIgnoreCase(FeatureLoader.getStringProperty("MDSYS.MBRCOORDLIST"))) {
                replaceString = FeatureLoader.getStringProperty("MDSYS.MBRCOORDLIST");
                output = output.replaceAll("(?i)(?<!\\w)(MDSYS.MBRCOORDLIST)(?!\\w)", replaceString);
            } else {
                output = originalInput;
                throw new MigrationServiceException("[DSC_ERR_002_001] " + MessageLoader.getMessage("DSC_ERR_002_001") + ":" + fileName + ".");
            }
        }
        if (QueryConversionUtility.containsCheck(output, "MDSYS.SDO_GEOMETRY")) {
            if (!"None".equalsIgnoreCase(FeatureLoader.getStringProperty("MDSYS.SDO_GEOMETRY"))) {
                replaceString = FeatureLoader.getStringProperty("MDSYS.SDO_GEOMETRY");
                output = output.replaceAll("(?i)(?<!\\w)(MDSYS.SDO_GEOMETRY)(?!\\w)", replaceString);
            } else {
                output = originalInput;
                throw new MigrationServiceException("[DSC_ERR_002_002] " + MessageLoader.getMessage("DSC_ERR_002_002") + fileName + ".");
            }
        }
        if (QueryConversionUtility.containsCheck(output, "GEOMETRY")) {
            output = OracleQueryKeywordReplacer.checkGeometryType(output, fileName);
        }
        output = QueryConversionUtility.getRplFromMap(output, quoteMap, "(##QUOTE##\\d+#)");
        quoteMap.clear();
        return output;
    }

    private static String checkGeometryType(String input, String fileName) {
        String output = input;
        Matcher matcher = GEOMETRY_PAT.matcher(output);
        int startIdx = 0;
        int tempIdx = 0;
        int endIdx = 0;
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String geometry = matcher.group(1);
            if (geometry != null) continue;
            if (!"None".equalsIgnoreCase(FeatureLoader.getStringProperty("GEOMETRY"))) {
                tempIdx = matcher.start();
                endIdx = matcher.end();
                sb.append(output.substring(startIdx, tempIdx));
                String replaceString = FeatureLoader.getStringProperty("GEOMETRY");
                String matcherString = matcher.group();
                matcherString = matcherString.replace(matcherString, replaceString);
                sb.append(matcherString);
                startIdx = endIdx;
                continue;
            }
            throw new MigrationServiceException("[DSC_ERR_002_003] " + MessageLoader.getMessage("DSC_ERR_002_003") + fileName + ".");
        }
        sb.append(output.substring(endIdx));
        output = sb.toString();
        return output;
    }

    public static String doReplacePromptKeywordToEcho(String input) {
        String output = input.trim();
        int startIndex = 0;
        int endIndex = 0;
        String keyword = null;
        if (output.startsWith("#S#")) {
            startIndex = QueryConversionUtility.getIndex(output, "#E#", 0) + 3;
        }
        if ((endIndex = output.indexOf(32)) != -1) {
            keyword = output.substring(startIndex, endIndex);
        }
        if (keyword != null && keyword.isEmpty() && (endIndex = QueryConversionUtility.getIndex(output, " ", ++startIndex)) != -1) {
            keyword = output.substring(startIndex, endIndex);
        }
        if ("prompt".equals(QueryConversionUtility.toLower(keyword))) {
            StringBuffer strbuf = new StringBuffer(output);
            strbuf.replace(startIndex, endIndex, "\\echo");
            output = strbuf.toString();
        }
        return output;
    }
}

