/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.oracle;

import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.oracle.OracleMapHelperExt;
import com.huawei.db.migration.oracle.OracleUtility;
import com.huawei.db.migration.services.OracleMigrationService;
import com.huawei.db.migration.util.ColumnSplitter;
import com.huawei.db.migration.util.DBPropertyLoader;
import com.huawei.db.migration.util.FeatureLoader;
import com.huawei.db.migration.util.FeatureLoaderExtended;
import com.huawei.db.migration.util.InterruptCharSequence;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.QueryConversionUtility;
import com.huawei.db.migration.util.QueryUtilityExt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OracleQueryKeywordReplacerExt {
    private static final Logger logger = LogManager.getLogger(OracleQueryKeywordReplacerExt.class);
    private static final Pattern ROW_NUM_VAL_PAT = Pattern.compile("(?i)(.*?)(union|minus.*)");
    private static final Pattern VALUES_PAT = Pattern.compile("(?i)(\\w+)\\s+values\\s*(\\(.*?\\))");
    private static final Pattern PATTERN_SPC_OPTR = Pattern.compile("(\\s*)((?:<|>|!|:)\\s*=|<\\s*>)");
    private static final Pattern CONSTANT_DEFAULT_PAT = Pattern.compile("(?i)(.*?)(\\w+)\\s+(constant\\s+)?(.*?)((?::=\\s*|default\\s+)(.*)|;)");
    private static final Pattern TBL_PAT = Pattern.compile("(?i)((?<!\\*)(\\w+)\\s+(\\w+\\.?\\w*).*?)");
    private static final Pattern VARRAY_TYPES_PAT = Pattern.compile("(?i)(.*?)((?<!\\*)(\\w+)\\s+(\\w+\\.?\\w*).*?)");
    private static final Pattern BYTE_PAT = Pattern.compile("(?i)(?:\\(\\s*\\d+\\s+(byte)\\s*\\))");
    private static final Pattern SYS_GUID_PAT = Pattern.compile("(?i).*?((?<!\\w)sys_guid\\s*\\(.*?\\s*\\)).*?;");
    private static final Pattern CHARACTER_PAT = Pattern.compile("(?i)((?<!\\w)(?:VARCHAR2?|CHAR)(?!\\w)\\s*\\(\\s*(?:\\d+)\\s+)CHAR\\s*\\)");
    private static final Pattern SELECT_UNIQUE_PAT = Pattern.compile("(?i)(?<!\\w)select(?!\\w)\\s+(?<!\\w)(unique)(?!\\w)");
    private static final Pattern ASC_IN_NLSSORT_PAT = Pattern.compile("(?i).*?nlssort\\s*\\(.*?\\)\\s*(asc)");
    private static final Pattern TO_DATE_PAT = Pattern.compile("(?i)\\b(?!TO_DATE\\b)(?:\\w+)\\s*\\(.*?\\)");
    private static ThreadLocal<String> valueLocal = new ThreadLocal();
    private static String symbol = "";
    private static String rownumStatement = "";
    private static List<String> varrayVars;

    public static String doReplaceStragg(String input) {
        String outputQry = input;
        Pattern pattern = Pattern.compile("(?i)(?<!\\w)(stragg\\s*\\(|wm_concat\\s*\\()");
        Matcher matcher = pattern.matcher(outputQry);
        String rqdStr = null;
        String functionNme = null;
        while (matcher.find()) {
            String funcStr;
            String funcString = funcStr = QueryConversionUtility.doGetReplaceString(outputQry.substring(outputQry.indexOf(matcher.group(1))));
            rqdStr = outputQry.substring(outputQry.indexOf(funcStr));
            rqdStr = rqdStr.substring(funcString.length());
            if (QueryConversionUtility.containsCheck(funcStr, "stragg")) {
                functionNme = "stragg";
            } else if (QueryConversionUtility.containsCheck(funcStr, "wm_concat")) {
                functionNme = "wm_concat";
            }
            funcStr = funcStr.replaceAll("(?i)" + functionNme, "STRING_AGG");
            StringBuffer sbuf = new StringBuffer();
            sbuf.append(outputQry.substring(0, outputQry.indexOf(funcString))).append(funcStr.substring(0, funcStr.length() - 1)).append(",").append("'").append(",").append("'").append(")").append(rqdStr);
            outputQry = sbuf.toString();
            sbuf.setLength(0);
        }
        return outputQry;
    }

    public static String doReplaceListagg(String inputQry) {
        String inputSql = inputQry;
        StringBuffer qryBuf = null;
        Pattern pattern = Pattern.compile("(?i)(?<!\\w)listagg(?:(?!\\blistagg\\b).)*?within\\s+group|(?<!\\w)listagg\\s*\\((.*?)\\s*");
        Matcher matcher = pattern.matcher(inputSql);
        String neededStr = null;
        while (matcher.find()) {
            String funcStr;
            String inputSqlLower = QueryConversionUtility.toLower(inputSql);
            String listStr = matcher.group(0);
            String functionStr = funcStr = QueryConversionUtility.doGetReplaceString(inputSql.substring(inputSql.indexOf(listStr)));
            int idx = inputSql.indexOf(funcStr);
            funcStr = OracleQueryKeywordReplacerExt.getQryBuff(funcStr);
            funcStr = funcStr.replaceAll("(?i)(?<!\\w)listagg(?!\\w)", "STRING_AGG");
            if (QueryConversionUtility.containsCheck(listStr, "within")) {
                inputSql = OracleQueryKeywordReplacerExt.getQryWithin(inputSql, inputSqlLower, funcStr, idx);
                continue;
            }
            qryBuf = new StringBuffer();
            int funIndex = inputSql.indexOf(functionStr);
            if (funIndex == -1) continue;
            neededStr = inputSql.substring(funIndex);
            neededStr = neededStr.substring(neededStr.indexOf(41) + 1);
            qryBuf = qryBuf.append(inputSql.substring(0, idx)).append(funcStr).append(neededStr);
            inputSql = qryBuf.toString();
        }
        return inputSql;
    }

    private static String getQryWithin(String input, String inputSqlLower, String funcStr, int idx) {
        String inputSql = input;
        int withIndex = inputSqlLower.indexOf("within");
        String subStr = "";
        String orderStr = "";
        if (withIndex != -1) {
            subStr = QueryConversionUtility.doGetReplaceString(inputSql.substring(withIndex));
            withIndex += subStr.length();
            orderStr = subStr.substring(subStr.indexOf(40) + 1, subStr.length() - 1);
        }
        StringBuffer qryBuf = new StringBuffer();
        int overIndex = -1;
        if (inputSqlLower.contains("partition") && (overIndex = inputSqlLower.indexOf("over")) - withIndex < 2) {
            String partitionStr = QueryConversionUtility.doGetReplaceString(inputSql.substring(overIndex));
            String neededStr = inputSql.substring(inputSql.indexOf(partitionStr));
            neededStr = neededStr.substring(neededStr.indexOf(41) + 1);
            qryBuf = qryBuf.append(inputSql.substring(0, idx)).append(funcStr).append(partitionStr.substring(0, partitionStr.length() - 1)).append(" ").append(orderStr).append(")").append(neededStr);
            inputSql = qryBuf.toString();
        } else {
            int subIndex = inputSql.indexOf(subStr);
            if (subIndex != -1) {
                String neededStr = inputSql.substring(subIndex);
                neededStr = neededStr.substring(neededStr.indexOf(41) + 1);
                qryBuf = qryBuf.append(inputSql.substring(0, idx)).append(funcStr.substring(0, funcStr.length() - 1)).append(orderStr).append(")").append(neededStr);
                inputSql = qryBuf.toString();
            }
        }
        return inputSql;
    }

    private static String getQryBuff(String funcStr) {
        if (!funcStr.contains("'")) {
            StringBuffer qryBuf = new StringBuffer(funcStr);
            qryBuf = qryBuf.insert(funcStr.indexOf(41), ",''");
            funcStr = qryBuf.toString();
        }
        return funcStr;
    }

    public static String doRplBracesFrmTable(String input) {
        String funcStr;
        String inputQry = input;
        Pattern pattern = Pattern.compile("(?i)((?<!\\w)from\\s*\\((?!\\s*select|\\s*#))");
        Matcher matcher = pattern.matcher(inputQry);
        if (matcher.find() && !(funcStr = QueryConversionUtility.doGetReplaceString(inputQry.substring(inputQry.indexOf(matcher.group(1))))).isEmpty()) {
            String funcRpl = "from " + QueryConversionUtility.removeParenthesis(funcStr);
            inputQry = inputQry.replace(funcStr, funcRpl);
        }
        return inputQry;
    }

    public static String doReplaceRownumFn(String inputQry) throws MigrationServiceException {
        StringBuffer sb = new StringBuffer();
        String replacedInput = inputQry;
        String startQry = "";
        Pattern pattern = Pattern.compile("(?i)((?<!\\w)select\\s+(.*?)(?<!\\w)from(?!\\w)(.*?)where\\s(.*?)?(?<!\\w)((?:\\w*\\()?\\s*rownum\\s*\\)?\\s*((=|<=|>=|<|>)\\s*(.*?)|between(.*?)and(.*?)))(and.*|group\\s+(?:#s#\\d+#e#\\s*)?by\\s+.*|having\\s+(?:#s#\\d+#e#\\s*)?by\\s+.*|order\\s+(?:#s#\\d+#e#\\s*)?by\\s+.*|$|;|\\s*union\\s*all\\s*.*?|minus.*?))");
        Matcher matcher = pattern.matcher(replacedInput);
        int index = 0;
        startQry = OracleQueryKeywordReplacerExt.getOutQry(replacedInput, startQry);
        while (matcher.find()) {
            String btnlwr;
            valueLocal.set(matcher.group(8));
            symbol = "";
            String btnhgr = null;
            String endQry = "";
            ++index;
            if (QueryConversionUtility.containsCheck(valueLocal.get(), "FOR UPDATE")) {
                throw new MigrationServiceException("[DSC_ERR_002_004] " + MessageLoader.getMessage("DSC_ERR_002_004"));
            }
            if (valueLocal.get() != null) {
                symbol = matcher.group(7).trim();
                valueLocal.set(valueLocal.get().trim());
                Matcher rownumValMatcher = ROW_NUM_VAL_PAT.matcher(valueLocal.get());
                if (rownumValMatcher.find()) {
                    valueLocal.set(rownumValMatcher.group(1).trim());
                    endQry = rownumValMatcher.group(2);
                }
            }
            if ((btnlwr = matcher.group(9)) != null) {
                btnlwr = btnlwr.trim();
                btnhgr = matcher.group(10).trim();
            }
            endQry = endQry + matcher.group(11).trim();
            if (btnlwr != null && btnhgr != null) {
                int hgr = Integer.parseInt(btnhgr);
                int lwr = Integer.parseInt(btnlwr);
                if (lwr == 0 && hgr > 0) {
                    symbol = "<=";
                    valueLocal.set(btnhgr);
                } else if (lwr != 0) {
                    symbol = ">";
                    valueLocal.set(btnhgr);
                }
            }
            replacedInput = OracleQueryKeywordReplacerExt.getReplacedInput(startQry, matcher, index, valueLocal.get(), endQry);
            sb.append(replacedInput);
        }
        replacedInput = OracleQueryKeywordReplacerExt.getOutput(sb, replacedInput);
        return replacedInput;
    }

    private static String getOutput(StringBuffer sb, String input) {
        String replacedInput = input;
        if (!QueryConversionUtility.equalCheck(sb.toString(), "")) {
            replacedInput = sb.toString();
        }
        if (replacedInput.matches("(?i).*(?<!\\w)ROWNUM(?!\\w).*")) {
            replacedInput = OracleQueryKeywordReplacerExt.updOrDelRownum(replacedInput);
        }
        return replacedInput;
    }

    private static String getOutQry(String replacedInput, String input) {
        String startQry = input;
        if (replacedInput.matches("(?i).*select.*")) {
            startQry = replacedInput.substring(0, QueryConversionUtility.getIndex(replacedInput, "select", 0));
        }
        return startQry;
    }

    private static String updOrDelRownum(String replacedInput) {
        String result = replacedInput;
        Pattern updateRownumPat = Pattern.compile("(?i)(.*(?<!\\w)(?:delete|update)\\s+.*?(?<!\\w)(?:from|set)(?!\\w).*?)(where\\s.*?(?<!\\w)(?:\\w*\\()?\\s*rownum\\s*\\)?\\s*(=|<=|>=|<|>)\\s*(\\w+)\\s*(?:and|or)?.*?;)");
        Matcher updateRownumMatcher = updateRownumPat.matcher(result);
        while (updateRownumMatcher.find()) {
            String limitVal = OracleQueryKeywordReplacerExt.doGetLmtVal(updateRownumMatcher.group(3).trim(), updateRownumMatcher.group(4).trim());
            String startQrey = updateRownumMatcher.group(1);
            String endQry = updateRownumMatcher.group(2);
            endQry = QueryConversionUtility.replace(endQry, "(?i)(?:where|and)\\s*ROWNUM(?!\\w)\\s*(=|<=|>=|<|>)\\s*\\w+", "", true);
            if (QueryConversionUtility.toLower((endQry = endQry.substring(0, endQry.indexOf(59)) + " " + limitVal + ";").trim()).startsWith("and") || QueryConversionUtility.toLower(endQry.trim()).startsWith("or")) {
                endQry = endQry.replaceFirst("(?i)(?<!\\w)and(?!\\w)|(?<!\\w)or(?!\\w)", QueryConversionUtility.toUpper("where"));
            }
            result = startQrey + endQry;
        }
        return result;
    }

    private static String getReplacedInput(String startQry, Matcher matcher, int index, String value, String endQry) {
        String cols = matcher.group(2).trim();
        String from = matcher.group(3);
        String whereclause = matcher.group(4).trim();
        rownumStatement = matcher.group(5);
        String replacedInput = OracleQueryKeywordReplacerExt.doGetMigRownum(matcher.group(), cols, from, whereclause, endQry);
        if (index == 1 && !startQry.isEmpty()) {
            replacedInput = startQry + replacedInput;
        }
        return replacedInput;
    }

    private static String doGetMigRownum(String rplInput, String columns, String from, String where, String endQuery) {
        String endQry = endQuery;
        String whereclause = where;
        String cols = columns;
        String replacedInput = rplInput;
        String wherePattern = "(?i)(where\\s+)?";
        String andPattern = "(?i)(and\\s+)?";
        String limitVal = null;
        if (endQry.isEmpty() || endQry.equals(";") || endQry.replace(" ", "").equals(");")) {
            limitVal = OracleQueryKeywordReplacerExt.doGetLmtVal(symbol, valueLocal.get());
            replacedInput = replacedInput.replaceFirst(wherePattern + QueryConversionUtility.santizePattern(rownumStatement), limitVal);
            replacedInput = replacedInput.replaceFirst(andPattern + QueryConversionUtility.santizePattern(limitVal), limitVal);
        } else if (!endQry.isEmpty()) {
            limitVal = OracleQueryKeywordReplacerExt.doGetLmtVal(symbol, valueLocal.get());
            if (cols.equals("*")) {
                cols = "*";
            }
            endQry = endQry.matches("(?i).*\\s*(union|minus)\\s*.*") ? limitVal + " " + endQry + " " : (endQry.contains(";") ? endQry.replace(";", " " + limitVal + ";") : endQry + " " + limitVal);
            replacedInput = !whereclause.isEmpty() ? OracleQueryKeywordReplacerExt.getRplInp(from, endQry, whereclause, cols) : (QueryConversionUtility.toLower(endQry.trim()).startsWith("and") || QueryConversionUtility.toLower(endQry.trim()).startsWith("or") ? OracleQueryKeywordReplacerExt.getQry(from, endQry, cols) : "select " + cols + " " + "from" + from + " " + endQry);
        }
        return replacedInput;
    }

    private static String getQry(String from, String endQry, String cols) {
        String replacedInput = "select " + cols + " " + "from" + from + " " + endQry.replaceFirst("(?i)(?<!\\w)and(?!\\w)|(?<!\\w)or(?!\\w)", QueryConversionUtility.toUpper("where"));
        return replacedInput;
    }

    private static String getRplInp(String from, String endQry, String input, String cols) {
        String whereclause = input;
        int whereIndex = whereclause.lastIndexOf(32);
        if (whereIndex != -1) {
            whereclause = whereclause.substring(0, whereIndex);
        }
        String replacedInput = "select " + cols + " " + "from" + from + " where " + whereclause + " " + " " + endQry;
        return replacedInput;
    }

    public static String doReplaceColRownumFn(String inputQry) {
        String replacedInput = inputQry;
        Pattern pattern = Pattern.compile("(?i)(.*)(?<!\\w)select\\s+(.*)(?<!\\w)from(?!\\w)(.*)");
        Matcher matcher = pattern.matcher(inputQry);
        String cols = "";
        if (matcher.find()) {
            cols = matcher.group(2);
        }
        List<String> colList = null;
        String columns = null;
        if (QueryConversionUtility.containsCheck(cols, "rownum")) {
            ColumnSplitter splitter = new ColumnSplitter();
            colList = splitter.doGetAllColumns(cols);
            int colSize = colList.size();
            for (int iIndex = 0; iIndex < colSize; ++iIndex) {
                String col = colList.get(iIndex);
                if (!(col = col.replaceAll("(?i)#S#\\d+#E#", "").trim()).matches("(?i).*(?<!\\w)ROWNUM(?!\\w).*")) continue;
                if (col.equalsIgnoreCase("rownum")) {
                    col = "ROW_NUMBER() OVER () AS ROWNUM";
                    colList.set(iIndex, col);
                    continue;
                }
                if (!QueryConversionUtility.containsCheck(col, "rownum")) continue;
                col = col.replaceAll("(?i)rownum(?!\\w)", "ROW_NUMBER() OVER ()");
                colList.set(iIndex, col);
            }
            columns = QueryConversionUtility.doGetStrFrmListWithComma(colList) + " ";
            replacedInput = replacedInput.replace(cols, columns);
        }
        return replacedInput;
    }

    private static String doGetLmtVal(String symbol, String val) {
        valueLocal.set(val);
        String limitVal = null;
        valueLocal.set(QueryConversionUtility.canonicalizeString(valueLocal.get()));
        if ("<=".equals(symbol)) {
            limitVal = "limit " + valueLocal.get();
        } else if ("<".equals(symbol)) {
            limitVal = "limit " + valueLocal.get() + "-" + 1;
        } else if (">=".equals(symbol) && "1".equals(valueLocal.get())) {
            limitVal = "";
        } else if ("=".equals(symbol) && "1".equals(valueLocal.get())) {
            limitVal = "limit 1";
        } else if ("=".equals(symbol) && valueLocal.get().contains("'")) {
            limitVal = "limit " + valueLocal.get();
        } else if (">=".equals(symbol)) {
            limitVal = "limit 0";
        } else if (">".equals(symbol)) {
            limitVal = "limit 0";
        }
        return limitVal;
    }

    public static String doReplaceNVLFn(String inputQuery) {
        String inputQry = inputQuery;
        LinkedHashMap<String, String> commentMap = new LinkedHashMap<String, String>(10);
        String replacedInput = inputQry = QueryConversionUtility.getSingleOrDoubleQuoteMap(inputQry, commentMap, "'", "'.*?'", "~VLNCMT~");
        Pattern pattern = Pattern.compile("(?i)(?<!\\w)NVL2\\s*\\(");
        Matcher matcher = pattern.matcher(inputQry);
        String subString = null;
        String nvlFnStr = null;
        List<String> nvlColParams = null;
        ColumnSplitter splitter = new ColumnSplitter();
        while (matcher.find()) {
            subString = inputQry.substring(matcher.start());
            nvlFnStr = QueryConversionUtility.doGetReplaceString(subString);
            nvlColParams = splitter.doGetAllColumns(nvlFnStr.substring(nvlFnStr.indexOf(40) + 1, nvlFnStr.lastIndexOf(41)));
            if (nvlColParams.size() <= 2) continue;
            String replacementStr = DBPropertyLoader.getStringProperty("NVL2Replace") + nvlColParams.get(0) + "," + "null" + "," + nvlColParams.get(2) + "," + nvlColParams.get(1) + ")";
            replacedInput = replacedInput.replace(nvlFnStr, replacementStr);
        }
        replacedInput = QueryConversionUtility.getRplFromMap(replacedInput, commentMap, "(~VLNCMT~\\d+#)");
        return replacedInput;
    }

    public static String doPreSchemaKeywordChanges(String inputQry, Set<String> uniqueConsPartition) throws MigrationServiceException {
        String output = inputQry;
        Map<String, String> globalMap = OracleMigrationService.getGlobalTempMap();
        output = QueryConversionUtility.doRplFromMap(output, globalMap);
        output = OracleMapHelperExt.doChangeGlobalTmpTbl(output);
        LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
        output = QueryConversionUtility.getSingleDoubleQuoteMap(output, quoteMap);
        if ((output = OracleQueryKeywordReplacerExt.doMigrateKeywords(uniqueConsPartition, output)).matches("(?i).*?(?<!\\w)alter(?!\\w).*?(?<!\\w)table(?!\\w).*?(?<!\\w)add\\s+partition(?!\\w).*")) {
            output = OracleQueryKeywordReplacerExt.removePartitionInAlter(output);
        }
        LinkedHashMap<String, String> commentMap = new LinkedHashMap<String, String>(10);
        output = OracleQueryKeywordReplacerExt.doCommentStorageParam(output, commentMap);
        if ((output = QueryConversionUtility.getSingleOrDoubleQuoteMap(output, commentMap, "/*", "\\/\\*.*?\\*\\/", "##COMMENT##")).trim().matches("(?i)create\\s+table.*(?<!\\w)(enable)(?!\\w).*?;")) {
            output = OracleQueryKeywordReplacerExt.commentEnableInCreateTable(output);
        }
        if (QueryConversionUtility.containsCheck(output = OracleQueryKeywordReplacerExt.checkAlterModifyEnableComment(output), "PCTUSED")) {
            output = output.replaceAll("(?i)(?<!\\w)(PCTUSED\\s+\\d+)", "/*$1*/");
        }
        if (QueryConversionUtility.containsCheck(output = QueryConversionUtility.getRplFromMap(output, commentMap, "(##COMMENT##\\d+#)"), "RESULT_CACHE")) {
            output = OracleMapHelperExt.doRmvResultCache(output);
        }
        if (output.matches("(?i).*(?<!\\w)REVERSE(?!\\w).*")) {
            String patternString = "(?i)(?<!\\w)REVERSE(?!\\w)";
            output = OracleQueryKeywordReplacerExt.doCommentKeyword(patternString, output);
        }
        output = QueryConversionUtility.getRplFromMap(output, quoteMap, "(##QUOTE##\\d+#)");
        return output;
    }

    private static String doMigrateKeywords(Set<String> uniqueConsPartition, String input) {
        String partitionBy;
        String output = input;
        OracleUtility util = new OracleUtility();
        StringBuffer varrayDecVars = new StringBuffer();
        if (QueryConversionUtility.containsCheck(output, "LONG")) {
            output = util.doMigrateDeclareStmt(output, varrayDecVars);
        }
        if (QueryConversionUtility.containsCheck(output = OracleQueryKeywordReplacerExt.toAddSchemaNameInFunc(output), "Replace")) {
            output = util.doModifyReplaceFunction(output);
        }
        if (QueryConversionUtility.containsCheck(output, "to_clob")) {
            output = util.doReplaceClob(output);
        }
        output = OracleMapHelperExt.doCommentForeignKey(output);
        if (QueryConversionUtility.containsCheck(output = OracleQueryKeywordReplacerExt.doAddQuotesforGaussKeywords(output), "nologging")) {
            output = OracleMapHelperExt.doRplNoLogging(output);
        }
        if (QueryConversionUtility.containsCheck(output, "rowid")) {
            output = output.replaceAll("(?i)(?<!\\w)rowid(?!\\w)", DBPropertyLoader.getStringProperty("rowIdDataType"));
        }
        if (QueryConversionUtility.containsCheck(output, partitionBy = "partition by ") && FeatureLoader.getBooleanProperty("RemovePartitionTS")) {
            output = OracleUtility.doCommentTableSpace(output);
        }
        if (QueryConversionUtility.containsCheck(output, partitionBy)) {
            output = OracleQueryKeywordReplacerExt.callCommentPartition(output, uniqueConsPartition);
        }
        return output;
    }

    private static String checkAlterModifyEnableComment(String input) {
        boolean checkMigrateModify = false;
        String output = input;
        if (QueryConversionUtility.containsCheck(output, "ALTER ".trim()) && QueryConversionUtility.containsCheck(output, "modify") && FeatureLoader.getBooleanProperty("MigSupForAlterTableModify")) {
            checkMigrateModify = true;
        }
        if (output.trim().matches("(?i)alter\\s+table.*(?<!\\w)(enable)(?!\\w|\\s+constraint|\\s+VALIDATE|\\s+NOVALIDATE|\\s+PRIMARY\\s+KEY|\\s+UNIQUE).*?;") && !checkMigrateModify) {
            output = OracleQueryKeywordReplacerExt.commentEnableInAlterTable(output);
        }
        return output;
    }

    private static String doCommentStorageParam(String output, Map<String, String> commentMap) {
        String newOutput = output;
        if (FeatureLoader.getBooleanProperty("commentStorageParameter")) {
            String pattern = "(?i)(?<!\\w)Lob\\s+\\(.*?\\)\\s+STORE";
            newOutput = QueryConversionUtility.doCommentStoreClause(newOutput, pattern);
            newOutput = QueryConversionUtility.getSingleOrDoubleQuoteMap(newOutput, commentMap, "/*", "\\/\\*.*?\\*\\/", "##COMMENT##");
            if ((newOutput = OracleQueryKeywordReplacerExt.doCommentUnsupportedKeywords(newOutput)).matches("(?i).*(?<!\\w)STORAGE\\s*\\(.*")) {
                String patternString = "(?i)(?<!\\w)STORAGE\\s*\\((.*?)\\)";
                newOutput = OracleQueryKeywordReplacerExt.doCommentKeyword(patternString, newOutput);
            }
            newOutput = QueryConversionUtility.getRplFromMap(newOutput, commentMap, "(##COMMENT##\\d+#)");
        }
        return newOutput;
    }

    private static String commentEnableInCreateTable(String outputQry) {
        String output = outputQry;
        if (QueryConversionUtility.containsCheck(output, "enable")) {
            String[] commaSplitArrays;
            StringBuffer sb = new StringBuffer();
            for (String enableQry : commaSplitArrays = QueryConversionUtility.doGetArrSplit(output, ",")) {
                if (!(enableQry = QueryConversionUtility.doReplaceSpecificGrp(enableQry, "(?<!\\w)(enable)(?!\\w)", "/*", "*/", 1, true)).endsWith(";")) {
                    sb.append(enableQry).append(",");
                    continue;
                }
                sb.append(enableQry);
            }
            output = sb.toString();
        }
        return output;
    }

    private static String commentEnableInAlterTable(String outputQry) {
        String output = outputQry;
        Pattern enableAlter = Pattern.compile("(?i)alter\\s+table.*(?<!\\w)(enable)(?!\\w|\\s+constraint|\\s+VALIDATE|\\s+NOVALIDATE|\\s+PRIMARY\\s+KEY|\\s+UNIQUE).*?;");
        Matcher enableAlterMatcher = enableAlter.matcher(output);
        String alterKey = "";
        String rplAlter = "";
        int start = 0;
        int temp = 0;
        int end = 0;
        StringBuffer sb = new StringBuffer();
        while (enableAlterMatcher.find()) {
            alterKey = enableAlterMatcher.group(1);
            rplAlter = "/*" + alterKey + "*/";
            temp = enableAlterMatcher.start(1);
            end = enableAlterMatcher.end(1);
            sb.append(output.substring(start, temp));
            sb.append(rplAlter);
            start = end;
        }
        sb.append(output.substring(end));
        output = sb.toString();
        return output;
    }

    private static String doAddQuotesforGaussKeywords(String input) {
        String output = input;
        Pattern pattern = Pattern.compile("(?i)((.*create\\s+table.*?\\(|.*alter\\s+table.*(?<!\\w)(?:add|modify)\\s*\\())(.*)(\\).*)");
        Matcher matcher = pattern.matcher(output);
        if (matcher.find()) {
            String columns;
            String rplColms = columns = matcher.group(3);
            for (String col : columns.split(",(?![^(]*\\))")) {
                String colPart;
                if (!QueryConversionUtility.containsCheck(col = col.trim(), " ") || !(colPart = col.substring(0, col.indexOf(32))).matches("(?i)(?<!\\w)limit|function|left|right|xmin|xmax|maxvalue(?!\\w)")) continue;
                StringBuffer colBuf = new StringBuffer();
                colBuf.append("\"").append(QueryConversionUtility.toUpper(colPart)).append("\"");
                rplColms = rplColms.replaceFirst(colPart, colBuf.toString());
            }
            output = output.replace(columns, rplColms);
        }
        return output;
    }

    public static String doAddQuotesForGuassKeyowrds(String col) {
        String colm = col;
        StringBuffer colBuf = new StringBuffer();
        if (colm.trim().matches("(?i)(?<!\\w)limit|function|left|right|xmin|xmax|maxvalue(?!\\w)")) {
            colBuf.append("\"").append(colm).append("\"");
            return colBuf.toString();
        }
        return colm;
    }

    private static String callCommentPartition(String outputQry, Set<String> uniqueConsPartition) {
        String output = outputQry;
        Pattern patternTable = Pattern.compile("(?i)(?<!\\w)CREATE(?!\\w).*?(?<!\\w)TABLE(?!\\w).*?(\\w*\\.?\\w+).*?;");
        Matcher matcherTable = patternTable.matcher(outputQry);
        String schemaTableNme = "";
        if (matcherTable.find()) {
            schemaTableNme = QueryConversionUtility.toLower(matcherTable.group(1));
        }
        output = output.replaceAll("\\s*\\(\\s*", "(");
        if (!schemaTableNme.equals("") && uniqueConsPartition != null && QueryConversionUtility.containsCheckCollec(uniqueConsPartition, schemaTableNme) && output.matches("(?i).*(?<!\\w)PARTITION\\s+BY\\s+(?:LIST|HASH|RANGE)(?!\\w).*")) {
            output = "comment_partition".equalsIgnoreCase(FeatureLoader.getStringProperty("uniqueConsForPartitonedTable")) ? QueryConversionUtility.doReplaceSpecificGrp(output, "(?i)(?<!\\w)(partition\\s+by\\s+(?:hash|list|range)\\s*\\(.*?)(as\\s*\\(##QUERY##\\d+#\\)|;|$)", "/*", "*/", 1, true) : OracleUtility.doCommentSubPartClause(output);
        } else if (output.matches("(?i).*(?<!\\w)PARTITION\\s+BY\\s+LIST(?!\\w).*")) {
            output = OracleQueryKeywordReplacerExt.addPartitionToMap(output);
            output = OracleUtility.doCommentPartition(output, "(?i)(?<!\\w)(partition\\s+by\\s+list\\s*\\(.*?)(as\\s*\\(##QUERY##\\d+#\\)|;|$)", "RemoveListPartition");
        } else if (output.matches("(?i).*(?<!\\w)PARTITION\\s+BY\\s+HASH(?!\\w).*")) {
            output = OracleUtility.doCommentPartition(output, "(?i)(?<!\\w)(partition\\s+by\\s+hash\\s*\\(.*?)(as\\s*\\(##QUERY##\\d+#\\)|;|$)", "RemoveHashPartition");
        } else if (output.matches("(?i).*(?<!\\w)PARTITION\\s+BY\\s+RANGE(?!\\w).*")) {
            output = OracleUtility.doCommentSubPartClause(output);
        }
        return output;
    }

    public static String addPartitionToMap(String input) {
        String output = input;
        output = output.replace("partition", "PARTITION");
        Pattern listPart = Pattern.compile("(?i)partition\\s+by\\s+(list)\\s*\\(\\s*(\\w+)\\s*\\)\\s*\\((.*?)\\)\\s*;");
        Matcher listMatch = listPart.matcher(output);
        String partitionType = "";
        String partitionName = "";
        String partitionVal = "";
        if (listMatch.find()) {
            String[] splitPartition;
            String tableName = QueryConversionUtility.getTableName(output).trim();
            partitionType = listMatch.group(1);
            partitionName = listMatch.group(2);
            partitionVal = listMatch.group(3);
            OracleMigrationService.addCreateTypeMap(tableName, partitionType);
            OracleMigrationService.addCreateTypeMap(tableName + "_name", partitionName);
            for (String splitPart : splitPartition = QueryConversionUtility.doGetArrSplit(partitionVal, "PARTITION")) {
                Matcher valMatch = VALUES_PAT.matcher(splitPart);
                if (!valMatch.find()) continue;
                OracleMigrationService.addCreateTypeMap(valMatch.group(1) + "_PARTITION_NAME", valMatch.group(2));
            }
        }
        return output;
    }

    private static String removePartitionInAlter(String outputQry) {
        String output = outputQry;
        output = output.matches("(?i).*?(?<!\\w)add\\s+partition\\s+\\w+\\s+values\\s+less\\s+than(?!\\w).*") && !"false".equalsIgnoreCase(FeatureLoader.getStringProperty("RemoveRangeSubPartition")) ? OracleUtility.doChangeAlterSubpartition(output) : (output.matches("(?i).*?(?<!\\w)add\\s+partition\\s+\\w+\\s+values(?!\\w).*") ? OracleUtility.doCmntAlterTblPartition(output, "RemoveListPartition") : OracleUtility.doCmntAlterTblPartition(output, "RemoveHashPartition"));
        return output;
    }

    protected static String doHandleUnsupportedException(String input) {
        String output = input;
        Pattern pattern = Pattern.compile("(?i)EXCEPTION\\s*(?:\\s*#S#\\d+#E#)?\\s*WHEN.*?;(\\s*#S#\\d+#E#)?(?=\\s*END\\s*;)");
        Matcher matcher = pattern.matcher(input);
        StringBuffer sb = new StringBuffer();
        int tempIndex = 0;
        while (matcher.find()) {
            String outGrp = matcher.group();
            int startIndex = matcher.start();
            sb.append(output.substring(tempIndex, startIndex));
            outGrp = QueryConversionUtility.doReplaceUnsupportedException(outGrp);
            outGrp = QueryConversionUtility.doHandleDupValOnIndex(outGrp, "(?i)WHEN\\s+DUP_VAL_ON_INDEX\\s+THEN(.*?;\\s*)(\\s*#S#\\d+#E#)?(?=\\s*(WHEN|$))", " sqlstate = 23505 ");
            sb.append(outGrp);
            tempIndex = matcher.end();
        }
        String endStr = output.substring(tempIndex);
        sb.append(endStr);
        return sb.toString();
    }

    private static String doRmvSpcBtnRelationalOptr(String input) {
        String output = input;
        Matcher matcher = PATTERN_SPC_OPTR.matcher(input);
        String optr = null;
        String rpl = null;
        while (matcher.find()) {
            String space = matcher.group(1);
            optr = matcher.group(2);
            rpl = optr.replaceAll("\\s*", "");
            if (space.isEmpty()) {
                rpl = " " + rpl;
            }
            output = output.replaceAll(optr, rpl);
        }
        return output;
    }

    protected static String doUDTCount(String inputBegin, String typeVar) {
        String begin = inputBegin;
        Pattern patternCnt = Pattern.compile("(?i)(" + typeVar + "\\.count(?!\\w))");
        Matcher matcherCnt = patternCnt.matcher(begin);
        while (matcherCnt.find()) {
            begin = begin.replace(matcherCnt.group(1), "(SELECT COUNT(*) FROM " + typeVar + ")");
        }
        return begin;
    }

    protected static String doCommentDeclareTypes(Map<String, String> declareTypes, String declare, Map<String, String> createTypesDBMap, String header, Map<String, String> recordTypes) {
        String declareOp;
        String varrayDeclare = declareOp = declare;
        String headerOp = header;
        List<String> colList = Arrays.asList(declareOp.split(";"));
        Pattern patternType = Pattern.compile("(?i)((?<!\\w)type\\s+(\\w+)\\s+(?:is|as)\\s+table\\s+of\\s+(\\w+(?:\\(.*?\\))?)(.*?);)");
        Matcher matcherType = patternType.matcher(declareOp);
        ArrayList<String> typesLst = new ArrayList<String>(10);
        String plsqlCollection = FeatureLoader.getStringProperty("plsqlCollection");
        if (QueryConversionUtility.equalCheck(plsqlCollection, "localtable")) {
            declareOp = OracleQueryKeywordReplacerExt.doRecordTypeMigration(declareTypes, declareOp, typesLst, recordTypes);
        }
        while (matcherType.find()) {
            String typeCreate = matcherType.group(1);
            String ddlTbl = matcherType.group(2);
            String dmlTbl = matcherType.group(3);
            String supportUDT = matcherType.group(4);
            if (QueryConversionUtility.equalCheck(plsqlCollection, "localtable")) {
                declareOp = declareOp.replace(typeCreate, "/*" + typeCreate + "*/");
                if (supportUDT != null) {
                    dmlTbl = OracleQueryKeywordReplacerExt.getDMLTbl(dmlTbl, supportUDT);
                }
            } else if (QueryConversionUtility.equalCheck(plsqlCollection, "VARRAY")) {
                if (QueryConversionUtility.containsCheck(declareOp, "binary_integer")) {
                    varrayDeclare = OracleQueryKeywordReplacerExt.getDecVarray(varrayDeclare, typeCreate, dmlTbl);
                } else {
                    declareOp = OracleQueryKeywordReplacerExt.getDecOper(declareOp, typeCreate);
                }
            }
            typesLst.add(typeCreate);
            ddlTbl = QueryConversionUtility.toUpper(ddlTbl);
            OracleQueryKeywordReplacerExt.addTblToMap(declareTypes, createTypesDBMap, ddlTbl, dmlTbl);
        }
        declareOp = OracleQueryKeywordReplacerExt.checkVarray(declareOp, varrayDeclare, plsqlCollection);
        declareOp = OracleQueryKeywordReplacerExt.handleCommentDeclareTypesSub(declareTypes, createTypesDBMap, declareOp, headerOp, colList);
        return declareOp;
    }

    private static String checkVarray(String input, String varrayDeclare, String plsqlCollection) {
        String declareOp = input;
        if (QueryConversionUtility.equalCheck(plsqlCollection, "VARRAY")) {
            declareOp = varrayDeclare;
        }
        return declareOp;
    }

    private static void addTblToMap(Map<String, String> declareTypes, Map<String, String> createTypesDBMap, String table, String dmlTbl) {
        String ddlTbl = table;
        ddlTbl = ddlTbl.contains("\"") ? ddlTbl.replace("\"", "") : ddlTbl;
        declareTypes.put("MIG_" + ddlTbl, dmlTbl);
        createTypesDBMap.put(ddlTbl, "typ_col");
    }

    private static String getDecVarray(String input, String typeCreate, String dmlTbl) {
        String varrayDeclare = input;
        if (dmlTbl != null) {
            varrayDeclare = OracleQueryKeywordReplacerExt.getVarrayDeclare(varrayDeclare, typeCreate, dmlTbl);
        }
        return varrayDeclare;
    }

    private static String getDecOper(String input, String typeCreate) {
        String declareOp = input;
        if (!declareOp.matches("(?i).*(?<!\\w)RECORD(?!\\w).*")) {
            declareOp = declareOp.replace(typeCreate, "/*" + typeCreate + "*/");
        }
        return declareOp;
    }

    private static String getDMLTbl(String table, String supportUDT) {
        String dmlTbl = table;
        if ((supportUDT = supportUDT.replaceAll("(?i)(?<!\\w)index(?!\\w).*", "").trim()).isEmpty()) {
            dmlTbl = dmlTbl + "~#~";
        } else if (supportUDT.charAt(0) == '.' && supportUDT.contains("%")) {
            dmlTbl = dmlTbl + "~#~" + supportUDT.substring(1, supportUDT.indexOf(37));
        } else if (supportUDT.charAt(0) != '%') {
            dmlTbl = dmlTbl + supportUDT + "~#~";
        }
        return dmlTbl;
    }

    private static String getVarrayDeclare(String declare, String typeCreate, String dmlTbl) {
        String varrayDeclare = declare;
        OracleUtility oracleUtil = new OracleUtility();
        String varraySize = oracleUtil.doGetVarraySize(dmlTbl);
        String typeCreateRpl = typeCreate.replaceFirst("(?i)\\s+table\\s+", " VARRAY(" + varraySize + ")" + " ");
        typeCreateRpl = typeCreateRpl.replaceFirst("(?i)index\\s+by\\s+binary_integer", "");
        varrayDeclare = varrayDeclare.replace(typeCreate, typeCreateRpl);
        return varrayDeclare;
    }

    private static String handleCommentDeclareTypesSub(Map<String, String> declareTypes, Map<String, String> createTypesDBMap, String declareQry, String headerQry, List<String> colList) {
        String headerOp = headerQry;
        String declareOp = declareQry;
        String declareOpUpr = null;
        String typeValue = "";
        HashSet<String> typeItr = new HashSet<String>(createTypesDBMap.keySet());
        for (String type : typeItr) {
            typeValue = createTypesDBMap.get(type);
            type = type.trim();
            declareOpUpr = QueryConversionUtility.toUpper(declareOp);
            if (QueryConversionUtility.equalCheck(FeatureLoader.getStringProperty("plsqlCollection"), "none")) continue;
            if (QueryConversionUtility.equalCheck(FeatureLoader.getStringProperty("plsqlCollection"), "localtable")) {
                if (!declareOpUpr.contains(type)) continue;
                for (String column : colList) {
                    declareOp = OracleQueryKeywordReplacerExt.commentTypeInCol(declareTypes, declareOp, type, column);
                    headerOp = OracleQueryKeywordReplacerExt.retTypeInHeader(headerOp, type);
                }
                continue;
            }
            if (!QueryConversionUtility.toUpper(type.trim()).endsWith("_VARRAY")) continue;
            type = type.substring(0, type.length() - 7);
            varrayVars = new ArrayList<String>(10);
            if (declareOpUpr.contains(type)) {
                for (String column : colList) {
                    declareOp = OracleQueryKeywordReplacerExt.varrayTypeInCol(declareTypes, declareOp, type, column, createTypesDBMap, typeValue);
                }
            }
            headerOp = OracleQueryKeywordReplacerExt.doReplaceVarrayReturnTypes(headerOp, createTypesDBMap, type);
            headerOp = OracleQueryKeywordReplacerExt.doReplaceVarrayInOutParameterTypes(headerOp, createTypesDBMap, type);
        }
        declareOp = headerOp + declareOp;
        if (QueryConversionUtility.containsCheck(declareOp, "String")) {
            declareOp = QueryConversionUtility.doReplaceExactStr("String", "VARCHAR", declareOp);
        }
        return declareOp;
    }

    public static String doCommentNullConstraint(String variable) {
        String var = variable;
        Matcher match = CONSTANT_DEFAULT_PAT.matcher(var);
        String varNme = null;
        String datatype = null;
        if (match.find()) {
            boolean sCondition;
            String commentGrp = match.group(1) != null ? match.group(1) : "";
            varNme = match.group(2);
            String constStr = match.group(3) != null ? match.group(3) : "";
            String grp = match.group(5).trim();
            boolean fCondition = !varNme.equalsIgnoreCase("TYPE") && !varNme.equalsIgnoreCase("SUBTYPE") && !grp.startsWith(":=");
            boolean bl = sCondition = !QueryConversionUtility.toLower(grp).startsWith("default") && !varNme.equalsIgnoreCase("CURSOR");
            if (fCondition && sCondition) {
                String str;
                datatype = match.group(4).trim();
                int index = datatype.lastIndexOf(" ");
                if (index != -1 && QueryConversionUtility.equalCheck("null", str = datatype.substring(index + 1))) {
                    datatype = datatype.substring(0, index) + " " + "/*" + str + "*/";
                }
                var = commentGrp + varNme + " " + constStr + datatype + grp;
            }
        }
        return var;
    }

    private static String doRecordTypeMigration(Map<String, String> declareTypes, String declareQry, List<String> typesLst, Map<String, String> recordTypes) {
        String declareOp = declareQry;
        Pattern patternType = Pattern.compile("(?i)((?<!\\w)type\\s+(\\w+)\\s+(?:is|as)\\s+RECORD\\s*(\\(.*?);)");
        Matcher matcherType = patternType.matcher(declareOp);
        String declareVars = "";
        while (matcherType.find()) {
            StringBuffer declareCols = new StringBuffer();
            String recordType = matcherType.group(1);
            String recordName = matcherType.group(2);
            String cols = OracleQueryKeywordReplacerExt.getCols(matcherType);
            typesLst.add(recordType);
            recordTypes.put(QueryConversionUtility.toUpper(recordName), cols);
            ColumnSplitter splitter = new ColumnSplitter();
            List<String> recordCols = splitter.doGetAllColumns(cols);
            declareVars = OracleQueryKeywordReplacerExt.getDecCols(recordName, recordCols, declareVars, declareCols);
            List<String> recordVars = new ArrayList<String>(10);
            recordVars = QueryConversionUtility.getMatchedGrpsInLst(declareOp, "(?i)(\\w+)\\s+(?<!\\w|TYPE\\s|\\sTABLE\\sOF\\s|\\sRETURN\\s)" + recordName + "(?!\\w)", 1, recordVars);
            declareOp = QueryConversionUtility.doReplaceSpecificGrp(declareOp, "(?i)(?<!\\w|TYPE\\s|\\sTABLE\\sOF\\s|\\sRETURN\\s)" + recordName + "(?!\\w)", "", "RECORD", 0, false);
            declareCols.deleteCharAt(declareCols.length() - 1);
            for (String varName : recordVars) {
                declareTypes.put("##RECORD##" + QueryConversionUtility.toUpper(varName), declareCols.toString());
            }
        }
        declareOp = OracleQueryKeywordReplacerExt.getDecOp(typesLst, declareOp, declareVars);
        return declareOp;
    }

    private static String getDecOp(List<String> typesLst, String declareOp, String declareVars) {
        declareOp = declareOp + declareVars;
        for (String recordTyp : typesLst) {
            declareOp = declareOp.replace(recordTyp, "/*" + recordTyp + "*/");
        }
        return declareOp;
    }

    private static String getDecCols(String recordName, List<String> recordCols, String declareVars, StringBuffer declareCols) {
        int index = 0;
        StringBuffer dec = new StringBuffer();
        for (String col : recordCols) {
            index = col.indexOf(32);
            dec.append(declareVars).append("MIG_").append(recordName).append("_").append(col.replace("\"", "")).append(";");
            declareCols.append("MIG_").append(recordName).append("_").append(col.substring(0, index).replace("\"", "")).append(" as ").append(col.substring(0, index)).append(",");
        }
        return dec.toString();
    }

    private static String getCols(Matcher matcherType) {
        String cols = matcherType.group(3);
        cols = QueryConversionUtility.removeParenthesis(cols);
        return cols;
    }

    private static String retTypeInHeader(String headerOpQry, String type) {
        String headerOp = headerOpQry;
        Pattern retTypePat = Pattern.compile("(?<!\\w)(return\\s+" + QueryConversionUtility.santizePattern(type) + ")(?!\\w)", 2);
        Matcher retMatcher = retTypePat.matcher(headerOp);
        StringBuffer headStr = new StringBuffer(headerOp);
        if (retMatcher.find()) {
            StringBuffer retStr = new StringBuffer("RETURN SETOF ");
            if (type.contains(".")) {
                retStr.append(type.substring(0, type.indexOf(46) + 1));
                retStr.append("MIG_");
                retStr.append(type.substring(type.indexOf(46) + 1));
            } else {
                retStr.append("MIG_");
                retStr.append(type);
            }
            headStr.replace(retMatcher.start(1), retMatcher.end(1), retStr.toString());
        }
        headerOp = headStr.toString();
        return headerOp;
    }

    private static String commentTypeInCol(Map<String, String> declareTypes, String declareOp, String type, String column) {
        String outStr = declareOp;
        String tempCol = QueryConversionUtility.toLower(column.replaceAll("(?i)#S#\\d+#E#", "")).trim();
        if (!tempCol.startsWith("type") && QueryConversionUtility.isExactMatch(column, type)) {
            boolean updateReq = OracleQueryKeywordReplacerExt.doGetTbls(declareTypes, type, column);
            outStr = OracleQueryKeywordReplacerExt.updateDeclareStmt(outStr, column, updateReq);
        }
        return outStr;
    }

    private static String varrayTypeInCol(Map<String, String> declareTypes, String declareOp, String type, String column, Map<String, String> createTypesDBMap, String typeValue) {
        String outStr = declareOp;
        boolean isVarray = false;
        String tempCol = QueryConversionUtility.toLower(column.replaceAll("(?i)#S#\\d+#E#", "")).trim();
        if (!tempCol.startsWith("type") && QueryConversionUtility.isExactMatch(column, type)) {
            String columnMod = OracleQueryKeywordReplacerExt.doReplaceVarrayTypes(declareTypes, type, column, typeValue, createTypesDBMap);
            if (varrayVars.size() == 0) {
                isVarray = true;
            } else {
                for (int iIndex = 0; iIndex < varrayVars.size(); ++iIndex) {
                    if (type.equals(varrayVars.get(iIndex).trim())) continue;
                    isVarray = true;
                }
            }
            if (isVarray) {
                int colonIndex = columnMod.indexOf(";");
                if (colonIndex != -1 && !QueryConversionUtility.containsCheck(outStr.replace(" ", ""), columnMod.substring(0, colonIndex).replace(" ", "")) && !outStr.matches("(?i).*type\\s+" + type.trim() + "\\s+is\\s+varray\\s*\\(\\s*\\d+\\s*\\)\\s*of\\s*.*?;.*")) {
                    outStr = outStr.replace(column, columnMod);
                }
                varrayVars.add(type);
            }
        }
        return outStr;
    }

    private static String updateDeclareStmt(String declareStmt, String colName, boolean isReq) {
        String column = colName;
        String updDeclare = declareStmt;
        if (isReq) {
            column = column.replace(")", "\\)");
            column = column.replace("(", "\\(");
            Pattern pattern = Pattern.compile(column + "\\s*;");
            Matcher matcher = pattern.matcher(new InterruptCharSequence(Matcher.quoteReplacement(updDeclare)));
            updDeclare = matcher.replaceAll("/*" + column.trim() + ";*/");
        }
        return updDeclare;
    }

    private static boolean doGetTbls(Map<String, String> declareTypes, String type, String column) {
        Matcher matcher = TBL_PAT.matcher(column);
        boolean isSuccess = false;
        if (matcher.find()) {
            String ddlTbl = matcher.group(2).trim();
            String dmlTbl = matcher.group(3).trim();
            if (dmlTbl.equalsIgnoreCase(type)) {
                declareTypes.put(ddlTbl, dmlTbl);
                isSuccess = true;
            }
        }
        return isSuccess;
    }

    private static String doReplaceVarrayTypes(Map<String, String> declareTypes, String type, String column, String typeValue, Map<String, String> createTypesDBMap) {
        Matcher matcher = VARRAY_TYPES_PAT.matcher(column);
        String columnMod = "";
        String ddlTbl = null;
        String dmlTbl = null;
        String beforeDDL = null;
        if (matcher.find()) {
            beforeDDL = matcher.group(1).trim();
            ddlTbl = matcher.group(3).trim();
            dmlTbl = matcher.group(4).trim();
            OracleUtility oracleUtil = new OracleUtility();
            String varraySize = oracleUtil.doGetVarraySize(typeValue);
            if (dmlTbl.equalsIgnoreCase(type)) {
                columnMod = !beforeDDL.contains("*/") ? " TYPE " + dmlTbl + " " + QueryConversionUtility.toUpper("is") + " " + "VARRAY" + "(" + varraySize + ")" + " " + "OF" + " " + typeValue + ";" + column : beforeDDL + " " + "TYPE" + " " + dmlTbl + " " + QueryConversionUtility.toUpper("is") + " " + "VARRAY" + "(" + varraySize + ")" + " " + "OF" + " " + typeValue + ";" + matcher.group(2).trim();
                createTypesDBMap.put(ddlTbl + "_VARRAYVAR", typeValue);
            }
        }
        return columnMod;
    }

    protected static String doGetCreateTblForTypes(Map<String, String> tblsMap, Map<String, String> recordTypeMap) {
        StringBuffer createTable = new StringBuffer();
        StringBuffer recordTable = null;
        for (Map.Entry<String, String> table : tblsMap.entrySet()) {
            String tblKey = table.getKey();
            String tblValue = table.getValue();
            String singleCreate = null;
            if (tblKey.startsWith("##RECORD##")) {
                tblKey = tblKey.substring(10);
                recordTable = new StringBuffer();
                recordTable.append("select").append(" ").append(tblValue).append(" ").append("INTO").append(" ").append(tblKey).append(";");
                singleCreate = recordTable.toString();
            } else if (tblValue.endsWith("~#~")) {
                tblValue = tblValue.replace("~#~", "");
                if (recordTypeMap.containsKey(tblValue = QueryConversionUtility.toUpper(tblValue))) {
                    tblValue = recordTypeMap.get(tblValue);
                    singleCreate = OracleQueryKeywordReplacerExt.createRecordTypeTable(tblKey, tblValue);
                } else {
                    singleCreate = OracleQueryKeywordReplacerExt.createUDTWithDatatype(tblKey, tblValue);
                    tblsMap.put(tblKey, tblValue);
                }
            } else if (tblValue.contains("~#~")) {
                String colValue = tblValue.substring(tblValue.indexOf("~#~") + 3);
                tblValue = tblValue.substring(0, tblValue.indexOf("~#~"));
                singleCreate = OracleQueryKeywordReplacerExt.createUDTWithColumnType(tblKey, tblValue, colValue);
                tblsMap.put(tblKey, tblValue);
            } else {
                singleCreate = OracleQueryKeywordReplacerExt.createUDT(tblKey, tblValue);
            }
            createTable.append(singleCreate);
        }
        return createTable.toString();
    }

    private static String createRecordTypeTable(String tblKey, String tblValue) {
        StringBuffer recordTable = new StringBuffer();
        recordTable.append("EXECUTE IMMEDIATE ");
        recordTable.append("'");
        recordTable.append("DROP");
        recordTable.append(" ").append("TABLE").append(" ");
        recordTable.append("IF").append(" ");
        recordTable.append("EXISTS");
        recordTable.append(" ");
        recordTable.append(tblKey);
        recordTable.append(";").append(" ");
        recordTable.append("CREATE").append(" ");
        recordTable.append("LOCAL TEMPORARY");
        recordTable.append(" ").append("TABLE").append(" ");
        recordTable.append(tblKey);
        recordTable.append("(");
        recordTable.append(" ").append(tblValue).append(")");
        recordTable.append(" ").append("ON COMMIT PRESERVE ROWS");
        recordTable.append("'").append(";").append(" ");
        String singleCreate = null;
        singleCreate = recordTable.toString();
        return singleCreate;
    }

    private static String createUDTWithDatatype(String tblKey, String tblValue) {
        StringBuffer createTable = new StringBuffer();
        createTable.append("EXECUTE IMMEDIATE ");
        createTable.append("'");
        createTable.append("DROP");
        createTable.append(" ").append("TABLE").append(" ");
        createTable.append("IF").append(" ");
        createTable.append("EXISTS");
        createTable.append(" ");
        createTable.append(tblKey);
        createTable.append(";").append(" ");
        createTable.append("CREATE").append(" ");
        createTable.append("LOCAL TEMPORARY");
        createTable.append(" ").append("TABLE").append(" ");
        createTable.append(tblKey);
        createTable.append("(").append("typ_col");
        createTable.append(" ").append(tblValue).append(")");
        createTable.append(" ").append("ON COMMIT PRESERVE ROWS");
        createTable.append("'").append(";").append(" ");
        return createTable.toString();
    }

    static String createUDTWithColumnType(String tblKey, String tblValue, String colValue) {
        StringBuffer createTable = new StringBuffer();
        createTable.append("EXECUTE IMMEDIATE ");
        createTable.append("'");
        createTable.append("DROP").append(" ").append("TABLE").append(" ");
        createTable.append("IF").append(" ");
        createTable.append("EXISTS").append(" ");
        createTable.append(tblKey);
        createTable.append(";").append(" ");
        createTable.append("CREATE");
        createTable.append(" ").append("LOCAL TEMPORARY");
        createTable.append(" ").append("TABLE").append(" ");
        createTable.append(tblKey).append(" ").append("ON COMMIT PRESERVE ROWS");
        createTable.append(" as ").append("SELECT").append(" ");
        createTable.append(colValue).append(" as ").append("typ_col");
        if (!tblKey.startsWith("MIG_")) {
            createTable.append(",").append("CAST(NULL AS INT) AS typ_idx_col");
        }
        createTable.append(" ").append("from");
        createTable.append(" ");
        createTable.append(tblValue);
        createTable.append(" WHERE ").append("FALSE");
        createTable.append("'");
        createTable.append(";").append(" ");
        return createTable.toString();
    }

    private static String createUDT(String tblKey, String tblValue) {
        StringBuffer createTable = new StringBuffer();
        createTable.append("EXECUTE IMMEDIATE ");
        createTable.append("'");
        createTable.append("DROP").append(" ").append("TABLE").append(" ");
        createTable.append("IF").append(" ").append("EXISTS").append(" ");
        createTable.append(tblKey);
        createTable.append(";").append(" ");
        createTable.append("CREATE").append(" ").append("LOCAL TEMPORARY");
        createTable.append(" ").append("TABLE").append(" ");
        createTable.append(tblKey).append(" ").append("ON COMMIT PRESERVE ROWS");
        createTable.append(" as ").append("SELECT").append(" ");
        createTable.append("*");
        if (!tblKey.startsWith("MIG_")) {
            createTable.append(",").append("CAST(NULL AS INT) AS typ_idx_col");
        }
        createTable.append(" ").append("from");
        createTable.append(" ");
        if (!tblKey.startsWith("MIG_") && !tblValue.contains(".")) {
            createTable.append("MIG_").append(tblValue);
        } else if (!tblKey.startsWith("MIG_") && tblValue.contains(".")) {
            int idx = tblValue.lastIndexOf(46);
            createTable.append(tblValue.substring(0, idx + 1)).append("MIG_");
            createTable.append(tblValue.substring(idx + 1));
        } else if (tblKey.startsWith("MIG_")) {
            createTable.append(tblValue);
        }
        createTable.append(" WHERE ").append("FALSE");
        createTable.append("'").append(";").append(" ");
        return createTable.toString();
    }

    public static String doPreIndexChanges(String inputQry, String fileName) {
        Pattern pattern;
        Matcher matcher;
        String output = inputQry;
        Map<String, String> globalMap = OracleMigrationService.getGlobalTempMap();
        output = QueryConversionUtility.doRplFromMap(output, globalMap);
        output = FeatureLoaderExtended.getBooleanProperty("GaussSupForIndexname") ? OracleQueryKeywordReplacerExt.supportIndexName(output) : QueryConversionUtility.doReplaceSpecificGrp(output, "(?i)(?<!\\w)(?:Create|alter)\\s+.*(?<!\\w)(?:index|table)\\s+.*?(\\w*\\.)?\\w+.*", "", "", 1, false);
        if (QueryConversionUtility.isExactMatch(output, "partition") && (matcher = (pattern = Pattern.compile("(?i)(?<!\\w)(partition\\s+by\\s+(?:list|range)\\s*\\(.*?)(as\\s*\\(##QUERY##\\d+#\\)|(?<!\\w)local(?!\\w)|;|$)")).matcher(output)).find()) {
            output = output.replace(matcher.group(1), "");
        }
        output = OracleQueryKeywordReplacerExt.doIndexChanges(output, fileName);
        return output;
    }

    private static String supportIndexName(String input) {
        String output = input;
        Pattern schIndexPat = Pattern.compile("(?i)(?<!\\w)create\\s+(?:unique\\s+)?index\\s+((?:(\\\"?\\w+\\\"?)\\.)?\\\"?(\\w+)\\\"?)\\s+on\\s+(?:(\\\"?\\w+\\\"?)\\.)?\\\"?\\w+\\\"?.*?;");
        Matcher schIndexMatch = schIndexPat.matcher(output);
        String schIndex = "";
        String schIndexQuote = "";
        String schTable = "";
        String schTableQuote = "";
        if (schIndexMatch.find()) {
            schIndex = schIndexMatch.group(2);
            schTable = schIndexMatch.group(4);
            schIndexQuote = schIndex;
            schTableQuote = schTable;
            if (schIndexQuote != null) {
                schIndexQuote = !schIndex.startsWith("\"") ? schIndex.toLowerCase(Locale.ROOT) : schIndexQuote.replace("\"", "");
            }
            if (schTableQuote != null) {
                schTableQuote = !schTable.startsWith("\"") ? schTable.toLowerCase(Locale.ROOT) : schTableQuote.replace("\"", "");
            }
            if (schIndexQuote != null && !schIndexQuote.equals(schTableQuote)) {
                if (schIndex.startsWith("\"")) {
                    schIndex = schIndex.replace("\"", "");
                    output = output.replace(schIndexMatch.group(1), "\"" + schIndex + "_" + schIndexMatch.group(3) + "\"");
                } else {
                    output = output.replace(schIndexMatch.group(1), schIndex + "_" + schIndexMatch.group(3));
                }
            }
        }
        return output;
    }

    private static String doIndexChanges(String outputQry, String fileName) {
        Pattern pattern;
        Matcher matcher;
        String output = outputQry;
        if (QueryConversionUtility.isExactMatch(output, "case") && (matcher = (pattern = Pattern.compile("(?i).*(?<!\\w)create\\s+(?<!\\w)(?:index|unique\\s+index)(?!\\w).*?(case.*?end).*")).matcher(output)).find()) {
            output = output.replace(matcher.group(1), "(" + matcher.group(1) + ")");
        }
        if (QueryConversionUtility.isExactMatch(output, "decode") && (matcher = (pattern = Pattern.compile("(?i).*(?<!\\w)create\\s+(?<!\\w)(?:index|unique\\s+index)(?!\\w).*?(decode.*?);")).matcher(output)).find()) {
            String decode = QueryConversionUtility.doGetReplaceString(matcher.group(1));
            output = output.replace(decode, "(" + decode + ")");
        }
        output = OracleQueryKeywordReplacerExt.disableOraHash(output, fileName);
        return output;
    }

    private static String disableOraHash(String outputQry, String fileName) {
        String output = outputQry;
        boolean containsOraHash = false;
        if (!QueryConversionUtility.isExactMatch(output, "ORA_HASH")) {
            return output;
        }
        Pattern pattern = Pattern.compile("(?i).*(?<!\\w)create\\s+(?<!\\w)(?:index|unique\\s+index)(?!\\w).*?(?:(?<!\\w)on(?!\\w)).*?\\((.*?((?<!\\w)ORA_HASH(?!\\w)\\s*\\(.*?\\))\\s*.*?)\\);");
        Matcher matcher = pattern.matcher(output);
        if (matcher.find()) {
            String oraHashFunc = matcher.group(2);
            String allColumns = matcher.group(1);
            if (oraHashFunc != null && allColumns != null) {
                String replacement = oraHashFunc.substring(oraHashFunc.indexOf("(") + 1, oraHashFunc.length() - 1);
                if (replacement.isEmpty()) {
                    String commaBeforeOraHash = allColumns.substring(0, allColumns.indexOf(oraHashFunc));
                    if (commaBeforeOraHash.contains(",")) {
                        output = output.replace(commaBeforeOraHash, commaBeforeOraHash.substring(0, commaBeforeOraHash.lastIndexOf(",")));
                        containsOraHash = true;
                    } else {
                        output = OracleQueryKeywordReplacerExt.handleElsePart(output, oraHashFunc, allColumns);
                    }
                }
                output = output.replace(oraHashFunc, oraHashFunc.substring(oraHashFunc.indexOf("(") + 1, oraHashFunc.length() - 1));
                containsOraHash = true;
            }
        }
        if (containsOraHash) {
            logger.info("ORA_HASH function is not supported by Gauss, so it has been removed from file : {}", (Object)fileName);
        }
        return output;
    }

    private static String handleElsePart(String outputVal, String oraHashFunc, String allColumns) {
        String commaAfterOraHash;
        String output = outputVal;
        int index = allColumns.indexOf(oraHashFunc);
        if (index != -1 && (commaAfterOraHash = allColumns.substring(index + oraHashFunc.length())).contains(",")) {
            output = output.replace(commaAfterOraHash, commaAfterOraHash.substring(commaAfterOraHash.indexOf(",") + 1));
        }
        return output;
    }

    protected static String toAddSchemaNameInFunc(String input) throws MigrationServiceException {
        String output = input;
        OracleUtility util = new OracleUtility();
        if (QueryConversionUtility.containsCheck(output, "LAST_DAY")) {
            output = util.doAddSchemaInFunctionNme(output, "(?i).*?(?<!function\\s|procedure\\s|table\\s|insert\\sinto\\s|update\\s|view\\s|\\.|\\w|#)(LAST_DAY\\s*\\()", "LAST_DAY", 1, 1, "LAST_DAY");
        }
        if (QueryConversionUtility.containsCheck(output, "MONTHS_BETWEEN")) {
            output = util.doAddSchemaInFunctionNme(output, "(?i).*?(?<!function\\s|procedure\\s|table\\s|insert\\sinto\\s|update\\s|view\\s|\\.|\\w|#)(MONTHS_BETWEEN\\s*\\()", "MONTHS_BETWEEN", 2, 2, "MONTHS_BETWEEN");
        }
        if (QueryConversionUtility.containsCheck(output, "COMPARE")) {
            output = util.doAddSchemaInFunctionNme(output, "(?i).*?(?<!function\\s|procedure\\s|table\\s|insert\\sinto\\s|update\\s|view\\s|\\.|\\w|#)((?:sys.dbms_lob.compare|dbms_lob.compare)\\s*\\()", "DBMS_LOB.COMPARE", 2, 5, "MIG_CLOB_COMPARE");
        }
        return output;
    }

    private static String doCommentUnsupportedKeywords(String inputQry) {
        String patternString = "(?i)(?<!\\w)(SEGMENT\\s+CREATION\\s+IMMEDIATE|SEGMENT\\s+CREATION\\s+DEFERRED|PCTUSED|LOGGING|PCTFREE|INITRANS|MAXTRANS|COMPRESS(?!\\w)|NOCOMPRESS|COMPUTE\\s+STATISTICS|TABLESPACE\\s+.*?\\s)(\\s+\\d+)?(?!\\s+VARCHAR2|\\s+NUMBER\\s+DATE)";
        Pattern segmentPattern = Pattern.compile(patternString);
        Matcher segmentMatcher = segmentPattern.matcher(inputQry);
        String segment = null;
        int temp = 0;
        StringBuffer outbuff = new StringBuffer();
        while (segmentMatcher.find()) {
            int start = segmentMatcher.start();
            int end = segmentMatcher.end();
            segment = segmentMatcher.group();
            outbuff.append(inputQry.substring(temp, start));
            String segmentWithCmnt = "/*" + segment + "*/";
            outbuff.append(segmentWithCmnt);
            temp = end;
        }
        outbuff.append(inputQry.substring(temp));
        return outbuff.toString();
    }

    private static String doCommentKeyword(String patternString, String input) {
        String output = input;
        Pattern pattern = Pattern.compile(patternString, 2);
        Matcher matcher = pattern.matcher(output);
        int tempIndex = 0;
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            int startIndex = matcher.start();
            int endIndex = matcher.end();
            sb.append(output.substring(tempIndex, startIndex));
            sb.append("/*" + matcher.group() + "*/");
            tempIndex = endIndex;
        }
        sb.append(output.substring(tempIndex));
        return sb.toString();
    }

    protected static String doPreOracleChanges(String inputQry) throws MigrationServiceException {
        String output = inputQry;
        output = OracleQueryKeywordReplacerExt.doPreMigChanges(output);
        LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
        output = QueryConversionUtility.getSingleDoubleQuoteMap(output, quoteMap);
        output = OracleQueryKeywordReplacerExt.doSchChanges(output);
        output = QueryConversionUtility.getRplFromMap(output, quoteMap, "(##QUOTE##\\d+#)");
        output = OracleQueryKeywordReplacerExt.getOutputQuery(output);
        if (QueryConversionUtility.containsCheck(output = QueryConversionUtility.replaceAll(output, "(?i)(?<!\\w)SYSDATE\\s*\\(\\s*\\)", "SYSDATE"), "DEFINE")) {
            output = QueryConversionUtility.replaceAll(output, "(?i)(?<!\\w)SET(?!\\w)\\s+(?<!\\w)define\\s+off(?!\\w)\\s*(;)?", "/* SET define off; */");
        }
        return output;
    }

    private static String getOutputQuery(String input) {
        String output = input;
        if (QueryConversionUtility.containsCheck(output = OracleQueryKeywordReplacerExt.checkdoSupportTwoArgsDate(output), "bitmap")) {
            output = QueryConversionUtility.changeBitmapIndex(output);
        }
        output = OracleQueryKeywordReplacerExt.doConvertSelectUnique(output);
        if (FeatureLoader.getBooleanProperty("commentPragmaAutomationTrans")) {
            output = QueryConversionUtility.doCommentSpecificGrp(output, "(?i)\\s*((?<!\\w)PRAGMA(?!\\w)\\s+(?<!\\w)AUTONOMOUS_TRANSACTION(?!\\w)\\s*;)", 1);
        }
        if (output.matches("(?i).*(?<!\\w)FLOAT\\s*\\(\\d+\\).*")) {
            output = QueryConversionUtility.replaceAll(output, "(?i)(?<!\\w)FLOAT\\s*\\(\\d+\\)", "FLOAT");
        }
        if (QueryConversionUtility.toLower(output = OracleQueryKeywordReplacerExt.doRemoveCharInVarchar(output)).contains("byte")) {
            output = OracleQueryKeywordReplacerExt.doRemoveByteInVarchar(output);
        }
        return output;
    }

    private static String doSchChanges(String input) {
        String output = input;
        output = OracleQueryKeywordReplacerExt.doRmvSpcBtnRelationalOptr(output);
        if (FeatureLoader.getBooleanProperty("tdMigrateAddMonth")) {
            output = OracleQueryKeywordReplacerExt.doAppendSchemaInFnNme(output, "ADD_MONTHS");
        }
        OracleUtility util = new OracleUtility();
        if (QueryConversionUtility.containsCheck(output, "Replace")) {
            output = util.doModifyReplaceFunction(output);
        }
        if (QueryConversionUtility.containsCheck(output, "RATIO_TO_REPORT")) {
            output = OracleUtility.doCheckRatioToReport(output);
        }
        output = OracleQueryKeywordReplacerExt.toAddSchemaNameInFunc(output);
        if (!FeatureLoader.getBooleanProperty("MigSupportForRegexFunc")) {
            output = OracleQueryKeywordReplacerExt.addSchemaInRegexPatterns(output);
        }
        if (QueryConversionUtility.containsCheck(output, "to_clob")) {
            output = util.doReplaceClob(output);
        }
        if (QueryConversionUtility.containsCheck(output, "CURRVAL") || QueryConversionUtility.containsCheck(output, "NEXTVAL")) {
            output = OracleUtility.doChangeNextCurrVal(output);
        }
        return output;
    }

    private static String doPreMigChanges(String input) {
        String output = input;
        if (QueryConversionUtility.containsCheck(output, "sys_guid")) {
            output = OracleQueryKeywordReplacerExt.migrateSysGuid(output);
        }
        if (QueryConversionUtility.containsCheck(output, "NLSSORT")) {
            output = OracleQueryKeywordReplacerExt.ascInNlsSort(output);
        }
        if (QueryConversionUtility.containsCheck(output = QueryConversionUtility.doPutQuoteOnKeyword(output), "SYSTIMESTAMP")) {
            output = output.replaceAll("(?i)(?<!\\w)SYSTIMESTAMP(?!\\w)", "CURRENT_TIMESTAMP");
        }
        if (QueryConversionUtility.containsCheck(output, "USERENV")) {
            output = OracleUtility.doAddSchemaInUserEnvFun(output, "(?i).*?(?<!function\\s|procedure\\s|table\\s|insert\\sinto\\s|update\\s|view\\s|\\.|\\w|#)(USERENV\\s*\\()", "USERENV", 1, 1, "USERENV");
        }
        if (output.matches("(?i).*(?<!\\w)q\\s*\\'.*")) {
            output = OracleQueryKeywordReplacerExt.doPutQuoteChange(output);
        }
        return output;
    }

    private static String doRemoveByteInVarchar(String output) {
        String input = output;
        if (input.matches("(?i).*create(?:.*?)(?:\\(\\s*\\d+\\s+(byte)\\s*\\)).*")) {
            Matcher matcher = BYTE_PAT.matcher(input);
            StringBuffer sb = new StringBuffer();
            int tempIndex = 0;
            while (matcher.find()) {
                int startIndex = matcher.start(1);
                int endIndex = matcher.end(1);
                sb.append(input.substring(tempIndex, startIndex));
                tempIndex = endIndex;
            }
            sb.append(input.substring(tempIndex));
            return sb.toString();
        }
        return input;
    }

    private static String migrateSysGuid(String outputQry) {
        String output = outputQry;
        Matcher sysMatcher = SYS_GUID_PAT.matcher(output);
        String sysGuid = "";
        String modSysGuid = "";
        while (sysMatcher.find()) {
            sysGuid = sysMatcher.group(1);
            modSysGuid = "MIG_ORA_EXT." + sysGuid;
            output = output.replace(sysGuid, modSysGuid);
        }
        return output;
    }

    private static String doRemoveCharInVarchar(String input) {
        Matcher matcher = CHARACTER_PAT.matcher(input);
        int tempIndex = 0;
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            int startIndex = matcher.start();
            int endIndex = matcher.end();
            sb.append(input.substring(tempIndex, startIndex));
            String varcharStr = matcher.group(1);
            sb.append(varcharStr + ")");
            tempIndex = endIndex;
        }
        sb.append(input.substring(tempIndex));
        return sb.toString();
    }

    private static String doConvertSelectUnique(String output) {
        String input = output;
        Matcher selectUniqueMatcher = SELECT_UNIQUE_PAT.matcher(input);
        int endIndex = 0;
        int tempIndex = 0;
        StringBuffer sb = new StringBuffer();
        boolean clearSb = true;
        while (selectUniqueMatcher.find()) {
            if (clearSb) {
                sb.setLength(0);
            }
            int startIndex = selectUniqueMatcher.start(1);
            endIndex = selectUniqueMatcher.end(1);
            sb.append(output.substring(tempIndex, startIndex));
            sb.append("DISTINCT");
            tempIndex = endIndex;
            clearSb = false;
        }
        sb.append(output.substring(endIndex, input.length()));
        input = sb.toString();
        return input;
    }

    private static String addSchemaInRegexPatterns(String input) throws MigrationServiceException {
        String output = input;
        OracleUtility util = new OracleUtility();
        if (QueryConversionUtility.containsCheck(output, "REGEXP_INSTR")) {
            output = util.doAddSchemaInFunctionNme(output, "(?i)(?<!function\\s|procedure\\s|table\\s|insert\\sinto\\s|update\\s|view\\s|\\.|\\w|#)(REGEXP_INSTR\\s*\\()", "REGEXP_INSTR", 2, 6, "REGEXP_INSTR");
        }
        if (QueryConversionUtility.containsCheck(output, "REGEXP_REPLACE")) {
            output = util.doAddSchemaInFunctionNme(output, "(?i)(?<!function\\s|procedure\\s|table\\s|insert\\sinto\\s|update\\s|view\\s|\\.|\\w|#)(REGEXP_REPLACE\\s*\\()", "REGEXP_REPLACE", 2, 6, "REGEXP_REPLACE");
        }
        if (QueryConversionUtility.containsCheck(output, "REGEXP_SUBSTR")) {
            output = util.doAddSchemaInFunctionNme(output, "(?i)(?<!function\\s|procedure\\s|table\\s|insert\\sinto\\s|update\\s|view\\s|\\.|\\w|#)(REGEXP_SUBSTR\\s*\\()", "REGEXP_SUBSTR", 2, 5, "REGEXP_SUBSTR");
        }
        return output;
    }

    private static String doReplaceVarrayReturnTypes(String beginQry, Map<String, String> createTypesDDL, String type) {
        String vrayy;
        String createType;
        String begin = beginQry;
        Pattern pattern = Pattern.compile("(?i)(return\\s+((?<!\\w)" + type + "(?!\\w)))\\s*(?:(?:#S#\\d+#E#)\\s*)*;?");
        Matcher matcher = pattern.matcher(new InterruptCharSequence(begin));
        if (matcher.find() && (createType = createTypesDDL.get(QueryConversionUtility.toUpper(vrayy = matcher.group(2).trim() + "_" + "VARRAY"))) != null) {
            String replacement = createType.trim() + "[]";
            String returnStmt = matcher.group(1);
            returnStmt = returnStmt.replace(matcher.group(2), replacement);
            begin = begin.replace(matcher.group(1), returnStmt);
        }
        return begin;
    }

    private static String doReplaceVarrayInOutParameterTypes(String begin, Map<String, String> createTypesDDL, String type) {
        Pattern pattern = Pattern.compile("(?i)((out|in|inout)\\s+)((\\w*\\.)?(?<!\\w)" + type + "(?!\\w))");
        Matcher matcher = pattern.matcher(new InterruptCharSequence(begin));
        StringBuffer sb = new StringBuffer();
        int tempIndex = 0;
        while (matcher.find()) {
            String vrayy = matcher.group(3).trim() + "_" + "VARRAY";
            String createType = createTypesDDL.get(QueryConversionUtility.toUpper(vrayy));
            if (createType == null) continue;
            int startIndex = matcher.start(3);
            int endIndex = matcher.end(3);
            sb.append(begin.substring(tempIndex, startIndex));
            String replacement = createType.trim() + "[]";
            sb.append(replacement);
            tempIndex = endIndex;
        }
        sb.append(begin.substring(tempIndex));
        return sb.toString();
    }

    private static String ascInNlsSort(String outputQry) {
        String output = outputQry;
        Matcher ascInNlssortMatch = ASC_IN_NLSSORT_PAT.matcher(output);
        int startIdx = 0;
        StringBuffer sb = new StringBuffer();
        while (ascInNlssortMatch.find()) {
            String asc = ascInNlssortMatch.group(1);
            String commentAsc = "/*" + asc + "*/";
            int tempIdx = ascInNlssortMatch.start(1);
            int endIdx = ascInNlssortMatch.end(1);
            sb.append(output.substring(startIdx, tempIdx));
            sb.append(commentAsc);
            startIdx = endIdx;
        }
        sb.append(output.substring(startIdx));
        output = sb.toString();
        return output;
    }

    public static String doPutQuoteChange(String input) {
        String output = input;
        StringBuffer strOutBuff = new StringBuffer();
        int tempIdx = 0;
        String patternQuote = "(?i)(?<!')q(\\'([\\`|~|!|@|#|$|%|^|*|\\(|\\)|+|\\-|=|\\\\|\\||\\/|{|}|\\[|\\]|:|\\'|\"|<|>|,|.|?|\\w]))";
        Pattern pattern = Pattern.compile(patternQuote);
        Matcher matcher = pattern.matcher(output);
        while (matcher.find()) {
            int quoteStartIdx = matcher.start(1);
            int quoteStartEndIdx = matcher.end(1);
            String delimiter = matcher.group(2).trim();
            if (delimiter.equals("(")) {
                delimiter = ")";
            } else if (delimiter.equals("[")) {
                delimiter = "]";
            } else if (delimiter.equals("{")) {
                delimiter = "}";
            } else if (delimiter.equals("<")) {
                delimiter = ">";
            }
            String quoteEndDelimiter = delimiter + "'";
            int quoteEndIdx = QueryConversionUtility.getIndex(output, quoteEndDelimiter, quoteStartEndIdx);
            String strWithinQuotes = output.substring(quoteStartEndIdx, quoteEndIdx);
            strOutBuff.append(output.substring(tempIdx, quoteStartIdx - 1)).append(" ").append("$q$").append(strWithinQuotes).append("$q$").append(" ");
            tempIdx = quoteEndIdx + 2;
        }
        strOutBuff.append(output.substring(tempIdx));
        output = strOutBuff.toString();
        return output;
    }

    public static String doAppendSchemaInFnNme(String outputQry, String functionNme) {
        String output = outputQry;
        if (QueryConversionUtility.containsCheck(output, functionNme)) {
            String replacePattern = "(?i)(?<!\\.|\\w|#)" + functionNme + "\\s*\\(";
            String replacementValue = "MIG_ORA_EXT." + functionNme + "(";
            output = output.replaceAll(replacePattern, replacementValue);
        }
        return output;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static String checkdoSupportTwoArgsDate(String input) throws MigrationServiceException {
        StringBuffer sb = new StringBuffer();
        int endIndex = 0;
        int startIndex = 0;
        int indexTranslate = 0;
        String cols = "";
        while (QueryConversionUtility.getIndex(input, "TO_DATE", indexTranslate) != -1) {
            Pattern toDatePattern;
            Matcher matcher;
            indexTranslate = QueryConversionUtility.getIndex(input, "TO_DATE", indexTranslate);
            sb.append(input.substring(startIndex, indexTranslate));
            if (indexTranslate == -1) continue;
            cols = QueryUtilityExt.doGetStringFromGivenIndex(indexTranslate, input);
            endIndex = indexTranslate + cols.length();
            Matcher matchfuncInTodate = TO_DATE_PAT.matcher(cols);
            if (matchfuncInTodate.find()) {
                cols = cols.replace(matchfuncInTodate.group(), "TEMP~~REPL~~FUNC");
            }
            if ((matcher = (toDatePattern = Pattern.compile("(?i)(?<!\\w)TO_DATE\\s*\\(.*?,.*?(,\\s*\\'?\\s*(.*?)\\s*\\'?\\s*)\\)")).matcher(cols)).find()) {
                String matcherGrp = matcher.group(1);
                if (!matcherGrp.matches(".*\\*\\/")) {
                    if (!matcherGrp.matches("(?i),\\s*\\'\\s*NLS_CALENDAR\\s*=\\s*GREGORIAN\\s*\\'\\s*")) throw new MigrationServiceException("[DSC_ERR_002_005] " + MessageLoader.getMessage("DSC_ERR_002_005"));
                    sb.append(cols.replace(matcherGrp, "/*" + matcherGrp + "*/"));
                } else {
                    sb.append(cols);
                }
                startIndex = endIndex;
            } else {
                if (cols.contains("TEMP~~REPL~~FUNC")) {
                    cols = cols.replace("TEMP~~REPL~~FUNC", matchfuncInTodate.group());
                }
                sb.append(cols);
                startIndex = endIndex;
            }
            indexTranslate += 6;
        }
        sb.append(input.substring(endIndex));
        return sb.toString();
    }
}

