/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.parser;

import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.parser.JSONBOObjectConstructor;
import com.huawei.db.migration.util.ErrorLoggerUtility;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONTokener;

public class GenericJSONParser {
    private static final Logger logger = LogManager.getLogger(GenericJSONParser.class);

    protected String getMigrationUserType(String scMigType) throws MigrationServiceException {
        try {
            if (null == scMigType) {
                return "invalid";
            }
            if (scMigType.equalsIgnoreCase("bulk")) {
                return "ddl";
            }
            if (scMigType.equalsIgnoreCase("blogic")) {
                return "plsql";
            }
            return "invalid";
        }
        catch (MigrationServiceException e) {
            throw new MigrationServiceException("Invalid migration type.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<?> getJSONObject(String parserTok) throws MigrationServiceException {
        String parserType = parserTok;
        List<?> list = null;
        parserType = QueryConversionUtility.toLower(parserType);
        String jsonFileName = this.constructJSONFileName(parserType);
        JSONTokener parser = null;
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream ioStream = null;
        JSONArray jarray = null;
        try {
            if (classLoader == null || classLoader.getResource(jsonFileName) == null) {
                throw new MigrationServiceException("[DSC_ERR_004_005] " + MessageLoader.getMessage("DSC_ERR_004_005"));
            }
            ioStream = classLoader.getResourceAsStream(jsonFileName);
            parser = new JSONTokener((Reader)new BufferedReader(new InputStreamReader(ioStream, Charset.defaultCharset())));
            jarray = new JSONArray(parser);
            list = new JSONBOObjectConstructor().getJSONObjectBOList(parserType, jarray);
        }
        catch (RuntimeException objExp) {
            String[] dbProps = parserType.split("-");
            if (dbProps.length > 1) {
                logger.error(ErrorLoggerUtility.getExceptionDetails(objExp) + "[DSC_ERR_004_006] " + MessageLoader.getMessage("DSC_ERR_004_006") + " " + this.getMigrationUserType(dbProps[1]) + " for the Database: " + dbProps[0]);
                throw new MigrationServiceException("[DSC_ERR_004_006] " + MessageLoader.getMessage("DSC_ERR_004_006") + " " + this.getMigrationUserType(dbProps[1]) + " for the Database: " + dbProps[0]);
            }
        }
        finally {
            if (ioStream != null) {
                try {
                    ioStream.close();
                    ioStream = null;
                }
                catch (IOException e) {
                    logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " IOException during file close.");
                }
            }
        }
        return list;
    }

    private String constructJSONFileName(String parserType) {
        String jsonFileName = parserType;
        StringBuffer sb = new StringBuffer();
        sb.append("jsons").append("/").append(jsonFileName).append(".").append("json");
        String finalJSONFileName = sb.toString();
        logger.debug("JSON Config File Name : {}", (Object)finalJSONFileName);
        return finalJSONFileName;
    }
}

