/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.replacer;

import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.interfaces.IReplacerMap;
import com.huawei.db.migration.replacer.MapTokenResolver;
import com.huawei.db.migration.replacer.TokenReplacingReader;
import com.huawei.db.migration.util.ErrorLoggerUtility;
import com.huawei.db.migration.util.MessageLoader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReplacerMap
implements IReplacerMap {
    private static final Logger logger = LogManager.getLogger(ReplacerMap.class);
    private Map<String, String> mInstance = new LinkedHashMap<String, String>(10);

    @Override
    public boolean containsKey(Object key) {
        return this.mInstance.containsKey(key);
    }

    @Override
    public String doSqlReplacement(String replacementPattern) throws MigrationServiceException {
        String outputQuery = null;
        Reader reader = null;
        StringReader src = null;
        try {
            src = new StringReader(replacementPattern);
            MapTokenResolver resolver = new MapTokenResolver(this);
            reader = new TokenReplacingReader(src, resolver);
            StringBuffer sb = null;
            sb = new StringBuffer();
            int data = reader.read();
            int charMaxVal = 65535;
            while (data != -1) {
                if (data <= charMaxVal) {
                    sb.append((char)data);
                }
                data = reader.read();
            }
            outputQuery = sb.toString();
        }
        catch (IOException e) {
            logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " IO Error occurred reading the query string. ");
            throw new MigrationServiceException("[DSC_ERR_004_007] " + MessageLoader.getMessage("DSC_ERR_004_007"));
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (src != null) {
                    ((Reader)src).close();
                }
            }
            catch (IOException e) {
                logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " Error occurred while closing the reader object");
            }
        }
        return outputQuery;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.mInstance.entrySet();
    }

    @Override
    public void clear() {
        this.mInstance.clear();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.mInstance.containsValue(value);
    }

    @Override
    public boolean isEmpty() {
        return this.mInstance.isEmpty();
    }

    @Override
    public String get(Object key) {
        return this.mInstance.get(key);
    }

    @Override
    public Set<String> keySet() {
        return this.mInstance.keySet();
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> mapObj) {
        this.mInstance.putAll(mapObj);
    }

    @Override
    public Collection<String> values() {
        return this.mInstance.values();
    }

    @Override
    public int size() {
        return this.mInstance.size();
    }

    @Override
    public String remove(Object key) {
        return this.mInstance.remove(key);
    }

    @Override
    public String put(String key, String value) {
        return this.mInstance.put(key, value);
    }
}

