/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.services;

import com.huawei.db.migration.bo.IMigrationInputBO;
import com.huawei.db.migration.common.handlers.MigrationProcessor;
import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.interfaces.IDBMigrationService;
import com.huawei.db.migration.parser.GenericJSONParser;
import com.huawei.db.migration.services.MigrationService;
import com.huawei.db.migration.services.MigrationValidatorService;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.ProgressUtil;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public abstract class DBMigrationService
implements IDBMigrationService {
    @Override
    public void handleMigration(Map<String, String> fileMap, IMigrationInputBO objInputData) throws MigrationServiceException, InterruptedException {
        GenericJSONParser objJSONParser = new GenericJSONParser();
        List<?> queryPatterns = objJSONParser.getJSONObject(objInputData.getSourceDb() + "-" + objInputData.getMigTaskName());
        List<?> querySplitterPatterns = objJSONParser.getJSONObject(objInputData.getSourceDb() + "-" + objInputData.getMigTaskName() + "-" + "splitter");
        ExecutorService executor = this.getExecutorService();
        ArrayList<Future<?>> futureList = this.scheduleMigrationThread(fileMap, objInputData, queryPatterns, querySplitterPatterns, executor);
        this.clearExecutorService(executor, futureList);
        ProgressUtil.completeProgress();
        MigrationService.printConsoleMessage(fileMap);
    }

    protected final void clearExecutorService(ExecutorService executor, ArrayList<Future<?>> futureList) throws InterruptedException {
        executor.shutdown();
        boolean shutdown = executor.awaitTermination(QueryConversionUtility.getApplicationTimeout(), TimeUnit.HOURS);
        QueryConversionUtility.clearFutureList(futureList);
        if (!shutdown) {
            throw new InterruptedException("[DSC_ERR_004_001] " + MessageLoader.getMessage("DSC_ERR_004_001"));
        }
    }

    private ArrayList<Future<?>> scheduleMigrationThread(Map<String, String> fileMap, IMigrationInputBO objInputData, List<?> queryPatterns, List<?> querySplitterPatterns, ExecutorService executor) {
        MigrationValidatorService validator = new MigrationValidatorService();
        Iterator<Map.Entry<String, String>> entries = fileMap.entrySet().iterator();
        ArrayList futureList = new ArrayList(10);
        while (entries.hasNext()) {
            Map.Entry<String, String> thisEntry = entries.next();
            validator.freeDiskSpaceChkFile(thisEntry.getValue(), objInputData.getTargetFolderLoc());
            String value = thisEntry.getValue();
            if (!(value instanceof String)) continue;
            String str = value;
            futureList.add(executor.submit(new MigrationProcessor(str, objInputData, fileMap.size(), queryPatterns, querySplitterPatterns)));
        }
        return futureList;
    }

    protected final ExecutorService getExecutorService() {
        ExecutorService executor = Executors.newFixedThreadPool(QueryConversionUtility.doGetAppThreadCnt());
        return executor;
    }
}

