/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.services;

import com.huawei.db.migration.bo.IMigrationInputBO;
import com.huawei.db.migration.bo.MigrationInputBO;
import com.huawei.db.migration.common.handlers.FileHandler;
import com.huawei.db.migration.common.handlers.MigrationProcessor;
import com.huawei.db.migration.exception.FileException;
import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.factory.MigrationAbstractFactory;
import com.huawei.db.migration.factory.MigrationFactoryProducer;
import com.huawei.db.migration.interfaces.IDBMigrationService;
import com.huawei.db.migration.services.MigrationValidatorService;
import com.huawei.db.migration.splitter.FileSplitterGenerator;
import com.huawei.db.migration.util.ApplicationProperty;
import com.huawei.db.migration.util.ApplicationPropertyLoader;
import com.huawei.db.migration.util.DBPropertyLoader;
import com.huawei.db.migration.util.ErrorLoggerUtility;
import com.huawei.db.migration.util.FeatureLoader;
import com.huawei.db.migration.util.FeatureLoaderExtended;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.ProgressUtil;
import com.huawei.db.migration.util.QueryConversionUtility;
import com.huawei.db.migration.util.QueryUtilityExt;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MigrationService {
    private static Logger logger = LogManager.getLogger(MigrationService.class);
    private static final int MAX_QRY_LENGTH = 0x3200000;
    private static final int DEFAULT_QRY_LENGTH = 0x100000;
    private static int totalNoFiles = 0;
    private static HashMap<String, String> featureProp;
    private static HashMap<String, String> applicationProp;

    public static void setProperties(HashMap<String, String> featureProperty, HashMap<String, String> applicationProperty) {
        featureProp = featureProperty;
        applicationProp = applicationProperty;
    }

    public static void doMigrate(String[] sourceTargetDb, String migrationTask, String sourceFolderLoc, String tarFolderLoc) throws MigrationServiceException, FileException {
        MigrationInputBO objInputData = new MigrationInputBO();
        MigrationValidatorService migrationValidator = MigrationService.loadProperty(sourceTargetDb, migrationTask, sourceFolderLoc, tarFolderLoc, objInputData);
        QueryConversionUtility.printConsoleMessage("DSC process start time : " + new Date());
        logger.info(MessageLoader.getMessage("migrationStartedTime"), (Object)new Date().toString());
        MigrationService.updateProperties();
        if (!QueryConversionUtility.containsCheck(System.getProperty("os.name"), "win")) {
            migrationValidator.folderAccessPrivilegeChk(objInputData);
        }
        String applicationlang = System.getProperty("APPLICATION_LANG");
        boolean doSplit = false;
        if (!"perl".equals(applicationlang) && !FeatureLoader.getBooleanProperty("dsqlSupport") && ApplicationPropertyLoader.getBooleanProperty("split_input")) {
            doSplit = true;
            FileSplitterGenerator.splitFilesStmtsWise(tarFolderLoc, migrationTask, sourceFolderLoc);
            objInputData.setSourceFolderLoc(tarFolderLoc + File.separator + "work");
        }
        FileHandler objFilehandler = new FileHandler();
        Map<String, String> files = objFilehandler.processSQLFiles(objInputData.getSourceFolderLoc(), new LinkedHashMap<String, String>(10));
        totalNoFiles = files.size() + objFilehandler.getUnsupportedCount();
        migrationValidator.freeDiskSpaceChk(files, objInputData.getTargetFolderLoc());
        if (files.size() == 0) {
            if (totalNoFiles == objFilehandler.getUnsupportedCount()) {
                if (objFilehandler.getUnsupportedFileExtensionList() != null && !objFilehandler.getUnsupportedFileExtensionList().isEmpty()) {
                    QueryConversionUtility.printConsoleMessage(objFilehandler.getUnsupportedFileExtensionList().toString() + " extensions are not supported. Please add extension in fileExtension config parameter in application.properties.");
                }
                throw new MigrationServiceException("[DSC_ERR_004_010] " + MessageLoader.getMessage("DSC_ERR_004_010"));
            }
            throw new MigrationServiceException("[DSC_ERR_004_045] " + MessageLoader.getMessage("DSC_ERR_004_045"));
        }
        try {
            MigrationService.runMigTool(objInputData, objFilehandler, files);
            MigrationService.splitFiles(sourceFolderLoc, tarFolderLoc, doSplit);
        }
        catch (MigrationServiceException objExp) {
            logger.error("[DSC_ERR_004_009] " + MessageLoader.getMessage("DSC_ERR_004_009"));
        }
        catch (InterruptedException objExp) {
            MigrationProcessor.interrupt();
            logger.error("[DSC_ERR_004_009] " + MessageLoader.getMessage("DSC_ERR_004_009"));
        }
    }

    private static void runMigTool(IMigrationInputBO objInputData, FileHandler objFilehandler, Map<String, String> files) throws MigrationServiceException, InterruptedException {
        String rangeStr = ApplicationPropertyLoader.getStringProperty("MaxSqlLen").trim();
        MigrationService.doGetRange(rangeStr);
        ProgressUtil.updateTotalFiles(files.size());
        ProgressUtil.calculateStatementCount(files);
        ProgressUtil.reset();
        MigrationAbstractFactory objAbtFactory = MigrationFactoryProducer.getDataBaseFactory(objInputData.getSourceDb());
        IDBMigrationService objMigSer = objAbtFactory.getDBMigrationService();
        if (objMigSer != null) {
            objMigSer.handleMigration(files, objInputData);
        }
        if (objFilehandler.getUnsupportedFileExtensionList() != null && !objFilehandler.getUnsupportedFileExtensionList().isEmpty()) {
            QueryConversionUtility.printConsoleMessage(objFilehandler.getUnsupportedFileExtensionList().toString() + " extensions are not supported. Please add extension in fileExtension config parameter in application.properties.");
        }
    }

    private static void splitFiles(String sourceFolderLoc, String tarFolderLoc, boolean doSplit) {
        if (doSplit) {
            File workFile = new File(tarFolderLoc + File.separator + "work");
            if (workFile.exists()) {
                QueryUtilityExt.deleteFile(workFile);
                if (workFile.exists()) {
                    logger.error("Error while deleting work directory :" + workFile.getName());
                }
            }
            QueryUtilityExt.mergeFiles(sourceFolderLoc, tarFolderLoc);
        }
    }

    private static void updateProperties() {
        Set<Map.Entry<String, String>> entrySet;
        if (featureProp != null && featureProp.size() > 0) {
            entrySet = featureProp.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                FeatureLoaderExtended.setProperty(entry.getKey(), entry.getValue());
            }
            featureProp.clear();
        }
        if (applicationProp != null && applicationProp.size() > 0) {
            entrySet = applicationProp.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                ApplicationProperty.setProperty(entry.getKey(), entry.getValue());
            }
            applicationProp.clear();
        }
    }

    public static void printConsoleMessage(Map<String, String> files) {
        if (!ProgressUtil.getRunFileBarStatus()) {
            QueryConversionUtility.printConsoleMessage("--------------------------------------------------------------------------");
            QueryConversionUtility.printConsoleMessage("Total number of files in input folder : " + totalNoFiles);
            logger.info(MessageLoader.getMessage("totalFiles"), (Object)totalNoFiles);
            logger.info(MessageLoader.getMessage("totalQueries"), (Object)ErrorLoggerUtility.totalQryCnt());
            QueryConversionUtility.printConsoleMessage("Total number of valid files in input folder : " + files.size());
            logger.info(MessageLoader.getMessage("totalFilesValid"), (Object)files.size());
            if (ErrorLoggerUtility.totalFailedFiles() > 0) {
                QueryConversionUtility.printConsoleMessage("DSC tool cannot convert few files, please check the Error log file.");
            }
            QueryConversionUtility.printConsoleMessage("--------------------------------------------------------------------------");
        }
    }

    public static MigrationValidatorService loadProperty(String[] sourceTargetDb, String migrationTask, String sourceFolderLoc, String tarFolderLoc, IMigrationInputBO objInputData) {
        String sourceDb = "";
        String targetDb = "";
        if (sourceTargetDb.length == 2) {
            sourceDb = sourceTargetDb[0];
            targetDb = sourceTargetDb[1];
        }
        ApplicationProperty.setProperty("sourceFolderLoc", sourceFolderLoc);
        ApplicationProperty.setProperty("SourceDB", sourceDb);
        ApplicationProperty.setProperty("TargetDB", targetDb);
        ApplicationProperty.setProperty("TYPE", migrationTask);
        objInputData.setMigTaskName(QueryConversionUtility.toUpper(migrationTask.trim()));
        objInputData.setSourceDb(QueryConversionUtility.toLower(sourceDb.trim()));
        objInputData.setTargetDb(QueryConversionUtility.toLower(targetDb.trim()));
        objInputData.setSourceFolderLoc(sourceFolderLoc.trim());
        objInputData.setTargetFolderLoc(tarFolderLoc.trim());
        MigrationValidatorService migrationValidator = new MigrationValidatorService();
        migrationValidator.doPreApplicationValidation(objInputData);
        DBPropertyLoader.loadProperty(objInputData.getSourceDb());
        if (objInputData.getSourceDb().equalsIgnoreCase("ORACLE") && QueryConversionUtility.isGaus100()) {
            FeatureLoader.loadProperty("features-" + objInputData.getSourceDb() + "-" + objInputData.getTargetDb());
        } else {
            FeatureLoader.loadProperty("features-" + objInputData.getSourceDb());
        }
        return migrationValidator;
    }

    public static void doGetRange(String rangeStr) {
        if (rangeStr.matches("\\d+")) {
            QueryConversionUtility.setRange(Integer.parseInt(rangeStr));
            int range = QueryConversionUtility.getRange();
            if (range >= 0x3200000 || range <= 1) {
                QueryConversionUtility.printConsoleMessage("The query length parameter (MaxSqlLen) value is out of range. Resetting to default value.");
                int n = 0x100000;
            }
        } else {
            throw new MigrationServiceException("[DSC_ERR_004_011] " + MessageLoader.getMessage("DSC_ERR_004_011"));
        }
    }
}

