/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.services;

import com.huawei.db.migration.bo.IMigrationInputBO;
import com.huawei.db.migration.common.handlers.MigrationPostProcessor;
import com.huawei.db.migration.common.handlers.MigrationProcessor;
import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.services.DBMigrationService;
import com.huawei.db.migration.util.FeatureLoader;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.PropertyLoader;
import com.huawei.db.migration.util.QueryConversionUtility;
import com.huawei.db.migration.util.QueryUtilityExt;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OracleMigrationService
extends DBMigrationService {
    private static final Logger logger = LogManager.getLogger(OracleMigrationService.class);
    protected static final Map<String, String> CREATE_TYPE_MAP = new ConcurrentHashMap<String, String>(10);
    private static final Map<String, String> GLOBAL_TEMP_MAP = new ConcurrentHashMap<String, String>(10);
    private static final Map<String, String> USER_ATTN_MAP = new ConcurrentHashMap<String, String>(10);
    private static final Map<String, String> PACKAGE_NAME_MAP = new ConcurrentHashMap<String, String>(10);
    private static final Map<String, Set<String>> PACKAGE_FILE_MAP = new ConcurrentHashMap<String, Set<String>>(10);
    private static final Map<String, String> PKG_BODY_FILE_MAP = new ConcurrentHashMap<String, String>(10);
    private static final Map<String, Set<String>> REF_CURSOR_MAP = new ConcurrentHashMap<String, Set<String>>(10);
    private static final Set<String> PKG_SPEC_SET = new HashSet<String>(10);
    private static final Set<String> SCHEMA_PKG_BODY_SET = new HashSet<String>(10);
    private static final Map<String, Set<String>> PACKAGE_VAR_MAP = new ConcurrentHashMap<String, Set<String>>(10);
    private static final Map<String, Set<String>> PRIMARY_KEY_ALTER = new ConcurrentHashMap<String, Set<String>>(10);
    private static final Set<String> IS_CONSTRAINT_WITH_PARTITION = new HashSet<String>(10);
    private Map<String, String> fileMap;

    public static void addSchemaPkgBodyToSet(String schemaPkgName) {
        SCHEMA_PKG_BODY_SET.add(schemaPkgName);
    }

    public static Map<String, String> getGlobalTempMap() {
        return new LinkedHashMap<String, String>(GLOBAL_TEMP_MAP);
    }

    private static Set<String> getPkgSpecSet() {
        return new HashSet<String>(PKG_SPEC_SET);
    }

    public static void addPkgSpecToSet(String pkgName) {
        PKG_SPEC_SET.add(pkgName);
    }

    private static String getPackageBodyFileName(String pkgName) {
        return PKG_BODY_FILE_MAP.get(pkgName);
    }

    public static Map<String, String> getPackageBodyFileMap() {
        return new LinkedHashMap<String, String>(PKG_BODY_FILE_MAP);
    }

    private static Map<String, Set<String>> getRefCursorMap() {
        return new LinkedHashMap<String, Set<String>>(REF_CURSOR_MAP);
    }

    public static void addPackageBodyFileMap(String pkgName, String fileName) {
        PKG_BODY_FILE_MAP.put(pkgName, fileName);
    }

    public static Map<String, String> getCreateTypeMap() {
        return new LinkedHashMap<String, String>(CREATE_TYPE_MAP);
    }

    private static Map<String, String> getUserAttnMap() {
        return new LinkedHashMap<String, String>(USER_ATTN_MAP);
    }

    public static void addCreateTypeMap(String table, String tableReplacement) {
        CREATE_TYPE_MAP.put(table, tableReplacement);
    }

    public static void clearCreateTypeMap() {
        CREATE_TYPE_MAP.clear();
    }

    public static void addGlobalTempMap(String table, String tableReplacement) {
        GLOBAL_TEMP_MAP.put(table, tableReplacement);
    }

    public static void addUserAttentionMap(String table, String tableReplacement) {
        USER_ATTN_MAP.put(table, tableReplacement);
    }

    public static Map<String, Set<String>> getPackageFileMap() {
        return new LinkedHashMap<String, Set<String>>(PACKAGE_FILE_MAP);
    }

    public static Map<String, String> getPackageNameMap() {
        return new LinkedHashMap<String, String>(PACKAGE_NAME_MAP);
    }

    public static String getPackageReplacement(String pkgName) {
        return PACKAGE_NAME_MAP.get(pkgName);
    }

    public static void addPackageFileMapFrmSet(String fileName, Set<String> newPkgSet) {
        Set<String> pkgSet = PACKAGE_FILE_MAP.get(fileName);
        if (pkgSet != null) {
            pkgSet.addAll(newPkgSet);
            PACKAGE_FILE_MAP.put(fileName, pkgSet);
        } else {
            PACKAGE_FILE_MAP.put(fileName, newPkgSet);
        }
    }

    public static void addRefCursorFileMap(String pkgName, Set<String> refCursors) {
        Set<String> pkgSet = REF_CURSOR_MAP.get(pkgName);
        if (pkgSet != null) {
            pkgSet.addAll(refCursors);
            REF_CURSOR_MAP.put(pkgName, pkgSet);
        } else {
            REF_CURSOR_MAP.put(pkgName, refCursors);
        }
    }

    public static void addPackageNameMap(String pkgName, String pkgNewName) {
        PACKAGE_NAME_MAP.put(pkgName, pkgNewName);
    }

    public static void setPackageVarMap(String pkgNme, Set<String> var) {
        Set<String> pkgSet = PACKAGE_VAR_MAP.get(pkgNme);
        if (pkgSet != null) {
            pkgSet.addAll(var);
            PACKAGE_VAR_MAP.put(pkgNme, pkgSet);
        } else {
            PACKAGE_VAR_MAP.put(pkgNme, var);
        }
    }

    public static void addPrimaryKeyAlter(String schema, Set<String> primaryKey) {
        PRIMARY_KEY_ALTER.put(schema, primaryKey);
    }

    public static Set<String> getPrimaryKeyAlter(String schema) {
        return PRIMARY_KEY_ALTER.get(schema);
    }

    public static void removePrimaryKeyAlter() {
        PRIMARY_KEY_ALTER.clear();
    }

    public static Set<String> getConstraintWithPartition() {
        return IS_CONSTRAINT_WITH_PARTITION;
    }

    public static void addConstraintWithPartition(String constraint) {
        IS_CONSTRAINT_WITH_PARTITION.add(constraint);
    }

    @Override
    public void handleMigration(Map<String, String> fileMap, IMigrationInputBO objInputData) throws MigrationServiceException {
        try {
            this.fileMap = fileMap;
            GLOBAL_TEMP_MAP.putAll(PropertyLoader.loadPropertyFile("global-temp-tables"));
            CREATE_TYPE_MAP.putAll(PropertyLoader.loadPropertyFile("create-types-UDT"));
            PACKAGE_NAME_MAP.putAll(PropertyLoader.loadPropertyFile("package-names-oracle"));
            this.loadRefcursor();
            super.handleMigration(fileMap, objInputData);
            this.writePropertiesData();
            this.handlePostProcessing(objInputData);
            this.fileMap = null;
        }
        catch (MigrationServiceException objExp) {
            logger.error("[DSC_ERR_004_009] " + MessageLoader.getMessage("DSC_ERR_004_009"));
        }
        catch (InterruptedException objExp) {
            QueryUtilityExt.handleInterruptedException(objExp);
            MigrationProcessor.interrupt();
        }
    }

    @Override
    public void handlePostProcessing(IMigrationInputBO objInputData) throws InterruptedException {
        if (objInputData.getMigTaskName().equalsIgnoreCase("blogic")) {
            this.bLogicPostProcessing(objInputData);
        } else if (objInputData.getMigTaskName().equalsIgnoreCase("bulk")) {
            this.bulkPostProcessing(this.fileMap, objInputData);
        }
        if (!OracleMigrationService.getUserAttnMap().isEmpty()) {
            QueryConversionUtility.printConsoleMessage("\n--------------------------------------------------------------------------");
            QueryConversionUtility.printConsoleMessage("USER ATTENTION!!!");
        }
        for (Map.Entry<String, String> attnEntry : OracleMigrationService.getUserAttnMap().entrySet()) {
            QueryConversionUtility.printConsoleMessage("Variable: " + attnEntry.getKey() + " should be substituted in the file : \"" + attnEntry.getValue() + "\"");
            logger.error("Variable: " + attnEntry.getKey() + " should be substituted in the file :\"" + attnEntry.getValue() + "\"");
        }
        Set<String> pkgBdyName = SCHEMA_PKG_BODY_SET;
        pkgBdyName.removeAll(OracleMigrationService.getPkgSpecSet());
        for (String pkgBdy : pkgBdyName) {
            if (!logger.isInfoEnabled()) continue;
            logger.info(pkgBdy + " : Package body has been converted. There might be mismatch in schema name while creation of package specification and package body.");
        }
    }

    @Override
    public void writePropertiesData() {
        try {
            PropertyLoader.writePropertyFile("global-temp-tables", GLOBAL_TEMP_MAP);
        }
        catch (MigrationServiceException migExp) {
            logger.error("Errored out while saving global temporary tables.");
        }
        try {
            PropertyLoader.writePropertyFile("create-types-UDT", CREATE_TYPE_MAP);
        }
        catch (MigrationServiceException migExp) {
            logger.error("Errored out while saving create type names of UDT.");
        }
        try {
            PropertyLoader.writePropertyFile("package-names-oracle", PACKAGE_NAME_MAP);
        }
        catch (MigrationServiceException migExp) {
            logger.error("Errored out while saving package and its corresponding function/procedure names.");
        }
    }

    private void loadRefcursor() {
        for (Map.Entry<String, String> entry : PACKAGE_NAME_MAP.entrySet()) {
            String pkgNameWithRefcur = entry.getKey();
            String sysRef = PACKAGE_NAME_MAP.get(pkgNameWithRefcur).trim();
            if (!pkgNameWithRefcur.contains(".") || !sysRef.equalsIgnoreCase("SYS_REFCURSOR")) continue;
            String pkgName = pkgNameWithRefcur.substring(0, pkgNameWithRefcur.lastIndexOf("."));
            String refcurs = pkgNameWithRefcur.substring(pkgNameWithRefcur.lastIndexOf(".") + 1, pkgNameWithRefcur.length());
            if (REF_CURSOR_MAP.containsKey(pkgName)) {
                Set<String> setNew = REF_CURSOR_MAP.get(pkgName);
                setNew.add(QueryConversionUtility.toLower(refcurs));
                continue;
            }
            HashSet<String> refset = new HashSet<String>(10);
            refset.add(QueryConversionUtility.toLower(refcurs));
            OracleMigrationService.addRefCursorFileMap(QueryConversionUtility.toLower(pkgName), refset);
        }
    }

    private void bulkPostProcessing(Map<String, String> fileMap, IMigrationInputBO objInputData) throws InterruptedException {
        ExecutorService oracleExecutor = this.getExecutorService();
        ArrayList futureList = new ArrayList(10);
        QueryConversionUtility.printConsoleMessage("Started post processing");
        if (PRIMARY_KEY_ALTER.size() > 0) {
            for (Map.Entry<String, String> file : fileMap.entrySet()) {
                futureList.add(oracleExecutor.submit(new MigrationPostProcessor(file.getValue(), objInputData, null, "bulk")));
            }
        }
        oracleExecutor.shutdown();
        oracleExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.MINUTES);
        this.clearExecutorService(oracleExecutor, futureList);
        QueryConversionUtility.printConsoleMessage("Completed post processing");
    }

    private void bLogicPostProcessing(IMigrationInputBO objInputData) throws InterruptedException {
        ExecutorService oracleExecutor = this.getExecutorService();
        ArrayList futureList = new ArrayList(10);
        QueryConversionUtility.printConsoleMessage("Started post processing");
        if (!QueryConversionUtility.equalCheck(FeatureLoader.getStringProperty("pkgvariable"), "none")) {
            this.getQryList(objInputData, oracleExecutor, futureList);
        }
        this.clearExecutorService(oracleExecutor, futureList);
        oracleExecutor = this.getExecutorService();
        LinkedHashMap<String, Set<String>> mapFileVsRefCurs = new LinkedHashMap<String, Set<String>>();
        for (Map.Entry<String, Set<String>> refCursor : OracleMigrationService.getRefCursorMap().entrySet()) {
            Set<String> refCursorSet = refCursor.getValue();
            String pkgBodyName = refCursor.getKey();
            String fileName = OracleMigrationService.getPackageBodyFileName(pkgBodyName);
            if ((fileName = this.packageMisMatch(pkgBodyName, fileName)) == null || refCursorSet.isEmpty()) continue;
            if (!mapFileVsRefCurs.containsKey(fileName)) {
                mapFileVsRefCurs.put(fileName, new HashSet(10));
            }
            Set vars = (Set)mapFileVsRefCurs.get(fileName);
            vars.addAll(refCursorSet);
        }
        this.callProcessorForEachFile(objInputData, oracleExecutor, mapFileVsRefCurs);
        oracleExecutor.shutdown();
        oracleExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.MINUTES);
        oracleExecutor = this.getExecutorService();
        this.clearExecutorService(oracleExecutor, futureList);
        QueryConversionUtility.printConsoleMessage("Completed post processing");
    }

    private void getQryList(IMigrationInputBO objInputData, ExecutorService oracleExecutor, ArrayList<Future<?>> futureList) {
        Set<String> pkgBodyNames = null;
        for (Map.Entry<String, String> pckgBdyMap : OracleMigrationService.getPackageBodyFileMap().entrySet()) {
            HashSet<String> pkgNames = new HashSet<String>(10);
            String pckgName = pckgBdyMap.getKey();
            String fileName = pckgBdyMap.getValue();
            Set<String> pkgChangeSet = OracleMigrationService.getPackageFileMap().get(fileName);
            pkgBodyNames = OracleMigrationService.getPackageNameMap().keySet();
            if (pkgChangeSet != null) {
                pkgBodyNames.retainAll(pkgChangeSet);
            }
            if (!pkgBodyNames.isEmpty()) {
                pkgNames.addAll(pkgBodyNames);
            }
            for (Map.Entry<String, String> pckgNameMap : OracleMigrationService.getPackageNameMap().entrySet()) {
                String key = pckgNameMap.getKey();
                if (!pckgNameMap.getValue().contains("-") || !QueryConversionUtility.containsCheck(key, pckgName + ".")) continue;
                pkgNames.add(key);
            }
            futureList.add(oracleExecutor.submit(new MigrationPostProcessor(fileName, objInputData, pkgNames, "")));
        }
    }

    private void callProcessorForEachFile(IMigrationInputBO objInputData, ExecutorService oracleExecutor, Map<String, Set<String>> mapFileVsVariables) {
        for (Map.Entry<String, Set<String>> entryFileVsVars : mapFileVsVariables.entrySet()) {
            Set<String> variablesSet = entryFileVsVars.getValue();
            String fileName = entryFileVsVars.getKey();
            oracleExecutor.execute(new MigrationPostProcessor(fileName, objInputData, variablesSet, "PKG_VAR"));
        }
    }

    private String packageMisMatch(String pkgBodyName, String fileName) {
        String returnFile = fileName;
        if (pkgBodyName.contains(".") && fileName == null) {
            String tempPkgBdy = pkgBodyName.substring(pkgBodyName.indexOf(46) + 1);
            returnFile = OracleMigrationService.getPackageBodyFileName(tempPkgBdy);
        }
        if (returnFile == null) {
            for (Map.Entry<String, String> bodyFile : PKG_BODY_FILE_MAP.entrySet()) {
                if (!bodyFile.getKey().endsWith("." + pkgBodyName)) continue;
                returnFile = bodyFile.getValue();
                break;
            }
        }
        return returnFile;
    }
}

