/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.splitter;

import com.huawei.db.migration.splitter.BlogicBaseListener;
import com.huawei.db.migration.splitter.BlogicParser;
import com.huawei.db.migration.splitter.CustomFileWriter;
import com.huawei.db.migration.splitter.FileSplitterUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.TokenStreamRewriter;

public class BLogicCustomFileSplitterListener
extends BlogicBaseListener {
    private List<String> stmtList = new ArrayList<String>(10);
    private int fileCnt;
    private int stmtCnt;
    private Path outPath;
    private String charsetName;
    private String inputFilePath;
    private int stmtLimit;
    private TokenStreamRewriter rewriter = null;

    public BLogicCustomFileSplitterListener(CommonTokenStream tokenStream, String charsetName, Path outPath, String inputFilePath, int istmtLmt) {
        this.rewriter = new TokenStreamRewriter((TokenStream)tokenStream);
        this.fileCnt = 0;
        this.stmtCnt = 0;
        this.outPath = outPath;
        this.charsetName = charsetName;
        this.inputFilePath = inputFilePath;
        this.stmtLimit = istmtLmt;
    }

    @Override
    public void enterSingle_statement(BlogicParser.Single_statementContext ctx) {
        String sql = this.rewriter.getText(ctx.getSourceInterval());
        if (sql.trim().isEmpty()) {
            return;
        }
        ++this.stmtCnt;
        this.stmtList.add(sql);
        if (this.stmtCnt % this.stmtLimit == 0) {
            Path finalOutPath = FileSplitterUtil.doGetSplittedPathName(this.inputFilePath, this.outPath, this.fileCnt);
            CustomFileWriter.writeContent(this.stmtList, finalOutPath, this.charsetName);
            ++this.fileCnt;
            this.stmtList.clear();
        }
    }

    @Override
    public void exitSql_script(BlogicParser.Sql_scriptContext ctx) {
        if (this.stmtList.size() > 0) {
            Path finalOutPath = FileSplitterUtil.doGetSplittedPathName(this.inputFilePath, this.outPath, this.fileCnt);
            CustomFileWriter.writeContent(this.stmtList, finalOutPath, this.charsetName);
        }
    }
}

