/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.splitter;

import com.huawei.db.migration.splitter.BlogicBaseListener;
import com.huawei.db.migration.splitter.BlogicParser;
import com.huawei.db.migration.splitter.CustomFileWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.TokenStreamRewriter;

public class BLogicCustomListener
extends BlogicBaseListener {
    private List<String> lineRangeList = new ArrayList<String>();
    private TokenStreamRewriter rewriter = null;
    private String charSet;
    private Path outPath;

    public BLogicCustomListener(CommonTokenStream commonTokenStream, String charSet, Path outPath) {
        this.rewriter = new TokenStreamRewriter((TokenStream)commonTokenStream);
        this.charSet = charSet;
        this.outPath = outPath;
    }

    @Override
    public void enterSingle_statement(BlogicParser.Single_statementContext ctx) {
        String text = this.rewriter.getText(ctx.getSourceInterval());
        if (text.trim().isEmpty() || text.trim().matches("(^(?i)(set|prompt|spool)(?!\\w).*$)")) {
            return;
        }
        int startLine = ctx.getStart().getLine();
        int endLine = ctx.getStop().getLine();
        String lineRange = startLine + "," + endLine;
        this.lineRangeList.add(lineRange);
    }

    @Override
    public void exitSql_script(BlogicParser.Sql_scriptContext ctx) {
        CustomFileWriter.writeContent(this.lineRangeList, this.outPath, this.charSet);
    }
}

