/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.splitter;

import com.huawei.db.migration.splitter.BLogicCustomFileSplitterListener;
import com.huawei.db.migration.splitter.BLogicCustomListener;
import com.huawei.db.migration.splitter.BlogicBaseListener;
import com.huawei.db.migration.splitter.BlogicCustomErrorListener;
import com.huawei.db.migration.splitter.BlogicLexer;
import com.huawei.db.migration.splitter.BlogicParser;
import com.huawei.db.migration.splitter.IStatementSplitter;
import com.huawei.db.migration.util.ApplicationPropertyLoader;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.nio.file.Path;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class BlogicStatementSplitter
implements IStatementSplitter {
    private int PLSQLLMT = 2000;

    @Override
    public void split(CharStream inputStream, Path outPath, boolean isFileSplitter, String charSet) {
        BlogicLexer lexer = new BlogicLexer(inputStream);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)BlogicCustomErrorListener.getInstance());
        CommonTokenStream commonTokenStream = new CommonTokenStream((TokenSource)lexer);
        BlogicParser parser = new BlogicParser((TokenStream)commonTokenStream);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)BlogicCustomErrorListener.getInstance());
        ParseTreeWalker walker = new ParseTreeWalker();
        BlogicParser.Sql_scriptContext tree = parser.sql_script();
        BlogicBaseListener listener = null;
        if (isFileSplitter) {
            String plsqlLimt = ApplicationPropertyLoader.getStringProperty("splitplsqlsize").trim();
            if (plsqlLimt.matches("\\d+")) {
                int iplsqlLmt;
                this.PLSQLLMT = iplsqlLmt = Integer.parseInt(plsqlLimt);
            } else {
                QueryConversionUtility.printConsoleMessage("The input split based plsql size specified is invalid, Hence proceeding with default value ");
            }
            String inputFilePath = inputStream.getSourceName();
            listener = new BLogicCustomFileSplitterListener(commonTokenStream, charSet, outPath, inputFilePath, this.PLSQLLMT);
        } else {
            listener = new BLogicCustomListener(commonTokenStream, charSet, outPath);
        }
        walker.walk((ParseTreeListener)listener, (ParseTree)tree);
    }
}

