/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.splitter;

import java.util.List;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.TokenStreamRewriter;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BulkCustomErrorListener
extends BaseErrorListener {
    private static final Logger logger = LogManager.getLogger("parselogger");
    private static final BulkCustomErrorListener INSTANCE = new BulkCustomErrorListener();

    private BulkCustomErrorListener() {
    }

    public static BulkCustomErrorListener getInstance() {
        return INSTANCE;
    }

    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException ex) {
        if (recognizer instanceof Parser) {
            Parser parser = (Parser)recognizer;
            TokenStream tokens = parser.getInputStream();
            String fileName = tokens.getSourceName();
            TokenStreamRewriter rewriter = new TokenStreamRewriter(parser.getTokenStream());
            int start = parser.getRuleContext().getStart().getTokenIndex();
            List childList = parser.getRuleContext().children;
            if (null != childList) {
                int end = ((ParseTree)childList.get((int)(childList.size() - 1))).getSourceInterval().b;
                String text = rewriter.getText(new Interval(start, end));
                if (!msg.contains("missing ';' at '<EOF>") || !text.trim().isEmpty() && !text.trim().matches("(^(?i)(set|prompt|spool)(?!\\w).*$)")) {
                    StringBuilder msgBuilder = new StringBuilder();
                    msgBuilder.append(msg).append(", file name:").append(fileName).append(", at line:").append(line).append(", position:").append(charPositionInLine);
                    logger.error(msgBuilder.toString());
                }
            } else {
                StringBuilder msgBuilder = new StringBuilder();
                msgBuilder.append(msg).append(", file name:").append(fileName).append(", at line:").append(line).append(", position:").append(charPositionInLine);
                logger.error(msgBuilder.toString());
            }
        }
    }
}

