/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.splitter;

import com.huawei.db.migration.splitter.BulkBaseListener;
import com.huawei.db.migration.splitter.BulkCustomErrorListener;
import com.huawei.db.migration.splitter.BulkCustomFileSplitterListener;
import com.huawei.db.migration.splitter.BulkCustomListener;
import com.huawei.db.migration.splitter.BulkLexer;
import com.huawei.db.migration.splitter.BulkParser;
import com.huawei.db.migration.splitter.IStatementSplitter;
import com.huawei.db.migration.util.ApplicationPropertyLoader;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.nio.file.Path;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class BulkStatementSplitter
implements IStatementSplitter {
    private int DDLLMT = 20000;

    @Override
    public void split(CharStream inputStream, Path outPath, boolean isFileSplitter, String charSet) {
        BulkLexer lexer = new BulkLexer(inputStream);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)BulkCustomErrorListener.getInstance());
        CommonTokenStream commonTokenStream = new CommonTokenStream((TokenSource)lexer);
        BulkParser parser = new BulkParser((TokenStream)commonTokenStream);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)BulkCustomErrorListener.getInstance());
        ParseTreeWalker walker = new ParseTreeWalker();
        BulkParser.Sql_scriptContext tree = parser.sql_script();
        BulkBaseListener listener = null;
        if (isFileSplitter) {
            String ddlLimt = ApplicationPropertyLoader.getStringProperty("splitddlsize").trim();
            if (ddlLimt.matches("\\d+")) {
                int iddlLmt;
                this.DDLLMT = iddlLmt = Integer.parseInt(ddlLimt);
            } else {
                QueryConversionUtility.printConsoleMessage("The input split based on ddl size specified is invalid, Hence proceeding with default value. ");
            }
            String inputFilePath = inputStream.getSourceName();
            listener = new BulkCustomFileSplitterListener(commonTokenStream, charSet, outPath, inputFilePath, this.DDLLMT);
        } else {
            listener = new BulkCustomListener(commonTokenStream, charSet, outPath);
        }
        walker.walk((ParseTreeListener)listener, (ParseTree)tree);
    }
}

