/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.splitter;

import com.huawei.db.migration.util.ApplicationPropertyLoader;
import com.huawei.db.migration.util.SetFilePermission;
import java.io.File;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DirWalker
extends SimpleFileVisitor<Path> {
    private static final Logger logger = LogManager.getLogger(DirWalker.class);
    private SetFilePermission filePer = new SetFilePermission();
    private boolean isFolCreated = false;
    private String osName = System.getProperty("os.name");
    private final Path inDirPath;
    private final Path outDirPath;
    private Map<Path, Path> filesMap;

    DirWalker(Path inputFolder, Path outputFolder) {
        this.inDirPath = inputFolder;
        this.outDirPath = outputFolder;
        try {
            if (Files.isDirectory(this.outDirPath, new LinkOption[0])) {
                this.deleteDirectoryRecursively(this.outDirPath.toFile());
            }
            this.isFolCreated = this.osName != null && this.osName.toLowerCase(Locale.ROOT).contains("win") ? this.filePer.createFolderWithPermissionInWin(this.outDirPath.toString(), false) : this.filePer.createFolderWithPermissionInLinux(this.outDirPath.toString(), false);
            if (this.isFolCreated) {
                logger.debug("Target Folder has been created: {}", (Object)this.outDirPath.toString());
            }
            this.filesMap = new HashMap<Path, Path>();
        }
        catch (SecurityException e) {
            logger.error("SecurityException in create directory " + this.outDirPath + " . ");
        }
    }

    private void deleteDirectoryRecursively(File inputDir) {
        try {
            File[] allContents = inputDir.listFiles();
            if (allContents != null) {
                for (File file : allContents) {
                    this.deleteDirectoryRecursively(file);
                }
            }
            if (!inputDir.delete()) {
                logger.error("Error while deleting " + inputDir.toString());
            }
        }
        catch (SecurityException e) {
            logger.error("Security Error in deleting directory " + inputDir.toString() + " recursively ");
        }
    }

    @Override
    public FileVisitResult visitFile(Path infile, BasicFileAttributes attr) {
        if (attr.isRegularFile() && this.isValidFile(infile.toString())) {
            Path relativePath = this.inDirPath.relativize(infile);
            Path outfilePath = Paths.get(this.outDirPath.toString(), relativePath.toString()).normalize();
            this.filesMap.put(infile.toAbsolutePath(), outfilePath.toAbsolutePath());
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
        Path relativePath = this.inDirPath.relativize(dir);
        boolean isFolcreated = false;
        if (!relativePath.toString().isEmpty()) {
            String outdirPath = this.outDirPath.toString() + File.separator + relativePath.toString();
            isFolcreated = this.osName != null && this.osName.toLowerCase(Locale.ROOT).contains("win") ? this.filePer.createFolderWithPermissionInWin(outdirPath, false) : this.filePer.createFolderWithPermissionInLinux(outdirPath, false);
            if (isFolcreated) {
                logger.debug("Target Folder has been created:{}", (Object)outdirPath);
            }
        }
        return FileVisitResult.CONTINUE;
    }

    private String[] getValidFileExtension() {
        String ext = ApplicationPropertyLoader.getStringProperty("fileExtension");
        if ((ext = ext.replace(".", "")).matches("[a-zA-Z0-9-_,\\s]+")) {
            if (!ext.trim().isEmpty()) {
                return ext.split("\\s*,\\s*");
            }
        } else {
            logger.error("Invalid file extensions configured, set the default extension to sql");
        }
        return new String[]{"sql"};
    }

    private boolean isValidFile(String filename) {
        String[] validExt;
        for (String ext : validExt = this.getValidFileExtension()) {
            if (!filename.toLowerCase(Locale.ROOT).endsWith("." + ext.toLowerCase(Locale.ROOT))) continue;
            return true;
        }
        return false;
    }

    public Map<Path, Path> getFilesMap() {
        return this.filesMap;
    }
}

