/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.splitter;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FileSplitterUtil {
    private static final Map<String, Integer> SPLIT_FILEMAP = new ConcurrentHashMap<String, Integer>(10);

    public static Map<String, Integer> getSplitFileMap() {
        return SPLIT_FILEMAP;
    }

    public static void addToSplitFileMap(String filePath, Integer cnt) {
        SPLIT_FILEMAP.put(filePath, cnt);
    }

    public static Path doGetSplittedPathName(String inputFilePath, Path outPath, int fileCnt) {
        FileSplitterUtil.addToSplitFileMap(inputFilePath, fileCnt);
        File file = outPath.toFile();
        String name = file.getName();
        String filePath = name.substring(0, name.lastIndexOf("."));
        String extn = name.substring(name.lastIndexOf("."));
        String splitName = filePath + "_sp_" + fileCnt + extn;
        String path = file.getPath().substring(0, file.getPath().lastIndexOf(File.separator));
        String finalPath = path + File.separator + splitName;
        Path finalOutPath = Paths.get(finalPath, new String[0]).normalize();
        return finalOutPath;
    }
}

