/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.sqlformatter;

import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.sqlformatter.GaussSQLConstants;
import com.huawei.db.migration.sqlformatter.GaussSQLToken;
import com.huawei.db.migration.sqlformatter.IGaussAbstractToken;
import java.util.ArrayList;
import java.util.List;

public class GaussSQLParser {
    private static final String SYMBOL = "\"?,&\\'<=()|*+>-/;!:";
    private static final String[] CONSTANT_TWOCHARSYMBOL = new String[]{"<>", "<=", ">=", "||", ":=", "/*", "*/", "!=", "::", "<<", ">>", "\\i"};
    private String prevStr;
    private char pChar;
    private int pPos;

    private static boolean isSpace(char argChar) {
        return argChar == ' ' || argChar == '\t' || argChar == '\n' || argChar == '\r' || argChar == '\uffff';
    }

    private static boolean isLetter(char argChar) {
        if (GaussSQLParser.isSpace(argChar)) {
            return false;
        }
        if (Character.isDigit(argChar)) {
            return false;
        }
        return !GaussSQLParser.isSymbol(argChar);
    }

    private static boolean isSymbol(char argChar) {
        int index = SYMBOL.indexOf(argChar);
        return index != -1;
    }

    private IGaussAbstractToken tokenChecker() {
        int currPos = this.pPos;
        if (this.pPos >= this.prevStr.length()) {
            ++this.pPos;
            return new GaussSQLToken(6, "", currPos);
        }
        this.pChar = this.prevStr.charAt(this.pPos);
        if (GaussSQLParser.isSpace(this.pChar)) {
            GaussSQLToken spaceToken = this.parseSpace(currPos);
            return spaceToken;
        }
        if (this.pChar == ';') {
            ++this.pPos;
            return new GaussSQLToken(1, ";", currPos);
        }
        if (Character.isDigit(this.pChar)) {
            return this.parseDigit(currPos);
        }
        if (GaussSQLParser.isLetter(this.pChar)) {
            GaussSQLToken letterToken = this.parseLetter(currPos);
            return letterToken;
        }
        if (this.pChar == '-') {
            ++this.pPos;
            char ch2 = this.prevStr.charAt(this.pPos);
            GaussSQLToken hypenToken = this.parseHypen(currPos, ch2);
            return hypenToken;
        }
        if (this.pChar == '/') {
            GaussSQLToken slashToken = this.parseSlash(currPos);
            return slashToken;
        }
        if (this.pChar == '\'') {
            GaussSQLToken backSlashToken = this.parseBackSlash(currPos);
            return backSlashToken;
        }
        if (this.pChar == '\"') {
            GaussSQLToken parseToken = this.parseBackSlashDoubleQuote(currPos);
            return parseToken;
        }
        if (GaussSQLParser.isSymbol(this.pChar)) {
            return this.parseSymbol(currPos);
        }
        ++this.pPos;
        return new GaussSQLToken(7, "" + this.pChar, currPos);
    }

    private GaussSQLToken parseBackSlashDoubleQuote(int currPos) {
        ++this.pPos;
        StringBuffer strBuff = new StringBuffer("\"");
        while (true) {
            if (this.pPos >= this.prevStr.length()) {
                continue;
            }
            this.pChar = this.prevStr.charAt(this.pPos);
            strBuff.append(this.pChar);
            ++this.pPos;
            if (this.pChar == '\"') break;
        }
        return new GaussSQLToken(3, strBuff.toString(), currPos);
    }

    private IGaussAbstractToken parseDigit(int currPos) {
        StringBuffer sb = new StringBuffer();
        while (Character.isDigit(this.pChar) || this.pChar == '.') {
            sb.append(this.pChar);
            ++this.pPos;
            if (this.pPos >= this.prevStr.length()) break;
            this.pChar = this.prevStr.charAt(this.pPos);
        }
        return new GaussSQLToken(4, sb.toString(), currPos);
    }

    private GaussSQLToken parseSpace(int currPos) {
        StringBuffer currString = new StringBuffer();
        do {
            currString.append(this.pChar);
            if (this.pPos < this.prevStr.length()) {
                this.pChar = this.prevStr.charAt(this.pPos);
            }
            if (!GaussSQLParser.isSpace(this.pChar)) {
                return new GaussSQLToken(0, currString.toString(), currPos);
            }
            ++this.pPos;
        } while (this.pPos < this.prevStr.length());
        return new GaussSQLToken(0, currString.toString(), currPos);
    }

    private IGaussAbstractToken parseSymbol(int currPos) {
        StringBuffer strBuff = new StringBuffer();
        strBuff.append(this.pChar);
        ++this.pPos;
        if (this.pPos >= this.prevStr.length()) {
            return new GaussSQLToken(1, strBuff.toString(), currPos);
        }
        char ch2 = this.prevStr.charAt(this.pPos);
        for (int iIndex = 0; iIndex < CONSTANT_TWOCHARSYMBOL.length; ++iIndex) {
            if (CONSTANT_TWOCHARSYMBOL[iIndex].charAt(0) != this.pChar || CONSTANT_TWOCHARSYMBOL[iIndex].charAt(1) != ch2) continue;
            ++this.pPos;
            strBuff.append(ch2);
            break;
        }
        return new GaussSQLToken(1, strBuff.toString(), currPos);
    }

    private GaussSQLToken parseBackSlash(int currPos) {
        StringBuffer strBuff;
        block3: {
            ++this.pPos;
            strBuff = new StringBuffer("'");
            if (this.pPos > 1 && this.getCharAt(this.prevStr, this.pPos - 2) == 'q') {
                int symbolPos = this.pPos;
                do {
                    this.pChar = this.getCharAt(this.prevStr, this.pPos);
                    strBuff.append(this.pChar);
                    ++this.pPos;
                } while (this.pChar != '\'' || symbolPos == this.pPos - 2 || !GaussSQLParser.isQSymbolOracle(this.getCharAt(this.prevStr, this.pPos - 2)));
                return new GaussSQLToken(4, strBuff.toString(), currPos);
            }
            do {
                this.pChar = this.getCharAt(this.prevStr, this.pPos);
                strBuff.append(this.pChar);
                ++this.pPos;
                if (this.pPos >= this.prevStr.length()) break block3;
            } while (this.pChar != '\'');
            return new GaussSQLToken(4, strBuff.toString(), currPos);
        }
        strBuff = new StringBuffer("'");
        this.pPos = currPos + 1;
        return new GaussSQLToken(4, strBuff.toString(), currPos);
    }

    private GaussSQLToken parseSlash(int currPos) {
        ++this.pPos;
        if (this.pPos >= this.prevStr.length()) {
            return new GaussSQLToken(1, "/", currPos);
        }
        char ch2 = this.prevStr.charAt(this.pPos);
        if (ch2 != '*' && ch2 != '/') {
            return new GaussSQLToken(1, "/", currPos);
        }
        ++this.pPos;
        this.pChar = this.getCharAt(this.prevStr, this.pPos);
        int count = 1;
        int singlequotecount = 0;
        StringBuffer sb = new StringBuffer("/*");
        while (true) {
            char ch0 = this.pChar;
            this.pChar = this.getCharAt(this.prevStr, this.pPos);
            sb.append(this.pChar);
            ++this.pPos;
            if (this.pChar == '\'') {
                singlequotecount = 1 - singlequotecount;
            }
            if (ch0 == '*' && this.pChar == '/' && singlequotecount == 0) {
                return new GaussSQLToken(5, sb.toString(), currPos);
            }
            if (ch0 == '/' && this.pChar == '*') {
                ++count;
                continue;
            }
            if (ch0 == '*' && this.pChar == '/' && --count == 0) break;
        }
        return new GaussSQLToken(5, sb.toString(), currPos);
    }

    private GaussSQLToken parseHypen(int currPos, char ch2) {
        if (this.pChar == '-' && ch2 == '-') {
            ++this.pPos;
            StringBuffer sb = new StringBuffer("--");
            if (this.pPos >= this.prevStr.length()) {
                return new GaussSQLToken(5, sb.toString(), currPos);
            }
            do {
                this.pChar = this.prevStr.charAt(this.pPos);
                sb.append(this.pChar);
                ++this.pPos;
            } while (this.pChar != '\n' && this.pPos < this.prevStr.length());
            return new GaussSQLToken(5, sb.toString(), currPos);
        }
        return new GaussSQLToken(1, "-", currPos);
    }

    private GaussSQLToken parseLetter(int currPos) {
        StringBuffer sb = new StringBuffer();
        if (this.pChar == '$' && this.getCharAt(this.prevStr, this.pPos + 1) == 'q' && this.getCharAt(this.prevStr, this.pPos + 2) == '$') {
            boolean flag = false;
            while (true) {
                this.pChar = this.getCharAt(this.prevStr, this.pPos);
                sb.append(this.pChar);
                ++this.pPos;
                if (this.pChar == '$' && this.getCharAt(this.prevStr, this.pPos) == 'q' && this.getCharAt(this.prevStr, this.pPos + 1) == '$' && flag) {
                    sb.append("q$");
                    this.pPos += 2;
                    return new GaussSQLToken(4, sb.toString(), currPos);
                }
                flag = true;
            }
        }
        while (GaussSQLParser.isLetter(this.pChar) || Character.isDigit(this.pChar) || this.pChar == '.') {
            sb.append(this.pChar);
            ++this.pPos;
            if (this.pPos >= this.prevStr.length()) break;
            this.pChar = this.prevStr.charAt(this.pPos);
        }
        for (int iIndex = 0; iIndex < GaussSQLConstants.SQL_RESERVED_WORDS.length; ++iIndex) {
            if (sb.toString().compareToIgnoreCase(GaussSQLConstants.SQL_RESERVED_WORDS[iIndex]) != 0) continue;
            return new GaussSQLToken(2, sb.toString(), currPos);
        }
        return new GaussSQLToken(3, sb.toString(), currPos);
    }

    public List<IGaussAbstractToken> parseSQL(String sqlStmt) {
        this.pPos = 0;
        this.prevStr = sqlStmt;
        ArrayList<IGaussAbstractToken> list = new ArrayList<IGaussAbstractToken>(10);
        while (true) {
            IGaussAbstractToken token;
            if ((token = this.tokenChecker()).getTokenType() == 4 && list.size() > 2) {
                IGaussAbstractToken newToken = (IGaussAbstractToken)list.get(list.size() - 1);
                if (newToken.getTokenString().equals("q")) {
                    newToken.setTokenType(4);
                    String strVal = token.getTokenString();
                    strVal = "q" + strVal;
                    token.setTokenString(strVal);
                    list.remove(list.size() - 1);
                }
            } else if (token.getTokenType() == 6) break;
            list.add(token);
        }
        return list;
    }

    private static boolean isQSymbolOracle(char argChar) {
        switch (argChar) {
            case '!': 
            case '\"': 
            case '#': 
            case '$': 
            case '\'': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '_': 
            case '`': 
            case '{': 
            case '|': 
            case '}': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    private char getCharAt(String str, int index) {
        if (index >= 0 && index < str.length()) {
            return str.charAt(index);
        }
        throw new MigrationServiceException("invalid index value specified for charAt");
    }
}

