/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.teradata;

import com.huawei.db.migration.util.ColumnSplitter;
import com.huawei.db.migration.util.ErrorLoggerUtility;
import com.huawei.db.migration.util.FeatureLoader;
import com.huawei.db.migration.util.FeatureLoaderExtended;
import com.huawei.db.migration.util.IGaussDBConstants;
import com.huawei.db.migration.util.InterruptCharSequence;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TeradataBteqHandler {
    private static final Logger logger = LogManager.getLogger(TeradataBteqHandler.class);
    public static final String VAR_EXIST = "lv_mig_obj_exists_check";
    public static final String VAR_ERROR_CODE = "lv_mig_errorcode";
    public static final String VAR_ACTIVITY_COUNT = "lv_mig_activitycount";
    private static final String PAT_SET_END = "(?i)\\.\\.\\s*SET\\s+(\\w+)\\s+(.*?)\\.\\.\\s*END";
    private static final int ERROR_CODE = 3807;
    private static final String PAT_SELECT_FROM = "(?:\\s+FROM(?!\\s{1,10}\\()\\s+(.*?)";
    private static final String PAT_SELECT_FROM_MATCHING = "(?:(?:\\sINNER|\\sLEFT|\\sWHERE)\\s.*?(?:;|\\)\\s*LOOP)|\\).*?;|;)";
    private static final String PAT_ACTIVITY_COUNT = "(?i).*\\.IF\\s+ACTIVITYCOUNT(?!\\w).*";
    private static final String PAT_UNDEFINED_TABLE = "(?i).*\\.IF\\s+ERRORCODE\\s*(?:=|<|>|<>|>=|<=)\\s*(3807).*";
    private static final String PAT_BTEQ_CMD = "(?i)\\.(?<!\\w)(GOTO|QUIT|LOGOFF|RETURN)(?!\\w)\\s*(\\w*)\\s*[;]?";
    private static final String PAT_BTEQ = "(?i)(?:\\.\\.?for\\s+)?((?:EXECUTE\\s+IMMEDIATE\\s+\\$q\\$)?(?:\\/\\*LOCKING\\s+ROW\\s+FOR\\s+ACCESS\\s*\\*\\/)?(?:SELECT|UPDATE|INSERT|CREATE|DELETE|ALTER|MERGE)(?:(?!\\.\\.).)*?;\\s*(?:\\**\\s*)?(?:#S#\\d+#E#\\s*)*)*(?:\\.\\.?DO\\s+\\@\\@(?:\\$\\{.*?\\}|\\w+).*?)?((?:\\.IF\\s+(?:\\w+)\\s*(?:=|<|>|<>|>=|<=)\\s*(\\'?\\w*\\'?|##QUOTE##\\d+#)\\s+THEN\\s+(?i)\\.(?<!\\w)(GOTO|QUIT|LOGOFF|RETURN)(?!\\w)\\s*(\\w*)\\s*[;]?\\s*(?:#S#\\d+#E#\\s*)*)+)";
    private static final Pattern SELQRY = Pattern.compile("(?i)((?:INSERT\\s+INTO|DELETE\\s+FROM|CREATE\\s+LOCAL).*?)?(SELECT.*?)?(;|\\)\\s*LOOP)");
    private static final Pattern INSERT_PAT = Pattern.compile("(?i)((?:INSERT\\s+INTO|DELETE\\s+FROM).*?)?(?:SELECT.*?)?INTO(.*?)?(?:(?:\\s+(FROM(?!\\s{1,10}\\()\\s+.*?)(?:(?:\\sINNER|\\sLEFT|\\sWHERE)\\s.*?(?:;|\\)\\s*LOOP)|\\).*?;|;))|;)");
    private static final Pattern SEL_INTO = Pattern.compile("(?i)(?<!\\w)select(?!\\w)(.*?)(?<!\\w)into(?!\\w)(.*?);");
    private static final Pattern ORDER_BY = Pattern.compile("(?i)(?<!\\w)(order\\s+by.*?);");
    private static final Pattern PRINT_BTEQ_PAT = Pattern.compile("(?i)print\\s+BTEQ\\s*<<\\s*ENDOFINPUT\\s*.*?close\\s*\\(.*?\\)\\s*;");
    private static final Pattern MY_PAT = Pattern.compile("(?i)\\s*my\\s*\\$\\w+\\s*=\\s*<\\s*<(\\w+);");
    private static final Pattern EXPORT_PAT = Pattern.compile("(?i)\\.\\s*export\\s+file\\s*\\=?\\s*(.*?);");
    private static final Pattern SELECT_FROM_PAT = Pattern.compile("(?i)select(.*?)from");
    private static final Pattern COMMENT_PAT = Pattern.compile("(?i)(#S#\\d+#E#\\s*)+");
    private static final Pattern SEL_QRY = Pattern.compile("(?i)\\.\\.?for\\s+(?:set|select)(.*?)from");
    private static final Pattern OTHER_SELECT_PAT = Pattern.compile("(?i)((?:^|INSERT|UPDATE|DELETE|CREATE|;|\\s(?!\\())(?:.*?))SELECT(.*?)(;|FROM|WHERE)");
    private static final Pattern INSERT_INTO_PAT = Pattern.compile("(?i)(?<!\\$)INSERT\\s+INTO\\s+(.*?);", 40);
    private static final Pattern UPDATE_PAT = Pattern.compile("(?i)(?<!\\$)UPDATE\\s+(.*?);", 40);
    private static final Pattern UPDATE_SET_PAT = Pattern.compile("(?i)(?<!\\$)UPDATE\\s+(.*?)SET.*?;", 40);
    private static final Pattern DELETE_FROM_PAT = Pattern.compile("(?i)(?<!\\$)DELETE\\s+FROM\\s+(.*?);", 40);
    private static final Pattern DROP_TABLE_PAT = Pattern.compile("(?i)(?<!\\$)DROP\\s+TABLE\\s+(.*?);");
    private static final Pattern CREATE_TABLE_PAT = Pattern.compile("(?i)CREATE\\s+(?:.*?)\\s+TABLE\\s+(.*?);", 40);
    private static final Pattern ACTIVITY_COUNT_PAT = Pattern.compile("(?i)(?<!\\w)\\$(ACTIVITYCOUNT(?:1|2))(?!\\w)");
    private static final String PAT_IF = "(?i)(?:\\.IF\\s+(\\'?\\w+\\'?)\\s*(=|<|>|<>|>=|<=)\\s*(\\'?\\w*\\'?|##QUOTE##\\d+#)\\s+THEN\\s+(?i)\\.(?<!\\w)(GOTO|QUIT|LOGOFF|RETURN)(?!\\w)\\s*(\\w*)\\s*[;]?\\s*((#S#\\d+#E#\\s*)*))";
    private static final String PAT_PRINT_BTEQ = "(?i)print\\s+BTEQ\\s*<<\\s*ENDOFINPUT\\s*;";
    private static final String PAT_END_CLOSE = "(?i)ENDOFINPUT.*?CLOSE\\s*\\(\\s*BTEQ\\s*\\)\\s*;";
    private static final String VARIABLE_PREFIX = "lv_mig_";
    private static final String SEMICOLON_SPACE = "; ";
    private static final String RETURN = "RETURN ;";
    private static final String RAISE_EXCEPTION = "RAISE EXCEPTION ";
    private boolean dsqlSupport = false;
    private boolean startWithSel = false;
    private boolean varFound = false;
    private String inputTemp;
    private ArrayList<String> columnsArray = new ArrayList(10);
    private ArrayList<String> prefixArray = new ArrayList(10);
    private int currentIndex = 0;
    private StringBuffer outputBuff;
    private String lVariable;
    private boolean viewTableBase;

    public String doBteqProcess(String input) {
        String inputSql = input.replaceAll("(?<!\\w)(DAY|MONTH|YEAR)(?!\\w)\\s+FROM", "$1 ~DT~SB~PTRN~");
        this.dsqlSupport = FeatureLoader.getBooleanProperty("dsqlSupport");
        inputSql = this.performActivityCountMigration(inputSql);
        inputSql = inputSql.replace(IGaussDBConstants.NEW_LINE, "");
        Matcher matcher = PRINT_BTEQ_PAT.matcher(inputSql);
        StringBuffer output = new StringBuffer(128);
        if (inputSql.matches("(?i).*print\\s+BTEQ\\s*<<\\s*ENDOFINPUT.*")) {
            while (matcher.find()) {
                inputSql = matcher.group();
                this.processBteqBlock(inputSql, output);
            }
        } else if (inputSql.matches("(?i).*my\\s*\\$\\w+\\s*=\\s*<\\s*<\\w+;.*")) {
            this.doSqlLangProcess(inputSql, output);
        } else {
            this.processBteqBlock(inputSql, output);
        }
        return output.toString();
    }

    private void doSqlLangProcess(String input, StringBuffer buffer) {
        String output = input;
        Matcher matcher = MY_PAT.matcher(output);
        while (matcher.find()) {
            String header = matcher.group();
            String sqlLangTag = matcher.group(1);
            int startIndex = matcher.start() + header.length();
            int index = input.indexOf(sqlLangTag, startIndex);
            String block = "";
            block = index != -1 ? input.substring(startIndex, index) : input.substring(startIndex);
            this.outputBuff = new StringBuffer();
            this.outputBuff.append(header);
            LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
            output = this.doProcessBteqIf(block, quoteMap);
            this.outputBuff.append(output);
            this.outputBuff.append(sqlLangTag);
            output = QueryConversionUtility.getRplFromMap(this.outputBuff.toString(), quoteMap, "(##QUOTE##\\d+#)");
            this.outputBuff.setLength(0);
            buffer.append(output);
            quoteMap.clear();
        }
    }

    private void processBteqBlock(String input, StringBuffer sb) {
        Matcher matcher;
        String output = input;
        this.outputBuff = new StringBuffer(128);
        if (output.matches("(?i).*(?i)print\\s+BTEQ\\s*<<\\s*ENDOFINPUT\\s*;.*")) {
            output = output.replaceAll(PAT_PRINT_BTEQ, "");
            this.outputBuff.append("PRINT BTEQ << ENDOFINPUT ; ");
        }
        String endofclose = "";
        if (output.matches("(?i).*(?i)ENDOFINPUT.*?CLOSE\\s*\\(\\s*BTEQ\\s*\\)\\s*;.*") && (matcher = Pattern.compile(PAT_END_CLOSE).matcher(output)).find()) {
            endofclose = matcher.group();
            output = output.replaceAll(PAT_END_CLOSE, "");
        }
        LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
        output = this.doProcessBteqIf(output, quoteMap);
        output = output + endofclose;
        output = this.replaceBteqCmd(output);
        output = this.processDoubleDotFunction(output);
        sb.append(QueryConversionUtility.getRplFromMap(output, quoteMap, "(##QUOTE##\\d+#)"));
        quoteMap.clear();
    }

    private String doProcessBteqIf(String input, Map<String, String> quoteMap) {
        String inputSql = input;
        String inputQry = input;
        inputSql = inputSql.replaceAll("(?i)\\.for\\s+set", ".FOR SELECT");
        inputQry = input.replaceAll("(?i)\\.for\\s+set", ".FOR SELECT");
        if (input.matches("(?i).*\\.IF\\s+.*")) {
            this.getQryForIf(quoteMap, inputQry);
        } else {
            this.outputBuff.append(inputQry);
        }
        inputSql = this.doLoopToExecute(this.outputBuff);
        if (!this.startWithSel) {
            inputSql = inputSql.replaceAll("(?i)lv_mig_obj_exists_check\\s+number\\s*\\(\\s*1\\s*\\)\\s*\\;", "");
        }
        this.outputBuff.setLength(0);
        inputSql = inputSql.replaceAll("(?i)(EXCEPTION.*?END\\s*;\\s*IF.*?END\\s+IF;\\s+\\.\\.\\s*IF\\s+)(ACTIVITYCOUNT)", "lv_mig_activitycount := SQL%ROWCOUNT ; $1 lv_mig_activitycount");
        return inputSql;
    }

    public void getQryForIf(Map<String, String> quoteMap, String input) {
        String inputQry = input;
        inputQry = this.processDotDotIfBlock(inputQry);
        this.outputBuff.append(this.getDeclareBlock(inputQry));
        String inputSql = this.doProcessVariable(inputQry);
        this.outputBuff.append(" BEGIN ");
        inputSql = QueryConversionUtility.getSingleDoubleQuoteMap(inputSql, quoteMap);
        Pattern pattern = Pattern.compile(PAT_BTEQ);
        Matcher matcher = pattern.matcher(inputSql);
        int endIndex = 0;
        int qryIdx = 0;
        int ifIdx = 0;
        boolean doLoop = false;
        while (matcher.find()) {
            int startIndex = matcher.start(1);
            qryIdx = matcher.end(1);
            ifIdx = matcher.start(2);
            String query = matcher.group(1);
            if (startIndex != -1) {
                if (!matcher.group(0).matches("(?i).*\\.\\s*for(?!\\w).*")) {
                    this.outputBuff.append(inputSql.substring(endIndex, startIndex));
                } else if (this.dsqlSupport) {
                    this.outputBuff.append(inputSql.substring(endIndex, startIndex).replaceAll("(?i)\\.\\.\\s*FOR(?!\\w)", ""));
                    doLoop = true;
                    query = this.getOutForLoop(this.outputBuff, query, matcher);
                    this.outputBuff.append(inputSql.substring(qryIdx, ifIdx));
                }
                String bteqCmd = matcher.group(2);
                boolean hasActivityCount = bteqCmd.matches(PAT_ACTIVITY_COUNT);
                boolean hasUndefinedTable = bteqCmd.matches(PAT_UNDEFINED_TABLE);
                this.outputBuff.append(this.getQueryBlock(query, hasActivityCount, hasUndefinedTable, doLoop));
                this.handleEndFor(matcher);
                if (inputSql.matches("(?i).*\\.export(?!\\w).*")) {
                    this.appendOutputForExport(this.outputBuff, inputSql, EXPORT_PAT, query);
                }
                this.outputBuff.append(this.getBteqBlock(inputQry, bteqCmd));
            } else {
                this.commentUnsupported(inputSql, this.outputBuff, matcher, endIndex);
            }
            endIndex = matcher.end();
        }
        this.getAppendedBuf(this.outputBuff, inputSql, endIndex);
        this.addQuoteToLvVariable(quoteMap);
    }

    private void handleEndFor(Matcher matcher) {
        if (matcher.group().matches("(?i).*\\.\\.\\s*end-for(?!\\w).*")) {
            this.outputBuff.append("END LOOP;");
            String inpSql = this.outputBuff.toString().replaceAll("(?i)\\.\\.?end\\s*\\-\\s*for", "");
            this.outputBuff.setLength(0);
            this.outputBuff.append(inpSql);
        }
    }

    public void getAppendedBuf(StringBuffer outputBuffer, String inputSql, int endIndex) {
        outputBuffer.append(inputSql.substring(endIndex));
        outputBuffer.append(" END; /");
    }

    public String doLoopToExecute(StringBuffer outputBuffer) {
        String inputSql = outputBuffer.toString();
        inputSql = inputSql.replaceAll("(?i)(?:\\.\\.?do)?\\s+\\@\\@\\$\\s*\\{(.*?)\\}\\@\\@", " EXECUTE IMMEDIATE lv_mig_$1;");
        if (this.dsqlSupport) {
            inputSql = inputSql.replaceAll("(?i)\\.\\.?end\\s*\\-\\s*for", "END LOOP;");
        }
        inputSql = inputSql.replaceAll("(?i)\\.\\s*export\\s+file\\s*\\=?\\s*.*?;", "");
        return inputSql;
    }

    public String getOutForLoop(StringBuffer outputBuffer, String qry, Matcher matcher) {
        String query = qry;
        ColumnSplitter split = new ColumnSplitter();
        Matcher col = SELECT_FROM_PAT.matcher(query);
        outputBuffer.append("FOR rec IN ( ").append(query.replace(";", "")).append(" ) ").append("LOOP BEGIN ");
        if (col.find()) {
            List<String> colWithAlias = split.doGetAllColumns(col.group(1));
            List<String> colName = QueryConversionUtility.getColList(colWithAlias);
            List<String> alias = QueryConversionUtility.doGetAliasList(colWithAlias);
            for (int i = 0; i < colName.size() && i < alias.size(); ++i) {
                outputBuffer.append(VARIABLE_PREFIX).append(alias.get(i)).append(" := rec.").append(alias.get(i)).append(";");
            }
        }
        query = "";
        return query;
    }

    public void appendOutputForExport(StringBuffer outputBuffer, String inputSql, Pattern exportPat, String query) {
        String fileName = "";
        Matcher expMatcher = exportPat.matcher(inputSql);
        if (expMatcher.find()) {
            fileName = expMatcher.group(1);
        }
        outputBuffer.append("EXECUTE $q$COPY (").append(query).append(" ) TO '").append(fileName).append("' CSV HEADER DELIMITER E'\t'$q$;");
    }

    private void commentUnsupported(String input, StringBuffer outputBuffer, Matcher matcher, int endIndex) {
        int matchStartIndex = matcher.start(2);
        String match = input.substring(endIndex, matchStartIndex);
        outputBuffer.append(match);
        match = input.substring(matchStartIndex, matcher.end());
        Matcher matcherComment = COMMENT_PAT.matcher(match);
        int commentStartIndex = -1;
        if (matcherComment.find()) {
            commentStartIndex = matcherComment.start();
        }
        if (commentStartIndex != -1) {
            String statement = match.substring(0, commentStartIndex);
            this.commentStatement(outputBuffer, statement);
            outputBuffer.append(" ").append(match.substring(commentStartIndex));
        } else {
            this.commentStatement(outputBuffer, match);
        }
    }

    private void commentStatement(StringBuffer outputBuffer, String match) {
        outputBuffer.append("/*").append(match).append("*/");
    }

    private String getDeclareBlock(String input) {
        boolean hasActivityCount = input.matches(PAT_ACTIVITY_COUNT);
        StringBuffer output = new StringBuffer(128);
        output.append("DECLARE ").append(VAR_EXIST).append(" NUMBER(1); ").append(VAR_ERROR_CODE).append(" NUMBER(4); ");
        if (hasActivityCount) {
            output.append(VAR_ACTIVITY_COUNT).append(" NUMBER(6); ");
        }
        output.append("lv_mig_view_basetable TEXT;");
        if (input.matches("(?i).*\\.\\.\\s*FOR(?!\\w).*")) {
            output.append("rec RECORD;");
        }
        this.declareForLoop(input, output);
        return output.toString();
    }

    private void declareForLoop(String input, StringBuffer output) {
        if (QueryConversionUtility.containsCheck(input, ".for")) {
            Matcher selQryMatch = SEL_QRY.matcher(input);
            String cols = "";
            if (selQryMatch.find()) {
                cols = selQryMatch.group(1);
                ColumnSplitter splitter = new ColumnSplitter();
                List<String> columnList = splitter.doGetAllColumns(cols);
                List<String> aliasList = QueryConversionUtility.doGetAliasList(columnList);
                for (int i = 0; i < aliasList.size() && i < columnList.size(); ++i) {
                    String aliasTrim = aliasList.get(i).trim();
                    output.append(VARIABLE_PREFIX).append(aliasTrim).append(" TEXT ").append(";");
                }
            }
        }
    }

    private String getQueryBlock(String query, boolean hasActivityCount, boolean hasUndefinedTable, boolean doLoop) {
        boolean startsWithQuery;
        String tempQuery = query;
        StringBuffer outputBuffer = new StringBuffer(128);
        boolean bl = startsWithQuery = tempQuery.matches("(?i)(?:(?:(?:(?:\\/\\*LOCKING\\s+ROW\\s+FOR\\s+ACCESS\\s*\\*\\/)SELECT(?!\\w).*))|(?:^SELECT(?!\\w).*))") && !QueryConversionUtility.containsCheck(query, " INTO ");
        if (!doLoop) {
            outputBuffer.append("BEGIN ");
        }
        if (startsWithQuery) {
            this.startWithSel = true;
            outputBuffer.append("SELECT COUNT(*) INTO ").append(VAR_EXIST).append(" FROM ( ");
            tempQuery = tempQuery.replace(";", "");
        }
        outputBuffer.append(tempQuery);
        if (startsWithQuery) {
            outputBuffer.append(" ) LIMIT 1; ");
        }
        outputBuffer.append(VAR_ERROR_CODE).append(" := 0; ");
        if (hasActivityCount) {
            outputBuffer.append(VAR_ACTIVITY_COUNT).append(" := ").append(startsWithQuery ? VAR_EXIST : "SQL%ROWCOUNT").append(SEMICOLON_SPACE);
        }
        outputBuffer.append("EXCEPTION ");
        if (hasUndefinedTable) {
            outputBuffer.append("WHEN UNDEFINED_TABLE THEN ").append(VAR_ERROR_CODE).append(" := ").append(3807).append(SEMICOLON_SPACE);
        }
        outputBuffer.append("WHEN OTHERS THEN ").append(VAR_ERROR_CODE).append(" := -1; ").append("END; ");
        return outputBuffer.toString();
    }

    private String getBteqBlock(String input, String bteqCmd) {
        StringBuffer outputBuffer = new StringBuffer(128);
        Pattern pattern = Pattern.compile(PAT_IF);
        Matcher matcher = pattern.matcher(bteqCmd);
        int endIndex = 0;
        while (matcher.find()) {
            this.getBufTillNextMatch(bteqCmd, outputBuffer, endIndex, matcher);
            String command = matcher.group(1);
            String operator = matcher.group(2);
            String errorCode = matcher.group(3);
            String gotoQuit = matcher.group(4);
            String label = matcher.group(5);
            String comment = matcher.group(6);
            String condition = operator + " " + errorCode;
            outputBuffer.append(this.processCommand(input, command, condition, gotoQuit, label));
            if (comment != null) {
                outputBuffer.append(" ").append(comment).append(" ");
            }
            endIndex = matcher.end();
        }
        outputBuffer.append(bteqCmd.substring(endIndex));
        return outputBuffer.toString();
    }

    private String processCommand(String input, String command, String condition, String gotoQuit, String label) {
        StringBuffer outputBuffer = new StringBuffer(128);
        String variable = this.getVariableName(command);
        outputBuffer.append("IF ").append(variable).append(condition).append(" THEN ");
        outputBuffer.append(this.handleConditionalCommand(input, gotoQuit, label));
        outputBuffer.append("END IF;");
        return outputBuffer.toString();
    }

    private String getVariableName(String command) {
        String variable = command;
        if ("ERRORCODE".equalsIgnoreCase(command)) {
            variable = VAR_ERROR_CODE;
        } else if ("ACTIVITYCOUNT".equalsIgnoreCase(command)) {
            variable = VAR_ACTIVITY_COUNT;
        }
        return variable;
    }

    private String replaceBteqCmd(String input) {
        String output = input;
        Pattern patternCmd = Pattern.compile(PAT_BTEQ_CMD);
        Matcher matcherCmd = patternCmd.matcher(input);
        while (matcherCmd.find()) {
            String gotoQuit = matcherCmd.group(1);
            String label = matcherCmd.group(2);
            String retValue = this.handleConditionalCommand(output, gotoQuit, label);
            output = output.replace(matcherCmd.group(), retValue);
        }
        output = output.replaceAll("(?i)\\.LABEL\\s+(\\w+)\\s*[;]?", "<<$1>>");
        output = output.replaceAll("(?i)(?<!\\w)(FOR\\s+SESSION)(?!\\w)", "/* $1 */");
        return output;
    }

    private String handleConditionalCommand(String input, String gotoQuit, String label) {
        String quoteCode = null;
        StringBuffer outputBuffer = new StringBuffer(128);
        if ("QUIT".equalsIgnoreCase(gotoQuit)) {
            int errorCode = this.isNumber(label);
            switch (errorCode) {
                case 0: {
                    outputBuffer.append(RETURN).append(" ");
                    break;
                }
                case -1: {
                    quoteCode = "'%', " + label;
                    outputBuffer.append(RAISE_EXCEPTION).append(quoteCode).append(SEMICOLON_SPACE);
                    break;
                }
                default: {
                    quoteCode = "'" + errorCode + "'";
                    outputBuffer.append(RAISE_EXCEPTION).append(quoteCode).append(SEMICOLON_SPACE);
                    break;
                }
            }
        } else if ("GOTO".equalsIgnoreCase(gotoQuit)) {
            if (input.matches("(?i).*\\.LABEL\\s+" + label + "(?!\\w).*")) {
                outputBuffer.append("GOTO ").append(label).append(SEMICOLON_SPACE);
            } else {
                outputBuffer.append(RAISE_EXCEPTION).append("'-1'").append(SEMICOLON_SPACE);
            }
        } else if ("LOGOFF".equalsIgnoreCase(gotoQuit)) {
            outputBuffer.append(RAISE_EXCEPTION).append("'-99'").append(SEMICOLON_SPACE);
        } else {
            outputBuffer.append(RETURN);
        }
        return outputBuffer.toString();
    }

    private int isNumber(String label) {
        int retValue = -1;
        try {
            if (label != null && !label.isEmpty()) {
                if (label.matches("\\s*\\d+\\s*")) {
                    retValue = Integer.parseInt(label.trim());
                }
            } else {
                retValue = 0;
            }
        }
        catch (NumberFormatException e) {
            logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " Error in BTEQ number parsing.");
        }
        return retValue;
    }

    private String doProcessVariable(String input) {
        String inputStr = input;
        inputStr = inputStr.replaceAll("(?i)(EXTRACT\\s*\\(\\s*\\'?\\w+\\'?\\s+)FROM", "$1#EX#FR##");
        inputStr = inputStr.replaceAll("(?i)(Where(?:(?<!;).)*?)(?<!\\w)SELECT(?!\\w)(.*?;)", "$1#S#E#L##$2");
        Matcher matcher = OTHER_SELECT_PAT.matcher(inputStr);
        while (matcher.find()) {
            String queryPrefix = matcher.group(1);
            int index = queryPrefix.lastIndexOf(59);
            queryPrefix = index != -1 ? queryPrefix.substring(index) : queryPrefix;
            this.prefixArray.add(queryPrefix);
            this.columnsArray.add(matcher.group(2));
        }
        for (int iIndex = 0; iIndex < this.columnsArray.size() && iIndex < this.prefixArray.size(); ++iIndex) {
            this.currentIndex = iIndex;
            String queryPrefix = this.prefixArray.get(iIndex);
            String columns = this.columnsArray.get(iIndex);
            ColumnSplitter splitter = new ColumnSplitter();
            List<String> columnList = splitter.doGetAllColumns(columns);
            inputStr = this.doProcessAlias(inputStr, columns, columnList, queryPrefix);
        }
        inputStr = inputStr.replaceAll("#EX#FR##", "FROM");
        inputStr = inputStr.replaceAll("#S#E#L##", "SELECT");
        this.columnsArray.clear();
        this.prefixArray.clear();
        return inputStr;
    }

    private String doProcessAlias(String input, String columns, List<String> columnList, String queryPrefix) {
        this.inputTemp = input;
        StringBuffer colSb = new StringBuffer(" ");
        StringBuffer aliasSb = new StringBuffer(" ");
        StringBuffer lVar = new StringBuffer();
        boolean insertQuery = queryPrefix.matches("(?i).*(?<!\\w)(INSERT|CREATE)(?!\\w).*");
        this.varFound = false;
        int index = input.indexOf(columns) + columns.length();
        List<String> aliasList = QueryConversionUtility.doGetAliasList(columnList);
        String output = input.substring(index);
        for (int iIndex = 0; iIndex < aliasList.size() && iIndex < columnList.size(); ++iIndex) {
            String column = columnList.get(iIndex);
            String aliasTrim = aliasList.get(iIndex).trim();
            String col = columnList.get(iIndex).replaceFirst("(?i)\\s+AS\\s+" + Pattern.quote(aliasList.get(iIndex)), "");
            if (aliasTrim.matches("\\w+") && !aliasTrim.matches("(?<!\\w)columnalias\\d+(?!\\w)") && (!column.equals(aliasTrim) || "SESSION".equalsIgnoreCase(aliasTrim))) {
                this.lVariable = this.getDeclareLvVar(aliasTrim);
                String temp = this.convertVariables(insertQuery, output, aliasTrim, iIndex, columnList);
                output = this.replaceLVariable(aliasSb, lVar, temp, aliasTrim);
            }
            colSb.append(col).append(", ");
        }
        if (this.varFound) {
            this.updateInputTemp(columns, colSb, aliasSb);
            if (!this.outputBuff.toString().matches(".*(?<!\\w)" + this.lVariable + "(?!\\w).*")) {
                this.outputBuff.append(lVar.toString());
            }
        } else if (this.outputBuff.toString().matches(".*(?<!\\w)" + this.lVariable + "(?!\\w).*") && aliasSb.length() > 2 && !this.inputTemp.matches("(?i).*\\.\\.\\s*FOR(?!\\w).*")) {
            this.updateInputTemp(columns, colSb, aliasSb);
        }
        colSb.setLength(0);
        return this.inputTemp;
    }

    private void updateInputTemp(String columns, StringBuffer colSb, StringBuffer aliasSb) {
        String cols = colSb.substring(0, colSb.length() - 2) + " INTO " + aliasSb.substring(0, aliasSb.length() - 2);
        this.inputTemp = this.inputTemp.replaceAll("(?i)(FOR)\\s+(SES)(SION)", "__$1__$2__$3__");
        if (columns.endsWith(" ")) {
            cols = cols + " ";
        }
        this.inputTemp = this.inputTemp.replace(columns, cols);
        this.inputTemp = this.inputTemp.replaceAll("(?i)__(FOR)__(SES)__(SION)__", "$1 $2$3");
    }

    private String convertVariables(boolean insertQuery, String input, String aliasTrim, int curIndex, List<String> columnList) {
        String output;
        String temp = output = input;
        if (!insertQuery && this.dsqlSupport) {
            temp = this.replaceAlias(output, aliasTrim);
        }
        Pattern dynPattern = Pattern.compile("(?i)\\\"?(?<!\\@)\\$\\s*\\{?(?<!\\w)(" + Pattern.quote(aliasTrim) + ")(?!\\w)\\}?\\s*\\\"?");
        Matcher dynMatcher = dynPattern.matcher(temp);
        while (dynMatcher.find()) {
            String variable = dynMatcher.group();
            String varGroup1 = dynMatcher.group(1);
            if (!varGroup1.trim().equals(aliasTrim) && !aliasTrim.matches("(?i)session")) break;
            this.varFound = true;
            temp = temp.replaceAll("\\'" + Pattern.quote(variable) + "\\'", "'" + this.lVariable + "'");
            temp = temp.replaceAll("(?<!\\')" + Pattern.quote(variable) + "(?<!\\')", " " + this.lVariable + " ");
            if (!insertQuery) {
                temp = QueryConversionUtility.replaceAll(temp, this.getLvVarRegex(aliasTrim, true, true), this.lVariable);
            }
            this.inputTemp = this.inputTemp.replace(output, temp);
            this.updateColumnsArray(aliasTrim, this.lVariable, variable);
            output = temp;
        }
        this.updateColumnList(insertQuery, aliasTrim, curIndex, columnList, this.lVariable);
        if ("SESSION".equalsIgnoreCase(aliasTrim)) {
            this.inputTemp = QueryConversionUtility.replaceAll(this.inputTemp, this.getLvVarRegex(aliasTrim, true, false), "pg_backend_pid() INTO " + this.lVariable);
        }
        return temp;
    }

    private void updateColumnList(boolean insertQuery, String aliasTrim, int curIndex, List<String> columnList, String lVariable) {
        for (int colIndex = curIndex + 1; colIndex < columnList.size(); ++colIndex) {
            String col;
            String retCol = col = columnList.get(colIndex);
            if (!insertQuery) {
                retCol = QueryConversionUtility.replaceAll(col, this.getLvVarRegex(aliasTrim, true, true), lVariable);
                retCol = this.replaceRegex(retCol, this.getLvVarRegex(aliasTrim, false, true), aliasTrim, lVariable);
            }
            if (retCol.equals(col)) continue;
            columnList.set(colIndex, retCol);
        }
    }

    private void updateColumnsArray(String aliasTrim, String lVariable, String variable) {
        for (int iIndex = this.currentIndex + 1; iIndex < this.columnsArray.size(); ++iIndex) {
            String col = this.columnsArray.get(iIndex);
            boolean insertQry = this.prefixArray.get(iIndex).matches("(?i).*(?<!\\w)(INSERT|CREATE)(?!\\w).*");
            String retCol = col;
            if (variable != null) {
                retCol = retCol.replaceAll("\\'" + Pattern.quote(variable) + "\\'", "'" + lVariable + "'");
                retCol = retCol.replaceAll("(?<!\\')" + Pattern.quote(variable) + "(?<!\\')", " " + lVariable + " ");
            }
            if (!insertQry) {
                retCol = QueryConversionUtility.replaceAll(retCol, this.getLvVarRegex(aliasTrim, true, true), lVariable);
            }
            if (retCol.equals(col)) continue;
            this.columnsArray.set(iIndex, retCol);
        }
    }

    private String replaceLVariable(StringBuffer aliasSb, StringBuffer lVar, String temp, String aliasTrim) {
        String replaceLVar = this.lVariable + " TEXT; ";
        if (!lVar.toString().contains(replaceLVar) && !this.outputBuff.toString().matches(".*(?<!\\w)" + this.lVariable + "(?!\\w).*")) {
            lVar.append(replaceLVar);
        }
        aliasSb.append(this.lVariable).append(", ");
        return temp;
    }

    private String replaceAlias(String input, String aliasTrim) {
        String inputStr = input.replaceAll("(?i)(\\.IF\\s+(?:(?:(?!THEN).)*?)(?<!\\w|\\$|\\$\\{|AS\\s|\\.|\\;))" + aliasTrim + "((?!\\w).*?THEN)", "$1\\$" + aliasTrim + "$2");
        return inputStr;
    }

    private String processDoubleDotFunction(String input) {
        String output = input;
        if (this.dsqlSupport && output.contains("..")) {
            output = output.replaceAll("(?i)\\.\\.\\s*IF(?!\\w)", "IF");
            output = output.replaceAll("(?i)\\.\\.\\s*END-IF(?!\\w)", "END IF;");
        }
        return output;
    }

    private String getDeclareLvVar(String aliasTrim) {
        String lvVar = aliasTrim.startsWith(VARIABLE_PREFIX) ? aliasTrim : VARIABLE_PREFIX + aliasTrim;
        String output = this.outputBuff.toString();
        if (output.matches("(?i).*(?<!\\w)" + lvVar + "(?!\\w).*") && !output.matches(".*(?<!\\w)" + lvVar + "(?!\\w).*")) {
            for (int iIndex = 1; iIndex < 1000; ++iIndex) {
                String var = lvVar + "_" + iIndex;
                if (output.matches("(?i).*(?<!\\w)" + var + "(?!\\w).*")) continue;
                lvVar = var;
                break;
            }
        }
        return lvVar;
    }

    private String getLvVarRegex(String aliasTrim, boolean includeAlias, boolean allSession) {
        String aliasRegex = includeAlias ? "\\s{1,10}(?i)AS\\s{1,10}|" : "";
        String sessionRegex = allSession && QueryConversionUtility.equalCheck("Session", aliasTrim) ? "|(?i)\\s{0,5}SELECT\\s{1,5}" : "";
        return "\\$?\\{?(?<!\\w|(?i)FOR\\s{1,10}|(?i)AS\\s{0,10}|\\@\\@\\$\\{" + sessionRegex + ")" + aliasTrim + "(?!\\w|" + aliasRegex + "\\s{0,10}=\\s{0,10})\\}?";
    }

    private String processDotDotIfBlock(String input) {
        String patDoubleIf = "(?i)((?:\\.\\.IF).*?\\.\\.END-IF\\s*(?:#S#\\d+#E#\\s*)*)((?:\\.IF\\s+(?:\\w+)\\s*(?:=|<|>|<>|>=|<=)\\s*('?\\w*'?|##QUOTE##\\d+#)\\s+THEN\\s+(?i)\\.(?<!\\w)(GOTO|QUIT|LOGOFF|RETURN)(?!\\w)\\s*(\\w*)\\s*[;]?))";
        Pattern pattern = Pattern.compile(patDoubleIf);
        Matcher matcher = pattern.matcher(input);
        int endIndex = 0;
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            int startIndex = matcher.start(2);
            sb.append(input.substring(endIndex, startIndex));
            String bteqCommand = matcher.group(2);
            sb.append(this.getBteqBlock(input, bteqCommand));
            endIndex = matcher.end(2);
        }
        sb.append(input.substring(endIndex));
        return sb.toString();
    }

    private String replaceRegex(String input, String regex, String aliasTrim, String replacement) {
        StringBuffer sb = new StringBuffer(128);
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(new InterruptCharSequence(input));
        int tempIndex = 0;
        while (matcher.find()) {
            int startIndex = matcher.start();
            int endIndex = matcher.end();
            String str = input.substring(tempIndex, startIndex);
            String match = matcher.group();
            sb.append(str);
            String endString = input.substring(endIndex, input.length());
            if (endString.matches("(?i)^\\s+(AS\\s+DATE)(?!\\w).*") || str.matches(".*(\\|)\\s*$")) {
                sb.append(replacement);
            } else {
                sb.append(match);
            }
            tempIndex = endIndex;
        }
        sb.append(input.substring(tempIndex));
        return sb.toString();
    }

    private String doSetEnd(String input) {
        String output = this.doProcessVariableSet(input);
        StringBuffer sb = new StringBuffer();
        Pattern pattern = Pattern.compile(PAT_SET_END);
        Matcher matcher = pattern.matcher(output);
        int endIndex = 0;
        StringBuffer varList = new StringBuffer();
        String dynPat = QueryConversionUtility.getLvVariableList(output, "(lv_mig_\\w+)\\s+(?:NUMBER\\(\\d\\)|TEXT)");
        while (matcher.find()) {
            this.getBufTillNextMatch(output, sb, endIndex, matcher);
            String variable = matcher.group(1);
            String lVar = this.getDeclareLvVar(variable);
            if (!(this.outputBuff.toString().matches(".*" + lVar + "\\s+TEXT\\s*;.*") || varList.toString().matches(".*" + lVar + "\\s+TEXT\\s*;.*") || output.matches(".*" + lVar + "\\s+TEXT\\s*;.*"))) {
                varList.append(lVar).append(" TEXT;");
            }
            sb.append(" ").append(lVar).append(" := ");
            String sql = matcher.group(2);
            sql = sql.replaceFirst(";\\s*$", "");
            sb.append(this.getQuotedString(dynPat, sql, true));
            sb.append(SEMICOLON_SPACE);
            endIndex = matcher.end();
        }
        sb.append(output.substring(endIndex));
        output = sb.toString();
        if (varList.length() > 0) {
            output = output.replaceAll("(DECLARE.*?)(?<!\\w)BEGIN(?!\\w)", "$1 " + varList.toString() + " BEGIN");
        }
        return output;
    }

    private String doProcessVariableSet(String input) {
        String output = input;
        Pattern pattern = Pattern.compile(PAT_SET_END);
        Matcher matcher = pattern.matcher(input);
        ArrayList<String> columnList = new ArrayList<String>(10);
        while (matcher.find()) {
            String column = matcher.group(1);
            column = column + " AS " + column;
            columnList.add(column);
            output = this.doProcessAlias(output, column, columnList, "");
            column = matcher.group(1);
            if (output.matches(".*\\.\\.\\s*SET\\s+" + column + "(?!\\w).*")) {
                output = output.replaceAll("(\\.\\.\\s*SET\\s+)" + column + "(?!\\w)", "$1lv_mig_" + column);
                if (this.outputBuff.length() == 0) {
                    this.outputBuff.append(VARIABLE_PREFIX + column + " TEXT;");
                }
            }
            columnList.clear();
            String outBuffStr = this.outputBuff.toString();
            if (this.outputBuff.length() > 0 && !output.contains(outBuffStr)) {
                output = output.replaceAll("(DECLARE.*?)(?<!\\w)BEGIN(?!\\w)", "$1 " + outBuffStr + " BEGIN");
            }
            this.outputBuff.setLength(0);
        }
        return output;
    }

    private String getQuotedString(String dynPat, String input, boolean trimPrefix) {
        Pattern pattern = Pattern.compile(dynPat);
        Matcher matcher = pattern.matcher(input);
        StringBuffer sb = new StringBuffer();
        if (trimPrefix) {
            sb.append("$q$");
        }
        int endIndex = 0;
        String endString = input;
        while (matcher.find()) {
            String endQuote;
            int startIndex = matcher.groupCount() == 0 ? matcher.start() : matcher.start(1);
            String prefix = input.substring(endIndex, startIndex);
            sb.append(prefix);
            String match = matcher.group();
            if (matcher.groupCount() == 0) {
                endIndex = matcher.end();
            } else {
                endIndex = matcher.end(1);
                match = matcher.group(1);
            }
            if (!prefix.trim().isEmpty()) {
                sb.append("$q$||");
            }
            String string = endQuote = (endString = input.substring(endIndex)).trim().isEmpty() || endString.matches("\\s*#S#\\d+#E#\\s*") ? "" : "||$q$";
            if (!match.startsWith("'") && match.endsWith("'")) {
                sb.append(match.substring(0, match.length() - 1)).append(endQuote).append("'");
                continue;
            }
            sb.append(match).append(endQuote);
        }
        if (!endString.trim().isEmpty()) {
            sb.append(endString);
            if (!endString.matches("\\s*#S#\\d+#E#\\s*")) {
                sb.append("$q$");
            }
        }
        return sb.toString();
    }

    public String addQuoteToInsert(String input, String dynPat) {
        Matcher matcher = INSERT_INTO_PAT.matcher(input);
        StringBuffer sb = new StringBuffer();
        int endIndex = 0;
        String dynPatMatch = ".*" + dynPat + ".*";
        while (matcher.find()) {
            this.getBufTillNextMatch(input, sb, endIndex, matcher);
            String insertQuery = matcher.group();
            Pattern insertPat = Pattern.compile("(?i)INSERT\\s+INTO\\s+(.*?)(?:\\((.*?)\\)|SELECT).*?(?:\\s+FROM(?!\\s{1,10}\\()\\s+(.*?)(?:(?:\\sINNER|\\sLEFT|\\sWHERE)\\s.*?(?:;|\\)\\s*LOOP)|\\).*?;|;)|VALUES.*?;|;)", 40);
            Matcher insertMatcher = insertPat.matcher(insertQuery);
            if (insertMatcher.find()) {
                boolean fCondition;
                String schema = insertMatcher.group(1);
                String columns = insertMatcher.group(2);
                String from = insertMatcher.group(3);
                boolean bl = fCondition = schema != null;
                if (fCondition) {
                    boolean tCondition;
                    boolean sCondition = schema.matches(dynPatMatch) || columns != null && columns.matches(dynPatMatch);
                    boolean bl2 = tCondition = from != null && from.matches(dynPatMatch);
                    if (sCondition || tCondition) {
                        this.addExecuteImmediate(dynPat, sb, insertQuery, schema);
                    } else {
                        sb.append(matcher.group());
                    }
                } else {
                    sb.append(matcher.group());
                }
            } else {
                sb.append(matcher.group());
            }
            endIndex = matcher.end();
        }
        sb.append(input.substring(endIndex));
        return sb.toString();
    }

    public String addQuoteToUpdate(String input, String dynPat) {
        Matcher matcher = UPDATE_PAT.matcher(input);
        StringBuffer sb = new StringBuffer();
        int endIndex = 0;
        String dynPatMatch = ".*" + dynPat + ".*";
        while (matcher.find()) {
            this.getBufTillNextMatch(input, sb, endIndex, matcher);
            String insertQuery = matcher.group();
            Matcher insertMatcher = UPDATE_SET_PAT.matcher(insertQuery);
            if (insertMatcher.find()) {
                String schema = insertMatcher.group(1);
                if (schema.matches(dynPatMatch)) {
                    this.addExecuteImmediate(dynPat, sb, insertQuery, schema);
                } else {
                    sb.append(matcher.group());
                }
            } else {
                sb.append(matcher.group());
            }
            endIndex = matcher.end();
        }
        sb.append(input.substring(endIndex));
        return sb.toString();
    }

    public String addQuoteToSelect(String input, String dynPat) {
        Pattern pattern = Pattern.compile("(?i)((?:INSERT\\s+INTO|DELETE\\s+FROM|CREATE\\s+LOCAL).*?)?(SELECT.*?)?(;|\\)\\s*LOOP)", 40);
        Matcher matcher = pattern.matcher(input);
        StringBuffer sb = new StringBuffer();
        int endIndex = 0;
        String dynPatMatch = ".*" + dynPat + ".*";
        while (matcher.find()) {
            String insertQuery = matcher.group();
            if (";".equals(insertQuery)) {
                sb.append(input.substring(endIndex, matcher.end()));
            } else if (matcher.group(1) == null && !insertQuery.contains("$q$")) {
                this.getBufTillNextMatch(input, sb, endIndex, matcher);
                Pattern insertPat = Pattern.compile("(?i)((?:INSERT\\s+INTO|DELETE\\s+FROM).*?)?(?:SELECT.*?)?(INTO.*?)?(?:(?:\\s+(FROM(?!\\s{1,10}\\()\\s+(?:\\$?\\{?\\w+\\}?\\s*\\.\\s*)?\\$?\\{?\\w+\\}?).*?(?:;|\\)\\s*LOOP)))", 40);
                Matcher insertMatcher = insertPat.matcher(insertQuery);
                if (insertMatcher.find()) {
                    insertQuery = insertQuery.replaceFirst(";\\s*$", "");
                    boolean endsWithLoop = insertQuery.matches("(?i).*(?<!\\w)LOOP\\s*$");
                    insertQuery = insertQuery.replaceFirst("(?i)\\)\\s*(?<!\\w)LOOP\\s*$", "");
                    String from = insertMatcher.group(3);
                    Pattern dynaPattern = Pattern.compile(dynPatMatch, 40);
                    Matcher dynaMatcher = null;
                    if (from != null) {
                        dynaMatcher = dynaPattern.matcher(from);
                    }
                    if (from != null && dynaMatcher != null && dynaMatcher.find()) {
                        this.addExecuteImmediateSelect(dynPat, sb, insertQuery, insertMatcher, from);
                    } else {
                        sb.append(insertQuery);
                    }
                    sb.append(endsWithLoop ? ") LOOP " : ";");
                } else {
                    sb.append(insertQuery);
                }
            } else {
                sb.append(input.substring(endIndex, matcher.start()));
                sb.append(insertQuery);
            }
            endIndex = matcher.end();
        }
        sb.append(input.substring(endIndex));
        return sb.toString();
    }

    public String addQuoteToDelete(String input, String dynPat) {
        Matcher matcher = DELETE_FROM_PAT.matcher(input);
        StringBuffer sb = new StringBuffer();
        int endIndex = 0;
        String dynPatMatch = ".*" + dynPat + ".*";
        while (matcher.find()) {
            this.getBufTillNextMatch(input, sb, endIndex, matcher);
            String insertQuery = matcher.group();
            Pattern insertPat = Pattern.compile("(?i)DELETE\\s+FROM\\s+(.*?)(?:WHERE(?:.*?))?(?:\\s+FROM(?!\\s{1,10}\\()\\s+(.*?)(?:(?:\\sINNER|\\sLEFT|\\sWHERE)\\s.*?(?:;|\\)\\s*LOOP)|\\).*?;|;)|;)", 40);
            Matcher insertMatcher = insertPat.matcher(insertQuery);
            if (insertMatcher.find()) {
                String schema = insertMatcher.group(1);
                String from = insertMatcher.group(2);
                if (schema.matches(dynPatMatch) || from != null && from.matches(dynPatMatch)) {
                    this.addExecuteImmediate(dynPat, sb, insertQuery, schema);
                } else {
                    sb.append(matcher.group());
                }
            } else {
                sb.append(matcher.group());
            }
            endIndex = matcher.end();
        }
        sb.append(input.substring(endIndex));
        return sb.toString();
    }

    private String addQuoteToDropTable(String input, String dynPat) {
        Matcher matcher = DROP_TABLE_PAT.matcher(input);
        StringBuffer sb = new StringBuffer();
        int endIndex = 0;
        String dynPatMatch = ".*" + dynPat + ".*";
        while (matcher.find()) {
            this.getBufTillNextMatch(input, sb, endIndex, matcher);
            String insertQuery = matcher.group();
            Pattern insertPat = Pattern.compile("(?i)DROP\\s+TABLE\\s+(.*?)(?:WHERE(?:.*?))?(?:\\s+FROM(?!\\s{1,10}\\()\\s+(.*?)(?:(?:\\sINNER|\\sLEFT|\\sWHERE)\\s.*?(?:;|\\)\\s*LOOP)|\\).*?;|;)|;)");
            Matcher insertMatcher = insertPat.matcher(insertQuery);
            if (insertMatcher.find()) {
                String schema = insertMatcher.group(1);
                String from = insertMatcher.group(2);
                if (schema.matches(dynPatMatch) || from != null && from.matches(dynPatMatch)) {
                    this.getQuoteWithExecuteImmediate(dynPatMatch, sb, insertQuery, false);
                } else {
                    sb.append(matcher.group());
                }
            } else {
                sb.append(matcher.group());
            }
            endIndex = matcher.end();
        }
        sb.append(input.substring(endIndex));
        return sb.toString();
    }

    public String addQuoteToCreate(String input, String dynPat) {
        Matcher matcher = CREATE_TABLE_PAT.matcher(input);
        StringBuffer sb = new StringBuffer();
        int endIndex = 0;
        String dynPatMatch = ".*" + dynPat + ".*";
        while (matcher.find()) {
            this.getBufTillNextMatch(input, sb, endIndex, matcher);
            String insertQuery = matcher.group();
            Pattern insertPat = Pattern.compile("(?i)CREATE\\s+(?:.*?)\\s+TABLE\\s+(.*?)\\s*(?:ON\\s+COMMIT\\s+PRESERVE\\s+ROWS\\s+DISTRIBUTE\\s+BY\\s+HASH\\s*\\((.*?)\\)|(?:#S#\\d+#E#\\s*)*,\\s*NO\\s+JOURNAL)\\s*.*?;", 40);
            Matcher insertMatcher = insertPat.matcher(insertQuery);
            if (insertMatcher.find()) {
                String schema = insertMatcher.group(1);
                String from = insertMatcher.group(2);
                if (schema.contains("(")) {
                    schema = schema.substring(0, schema.indexOf("("));
                }
                if (schema.matches(dynPatMatch) || from != null && from.matches(dynPatMatch)) {
                    this.getQuoteWithExecuteImmediate(dynPat, sb, insertQuery.replaceFirst(";\\s*$", ""), true);
                } else {
                    sb.append(matcher.group());
                }
            } else {
                sb.append(matcher.group());
            }
            endIndex = matcher.end();
        }
        sb.append(input.substring(endIndex));
        return sb.toString();
    }

    private void addExecuteImmediate(String dynPat, StringBuffer sb, String insertQuery, String schema) {
        String dynPatMatch = ".*" + dynPat + ".*";
        String query = insertQuery.replaceFirst(";\\s*$", "");
        if (schema.matches(dynPatMatch)) {
            this.viewTableBase = true;
            this.addViewBaseTable(sb, schema, dynPatMatch, true);
            sb.append(" IF lv_mig_view_basetable IS NULL THEN ");
            this.getQuoteWithExecuteImmediate(dynPat, sb, query, true);
            sb.append(" ELSE ");
            query = query.replaceFirst(Pattern.quote(schema), "lv_mig_view_basetable ");
            this.getQuoteWithExecuteImmediate(dynPat, sb, query, true);
            sb.append(" END IF; ");
        } else {
            this.addViewBaseTable(sb, schema, dynPatMatch, false);
            this.getQuoteWithExecuteImmediate(dynPat, sb, query, true);
        }
    }

    private void addViewBaseTable(StringBuffer sb, String schema, String dynPatMatch, boolean addBaseTable) {
        String tableName;
        String schemaName;
        String[] schemaList = schema.split("\\.");
        String string = schemaName = schemaList.length == 2 ? schemaList[0] : "CURRENT_SCHEMA()";
        if (!schemaName.matches(dynPatMatch) && !"CURRENT_SCHEMA()".equals(schemaName)) {
            schemaName = "'" + schemaName.trim() + "'";
        } else if (schemaName.matches(dynPatMatch)) {
            schemaName = this.getQuotedString(dynPatMatch, schemaName, false);
        }
        String string2 = tableName = schemaList.length == 2 ? schemaList[1] : schemaList[0];
        if (!tableName.matches(dynPatMatch)) {
            tableName = "'" + tableName.trim() + "'";
        } else if (tableName.matches(dynPatMatch)) {
            tableName = this.getQuotedString(dynPatMatch, tableName, false);
        }
        if (addBaseTable) {
            sb.append("lv_mig_view_basetable := mig_td_ext.mig_fn_get_view_basetable(" + schemaName + ", " + tableName + ");");
        }
    }

    private void getQuoteWithExecuteImmediate(String dynPat, StringBuffer sb, String query, boolean addSemicolon) {
        sb.append("EXECUTE IMMEDIATE ");
        sb.append("$q$");
        sb.append(this.getQuotedString(dynPat, query, false));
        if (addSemicolon) {
            sb.append(SEMICOLON_SPACE);
        }
    }

    private void addExecuteImmediateSelect(String dynPat, StringBuffer sb, String insertQuery, Matcher insertMatcher, String fromInput) {
        String into = insertMatcher.group(2);
        if (into != null) {
            into = into.replace(IGaussDBConstants.NEW_LINE, "");
        }
        String from = fromInput;
        int intoIndex = into != null ? insertMatcher.start(2) : insertMatcher.start(3);
        String prefix = insertQuery.substring(insertMatcher.start(), intoIndex);
        String endString = insertQuery.substring(insertMatcher.end(3), insertQuery.length());
        if (into != null && into.matches("(?i).*\\s+FROM\\s+.*")) {
            String fromPrefix = into.replaceFirst("(?i).*?((?<!\\w)FROM(?!\\w).*)", "$1");
            from = fromPrefix + " " + from;
            into = into.replace(fromPrefix, "");
        }
        String query = prefix + from + endString;
        this.getQuoteWithExecuteImmediate(dynPat, sb, query, false);
        if (into != null) {
            sb.append(" ").append(into);
        }
    }

    private String performActivityCountMigration(String input) {
        String output = input;
        if (this.dsqlSupport && QueryConversionUtility.containsCheck(input, "$ACTIVITYCOUNT")) {
            String regex = "(?i)((?:insert|update|delete)(?:(?!INSERT|DELETE|UPDATE).)*?;)\\s*((?:insert|update|delete).*?;)(?:.*?)(?:(?<!\\w)\\.if(?!\\w).*?then.*?)?(?:(?<!\\w)(\\$ACTIVITYCOUNT(?:1|2))(?!\\w))";
            Matcher matcher = Pattern.compile(regex).matcher(output);
            StringBuffer sb = new StringBuffer();
            int startIndex = -1;
            if (matcher.find()) {
                Matcher matchercount = ACTIVITY_COUNT_PAT.matcher(output);
                LinkedHashSet<String> set = new LinkedHashSet<String>();
                while (matchercount.find()) {
                    set.add(matchercount.group(1));
                    if (set.size() != 2) continue;
                }
                startIndex = this.performActivityCountSub(output, matcher, sb, startIndex, set);
                sb.append(output.substring(startIndex));
                output = sb.toString();
                output = output.replace("$ACTIVITYCOUNT1", "lv_mig_activitycount1 ");
                output = output.replace("$ACTIVITYCOUNT2", "lv_mig_activitycount2 ");
            }
        }
        return output;
    }

    private int performActivityCountSub(String input, Matcher matcher, StringBuffer sb, int startIdx, LinkedHashSet<String> set) {
        String output = input;
        int startIndex = startIdx;
        boolean flag = true;
        for (String string : set) {
            String activityValue;
            String group;
            if (flag) {
                startIndex = matcher.start(1);
                sb.append(output.substring(0, startIndex));
                group = matcher.group(1);
                activityValue = group + " lv_mig_" + string.toLowerCase(Locale.ROOT) + " := SQL%ROWCOUNT ; ";
                sb.append(activityValue);
                startIndex = matcher.end(1);
                flag = false;
                continue;
            }
            int endindex = matcher.start(2);
            sb.append(output.substring(startIndex, endindex));
            group = matcher.group(2);
            activityValue = group + " lv_mig_" + string.toLowerCase(Locale.ROOT) + " := SQL%ROWCOUNT ; ";
            sb.append(activityValue);
            startIndex = matcher.end(2);
        }
        return startIndex;
    }

    private void addQuoteToLvVariable(Map<String, String> quoteMap) {
        String output = QueryConversionUtility.getRplFromMap(this.outputBuff.toString(), quoteMap, "(##QUOTE##\\d+#)");
        this.outputBuff.setLength(0);
        output = this.addVariableForActivityCount(output);
        output = this.doSetEnd(output);
        String lvVarList = QueryConversionUtility.getLvVariableList(output, "(lv_mig_\\w+)\\s+(?:NUMBER\\(\\d\\)|TEXT)");
        output = this.addQuoteToInsert(output, lvVarList);
        output = this.addQuoteToSelect(output, lvVarList);
        if (FeatureLoaderExtended.getBooleanProperty("dsqlSupport")) {
            output = this.migrateForStringAgg(output);
        }
        output = this.addQuoteToDelete(output, lvVarList);
        output = this.addQuoteToCreate(output, lvVarList);
        output = this.addQuoteToUpdate(output, lvVarList);
        output = this.addQuoteToDropTable(output, lvVarList);
        if (!this.viewTableBase) {
            output = output.replace("lv_mig_view_basetable TEXT;", "");
        }
        output = output.replaceAll("(?i)FOR\\s+rec\\s+IN\\s+\\(\\s+EXECUTE\\s+IMMEDIATE\\s*", "FOR rec IN EXECUTE (");
        output = output.replaceAll("\\'(lv_mig_\\w+)\\'", "$1");
        output = QueryConversionUtility.getSingleDoubleQuoteMap(output, quoteMap);
        this.outputBuff.append(output);
    }

    private String addVariableForActivityCount(String input) {
        String output = input;
        if (this.dsqlSupport) {
            String regexPattern = "((?:(?:insert|update|delete)(?:(?!INSERT|DELETE|UPDATE).)*?;)\\s*lv_mig_activitycount[12]\\s+:=\\s+SQL%ROWCOUNT\\s+;\\s+)(BEGIN)";
            if (output.matches("(?i).*?" + regexPattern + ".*")) {
                if ((output = output.replaceFirst("(?i)" + regexPattern, "$2 $1")).matches(".*?lv_mig_activitycount1 .*")) {
                    output = output.replaceAll("(DECLARE.*?)(?<!\\w)BEGIN(?!\\w)", "$1 lv_mig_activitycount1 NUMBER (6); BEGIN");
                }
                if (output.matches(".*?lv_mig_activitycount2 .*")) {
                    output = output.replaceAll("(DECLARE.*?)(?<!\\w)BEGIN(?!\\w)", "$1 lv_mig_activitycount2 NUMBER (6); BEGIN");
                }
            }
        }
        return output;
    }

    public String migrateForStringAgg(String input) {
        String output = input;
        StringBuffer sb = new StringBuffer();
        ColumnSplitter split = new ColumnSplitter();
        int endIndex = 0;
        Matcher matcher = SELQRY.matcher(output);
        String putLine = "";
        while (matcher.find()) {
            String insertQuery = matcher.group();
            if (this.matchInsrtQry(insertQuery)) {
                endIndex = this.getOutForNoStrAgg(output, sb, endIndex, matcher);
                continue;
            }
            if (matcher.group(1) != null || insertQuery.contains("$q$")) continue;
            this.getBufTillNextMatch(output, sb, endIndex, matcher);
            Matcher selIntoMatch = SEL_INTO.matcher(insertQuery);
            if (selIntoMatch.find()) {
                String ordBy = "";
                String into = "";
                Matcher orderByMatch = ORDER_BY.matcher(insertQuery);
                Matcher insertMatcher = INSERT_PAT.matcher(insertQuery);
                if (orderByMatch.find()) {
                    ordBy = orderByMatch.group(1);
                    insertQuery = insertQuery.replace(ordBy, "");
                }
                if (insertMatcher.find()) {
                    into = insertMatcher.group(2).trim();
                    List<String> colInto = split.doGetAllColumns(into);
                    StringBuffer max = new StringBuffer();
                    putLine = this.getPutLine(putLine, colInto, max);
                    String maxVar = this.getMaxVariable(max);
                    List<String> colName = split.doGetAllColumns(selIntoMatch.group(1));
                    insertQuery = insertQuery.replace("' , '", "','");
                    if (!ordBy.isEmpty()) {
                        insertQuery = this.appendStrAgg(ordBy, insertQuery, colInto, colName);
                        insertQuery = this.appendMaxFunc(into, insertQuery, maxVar);
                    } else {
                        insertQuery = this.migWOOrder(insertQuery, colName);
                    }
                }
            }
            insertQuery = this.replaceDBC(insertQuery);
            sb.append(insertQuery);
            endIndex = matcher.end();
        }
        sb.append(output.substring(endIndex));
        output = this.getOut(sb);
        return output;
    }

    private boolean matchInsrtQry(String insertQuery) {
        return ";".equals(insertQuery) || insertQuery.matches("(?i).*(?<!\\w)from\\s+dual(?!\\w).*") || !insertQuery.matches("(?i).*(?<!\\w)from(?!\\w).*") || insertQuery.matches("(?i).*(?<!\\w)count\\s*\\(\\s*\\*\\s*\\).*") || insertQuery.matches("(?i).*(?<!\\w)insert\\s+into(?!\\w).*") || insertQuery.matches("(?i).*(?<!\\w)extract\\s*\\(\\s*.*?from.*");
    }

    private String getMaxVariable(StringBuffer max) {
        String maxVar = max.toString();
        maxVar = this.remColonFromMaxvar(maxVar);
        return maxVar;
    }

    private void getBufTillNextMatch(String output, StringBuffer sb, int endIndex, Matcher matcher) {
        int startIndex = matcher.start();
        sb.append(output.substring(endIndex, startIndex));
    }

    public String appendMaxFunc(String into, String insQry, String maxVar) {
        String insertQuery = insQry;
        insertQuery = insertQuery.replaceAll("(?i)(?<!\\w)into\\s+" + into, "");
        insertQuery = insertQuery.replace(insertQuery, "SELECT " + maxVar + " INTO " + into + " FROM (" + insertQuery);
        insertQuery = insertQuery.substring(0, insertQuery.length() - 1);
        insertQuery = insertQuery + ");";
        return insertQuery;
    }

    public String appendStrAgg(String ordBy, String insQry, List<String> colInto, List<String> colName) {
        String insertQuery = insQry;
        for (int i = 0; i < colName.size(); ++i) {
            String col = colName.get(i);
            insertQuery = insertQuery.replace(" " + col, " STRING_AGG( " + col + ", ',')  OVER(" + ordBy + ") AS " + colInto.get(i));
        }
        return insertQuery;
    }

    public String getOut(StringBuffer sb) {
        String output = sb.toString();
        if (!output.endsWith("/")) {
            output = output + "/";
        }
        return output;
    }

    public String getPutLine(String linePut, List<String> colInto, StringBuffer max) {
        String putLine = linePut;
        for (int i = 0; i < colInto.size(); ++i) {
            String intoColRep = colInto.get(i).replace(VARIABLE_PREFIX, "");
            colInto.set(i, intoColRep);
            max.append("MAX(").append(colInto.get(i)).append("),");
        }
        return putLine;
    }

    public String replaceDBC(String insQry) {
        String insertQuery = insQry;
        insertQuery = insertQuery.replaceAll("(?i)(?<!\\w)dbc.columnsV(?!\\w)", "mig_td_ext.vw_td_dbc_columnsV");
        insertQuery = insertQuery.replaceAll("(?i)(?<!\\w)dbc.indicesV(?!\\w)", "mig_td_ext.vw_td_dbc_indicesV");
        return insertQuery;
    }

    public String remColonFromMaxvar(String maxVariable) {
        String maxVar = maxVariable;
        if (maxVar.endsWith(",")) {
            maxVar = maxVar.substring(0, maxVar.length() - 1);
        }
        return maxVar;
    }

    public int getOutForNoStrAgg(String output, StringBuffer sb, int endIdx, Matcher matcher) {
        int endIndex = endIdx;
        sb.append(output.substring(endIndex, matcher.end()));
        endIndex = matcher.end();
        return endIndex;
    }

    public String migWOOrder(String insertQry, List<String> colName) {
        String insertQuery = insertQry;
        for (int i = 0; i < colName.size(); ++i) {
            String col = colName.get(i);
            insertQuery = QueryConversionUtility.replaceAll(insertQuery, "(?<!\\w)" + Pattern.quote(col) + "(?!\\w)", " STRING_AGG( " + col + ", ',')");
        }
        return insertQuery;
    }
}

