/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.teradata;

import com.huawei.db.migration.common.features.GroupingFeature;
import com.huawei.db.migration.common.handlers.CommentsHandler;
import com.huawei.db.migration.database.bo.IIndexConstraintsBO;
import com.huawei.db.migration.database.bo.IQueryPatternsBO;
import com.huawei.db.migration.database.bo.IndexConstraintsBO;
import com.huawei.db.migration.interfaces.IReplacerMap;
import com.huawei.db.migration.services.TeradataMigrationService;
import com.huawei.db.migration.teradata.TeradataMapHelperAlias;
import com.huawei.db.migration.teradata.TeradataMapHelperIndex;
import com.huawei.db.migration.teradata.TeradataQueryKeywordReplacer;
import com.huawei.db.migration.teradata.TitleNamedUtility;
import com.huawei.db.migration.util.ColumnSplitter;
import com.huawei.db.migration.util.FeatureLoader;
import com.huawei.db.migration.util.IGaussDBConstants;
import com.huawei.db.migration.util.PlaceHolderUtility;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TeradataMapHelper {
    private static final Pattern QUALIFY_PATTERN = Pattern.compile("(?i)(?<!\\w)AS(?!\\w)\\s*(?:\\w*)\\s*\\s*(((?<!\\w)~REM~OVE~)\\s*(##QUOTE##\\d+#|\\\"\\w*\\\"))");
    private static final Pattern TBL_PATTERN = Pattern.compile("(?i)\\(\\s*LIKE\\s+(.*?)(?<!\\w)INCLUDING\\s+");
    private static final Pattern COMPARISON_OPERATORS = Pattern.compile("(?i)(?![^(]*\\))((?:<=|>=|<>|=|>|<|\\s*(?<!\\w)(is|in|not\\s+in)(?!\\w)).*)");
    private static final Logger logger = LogManager.getLogger(TeradataMapHelper.class);
    private Map<String, String> replaceValMap = null;
    private Map<String, String> aliasColumnMap = null;
    private List<String> allIndexList = new ArrayList<String>(10);
    private TeradataMapHelperAlias teradataMapAlias = new TeradataMapHelperAlias();
    private TeradataMapHelperIndex teradataMapIndex = new TeradataMapHelperIndex();
    private boolean isVolatileTbl = false;
    private List<String> columns = null;
    private String tblName = null;
    private IIndexConstraintsBO objIndexConstraintsBO = null;

    public boolean aliasNameUsageinWhrclause(IQueryPatternsBO objReplaceBO, String inputSQL, Map<String, String> queryDataMap) {
        Pattern newPattern;
        Matcher orderBymatch;
        String orgWhrCond = queryDataMap.get("wherecondition");
        String orderByCla = "";
        String whrCondWithOrderBy = "";
        String newWhrCond = "";
        boolean isOrderby = false;
        boolean whereFlag = false;
        boolean isTopFunction = queryDataMap.containsKey("limit");
        if (orgWhrCond.matches("(?i).*(?<!\\w)order(?!\\w).*") && (orderBymatch = (newPattern = Pattern.compile("(.*)((order\\s+by)(.*))", 2)).matcher(orgWhrCond)).find()) {
            if (!orderBymatch.group(1).trim().isEmpty()) {
                whrCondWithOrderBy = orderBymatch.group(1);
            } else {
                whrCondWithOrderBy = "";
                whereFlag = true;
            }
            orderByCla = orderBymatch.group(2);
            queryDataMap.put("wherecondition", whrCondWithOrderBy);
            isOrderby = true;
        }
        boolean isValid = false;
        if (!whereFlag) {
            queryDataMap.put("orderby", orderByCla);
            isValid = this.doCheckAliasFnReplace(queryDataMap, isValid, "wherecondition");
        }
        if (isTopFunction) {
            this.doColumnFunctionReplacer(queryDataMap, "aliascolumnname", queryDataMap.get("aliascolumnname"));
            isValid = true;
        }
        if (isOrderby && !isTopFunction) {
            newWhrCond = queryDataMap.get("wherecondition");
            queryDataMap.put("wherecondition", newWhrCond + " " + orderByCla);
            isValid = this.doCheckAliasFnReplace(queryDataMap, isValid, "wherecondition");
        } else if (isOrderby && isTopFunction) {
            queryDataMap.put("orderby", orderByCla);
        }
        return isValid;
    }

    private boolean doCheckAliasFnReplace(Map<String, String> queryDataMap, boolean isValidInp, String key) {
        boolean isValid = isValidInp;
        String keyVal = queryDataMap.get(key);
        if (keyVal != null) {
            String keyInput;
            String tempInput = keyInput = " " + keyVal + " ";
            if (!this.aliasColumnMap.isEmpty()) {
                String aliasName = null;
                for (Map.Entry<String, String> aliasEntry : this.aliasColumnMap.entrySet()) {
                    aliasName = aliasEntry.getKey();
                    String patternString = QueryConversionUtility.doGetAliasPattern(aliasName);
                    keyInput = QueryConversionUtility.doReplaceSpecificGrp(keyInput, patternString, "", this.aliasColumnMap.get(aliasName), 1, false);
                }
                if (!keyInput.equals(tempInput)) {
                    isValid = true;
                }
                this.doColumnFunctionReplacer(queryDataMap, key, keyInput);
            }
        }
        return isValid;
    }

    private void doColumnFunctionReplacer(Map<String, String> queryDataMap, String key, String keyInput) {
        String keyInputTmp = QueryConversionUtility.doReplaceFunctionVariables(keyInput, this.replaceValMap, "COLUMN__");
        queryDataMap.put(key, keyInputTmp);
    }

    private void doConstructAliasColumnMap(IQueryPatternsBO objReplaceBO, IReplacerMap queryDataMap) {
        if (FeatureLoader.getBooleanProperty("tdMigrateALIAS")) {
            String aliasColumns = (String)queryDataMap.get(objReplaceBO.getConstraintInput());
            Pattern oraAliasPattern = Pattern.compile(objReplaceBO.getConstraintPattern(), 2);
            if (QueryConversionUtility.toUpper((aliasColumns = aliasColumns.replaceAll("(?i)#S#\\d+#E#", "")).trim()).startsWith("DISTINCT")) {
                aliasColumns = aliasColumns.trim().substring(8);
            }
            Matcher oraAliasMatcher = oraAliasPattern.matcher(aliasColumns);
            String column = null;
            String alias = null;
            while (oraAliasMatcher.find()) {
                column = oraAliasMatcher.group(2).trim();
                if (column.equals(alias = oraAliasMatcher.group(10).trim())) continue;
                this.doPutAliasAndColumnInMap(column, alias);
            }
        }
    }

    private void doPutAliasAndColumnInMap(String columnInp, String alias) {
        boolean isColumnContainsAlias = true;
        String columnExpKey = null;
        boolean isColExp = false;
        String column = columnInp;
        if (column.trim().startsWith("_COLUMN__")) {
            columnExpKey = column;
            column = QueryConversionUtility.doReplaceFunctionVariables(column, this.replaceValMap, "_COLUMN__");
            isColExp = true;
        }
        if (QueryConversionUtility.containsCheck(column, alias)) {
            isColumnContainsAlias = QueryConversionUtility.isContainsExactMatch(" " + column + " ", alias);
            if (!isColumnContainsAlias) {
                column = isColExp ? columnExpKey : column;
                this.aliasColumnMap.put(alias, column);
            }
        } else {
            column = isColExp ? columnExpKey : column;
            this.aliasColumnMap.put(alias, column);
        }
    }

    public boolean aliasNameUsageinQualifyRowNumRank(IQueryPatternsBO objReplaceBO, String inputSQL, Map<String, String> queryDataMap) {
        Pattern newpattern;
        Matcher match;
        boolean isValidPartionBy = false;
        boolean isValidWhere = false;
        boolean iswhere = false;
        boolean isPartionBy = false;
        boolean isOrderby = false;
        boolean isValidOrderBy = false;
        isValidWhere = this.getIsValid(queryDataMap, isValidWhere, iswhere);
        String orgRownumber = queryDataMap.get("rownumber");
        String partionBy = "";
        String orderBy = null;
        String append = "";
        String newPartionBy = "";
        String newOrderBy = "";
        if (orgRownumber.matches("(?i).*(?<!\\w)over\\s*\\(.*") && (match = (newpattern = Pattern.compile("(?i)(((\\s*\\(\\s*\\)\\s*(?:#S#\\d+#E#\\s*)*over\\s*\\()(\\s*partition\\s+by\\s*(.*))?)(\\s*order\\s+by\\s*(.*))?)")).matcher(orgRownumber)).find()) {
            append = match.group(3);
            if (match.group(4) != null) {
                partionBy = match.group(4);
                isPartionBy = true;
                queryDataMap.put("rownumber", partionBy);
                isValidPartionBy = this.doCheckAliasFnReplace(queryDataMap, isValidPartionBy, "rownumber");
                newPartionBy = queryDataMap.get("rownumber");
            }
            if (match.group(6) != null) {
                orderBy = match.group(6);
                isOrderby = true;
                queryDataMap.put("rownumber", orderBy);
                isValidOrderBy = this.doCheckAliasFnReplace(queryDataMap, isValidOrderBy, "rownumber");
                newOrderBy = queryDataMap.get("rownumber");
            }
            logger.debug("partion by (or /and) Order by clause found");
        }
        if (isPartionBy || isOrderby) {
            queryDataMap.put("rownumber", append + newPartionBy + newOrderBy);
        }
        return isValidWhere || isValidPartionBy || isValidOrderBy;
    }

    private boolean getIsValid(Map<String, String> queryDataMap, boolean flag, boolean whereFlag) {
        boolean iswhere = whereFlag;
        boolean isValidWhere = flag;
        String whereCondn = "";
        String fromCondn = "";
        String fromMap = queryDataMap.get("from");
        if (QueryConversionUtility.containsCheck(fromMap, " where ")) {
            int index = QueryConversionUtility.toLower(fromMap).indexOf(" where ");
            fromCondn = fromMap.substring(0, index);
            whereCondn = fromMap.substring(index);
            iswhere = true;
            queryDataMap.put("from", whereCondn);
            isValidWhere = this.doCheckAliasFnReplace(queryDataMap, isValidWhere, "from");
        }
        this.putCondToMap(queryDataMap, iswhere, fromCondn);
        return isValidWhere;
    }

    private void putCondToMap(Map<String, String> queryDataMap, boolean iswhere, String fromCondn) {
        if (iswhere) {
            String newCond = queryDataMap.get("from");
            queryDataMap.put("from", fromCondn + newCond);
        }
    }

    public boolean aliasNameReplaceForQualify(IQueryPatternsBO objReplaceBO, String inputSQL, Map<String, String> queryDataMap) {
        String input = queryDataMap.get(objReplaceBO.getConstraintInput());
        String patternInput = this.teradataMapAlias.doPutColumnAlias(input);
        boolean flag = patternInput.contains("COLUMN__function");
        String corequery = "select " + patternInput;
        Thread currentThread = Thread.currentThread();
        int threadId = (int)currentThread.getId();
        boolean titleWithQualify = TitleNamedUtility.LIST_THREAD.remove(threadId);
        Matcher qualifyMatcher = QUALIFY_PATTERN.matcher(corequery);
        String remaneAs = null;
        while (qualifyMatcher.find()) {
            remaneAs = qualifyMatcher.group(2);
            corequery = corequery.replace(qualifyMatcher.group(1), " ");
        }
        patternInput = this.getCols(queryDataMap, patternInput, corequery, titleWithQualify);
        patternInput = this.maskCaseWhenExpr(patternInput);
        String patternInputToMatch = patternInput.replaceAll("(?i)#S#\\d+#E#", "");
        patternInputToMatch = this.maskCaseWhenExpr(patternInputToMatch);
        Pattern pattern = Pattern.compile(objReplaceBO.getConstraintPattern(), 2);
        Matcher matcher = pattern.matcher(patternInputToMatch);
        LinkedHashMap<String, String> columnsMapWithAlias = new LinkedHashMap<String, String>(10);
        boolean isValid = this.getIfValid(titleWithQualify, matcher, columnsMapWithAlias);
        ColumnSplitter splitter = new ColumnSplitter();
        List<String> columnsList = splitter.doGetAllColumns(patternInputToMatch);
        patternInput = this.doTitleNamedRemove(patternInput, remaneAs);
        patternInput = columnsList.contains("*") ? "*" : this.getPatternInput(patternInput, flag, titleWithQualify, columnsMapWithAlias);
        queryDataMap.put("aliascolumnname", patternInput);
        if (!QueryConversionUtility.containsCheck(input, " as ")) {
            return true;
        }
        return isValid;
    }

    private String maskCaseWhenExpr(String columnNames) {
        Pattern caseWhenPattern = Pattern.compile("(?i).*?CASE(?:(?!CASE).*?)END");
        String[] commaArray = QueryConversionUtility.doGetArrSplit(columnNames, ",");
        List<String> colList = Arrays.asList(commaArray);
        for (int i = 0; i < colList.size(); ++i) {
            Matcher caseWhenMatcher = caseWhenPattern.matcher(colList.get(i));
            String maskCol = caseWhenMatcher.replaceAll("##CASE##WHEN##");
            colList.set(i, maskCol);
        }
        return String.join((CharSequence)",", colList);
    }

    private boolean getIfValid(boolean titleWithQualify, Matcher matcher, LinkedHashMap<String, String> columnsMapWithAlias) {
        String prev = null;
        boolean isValid = false;
        while (matcher.find()) {
            String zeroCol = matcher.group().trim();
            String twoCol = matcher.group(2).trim();
            String tenCol = matcher.group(10).trim();
            if (!tenCol.equals(twoCol)) {
                String key = zeroCol;
                if (twoCol.equalsIgnoreCase("as")) {
                    columnsMapWithAlias.put(prev, tenCol);
                    columnsMapWithAlias.put(zeroCol, "");
                } else {
                    columnsMapWithAlias.put(key, titleWithQualify ? twoCol : tenCol);
                }
                prev = zeroCol;
            }
            isValid = true;
        }
        return isValid;
    }

    public String getPatternInput(String patternInput, boolean flag, boolean titleWithQualify, LinkedHashMap<String, String> columnsMapWithAlias) {
        if (!titleWithQualify) {
            for (Map.Entry<String, String> entry : columnsMapWithAlias.entrySet()) {
                if (!patternInput.contains(entry.getKey())) continue;
                patternInput = patternInput.replace(entry.getKey(), entry.getValue());
            }
        }
        if (flag) {
            patternInput = QueryConversionUtility.replace(patternInput, "(?i)(_COLUMN__function\\d+_\\s+as)", "", false);
        }
        patternInput = QueryConversionUtility.doReplaceFunctionVariables(patternInput, this.replaceValMap, "COLUMN__");
        return patternInput;
    }

    public String getCols(Map<String, String> queryDataMap, String patternInput, String corequery, boolean titleWithQualify) {
        String regex = "(?i)as\\s+(?:(?:\\\".*?\\\")|##QUOTE##\\d+#)";
        if (corequery.matches("(?i).*?(?<!\\w)~REM~OVE~(?!\\w).*")) {
            corequery = QueryConversionUtility.replaceAll(corequery, "(?i)(?<!\\w)~REM~OVE~(?!\\w)", " as ");
        }
        corequery = QueryConversionUtility.doReplaceFunctionVariables(corequery, this.replaceValMap, "COLUMN__");
        if (titleWithQualify) {
            corequery = QueryConversionUtility.replace(corequery, regex, "", false);
        }
        queryDataMap.put("corequery", corequery);
        patternInput = QueryConversionUtility.doRemDotOrAppendAlias(patternInput, true);
        return patternInput;
    }

    private String doTitleNamedRemove(String patternInputVal, String remaneAs) {
        String patternInput = patternInputVal;
        if (remaneAs != null) {
            patternInput = patternInput.replace(remaneAs, "AS");
        }
        if (patternInput.matches("(?i).*?(?<!\\w)~REM~OVE~(?!\\w).*")) {
            patternInput = QueryConversionUtility.replaceAll(patternInput, "(?i)\\w+\\s+(?<!\\w)~REM~OVE~(?!\\w)\\s*(.*?)\\,", "");
        }
        return patternInput;
    }

    public void doColumnSplit(IQueryPatternsBO objReplaceBO, IReplacerMap queryDataMap) {
        this.replaceValMap = new LinkedHashMap<String, String>(10);
        this.aliasColumnMap = new LinkedHashMap<String, String>(10);
        String columnNames = (String)queryDataMap.get(objReplaceBO.getConstraintInput());
        List<String> columnArrays = null;
        LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
        if (columnNames != null && !columnNames.trim().equals("*") && !columnNames.trim().replace(" ", "").endsWith(".*")) {
            columnNames = QueryConversionUtility.getSingleDoubleQuoteMap(columnNames, quoteMap);
            ColumnSplitter splitter = new ColumnSplitter();
            columnArrays = splitter.doGetAllColumns(columnNames);
            columnArrays = CommentsHandler.replacementForQuote(columnArrays, quoteMap, "(##QUOTE##\\d+#)");
            String topFn = null;
            String topValue = null;
            if (!columnArrays.isEmpty() && QueryConversionUtility.toLower(columnArrays.get(0).replaceAll("(?i)#S#\\d+#E#", "")).trim().startsWith("top ")) {
                topFn = columnArrays.get(0);
                String column = null;
                Matcher matcher = Pattern.compile("(?i)(.*)top\\s+(\\d+|:\\w+)\\s+(percent\\s+with\\s+ties|with\\s+ties|percent)?\\s*(.*)").matcher(topFn);
                if (matcher.find()) {
                    topValue = matcher.group(2);
                    topFn = matcher.group(3);
                    column = matcher.group(4);
                    column = matcher.group(1) == null ? column : matcher.group(1) + column;
                    columnArrays.set(0, column);
                } else {
                    topFn = null;
                }
            }
            queryDataMap.put("TopFunction", topFn);
            queryDataMap.put("TopValue", topValue);
            this.getUpdatedMap(objReplaceBO, queryDataMap, columnNames, columnArrays);
        }
    }

    private void getUpdatedMap(IQueryPatternsBO objReplaceBO, IReplacerMap queryDataMap, String columnNames, List<String> columnArrays) {
        String modifiedPlaceholderColumns = columnNames;
        if (!columnArrays.isEmpty()) {
            PlaceHolderUtility placeHolder = new PlaceHolderUtility();
            modifiedPlaceholderColumns = placeHolder.doGetPlaceholderColumns(columnArrays, this.replaceValMap, false, true);
        }
        queryDataMap.put("aliascolumnname", modifiedPlaceholderColumns);
        this.doConstructAliasColumnMap(objReplaceBO, queryDataMap);
        this.doReplaceNestedAlias(queryDataMap);
        this.aliasColumnMap.clear();
        this.doConstructAliasColumnMap(objReplaceBO, queryDataMap);
        if (!this.replaceValMap.isEmpty() && !this.aliasColumnMap.isEmpty()) {
            this.updateReplaceValMapWithAlias();
        }
        if (!this.replaceValMap.isEmpty() && !this.aliasColumnMap.isEmpty()) {
            this.updAliasMapWithReplaceValMap();
        }
    }

    public boolean aliasColumnNamesReplacememnt(Map<String, String> queryDataMap) {
        String aliasColumnName = queryDataMap.get("aliascolumnname");
        String newAliasName = queryDataMap.get("aliascolumnname");
        if (!aliasColumnName.equals(newAliasName = QueryConversionUtility.doReplaceFunctionVariables(newAliasName, this.replaceValMap, "COLUMN__"))) {
            queryDataMap.put("aliascolumnname", newAliasName);
            return true;
        }
        return false;
    }

    public boolean aliasNameReplaceInFrom(IQueryPatternsBO mapper, String sqlQuery, Map<String, String> queryDataMap) {
        boolean isvalidFrom = this.doCheckAliasFnReplace(queryDataMap, false, "from");
        boolean isvalidWhere = this.doCheckAliasFnReplace(queryDataMap, false, "where");
        return isvalidFrom || isvalidWhere;
    }

    private void doReplaceNestedAlias(IReplacerMap queryDataMap) {
        boolean isDistinct = false;
        String allColumnsWithCmnts = ((String)queryDataMap.get("aliascolumnname")).trim();
        if (QueryConversionUtility.containsCheck(allColumnsWithCmnts, "DISTINCT")) {
            allColumnsWithCmnts = allColumnsWithCmnts.replaceFirst("(?i)(?<!\\w)distinct\\s", "");
            isDistinct = true;
        }
        String[] placeHolderCommaArray = null;
        String allColumns = "";
        if (allColumnsWithCmnts.contains("#S#")) {
            placeHolderCommaArray = QueryConversionUtility.doGetArrSplit(allColumnsWithCmnts, ",");
            allColumns = allColumnsWithCmnts.replaceAll("(?i)#S#\\d+#E#", "");
        } else {
            allColumns = allColumnsWithCmnts;
        }
        allColumns = QueryConversionUtility.doRemoveExtraSpace(allColumns);
        String[] commaArray = null;
        commaArray = QueryConversionUtility.doGetArrSplit(allColumns, ",");
        Map<String, String> normalColumnsMap = this.teradataMapAlias.doGetColWithAlias(commaArray);
        if (!this.aliasColumnMap.isEmpty()) {
            commaArray = this.doChangeAliasinColumns(commaArray, normalColumnsMap);
            if (placeHolderCommaArray != null) {
                this.teradataMapAlias.changePlaceholderCol(placeHolderCommaArray, commaArray);
            }
            String[] arr = null;
            arr = placeHolderCommaArray != null ? placeHolderCommaArray : commaArray;
            List<String> arrAsList = Arrays.asList(arr);
            allColumns = QueryConversionUtility.doGetStrFrmListWithComma(arrAsList);
            if (isDistinct) {
                allColumns = "DISTINCT " + allColumns;
            }
            queryDataMap.put("aliascolumnname", allColumns);
        }
    }

    private String[] doChangeAliasinColumns(String[] commaArray, Map<String, String> normalColumnsMap) {
        String[] columnArrays = commaArray;
        Set<String> aliasSet = this.aliasColumnMap.keySet();
        for (Map.Entry<String, String> columnsEntry : normalColumnsMap.entrySet()) {
            String columnToChk = "";
            String aliasNCM = "";
            if (columnsEntry.getKey() != null) {
                columnToChk = columnsEntry.getKey().trim();
                aliasNCM = columnsEntry.getValue();
            }
            for (Map.Entry<String, String> aliasEntry : this.aliasColumnMap.entrySet()) {
                String aliasToChk = aliasEntry.getKey().trim();
                String columnACM = aliasEntry.getValue().trim();
                if (!QueryConversionUtility.equalCheck(columnToChk, aliasToChk) && (!QueryConversionUtility.containsCheck(columnToChk, "grouping") || !QueryConversionUtility.isExactMatch(columnToChk, aliasToChk))) continue;
                while (aliasSet.contains(columnACM)) {
                    columnACM = this.aliasColumnMap.get(columnACM);
                }
                this.teradataMapAlias.dpRplNestedAliasWithColVal(columnArrays, columnToChk, aliasNCM, aliasToChk, columnACM);
            }
        }
        return columnArrays;
    }

    public void doReplaceConstraintsIndex(Map<String, String> parserMap) {
        String tableColumns = parserMap.get("endschema");
        this.tblName = parserMap.get("tablename");
        LinkedHashMap<String, String> multiCommentMap = new LinkedHashMap<String, String>(10);
        String setFn = this.doReplaceConstraintSet(tableColumns, multiCommentMap, parserMap);
        String fname = parserMap.get("FILENAME");
        String finalCols = parserMap.get("endschema").replaceAll("\\/\\*.*?\\*\\/", "").trim();
        if (QueryConversionUtility.equalCheck(setFn, "SET") || !FeatureLoader.getStringProperty("session_mode").equalsIgnoreCase("ansi") && (QueryConversionUtility.equalCheck(setFn, "volatile") || setFn.isEmpty())) {
            finalCols = QueryConversionUtility.canonicalizeString(finalCols);
            if (!this.objIndexConstraintsBO.isPrimaryKey() && !finalCols.matches("(?i).*(?<!\\w)UNIQUE(?!\\w|\\sINDEX).*")) {
                this.columns = null;
                this.doReplaceConstraintUnion(finalCols, fname);
            }
        }
        if (this.isVolatileTbl) {
            TeradataMigrationService.addMultiSetTempTblsMap(fname, QueryConversionUtility.doGetSetTableName(this.tblName));
        }
        if (finalCols.matches("(?i)\\s*\\(\\s*LIKE(?!\\w).*")) {
            List<String> columnsList = null;
            Matcher tblMat = TBL_PATTERN.matcher(finalCols);
            boolean isExists = false;
            if (tblMat.find()) {
                String asTblNme = tblMat.group(1).trim();
                isExists = TeradataMigrationService.chkDateFormattblContains(asTblNme = QueryConversionUtility.toUpper(asTblNme));
                if (isExists) {
                    columnsList = TeradataMigrationService.getDateColumn(asTblNme);
                    this.tblName = this.tblName.replaceAll("\\s*\\.\\s*", ".");
                    for (String col : columnsList) {
                        TeradataMigrationService.addDateColumn(this.tblName, col);
                    }
                }
            }
        }
    }

    private String doReplaceConstraintSet(String tableColumns, Map<String, String> multiCommentMap, Map<String, String> parserMap) {
        String tableColumnsWOCmnt;
        String cmntPlaceholderAtStart = "";
        this.objIndexConstraintsBO = new IndexConstraintsBO();
        if (tableColumns.trim().startsWith("#S#")) {
            cmntPlaceholderAtStart = QueryConversionUtility.doGetStartCmnts(tableColumns);
        }
        if ((tableColumnsWOCmnt = tableColumns.replaceAll("(?i)#S#\\d+#E#", "").trim()).startsWith("(") || QueryConversionUtility.toUpper(tableColumnsWOCmnt).startsWith("AS ") || QueryConversionUtility.toUpper(tableColumnsWOCmnt).startsWith("AS(")) {
            TeradataQueryKeywordReplacer tqkr = new TeradataQueryKeywordReplacer();
            this.objIndexConstraintsBO = tqkr.doGetIndexConstraintsBO(tableColumns, tableColumnsWOCmnt, this.objIndexConstraintsBO, multiCommentMap);
            this.objIndexConstraintsBO = this.doDecideIndexesCreation(this.objIndexConstraintsBO, this.tblName);
            String finalScript = this.doGetScriptFromIndexes(this.objIndexConstraintsBO, multiCommentMap);
            if (!cmntPlaceholderAtStart.isEmpty()) {
                finalScript = cmntPlaceholderAtStart + " " + finalScript;
            }
            parserMap.put("endschema", finalScript);
        }
        String setFn = parserMap.get("setFn").trim();
        String tempSet = setFn.replaceAll("(?i)#S#\\d+#E#", "");
        this.isVolatileTbl = false;
        if (QueryConversionUtility.containsCheck(tempSet, "volatile")) {
            this.isVolatileTbl = true;
        }
        if (setFn.contains(" ")) {
            String[] setSplit = setFn.split(" ");
            String firstColumn = setSplit.length > 0 ? setSplit[0] : "";
            setFn = QueryConversionUtility.containsCheck(firstColumn, "SET") ? firstColumn : setSplit[setSplit.length - 1];
        }
        return setFn;
    }

    private void doReplaceConstraintUnion(String finalColsInp, String fname) {
        String finalCols = finalColsInp;
        if (finalCols.matches("(?i)\\s*\\(\\s*LIKE(?!\\w).*")) {
            finalCols = QueryConversionUtility.canonicalizeString(finalCols);
            Matcher tblMat = TBL_PATTERN.matcher(finalCols);
            boolean withoutPrimaryKeyTable = false;
            if (tblMat.find()) {
                String asTblNme = tblMat.group(1).trim();
                withoutPrimaryKeyTable = TeradataMigrationService.chkContainsTbl(fname, this.isVolatileTbl, asTblNme = QueryConversionUtility.toUpper(asTblNme));
                if (withoutPrimaryKeyTable) {
                    this.columns = TeradataMigrationService.getSetTableColumns(fname, this.isVolatileTbl, asTblNme);
                    this.tblName = this.tblName.replaceAll("\\s*\\.\\s*", ".");
                    TeradataMigrationService.addSetTableNameColListToMap(fname, this.isVolatileTbl, QueryConversionUtility.doGetSetTableName(this.tblName), this.columns);
                    if (this.isVolatileTbl) {
                        TeradataMigrationService.addSetTempTblsMap(fname, QueryConversionUtility.doGetSetTableName(this.tblName));
                        this.isVolatileTbl = false;
                    }
                }
            }
        } else {
            this.columns = this.teradataMapIndex.getConstraintIdxColsList(this.objIndexConstraintsBO);
            this.tblName = this.tblName.replaceAll("\\s*\\.\\s*", ".");
            TeradataMigrationService.addSetTableNameColListToMap(fname, this.isVolatileTbl, QueryConversionUtility.doGetSetTableName(this.tblName), this.columns);
            if (this.isVolatileTbl) {
                TeradataMigrationService.addSetTempTblsMap(fname, QueryConversionUtility.doGetSetTableName(this.tblName));
                this.isVolatileTbl = false;
            }
        }
    }

    private String doGetScriptFromIndexes(IIndexConstraintsBO objIndexConstraintsBOParam, Map<String, String> multiCommentMap) {
        String finalScript = null;
        finalScript = this.teradataMapIndex.doGetDDLColumnScript(objIndexConstraintsBOParam);
        String primaryICreation = objIndexConstraintsBOParam.getPrimaryICreation();
        if (primaryICreation != null) {
            finalScript = this.teradataMapIndex.updateScriptWithPrimIdx(finalScript, primaryICreation);
        } else if (!finalScript.matches("(?i)(?<!\\w)AS(?!\\w).*") && !finalScript.isEmpty()) {
            finalScript = "(" + finalScript + ")";
        }
        String onCommitRows = objIndexConstraintsBOParam.getOnCommitRows();
        if (onCommitRows != null) {
            if (finalScript.contains("##QUERY##") || QueryConversionUtility.containsCheck(finalScript, "select")) {
                finalScript = onCommitRows + " " + finalScript;
            } else if (finalScript.contains("DISTRIBUTE BY")) {
                int index = finalScript.indexOf("DISTRIBUTE BY");
                finalScript = finalScript.substring(0, index) + " " + onCommitRows + " " + finalScript.substring(index);
            } else {
                finalScript = finalScript + " " + onCommitRows;
            }
        }
        StringBuffer finalStrPartition = new StringBuffer(finalScript);
        if (multiCommentMap != null && !multiCommentMap.isEmpty()) {
            for (Map.Entry<String, String> entry : multiCommentMap.entrySet()) {
                finalStrPartition.append(entry.getValue());
            }
        }
        finalScript = finalStrPartition.toString();
        String extraKeywords = objIndexConstraintsBOParam.getExtraKeywords();
        if (extraKeywords.isEmpty()) {
            finalScript = finalScript + ";";
        } else {
            String extraKey = extraKeywords.replace(";", "");
            if (!finalScript.contains(extraKey.trim())) {
                finalScript = finalScript + extraKeywords;
            }
        }
        if (!finalScript.trim().endsWith(";")) {
            finalScript = finalScript + ";";
        }
        StringBuffer finalStr = new StringBuffer(finalScript);
        for (String index : this.allIndexList) {
            finalStr.append(IGaussDBConstants.NEW_LINE).append(" ").append(index);
        }
        return finalStr.toString();
    }

    private IIndexConstraintsBO doDecideIndexesCreation(IIndexConstraintsBO objIndexConstraintsBOParam, String tblNameParam) {
        if (objIndexConstraintsBOParam.isPrimaryKey()) {
            this.doIndexCreationForPrimaryKey(objIndexConstraintsBOParam, tblNameParam);
        } else {
            this.doIndexCreationForNoPrimaryKey(objIndexConstraintsBOParam, tblNameParam);
        }
        return objIndexConstraintsBOParam;
    }

    private void doIndexCreationForNoPrimaryKey(IIndexConstraintsBO objIndexConstraintsBOParam, String tblNameParam) {
        String distributeByHash = null;
        String primaryIndex = objIndexConstraintsBOParam.getPrimaryIndex();
        if (primaryIndex != null) {
            primaryIndex = this.getPrimaryIdx(primaryIndex);
        }
        if (primaryIndex == null) {
            if (!objIndexConstraintsBOParam.getUniqueList().isEmpty()) {
                primaryIndex = objIndexConstraintsBOParam.getUniqueList().get(0);
            } else if (!objIndexConstraintsBOParam.getUniqueIndexList().isEmpty()) {
                primaryIndex = objIndexConstraintsBOParam.getUniqueIndexList().get(0);
                primaryIndex = this.getPrimaryIdx(primaryIndex);
            }
            if (primaryIndex != null && primaryIndex.contains(",")) {
                primaryIndex = primaryIndex.substring(0, primaryIndex.indexOf(44));
            }
        }
        if (primaryIndex != null) {
            this.teradataMapIndex.doReplaceMapValuesToComment(objIndexConstraintsBOParam.getIndexMap());
            distributeByHash = "DISTRIBUTE BY HASH (" + primaryIndex + ")";
            objIndexConstraintsBOParam.setPrimaryICreation(distributeByHash);
            this.doChkForCreateIdxes(objIndexConstraintsBOParam, "unique", tblNameParam, primaryIndex, true);
            this.doChkForCreateIdxes(objIndexConstraintsBOParam, "uniqueindex", tblNameParam, primaryIndex, false);
        }
        this.doCreateIndexes(objIndexConstraintsBOParam.getIndexList(), "", tblNameParam);
    }

    private void doIndexCreationForPrimaryKey(IIndexConstraintsBO objIndexConstraintsBOParam, String tblNameParam) {
        String primaryKeyColumn = objIndexConstraintsBOParam.getPrimaryKeyCols();
        String primaryIndex = objIndexConstraintsBOParam.getPrimaryIndex();
        boolean isSuperSet = false;
        if (primaryIndex != null) {
            primaryIndex = this.getPrimaryIdx(primaryIndex);
            isSuperSet = this.teradataMapIndex.doChkForSuperSet(primaryKeyColumn, primaryIndex);
        }
        this.getDistriByHash(objIndexConstraintsBOParam, primaryIndex, isSuperSet);
        if (!isSuperSet && primaryIndex != null) {
            primaryIndex = this.setPrimaryIdx(objIndexConstraintsBOParam, primaryKeyColumn, primaryIndex);
        }
        if (!isSuperSet && primaryIndex == null) {
            if (primaryKeyColumn.contains(",")) {
                primaryIndex = primaryKeyColumn.substring(0, primaryKeyColumn.indexOf(44));
            } else if (!primaryKeyColumn.contains(",")) {
                primaryIndex = primaryKeyColumn;
            }
        }
        this.teradataMapIndex.doReplaceMapValuesToComment(objIndexConstraintsBOParam.getIndexMap());
        if (primaryIndex != null) {
            this.doChkForCreateIdxes(objIndexConstraintsBOParam, "unique", tblNameParam, primaryIndex, true);
            this.doChkForCreateIdxes(objIndexConstraintsBOParam, "uniqueindex", tblNameParam, primaryIndex, false);
        }
        this.doCreateIndexes(objIndexConstraintsBOParam.getIndexList(), "", tblNameParam);
    }

    private String setPrimaryIdx(IIndexConstraintsBO objIndexConstraintsBOParam, String primaryKeyColumn, String input) {
        String primaryIndex = input;
        String distributeByHash = "";
        if (primaryKeyColumn.contains(",")) {
            List<String> distributeByHashLst = QueryConversionUtility.getLstFrmStringWithComma(primaryIndex, true);
            List<String> primaryKeyColsLst = QueryConversionUtility.getLstFrmStringWithComma(primaryKeyColumn, true);
            distributeByHashLst.retainAll(primaryKeyColsLst);
            primaryIndex = distributeByHashLst.size() != 0 ? QueryConversionUtility.doGetStrFrmListWithComma(distributeByHashLst) : null;
        } else if (!primaryKeyColumn.contains(",")) {
            primaryIndex = null;
        }
        if (primaryIndex != null) {
            distributeByHash = "DISTRIBUTE BY HASH (" + primaryIndex + ")";
            objIndexConstraintsBOParam.setPrimaryICreation(distributeByHash);
        }
        return primaryIndex;
    }

    private void getDistriByHash(IIndexConstraintsBO objIndexConstraintsBOParam, String primaryIndex, boolean isSuperSet) {
        if (isSuperSet) {
            String distributeByHash = "DISTRIBUTE BY HASH (" + primaryIndex + ")";
            objIndexConstraintsBOParam.setPrimaryICreation(distributeByHash);
        }
    }

    private String getPrimaryIdx(String input) {
        String primaryIndex = input;
        if (primaryIndex.contains("-")) {
            primaryIndex = primaryIndex.substring(primaryIndex.indexOf(45) + 1);
        }
        return primaryIndex;
    }

    private void doChkForCreateIdxes(IIndexConstraintsBO objIndexConstraintsBOParam, String constraint, String tblNameParam, String distributeByHashCol, boolean isUniqueConstraint) {
        boolean isSuperSet = false;
        String idxName = null;
        List<String> indexList = null;
        indexList = constraint.equalsIgnoreCase("unique") ? objIndexConstraintsBOParam.getUniqueList() : objIndexConstraintsBOParam.getUniqueIndexList();
        for (String indexCol : indexList) {
            idxName = "";
            if (indexCol.contains("-")) {
                int idx = indexCol.indexOf(45);
                idxName = indexCol.substring(0, idx);
                indexCol = indexCol.substring(idx + 1);
            }
            if (!indexCol.equalsIgnoreCase(distributeByHashCol)) {
                if (indexCol.contains(",")) {
                    isSuperSet = this.teradataMapIndex.doChkForSuperSet(indexCol, distributeByHashCol);
                    if (isSuperSet) {
                        if (isUniqueConstraint) {
                            this.teradataMapIndex.doKeepUniqueConstraint(objIndexConstraintsBOParam, indexCol);
                            continue;
                        }
                        this.doCreateIndexes(indexCol, "UNIQUE", tblNameParam, idxName);
                        continue;
                    }
                    this.doCreateIndexes(indexCol, "", tblNameParam, idxName);
                    continue;
                }
                this.doCreateIndexes(indexCol, "", tblNameParam, idxName);
                continue;
            }
            if (isUniqueConstraint) {
                this.teradataMapIndex.doKeepUniqueConstraint(objIndexConstraintsBOParam, indexCol);
                continue;
            }
            if (FeatureLoader.getStringProperty("unique_primary_index_in_column_table").equalsIgnoreCase("false") && FeatureLoader.getStringProperty("rowstoreToColumnstore").equalsIgnoreCase("true")) continue;
            this.doCreateIndexes(indexCol, "UNIQUE", tblNameParam, idxName);
        }
    }

    private void doCreateIndexes(List<String> columnList, String unique, String tblNameParam) {
        StringBuffer indexScript = null;
        String idxName = null;
        if (columnList.size() != 0) {
            for (String columnName : columnList) {
                indexScript = new StringBuffer(128);
                idxName = "";
                if (columnName.contains("-")) {
                    int idx = columnName.indexOf(45);
                    idxName = columnName.substring(0, idx);
                    columnName = columnName.substring(idx + 1);
                }
                if (!columnName.trim().startsWith("(")) {
                    columnName = "(" + columnName + ")";
                }
                indexScript.append("CREATE").append(" ");
                if (!unique.isEmpty()) {
                    indexScript.append(unique).append(" ");
                }
                indexScript.append(QueryConversionUtility.toUpper("index")).append(" ");
                if (!idxName.isEmpty()) {
                    indexScript.append(idxName).append(" ");
                }
                indexScript.append("on").append(" ");
                indexScript.append(tblNameParam).append(" ");
                indexScript.append(columnName).append(";");
                this.allIndexList.add(indexScript.toString());
            }
        }
    }

    private void doCreateIndexes(String columnInp, String unique, String tblNameParam, String idxNameInp) {
        StringBuffer indexScript = null;
        String idxName = idxNameInp;
        String column = columnInp;
        if (column != null && !column.isEmpty()) {
            if (column.contains("-")) {
                int idx = column.indexOf(45);
                idxName = column.substring(0, idx);
                column = column.substring(idx + 1);
            }
            indexScript = new StringBuffer(128);
            if (!column.trim().startsWith("(")) {
                column = "(" + column + ")";
            }
            indexScript.append("CREATE").append(" ");
            if (!unique.isEmpty()) {
                indexScript.append(unique).append(" ");
            }
            indexScript.append(QueryConversionUtility.toUpper("index")).append(" ");
            if (idxName != null && !idxName.isEmpty()) {
                indexScript.append(idxName).append(" ");
            }
            indexScript.append("on").append(" ");
            indexScript.append(tblNameParam).append(" ");
            indexScript.append(column).append(";");
            this.allIndexList.add(indexScript.toString());
        }
    }

    public boolean doGrpingFn(Map<String, String> parserMap) {
        boolean isValid = false;
        GroupingFeature groupingFeature = new GroupingFeature();
        isValid = this.doCheckAliasFnReplace(parserMap, isValid, "grpelement");
        isValid = this.doCheckAliasFnReplace(parserMap, isValid, "havingClause");
        isValid = groupingFeature.doGrpingFn(parserMap, this.replaceValMap, this.aliasColumnMap);
        return isValid;
    }

    private void updAliasMapWithReplaceValMap() {
        String replaceKey = null;
        String aliasColumn = null;
        for (Map.Entry<String, String> replaceEntry : this.replaceValMap.entrySet()) {
            replaceKey = replaceEntry.getKey();
            for (Map.Entry<String, String> aliasEntry : this.aliasColumnMap.entrySet()) {
                aliasColumn = aliasEntry.getValue();
                if (!replaceKey.equals(aliasColumn)) continue;
                this.aliasColumnMap.put(aliasEntry.getKey(), replaceEntry.getValue());
            }
        }
    }

    private void updateReplaceValMapWithAlias() {
        for (Map.Entry<String, String> aliasEntry : this.aliasColumnMap.entrySet()) {
            String aliasName = aliasEntry.getKey();
            String aliasColumn = aliasEntry.getValue();
            for (Map.Entry<String, String> replaceEntry : this.replaceValMap.entrySet()) {
                String replaceMapVal = " " + replaceEntry.getValue() + " ";
                String replaceMapKey = replaceEntry.getKey();
                if (QueryConversionUtility.containsCheck(aliasColumn.trim(), replaceMapKey.trim())) continue;
                String patternString = QueryConversionUtility.doGetAliasPattern(aliasName);
                if (QueryConversionUtility.containsCheck(aliasColumn, "_COLUMN__") && !replaceMapVal.matches("(?i)(?:.*)\\$\\s*(?:\\{\\s*)?" + aliasName + "(?:\\s*\\})?(?:.*)")) {
                    replaceMapVal = replaceMapVal.replace(aliasName, "(" + aliasName + ")");
                }
                replaceMapVal = QueryConversionUtility.doReplaceSpecificGrp(replaceMapVal, patternString, "", this.aliasColumnMap.get(aliasName), 1, false);
                this.replaceValMap.put(replaceMapKey, replaceMapVal.trim());
            }
        }
    }

    public void changeInQualifyClause(IReplacerMap parserMap) {
        String qualifyClause = (String)parserMap.get("qualifyclause");
        LinkedHashMap<String, String> overMap = new LinkedHashMap<String, String>(10);
        qualifyClause = QueryConversionUtility.doReplaceOverStr(qualifyClause, overMap);
        List<String> colsLst = this.teradataMapIndex.getQualifyColsInLst(qualifyClause);
        String rankCol = null;
        boolean isValid = false;
        int colCnt = 1;
        StringBuffer colBuf = new StringBuffer(128);
        StringBuffer whereBuf = new StringBuffer(128);
        for (int iIndex = 0; iIndex < colsLst.size(); iIndex += 2) {
            String rankColInit = colsLst.get(iIndex);
            String rownumCnt = "ROW_NUM" + colCnt;
            rankCol = this.getRankColumn(parserMap, overMap, rankColInit);
            String colmn = colsLst.get(iIndex);
            colmn = QueryConversionUtility.getRplFromMap(colmn, overMap, "(##OVER##\\d+#)");
            String modifiedAnalyticCol = null;
            if (rankCol.matches("(?i).*(?<!\\w)(?:RANK|ROW_NUMBER|MDIFF|SUM)\\s*\\(.*")) {
                isValid = this.doCheckAliasFnReplace(parserMap, isValid, "QualifyCols");
                modifiedAnalyticCol = colmn.replace(rankCol.trim(), "Q" + (String)parserMap.get("QryCnt") + "." + rownumCnt);
                colsLst.set(iIndex, (String)parserMap.get("QualifyCols") + " as " + rownumCnt);
                colBuf.append(",").append(colsLst.get(iIndex));
            } else {
                modifiedAnalyticCol = this.getModCol(parserMap, rankCol, colmn);
            }
            this.getWhereBuff(colsLst, whereBuf, modifiedAnalyticCol, iIndex);
            ++colCnt;
        }
        String rowcolumns = this.teradataMapIndex.addOrderByColumn(parserMap, colCnt) + colBuf.toString();
        String whereBufStr = QueryConversionUtility.getRplFromMap(whereBuf.toString(), overMap, "(##OVER##\\d+#)");
        parserMap.put("rowcolumns", rowcolumns);
        parserMap.put("qualifyWhere", whereBufStr);
    }

    private void getWhereBuff(List<String> colsLst, StringBuffer whereBuf, String modifiedAnalyticCol, int iIndex) {
        whereBuf.append(modifiedAnalyticCol);
        if (iIndex < colsLst.size() - 2) {
            whereBuf.append(colsLst.get(iIndex + 1)).append(" ");
        }
    }

    private String getModCol(IReplacerMap parserMap, String rankCol, String colmn) {
        String rankColumn = rankCol.contains(".") ? rankCol.substring(rankCol.indexOf(46) + 1) : rankCol;
        String modifiedAnalyticCol = colmn.replace(rankCol.trim(), "Q" + (String)parserMap.get("QryCnt") + "." + rankColumn.trim());
        return modifiedAnalyticCol;
    }

    private String getRankColumn(IReplacerMap parserMap, Map<String, String> overMap, String input) {
        Matcher matchVal;
        String rankColInit = input;
        if (rankColInit.matches("(?i).*(?:<=|>=|<>|=|>|<|\\s*(?<!\\w)(is|in|not\\s+in)(?!\\w))(.*)") && (matchVal = COMPARISON_OPERATORS.matcher(rankColInit)).find()) {
            rankColInit = rankColInit.substring(0, matchVal.start(1));
        }
        rankColInit = QueryConversionUtility.getRplFromMap(rankColInit, overMap, "(##OVER##\\d+#)");
        String rankCol = QueryConversionUtility.doCorrectBrackets(rankColInit);
        parserMap.put("QualifyCols", rankCol);
        return rankCol;
    }
}

