/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.teradata;

import com.huawei.db.migration.common.features.MergeFeature;
import com.huawei.db.migration.database.bo.IIndexConstraintsBO;
import com.huawei.db.migration.interfaces.IReplacerMap;
import com.huawei.db.migration.util.ColumnSplitter;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TeradataMapHelperIndex {
    private static final Pattern RANK_SPLIT_PAT = Pattern.compile("(?i)(?<!\\w)(AND|OR)(?!\\w)");
    private static final Pattern ANALYTIC_PATTERN = Pattern.compile("(?i)\\s*(?<!\\w)(RANK|ROW_NUMBER)(?!\\w).*");

    public boolean doChkForSuperSet(String uniqueCol, String primaryKeyColumn) {
        List<String> primaryKeyColsLst;
        boolean isSuperSet = false;
        List<String> uniqueColsLst = QueryConversionUtility.getLstFrmStringWithComma(uniqueCol, true);
        if (uniqueColsLst.containsAll(primaryKeyColsLst = QueryConversionUtility.getLstFrmStringWithComma(primaryKeyColumn, true))) {
            isSuperSet = true;
        }
        return isSuperSet;
    }

    public void doKeepUniqueConstraint(IIndexConstraintsBO objIndexConstraintsBO, String indexCol) {
        Map<String, String> colIndexMap = objIndexConstraintsBO.getColIndexMap();
        Map<String, String> indexMap = objIndexConstraintsBO.getIndexMap();
        String uniqueVal = null;
        for (Map.Entry<String, String> uniqueCol : colIndexMap.entrySet()) {
            if (!uniqueCol.getKey().contains(indexCol)) continue;
            uniqueVal = indexMap.get(uniqueCol.getValue());
            uniqueVal = uniqueVal.substring(2, uniqueVal.length() - 2);
            String lwrVal = QueryConversionUtility.toLower(uniqueVal);
            if (!uniqueVal.equalsIgnoreCase("unique") && (lwrVal.startsWith("constraint") || lwrVal.startsWith("unique"))) {
                uniqueVal = "," + uniqueVal;
            }
            indexMap.put(uniqueCol.getValue(), uniqueVal);
        }
    }

    public void doReplaceMapValuesToComment(Map<String, String> indexMap) {
        if (!indexMap.isEmpty()) {
            for (Map.Entry<String, String> indexMapEntry : indexMap.entrySet()) {
                indexMap.put(indexMapEntry.getKey(), "/*" + indexMapEntry.getValue() + "*/");
            }
        }
    }

    public String doGetDDLColumnScript(IIndexConstraintsBO objIndexConstraintsBO) {
        String finalScript = "";
        StringBuffer sb = new StringBuffer(128);
        List<String> columnArrays = objIndexConstraintsBO.getColumnArrays();
        int columnArraySize = columnArrays.size();
        String column = null;
        String nextCol = null;
        for (int iIndex = 0; iIndex < columnArraySize; ++iIndex) {
            column = columnArrays.get(iIndex);
            if (iIndex != columnArraySize - 1) {
                nextCol = columnArrays.get(iIndex + 1);
            }
            if (nextCol != null && !nextCol.startsWith("#" + QueryConversionUtility.toUpper("unique") + "#") && !nextCol.startsWith("/*")) {
                sb.append(column).append(",");
            } else {
                sb.append(column);
            }
            nextCol = null;
        }
        finalScript = sb.toString().trim();
        if (!finalScript.isEmpty() && (finalScript = QueryConversionUtility.doReplaceFunctionVariables(finalScript, objIndexConstraintsBO.getIndexMap(), "#" + QueryConversionUtility.toUpper("unique") + "#")).endsWith(",")) {
            finalScript = finalScript.substring(0, finalScript.length() - 1);
        }
        return finalScript;
    }

    public String updateScriptWithPrimIdx(String finalScriptInp, String primaryICreation) {
        String finalScript = finalScriptInp;
        String finalScriptUpper = QueryConversionUtility.toUpper(finalScript.trim());
        if (primaryICreation != null && !primaryICreation.isEmpty()) {
            finalScript = !finalScriptUpper.startsWith("AS ") && !finalScriptUpper.startsWith("AS(") ? "(" + finalScript + ")" + primaryICreation : finalScript + primaryICreation;
        } else if (!finalScriptUpper.startsWith("AS ") && !finalScriptUpper.startsWith("AS(")) {
            finalScript = "(" + finalScript + ")";
        }
        return finalScript;
    }

    public ArrayList<String> getConstraintIdxColsList(IIndexConstraintsBO objIndexConstraintsBO) {
        ArrayList<String> columns = new ArrayList<String>(objIndexConstraintsBO.getColumnArrays().size());
        for (String column : objIndexConstraintsBO.getColumnArrays()) {
            column = column.replaceAll("\\/\\*.*?\\*\\/", "").trim();
            String columnUpper = QueryConversionUtility.toUpper(column);
            if (column.startsWith("#") || columnUpper.startsWith("LIKE") || columnUpper.startsWith("AS") || columnUpper.isEmpty()) continue;
            if (QueryConversionUtility.containsCheck(column, "default")) {
                String columnName = column.substring(0, column.indexOf(32));
                int index = QueryConversionUtility.toLower(column).indexOf("default");
                String defaultStr = column.substring(index).trim() + " ";
                int defSpace = defaultStr.indexOf(32);
                defaultStr = defaultStr.substring(defSpace).trim();
                columns.add(columnName + "#~#" + defaultStr);
                continue;
            }
            int spaceIndex = (column = column.replaceFirst("(?i)not\\s+null", "").replaceAll("(?i)default", "")).indexOf(32);
            if (spaceIndex == -1) continue;
            columns.add(column.substring(0, spaceIndex) + "#~#" + QueryConversionUtility.toUpper("null") + "::" + column.substring(spaceIndex + 1));
        }
        return columns;
    }

    public boolean mergeFn(Map<String, String> parserMap) {
        boolean isValid = false;
        MergeFeature commonFeature = new MergeFeature();
        isValid = commonFeature.mergeFn(parserMap);
        return isValid;
    }

    public List<String> getQualifyColsInLst(String qualifyClause) {
        ArrayList<String> colsLst = new ArrayList<String>(10);
        Matcher matchSplit = RANK_SPLIT_PAT.matcher(qualifyClause);
        int tempIdx = 0;
        int startIdx = 0;
        String andOr = null;
        while (matchSplit.find()) {
            startIdx = matchSplit.start(1);
            andOr = matchSplit.group(1);
            colsLst.add(qualifyClause.substring(tempIdx, startIdx));
            colsLst.add(andOr);
            tempIdx = startIdx + andOr.length();
        }
        colsLst.add(qualifyClause.substring(tempIdx));
        return colsLst;
    }

    public String addOrderByColumn(IReplacerMap parserMap, int colCntInp) {
        String orderBy = (String)parserMap.get("orderBy");
        StringBuffer buffer = new StringBuffer(128);
        int colCnt = colCntInp;
        if (orderBy != null && !orderBy.isEmpty()) {
            String orderByStrRmvd = orderBy.replaceFirst("(?i)(?<!\\w)order\\s+by(?!\\w)", "");
            ColumnSplitter splitter = new ColumnSplitter();
            List<String> orderbyColsList = splitter.doGetAllColumns(orderByStrRmvd);
            List<String> selectColsList = splitter.doGetAllColumns((String)parserMap.get("aliascolumnname"));
            ArrayList<String> modifiedColsList = new ArrayList<String>(10);
            this.getModifiedColsList(selectColsList, modifiedColsList);
            Pattern arithmeticPattern = Pattern.compile("\\+|\\-|\\*|\\/|\\%|\\^|\\||\\&");
            for (String column : orderbyColsList) {
                String columnToCheck = this.getColToCheck(column = column.replaceAll("(?i)#S#\\d+#E#", "").replaceAll("\\s*,\\s*", ","));
                boolean hasColumn = modifiedColsList.contains(columnToCheck.trim());
                if (hasColumn || column.matches("\\d+")) continue;
                Matcher arthimeticMatcher = arithmeticPattern.matcher(column.trim());
                Matcher analyticMatcher = ANALYTIC_PATTERN.matcher(column.trim());
                if (arthimeticMatcher.find() || analyticMatcher.find()) {
                    String rownumCnt = "ROW_NUM" + colCnt;
                    buffer.append(",").append(column).append(" as ").append(rownumCnt);
                    orderBy = orderBy.replace(column, rownumCnt);
                    ++colCnt;
                    continue;
                }
                buffer.append(",");
                buffer.append(column);
                orderBy = orderBy.replace(column, column);
            }
            parserMap.put("orderBy", orderBy);
        }
        return buffer.toString();
    }

    private String getColToCheck(String column) {
        Pattern ascDescPat = Pattern.compile("(?i)(.*)(?<!\\w)(?:ASC|DESC)(?!\\w)");
        Matcher ascDescMat = ascDescPat.matcher(column);
        String columnToCheck = column;
        if (ascDescMat.find()) {
            columnToCheck = ascDescMat.group(1);
        }
        return columnToCheck;
    }

    private void getModifiedColsList(List<String> selectColsList, List<String> modifiedColsList) {
        Pattern aliasPattern = Pattern.compile("(?i)((([\\s]*\\$?\\'?[\\s]*\\w*[\\.]?(?:\\w+|##subQuery##\\d+__)[\\s]*?\\'?|\\'.*?\\'|\\\".*?\\\")|(\\w+[\\s]*?\\w*[\\s]*?)|(\\'[\\s]*\\')|(\\w+?\\(\\s*.*?\\))|\\(\\s*\\w*\\s*\\))((\\s+AS\\s+)|(\\s))(\\\".*?\\\"|\\w+))");
        for (String colInSelect : selectColsList) {
            Matcher aliasMatcher = aliasPattern.matcher(colInSelect);
            if (aliasMatcher.find()) {
                String columnName = aliasMatcher.group(2);
                modifiedColsList.add(columnName);
                String aliasName = aliasMatcher.group(10);
                if (columnName.equals(aliasName)) continue;
                modifiedColsList.add(aliasName);
                continue;
            }
            modifiedColsList.add(colInSelect);
        }
    }

    public void changeOrderBy(IReplacerMap parserMap) {
        String orderBy = (String)parserMap.get("orderBy");
        if (orderBy != null && !orderBy.isEmpty()) {
            String qryCnt = (String)parserMap.get("QryCnt");
            String orderByStrRmvd = orderBy.replaceFirst("(?i)(?<!\\w)order\\s+by(?!\\w)", "");
            String[] cols = orderByStrRmvd.split(",");
            List<String> colsList = Arrays.asList(cols);
            String column = null;
            for (int iIndex = 0; iIndex < colsList.size(); ++iIndex) {
                column = colsList.get(iIndex);
                String startColCmnt = QueryConversionUtility.doGetStartCmnts(column);
                String endColCmnt = QueryConversionUtility.doGetEndCmnts(column);
                if ((column = column.replaceAll("(?i)#S#\\d+#E#", "").trim()).contains(".")) {
                    colsList.set(iIndex, startColCmnt + "Q" + qryCnt + column.substring(column.indexOf(46)) + endColCmnt);
                    continue;
                }
                if (column.contains(".") || column.matches("\\d+")) continue;
                colsList.set(iIndex, startColCmnt + "Q" + qryCnt + "." + column + endColCmnt);
            }
            parserMap.put("orderBy", "order by " + colsList.toString().substring(1, colsList.toString().length() - 1));
        }
    }
}

