/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.teradata;

import com.huawei.db.migration.database.bo.IQueryPatternsBO;
import com.huawei.db.migration.database.bo.IQuerySplitterPatternsBO;
import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.handlers.TeradataMigrationTaskHandler;
import com.huawei.db.migration.interfaces.IMigrationMapper;
import com.huawei.db.migration.interfaces.IMigrationParser;
import com.huawei.db.migration.interfaces.IMigrationPatternHandler;
import com.huawei.db.migration.interfaces.IReplacerMap;
import com.huawei.db.migration.replacer.ReplacerMap;
import com.huawei.db.migration.services.TeradataMigrationService;
import com.huawei.db.migration.teradata.DBCSystemUtil;
import com.huawei.db.migration.teradata.TeradataFnIntoExists;
import com.huawei.db.migration.teradata.TeradataMapHelperAlias;
import com.huawei.db.migration.teradata.TeradataQueryKeywordReplacer;
import com.huawei.db.migration.teradata.TeradataTimeUtility;
import com.huawei.db.migration.teradata.TeradataUtilityExt;
import com.huawei.db.migration.util.ColumnSplitter;
import com.huawei.db.migration.util.FeatureLoader;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.PlaceHolderUtility;
import com.huawei.db.migration.util.ProgressUtil;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TeradataPatternHandler
implements IMigrationPatternHandler {
    private static final Logger logger = LogManager.getLogger(TeradataPatternHandler.class);
    private static final Pattern SELECT_FROM_PAT = Pattern.compile("(?i)(?<!\\w)select(?!\\w)(.*?)(?<!\\w)from(?!\\w)");
    private static final Pattern SELECT_FROM_WHERE_PAT = Pattern.compile("(?i)SELECT(.*?)(?<!\\w)from(?!\\w)(.*?)(?<!\\w)where(?!\\w)(.*?);|$");
    private static int tabAliasCnt = 0;
    private String fileName = null;
    private Map<String, String> subQueryTrackMap = null;
    private int counter = 0;
    private int qryCnt = 0;
    private Map<String, String> replaceValMap = new LinkedHashMap<String, String>(10);
    private IQuerySplitterPatternsBO splitterPatternBO = null;
    private List<IQueryPatternsBO> queryPatterns = null;

    public static int getTabaliasCnt() {
        return tabAliasCnt;
    }

    public static void setTabaliasCnt(int cnt) {
        tabAliasCnt = cnt;
    }

    @Override
    public String doSplit(String inputVal, List<?> patterns, List<?> splitterPatterns, int position) throws MigrationServiceException {
        String input = inputVal;
        this.subQueryTrackMap = new TreeMap<String, String>();
        this.counter = 0;
        this.qryCnt = 1;
        TeradataPatternHandler.setTabaliasCnt(1);
        List<?> querySplitterPatterns = splitterPatterns;
        String outputQuery = null;
        if (querySplitterPatterns.size() == 1) {
            this.splitterPatternBO = (IQuerySplitterPatternsBO)querySplitterPatterns.get(0);
            List<String> subQueryList = QueryConversionUtility.getSubQueryList(input);
            while (subQueryList.size() > 0) {
                input = this.replaceSubqueries(input, subQueryList);
                subQueryList = QueryConversionUtility.getSubQueryList(input);
            }
            IReplacerMap spliterQryMap = null;
            boolean mergeFlag = false;
            spliterQryMap = this.getMergeFlag(input = this.getInpQry(input), this.splitterPatternBO, mergeFlag);
            if (!spliterQryMap.isEmpty()) {
                String innerQry = (String)spliterQryMap.get("innerquery");
                if (innerQry == null) {
                    throw new MigrationServiceException("Invalid Query");
                }
                String innerQuery = innerQry = QueryConversionUtility.doRemoveExtraSpace(innerQry);
                this.queryPatterns = patterns;
                outputQuery = this.doInnerQryMigration(position, spliterQryMap, innerQry, innerQuery, inputVal);
            } else {
                logger.info(MessageLoader.getMessage("noDataSplitter"), (Object)this.fileName, (Object)MessageLoader.getMessage("queryPosInfo"), (Object)position);
                outputQuery = input;
            }
        } else {
            throw new MigrationServiceException("[DSC_ERR_003_008] " + MessageLoader.getMessage("DSC_ERR_003_008"));
        }
        return outputQuery;
    }

    private IReplacerMap getMergeFlag(String input, IQuerySplitterPatternsBO splitterPatternBO, boolean flag) {
        IReplacerMap spliterQryMap;
        boolean mergeFlag = flag;
        if (QueryConversionUtility.containsCheck(input, "merge") && input.matches("(?i).*(?<!\\w)merge(?!\\w)\\s*(?:#S#\\d+#E#\\s*)*into(?!\\w).*")) {
            boolean bl = mergeFlag = !"None".equalsIgnoreCase(FeatureLoader.getStringProperty("mergeImplementation"));
        }
        if (mergeFlag) {
            spliterQryMap = new ReplacerMap();
            spliterQryMap.put("outterquery", "");
            spliterQryMap.put("innerquery", input);
            if (QueryConversionUtility.containsCheck(input, "INSERT")) {
                this.doChkSetTable(input, mergeFlag);
            }
        } else {
            spliterQryMap = this.getSplittedQueryMap(input, splitterPatternBO);
        }
        return spliterQryMap;
    }

    private String getInpQry(String input) {
        String renameInput = null;
        if (QueryConversionUtility.containsCheck(input, "rename")) {
            renameInput = QueryConversionUtility.toLower(input).replaceAll("(?i)#S#\\d+#E#", "").trim();
            input = this.checkRename(input, renameInput);
        }
        return input;
    }

    private String checkRename(String input, String renameInput) {
        Pattern patternRename;
        Matcher matcherRename;
        String output = input;
        if (output.matches("(?i).*(?<!\\w)rename(?!\\w)\\s*(?:#S#\\d+#E#\\s*)*table(?!\\w).*") && (matcherRename = (patternRename = Pattern.compile("(?i)(?<!\\w)rename\\s+table\\s+(?:\\$?\\s*\\{?\\w+\\s*\\}?\\.\\s*\\$?\\s*\\{?\\w+\\}?|\\$?\\s*\\{?\".*?\"\\s*\\}?\\.\\s*\\$?\\s*\\{?\".*?\"\\}?|\\$?\\s*\\{?\".*?\"\\s*\\}?\\.\\s*\\$?\\s*\\{?\\w+\\}?|\\$?\\s*\\{?\\w+\\s*\\}?\\.\\s*\\$?\\s*\\{?\".*?\"\\}?|\\$?\\s*\\{?\".*?\"\\}?|\\$?\\s*\\{?\\w+\\}?)\\s+(to|as)\\s+(?:\\$?\\s*\\{?\\w+\\s*\\}?\\.\\s*\\$?\\s*\\{?\\w+\\}?|\\$?\\s*\\{?\".*?\"\\s*\\}?\\.\\s*\\$?\\s*\\{?\".*?\"\\}?|\\$?\\s*\\{?\".*?\"\\s*\\}?\\.\\s*\\$?\\s*\\{?\\w+\\}?|\\$?\\s*\\{?\\w+\\s*\\}?\\.\\s*\\$?\\s*\\{?\".*?\"\\}?|\\$?\\s*\\{?\".*?\"\\}?|\\$?\\s*\\{?\\w+\\}?)")).matcher(renameInput)).find()) {
            output = output.replaceFirst("(?i)(?<!\\w)rename(?!\\w)", "ALTER ");
            output = output.replaceFirst("(?i)(?<!\\w)to|as(?!\\w)", "RENAME TO ");
        }
        return output;
    }

    private String doInnerQryMigration(int position, IReplacerMap spliterQryMap, String innerQryInp, String innerQuery, String unformatedInput) throws MigrationServiceException {
        String outputQuery = null;
        String intermOutputQuery = null;
        String innerQry = innerQryInp;
        if (QueryConversionUtility.isSubQueryMatches(innerQuery) && !QueryConversionUtility.getSubQueryList(innerQuery).isEmpty()) {
            logger.debug("Splitter Pattern & SubQuery Match Found");
            innerQry = this.doUnionCheck(this.queryPatterns, position, innerQry, unformatedInput);
            spliterQryMap.put("replacementoutquery", innerQry);
            String outterQry = QueryConversionUtility.doReplaceFunctionVariables((String)spliterQryMap.get("outterquery"), this.subQueryTrackMap, "##SUBQUERY##");
            spliterQryMap.put("outterquery", outterQry);
            outputQuery = spliterQryMap.doSqlReplacement(this.splitterPatternBO.getFinalReplacementPattern());
        } else {
            logger.debug("Splitter Pattern Match Found and no subqueries found in the Query");
            String splittedInputQuery = (String)spliterQryMap.get(this.splitterPatternBO.getMigrationToolInput());
            intermOutputQuery = this.doSubQryConversionReplace(this.queryPatterns, position, splittedInputQuery, unformatedInput);
            intermOutputQuery = this.doUnionCheck(this.queryPatterns, position, splittedInputQuery, unformatedInput);
            intermOutputQuery = QueryConversionUtility.doReplaceFunctionVariables(intermOutputQuery, this.subQueryTrackMap, "##SUBQUERY##");
            spliterQryMap.put("replacementoutquery", intermOutputQuery);
            String outterQry = QueryConversionUtility.doReplaceFunctionVariables((String)spliterQryMap.get("outterquery"), this.subQueryTrackMap, "##SUBQUERY##");
            spliterQryMap.put("outterquery", outterQry);
            outputQuery = spliterQryMap.doSqlReplacement(this.splitterPatternBO.getFinalReplacementPattern());
        }
        return outputQuery;
    }

    private String doSubQryConversionReplace(List<IQueryPatternsBO> mapper, int position, String innerQry, String unformatedInput) throws MigrationServiceException {
        for (Map.Entry<String, String> subIndividualQuery : this.subQueryTrackMap.entrySet()) {
            String subQuery = subIndividualQuery.getValue();
            subQuery = subQuery.replaceFirst("\\(", "");
            int index = subQuery.lastIndexOf(41);
            subQuery = subQuery.substring(0, index);
            String intermSubOutputQuery = this.doUnionCheck(mapper, position, subQuery, unformatedInput);
            this.subQueryTrackMap.put(subIndividualQuery.getKey(), "(" + intermSubOutputQuery + ")");
        }
        return innerQry;
    }

    private String doUnionCheck(List<IQueryPatternsBO> mapper, int position, String inputQuery, String unformatedInput) throws MigrationServiceException {
        String outputQuery = null;
        String inputQueryWithQuote = null;
        LinkedHashMap<String, String> unionMap = new LinkedHashMap<String, String>(10);
        List<IQueryPatternsBO> decideMappers = QueryConversionUtility.getMajorPatterns(mapper, inputQuery, "(?<!\\w)Qualify\\s+|\\s+top\\s+|(?<!\\w)Merge\\s+", "Qualify|Top");
        String temp = null;
        LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
        inputQueryWithQuote = QueryConversionUtility.getSingleDoubleQuoteMap(inputQuery, quoteMap);
        if (QueryConversionUtility.unionSplitter(inputQueryWithQuote, unionMap, 0)) {
            StringBuffer unionQry = new StringBuffer();
            for (Map.Entry singleQuery : unionMap.entrySet()) {
                temp = ((String)singleQuery.getKey()).replaceFirst("#\\d+#", "");
                temp = this.doQueryConversion(temp, decideMappers, position, unformatedInput, quoteMap);
                ++this.qryCnt;
                unionQry.append(" ").append(temp).append(" ").append((String)singleQuery.getValue()).append(" ");
            }
            outputQuery = unionQry.toString();
        } else {
            outputQuery = this.doQueryConversion(inputQuery, decideMappers, position, unformatedInput, quoteMap);
            ++this.qryCnt;
        }
        inputQueryWithQuote = QueryConversionUtility.getRplFromMap(outputQuery, quoteMap, "(##QUOTE##\\d+#)");
        return inputQueryWithQuote;
    }

    private String doQueryConversion(String ipQry, List<IQueryPatternsBO> mappers, int position, String unformatedInput, Map<String, String> quoteMap) throws MigrationServiceException {
        TreeMap<String, String> functionMap = new TreeMap<String, String>();
        String query = QueryConversionUtility.doReplaceFrom(ipQry, functionMap);
        query = TeradataUtilityExt.handlingTopWithTiesWithOutOrderBy(query);
        query = this.modifyColumnsForUserEnvironmentDate(query);
        query = this.modifyOrderGroupForUserEnvironmentDate(query);
        query = TeradataTimeUtility.modifyOrderGroupForUserEnvironmentTime(query);
        query = TeradataQueryKeywordReplacer.doReplaceWhereGrpByOrdrByClauses(query);
        DBCSystemUtil dbcSystemUtil = new DBCSystemUtil();
        if (QueryConversionUtility.containsCheck(query = dbcSystemUtil.changeDbcProperty(this.replaceValMap, query), "dbc.sessioninfoV") || QueryConversionUtility.containsCheck(query, "dbc.sessioninfo")) {
            query = this.doChangeNameOfDbcsessionTbl(query);
        }
        String inputSql = query.replaceAll("\\s+,\\s+|\\s+,|,\\s+", ",");
        String grpByElmts = null;
        Pattern pattern = Pattern.compile("(?i)((#s#\\d+#e#\\s*)?\\s*group(?:(\\s*#s#\\d+#e#\\s*))?\\s*(?<!\\w)by(?!\\w)(\\s*#s#\\d+#e#\\s*)?\\s+(.*?)(ORDER\\s+BY|;|$))");
        Matcher matcher = pattern.matcher(inputSql);
        if (matcher.find()) {
            grpByElmts = matcher.group(5);
        }
        query = TeradataQueryKeywordReplacer.doReplaceCSUM(query);
        if ((query = this.rankAndRowNumInColumn(query)).matches("(?i).*(#s#\\d+#e#\\s*)*?\\s*partition(?:(\\s*#s#\\d+#e#\\s*)*)?\\s*(?<!\\w)by(?!\\w)(\\s*#s#\\d+#e#\\s*)*?(((\\$?(\\w+\\.?\\w+)|\\d+)\\,?)*).*") && grpByElmts != null) {
            query = this.doChangePartitionBycols(query);
        }
        query = this.doAddAliasForExpression(query);
        TeradataMigrationTaskHandler taskHandler = new TeradataMigrationTaskHandler();
        IMigrationParser objParser = taskHandler.getParser();
        IMigrationMapper objMapper = taskHandler.getMapper();
        String outputQuery = this.doPatternSplitter(query, mappers, objMapper, objParser);
        if (QueryConversionUtility.containsCheck(outputQuery, "MDIFF")) {
            outputQuery = TeradataQueryKeywordReplacer.doReplaceMDIFF(outputQuery);
        }
        if (unformatedInput.matches("(?i).*?(?<!\\w)SELECT(?!\\w).*?(?<!\\w)(UNION|UNION\\+ALL|MINUS|INTERSECT|EXCEPT)(?!\\w).*?(?<!\\w)SELECT(?!\\w).*")) {
            String regex = "(?i)(?<!\\w)select(?!\\w)(.*?)($|(?<!\\w)from)(?!\\w)";
            outputQuery = QueryConversionUtility.doRplSingleQuoteInColumn(outputQuery, regex, quoteMap);
        }
        TeradataFnIntoExists intoExists = new TeradataFnIntoExists();
        outputQuery = intoExists.doIntoExistsConversion(outputQuery, this.subQueryTrackMap, functionMap);
        outputQuery = QueryConversionUtility.doReplaceFunctionVariables(outputQuery, functionMap, "__FUNCTION__");
        if (FeatureLoader.getBooleanProperty("tdcolumnInSensitive")) {
            outputQuery = this.doRemoveQuotesInColms(outputQuery);
        }
        return outputQuery;
    }

    private String doRemoveQuotesInColms(String inputQry) {
        String input = inputQry;
        Matcher matcher = SELECT_FROM_PAT.matcher(input);
        String columns = null;
        if (matcher.find()) {
            columns = matcher.group(1).trim();
            ColumnSplitter splitter = new ColumnSplitter();
            List<String> colmLst = splitter.doGetAllColumns(columns);
            String columnsReplc = columns;
            for (String colm : colmLst) {
                columnsReplc = this.doReplaceDoubleQuotesInColumns(columnsReplc, colm);
            }
            input = input.replace(columns, columnsReplc);
            input = this.doRemoveDoubleQuotesInJoinOnCol(input);
        }
        return input;
    }

    private String doRemoveDoubleQuotesInJoinOnCol(String inputQry) {
        String input = inputQry;
        Pattern pattern = Pattern.compile("(?i)(?:join|(?:(?:self|left|right|inner|outer|cross)\\s+join)|(?:left|right)(?:\\s+(?:inner|outer)\\s+join)|full(?:(?:\\s+(?:inner|outer))?\\s+join))(?:.*?)(?<!\\w)on(?!\\w)(.*?)(?<!\\w)(?:AND|OR|$|;)(?!\\w)");
        Matcher matcher = pattern.matcher(input);
        String columns = null;
        while (matcher.find()) {
            columns = matcher.group(1).trim();
            if (QueryConversionUtility.containsCheck(columns, " ON ")) {
                String[] colOnArr;
                for (String colms : colOnArr = columns.split("(?i)on(?![^(]*\\))")) {
                    input = this.doRemoveQuotesInJoinOnForOneColm(input, colms);
                }
                continue;
            }
            input = this.doRemoveQuotesInJoinOnForOneColm(input, columns);
        }
        return input;
    }

    private String doRemoveQuotesInJoinOnForOneColm(String input, String columns) {
        String[] colArr = columns.split("=(?![^(]*\\))");
        String updatedColumns = "";
        if (colArr.length > 1) {
            String firstCol = colArr[0].trim();
            String secndCol = colArr[1].trim();
            updatedColumns = this.doRemoveOnlyDoubleQuotesInJoinOn(columns, firstCol);
            input = input.replace(columns, updatedColumns);
            updatedColumns = this.doRemoveOnlyDoubleQuotesInJoinOn(columns, secndCol);
            input = input.replace(columns, updatedColumns);
        }
        return input;
    }

    private String doRemoveOnlyDoubleQuotesInJoinOn(String columns, String firstCol) {
        if (firstCol.contains("\"")) {
            int dblQtedColmIndex = firstCol.indexOf("\"");
            String quotedStr = firstCol.substring(dblQtedColmIndex).trim();
            char firstChar = quotedStr.charAt(1);
            if (firstChar != '$' && firstChar != '#') {
                quotedStr = quotedStr.replace("\"", "");
            }
            String colmnFull = firstCol.substring(0, dblQtedColmIndex).trim() + quotedStr;
            columns = columns.replace(firstCol, colmnFull);
        }
        return columns;
    }

    private String doReplaceDoubleQuotesInColumns(String columnsReplc, String colm) {
        if (QueryConversionUtility.properTerminated(colm)) {
            String alias = "";
            String colmnWOAlias = colm;
            if (QueryConversionUtility.containsCheck(colm = colm.trim(), " AS ")) {
                colmnWOAlias = colm.split("(?i)\\s+AS\\s+")[0];
                alias = colm.substring(colmnWOAlias.length());
            }
            if (colmnWOAlias.contains("\"")) {
                int dblQtedColmIndex = colmnWOAlias.indexOf("\"");
                String quotedStr = colmnWOAlias.substring(dblQtedColmIndex).trim();
                char firstChar = quotedStr.charAt(1);
                if (firstChar != '$' && firstChar != '#') {
                    quotedStr = quotedStr.replace("\"", "");
                }
                String colmnWithAlias = colmnWOAlias.substring(0, dblQtedColmIndex).trim() + quotedStr + alias;
                columnsReplc = columnsReplc.replace(colm, colmnWithAlias);
            }
        }
        return columnsReplc;
    }

    private String doChangeNameOfDbcsessionTbl(String input) {
        String inputStr = input;
        Matcher matcher = SELECT_FROM_WHERE_PAT.matcher(inputStr);
        if (matcher.find()) {
            String colmInWhreCluase;
            String columns = matcher.group(1);
            String tblName = matcher.group(2);
            String whereClause = matcher.group(3);
            String colmnsModified = this.doModifyColumns(columns);
            inputStr = inputStr.replace(columns, " " + colmnsModified + " ");
            String string = inputStr = tblName != null ? inputStr.replace(tblName, " pg_catalog.pg_stat_activity ") : inputStr;
            if (whereClause != null && QueryConversionUtility.containsCheck(whereClause, "sessionno") && (colmInWhreCluase = whereClause.substring(0, whereClause.indexOf("=")).trim()).equalsIgnoreCase("sessionno")) {
                String whereClauseUpd = whereClause.replace(colmInWhreCluase, "pid");
                inputStr = inputStr.replace(whereClause, " " + whereClauseUpd + " ");
            }
        }
        return inputStr;
    }

    private String doModifyColumns(String columns) {
        ColumnSplitter splitter = new ColumnSplitter();
        List<String> columnList = splitter.doGetAllColumns(columns);
        StringBuffer colmnsBuf = new StringBuffer();
        for (String colms : columnList) {
            String colmsTrim = colms.trim();
            if (!this.doCheckAlias(colmsTrim)) {
                if (colmsTrim.equalsIgnoreCase("username")) {
                    colmsTrim = "usename AS " + colmsTrim;
                } else if (colmsTrim.equalsIgnoreCase("clientsystemuserid")) {
                    colmsTrim = "usename AS " + colmsTrim;
                } else if (colmsTrim.equalsIgnoreCase("clientipaddress")) {
                    colmsTrim = "client_addr AS " + colmsTrim;
                } else if (colmsTrim.equalsIgnoreCase("clientprogramname")) {
                    colmsTrim = "application_name AS " + colmsTrim;
                }
            }
            colmnsBuf.append(colmsTrim).append(",");
        }
        return colmnsBuf.substring(0, colmnsBuf.length() - 1);
    }

    public String doAddAliasForExpression(String query) {
        String input = query;
        Pattern pattern = Pattern.compile("(?i)(?<!\\w)select(?!\\w)(.*?)(?<!\\w)from(?!\\w)(.*)");
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            String[] column;
            String columns = matcher.group(1);
            int startIndex = matcher.start(1);
            int endIndex = matcher.end(1);
            ColumnSplitter splitter = new ColumnSplitter();
            LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
            int bracketCount = splitter.updateBracketCount(columns = QueryConversionUtility.getSingleDoubleQuoteMap(columns, quoteMap), 0);
            if (bracketCount > 0) {
                return input;
            }
            List<String> columnList = splitter.doGetAllColumns(columns);
            for (int iIndex = 0; iIndex < columnList.size(); ++iIndex) {
                column = columnList.remove(iIndex);
                if (column.startsWith("TO_CHAR")) {
                    column = column.replaceAll("(?i)((?<!\\w)TO_CHAR(?!\\w)\\s*\\(.*?\\)\\s*as\\s+varchar\\(\\s*\\d+\\s*\\))", "CAST($1)");
                }
                columnList.add(iIndex, (String)column);
            }
            PlaceHolderUtility placeHolder = new PlaceHolderUtility();
            columns = placeHolder.doGetPlaceholderColumns(columnList, this.replaceValMap, true, true);
            column = columns.split(",");
            StringBuffer sb = new StringBuffer();
            String updatedColums = this.getUpdBuff(quoteMap, column, sb);
            input = sb.append(query.substring(0, startIndex)).append(" ").append(updatedColums).append(" ").append(query.substring(endIndex)).append(" ").toString();
        }
        return input;
    }

    private String getUpdBuff(Map<String, String> quoteMap, String[] column, StringBuffer sb) {
        String cmntRmvdCol = null;
        String cmntStrt = "";
        String cmntEnd = "";
        int spaceCount = 0;
        String col = null;
        for (int iIndex = 0; iIndex < column.length; ++iIndex) {
            col = column[iIndex].trim();
            cmntStrt = QueryConversionUtility.doGetStartCmnts(col);
            cmntEnd = QueryConversionUtility.doGetEndCmnts(col);
            cmntRmvdCol = col.replaceAll("(?i)#S#\\d+#E#", "").trim();
            spaceCount = QueryConversionUtility.doCntCharacter(cmntRmvdCol, ' ');
            col = this.doFindColumnNameForExpression(spaceCount, col, cmntRmvdCol, cmntStrt, cmntEnd);
            col = QueryConversionUtility.doReplaceFunctionVariables(col, this.replaceValMap, "COLUMN__");
            sb.append(col);
            if (iIndex >= column.length - 1) continue;
            sb.append(",");
        }
        String updatedColums = sb.toString();
        updatedColums = QueryConversionUtility.getRplFromMap(updatedColums, quoteMap, "(##QUOTE##\\d+#)");
        sb.setLength(0);
        return updatedColums;
    }

    private String doFindColumnNameForExpression(int spaceCount, String col, String cmntRmvdCol, String cmntStrt, String cmntEnd) {
        String columnFunction;
        String column = col;
        if (spaceCount == 0 && column.startsWith("_COLUMN__function") && (columnFunction = this.replaceValMap.get(cmntRmvdCol)) != null && columnFunction.matches("(?i).*?(?<!\\w)(LPAD|TO_CHAR)(?!\\w)\\s*\\(.*")) {
            LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
            String neededColumn = QueryConversionUtility.getSingleQuoteMap(columnFunction, quoteMap);
            StringBuffer newsb = new StringBuffer();
            Pattern wordIdentifier = Pattern.compile("([\\$#]?\\{?\\\"?#?\\w+\\\"?\\}?\\.?)+");
            String neededColumnWC = QueryConversionUtility.replaceAll(neededColumn, "(?i)#S#\\d+#E#", "");
            neededColumnWC = QueryConversionUtility.replaceAll(neededColumnWC, "##QUOTE##\\d+#", "");
            Matcher wordMatcher = wordIdentifier.matcher(neededColumnWC);
            neededColumn = QueryConversionUtility.getRplFromMap(neededColumn, quoteMap, "(##QUOTE##\\d+#)");
            String word = null;
            while (wordMatcher.find()) {
                String wordMatch = wordMatcher.group(0);
                word = wordMatcher.group(1);
                if (word.matches("(?i)(?<!\\w)(as|is|varchar|char|int|decimal|substr|upper|cast|lower|ltrim|rtrim|trim|xc_node_id|tableoid|ctid|text|case|to_date|replace|to_char|lpad|rpad|COALESCE|length|substring|ZEROIFNULL|NULLIFZERO|mod|MaxDate|Max|Min|TRANSACCTNUM|ABS|decode|concat|time|date|FORMAT|Mr|Ms|Mrs|Miss|LAG|NULL|OVER|AVG|E|S|SET|EXISTS|ASC|DESC|IN|BY|group|partition|IF|ELSE|CASE|JOIN|NEXT|LAST|ADD|USING|MONTH|NULLIF|sum|CURRENT_TIMESTAMP|PUBLIC|HAVING|TIMESTAMP|TO_CLOB|INTO|FOR|INTEGER|ALL|NUMBER|BLOB|rank|row_number|ARRAY|decode|grouping|interval|extract|now|reverse|right|chr|convert|encode||left|to_ascii|to_hex|character|varying|double|path|bigint|when|bigserial|SYS_CALENDAR|and|or|then|end)(?!\\w)") || word.matches("\\d+") || wordMatch.matches("mig_fn_castasint") || word.matches("mig_fn_castasint")) continue;
                newsb.append(cmntStrt).append(" ").append(neededColumn).append(" ").append("AS").append(" ").append(word).append(" ").append(cmntEnd);
                column = newsb.toString();
                break;
            }
        }
        return column;
    }

    private String rankAndRowNumInColumn(String input) {
        String inputSql = input;
        String output = input;
        String grpByElmts = null;
        String grpByElmtStr = "";
        Pattern pattern = null;
        Matcher matcher = null;
        if (QueryConversionUtility.containsCheck(inputSql, "cube") || QueryConversionUtility.containsCheck(inputSql, "rollup") || QueryConversionUtility.containsCheck(inputSql, "grouping")) {
            inputSql = inputSql.replaceAll("\\s*\\(\\s*", "(");
            inputSql = inputSql.replaceAll("\\s*\\)", ")");
        } else {
            inputSql = inputSql.replaceAll("\\s+,\\s+|\\s+,|,\\s+", ",");
            inputSql = inputSql.replaceAll("\\s*\\(\\s*", "(");
            inputSql = inputSql.replaceAll("\\s*\\)", ")");
            pattern = Pattern.compile("(?i)((#s#\\d+#e#\\s*)?\\s*group(?:(\\s*#s#\\d+#e#\\s*))?\\s*(?<!\\w)by(?!\\w)(\\s*#s#\\d+#e#\\s*)?\\s+(.*?)(ORDER\\s+BY|;|$))");
            matcher = pattern.matcher(inputSql);
            if (matcher.find() && (grpByElmts = matcher.group(5)).matches("(?i).*(?<!\\w)cast\\s*\\(\\s*current_time\\s*as\\s*time\\s*\\(\\s*\\d\\s*\\)\\s*\\).*?")) {
                grpByElmtStr = grpByElmts;
                grpByElmts = "__MIG_TD_CUR_TIME_PLACE_HOLDER__";
            }
        }
        inputSql = TeradataQueryKeywordReplacer.doGetReplacementForOrderbyInRankFunc(inputSql);
        if ((QueryConversionUtility.containsCheck(inputSql, "rank") || QueryConversionUtility.containsCheck(inputSql, "ROW_NUMBER")) && grpByElmts == null) {
            output = QueryConversionUtility.doReplaceSpecificGrp(inputSql, "((?<!\\w)(?:rank|row_number)\\s*(#S#\\d+#E#\\s*)*\\()\\s*(?:#S#\\d+#E#\\s*)*(?:(?:\\$?\\w.*?)|(?:\\\"\\$.*?\\)))", "", ") over ( order by ", 1, true);
        }
        if ((QueryConversionUtility.containsCheck(inputSql, "rank") || QueryConversionUtility.containsCheck(inputSql, "ROW_NUMBER")) && grpByElmts != null && !(output = this.doChangePartitionBycolsInRankFunc(inputSql, grpByElmts)).equals(inputSql) && matcher != null) {
            output = output.replace(matcher.group(1).trim(), matcher.group(6).trim());
        }
        output = output.replace("__MIG_TD_CUR_TIME_PLACE_HOLDER__", grpByElmtStr);
        return output;
    }

    private String doChangePartitionBycolsInRankFunc(String outputVal, String grpByElmts) {
        String output;
        String colStr = null;
        String cols = null;
        String modifiedPatrCols = null;
        Pattern pattrn = Pattern.compile("(?i)(?<!\\w)select(?!\\w)(.*?)(?<!\\w)from(?!\\w)");
        Matcher matcher = pattrn.matcher(output = outputVal);
        if (matcher.find()) {
            cols = matcher.group(1);
        }
        if (cols != null && !cols.isEmpty()) {
            TeradataMapHelperAlias tdmAlias = new TeradataMapHelperAlias();
            colStr = tdmAlias.changeColumns(this.replaceValMap, cols);
            colStr = tdmAlias.doPutColumnAlias(colStr);
            if (grpByElmts.trim().matches("(?i).*(((\\w+?\\()?\\$?#?(\\w+\\.?\\w*\\.?\\w*)|\\d+)\\)?\\,?).*")) {
                modifiedPatrCols = grpByElmts.matches(".*(?<!\\w)(\\d+)(?!\\w).*") ? this.doChangePostionsToColName(grpByElmts, colStr) : grpByElmts;
                output = this.doAddAliasForColPosition(output, grpByElmts, colStr, cols);
                output = QueryConversionUtility.doReplaceSpecificGrp(output, "((?<!\\w)(?:rank|row_number)\\s*(#S#\\d+#E#\\s*)*\\()\\s*(?:#S#\\d+#E#\\s*)*(?:(?:\\$?\\w.*?)|(?:\\\"\\$.*?\\)))", "", ") over ( partition by " + modifiedPatrCols + " " + "order" + " " + "by" + " ", 1, true);
            }
        }
        return output;
    }

    private String doChangePartitionBycols(String queryInp) {
        String colStr = null;
        String cols = null;
        String query = queryInp;
        Pattern pattrn = Pattern.compile("(?i)(?<!\\w)select(?!\\w)(.*?)(?<!\\w)from(?!\\w)");
        Matcher matcher = pattrn.matcher(query);
        if (matcher.find()) {
            cols = matcher.group(1);
        }
        if (cols != null && !cols.isEmpty()) {
            TeradataMapHelperAlias tdma = new TeradataMapHelperAlias();
            colStr = tdma.changeColumns(this.replaceValMap, cols);
            colStr = tdma.doPutColumnAlias(colStr);
            String rankOrRow = null;
            Pattern grpPattern = Pattern.compile("(?i)((((row_number|rank)(?:\\s*#s#\\d+#e#)*\\s*\\(\\s*\\))?\\s*(?:#s#\\d+#e#\\s*)*over\\s*(?:#s#\\d+#e#\\s*)*\\()\\s*(?:#s#\\d+#e#\\s*)*partition\\s*(?:#s#\\d+#e#\\s*)*\\s+(?<!\\w)by(?!\\w)(?:\\s*#s#\\d+#e#)*\\s+(.*?)(?<!\\w)order(?!\\w))");
            Matcher grpMatcher = grpPattern.matcher(query);
            String partCols = null;
            String santizedColm = null;
            while (grpMatcher.find()) {
                String partColsWOCmts;
                rankOrRow = grpMatcher.group(4);
                if (rankOrRow != null && (QueryConversionUtility.containsCheck(rankOrRow = rankOrRow.trim(), "rank") || QueryConversionUtility.containsCheck(rankOrRow, "ROW_NUMBER")) || !(partColsWOCmts = (partCols = grpMatcher.group(5).trim()).replaceAll("(?i)#S#\\d+#E#", "").replaceAll("\\s*,\\s*", ",").trim()).matches("(?i).*(((\\w+?\\()?\\$?#?(\\w+\\.?\\w*\\.?\\w*)|\\d+)\\)?\\,?).*") || !partColsWOCmts.matches(".*(?<!\\w)(\\d+)(?!\\w).*")) continue;
                String modifiedPatrCols = this.doChangePostionsToColName(partCols, colStr);
                santizedColm = QueryConversionUtility.santizePattern(partCols);
                query = this.doAddAliasForColPosition(query, partCols, colStr, cols);
                query = query.replaceFirst("(?i)(#s#\\d+#e#\\s*)*?\\s*(partition(?:(\\s*#s#\\d+#e#\\s*)*)?\\s*(?<!\\w)by(?!\\w)\\s+)(#s#\\d+#e#\\s*)*?" + santizedColm, "$2" + modifiedPatrCols);
            }
        }
        return query;
    }

    private String doAddAliasForColPosition(String queryInp, String partCols, String colStr, String cols) {
        String[] colArr = cols.split(",(?![^(]*\\))");
        String[] updColArr = colStr.split(",(?![^(]*\\))");
        String[] partColsArr = partCols.split(",(?![^(]*\\))");
        String query = queryInp;
        String colRpl = cols;
        for (String colPos : partColsArr) {
            int icolPos;
            if (!(colPos = colPos.trim()).matches("\\d+") || updColArr.length <= (icolPos = Integer.parseInt(colPos) - 1) || !updColArr[icolPos].startsWith("_COLUMN__") || this.doCheckAlias(colArr[icolPos])) continue;
            String replaceAlias = " AS " + updColArr[icolPos].split("(?i)\\s+AS\\s+")[1];
            String updColName = colArr[icolPos] + " " + replaceAlias + " ";
            colRpl = colRpl.replace(colArr[icolPos], updColName);
        }
        query = query.replace(cols, colRpl);
        return query;
    }

    private boolean doCheckAlias(String columnInp) {
        String column = columnInp;
        column = column.replaceAll("(?i)#S#\\d+#E#", "").trim();
        boolean val = false;
        TeradataMapHelperAlias tdma = new TeradataMapHelperAlias();
        String colStr = tdma.changeColumns(this.replaceValMap, column);
        if (QueryConversionUtility.containsCheck(colStr = colStr.trim(), " AS ")) {
            String[] colArr = colStr.split("(?i)\\s+AS\\s+");
            val = colArr.length == 2;
        } else if (colStr.contains(" ")) {
            val = true;
        }
        return val;
    }

    private String doChangePostionsToColName(String grpByElmtsInp, String colStr) {
        String grpByElmts = grpByElmtsInp;
        String[] grpArr = grpByElmts.split(",(?![^(]*\\))");
        boolean isDigit = false;
        int columnVal = 0;
        String[] colArr = colStr.split(",(?![^(]*\\))");
        StringBuffer strBuf = new StringBuffer();
        String colName = null;
        List<String> lst = this.doExtractAliasList(colArr);
        for (String col : grpArr) {
            if ((col = col.trim()).matches("\\d+")) {
                columnVal = Integer.parseInt(col) - 1;
                isDigit = true;
                if (columnVal < lst.size()) {
                    colName = lst.get(columnVal).trim();
                    colName = colName.startsWith("_COLUMN__") ? this.replaceValMap.get(colName) : colName;
                }
                strBuf.append(colName).append(",");
                continue;
            }
            strBuf.append(col).append(",");
        }
        if (isDigit) {
            strBuf.replace(strBuf.length() - 1, strBuf.length(), "");
            grpByElmts = strBuf.toString();
        }
        return grpByElmts;
    }

    private List<String> doExtractAliasList(String[] colArr) {
        List<String> lst = new LinkedList<String>(Arrays.asList(colArr));
        for (int iIndex = 0; iIndex < lst.size(); ++iIndex) {
            if (!QueryConversionUtility.containsCheck((String)lst.get(iIndex), " ~REM~OVE~ ")) continue;
            lst.remove(iIndex);
        }
        lst = QueryConversionUtility.doGetAliasList(lst);
        return lst;
    }

    private String modifyColumnsForUserEnvironmentDate(String queryToCheck) {
        String query = queryToCheck;
        LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
        query = QueryConversionUtility.getSingleDoubleQuoteMap(query, quoteMap);
        StringBuffer sb = new StringBuffer();
        boolean isFromExists = query.matches("(?i).*(?<!\\w)from(?!\\w).*");
        String strQueryPattern = null;
        strQueryPattern = isFromExists ? "(?i)(?<!\\w)select(?!\\w)(.*?)(?<!\\w)from(?!\\w)(.*)" : "(?i)(?<!\\w)select(?!\\w)(.*)";
        Pattern pattern = Pattern.compile(strQueryPattern);
        Matcher matcher = pattern.matcher(query);
        if (matcher.find()) {
            ArrayList<String> modifiedColumns = new ArrayList<String>(10);
            String columnNames = matcher.group(1);
            Pattern patExtract = Pattern.compile("(?i)(?<!\\w)(trim|extract|substring)(?!\\w)");
            Matcher matExtract = patExtract.matcher(columnNames);
            if (!matExtract.find()) {
                ColumnSplitter splitter = new ColumnSplitter();
                List<String> columnArrays = splitter.doGetAllColumns(columnNames);
                for (String col : columnArrays) {
                    col = this.modifyColForUserEnvironmentDate(col);
                    col = TeradataTimeUtility.modifyColForUserEnvironmentTime(col);
                    modifiedColumns.add(col);
                }
                String modifiedColStr = QueryConversionUtility.doGetStrFrmListWithSeparator(modifiedColumns, ",");
                if ("".equals(modifiedColStr)) {
                    modifiedColStr = columnNames;
                }
                sb.append(query.substring(0, matcher.start(1))).append(" ").append(modifiedColStr).append(" ").append(query.substring(matcher.end(1)));
                query = sb.toString();
            }
        }
        query = QueryConversionUtility.getRplFromMap(query, quoteMap, "(##QUOTE##\\d+#)");
        return query;
    }

    private String modifyOrderGroupForUserEnvironmentDate(String queryToCheck) {
        String query = queryToCheck;
        Pattern groupPattern = Pattern.compile("(?i)(?<!\\w)((order|group)(?!\\w)\\s+(?<!\\w)by)(?!\\w)(.*?)(?<!\\w|as\\s)(date)(?!\\w)");
        StringBuffer sb = new StringBuffer();
        int endIndex = 0;
        int tempIdx = 0;
        String grpororder = null;
        Matcher groupMatcher = groupPattern.matcher(query);
        while (groupMatcher.find()) {
            grpororder = groupMatcher.group(1);
            String matchQuery = groupMatcher.group(4);
            int startIndex = groupMatcher.start();
            endIndex = groupMatcher.end();
            matchQuery = matchQuery.replaceAll("(?i)(?<!\\w)date(?!\\w)", "CURRENT_DATE");
            sb.append(query.substring(tempIdx, startIndex)).append(" ");
            sb.append(grpororder).append(groupMatcher.group(3));
            sb.append(matchQuery);
            tempIdx = endIndex;
        }
        sb.append(query.substring(endIndex));
        query = sb.toString();
        return query;
    }

    private String modifyColForUserEnvironmentDate(String columnToCheck) {
        String[] colParts;
        String column = columnToCheck;
        String col = column.replaceAll("(?i)#S#\\d+#E#", "");
        if (col.endsWith(";")) {
            col = col.substring(0, col.length() - 1);
        }
        if ((colParts = col.split(" ")).length > 0 && colParts[0].trim().equalsIgnoreCase("DATE")) {
            column = column.replaceFirst("(?i)(?<!\\w)date(?!\\w|\\s*\\#)", "CURRENT_DATE");
        }
        return column;
    }

    public String doPatternSplitter(String query, List<IQueryPatternsBO> mappers, IMigrationMapper objMapper, IMigrationParser objParser) throws MigrationServiceException {
        IReplacerMap parserMap = new ReplacerMap();
        boolean breakLoop = false;
        String outputQuery = query;
        for (IQueryPatternsBO replaceBO : mappers) {
            parserMap = objParser.doParsing(query, replaceBO, parserMap);
            if (parserMap.size() != 0) {
                parserMap.put("QryCnt", this.qryCnt + "");
                parserMap.put("FILENAME", this.getFileName());
                outputQuery = this.doCheckConstraintForInput(query, objMapper, parserMap, replaceBO);
                breakLoop = true;
            }
            if (!breakLoop) continue;
            break;
        }
        return outputQuery;
    }

    private String doCheckConstraintForInput(String query, IMigrationMapper objMapper, IReplacerMap parserMap, IQueryPatternsBO replaceBO) throws MigrationServiceException {
        String outputQuery = null;
        if (replaceBO.isConstraintFlag()) {
            outputQuery = this.doCheckMapping(query, objMapper, parserMap, replaceBO);
        } else {
            logger.debug("No Constraint Flag - Direct Replacement Logic will be applied");
            outputQuery = parserMap.doSqlReplacement(replaceBO.getReplacementPattern());
        }
        return outputQuery;
    }

    private String doCheckMapping(String query, IMigrationMapper objMapper, IReplacerMap parserMap, IQueryPatternsBO replaceBO) throws MigrationServiceException {
        String outputQuery = null;
        if (objMapper.doMapping(query, replaceBO, parserMap)) {
            logger.debug("Constraint validation case success- Replacement Logic need to be applied");
            outputQuery = parserMap.doSqlReplacement(replaceBO.getReplacementPattern());
        } else {
            outputQuery = query;
            logger.debug("Constraint validation case failed - Query Migration not Required");
        }
        return outputQuery;
    }

    private IReplacerMap getSplittedQueryMap(String inputQuery, IQuerySplitterPatternsBO splitterPatternBO) {
        String outerQuery = "";
        boolean flag = false;
        boolean flagForValue = true;
        IReplacerMap splitterPatternMap = QueryConversionUtility.doGetInrOutrQry(inputQuery, splitterPatternBO, flagForValue);
        String outQry = (String)splitterPatternMap.get("outterquery");
        if (outQry != null && !outQry.trim().isEmpty()) {
            outerQuery = this.replaceTableNameInColumns(outQry);
            splitterPatternMap.put("outterquery", outerQuery);
        }
        if (QueryConversionUtility.containsCheck(outerQuery, "INSERT")) {
            this.doChkSetTable(outerQuery, flag);
        }
        return splitterPatternMap;
    }

    private void doChkSetTable(String outerQuery, boolean flag) {
        String pattenStr = null;
        int grpNumber = 0;
        String tempQry = outerQuery.replaceAll("(?i)#S#\\d+#E#", "");
        tempQry = tempQry.replaceAll("\\s*\\.\\s*", ".");
        pattenStr = flag ? "(?i)merge\\s+(into\\s+)?(\\$?\\s*\\{?\\w+\\s*\\}?\\s*\\.\\s*\\$?\\s*\\{?\\w+\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\".*?\"\\s*\\}?\\s*\\.\\s*\\$?\\s*\\{?\".*?\"\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\".*?\"\\s*\\}?\\s*\\.\\s*\\$?\\s*\\{?\\w+\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\\w+\\s*\\}?\\s*\\.\\s*\\$?\\s*\\{?\".*?\"\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\".*?\"\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\\w+\\}?(?:\\s*\\$\\s*\\{.*?\\})?)" : "(?i)insert\\s+into\\s+(\\$?\\s*\\{?\\w+\\s*\\}?\\s*\\.\\s*\\$?\\s*\\{?\\w+\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\".*?\"\\s*\\}?\\s*\\.\\s*\\$?\\s*\\{?\".*?\"\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\".*?\"\\s*\\}?\\s*\\.\\s*\\$?\\s*\\{?\\w+\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\\w+\\s*\\}?\\s*\\.\\s*\\$?\\s*\\{?\".*?\"\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\".*?\"\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\\w+\\}?(?:\\s*\\$\\s*\\{.*?\\})?)";
        grpNumber = flag ? 2 : 1;
        Pattern pattern = Pattern.compile(pattenStr);
        Matcher matcher = pattern.matcher(tempQry);
        String tableName = null;
        if (matcher.find()) {
            tableName = matcher.group(grpNumber);
            tableName = !tableName.contains("\"") ? QueryConversionUtility.toUpper(tableName) : QueryConversionUtility.doGetSetTableName(tableName);
            TeradataMigrationService.addPackageNameMap(this.fileName, tableName);
        }
    }

    private String replaceTableNameInColumns(String input) {
        String output = input;
        if (QueryConversionUtility.containsCheck(output, "INSERT")) {
            String insertQuery = output.substring(QueryConversionUtility.toUpper(output).indexOf("INSERT"));
            String[] columnNamesArr = QueryConversionUtility.doGetColArr(insertQuery);
            output = QueryConversionUtility.remTabAliasInCol(output, columnNamesArr);
        }
        return output;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileNme) {
        this.fileName = fileNme;
    }

    private String replaceSubqueries(String sqlInp, List<String> subQueryList) {
        String sql = sqlInp;
        Collections.reverse(subQueryList);
        String noSpaceString = null;
        for (String subSelect : subQueryList) {
            noSpaceString = QueryConversionUtility.toLower(subSelect).replace("select ", "select#").replace(" ", "");
            if (noSpaceString.lastIndexOf("(select#") == noSpaceString.indexOf("(select#")) {
                ++this.counter;
                sql = QueryConversionUtility.replaceQueryWithCommonPattern(sql, subSelect, this.counter, this.subQueryTrackMap, "##SUBQUERY##");
            }
            ProgressUtil.printProgress();
        }
        return sql;
    }
}

