/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.teradata;

import com.huawei.db.migration.database.bo.IQuerySplitterPatternsBO;
import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.interfaces.IReplacerMap;
import com.huawei.db.migration.parser.GenericJSONParser;
import com.huawei.db.migration.services.TeradataMigrationService;
import com.huawei.db.migration.teradata.TeradataMapHelperAlias;
import com.huawei.db.migration.teradata.TeradataUtilityExt;
import com.huawei.db.migration.util.ErrorLoggerUtility;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TeradataPostMigrationHandler {
    private static final Logger logger = LogManager.getLogger(TeradataPostMigrationHandler.class);
    private static final Pattern CAST_AS_PAT = Pattern.compile("(?i)(?<!\\w)(cast\\s*\\(.*?as(?!\\w))(.*?)\\)");
    private String qryTblNme = null;
    private String table = null;
    private boolean isMultiSetTbl = false;
    private String outerQuery = null;
    private String innQuery = null;
    private StringBuffer extraColNames;

    public List<String> doPostProcess(String fileName, List<String> inputList, Set<String> tableNames, String task) throws MigrationServiceException {
        ArrayList<String> outputList = new ArrayList<String>(inputList.size());
        GenericJSONParser objJSONParser = new GenericJSONParser();
        List<?> querySplitterPatterns = objJSONParser.getJSONObject("teradata-query-splitter");
        IQuerySplitterPatternsBO qrySplitterPat = (IQuerySplitterPatternsBO)querySplitterPatterns.get(0);
        String output = null;
        String tempOutput = "";
        Map<String, String> createTypesDDL = this.getUpdatedCreateTypeMap();
        for (String input : inputList) {
            try {
                output = input = this.maskBteqQuery(input);
                boolean validInsert = TeradataUtilityExt.checkForValidInsertQry(output);
                if (validInsert && output.matches("(?i).*(?<!\\w)insert(?!\\w)\\s+(?:#S#\\d+#E#\\s*)*into(?!\\w).*") && !task.equalsIgnoreCase("createtype")) {
                    String tempOut = output.replaceAll("(?i)#S#\\d+#E#", "");
                    String regexStartsWithWith = "(?i)^((\\$.*?\\s+)|(\\$\\{.*?\\}\\s+))*\\s*with\\s+.*";
                    if ((tempOut = QueryConversionUtility.canonicalizeString(tempOut)).matches(regexStartsWithWith)) {
                        String strInsrt = QueryConversionUtility.doGetSpecficClause(output, "(?i)(?<!\\w)(insert(?!\\w)\\s+into)(?!\\w)");
                        int startIndex = output.indexOf(strInsrt);
                        tempOutput = output.substring(0, startIndex);
                        output = output.substring(startIndex);
                    }
                    output = this.doMigrateSetTable(tableNames, output, qrySplitterPat, fileName);
                    output = tempOutput + output;
                }
                if (!createTypesDDL.isEmpty() && QueryConversionUtility.containsCheck(output, "cast")) {
                    output = TeradataPostMigrationHandler.doMigrateDataType(output, createTypesDDL);
                }
                tempOutput = "";
                outputList.add(output);
            }
            catch (MigrationServiceException e) {
                this.cathMigSerExc(fileName, outputList, output, e);
            }
            catch (RuntimeException e) {
                this.logRuntimeExc(outputList, output, e);
            }
        }
        return outputList;
    }

    private void logRuntimeExc(List<String> outputList, String output, RuntimeException e) {
        logger.error(e.getMessage());
        logger.error("[DSC_ERR_004_041] " + MessageLoader.getMessage("DSC_ERR_004_041"));
        outputList.add(output);
    }

    private void cathMigSerExc(String fileName, List<String> outputList, String output, MigrationServiceException e) {
        ErrorLoggerUtility.failedQryCnt();
        ErrorLoggerUtility.failedFileCnt(fileName);
        logger.error(e.getMessage());
        logger.error("[DSC_ERR_004_041] " + MessageLoader.getMessage("DSC_ERR_004_041"));
        outputList.add(output);
    }

    private String maskBteqQuery(String inputQuery) {
        Pattern slashCmdPattern = Pattern.compile("(?i)\\\\(?<!\\w)(if|else|endif|q|goto|i|set|label|for|loop|end-for|exit-for)(?!\\w)");
        Matcher slashCmdMatcher = slashCmdPattern.matcher(inputQuery);
        String outputQuery = slashCmdMatcher.replaceAll("#$1");
        outputQuery = outputQuery.replaceAll("#else", "#else ##ELSETHEN##");
        outputQuery = outputQuery.replaceAll("#for", "#for ##FORTHEN##");
        outputQuery = outputQuery.replaceAll("#loop", "##FORTHEN## #loop ##LOOPTHEN##");
        outputQuery = outputQuery.replaceAll("#end-for", "#endfor");
        outputQuery = outputQuery.replaceAll("#exit-for", "#exitfor");
        Pattern ifExprPattern = Pattern.compile("(?i)(?:#if)\\s+'?(?:\\$\\{(?:\\w+)\\})'?\\s*'?(==|!=)'?\\s*'?(\\w*|\\d+)'?");
        Matcher ifExprMatcher = ifExprPattern.matcher(outputQuery);
        StringBuffer outputBuf = new StringBuffer(128);
        int startIdx = 0;
        int endIdx = 0;
        while (ifExprMatcher.find()) {
            String ifExpr = ifExprMatcher.group();
            startIdx = ifExprMatcher.start();
            if (startIdx > endIdx) {
                outputBuf.append(outputQuery.substring(endIdx, startIdx));
            }
            if (ifExprMatcher.group(1).equals("==")) {
                outputBuf.append(ifExpr.replace("==", "'=='"));
            } else {
                outputBuf.append(ifExpr);
            }
            outputBuf.append(" ##IFTHEN## ");
            endIdx = ifExprMatcher.end();
        }
        if (endIdx < outputQuery.length()) {
            outputBuf.append(outputQuery.substring(endIdx, outputQuery.length()));
        }
        return outputBuf.toString();
    }

    private Map<String, String> getUpdatedCreateTypeMap() {
        Map<String, String> createTypesDDL = TeradataMigrationService.getCreateTypeMap();
        TeradataMapHelperAlias teradataMapHelperAlias = new TeradataMapHelperAlias();
        String migratedDataType = null;
        for (Map.Entry<String, String> map : createTypesDDL.entrySet()) {
            migratedDataType = teradataMapHelperAlias.doReplaceDataType(map.getValue().trim());
            if (migratedDataType == null || migratedDataType.isEmpty() || migratedDataType.trim().equals(map.getValue().trim())) continue;
            map.setValue(migratedDataType.trim());
        }
        return createTypesDDL;
    }

    private static String doMigrateDataType(String inputQry, Map<String, String> createTypesDDL) {
        String output = inputQry;
        Matcher matcher = CAST_AS_PAT.matcher(inputQry);
        StringBuffer sb = new StringBuffer();
        int startIndex = 0;
        int endIndex = 0;
        int tempIndex = 0;
        while (matcher.find()) {
            tempIndex = matcher.start(2);
            endIndex = matcher.end(2);
            String userDataType = matcher.group(2);
            String dataType = createTypesDDL.get(userDataType.trim());
            sb.append(output.substring(startIndex, tempIndex));
            if (dataType != null) {
                sb.append(" " + dataType + " ");
            } else {
                sb.append(userDataType);
            }
            startIndex = endIndex;
        }
        sb.append(output.substring(endIndex));
        output = sb.toString();
        return output;
    }

    private String doMigrateSetTable(Set<String> tableNames, String outputVal, IQuerySplitterPatternsBO qrySplitterPat, String fileName) throws MigrationServiceException {
        String output = outputVal;
        boolean flag = true;
        IReplacerMap splitterPatternMap = QueryConversionUtility.doGetInrOutrQry(output, qrySplitterPat, flag);
        String outerQry = (String)splitterPatternMap.get("outterquery");
        if (QueryConversionUtility.containsCheck(outerQry, "INSERT")) {
            splitterPatternMap = this.doChkSetTable(splitterPatternMap, tableNames, fileName);
        }
        output = splitterPatternMap.doSqlReplacement(qrySplitterPat.getFinalReplacementPattern());
        return output;
    }

    private IReplacerMap doChkSetTable(IReplacerMap splittedQry, Set<String> tableNames, String fileName) {
        String tableNameInQry;
        this.outerQuery = (String)splittedQry.get("outterquery");
        this.innQuery = (String)splittedQry.get("innerquery");
        StringBuffer innQryBuf = new StringBuffer(128);
        if (this.innQuery != null) {
            innQryBuf.append(this.innQuery);
        }
        int insertIndex = QueryConversionUtility.toUpper(this.outerQuery).indexOf("INSERT");
        int index = this.outerQuery.indexOf(40, insertIndex);
        StringBuffer tableBuffer = new StringBuffer(128);
        String[] colArr = this.getTableNameInQuery(index, tableBuffer);
        this.qryTblNme = tableNameInQry = tableBuffer.toString();
        this.table = null;
        this.isMultiSetTbl = false;
        if (TeradataMigrationService.chkContainsMultiSetTempTbl(fileName, QueryConversionUtility.doGetSetTableName(tableNameInQry))) {
            this.isMultiSetTbl = true;
        }
        if (TeradataMigrationService.chkContainsTempTbl(fileName, QueryConversionUtility.doGetSetTableName(tableNameInQry))) {
            tableNameInQry = fileName + "-" + tableNameInQry;
        }
        for (String tableSet : tableNames) {
            if (tableNameInQry.contains("\"") && QueryConversionUtility.setTableContain(tableSet, tableNameInQry)) {
                this.table = tableSet;
                break;
            }
            if (!tableNameInQry.equalsIgnoreCase(tableSet)) continue;
            this.table = tableSet;
            break;
        }
        this.doChkSetTableMultiSet(innQryBuf, fileName, colArr, index, splittedQry);
        return splittedQry;
    }

    private void doChkSetTableMultiSet(StringBuffer innQryBuf, String fileName, String[] colArr, int index, Map<String, String> splittedQry) {
        if (this.table != null && !this.isMultiSetTbl) {
            innQryBuf.deleteCharAt(innQryBuf.indexOf(";"));
            innQryBuf.insert(0, '(');
            innQryBuf.append(')');
            innQryBuf.append(" ").append("MINUS").append(" ").append("select").append(" ");
            List<String> schemaCols = TeradataMigrationService.getSetTableColumns(fileName, false, this.table);
            if (colArr != null) {
                StringBuffer extraColValues = new StringBuffer(128);
                this.extraColNames = new StringBuffer(128);
                this.insertColumnTableCreation(schemaCols, colArr, innQryBuf, extraColValues, index);
            } else {
                innQryBuf.append("*").append(" ").append("from").append(" ").append(this.qryTblNme).append(";");
            }
            splittedQry.put("outterquery", this.outerQuery);
            splittedQry.put("innerquery", innQryBuf.toString());
            splittedQry.put("replacementoutquery", innQryBuf.toString());
        } else {
            splittedQry.put("replacementoutquery", this.innQuery);
        }
    }

    private void insertColumnTableCreation(List<String> schemaCols, String[] colArr, StringBuffer innQryBuf, StringBuffer extraColValues, int index) {
        if (schemaCols.size() != colArr.length) {
            List<String> qryCols = this.getColumnList(colArr);
            List<String> schemaColModifier = this.removeDupCols(schemaCols, qryCols);
            String[] extraSplit = null;
            for (String extraCol : schemaColModifier) {
                extraSplit = extraCol.split("#~#");
                if (extraSplit.length <= 1) continue;
                String split0 = extraSplit[0];
                String split1 = extraSplit[1];
                if (split0 != null) {
                    innQryBuf.append(split0).append(",");
                    this.extraColNames.append(split0).append(",");
                }
                if (split1 == null) continue;
                extraColValues.append(split1).append(",");
            }
            this.innerQueryHasDistinct(innQryBuf, extraColValues);
        }
        innQryBuf.append(QueryConversionUtility.doGetStrFrmArray(colArr, ","));
        innQryBuf.append(" ").append("from").append(" ").append(this.qryTblNme).append(";");
        this.outerQuery = this.outerQuery.substring(0, index + 1) + this.extraColNames.toString() + this.outerQuery.substring(index + 1);
    }

    private void innerQueryHasDistinct(StringBuffer innQryBuf, StringBuffer extraColValues) {
        int strtIndex = 0;
        if (this.innQuery != null && this.innQuery.matches("(?i).*(?<!\\w)select\\s+distinct(?!\\w).*")) {
            int selectIndex = QueryConversionUtility.toLower(innQryBuf.toString()).indexOf("select");
            strtIndex = QueryConversionUtility.toUpper(innQryBuf.toString()).indexOf("DISTINCT");
            innQryBuf.replace(selectIndex, strtIndex + 8, "select DISTINCT " + extraColValues.toString());
        } else {
            strtIndex = QueryConversionUtility.toLower(innQryBuf.toString()).indexOf("select");
            innQryBuf.replace(strtIndex, strtIndex + 6, "select " + extraColValues.toString());
        }
    }

    private String[] getTableNameInQuery(int index, StringBuffer tableBuffer) {
        String[] colArr = null;
        String tableNameInQry = null;
        if (index != -1) {
            tableNameInQry = this.outerQuery.substring(0, index) + " ";
            colArr = QueryConversionUtility.doGetColArr(this.outerQuery.substring(index).replaceAll("(?i)#S#\\d+#E#", ""));
            colArr = QueryConversionUtility.trimElementsInArray(colArr);
        } else {
            tableNameInQry = this.outerQuery + " ";
        }
        tableNameInQry = tableNameInQry.replaceAll("\\s*\\.\\s*", ".");
        int intoIndex = QueryConversionUtility.getStartIndex(tableNameInQry, "(?i)(?<!\\w)into(?!\\w)", 0);
        tableNameInQry = tableNameInQry.substring(intoIndex + 4).trim();
        tableNameInQry = tableNameInQry.replaceAll("(?i)#S#\\d+#E#", "").trim();
        tableBuffer.append(tableNameInQry);
        return colArr;
    }

    private List<String> getColumnList(String[] colArr) {
        ArrayList<String> qryCols = new ArrayList<String>(colArr.length);
        for (String col : colArr) {
            if (col.contains(" ")) {
                qryCols.add(col.substring(0, col.indexOf(32)));
                continue;
            }
            qryCols.add(col);
        }
        return qryCols;
    }

    private List<String> removeDupCols(List<String> schemaCols, List<String> qryCols) {
        ArrayList<String> schemaColModifier = new ArrayList<String>(10);
        schemaColModifier.addAll(schemaCols);
        block0: for (String schemaCol : schemaCols) {
            String schemaColUpperCase = QueryConversionUtility.toUpper(schemaCol);
            for (String qryCol : qryCols) {
                String qryColUpperCase = QueryConversionUtility.toUpper(qryCol);
                if (!schemaColUpperCase.startsWith(qryColUpperCase + "#")) continue;
                schemaColModifier.remove(schemaCol);
                continue block0;
            }
        }
        return schemaColModifier;
    }
}

