/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.teradata;

import com.huawei.db.migration.util.QueryConversionUtility;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TeradataTimeUtility {
    private static final String CURRENT_TIME = "cast(CURRENT_TIME AS TIME(0))";

    public static String doUserEnvironmentTime(String input) {
        String[] patterns;
        String output = input;
        LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
        output = QueryConversionUtility.getSingleDoubleQuoteMap(output, quoteMap);
        for (String pattern : patterns = new String[]{"(?<!\\w)default\\s*(?:#S#\\d+#E#\\s*)*(?<!\\w)(time)(?!\\w)\\s*(?:#S#\\d+#E#\\s*)*\\s*(?=,|\\)|;)", "(?:=|<=|>=|<>|<|>|\\+|\\-|\\*|\\/|(?<!\\w)(?:LT|GT|EQ|LE|GE|NE)(?!\\w))\\s*(?:\\s*#S#\\d+#E#)*\\s+(?<!\\w)(time)(?!(\\w|\\s*##QUOTE##\\d+#))", "(?<!\\w)(time)(?!\\w)\\s*(?:#S#\\d+#E#\\s*)*(?:=|<=|>=|<>|<|>|\\+|\\-|\\*|\\/|(?<!\\w)(?:LT|GT|EQ|LE|GE|NE)(?!\\w))", "(?<!\\w)cast\\s*(?:#S#\\d+#E#\\s*)*\\(\\s*(?:#S#\\d+#E#\\s*)*(?<!\\w)(time)(?!\\w)", "(?i)(?<!\\w)where(?!\\w).*(?<!\\w|as\\s)(time)(?!\\w|\\s*##QUOTE##\\d+#)"}) {
            output = QueryConversionUtility.doReplaceSpecificGrp(output, pattern, null, CURRENT_TIME, 1, false);
        }
        output = QueryConversionUtility.getRplFromMap(output, quoteMap, "(##QUOTE##\\d+#)");
        output = QueryConversionUtility.doReplaceSpecificGrp(output, "(?i)(?<!\\')\\(\\s*(?:#S#\\d+#E#\\s*)*(?<!\\w)(time)(?!\\w|\\s*\\'[0-9:\\.]+)\\s*(.*?)\\)(?!\\')", null, CURRENT_TIME, 1, false);
        return output;
    }

    public static String modifyColForUserEnvironmentTime(String columnToCheck) {
        String[] colParts;
        String column = columnToCheck;
        String col = column.replaceAll("(?i)#S#\\d+#E#", "");
        if (col.endsWith(";")) {
            col = col.substring(0, col.length() - 1);
        }
        if ((colParts = col.split(" ")).length > 0 && colParts[0].trim().equalsIgnoreCase("TIME")) {
            column = column.replaceFirst("(?i)(?<!\\w)time(?!\\w|\\s*\\#)", CURRENT_TIME);
        }
        return column;
    }

    public static String modifyOrderGroupForUserEnvironmentTime(String queryToCheck) {
        String query = queryToCheck;
        Pattern groupPattern = Pattern.compile("(?i)(?<!\\w)((order|group)(?!\\w)\\s+(?<!\\w)by)(?!\\w)(.*?)(?<!\\w|\"|'|as\\s)(time)(?!\\w|\"|'|\\s*\\'[0-9:\\.]+)");
        StringBuffer sb = new StringBuffer(128);
        int endIndex = 0;
        int tempIdx = 0;
        String grpororder = null;
        Matcher groupMatcher = groupPattern.matcher(query);
        while (groupMatcher.find()) {
            grpororder = groupMatcher.group(1);
            String matchQuery = groupMatcher.group(4);
            int startIndex = groupMatcher.start();
            endIndex = groupMatcher.end();
            matchQuery = matchQuery.replaceAll("(?i)(?<!\\w)time(?!\\w)", CURRENT_TIME);
            sb.append(query.substring(tempIdx, startIndex)).append(" ");
            sb.append(grpororder).append(groupMatcher.group(3));
            sb.append(matchQuery);
            tempIdx = endIndex;
        }
        sb.append(query.substring(endIndex));
        query = sb.toString();
        return query;
    }
}

