/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.util;

import com.huawei.db.migration.util.QueryConversionUtility;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ColumnSplitter {
    private static final Pattern PAT_CASE = Pattern.compile("(?i).*?CASE(?:(?!CASE).*?)(END\\s+CASE).*?");
    private int commaCount = 0;
    private int quoteCount = 0;

    public List<String> doGetAllColumns(String inputColumns) {
        List<String> columnsList = new ArrayList<String>(10);
        if (inputColumns != null && !inputColumns.isEmpty()) {
            String[] commaSplitArrays = QueryConversionUtility.doGetArrSplit(inputColumns, ",");
            columnsList = this.getQryColumnsInList(commaSplitArrays);
        }
        return columnsList;
    }

    private List<String> getQryColumnsInList(String[] commaSplitArrays) {
        String column = null;
        ArrayList<String> columnArrays = new ArrayList<String>(10);
        StringBuffer columnBuff = new StringBuffer();
        this.commaCount = 0;
        this.quoteCount = 0;
        boolean caseFlag = false;
        int caseCnt = 0;
        int endCnt = 0;
        int caseBracketCount = 0;
        String trimColumn = null;
        for (int iIndex = 0; iIndex < commaSplitArrays.length; ++iIndex) {
            column = commaSplitArrays[iIndex] + " ";
            Matcher matchCase = PAT_CASE.matcher(column);
            while (matchCase.find()) {
                column = column.substring(0, matchCase.start(1)) + "end" + " " + column.substring(matchCase.end(1));
            }
            trimColumn = column.trim();
            if (trimColumn.matches("(?i)(?:#S#\\d+\\#E#\\s*)*(?<!\\w)case(?!\\w).*") && this.commaCount == 0 && this.quoteCount == 0 || caseFlag) {
                caseBracketCount = this.updateBracketCount(column, caseBracketCount);
                if ((caseCnt += column.split("(?i)(?<!\\w)case(?!\\w)").length - 1) == (endCnt += column.split("(?i)(?<!\\w)end(?!\\w)").length - 1) && caseBracketCount == 0) {
                    caseCnt = 0;
                    endCnt = 0;
                    caseFlag = false;
                    columnBuff.append(trimColumn);
                } else {
                    columnBuff.append(trimColumn).append(",");
                    caseFlag = true;
                }
            } else {
                this.doSplitColumn(column, columnBuff, trimColumn, caseFlag);
            }
            if (caseFlag || this.commaCount > 0 || this.quoteCount != 0) continue;
            columnArrays.add(columnBuff.toString().trim());
            columnBuff = new StringBuffer();
            this.commaCount = 0;
        }
        this.getUpdatedColumnArray(columnArrays, columnBuff);
        return columnArrays;
    }

    private void getUpdatedColumnArray(List<String> columnArrays, StringBuffer columnBuff) {
        String temp;
        if (!"".equals(columnBuff.toString()) && QueryConversionUtility.containsCheck(temp = " " + columnBuff.toString().trim(), "decimal")) {
            if (temp.endsWith(",")) {
                temp = temp.substring(0, temp.length() - 1);
            }
            columnArrays.add(temp);
        }
    }

    private void doSplitColumn(String column, StringBuffer columnBuff, String trimColumn, boolean caseFlag) {
        boolean condition;
        boolean bl = condition = column.contains("(") || column.contains(")") || this.commaCount != 0;
        if (condition && this.quoteCount == 0 && !caseFlag) {
            this.commaCount = this.doGetColBracketCnt(column, columnBuff, trimColumn);
        } else if ((trimColumn.startsWith("'") || this.quoteCount != 0) && !caseFlag && this.commaCount == 0) {
            this.quoteCount = this.doGetsingleQuoteCnt(column, trimColumn, columnBuff);
        } else {
            columnBuff.append(trimColumn);
        }
    }

    private int appendColForQuotes(StringBuffer columnBuff, String column) {
        if (this.quoteCount % 2 != 0) {
            columnBuff.append(column).append(",");
        } else {
            columnBuff.append(column);
            this.quoteCount = 0;
        }
        return this.quoteCount;
    }

    private void appendColWithComma(StringBuffer columnBuff, String column) {
        columnBuff.append(column);
        if (this.commaCount != 0) {
            columnBuff.append(",");
        }
    }

    private int doGetsingleQuoteCnt(String column, String trimColumn, StringBuffer columnBuff) {
        char[] charSplitArrays = column.toCharArray();
        for (int jIndex = 0; jIndex < charSplitArrays.length; ++jIndex) {
            if (charSplitArrays[jIndex] != '\'') continue;
            ++this.quoteCount;
        }
        return this.appendColForQuotes(columnBuff, trimColumn);
    }

    private int doGetColBracketCnt(String column, StringBuffer columnBuff, String trimColumn) {
        this.commaCount = this.updateBracketCount(column, this.commaCount);
        this.appendColWithComma(columnBuff, trimColumn);
        return this.commaCount;
    }

    public int updateBracketCount(String column, int count) {
        int cnt = count;
        char[] charSplitArrays = column.toCharArray();
        for (int jIndex = 0; jIndex < charSplitArrays.length; ++jIndex) {
            if (charSplitArrays[jIndex] == '(') {
                ++cnt;
                continue;
            }
            if (charSplitArrays[jIndex] != ')') continue;
            --cnt;
        }
        return cnt;
    }
}

