/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.util;

import com.huawei.db.migration.exception.MigrationServiceException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ErrorLoggerUtility {
    protected static final Set<String> FAILED_FILES = ConcurrentHashMap.newKeySet(5);
    private static final AtomicInteger FAILED_QUERIES = new AtomicInteger(0);
    private static final AtomicInteger QUERY_COUNT = new AtomicInteger(0);

    public static void updateQryCnt() {
        QUERY_COUNT.incrementAndGet();
    }

    public static AtomicInteger getFailedQueries() {
        return FAILED_QUERIES;
    }

    public static int totalQryCnt() {
        return QUERY_COUNT.intValue();
    }

    public static int totalFailedFiles() {
        return FAILED_FILES.size();
    }

    public static void failedQryCnt() {
        FAILED_QUERIES.incrementAndGet();
    }

    public static void failedFileCnt(String fileName) {
        FAILED_FILES.add(fileName);
    }

    public static int getFailedQueryCount() {
        return FAILED_QUERIES.intValue();
    }

    public static String getExceptionDetails(Throwable treadObject) {
        StackTraceElement[] traces;
        for (StackTraceElement ele : traces = treadObject.getStackTrace()) {
            if (!ele.getClassName().startsWith("com.huawei")) continue;
            String msg = treadObject instanceof MigrationServiceException ? "" : ":" + treadObject.getMessage();
            return "[" + ele.getFileName() + ":" + ele.getMethodName() + ":" + ele.getLineNumber() + msg + "]";
        }
        return "";
    }
}

