/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.util;

import com.huawei.db.migration.util.ApplicationPropertyLoader;
import com.huawei.db.migration.util.ErrorLoggerUtility;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageLoader {
    private static final Logger logger = LogManager.getLogger(MessageLoader.class);
    private static ResourceBundle resourceBundle = null;

    public static void loadMessages() {
        String propFileName = "messages/messageBundle";
        String language = QueryConversionUtility.toLower(ApplicationPropertyLoader.getStringProperty("language"));
        String country = QueryConversionUtility.toUpper(ApplicationPropertyLoader.getStringProperty("country"));
        Locale locale = Locale.getDefault();
        if (!language.isEmpty() && !country.isEmpty()) {
            locale = new Locale(language, country);
        }
        resourceBundle = ResourceBundle.getBundle(propFileName, locale);
    }

    public static String getMessage(String propName) {
        String value = null;
        Object objStr = null;
        if (resourceBundle.containsKey(propName)) {
            objStr = resourceBundle.getObject(propName);
        }
        if (objStr != null && objStr instanceof String) {
            value = (String)objStr;
        }
        try {
            if (value != null) {
                value = new String(value.getBytes("ISO-8859-1"), "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " UnSupported Encoding format request");
        }
        return value;
    }
}

