/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.util;

import com.huawei.db.migration.common.handlers.FileHandler;
import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.util.ErrorLoggerUtility;
import com.huawei.db.migration.util.MessageLoader;
import com.huawei.db.migration.util.QueryConversionUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PropertyLoader {
    private static final Logger logger = LogManager.getLogger(PropertyLoader.class);

    public static Map<String, String> loadPropertyFile(String proFileName) throws MigrationServiceException {
        Map<String, String> propertyMap;
        block13: {
            StringBuffer sb = new StringBuffer();
            propertyMap = null;
            String configDir = FilenameUtils.normalize((String)System.getProperty("config.dir"));
            if (configDir == null || !new File(configDir).exists()) {
                throw new MigrationServiceException("[DSC_ERR_004_002] " + MessageLoader.getMessage("DSC_ERR_004_002"));
            }
            PropertyLoader.getConfigFolder(proFileName, sb, configDir);
            String propertyFileName = sb.toString();
            Properties objProp = new Properties();
            InputStream inputStream = null;
            try {
                propertyFileName = FilenameUtils.normalize((String)propertyFileName);
                if (propertyFileName == null) {
                    throw new MigrationServiceException("[DSC_ERR_004_004] " + MessageLoader.getMessage("DSC_ERR_004_004"));
                }
                File propFile = new File(propertyFileName);
                Path path = Paths.get(propFile.getCanonicalPath(), new String[0]);
                if (propFile.exists()) {
                    inputStream = new FileInputStream(path.toFile());
                    objProp.load(inputStream);
                    propertyMap = PropertyLoader.doGetPropsMap(objProp);
                    logger.info("Successfully loaded Property file : {}", (Object)propertyFileName);
                    break block13;
                }
                throw new MigrationServiceException("[DSC_ERR_004_004] " + MessageLoader.getMessage("DSC_ERR_004_004") + ":" + propertyFileName);
            }
            catch (IOException e) {
                logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " [DSC_ERR_004_004] " + MessageLoader.getMessage("DSC_ERR_004_004") + " " + proFileName);
                throw new MigrationServiceException("[DSC_ERR_004_004] " + MessageLoader.getMessage("DSC_ERR_004_004"));
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " [DSC_ERR_004_004] " + MessageLoader.getMessage("DSC_ERR_004_004"));
                    }
                }
            }
        }
        return propertyMap;
    }

    private static void getConfigFolder(String proFileName, StringBuffer sb, String configDir) {
        File configFolder = new File(configDir);
        if (!configFolder.isDirectory() || !configFolder.canRead()) {
            throw new MigrationServiceException("[DSC_ERR_004_003] " + MessageLoader.getMessage("DSC_ERR_004_003") + ":" + configFolder.toString());
        }
        sb.append(configFolder.toString()).append("/").append(proFileName).append(".").append("properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> loadEnviromentFile(String proFileName) {
        Map<String, String> propertyMap = new HashMap<String, String>();
        Properties objProp = new Properties();
        String propertyFileName = proFileName;
        FileInputStream inputStream = null;
        try {
            propertyFileName = FilenameUtils.normalize((String)propertyFileName);
            if (!propertyFileName.isEmpty() && !FileHandler.isInSecureDir(Paths.get(propertyFileName, new String[0]))) {
                throw new MigrationServiceException("[DSC_ERR_004_035] " + MessageLoader.getMessage("DSC_ERR_004_035") + " " + propertyFileName);
            }
            File envFile = new File(proFileName);
            Path path = Paths.get(envFile.getCanonicalPath(), new String[0]);
            if (envFile.exists()) {
                inputStream = new FileInputStream(path.toFile());
                objProp.load(inputStream);
                propertyMap = PropertyLoader.doGetPropsMap(objProp);
                logger.info("Successfully loaded Enviroment parameter File : {}", (Object)propertyFileName);
            } else if (logger.isInfoEnabled()) {
                logger.info("Error while loading the file. " + propertyFileName);
            }
        }
        catch (IOException e) {
            logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " [DSC_ERR_004_036] " + MessageLoader.getMessage("DSC_ERR_004_036") + " " + propertyFileName);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " [DSC_ERR_004_036] " + MessageLoader.getMessage("DSC_ERR_004_036"));
                }
            }
        }
        return propertyMap;
    }

    private static Map<String, String> doGetPropsMap(Properties objProp) {
        LinkedHashMap<String, String> propertyMap = new LinkedHashMap<String, String>(10);
        String key = null;
        Enumeration<Object> e = objProp.keys();
        while (e.hasMoreElements()) {
            Object objElement = e.nextElement();
            if (!(objElement instanceof String)) continue;
            key = (String)objElement;
            propertyMap.put(key, objProp.getProperty(key).trim());
        }
        return propertyMap;
    }

    public static void writePropertyFile(String proFileName, Map<String, String> propertyMap) throws MigrationServiceException {
        StringBuffer fileName = PropertyLoader.getPropertyFileName(proFileName);
        String propertyFileName = fileName.toString();
        OutputStream outputStream = null;
        File propFile = null;
        try {
            propertyFileName = FilenameUtils.normalize((String)propertyFileName);
            if (propertyFileName == null) {
                throw new MigrationServiceException("Error while updating the property file");
            }
            propFile = new File(propertyFileName);
            if (!propFile.exists() && propFile.createNewFile()) {
                logger.info("Successfully created Property file : {}", (Object)propertyFileName);
            }
            if (propFile.exists() && propFile.canWrite()) {
                outputStream = new FileOutputStream(propFile);
                Properties objProp = new Properties();
                for (Map.Entry<String, String> property : propertyMap.entrySet()) {
                    objProp.setProperty(property.getKey(), property.getValue());
                }
                objProp.store(outputStream, "File Updated");
                logger.info("Successfully updated Property file : {}", (Object)propertyFileName);
            } else {
                logger.info("Unable to update Property file : {}", (Object)propertyFileName);
            }
        }
        catch (IOException e) {
            logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " Error while updating the property file :" + proFileName);
            throw new MigrationServiceException("Error while updating the property file");
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " Error while updating the property file :" + proFileName);
                }
            }
        }
    }

    private static StringBuffer getPropertyFileName(String proFileName) {
        StringBuffer fileName = new StringBuffer();
        String configDir = FilenameUtils.normalize((String)System.getProperty("config.dir"));
        if (configDir == null) {
            throw new MigrationServiceException("[DSC_ERR_004_002] " + MessageLoader.getMessage("DSC_ERR_004_002"));
        }
        File configFolder = new File(configDir);
        if (!configFolder.isDirectory()) {
            throw new MigrationServiceException("[DSC_ERR_004_003] " + MessageLoader.getMessage("DSC_ERR_004_003") + ":" + configFolder.toString());
        }
        fileName.append(configFolder.toString()).append("/").append(proFileName).append(".").append("properties");
        return fileName;
    }

    public static void writeListValuesToPropertyFile(String proFileName, Map<String, List<String>> propertyMap) throws MigrationServiceException {
        StringBuffer propfileName = PropertyLoader.getPropertyFileName(proFileName);
        String fileName = propfileName.toString();
        OutputStream outStream = null;
        File propFile = null;
        try {
            fileName = FilenameUtils.normalize((String)fileName);
            if (fileName == null) {
                throw new MigrationServiceException("Error while updating the property file");
            }
            propFile = new File(fileName);
            if (!propFile.exists() && PropertyLoader.createNewFile(propFile)) {
                logger.info("Successfully created Property file : {}", (Object)fileName);
            }
            if (propFile.exists() && propFile.canWrite()) {
                outStream = new FileOutputStream(propFile);
                Properties propObj = new Properties();
                for (Map.Entry<String, List<String>> property : propertyMap.entrySet()) {
                    propObj.setProperty(property.getKey(), property.getValue().toString());
                }
                propObj.store(outStream, "File Updated");
                logger.info("Successfully updated Property file : {}", (Object)fileName);
            } else {
                logger.info("Unable to update Property file : {}", (Object)fileName);
            }
        }
        catch (IOException e) {
            logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " Error while updating the property file :" + proFileName);
            throw new MigrationServiceException("Error while updating the property file");
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " Error while updating the property file :" + proFileName);
                }
            }
        }
    }

    private static boolean createNewFile(File propFile) throws IOException {
        if (QueryConversionUtility.containsCheck(System.getProperty("os.name"), "win")) {
            return propFile.createNewFile();
        }
        Path path = propFile.toPath();
        Set<PosixFilePermission> perms = PosixFilePermissions.fromString("rw-------");
        FileAttribute<Set<PosixFilePermission>> attr = PosixFilePermissions.asFileAttribute(perms);
        Files.createFile(path, attr);
        return true;
    }
}

