/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.db.migration.util;

import com.huawei.db.migration.database.bo.IQueryPatternsBO;
import com.huawei.db.migration.database.bo.IQuerySplitterPatternsBO;
import com.huawei.db.migration.exception.MigrationServiceException;
import com.huawei.db.migration.interfaces.IMigrationTaskService;
import com.huawei.db.migration.interfaces.IReplacerMap;
import com.huawei.db.migration.replacer.ReplacerMap;
import com.huawei.db.migration.util.ApplicationProperty;
import com.huawei.db.migration.util.ApplicationPropertyLoader;
import com.huawei.db.migration.util.ColumnSplitter;
import com.huawei.db.migration.util.DBPropertyLoader;
import com.huawei.db.migration.util.ErrorLoggerUtility;
import com.huawei.db.migration.util.FeatureLoader;
import com.huawei.db.migration.util.InterruptCharSequence;
import com.huawei.db.migration.util.MessageLoader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class QueryConversionUtility {
    private static final Logger logger = LogManager.getLogger(QueryConversionUtility.class);
    private static final Pattern TITLE_WITH_VIEW = Pattern.compile("(?i)\\(\\s*title\\s*\\'.*?\\'\\s*\\)");
    private static final Pattern PATTERN_VALUES = Pattern.compile("(?i)(.*?)(?<!\\w)values(?!\\w)(.*)");
    private static final Pattern PATTERN_SCHEMA_COL = Pattern.compile("((\\w+\\.)?\\w+\\.)\\w+");
    private static final Pattern WORD_IDENTIFIER = Pattern.compile("(?<!')(\"?\\w+\"?)(?!\\w|\\s*\\(|')");
    private static final Pattern CONTAINS_DOLLAR_PAT = Pattern.compile("((\\w+\\.)?(\\w+|##DOLLAR##\\d+#)\\.)\\w+");
    private static final Pattern AS_PAT = Pattern.compile("(?i)(.*)(?<!\\w)as\\s+\"?\\w+\"?\\s*(?:#S#\\d+#E#\\s*)*$");
    private static final Pattern PATTERN_DOLLAR = Pattern.compile("\\$\\{.*?\\}|\\\"*\\$.*?(?=\\.)|\\'\\$.*?\\'");
    private static final Pattern MDIFF_PAT = Pattern.compile("(?i)(?<!\\w)MDIFF(?!\\w).*?\\(");
    private static final Pattern PATTERN_OVER = Pattern.compile("(?i)((?<!\\w)over\\s*\\()");
    private static final Pattern QUOTE_PATTERN = Pattern.compile("(?i)(##Quote##\\d+#)\\s*(?:#S#\\d+#E#)?");
    private static final Pattern SINGLE_QUOTE_PATTERN = Pattern.compile("\\'.*\\'");
    private static final Pattern AS_PATTERN = Pattern.compile("(?i)(.*)(as.*)");
    private static final Pattern VARCHAR_PAT = Pattern.compile("(?i)(varchar\\(\\s*.*?\\s*\\))");
    private static final Pattern DATATYPE_PAT = Pattern.compile("\\'.*?\\'\\s*\\((.*)\\)");
    private static final Pattern SELECT_FROM_TABLE_PAT = Pattern.compile("(?i)(?<!\\w)SELECT(.*?)FROM\\s+.*?(TABLE)\\s*\\(");
    private static final Pattern SELECT_FROM_PAT = Pattern.compile("(?i)(?<!\\w)select(?!\\w)(.*?)(?<!\\w)from(?!\\w)", 2);
    private static final Pattern DOT_PAT = Pattern.compile("(?i)(?<!\\w)\\w+\\.");
    private static final Pattern ORDER_PATTERN = Pattern.compile("(?i)ORDER\\s+(SIBLINGS\\s+)?BY(.*?)(;|$|LIMIT|HAVING)");
    private static final Pattern TRUNC_PAT = Pattern.compile("(?i)(?<!\\w)trunc\\s*\\(");
    private static String patternString = "";
    private static String gaussSlashKey = "\"";
    private static int timeout = -1;
    private static final Pattern BITMAP_PATTRN = Pattern.compile("(?i)(?<!\\w)create(?!\\w)\\s+(bitmap).*?on\\s+((?:\\w+)\\.?(?:\\w+)).*?;");
    private static BufferedWriter writer;
    private static final String PATTERN = "(?i)^(#S#\\d+#E#\\s)*\\(\\s*(#S#\\d+#E#\\s)*SELECT\\s.*";
    private static int range;
    private static int appThreadCount;

    public static int getRange() {
        return range;
    }

    public static void setRange(int rangeVal) {
        range = rangeVal;
    }

    public static void setPattern(String pattern) {
        patternString = pattern;
    }

    public static String toLower(String input) {
        String inputString = null;
        inputString = input != null ? input.toLowerCase(Locale.ROOT) : "";
        return inputString;
    }

    public static void printConsoleMessage(String messageInp, boolean newLine) {
        String message = messageInp;
        if (null != message) {
            try {
                writer.write(message);
                if (newLine) {
                    writer.write(System.lineSeparator());
                }
                writer.flush();
            }
            catch (IOException e) {
                logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " Error while writing message to console. " + e.getMessage());
            }
        }
    }

    public static void printConsoleMessage(String messageInp) {
        QueryConversionUtility.printConsoleMessage(messageInp, true);
    }

    public static String toUpper(String input) {
        String inputString = null;
        inputString = input != null ? input.toUpperCase(Locale.ROOT) : "";
        return inputString;
    }

    public static boolean containsCheck(String var1, String var2) {
        String tempVar1 = QueryConversionUtility.canonicalizeString(var1);
        String tempVar2 = QueryConversionUtility.canonicalizeString(var2);
        return QueryConversionUtility.toLower(tempVar1).contains(QueryConversionUtility.toLower(tempVar2));
    }

    public static boolean containsCheckCollec(Set<String> var1, String var2) {
        for (String current : var1) {
            if (!QueryConversionUtility.containsCheck(current, var2)) continue;
            return true;
        }
        return false;
    }

    public static boolean equalCheck(String var1, String var2) {
        return var1 != null && var1.trim().equalsIgnoreCase(var2.trim());
    }

    public static int getIndex(String var1, String var2, int fromIndex) {
        return QueryConversionUtility.toLower(var1).indexOf(QueryConversionUtility.toLower(var2), fromIndex);
    }

    public static boolean properTerminated(String inputQuery) {
        int count;
        boolean result = true;
        if (inputQuery.contains("(") && (count = QueryConversionUtility.doChkBracketCnt(inputQuery)) != 0) {
            result = false;
        }
        return result;
    }

    public static int doChkBracketCnt(String inputQuery) {
        int count = 0;
        char[] charInput = inputQuery.toCharArray();
        for (int jIndex = 0; jIndex < charInput.length; ++jIndex) {
            if (charInput[jIndex] == '(') {
                ++count;
            }
            if (charInput[jIndex] != ')') continue;
            --count;
        }
        return count;
    }

    public static String isExcludePatternFound(String outputQuery, String keywords) {
        String keyword;
        Pattern pattern = Pattern.compile("(" + keywords + ")", 2);
        Matcher matcher = pattern.matcher(outputQuery);
        String output = outputQuery;
        if (matcher.find() && (keyword = matcher.group()) != null) {
            if (keyword.contains("(")) {
                keyword = QueryConversionUtility.toUpper(keyword.substring(0, keyword.indexOf(40)));
            }
            throw new MigrationServiceException("[DSC_ERR_004_046] " + MessageLoader.getMessage("DSC_ERR_004_046") + " " + keyword);
        }
        return output;
    }

    public static String doRemoveExtraSpace(String input) {
        String output = input;
        LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
        if ((output = QueryConversionUtility.canonicalizeString(output)) != null && (output.contains("'") || output.contains("\""))) {
            output = QueryConversionUtility.getSingleDoubleQuoteMap(output, quoteMap);
        }
        if (output != null) {
            output = output.replaceAll("\\t", " ");
            output = output.replaceAll("\\s{2,}", " ");
            if (quoteMap.size() > 0) {
                output = QueryConversionUtility.getRplFromMap(output, quoteMap, "(##QUOTE##\\d+#)");
            }
        }
        return output;
    }

    public static String doReplaceFunctionVariables(String input, Map<String, String> functionMap, String fnVariable) {
        String output = input;
        String replaceKey = null;
        if (!functionMap.isEmpty()) {
            output = QueryConversionUtility.canonicalizeString(output);
            while (output != null && output.contains(fnVariable)) {
                for (Map.Entry<String, String> replaceEntry : functionMap.entrySet()) {
                    replaceKey = replaceEntry.getKey();
                    if (!output.contains(replaceKey)) continue;
                    output = output.replace(replaceKey, replaceEntry.getValue());
                }
            }
        }
        return output;
    }

    public static String doReplaceSpecificGrp(String input, String patternString, String befReplacement, String replacement, int grpNumber, boolean appendOrReplace) {
        String output = input;
        output = QueryConversionUtility.canonicalizeString(output);
        Pattern pattern = Pattern.compile(patternString, 2);
        Matcher matcher = pattern.matcher(new InterruptCharSequence(output));
        int tempEnd = 0;
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String grpValue = matcher.group(grpNumber);
            if (grpValue == null || output == null) continue;
            int startindex = matcher.start(grpNumber);
            int endIndex = matcher.end(grpNumber);
            sb.append(output.substring(tempEnd, startindex));
            if (appendOrReplace) {
                sb.append(befReplacement).append(" ").append(matcher.group(grpNumber)).append(" ").append(replacement);
            } else {
                sb.append(replacement);
            }
            tempEnd = endIndex;
        }
        if (output != null) {
            sb.append(output.substring(tempEnd));
        }
        output = sb.toString();
        return output;
    }

    public static String doCommentTableSpaceListHash(String input, String befReplacement, String replacement, int grpNumber, boolean appendOrReplace) {
        Pattern pattern = Pattern.compile(patternString, 2);
        Matcher matcher = pattern.matcher(input);
        int tempEnd = 0;
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String grpValue = matcher.group();
            if (grpValue == null) continue;
            int startindex = matcher.start();
            int endIndex = matcher.end();
            sb.append(input.substring(tempEnd, startindex));
            String out = QueryConversionUtility.doReplaceSpecificGrp(matcher.group(), "(?i)(?<!\\w)(tablespace\\s+.*?)(;|,|\\)|\\s)", befReplacement, replacement, grpNumber, appendOrReplace);
            sb.append(out);
            tempEnd = endIndex;
        }
        sb.append(input.substring(tempEnd));
        return sb.toString();
    }

    public static String doCommentStoreClause(String inputVal, String patternString) {
        String input = inputVal;
        input = QueryConversionUtility.canonicalizeString(input);
        Pattern pattern = Pattern.compile(patternString, 2);
        Matcher matcher = pattern.matcher(input);
        int tempEnd = 0;
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            int startindex = matcher.start();
            int endIndex = matcher.end();
            if (input == null) continue;
            String column = QueryConversionUtility.doGetReplaceString(input.substring(endIndex));
            sb.append(input.substring(tempEnd, startindex));
            if (!column.matches(".*\\*\\/\\s*\\)?\\s*")) {
                String out = "/*" + matcher.group() + column + "*/";
                sb.append(out);
            } else {
                sb.append(matcher.group()).append(column);
            }
            tempEnd = endIndex + column.length();
        }
        if (input != null) {
            sb.append(input.substring(tempEnd));
        }
        return sb.toString();
    }

    public static String replaceQueryWithCommonPattern(String input, String subString, int counter, Map<String, String> functionMap, String fnVariable) {
        String output = input.replaceFirst(Pattern.quote(subString), " " + fnVariable + counter + "__" + " ");
        functionMap.put(fnVariable + counter + "__", subString);
        return output;
    }

    public static String replaceSubPartitionWithCommonPattern(String input, String subString, Map<String, String> functionMap, String fnVariable, String endVariable) {
        Pattern pattern = Pattern.compile(subString, 2);
        Matcher matcher = pattern.matcher(input);
        int tempEnd = 0;
        StringBuffer sb = new StringBuffer();
        int counter = 0;
        while (matcher.find()) {
            String grpValue = matcher.group();
            if (grpValue == null) continue;
            int startindex = matcher.start();
            sb.append(input.substring(tempEnd, startindex));
            String group = matcher.group();
            sb.append(" ").append("##SUBPART##").append(++counter).append("__").append(endVariable).append(" ");
            functionMap.put("##SUBPART##" + counter + "__" + endVariable, group);
            tempEnd = matcher.end();
        }
        sb.append(input.substring(tempEnd));
        return sb.toString();
    }

    public static String replaceSubPartitionWithCommonPatternFn(String input, String subString, Map<String, String> functionMap, String fnVariable, String endVariable) {
        Pattern pattern = Pattern.compile(subString, 2);
        Matcher matcher = pattern.matcher(input);
        String output = input;
        int counter = 0;
        while (matcher.find()) {
            String grpValue = matcher.group();
            if (grpValue == null) continue;
            int subPartIndex = QueryConversionUtility.getIndex(input, matcher.group(), matcher.start());
            String subPartStr = QueryConversionUtility.doGetReplaceString(input.substring(subPartIndex));
            output = output.replace(subPartStr, " ##SUBPART##" + ++counter + "__" + endVariable + " ");
            functionMap.put("##SUBPART##" + counter + "__" + endVariable, subPartStr);
        }
        return output;
    }

    private static boolean checkOpenSelectHash(String substring) {
        boolean result = QueryConversionUtility.containsCheck(substring, "select") && substring.matches(PATTERN);
        return result;
    }

    public static boolean isSubQueryMatches(String input) {
        int indexOfselect;
        String substring;
        String innerQueryU;
        boolean isSubquery = false;
        if (input != null && (innerQueryU = QueryConversionUtility.toUpper(input)).contains(QueryConversionUtility.toUpper("select")) && QueryConversionUtility.toUpper(substring = input.substring((indexOfselect = innerQueryU.indexOf(QueryConversionUtility.toUpper("select"))) + 6)).contains(QueryConversionUtility.toUpper("select"))) {
            isSubquery = true;
        }
        return isSubquery;
    }

    public static boolean excludePatternValidation(List<String> excludePatternLst, String inputQueryVal) {
        Iterator<String> excluItr = excludePatternLst.iterator();
        boolean isValid = true;
        String patternQuery = null;
        Pattern pattern = null;
        Matcher matcher = null;
        String inputQuery = inputQueryVal;
        while (excluItr.hasNext()) {
            patternQuery = excluItr.next();
            inputQuery = QueryConversionUtility.canonicalizeString(inputQuery);
            pattern = Pattern.compile(patternQuery, 2);
            matcher = pattern.matcher(inputQuery);
            if (!matcher.find()) continue;
            isValid = false;
            logger.debug("Exclude Pattern Validation Failed");
            break;
        }
        return isValid;
    }

    public static String doGetPatternMatch(String patternString, String tableConditions) {
        StringBuffer tableComment = new StringBuffer();
        Pattern pattern = Pattern.compile(patternString, 2);
        Matcher matcher = pattern.matcher(tableConditions);
        while (matcher.find()) {
            tableComment.append(matcher.group(0));
        }
        return tableComment.toString();
    }

    public static String doGetReplaceString(String input) {
        String inputString = input;
        String neededString = "";
        int even = 0;
        boolean searchFlag = false;
        for (int iIndex = 0; iIndex < inputString.length(); ++iIndex) {
            if (inputString.charAt(iIndex) == '(') {
                ++even;
                searchFlag = true;
            } else if (inputString.charAt(iIndex) == ')') {
                --even;
            }
            if (even != 0 || !searchFlag) continue;
            neededString = inputString.substring(0, iIndex + 1);
            break;
        }
        return neededString;
    }

    public static List<String> getSubQueryList(String inputQuery) {
        boolean searchClose = false;
        ArrayList<String> subqueryLst = new ArrayList<String>(10);
        int inputQryLen = inputQuery.length();
        String inputQryLower = QueryConversionUtility.toLower(inputQuery);
        block0: for (int jIndex = 0; jIndex < inputQryLen; ++jIndex) {
            String substring;
            int selectIndex;
            if (inputQuery.charAt(jIndex) != '(' || (selectIndex = inputQryLower.indexOf("select", jIndex)) == -1 || !QueryConversionUtility.checkOpenSelectHash(substring = inputQuery.substring(jIndex))) continue;
            int even = 0;
            int substringLen = substring.length();
            for (int jIdx = 0; jIdx < substringLen; ++jIdx) {
                if (substring.charAt(jIdx) == '(') {
                    searchClose = true;
                    ++even;
                } else if (substring.charAt(jIdx) == ')') {
                    --even;
                }
                if (even != 0 || !searchClose) continue;
                searchClose = false;
                String tolist = substring.substring(0, jIdx + 1);
                if (!QueryConversionUtility.checkOpenSelectHash(tolist)) continue block0;
                subqueryLst.add(tolist);
                continue block0;
            }
        }
        return subqueryLst;
    }

    public static String doReplaceKeywords(String input, String patternName) {
        LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
        String inputSql = input;
        inputSql = QueryConversionUtility.doRemoveExtraSpace(inputSql);
        inputSql = QueryConversionUtility.getSingleDoubleQuoteMap(inputSql, quoteMap);
        inputSql = QueryConversionUtility.canonicalizeString(inputSql);
        Pattern pattern = Pattern.compile(patternName, 2);
        Matcher matcher = pattern.matcher(inputSql);
        StringBuffer sb = new StringBuffer();
        int tempEnd = 0;
        while (matcher.find() && inputSql != null) {
            String keyword = matcher.group();
            int startindex = matcher.start();
            sb.append(inputSql.substring(tempEnd, startindex));
            String propertyName = QueryConversionUtility.toUpper(keyword).replace(" ", "");
            String propValue = "";
            if (propertyName != null && (propValue = DBPropertyLoader.getStringProperty(propertyName = QueryConversionUtility.canonicalizeString(propertyName))).isEmpty()) {
                if (propertyName.trim().startsWith("BLOB")) {
                    propValue = "BLOB";
                } else if (propertyName.trim().startsWith("CLOB")) {
                    propValue = "CLOB";
                } else if (propertyName.contains("PERIOD") && propertyName.contains("TIME")) {
                    String digits = matcher.group(1);
                    propValue = "TSRANGE";
                    if (digits != null) {
                        propValue = propValue + digits;
                    }
                } else if (propertyName.contains("GRAPHIC")) {
                    propValue = "BYTEA ";
                }
            }
            sb.append(" ").append(propValue).append(" ");
            tempEnd = matcher.end();
        }
        if (inputSql != null) {
            sb.append(inputSql.substring(tempEnd));
        }
        inputSql = QueryConversionUtility.outAfterRplMap(sb, quoteMap);
        return inputSql;
    }

    public static boolean preQueryValidator(String inputQuery) {
        boolean isProgramExclude = true;
        boolean preValidFlag = ApplicationPropertyLoader.getBooleanProperty("prevalidationFlag");
        if (preValidFlag) {
            int validLength;
            String input = inputQuery;
            input = input.replaceAll("(\\w+)\\'s", "~~$1s~~");
            int inputLen = (input = input.replaceAll("('.*?'|\".*?\")", "")).length();
            if (inputLen > (validLength = QueryConversionUtility.getRange()) || inputLen <= 1) {
                throw new MigrationServiceException("[DSC_ERR_004_048] " + MessageLoader.getMessage("DSC_ERR_004_048"));
            }
            if (!QueryConversionUtility.properTerminated(input)) {
                throw new MigrationServiceException("[DSC_ERR_004_024] " + MessageLoader.getMessage("DSC_ERR_004_024"));
            }
            String output = QueryConversionUtility.isExcludePatternFound(input, "(?i)(?<!\\w)JOIN(?!\\w)\\s*(?:#S#\\d+#E#\\s*)*(?<!\\w)SELECT(?!\\w)");
            isProgramExclude = output.equals(input);
        }
        return isProgramExclude;
    }

    public static boolean isContainsExactMatch(String sqlWithAlias, String aliasName) {
        boolean isContains = false;
        if (sqlWithAlias.matches("(?i).*(?<=\\s|!|#|%|&|\\(|\\)|\\+|-|\\*|\\/|,|\\.|<|>|\\?|\\=)" + aliasName + "(?=\\s*|!|#|%|&|\\(|\\)|\\+|-|\\*|\\/|,|\\;|<|>|\\?|\\=)" + ".*")) {
            isContains = true;
        }
        return isContains;
    }

    public static String doGetStartCmnts(String inputColumn) {
        String inputColumnVal = inputColumn;
        StringBuffer cmntPlaceholderAtStart = new StringBuffer();
        while (inputColumnVal.trim().startsWith("#S#")) {
            int cmntEndIndex = inputColumnVal.indexOf("#E#");
            cmntPlaceholderAtStart.append(inputColumnVal.substring(0, cmntEndIndex + 3));
            inputColumnVal = inputColumnVal.substring(cmntEndIndex + 3);
        }
        return cmntPlaceholderAtStart.toString();
    }

    public static String doGetEndCmnts(String inputColumn) {
        String inputColumnVal = inputColumn;
        String cmntPlaceholderAtEnd = "";
        while (inputColumnVal.trim().endsWith("#E#")) {
            int cmntIndex = inputColumnVal.lastIndexOf("#S#");
            int cmntEndIndex = inputColumnVal.lastIndexOf("#E#");
            cmntPlaceholderAtEnd = inputColumnVal.substring(cmntIndex, cmntEndIndex + 3) + cmntPlaceholderAtEnd;
            inputColumnVal = inputColumnVal.substring(0, cmntIndex);
        }
        return cmntPlaceholderAtEnd;
    }

    public static String doReplaceKeyword(String input, String pattern, String patternName) {
        String singleQuoteCheck;
        Pattern asDatePattern;
        Matcher matcher;
        String inputSql = input;
        StringBuffer replacement = new StringBuffer();
        replacement = replacement.append(" ").append(DBPropertyLoader.getStringProperty(patternName + "Replace"));
        if (patternName.equals("castAsDateFormatPattern") && (matcher = (asDatePattern = Pattern.compile(pattern)).matcher(input)).find()) {
            replacement = replacement.append(matcher.group(1)).append(matcher.group(3)).append(matcher.group(7));
        }
        if ((inputSql = inputSql.replaceAll(pattern, replacement.toString())).matches("(?i).*(?<!\\w)AS\\s+(#S#\\d+#E#\\s*)*DATE.*") && (matcher = Pattern.compile(singleQuoteCheck = "(?i)\\s*(\\'(.*?)\\')?\\s*(?<!\\w)AS\\s+((#S#\\d+#E#\\s*)*)DATE\\s*((#S#\\d+#E#\\s*)*)").matcher(inputSql)).find()) {
            String singleQuoteGroupOne = matcher.group(1);
            String singleQuoteGroupTwo = matcher.group(2);
            if (singleQuoteGroupOne != null && singleQuoteGroupTwo.trim().isEmpty()) {
                inputSql = inputSql.replace(singleQuoteGroupOne, "''");
            }
        }
        return inputSql;
    }

    public static String doGetStrFrmListWithComma(List<String> inputList) {
        StringBuilder sb = new StringBuilder();
        int cnt = inputList.size();
        for (int iIndex = 0; iIndex < cnt; ++iIndex) {
            if (iIndex != cnt - 1) {
                sb.append(inputList.get(iIndex)).append(",");
                continue;
            }
            sb.append(inputList.get(iIndex));
        }
        return sb.toString();
    }

    public static String doGetStrFrmArray(String[] inputArr, String separator) {
        StringBuilder sb = new StringBuilder();
        int cnt = inputArr.length;
        for (int iIndex = 0; iIndex < cnt; ++iIndex) {
            if (iIndex != cnt - 1) {
                sb.append(inputArr[iIndex]).append(separator);
                continue;
            }
            sb.append(inputArr[iIndex]);
        }
        return sb.toString();
    }

    public static String[] doGetArrSplit(String columnsStr, String splitter) {
        String[] strArray = new String[]{columnsStr};
        if (QueryConversionUtility.containsCheck(columnsStr, splitter)) {
            strArray = columnsStr.split(splitter);
        }
        return strArray;
    }

    public static String[] getGroupByElements(String inputSql) {
        String[] grpElements = null;
        String tempInputSql = inputSql.replaceAll("(?i)#S#\\d+#E#", "");
        if (tempInputSql.matches("(?i).*?(?<!\\w)group\\s+by(?!\\w).*")) {
            grpElements = new String[3];
            String spaceRmvdIpQry = inputSql;
            spaceRmvdIpQry = spaceRmvdIpQry + " ";
            spaceRmvdIpQry = spaceRmvdIpQry.replaceAll("\\s+,\\s+|\\s+,|,\\s+", ",");
            spaceRmvdIpQry = spaceRmvdIpQry.replaceAll("\\(", " (");
            spaceRmvdIpQry = spaceRmvdIpQry.replaceAll("\\)", " )");
            Pattern pattern = Pattern.compile("(?i)((#s#\\d+#e#\\s*)?\\s*group(?:(\\s*#s#\\d+#e#\\s*))?\\s*(?<!\\w)by(?!\\w)(\\s*#s#\\d+#e#\\s*)?\\s+(.*?)(\\s+|;))");
            Matcher matcher = pattern.matcher(spaceRmvdIpQry);
            String groupByElements = null;
            String groupBy = null;
            if (matcher.find()) {
                groupBy = matcher.group(1);
                groupByElements = matcher.group(5).trim();
            }
            if (groupBy != null && groupBy.contains(";")) {
                groupBy = groupBy.replace(";", "");
                groupBy = groupBy.trim();
            }
            grpElements[0] = spaceRmvdIpQry;
            grpElements[1] = groupBy;
            grpElements[2] = groupByElements;
        }
        return grpElements;
    }

    public static boolean unionSplitter(String query, Map<String, String> unionMap, int counterInp) {
        boolean status = false;
        Pattern pattern = Pattern.compile("(?i)((.*)(\\s(UNION ALL|UNION|INTERSECT|MINUS|EXCEPT)\\s)(.*))");
        Matcher matcher = null;
        int counter = counterInp;
        String beforeUnion = query;
        String keyword = null;
        String afterUnion = null;
        String beforeUnionLower = QueryConversionUtility.toLower(beforeUnion);
        if (QueryConversionUtility.conjunctionCheck(beforeUnionLower)) {
            block0: while (QueryConversionUtility.conjunctionCheck(beforeUnionLower)) {
                status = true;
                matcher = pattern.matcher(beforeUnion);
                while (matcher.find()) {
                    status = true;
                    beforeUnion = matcher.group(2);
                    beforeUnionLower = QueryConversionUtility.toLower(beforeUnion);
                    keyword = matcher.group(4);
                    if (!matcher.find()) continue;
                    continue block0;
                }
            }
            if (query != null) {
                afterUnion = query.replaceFirst(QueryConversionUtility.santizePattern(beforeUnion), "");
                afterUnion = afterUnion.replaceFirst(QueryConversionUtility.santizePattern(keyword), "").trim();
            }
        }
        if (status) {
            unionMap.put("#" + counter + "#" + beforeUnion, keyword);
            QueryConversionUtility.unionSplitter(afterUnion, unionMap, ++counter);
        } else {
            unionMap.put("#" + counter + "#" + query, "");
        }
        return status;
    }

    private static boolean conjunctionCheck(String beforeUnionLower) {
        return beforeUnionLower.contains(" union ") || beforeUnionLower.contains(" union all ") || beforeUnionLower.contains(" minus ") || beforeUnionLower.contains(" intersect ") || beforeUnionLower.contains(" except ");
    }

    public static String doGetSchemaQueries(String inputSql, Map<String, String> queryMap, int queryCountInp) {
        String placeHolder = "";
        List<String> subQueryList = QueryConversionUtility.getSubQueryList(inputSql);
        String input = inputSql;
        int queryCount = queryCountInp;
        while (!subQueryList.isEmpty() && subQueryList.get(0) != null) {
            placeHolder = subQueryList.get(0).trim().substring(1, subQueryList.get(0).trim().length() - 1);
            input = input.replace(placeHolder, "##QUERY##" + ++queryCount + "#");
            if (placeHolder.contains("dbc.indices")) {
                input = input.replace("databasename", "schemaname");
            } else if (placeHolder.contains("dbc.tables")) {
                input = input.replace("databasename", "schemaname");
            }
            subQueryList.remove(0);
            queryMap.put("##QUERY##" + queryCount + "#", placeHolder);
        }
        if (QueryConversionUtility.containsCheck(input = QueryConversionUtility.handleTitleWithView(input), "select") && !QueryConversionUtility.containsCheck(input, ".IF")) {
            ++queryCount;
            Pattern pattern = Pattern.compile("(?i)(.*?)((?<!\\w)select(?!\\w).*?)(?:(?:(?:\\)?\\s*unique(?!\\w)|\\)?\\s*primary(?!\\w)|\\)?\\s*on\\s*commit|\\)?\\s*with\\s*data|\\)?\\s*with\\s*no\\s*data|;)(?!'|\\w+)).*?)");
            Matcher matcher = pattern.matcher(input);
            while (matcher.find()) {
                placeHolder = matcher.group(2);
                int count = QueryConversionUtility.doChkBracketCnt(placeHolder);
                if (count > 0) {
                    String endingBracket = String.join((CharSequence)" ", Collections.nCopies(count, ")"));
                    placeHolder = placeHolder + endingBracket;
                }
                input = input.replace(placeHolder, "(##QUERY##" + queryCount + "#" + ")" + " ");
                queryMap.put("##QUERY##" + queryCount + "#", placeHolder);
                ++queryCount;
            }
        }
        return input;
    }

    public static String handleTitleWithView(String input) {
        if (QueryConversionUtility.containsCheck(input, "VIEW ") && QueryConversionUtility.containsCheck(input, "title")) {
            Matcher titleWithViewMatcher = TITLE_WITH_VIEW.matcher(input);
            int startIdx = 0;
            String title = "";
            String titleWithCmnt = "";
            StringBuffer sb = new StringBuffer();
            while (titleWithViewMatcher.find()) {
                title = titleWithViewMatcher.group();
                titleWithCmnt = "/*" + title + "*/";
                int tempIdx = titleWithViewMatcher.start();
                int endIdx = titleWithViewMatcher.end();
                sb.append(input.substring(startIdx, tempIdx));
                sb.append(titleWithCmnt);
                startIdx = endIdx;
            }
            sb.append(input.substring(startIdx));
            input = sb.toString();
        }
        return input;
    }

    public static Map<String, String> doMigrateSchemaQueries(String fileName, List<IQueryPatternsBO> queryPatterns, List<IQuerySplitterPatternsBO> querySplitterPatterns, Map<String, String> queryMap, IMigrationTaskService objTaskService) throws MigrationServiceException {
        String query = null;
        String qryOutput = null;
        for (Map.Entry<String, String> queries : queryMap.entrySet()) {
            query = queries.getValue();
            qryOutput = objTaskService.handleMigrationTask(query, fileName, queryPatterns, querySplitterPatterns);
            queryMap.put(queries.getKey(), qryOutput);
        }
        return queryMap;
    }

    public static String[] doGetColArr(String output) {
        String[] columnNamesArr = null;
        if (output.contains("(") && output.contains(")")) {
            int startIndex = output.indexOf(40);
            int endIndex = output.indexOf(41);
            String withinBraceString = output.substring(startIndex + 1, endIndex);
            columnNamesArr = QueryConversionUtility.doGetArrSplit(withinBraceString, ",");
        }
        return columnNamesArr;
    }

    public static String remTabAliasInCol(String outputVal, String[] columnNamesArr) {
        String output = outputVal;
        if (columnNamesArr != null) {
            int lastDotIndex = 0;
            for (String columnNme : columnNamesArr) {
                LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
                if (!(columnNme = QueryConversionUtility.getSingleQuoteMap(columnNme, quoteMap)).contains(".")) continue;
                lastDotIndex = columnNme.lastIndexOf(46);
                String tillLastDot = columnNme.substring(0, lastDotIndex + 1);
                output = output.replace(tillLastDot, "");
                output = QueryConversionUtility.getRplFromMap(output, quoteMap, "(##QUOTE##\\d+#)");
            }
        }
        return output;
    }

    public static String removeParenthesis(String inputQuery) {
        String inputQry = inputQuery;
        if (inputQry.contains("(") && inputQry.contains(")")) {
            inputQry = inputQuery.substring(inputQuery.indexOf(40) + 1, inputQuery.lastIndexOf(41));
        }
        return inputQry;
    }

    public static int strFreqInList(List<String> list, String str) {
        int counter = 0;
        for (String listStr : list) {
            if (!listStr.equalsIgnoreCase(str)) continue;
            ++counter;
        }
        return counter;
    }

    public static List<String> doGetAliasList(List<String> columns) {
        List<String> aliasList = new ArrayList<String>(10);
        aliasList = QueryConversionUtility.doGetAliasList(columns, aliasList);
        return aliasList;
    }

    private static List<String> doGetAliasListWithOutAddingAlias(List<String> columns) {
        ArrayList<String> aliasList = new ArrayList<String>(10);
        String column = null;
        for (int iIndex = 0; iIndex < columns.size(); ++iIndex) {
            column = columns.get(iIndex);
            if ((column = column.replaceAll("(?i)#S#\\d+#E#", "").trim()).contains(" ")) {
                aliasList.add(column.substring(column.lastIndexOf(32)).trim());
                continue;
            }
            aliasList.add(column.trim());
        }
        return aliasList;
    }

    public static List<String> doGetAliasList(List<String> columns, List<String> addedColsLst) {
        ArrayList<String> aliasList = new ArrayList<String>(10);
        String column = null;
        int aliasCounter = 1;
        String regex = "(?i)(time\\s+(?:\\'.*?\\'|##QUOTE##\\d#))(.*)";
        Pattern pattern = Pattern.compile(regex, 2);
        for (int iIndex = 0; iIndex < columns.size(); ++iIndex) {
            Matcher matcher;
            column = columns.get(iIndex).trim();
            if (column.contains("#S#")) {
                column = column.replaceAll("(?i)#S#\\d+#E#", "").trim();
            }
            if ((matcher = pattern.matcher(column)).matches()) {
                String timePart = matcher.group(1);
                String aliasPart = matcher.group(2);
                if (aliasPart != null && aliasPart.length() > 0) {
                    aliasList.add(aliasPart.substring(aliasPart.lastIndexOf(32)));
                    continue;
                }
                aliasList.add(timePart);
                continue;
            }
            if (column.contains("\"") && !column.contains(".\"") && !column.contains(")")) {
                aliasList.add(column.substring(column.indexOf(34)));
                continue;
            }
            if (column.contains(")")) {
                String alias = column.substring(column.lastIndexOf(41)).trim();
                if (alias.contains(" ")) {
                    alias = alias.substring(alias.lastIndexOf(32));
                    aliasList.add(alias.trim());
                    continue;
                }
                if (addedColsLst.size() != 0 && addedColsLst.contains(column)) {
                    column = column + " aggColumnalias" + aliasCounter;
                    columns.set(iIndex, column);
                    aliasList.add("aggColumnalias" + aliasCounter++);
                    continue;
                }
                column = column + " columnalias" + aliasCounter;
                columns.set(iIndex, column);
                aliasList.add("columnalias" + aliasCounter++);
                continue;
            }
            if (column.contains(" ")) {
                aliasList.add(column.substring(column.lastIndexOf(32)).trim());
                continue;
            }
            aliasList.add(column.trim());
        }
        return aliasList;
    }

    public static String doReplaceExactStr(String finderStr, String replacement, String input) {
        String output = input.replaceAll("(?i)(?<!\\w)" + finderStr + "(?!\\w)", replacement);
        return output;
    }

    public static boolean isExactMatch(String inputVal, String finderStr) {
        boolean isMatch = false;
        String input = inputVal;
        if (finderStr != null) {
            input = QueryConversionUtility.canonicalizeString(input);
            Pattern pattern = Pattern.compile("(?<!\\w|\\.)" + finderStr + "(?!\\w|\\.)", 2);
            Matcher matcher = pattern.matcher(input);
            if (matcher.find()) {
                isMatch = true;
            }
        }
        return isMatch;
    }

    public static IReplacerMap doGetInrOutrQry(String inputQueryVal, IQuerySplitterPatternsBO splitterPatternBO, boolean flag) {
        String inputQuery = inputQueryVal;
        inputQuery = QueryConversionUtility.canonicalizeString(inputQuery);
        ReplacerMap splitterPatternMap = new ReplacerMap();
        Pattern pattern = Pattern.compile(splitterPatternBO.getSplitterPattern(), 2);
        Matcher matcher = pattern.matcher(inputQuery);
        Map<String, String> tokens = splitterPatternBO.getSplitterMapAtt();
        if (matcher.find()) {
            logger.debug("Query Splitter Pattern Match Found");
            for (Map.Entry<String, String> keys : tokens.entrySet()) {
                int group = 0;
                try {
                    group = Integer.parseInt(keys.getValue());
                }
                catch (NumberFormatException e) {
                    logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " Error while converting from string to int for value= " + keys.getValue());
                    throw new MigrationServiceException("[DSC_ERR_004_018] " + MessageLoader.getMessage("DSC_ERR_004_018"));
                }
                splitterPatternMap.put(keys.getKey(), matcher.group(group));
            }
        } else {
            splitterPatternMap.put("innerquery", inputQuery);
            splitterPatternMap.put("outterquery", "");
        }
        if (!(!QueryConversionUtility.toLower((String)splitterPatternMap.get("innerquery")).contains("values") || "None".equalsIgnoreCase(FeatureLoader.getStringProperty("mergeImplementation")) && Pattern.matches("(?i)(.*?)(?<!\\w)MERGE(?!\\w)(.*?)", inputQuery))) {
            QueryConversionUtility.updateSplitterMapForValues(inputQuery, splitterPatternMap, flag);
        }
        return splitterPatternMap;
    }

    private static void updateSplitterMapForValues(String inputQuery, Map<String, String> splitterPatternMap, boolean flag) {
        Matcher matcherValues = PATTERN_VALUES.matcher(inputQuery);
        if (matcherValues.find()) {
            splitterPatternMap.put("outterquery", matcherValues.group(1));
            String aftValues = matcherValues.group(2);
            String neededString = QueryConversionUtility.doGetReplaceString(aftValues).trim();
            String lastStr = aftValues.replace(neededString, "");
            String inrQry = "";
            inrQry = flag ? "select " + neededString.substring(1, neededString.length() - 1) + lastStr : "VALUES " + neededString + lastStr;
            splitterPatternMap.put("innerquery", inrQry);
        }
    }

    public static String getTblNmeRmvinWhrJoin(String setwhereAndOr, String tableName) {
        if (setwhereAndOr != null && setwhereAndOr.trim().length() != 5) {
            return tableName.replaceAll("(?i)(?<!\\w)where(?!\\w).*", "").trim();
        }
        return tableName;
    }

    private static void doCheckAliasName(String subQryfrom, String tabAlias) throws MigrationServiceException {
        ArrayList<String> aliasMatches = new ArrayList<String>(10);
        Matcher aliasMatcher = Pattern.compile("(?i)(?:\\w*\\s*(?:#S#\\d+#E#\\s*)*(?:(?<!\\w)as(?!\\w))?\\s+(?:\\s*(?:#S#\\d+#E#\\s*)*)((?:\\\"|\\')?\\w+(?:\\\"|\\')?))").matcher(subQryfrom);
        while (aliasMatcher.find()) {
            aliasMatches.add(aliasMatcher.group(1));
        }
        for (int iIndex = 0; iIndex < aliasMatches.size(); ++iIndex) {
            if (!((String)aliasMatches.get(iIndex)).equalsIgnoreCase(tabAlias.trim())) continue;
            throw new MigrationServiceException("[DSC_ERR_003_016] " + MessageLoader.getMessage("DSC_ERR_003_016"));
        }
    }

    public static boolean doGetupdatedSubQryStr(String columns, Map<String, String> subQueryTrackMap, String tabAlias, String subQry) throws MigrationServiceException {
        boolean openBracketFlag = false;
        String subQryVal = subQueryTrackMap.get(subQry);
        String ipStr = subQryVal.substring(1, subQryVal.length() - 1) + " ";
        String cols = columns.trim();
        String ipStrTemp = ipStr.replaceAll("(?i)#S#\\d+#E#", "");
        if (ipStrTemp.matches("(?i).*(?<!\\w)(TOP|select\\s+\\d+|select\\s+\\*)(?!\\w).*")) {
            throw new MigrationServiceException("[DSC_ERR_003_017] " + MessageLoader.getMessage("DSC_ERR_003_017"));
        }
        if (cols.charAt(0) == '(') {
            cols = QueryConversionUtility.removeParenthesis(cols);
        }
        if (cols.charAt(0) == '(' && !cols.contains(")")) {
            cols = cols.substring(1);
            openBracketFlag = true;
        }
        LinkedHashMap<String, String> unionMap = new LinkedHashMap<String, String>(10);
        StringBuffer outputStr = new StringBuffer();
        String temp = null;
        if (QueryConversionUtility.unionSplitter(ipStr, unionMap, 0)) {
            for (Map.Entry singleQuery : unionMap.entrySet()) {
                ColumnSplitter splitter = new ColumnSplitter();
                List<String> colsLst = splitter.doGetAllColumns(cols);
                temp = ((String)singleQuery.getKey()).replaceFirst("#\\d+#", "") + " ";
                QueryConversionUtility.getUpdSubQry(temp, colsLst, tabAlias, outputStr);
                outputStr.append((String)singleQuery.getValue()).append(" ");
            }
        } else {
            ColumnSplitter splitter = new ColumnSplitter();
            List<String> colsLst = splitter.doGetAllColumns(cols);
            QueryConversionUtility.getUpdSubQry(ipStr, colsLst, tabAlias, outputStr);
        }
        outputStr.insert(0, "(");
        outputStr.append(")");
        subQueryTrackMap.put(subQry, outputStr.toString());
        return openBracketFlag;
    }

    private static void getUpdSubQry(String ipStrTemp, List<String> colsLst, String tabAlias, StringBuffer outputStr) throws MigrationServiceException {
        Pattern patternSubQry = Pattern.compile("(?i)(.*)(?<!\\w)select(?!\\w)(.*)(?<!\\w)from(?!\\w)(.*?)(?<!\\w)(where\\s.*|group\\s+by.*|having.*|order\\s+by.*|$)");
        String subCols = null;
        String subQryfrom = null;
        String subQryGrbBy = null;
        Matcher matchSubQry = patternSubQry.matcher(ipStrTemp);
        if (matchSubQry.find()) {
            subCols = matchSubQry.group(2);
            subQryfrom = matchSubQry.group(3).trim();
            QueryConversionUtility.doCheckAliasName(subQryfrom, tabAlias);
            subQryGrbBy = matchSubQry.group(4);
            String newTabAlias = "";
            if (!tabAlias.trim().isEmpty()) {
                newTabAlias = tabAlias + ".";
            }
            String subQryCols = subCols.replaceAll("(?i)#S#\\d+#E#", "");
            ColumnSplitter splitter = new ColumnSplitter();
            List<String> subColsLst = null;
            subColsLst = splitter.doGetAllColumns(subQryCols);
            subColsLst = QueryConversionUtility.getColList(subColsLst);
            if (colsLst.size() <= subColsLst.size()) {
                ArrayList<String> aggregateCols = new ArrayList<String>(10);
                ArrayList<String> aggregateSubCols = new ArrayList<String>(10);
                for (int iIndex = 0; iIndex < colsLst.size(); ++iIndex) {
                    if (!subColsLst.get(iIndex).matches("(?i).*(?<!\\w)(MAX|MIN|SUM|AVG|COUNT|FIRST|LAST)\\s*\\(.*")) continue;
                    aggregateSubCols.add(subColsLst.get(iIndex));
                    aggregateCols.add(colsLst.get(iIndex));
                }
                subColsLst.removeAll(aggregateSubCols);
                colsLst.removeAll(aggregateCols);
                String whereForm = QueryConversionUtility.formWhereForExistCols(colsLst, subColsLst, newTabAlias, subQryfrom, subQryCols);
                String havingForm = QueryConversionUtility.formHavingForAggFn(aggregateCols, aggregateSubCols, newTabAlias);
                subQryGrbBy = QueryConversionUtility.doUpdWhereHavingClause(subQryGrbBy, whereForm, havingForm);
                outputStr.append(matchSubQry.group(1)).append("select").append(" ").append(subCols).append(" ").append("from").append(" ").append(subQryfrom).append(" ");
                outputStr.append(subQryGrbBy).append(" ");
            } else {
                throw new MigrationServiceException("[DSC_ERR_003_018] " + MessageLoader.getMessage("DSC_ERR_003_018"));
            }
        }
    }

    private static String doUpdWhereHavingClause(String subQryGrbByInp, String whereForm, String havingForm) {
        String subQryGrbBy = subQryGrbByInp;
        if (havingForm.length() != 0) {
            subQryGrbBy = QueryConversionUtility.updateHavingClause(subQryGrbBy, havingForm);
        }
        if (whereForm.length() != 0) {
            subQryGrbBy = QueryConversionUtility.updateWhereClause(subQryGrbBy, whereForm);
        }
        return subQryGrbBy;
    }

    private static String formHavingForAggFn(List<String> aggregateCols, List<String> aggregateSubCols, String newTabAlias) {
        int colSize = aggregateCols.size();
        StringBuffer havingForm = new StringBuffer();
        String column = null;
        for (int iIndex = 0; iIndex < colSize; ++iIndex) {
            column = aggregateCols.get(iIndex);
            havingForm.append(aggregateSubCols.get(iIndex)).append("=");
            QueryConversionUtility.getWhereForm(newTabAlias, havingForm, column, PATTERN_SCHEMA_COL);
        }
        if (colSize != 0) {
            havingForm.insert(0, " having ");
        }
        return havingForm.toString();
    }

    private static String addTblAliasInFunction(String newTabAlias, String columnInp) {
        String column = columnInp;
        Matcher wordMatcher = WORD_IDENTIFIER.matcher(column);
        String word = null;
        while (wordMatcher.find()) {
            word = wordMatcher.group(1);
            if (word.matches("(?i)(?<!\\w)(as|is|varchar|char|int|decimal|substr|upper|cast|lower|ltrim|rtrim|trim|xc_node_id|tableoid|ctid|text|case|to_date|replace|to_char|lpad|rpad|COALESCE|length|substring|ZEROIFNULL|NULLIFZERO|mod|MaxDate|Max|Min|TRANSACCTNUM|ABS|decode|concat|time|date|FORMAT|Mr|Ms|Mrs|Miss|LAG|NULL|OVER|AVG|E|S|SET|EXISTS|ASC|DESC|IN|BY|group|partition|IF|ELSE|CASE|JOIN|NEXT|LAST|ADD|USING|MONTH|NULLIF|sum|CURRENT_TIMESTAMP|PUBLIC|HAVING|TIMESTAMP|TO_CLOB|INTO|FOR|INTEGER|ALL|NUMBER|BLOB|rank|row_number|ARRAY|decode|grouping|interval|extract|now|reverse|right|chr|convert|encode||left|to_ascii|to_hex|character|varying|double|path|bigint|when|bigserial|SYS_CALENDAR|and|or|then|end)(?!\\w)") || word.matches("\\d+")) continue;
            column = column.replaceAll("(?i)(?<!\\w|\\.)" + word + "(?!\\w|\\.)", newTabAlias + word);
        }
        return column;
    }

    private static String updateWhereClause(String subQryGrbByInp, String whereForm) {
        String tempWhere = whereForm;
        String subQryGrbBy = subQryGrbByInp;
        if (!subQryGrbBy.matches("(?i).*(?<!\\w)where(?!\\w).*")) {
            tempWhere = whereForm.substring(0, whereForm.length() - 4);
            subQryGrbBy = tempWhere + subQryGrbBy;
        } else {
            int whereIdx = QueryConversionUtility.getStartIndex(subQryGrbBy, "(?i)(?<!\\w)(where)(?!\\w)", 1);
            int index = QueryConversionUtility.getStartIndex(subQryGrbBy, "(?i)(?<!\\w)(group\\s+by|having|order\\s+by)(?!\\w)", 1);
            subQryGrbBy = index == -1 ? subQryGrbBy.substring(0, whereIdx + 5) + "(" + subQryGrbBy.substring(whereIdx + 5) + ")" : subQryGrbBy.substring(0, whereIdx + 5) + "(" + subQryGrbBy.substring(whereIdx + 5, index) + ")" + subQryGrbBy.substring(index);
            subQryGrbBy = subQryGrbBy.replaceFirst("(?i)(?<!\\w)where(?!\\w)", tempWhere);
        }
        return subQryGrbBy;
    }

    private static String updateHavingClause(String subQryGrbByInp, String havingForm) {
        String tempHaving = havingForm;
        String subQryGrbBy = subQryGrbByInp;
        int orderByIdx = QueryConversionUtility.getStartIndex(subQryGrbBy, "(?i).*(?<!\\w)(order\\s+by)(?!\\w).*", 1);
        if (!subQryGrbBy.matches("(?i).*(?<!\\w)having(?!\\w).*")) {
            tempHaving = havingForm.substring(0, havingForm.length() - 4);
            subQryGrbBy = orderByIdx == -1 ? subQryGrbBy + tempHaving : subQryGrbBy.substring(0, orderByIdx) + tempHaving + subQryGrbBy.substring(orderByIdx);
        } else {
            int havingIdx = QueryConversionUtility.getStartIndex(subQryGrbBy, "(?i).*(?<!\\w)(having)(?!\\w).*", 1);
            subQryGrbBy = orderByIdx == -1 ? subQryGrbBy.substring(0, havingIdx + 6) + "(" + subQryGrbBy.substring(havingIdx + 6) + ")" : subQryGrbBy.substring(0, havingIdx + 6) + "(" + subQryGrbBy.substring(havingIdx + 6, orderByIdx) + ")" + subQryGrbBy.substring(orderByIdx);
            subQryGrbBy = subQryGrbBy.replaceFirst("(?i)(?<!\\w)having(?!\\w)", tempHaving);
        }
        return subQryGrbBy;
    }

    private static String formWhereForExistCols(List<String> colsLst, List<String> subColumnList, String newTabAlias, String subQryfrom, String subQryCols) {
        List<String> subColsLst = subColumnList;
        int colSize = colsLst.size();
        StringBuffer whereForm = new StringBuffer();
        String column = null;
        String leftCol = null;
        for (int iIndex = 0; iIndex < colSize; ++iIndex) {
            column = colsLst.get(iIndex);
            if (subQryfrom.trim().matches("(?i).*\\)\\s*Q\\d+$")) {
                ColumnSplitter splitter = new ColumnSplitter();
                subColsLst = splitter.doGetAllColumns(subQryCols);
                subColsLst = QueryConversionUtility.doGetAliasList(subColsLst);
                String qualifyAlias = subQryfrom.substring(subQryfrom.lastIndexOf(41) + 1, subQryfrom.length());
                leftCol = subColsLst.get(iIndex);
                QueryConversionUtility.getWhrFrmWithQualify(whereForm, leftCol, CONTAINS_DOLLAR_PAT, qualifyAlias);
            } else {
                whereForm.append(subColsLst.get(iIndex)).append("=");
            }
            QueryConversionUtility.getWhereForm(newTabAlias, whereForm, column, CONTAINS_DOLLAR_PAT);
        }
        if (colSize != 0) {
            whereForm.insert(0, " where ");
        }
        return whereForm.toString();
    }

    private static void getWhrFrmWithQualify(StringBuffer whereForm, String leftColumn, Pattern patternSchemaCol, String qualifyAlias) {
        String leftCol = leftColumn;
        if (leftCol.contains(".")) {
            Matcher matcherSchemaCol = patternSchemaCol.matcher(leftCol);
            if (matcherSchemaCol.find()) {
                leftCol = leftCol.replace(matcherSchemaCol.group(3), qualifyAlias);
                whereForm.append(leftCol).append("=");
            }
        } else {
            whereForm.append(qualifyAlias).append(".").append(leftCol).append("=");
        }
    }

    private static void getWhereForm(String newTabAlias, StringBuffer whereForm, String col, Pattern patternSchemaCol) {
        String column = col;
        if (column.contains(".")) {
            Matcher matcherSchemaCol = patternSchemaCol.matcher(column);
            if (matcherSchemaCol.find()) {
                if (!newTabAlias.isEmpty()) {
                    column = column.replace(matcherSchemaCol.group(1), newTabAlias);
                    whereForm.append(column).append(" and ");
                } else {
                    whereForm.append(column).append(" and ");
                }
            }
        } else {
            column = QueryConversionUtility.addTblAliasInFunction(newTabAlias, column);
            whereForm.append(column).append(" and ");
        }
    }

    public static List<String> getColList(List<String> inputCols) {
        ArrayList<String> outputCols = new ArrayList<String>(10);
        String column = null;
        String columnLwr = null;
        String columnWOAlias = null;
        Matcher matcher = null;
        int colSize = inputCols.size();
        for (int iIndex = 0; iIndex < colSize; ++iIndex) {
            columnWOAlias = column = inputCols.get(iIndex);
            columnLwr = QueryConversionUtility.toLower(column);
            matcher = AS_PAT.matcher(column);
            if (matcher.find()) {
                columnWOAlias = matcher.group(1);
            } else if (column != null && columnLwr.startsWith("case") && columnLwr.contains("end")) {
                if ((column = column.replace(")", ") ")) != null) {
                    columnLwr = QueryConversionUtility.toLower(column);
                    columnWOAlias = column.substring(0, columnLwr.lastIndexOf(" end") + 4);
                }
            } else if (column != null && column.matches("(?i).*(\\+|\\-|\\*|\\/|\\%|\\^|\\||\\&).*")) {
                if (column.matches(".*(\\w|\\))\\s+\\w+$")) {
                    columnWOAlias = column.substring(0, column.lastIndexOf(32));
                }
            } else if (column != null && column.contains("(")) {
                columnWOAlias = column.substring(0, column.lastIndexOf(41) + 1);
            } else if (column != null && column.contains(" ") && !QueryConversionUtility.toUpper(column).contains("DISTINCT")) {
                columnWOAlias = column.substring(0, column.lastIndexOf(32));
            }
            if (columnWOAlias != null && QueryConversionUtility.toUpper(columnWOAlias).contains("DISTINCT")) {
                columnWOAlias = columnWOAlias.replaceAll("(?i)DISTINCT", "").trim();
            }
            outputCols.add(columnWOAlias);
        }
        return outputCols;
    }

    private static String doFunctionReplace(String sqlInp, String fnNme, int count, Map<String, String> functionMap) {
        String sql = sqlInp;
        int startIndex = sql.indexOf(fnNme);
        String sub = sql.substring(startIndex);
        String functionString = QueryConversionUtility.doGetReplaceString(sub);
        if (!functionString.isEmpty()) {
            sql = QueryConversionUtility.replaceQueryWithCommonPattern(sql, functionString, count, functionMap, "__FUNCTION__");
        }
        return sql;
    }

    public static String doReplaceFrom(String queryInp, Map<String, String> functionMap) {
        boolean isFromExists = true;
        String query = queryInp;
        isFromExists = QueryConversionUtility.fromKeywordValidation(query);
        if (!isFromExists) {
            int count = 1;
            Pattern pattern = Pattern.compile("(?i)(?<!\\w)(trim|extract|substring)(?!\\w)");
            Matcher matcher = pattern.matcher(query);
            String funcNme = null;
            while (matcher.find()) {
                String initialQry = query;
                funcNme = matcher.group();
                query = QueryConversionUtility.doFunctionReplace(query, funcNme, count, functionMap);
                ++count;
                if (initialQry.equals(query)) break;
                matcher = pattern.matcher(query);
            }
        }
        return query;
    }

    private static boolean fromKeywordValidation(String input) {
        String[] tempFrom;
        boolean isValid = false;
        String[] tempSelect = QueryConversionUtility.toLower(input).split("select");
        isValid = tempSelect.length == (tempFrom = QueryConversionUtility.toLower(input).split("from")).length;
        return isValid;
    }

    public static List<IQueryPatternsBO> getMajorPatterns(List<IQueryPatternsBO> mapper, String inputQuery, String mapDecider, String majorMappers) {
        ArrayList<IQueryPatternsBO> decideMappers = new ArrayList<IQueryPatternsBO>(10);
        Pattern pattern = Pattern.compile(mapDecider, 2);
        Matcher matcher = pattern.matcher(inputQuery);
        String patternKeyword = null;
        if (matcher.find()) {
            patternKeyword = matcher.group(0).trim();
            QueryConversionUtility.constructMappersForQry(mapper, decideMappers, patternKeyword);
        } else {
            QueryConversionUtility.constructDecideMappers(mapper, decideMappers, majorMappers);
        }
        return decideMappers;
    }

    private static void constructMappersForQry(List<IQueryPatternsBO> mapper, List<IQueryPatternsBO> decideMappers, String patternKeyword) {
        for (IQueryPatternsBO queryPatternsBO : mapper) {
            if (!QueryConversionUtility.containsCheck(queryPatternsBO.getName(), patternKeyword)) continue;
            decideMappers.add(queryPatternsBO);
        }
    }

    private static void constructDecideMappers(List<IQueryPatternsBO> mapper, List<IQueryPatternsBO> decideMappers, String mapDecider) {
        String[] decider = mapDecider.split("\\|");
        decideMappers.addAll(mapper);
        for (String string : decider) {
            for (IQueryPatternsBO queryPatternsBO : mapper) {
                if (!QueryConversionUtility.containsCheck(queryPatternsBO.getName(), string) || !decideMappers.contains(queryPatternsBO)) continue;
                decideMappers.remove(queryPatternsBO);
            }
        }
    }

    public static String doGetAliasPattern(String aliasName) {
        StringBuffer sbuff = new StringBuffer();
        String tempAlias = QueryConversionUtility.santizePattern(aliasName);
        sbuff.append("(?i)").append("(?<!\\w)").append("(").append("(?<=\\s|!|#|%|&|\\(|\\)|\\+|-|\\*|\\/|,|<|>|\\?|\\=|\\|)").append(tempAlias).append("(?=\\s*|!|#|%|&|\\(|\\)|\\+|-|\\*|\\/|,|\\;|<|>|\\?|\\=)").append(")").append("(?!\\w)");
        return sbuff.toString();
    }

    public static String preChkForRegex(String regexInput) {
        String modifiedStr = regexInput;
        if (modifiedStr.contains(")")) {
            modifiedStr = modifiedStr.replace(")", "\\)");
            modifiedStr = modifiedStr.replace("(", "\\(");
        }
        if (modifiedStr.contains(".")) {
            modifiedStr = modifiedStr.replace(".", "\\.");
        }
        if (modifiedStr.contains("*")) {
            modifiedStr = modifiedStr.replace("*", "\\*");
        }
        return modifiedStr;
    }

    public static String[] trimElementsInArray(String[] colArray) {
        String[] outArray = null;
        if (colArray != null) {
            outArray = new String[colArray.length];
            for (int iIndex = 0; iIndex < colArray.length; ++iIndex) {
                outArray[iIndex] = colArray[iIndex].trim();
            }
        }
        return outArray;
    }

    public static String getSingleQuoteMap(String inputSql, Map<String, String> quoteMap) {
        return QueryConversionUtility.getSingleOrDoubleQuoteMap(inputSql, quoteMap, "'", "'.*?'", "##QUOTE##");
    }

    public static String getSingleQuoteMap(String inputSql, Map<String, String> quoteMap, String quotePattern) {
        return QueryConversionUtility.getSingleOrDoubleQuoteMap(inputSql, quoteMap, "'", "'.*?'", quotePattern);
    }

    public static String getDoubleQuoteMap(String inputSql, Map<String, String> quoteMap) {
        return QueryConversionUtility.getSingleOrDoubleQuoteMap(inputSql, quoteMap, "\"", "\".*?\"", "##QUOTE##");
    }

    public static String getSingleOrDoubleQuoteMap(String inputSql, Map<String, String> quoteMap, String quote, String quotePattern, String rplStr) {
        String outputSql = inputSql;
        String string = outputSql = outputSql != null ? QueryConversionUtility.canonicalizeString(outputSql) : "null";
        if (outputSql != null && QueryConversionUtility.containsCheck(outputSql, quote)) {
            Pattern pattern = Pattern.compile(quotePattern);
            Matcher matcher = pattern.matcher(outputSql);
            int quoteCnt = 1;
            String quoteStr = null;
            while (matcher.find()) {
                quoteStr = matcher.group();
                outputSql = outputSql.replace(quoteStr, rplStr + quoteCnt + "#");
                quoteMap.put(rplStr + quoteCnt + "#", quoteStr);
                ++quoteCnt;
            }
        }
        return outputSql;
    }

    public static String doGetSetTableName(String tblNameInp) {
        String tblName;
        LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
        String returnTab = tblName = tblNameInp;
        if ((tblName = QueryConversionUtility.canonicalizeString(tblName)) != null && tblName.contains("\"")) {
            returnTab = QueryConversionUtility.getSingleDoubleQuoteMap(tblName, quoteMap);
        }
        returnTab = QueryConversionUtility.toUpper(returnTab);
        returnTab = QueryConversionUtility.getRplFromMap(returnTab, quoteMap, "(##QUOTE##\\d+#)");
        return returnTab;
    }

    public static boolean setTableContain(String setTblName, String tblNameInMap) {
        boolean isContains = setTblName.contains(tblNameInMap);
        if (!isContains && setTblName.startsWith("$")) {
            String unQuotedTblNameInMap = tblNameInMap.replaceAll("\"", "");
            isContains = setTblName.equalsIgnoreCase(unQuotedTblNameInMap);
        }
        if (!isContains && QueryConversionUtility.containsCheck(setTblName, tblNameInMap)) {
            String[] setStrArr = tblNameInMap.split("\\.");
            String[] tabStrArr = setTblName.split("\\.");
            if (setStrArr.length > 1 && tabStrArr.length > 1) {
                if (setStrArr[0].contains("\"")) {
                    if (setStrArr[0].equals(tabStrArr[0]) && setStrArr[1].equalsIgnoreCase(tabStrArr[1])) {
                        isContains = true;
                    }
                } else if (setStrArr[1].equals(tabStrArr[1]) && setStrArr[0].equalsIgnoreCase(tabStrArr[0])) {
                    isContains = true;
                }
            }
        }
        return isContains;
    }

    public static String getSingleDoubleQuoteMap(String inputSql, Map<String, String> quoteMap) {
        String outputSql = inputSql;
        if (outputSql.contains("'") || outputSql.contains("\"") || outputSql.contains("$q")) {
            outputSql = QueryConversionUtility.canonicalizeString(outputSql);
            Pattern pattern = Pattern.compile("('.*?'|\".*?\"|\\$q\\$.*?\\$q\\$)");
            Matcher matcher = pattern.matcher(outputSql);
            int quoteCnt = 1;
            int tempIndex = 0;
            StringBuffer sb = new StringBuffer(128);
            String rplStr = "##QUOTE##";
            while (matcher.find()) {
                String quoteString = matcher.group();
                int startIndex = matcher.start();
                int endIndex = matcher.end();
                sb.append(outputSql.substring(tempIndex, startIndex));
                sb.append("##QUOTE##").append(quoteCnt).append("#");
                tempIndex = endIndex;
                quoteMap.put("##QUOTE##" + quoteCnt + "#", quoteString);
                ++quoteCnt;
            }
            sb.append(outputSql.substring(tempIndex));
            return sb.toString();
        }
        return outputSql;
    }

    public static String getRplFromMap(String inputSql, Map<String, String> quoteMap, String patternStr) {
        String outputSql = inputSql;
        if (quoteMap != null && !quoteMap.isEmpty()) {
            Pattern pattern = Pattern.compile(patternStr);
            Matcher matcher = pattern.matcher(outputSql);
            String match = null;
            outputSql = QueryConversionUtility.canonicalizeString(outputSql);
            int endIndex = 0;
            StringBuffer sb = new StringBuffer();
            if (outputSql != null) {
                while (matcher.find()) {
                    int startIndex = matcher.start(1);
                    sb.append(outputSql.substring(endIndex, startIndex));
                    match = matcher.group(1);
                    sb.append(quoteMap.get(match));
                    endIndex = matcher.end(1);
                }
                sb.append(outputSql.substring(endIndex));
                outputSql = sb.toString();
            }
        }
        return outputSql;
    }

    public static String getDollarMap(String inputSql, Map<String, String> dollarMap) {
        String rplStr = "##DOLLAR##";
        String outputSql = inputSql;
        if (outputSql.contains("$")) {
            Matcher matcherDollar = PATTERN_DOLLAR.matcher(outputSql);
            int dollarCnt = 1;
            String dollarStr = null;
            while (matcherDollar.find()) {
                dollarStr = matcherDollar.group();
                dollarStr = dollarStr.replace("'", "");
                outputSql = outputSql.replaceAll("(?<!\\w)" + Pattern.quote(dollarStr) + "(?!\\w)", rplStr + dollarCnt + "#");
                dollarMap.put(rplStr + dollarCnt + "#", dollarStr);
                ++dollarCnt;
            }
        }
        return outputSql;
    }

    public static String doRplFromMap(String outputVal, Map<String, String> globalMap) {
        String output = outputVal;
        String outputUpr = QueryConversionUtility.toUpper(output);
        outputUpr = QueryConversionUtility.canonicalizeString(outputUpr);
        for (Map.Entry<String, String> globalTab : globalMap.entrySet()) {
            if (output == null || outputUpr == null || !outputUpr.contains(globalTab.getKey())) continue;
            output = output.replaceAll("(?i)(?<!\\w)" + globalTab.getKey() + "(?!\\w)", globalTab.getValue());
        }
        return output;
    }

    public static String doPutQuoteOnKeyword(String input) {
        String output = input;
        if (output.matches("(?i).*(alter\\s+session\\s+(?:ADVISE\\s+(?:COMMIT|ROLLBACK|NOTHING)|CLOSE\\s+DATABASE\\s+LINK|(?:ENABLE|DISABLE)\\s+(?:RESUMABLE|COMMIT\\s+IN\\s+PROCEDURE|GUARD|PARALLEL\\s+(?:DML|DDL|QUERY))|FORCE\\s+PARALLEL\\s+(?:DML|DDL|QUERY)).*)")) {
            return output;
        }
        LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
        if (output.contains("'") || output.contains("\"")) {
            output = QueryConversionUtility.getSingleDoubleQuoteMap(output, quoteMap);
        }
        if (output.matches("(?i).*(?<!\\w|#)key(?!\\w).*")) {
            output = QueryConversionUtility.doRplKeywordInSqlWithExcep(output, "key", "\"", "\"", 1, "primary\\s+key(?!\\w|\")|foreign\\s+key(?!\\w|\")");
        }
        if (output.matches("(?i).*(?<!\\w|#)cast(?!\\w).*")) {
            output = QueryConversionUtility.doRplKeywordInSqlWithExcep(output, "cast", "\"", "\"", 1, "cast\\s*\\(");
        }
        output = QueryConversionUtility.getRplFromMap(output, quoteMap, "(##QUOTE##\\d+#)");
        return output;
    }

    private static String doRplKeywordInSqlWithExcep(String input, String keywordsList, String befReplacement, String replacement, int grpNum, String exceptionKeywordsList) {
        String output = input;
        String patternStr = "(?i)(?<!\\w|\"|#)(" + keywordsList + ")(?!\\w|\")";
        Pattern patternkeyword = Pattern.compile(patternStr, 2);
        int tempEnd = 0;
        int startidx = 0;
        int endIdx = 0;
        StringBuffer stringBuff = new StringBuffer();
        LinkedHashMap<String, String> exceptionMap = new LinkedHashMap<String, String>(10);
        output = QueryConversionUtility.getExceptionKeywordMap(output, exceptionMap, exceptionKeywordsList);
        Matcher matcherkeyword = patternkeyword.matcher(output);
        while (matcherkeyword.find()) {
            startidx = matcherkeyword.start(grpNum);
            endIdx = matcherkeyword.end(grpNum);
            stringBuff.append(output.substring(tempEnd, startidx));
            stringBuff.append(gaussSlashKey).append(QueryConversionUtility.toUpper(matcherkeyword.group(grpNum))).append(replacement);
            tempEnd = endIdx;
        }
        stringBuff.append(output.substring(tempEnd));
        output = stringBuff.toString();
        String excepPattern = "(##EXPN##\\d+#)";
        output = QueryConversionUtility.getRplFromMap(output, exceptionMap, excepPattern);
        return output;
    }

    private static String getExceptionKeywordMap(String inputSql, Map<String, String> exceptionMap, String exceptionKeywordsList) {
        String rplStr = "##EXPN##";
        String outputSql = inputSql;
        Pattern pattern = Pattern.compile("(?i)(?<!\\w|\")(" + exceptionKeywordsList + ")");
        Matcher matcher = pattern.matcher(outputSql);
        int expCnt = 1;
        String keyString = null;
        while (matcher.find()) {
            keyString = matcher.group(1);
            outputSql = outputSql.replace(keyString, rplStr + expCnt + "#");
            exceptionMap.put(rplStr + expCnt + "#", keyString);
            ++expCnt;
        }
        return outputSql;
    }

    public static List<String> getMatchedGrpsInLst(String inputVal, String patternString, int grpNo, List<String> list) {
        String input = inputVal;
        input = QueryConversionUtility.canonicalizeString(input);
        Pattern pattern = Pattern.compile(patternString, 2);
        Matcher matcher = pattern.matcher(new InterruptCharSequence(input));
        while (matcher.find()) {
            list.add(matcher.group(grpNo));
        }
        return list;
    }

    public static Set<String> getUniqueMatchedGrpsInSet(String input, String patternString, int grpNo) {
        HashSet<String> returnSet = new HashSet<String>(10);
        Pattern pattern = Pattern.compile(patternString, 2);
        Matcher matcher = pattern.matcher(input);
        String tempStr = null;
        while (matcher.find()) {
            tempStr = QueryConversionUtility.toLower(matcher.group(grpNo));
            if ((tempStr = QueryConversionUtility.canonicalizeString(tempStr)) != null && tempStr.contains("\"") && tempStr.matches("(?i)(\\w+\\.\\s*\"(owner|key|name|limit|cast)\")")) {
                tempStr = tempStr.replaceAll("\"", "");
            }
            returnSet.add(tempStr);
        }
        return returnSet;
    }

    public static String doGetStrFrmListWithSeparator(List<String> inputList, String separator) {
        StringBuilder sb = new StringBuilder();
        int cnt = inputList.size();
        for (int iIndex = 0; iIndex < cnt; ++iIndex) {
            if (iIndex != cnt - 1) {
                sb.append(inputList.get(iIndex)).append(separator);
                continue;
            }
            sb.append(inputList.get(iIndex));
        }
        return sb.toString();
    }

    public static String doPutSpaceBeforeAs(int closeIndex, String inputArrValue, int startIndex) {
        String subAs;
        String inputStr = inputArrValue;
        if (inputStr.charAt(closeIndex + 1) != ' ' && QueryConversionUtility.equalCheck(subAs = inputStr.substring(closeIndex + 1, closeIndex + 3), "AS")) {
            inputStr = inputStr.substring(0, closeIndex + 1) + " " + inputStr.substring(closeIndex + 1);
        }
        return inputStr;
    }

    public static String doGetColumnValue(String inputColValue, String aliasChecker) {
        String output = inputColValue;
        String temp = aliasChecker.trim();
        temp = temp.contains("\"") ? temp.substring(temp.indexOf(34)) : temp.substring(temp.lastIndexOf(32) + 1);
        if (!temp.isEmpty()) {
            boolean tCondition;
            char charLetter = temp.charAt(0);
            boolean fCondition = temp.charAt(0) > '@' && charLetter < '[';
            boolean sCondition = charLetter > '`' && charLetter < '{';
            boolean bl = tCondition = charLetter == '\"';
            if (fCondition || sCondition || tCondition) {
                output = inputColValue.substring(0, inputColValue.indexOf(temp) - 1);
            }
        }
        return output;
    }

    public static int doGetPuncSymbolIndex(String inputStr, String symbol, String symbolAfter) {
        int commaIdx = 0;
        commaIdx = inputStr.contains(symbolAfter) ? inputStr.indexOf(symbol, inputStr.lastIndexOf(symbolAfter)) : inputStr.lastIndexOf(symbol);
        return commaIdx;
    }

    public static String doRemDotOrAppendAlias(String columnNames, boolean removeDots) {
        int cnt = 1;
        int aliasCnt = 1;
        String[] commaArray = null;
        String aliasNameTemp = "ColumnAlias";
        StringBuffer outCols = new StringBuffer();
        StringBuffer colBuf = new StringBuffer();
        String output = "";
        String cmntPlaceholderStrt = null;
        String cmntPlaceholderEnd = null;
        String inputColumn = null;
        if (columnNames != null) {
            LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
            columnNames = QueryConversionUtility.getSingleQuoteMap(columnNames, quoteMap);
            commaArray = QueryConversionUtility.doGetArrSplit(columnNames, ",");
            List<String> colAliasLst = Arrays.asList(commaArray);
            colAliasLst = QueryConversionUtility.doGetAliasListWithOutAddingAlias(colAliasLst);
            for (int i = 0; i < commaArray.length; ++i) {
                cmntPlaceholderStrt = "";
                cmntPlaceholderEnd = "";
                inputColumn = commaArray[i].trim();
                if (inputColumn.contains("#S#")) {
                    cmntPlaceholderStrt = QueryConversionUtility.doGetStartCmnts(inputColumn);
                    cmntPlaceholderEnd = QueryConversionUtility.doGetEndCmnts(inputColumn);
                    inputColumn = inputColumn.replaceAll("(?i)#S#\\d+#E#", "");
                }
                if (!cmntPlaceholderStrt.isEmpty()) {
                    outCols.append(cmntPlaceholderStrt).append(" ");
                }
                if (inputColumn.trim().contains(" ") && !removeDots) {
                    outCols.append(inputColumn);
                } else if (inputColumn.trim().startsWith("_COLUMN__") && !removeDots) {
                    outCols.append(inputColumn).append(" ").append("AS").append(" ");
                    colBuf = colBuf.append(aliasNameTemp).append(aliasCnt);
                    if (colAliasLst.contains(colBuf.toString())) {
                        while (colAliasLst.contains(colBuf.toString())) {
                            colBuf.setLength(0);
                            colBuf.append(aliasNameTemp).append(++aliasCnt);
                        }
                        ++aliasCnt;
                        outCols.append(colBuf);
                    } else {
                        outCols.append(colBuf);
                        ++aliasCnt;
                    }
                    colBuf.setLength(0);
                } else if (removeDots) {
                    int dotIdx = inputColumn.indexOf(46);
                    if (dotIdx > 0) {
                        int lastSpaceIdx = inputColumn.substring(0, dotIdx).lastIndexOf(" ");
                        if (lastSpaceIdx > 0) {
                            outCols.append(inputColumn.substring(0, lastSpaceIdx + 1));
                            outCols.append(inputColumn.substring(dotIdx + 1, inputColumn.length()));
                        } else {
                            outCols.append(inputColumn.substring(dotIdx + 1, inputColumn.length()));
                        }
                    } else {
                        outCols.append(inputColumn.substring(dotIdx + 1, inputColumn.length()));
                    }
                } else {
                    outCols.append(inputColumn);
                }
                if (!cmntPlaceholderEnd.isEmpty()) {
                    outCols.append(" ").append(cmntPlaceholderEnd);
                }
                if (cnt == commaArray.length) continue;
                outCols.append(",");
                ++cnt;
            }
            output = outCols.toString();
            output = QueryConversionUtility.getRplFromMap(output, quoteMap, "(##QUOTE##\\d+#)");
        }
        return output;
    }

    private static String getOutput(boolean removeDots, StringBuffer outCols, String columnNamesStr) {
        LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
        String columnNames = QueryConversionUtility.getSingleDoubleQuoteMap(columnNamesStr, quoteMap);
        String[] commaArray = QueryConversionUtility.doGetArrSplit(columnNames, ",");
        List<String> colAliasLst = Arrays.asList(commaArray);
        colAliasLst = QueryConversionUtility.doGetAliasListWithOutAddingAlias(colAliasLst);
        int cnt = 1;
        int aliasCnt = 1;
        StringBuffer colBuf = new StringBuffer();
        for (int iIndex = 0; iIndex < commaArray.length; ++iIndex) {
            String cmntPlaceholderStrt = "";
            String cmntPlaceholderEnd = "";
            String inputColumn = commaArray[iIndex].trim();
            if (inputColumn.contains("#S#")) {
                cmntPlaceholderStrt = QueryConversionUtility.doGetStartCmnts(inputColumn);
                cmntPlaceholderEnd = QueryConversionUtility.doGetEndCmnts(inputColumn);
                inputColumn = inputColumn.replaceAll("(?i)#S#\\d+#E#", "");
            }
            if (!cmntPlaceholderStrt.isEmpty()) {
                outCols.append(cmntPlaceholderStrt).append(" ");
            }
            if (inputColumn.trim().contains(" ") && !removeDots) {
                outCols.append(inputColumn);
            } else if (inputColumn.trim().startsWith("_COLUMN__") && !removeDots) {
                outCols.append(inputColumn).append(" ").append("AS").append(" ");
                String aliasNameTemp = "ColumnAlias";
                colBuf = colBuf.append(aliasNameTemp).append(aliasCnt);
                aliasCnt = QueryConversionUtility.getAliasList(aliasCnt, aliasNameTemp, outCols, colBuf, colAliasLst);
                colBuf.setLength(0);
            } else if (removeDots) {
                outCols.append(inputColumn.substring(inputColumn.indexOf(46) + 1, inputColumn.length()));
            } else {
                outCols.append(inputColumn);
            }
            cnt = QueryConversionUtility.getOut(commaArray, outCols, cnt, cmntPlaceholderEnd);
        }
        String output = QueryConversionUtility.outAfterRplMap(outCols, quoteMap);
        return output;
    }

    private static String outAfterRplMap(StringBuffer outCols, Map<String, String> quoteMap) {
        String output = outCols.toString();
        output = QueryConversionUtility.getRplFromMap(output, quoteMap, "(##QUOTE##\\d+#)");
        return output;
    }

    private static int getOut(String[] commaArray, StringBuffer outCols, int count, String cmntPlaceholderEnd) {
        int cnt = count;
        if (!cmntPlaceholderEnd.isEmpty()) {
            outCols.append(" ").append(cmntPlaceholderEnd);
        }
        if (cnt != commaArray.length) {
            outCols.append(",");
            ++cnt;
        }
        return cnt;
    }

    private static int getAliasList(int aliasCntInp, String aliasNameTemp, StringBuffer outCols, StringBuffer colBuf, List<String> colAliasLst) {
        int aliasCnt = aliasCntInp;
        if (colAliasLst.contains(colBuf.toString())) {
            while (colAliasLst.contains(colBuf.toString())) {
                colBuf.setLength(0);
                colBuf.append(aliasNameTemp).append(++aliasCnt);
            }
            ++aliasCnt;
            outCols.append(colBuf);
        } else {
            outCols.append(colBuf);
            ++aliasCnt;
        }
        return aliasCnt;
    }

    public static int getLastIndex(String inputStr, String finderStrInp) {
        String finderStr = finderStrInp;
        finderStr = QueryConversionUtility.preChkForRegex(finderStr);
        Pattern pattern = Pattern.compile("(?i).*(?<!\\w)" + finderStr + "(?!\\w)");
        Matcher matcher = pattern.matcher(inputStr);
        int index = -1;
        if (matcher.find()) {
            index = matcher.end();
        }
        return index;
    }

    public static int getLastIndexForSymbols(String inputStr, String finderStrInp) {
        String finderStr = finderStrInp;
        finderStr = QueryConversionUtility.preChkForRegex(finderStr);
        Pattern pattern = Pattern.compile("(?i).*" + finderStr);
        Matcher matcher = pattern.matcher(inputStr);
        int index = -1;
        if (matcher.find()) {
            index = matcher.end();
        }
        return index;
    }

    public static int getStartIndex(String inputStr, String patternStr, int group) {
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(inputStr);
        int index = -1;
        if (matcher.find()) {
            index = matcher.start(group);
        }
        return index;
    }

    public static int getEndIndex(String inputStr, String patternStr, int group) {
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(inputStr);
        int index = -1;
        if (matcher.find()) {
            index = matcher.end(group);
        }
        return index;
    }

    public static String santizePattern(String pattern) {
        String sanizedPat = "";
        if (pattern == null) {
            return sanizedPat;
        }
        sanizedPat = pattern.replaceAll("[-.\\+*?\\[^\\]$(){}=!<>|:\\\\]", "\\\\$0");
        return sanizedPat;
    }

    public static int doGetAppThreadCnt() {
        if (appThreadCount == -1) {
            int defaultThreadCnt = Runtime.getRuntime().availableProcessors() - 1;
            if (logger.isInfoEnabled()) {
                logger.info(MessageLoader.getMessage("processor"), (Object)(defaultThreadCnt + 1));
            }
            try {
                appThreadCount = Integer.parseInt(ApplicationPropertyLoader.getStringProperty("NoOfThreads"));
            }
            catch (NumberFormatException ex) {
                appThreadCount = defaultThreadCnt;
                logger.error(ErrorLoggerUtility.getExceptionDetails(ex) + " [DSC_ERR_004_037] " + MessageLoader.getMessage("DSC_ERR_004_037"));
                QueryConversionUtility.printConsoleMessage("Invalid input(empty/space/string value) for the parameter NoOfThreads in application.properties. Hence taking the default processes.");
            }
            if (appThreadCount < 1) {
                appThreadCount = defaultThreadCnt;
                logger.error("[DSC_ERR_004_038] " + MessageLoader.getMessage("DSC_ERR_004_038"));
                QueryConversionUtility.printConsoleMessage("Input for the parameter NoOfThreads in application.properties is less than 1. Hence taking the default processes.");
            }
            if (logger.isInfoEnabled()) {
                logger.info(MessageLoader.getMessage("userConfigProcessor"), (Object)appThreadCount);
            }
        }
        return appThreadCount;
    }

    public static String doCommentSpecificGrp(String input, String inputPattern, int groupNo) {
        String output = input;
        Pattern pattern = Pattern.compile(inputPattern);
        Matcher matcher = pattern.matcher(output);
        if (matcher.find()) {
            output = output.replaceAll("(?i)title", "COMMENT").replaceAll("(?i)compress", "");
        }
        return output;
    }

    public static String getColumnsFromList(int startIndex, List<String> mdiffColList) {
        StringBuffer outBuff = new StringBuffer();
        if (mdiffColList.size() > startIndex) {
            int colSize = mdiffColList.size();
            for (int iIndex = startIndex; iIndex < colSize; ++iIndex) {
                outBuff.append(mdiffColList.get(iIndex)).append(",");
            }
            outBuff.deleteCharAt(outBuff.length() - 1);
        }
        return outBuff.toString();
    }

    public static String supportedValidator(String oraInputQuery) {
        String output = QueryConversionUtility.isExcludePatternFound(oraInputQuery, "(?<!\\w|\")(ORGANIZATION\\s+INDEX|GROUP_ID\\s*\\()(?!\\w|\\+)");
        return output;
    }

    public static String finderGroup(String input, String pattern, int groupNo) {
        String finderStr = null;
        Pattern finderPat = Pattern.compile(pattern);
        Matcher finderMatch = finderPat.matcher(input);
        if (finderMatch.find()) {
            finderStr = finderMatch.group(groupNo);
        }
        return finderStr;
    }

    public static List<String> getLstFrmStringWithComma(String inputStr, boolean isUpper) {
        String[] colsArr = null;
        ArrayList<String> colsLst = new ArrayList<String>(10);
        colsArr = inputStr.contains(",") ? inputStr.split(",") : new String[]{inputStr};
        for (String col : colsArr) {
            if (isUpper) {
                colsLst.add(QueryConversionUtility.toUpper(col.trim()));
                continue;
            }
            colsLst.add(col.trim());
        }
        return colsLst;
    }

    public static String doGetSpecficClause(String fromTempInp, String patString) {
        String clause = "";
        String fromTemp = fromTempInp;
        fromTemp = QueryConversionUtility.canonicalizeString(fromTemp);
        Pattern pat = Pattern.compile(patString);
        Matcher match = pat.matcher(fromTemp);
        if (match.find()) {
            clause = match.group(1);
        }
        return clause;
    }

    public static int doCntCharacter(String rankCol, char character) {
        int count = 0;
        for (int iIndex = 0; iIndex < rankCol.length(); ++iIndex) {
            if (rankCol.charAt(iIndex) != character) continue;
            ++count;
        }
        return count;
    }

    public static String doCorrectBrackets(String rankCol) {
        Pattern rnkOver = Pattern.compile("(?i)(?<!\\w)(?:rank|row_number|sum)(?!\\w).*?(over\\s*\\()");
        Matcher rnkOverMat = rnkOver.matcher(rankCol);
        Matcher mdiffMat = MDIFF_PAT.matcher(rankCol);
        int rnkStart = 0;
        int ovrStart = 0;
        String rankColumn = rankCol;
        if (rnkOverMat.find()) {
            rnkStart = rnkOverMat.start();
            ovrStart = rnkOverMat.start(1);
            String overStr = QueryConversionUtility.doGetReplaceString(rankCol.substring(ovrStart));
            rankColumn = rankCol.substring(rnkStart, ovrStart + overStr.length());
        } else if (mdiffMat.find()) {
            rnkStart = mdiffMat.start();
            String mdiffStr = QueryConversionUtility.doGetReplaceString(rankCol.substring(rnkStart));
            rankColumn = rankCol.substring(rnkStart, rnkStart + mdiffStr.length());
        } else {
            rankColumn = rankCol.replaceAll("\\(|\\)", "");
        }
        return rankColumn;
    }

    public static String doReplaceOverStr(String sqlQuery, Map<String, String> overMap) {
        StringBuffer sbuf = new StringBuffer();
        if (sqlQuery.matches("(?i).*?(?<!\\w)over\\s*\\(.*")) {
            Matcher matcherOver = PATTERN_OVER.matcher(sqlQuery);
            int idx = 0;
            int tmpIdx = 0;
            String overStr = null;
            String rplStr = "##OVER##";
            int overCnt = 1;
            while (matcherOver.find()) {
                idx = matcherOver.start();
                sbuf.append(sqlQuery.substring(tmpIdx, idx));
                overStr = QueryConversionUtility.doGetReplaceString(sqlQuery.substring(idx));
                sbuf.append(rplStr).append(overCnt).append("#");
                overMap.put(rplStr + overCnt++ + "#", overStr);
                tmpIdx = idx + overStr.length();
            }
            sbuf.append(sqlQuery.substring(tmpIdx));
        } else {
            sbuf.append(sqlQuery);
        }
        return sbuf.toString();
    }

    public static String doRplSingleQuoteInColumn(String inputQry, String regex, Map<String, String> quoteMap) {
        String input = inputQry;
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            input = QueryConversionUtility.getOutQry(regex, quoteMap, input, matcher);
        }
        return input;
    }

    private static String getOutQry(String regex, Map<String, String> quoteMap, String input, Matcher matcher) {
        boolean rplFlag = false;
        StringBuffer sbuf = new StringBuffer();
        if (matcher.group(1).contains("'") || matcher.group(1).contains("#")) {
            ColumnSplitter splitter = new ColumnSplitter();
            List<String> colList = splitter.doGetAllColumns(matcher.group(1));
            String column = null;
            boolean teradataRegex = regex.equals("(?i)(?<!\\w)select(?!\\w)(.*?)($|(?<!\\w)from)(?!\\w)");
            for (String cols : colList) {
                String quoteColumn = "";
                column = cols;
                if (column.startsWith("'") || column.startsWith("#")) {
                    String colValue = null;
                    int quoteIdx = 0;
                    if (column.startsWith("'")) {
                        quoteIdx = column.lastIndexOf(39);
                        quoteColumn = QueryConversionUtility.getQuoteColumn(column, quoteColumn);
                    } else if (column.startsWith("#") && teradataRegex) {
                        quoteIdx = column.lastIndexOf(35);
                        Matcher quoteMatcher = QUOTE_PATTERN.matcher(column);
                        if (quoteMatcher.find()) {
                            quoteColumn = quoteMatcher.group(1);
                            String string = colValue = quoteMap != null ? quoteMap.get(quoteColumn) : null;
                            if (colValue == null || !colValue.startsWith("'")) {
                                quoteIdx = -1;
                            }
                            colValue = quoteMatcher.group();
                        } else {
                            quoteIdx = -1;
                        }
                    }
                    if (quoteIdx > 0) {
                        column = QueryConversionUtility.getColumnValue(column, teradataRegex, quoteColumn, colValue, quoteIdx);
                        rplFlag = true;
                    }
                }
                sbuf.append(column).append(",");
            }
            if (sbuf.length() > 0) {
                sbuf.deleteCharAt(sbuf.length() - 1);
            }
            String colStr = sbuf.toString();
            input = QueryConversionUtility.getInputValue(input, matcher.group(1), colStr, rplFlag);
        }
        return input;
    }

    private static String getQuoteColumn(String column, String quoteColumnInp) {
        Matcher singleQuoteMatcher = SINGLE_QUOTE_PATTERN.matcher(column);
        String quoteColumn = quoteColumnInp;
        if (singleQuoteMatcher.find()) {
            quoteColumn = singleQuoteMatcher.group();
        }
        return quoteColumn;
    }

    private static String getInputValue(String inputVal, String columns, String colStr, boolean rplFlag) {
        String input = inputVal;
        if (rplFlag) {
            StringBuffer sbuf = new StringBuffer();
            sbuf.append(input.substring(0, input.indexOf(columns))).append(" ").append(colStr).append(" ").append(input.substring(input.indexOf(columns) + columns.length()));
            input = sbuf.toString();
        }
        return input;
    }

    private static String getColumnValue(String columnInp, boolean teradataRegex, String quoteColumn, String colValue, int quoteIdx) {
        String alias = "";
        StringBuffer subCols = null;
        String column = columnInp;
        if (!QueryConversionUtility.containsCheck(column, " as ")) {
            subCols = column.matches("\\'.*?\\'\\s*\\w+") ? new StringBuffer(quoteColumn) : new StringBuffer(column);
        } else {
            subCols = colValue != null ? new StringBuffer(colValue) : new StringBuffer(quoteColumn);
            Matcher asMatcher = AS_PATTERN.matcher(column);
            if (asMatcher.find()) {
                alias = asMatcher.group(2);
            }
        }
        String checkDataType = column.substring(quoteIdx + 1).trim();
        subCols.insert(0, "cast ( ");
        subCols = QueryConversionUtility.doTypeCasting(column, teradataRegex, subCols, checkDataType, alias);
        column = subCols.toString();
        return column;
    }

    private static StringBuffer doTypeCasting(String column, boolean teradataRegex, StringBuffer subColumns, String checkDataType, String alias) {
        StringBuffer subCols = subColumns;
        String dataType = null;
        if (checkDataType.startsWith("(") && teradataRegex) {
            Matcher matcher = DATATYPE_PAT.matcher(subCols);
            if (matcher.find()) {
                dataType = "AS " + matcher.group(1);
                subCols = subCols.replace(matcher.start(1) - 1, matcher.end(1) + 1, "");
            }
        } else {
            dataType = " as text";
        }
        if (dataType == null) {
            Matcher dataTypeMatch = VARCHAR_PAT.matcher(checkDataType);
            if (dataTypeMatch.find()) {
                dataType = "AS " + dataTypeMatch.group(1);
            }
            subCols.append(" ").append(dataType).append(")");
        } else if (column.startsWith("'")) {
            subCols.append(" ").append(dataType).append(")");
        } else if (column.startsWith("#") && teradataRegex) {
            subCols.append(" ").append(dataType).append(")");
        }
        if (!alias.isEmpty()) {
            if (QueryConversionUtility.containsCheck(checkDataType, "AS") && !QueryConversionUtility.containsCheck(checkDataType, "varchar")) {
                subCols.append(" ").append(checkDataType);
            } else {
                subCols.append(" ").append(alias);
            }
        }
        return subCols;
    }

    public static boolean checkJoin(String tableName) {
        boolean isJoin = false;
        if (QueryConversionUtility.containsCheck(tableName, "join")) {
            isJoin = tableName.matches("(?i).*(?<!\\w)(?:left|right|full|cross|self|inner)(?!\\w)\\s*(?:#S#\\d+#E#\\s*)*(?:(?<!\\w)(?:outer)(?!\\w))?\\s*(?:#S#\\d+#E#\\s*)*(?<!\\w)join(?!\\w).*");
        }
        return isJoin;
    }

    public static String replacementQuoteComment(String sql, Map<String, String> quoteMap, Map<String, String> multiCommentMap) {
        String outputSql = sql;
        String rplStr = "##QUOTE##";
        Pattern pattern1 = Pattern.compile("('.*?'|\".*?\"|\\$q\\$.*?\\$q\\$)");
        Pattern pattern2 = Pattern.compile("(\\/\\*.*?\\*\\/)");
        int quoteCnt = 1;
        String quoteString = null;
        String commentString = null;
        int quoteIndex = outputSql.length();
        int commentIndex = outputSql.length();
        int commentStart = 0;
        int quoteStart = 0;
        int commentCnt = 1;
        while (quoteIndex != -1 || commentIndex != -1) {
            int minValue;
            quoteIndex = QueryConversionUtility.minIndex(outputSql.indexOf(39, quoteStart), outputSql.indexOf(34, quoteStart));
            if (quoteIndex == (minValue = QueryConversionUtility.minIndex(quoteIndex, commentIndex = outputSql.indexOf("/*", commentStart)))) {
                Matcher matcher1 = pattern1.matcher(outputSql);
                if (matcher1.find()) {
                    quoteString = matcher1.group();
                    outputSql = outputSql.replace(quoteString, rplStr + quoteCnt + "#");
                    quoteMap.put(rplStr + quoteCnt + "#", quoteString);
                    ++quoteCnt;
                    continue;
                }
                quoteStart = quoteIndex + 1;
                continue;
            }
            if (commentIndex != minValue) continue;
            Matcher matcher2 = pattern2.matcher(outputSql = QueryConversionUtility.canonicalizeString(outputSql));
            if (matcher2.find()) {
                commentString = matcher2.group();
                String rplStrComm = "##COMMENT##";
                outputSql = outputSql.replace(commentString, rplStrComm + commentCnt + "#");
                multiCommentMap.put(rplStrComm + commentCnt + "#", commentString);
                ++commentCnt;
                continue;
            }
            commentStart = commentIndex + 2;
        }
        return outputSql;
    }

    private static int minIndex(int indexOne, int indexTwo) {
        int output = indexOne;
        if (indexOne == -1 || indexTwo == -1) {
            output = indexOne == -1 ? indexTwo : indexOne;
        } else if (indexTwo < indexOne) {
            output = indexTwo;
        }
        return output;
    }

    public static String replaceAll(String input, String regex, String replacement) {
        return QueryConversionUtility.replace(input, regex, replacement, false);
    }

    public static String replace(String input, String regex, String replacement, boolean replaceFirst) {
        StringBuffer sb = new StringBuffer(128);
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(new InterruptCharSequence(input));
        int tempIndex = 0;
        while (matcher.find()) {
            int startIndex = matcher.start();
            int endIndex = matcher.end();
            String str = input.substring(tempIndex, startIndex);
            sb.append(str);
            sb.append(replacement);
            tempIndex = endIndex;
            if (!replaceFirst) continue;
            break;
        }
        sb.append(input.substring(tempIndex));
        return sb.toString();
    }

    public static String changeBitmapIndex(String outputVal) {
        StringBuffer sb = new StringBuffer();
        String output = outputVal;
        Matcher bitmapMatcher = BITMAP_PATTRN.matcher(output);
        int endIndex = 0;
        int tempIndex = 0;
        int tableIndex = 0;
        String match = null;
        String bitmapIndex = FeatureLoader.getStringProperty("BitmapIndexSupport");
        String bitmapCmnt = "/*bitmap*/";
        while (bitmapMatcher.find()) {
            if ("comment".equalsIgnoreCase(bitmapIndex)) {
                tempIndex = bitmapMatcher.start();
                sb.append(output.substring(endIndex, tempIndex));
                match = bitmapMatcher.group(0);
                match = match.replace(bitmapMatcher.group(0), "/*" + bitmapMatcher.group(0) + "*/");
                sb.append(match);
                endIndex = bitmapMatcher.end();
                continue;
            }
            if (!"btree".equalsIgnoreCase(bitmapIndex)) continue;
            tempIndex = bitmapMatcher.start();
            sb.append(output.substring(endIndex, tempIndex));
            endIndex = bitmapMatcher.end();
            tableIndex = bitmapMatcher.end(2);
            sb.append(output.substring(tempIndex, tableIndex));
            sb.append(" ");
            sb.append("USING");
            sb.append(" ").append("btree");
            sb.append(" ");
            sb.append(output.substring(tableIndex, endIndex));
        }
        sb.append(output.substring(endIndex, output.length()));
        output = sb.toString();
        if ("btree".equalsIgnoreCase(bitmapIndex)) {
            output = output.replaceAll("(?i)(?<!\\w|\"|')bitmap(?!\\w)", bitmapCmnt);
        }
        return output;
    }

    public static String doChangeTableToUnnest(String outputVal) {
        StringBuffer sb = new StringBuffer();
        ColumnSplitter splitter = new ColumnSplitter();
        String output = outputVal;
        output = QueryConversionUtility.canonicalizeString(output);
        Matcher matcher = SELECT_FROM_TABLE_PAT.matcher(output);
        int tempIndex = 0;
        while (matcher.find()) {
            int startIndex = matcher.start(1);
            sb.append(output != null ? output.substring(tempIndex, startIndex) : "null");
            String columnValue = matcher.group(1).trim();
            List<String> columnList = splitter.doGetAllColumns(columnValue);
            tempIndex = startIndex;
            startIndex = matcher.start(2);
            int endIndex = matcher.end(2);
            if (output == null) continue;
            sb.append(output.substring(tempIndex, startIndex));
            sb.append("UNNEST");
            String tableName = QueryConversionUtility.doGetTableName(output).trim();
            String paranthesisString = QueryConversionUtility.doGetReplaceString(output.substring(endIndex));
            int length = paranthesisString.length();
            int index = tableName.indexOf(paranthesisString);
            sb.append(paranthesisString);
            if (index != -1) {
                tableName = tableName.substring(index);
                if (!(tableName = tableName.replace(paranthesisString, "").trim()).isEmpty() && !tableName.matches("(?i).*(?<!\\w)SELECT(.*?)FROM\\s+.*(TABLE)\\(.*")) {
                    tableName = QueryConversionUtility.getTblName(sb, tableName);
                    length = length + tableName.length() + 1;
                }
            }
            QueryConversionUtility.getappendedBuf(sb, columnList, tableName);
            tempIndex = endIndex + length;
        }
        return output != null ? sb.append(output.substring(tempIndex)).toString() : sb.toString();
    }

    private static String getTblName(StringBuffer sb, String tblNme) {
        String tableName = tblNme;
        int commaIndex = tableName.indexOf(",");
        if (commaIndex != -1) {
            tableName = tableName.substring(0, commaIndex);
        }
        sb.append(" ").append(tableName);
        return tableName;
    }

    private static void getappendedBuf(StringBuffer sb, List<String> columnList, String tableName) {
        if (columnList.size() != 1 || !"*".equals(columnList.get(0))) {
            for (String col : columnList) {
                if (!col.matches("(?i).*(?<!\\w|#)(column_value|\\.?\\*)(?!\\w|\\s*\\(|\\.).*")) continue;
                if (!tableName.isEmpty()) {
                    sb.append(" ( COLUMN_VALUE ) ");
                } else {
                    sb.append(" AS COLUMN_VALUE ");
                }
                break;
            }
        } else {
            sb.append(" AS COLUMN_VALUE ");
        }
    }

    public static String doGetTableName(String inputVal) {
        Pattern fromPattern;
        Matcher fromMatch;
        String fromClause = "";
        LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
        String input = inputVal;
        if ((input = QueryConversionUtility.getSingleQuoteMap(input, quoteMap)).matches("(?i).*?(?<!\\w)select(?!\\w).*(?<!\\w)from(?!\\w).*") && (fromMatch = (fromPattern = Pattern.compile("(?i).*?(?<!\\w)select(?!\\w).*?(?<!\\w)from(?!\\w)(.*?)((?<!\\w)(?:where|qualify|group\\s+by|having|order\\s+by|connect\\s+by|start\\s+with)(?!\\w)|;|$).*", 2)).matcher(input)).find() && (fromClause = fromMatch.group(1).trim()).startsWith("(") && !fromClause.endsWith(")")) {
            fromClause = " " + fromClause.substring(1) + " ";
        }
        fromClause = QueryConversionUtility.getRplFromMap(fromClause, quoteMap, "(##QUOTE##\\d+#)");
        return fromClause;
    }

    public static List<String> doGetColumnNameList(String input) {
        List<String> columnList = new ArrayList<String>(10);
        Matcher fromMatch = SELECT_FROM_PAT.matcher(input);
        if (fromMatch.find()) {
            ColumnSplitter splitter = new ColumnSplitter();
            columnList = splitter.doGetAllColumns(fromMatch.group(1));
        }
        for (String element : columnList) {
            columnList.set(columnList.indexOf(element), element);
        }
        return columnList;
    }

    public static String doSplitcolNameDotALias(String columnName, String tblAlias) {
        Matcher matcher = DOT_PAT.matcher(columnName);
        StringBuffer sb = new StringBuffer();
        int tempIndex = 0;
        while (matcher.find()) {
            int startIndex = matcher.start();
            int endIndex = matcher.end();
            sb.append(columnName.substring(tempIndex, startIndex));
            String grp = matcher.group();
            if (!grp.equalsIgnoreCase(tblAlias + ".")) {
                sb.append(grp);
            }
            tempIndex = endIndex;
        }
        sb.append(columnName.substring(tempIndex));
        return sb.toString();
    }

    public static List<String> doGetVarsInCaseStmt(String columnName) {
        ArrayList<String> varList = new ArrayList<String>(10);
        Pattern pattern = Pattern.compile("(?i)(?<!\\w|'|\\\"|#)(?!\\d+|(LEVEL|CASE|WHEN|THEN|IF|ELSE|END)(?!\\w))\\w+(?!\\w|\\s*'|\\s*\\\"|\\s*\\(|\\.)");
        Matcher matcher = pattern.matcher(columnName);
        while (matcher.find()) {
            varList.add(matcher.group());
        }
        return varList;
    }

    public static List<String> doGetOrderByClauseList(String input) {
        ArrayList<String> orderByList = new ArrayList<String>(10);
        Matcher orderMatch = ORDER_PATTERN.matcher(input);
        String group = null;
        if (orderMatch.find()) {
            group = orderMatch.group(2);
        }
        if (group != null) {
            String[] ordArray;
            group = QueryConversionUtility.replaceAll(group, "(?i)(?<!\\w)(ASC|DESC|nulls LAST|nulls FIRST)", "");
            for (String arr : ordArray = group.split("(?i)(,)")) {
                String[] splitArr;
                if (arr.trim().matches("(?i)(?<!\\w)\\w+\\((.*)\\)")) {
                    arr = QueryConversionUtility.finderGroup(arr.trim(), "(?i)(?<!\\w)\\w+\\((.*)\\)", 1);
                }
                if (arr == null || "LEVEL".equalsIgnoreCase((splitArr = arr.split("(?i)(\\.)"))[splitArr.length - 1].trim())) continue;
                orderByList.add(splitArr[splitArr.length - 1]);
            }
        }
        return orderByList;
    }

    public static String doCommentPatternGrp(String input, String inputPattern, int groupNo) {
        String output = input;
        output = QueryConversionUtility.canonicalizeString(output);
        Pattern pattern = Pattern.compile(inputPattern);
        Matcher matcher = pattern.matcher(output);
        StringBuffer sb = new StringBuffer();
        int tempIndex = 0;
        if (output != null) {
            while (matcher.find()) {
                String group = matcher.group(groupNo);
                int startIndex = matcher.start(groupNo);
                int endIndex = matcher.end(groupNo);
                sb.append(output.substring(tempIndex, startIndex));
                sb.append(" /*" + group + "*/ ");
                tempIndex = endIndex;
            }
            sb.append(output.substring(tempIndex));
        }
        output = sb.toString();
        return output;
    }

    public static String doGetColumnNameWithAlias(String columnNameWithAlias, String columnAliasList, String joinAlias, boolean multiTblFlag) {
        String output = columnNameWithAlias;
        LinkedHashMap<String, String> quoteMap = new LinkedHashMap<String, String>(10);
        output = QueryConversionUtility.getSingleQuoteMap(output, quoteMap);
        int index = output.lastIndexOf(columnAliasList);
        String colName = output;
        StringBuffer sb = new StringBuffer();
        if (!(multiTblFlag || colName.matches("\\d+|##QUOTE##\\d+#") || QueryConversionUtility.equalCheck("LEVEL", colName) || colName.contains("."))) {
            sb.append(joinAlias + ".");
        }
        sb.append(colName);
        if (index != -1 && index != 0) {
            colName = output.substring(0, index);
            Pattern pattern = Pattern.compile("(?i)(?<!\\w|'|\\\"|#)(?!\\d+|(LEVEL|CASE|WHEN|THEN|ELSE|END|IF|AND|OR)(?!\\w))\\w+(?!\\w|\\s*'|\\s*\\\"|\\s*\\(|\\.)");
            Matcher matcher = pattern.matcher(colName);
            int tempIndex = 0;
            sb = new StringBuffer();
            while (matcher.find()) {
                String group = matcher.group();
                int startIndex = matcher.start();
                int endIndex = matcher.end();
                if (group.matches("##QUOTE##\\d+#")) continue;
                sb.append(colName.substring(tempIndex, startIndex));
                if (!multiTblFlag && !group.matches("\\d+")) {
                    sb.append(joinAlias + ".");
                }
                sb.append(group);
                tempIndex = endIndex;
            }
            sb.append(colName.substring(tempIndex));
            sb.append(" " + columnAliasList);
        }
        output = QueryConversionUtility.outAfterRplMap(sb, quoteMap);
        return output;
    }

    public static String canonicalizeString(String strVal) {
        return strVal != null ? Normalizer.normalize(strVal, Normalizer.Form.NFKC) : null;
    }

    public static String doReplaceUnsupportedException(String input) {
        String output = input;
        StringBuffer sb = new StringBuffer();
        int tempIndex = 0;
        Pattern pattern = Pattern.compile("(?i)WHEN(.*?)THEN.*?;\\s*(\\s*#S#\\d+#E#)?(?=\\s*(WHEN|$))");
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            String exception = matcher.group(1).trim();
            int startIndex = matcher.start(1);
            int endIndex = matcher.end(1);
            sb.append(output.substring(tempIndex, startIndex));
            if ("zero_divide".equalsIgnoreCase(exception)) {
                exception = "DIVISION_BY_ZERO";
            } else if ("invalid_number".equalsIgnoreCase(exception)) {
                exception = "INVALID_PARAMETER_VALUE";
            }
            String str = " " + exception + " ";
            sb.append(str);
            tempIndex = endIndex;
        }
        sb.append(output.substring(tempIndex));
        output = sb.toString();
        return output;
    }

    public static String doHandleDupValOnIndex(String input, String patternString, String replacement) {
        String output = input;
        StringBuffer sb = new StringBuffer(128);
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            int startIndex = matcher.start();
            int endIndex = matcher.end();
            sb.append(output.substring(0, startIndex));
            sb.append(output.substring(endIndex));
            output = sb.toString();
            String dupValOnIndexGrp = matcher.group(1).trim();
            output = QueryConversionUtility.doHandleExceptionInOthers(output, replacement, dupValOnIndexGrp);
        }
        return output;
    }

    private static String doHandleExceptionInOthers(String input, String replacement, String dupValOnIndexGrp) {
        String output = input;
        StringBuffer sb = new StringBuffer();
        int tempIndex = 0;
        if (dupValOnIndexGrp != null) {
            Pattern pat = Pattern.compile("(?i)WHEN\\s+OTHERS\\s+THEN(.*?;\\s*)(\\s*#S#\\d+#E#)?(?=\\s*(WHEN|$))");
            Matcher mat = pat.matcher(input);
            if (mat.find()) {
                int startIndex = mat.start(1);
                int endIndex = mat.end(1);
                sb.append(output.substring(tempIndex, startIndex));
                sb.append(" IF " + replacement + " THEN " + dupValOnIndexGrp + " ELSE ");
                sb.append(mat.group(1));
                tempIndex = endIndex;
                sb.append(output.substring(tempIndex));
                sb.append(" END IF; ");
            } else {
                sb.append(output);
                sb.append(" WHEN OTHERS THEN ");
                sb.append(" IF " + replacement + " THEN " + dupValOnIndexGrp);
                sb.append(" END IF; ");
            }
            output = sb.toString();
        }
        return output;
    }

    public static void clearFutureList(ArrayList<Future<?>> futureList) {
        for (Future<?> future : futureList) {
            if (future.isDone()) continue;
            future.cancel(true);
        }
        futureList.clear();
    }

    public static int getApplicationTimeout() {
        if (timeout == -1) {
            timeout = 4;
            try {
                timeout = Integer.parseInt(ApplicationPropertyLoader.getStringProperty("Timeout"));
            }
            catch (NumberFormatException e) {
                logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " [DSC_ERR_004_042] " + MessageLoader.getMessage("DSC_ERR_004_042"));
            }
        }
        return timeout;
    }

    public static String doReplaceOperators(String input, String patternString) {
        String output = input;
        Pattern pattern = Pattern.compile(patternString, 2);
        Matcher matcher = pattern.matcher(output);
        int tempEnd = 0;
        StringBuffer sb = new StringBuffer();
        String matcherString = null;
        while (matcher.find()) {
            int startindex = matcher.start();
            int endIndex = matcher.end();
            sb.append(input.substring(tempEnd, startindex));
            matcherString = QueryConversionUtility.toLower(matcher.group(1));
            if (matcherString.contains("eq")) {
                sb.append(" ").append("=").append(matcher.group(2));
            } else if (matcherString.contains("ne") || matcherString.contains("not") && !matcherString.contains("in") || matcherString.contains("^")) {
                sb.append(" ").append("<>").append(matcher.group(2));
            } else if (matcherString.contains("lt")) {
                sb.append(" ").append("<").append(matcher.group(2));
            } else if (matcherString.contains("le")) {
                sb.append(" ").append("<=").append(matcher.group(2));
            } else if (matcherString.contains("gt")) {
                sb.append(" ").append(">").append(matcher.group(2));
            } else if (matcherString.contains("ge")) {
                sb.append(" ").append(">=").append(matcher.group(2));
            }
            tempEnd = endIndex;
        }
        sb.append(input.substring(tempEnd));
        output = sb.toString();
        return output;
    }

    public static int countOccurrencesOfSubstring(String input, String strFind) {
        int count = 0;
        int fromIndex = 0;
        while ((fromIndex = input.indexOf(strFind, fromIndex)) != -1) {
            ++count;
            ++fromIndex;
        }
        return count;
    }

    public static String doReplaceTrunc(String inputQry) {
        String output = inputQry;
        Matcher matcher = TRUNC_PAT.matcher(output);
        while (matcher.find()) {
            output = QueryConversionUtility.doRplTruncIfMatch(inputQry, output, matcher);
        }
        return output;
    }

    private static String doRplTruncIfMatch(String inputQry, String output, Matcher matcher) {
        boolean isRequired = false;
        int commaIdx = -1;
        String truncDecider = "";
        String tempInput = inputQry.substring(matcher.start());
        String truncString = QueryConversionUtility.doGetReplaceString(tempInput);
        String truncData = QueryConversionUtility.removeParenthesis(truncString).trim();
        if (truncData.contains(",") && truncData.contains("'")) {
            commaIdx = QueryConversionUtility.doGetPuncSymbolIndex(truncData, ",", ")");
            if (commaIdx > 0) {
                isRequired = true;
                truncDecider = QueryConversionUtility.getTruncDecider(commaIdx, truncData);
            }
            switch (truncDecider) {
                case "'m": {
                    truncData = "'MONTH'," + truncData.substring(0, commaIdx);
                    break;
                }
                case "'q": {
                    truncData = "'QUARTER'," + truncData.substring(0, commaIdx);
                    break;
                }
                case "'y": {
                    truncData = "'YEAR'," + truncData.substring(0, commaIdx);
                    break;
                }
                case "'d": {
                    truncData = "'DAY'," + truncData.substring(0, commaIdx);
                    break;
                }
                default: {
                    isRequired = false;
                    break;
                }
            }
        } else if (truncData.equalsIgnoreCase("CURRENT_TIMESTAMP") || "SYSDATE".equalsIgnoreCase(truncData)) {
            truncData = "'DAY'," + truncData;
            isRequired = true;
        }
        output = QueryConversionUtility.getFinalOut(output, isRequired, truncString, truncData);
        return output;
    }

    private static String getFinalOut(String input, boolean isReq, String truncString, String inpTrunc) {
        String output = input;
        String truncData = inpTrunc;
        boolean isRequired = isReq;
        if (isRequired) {
            truncData = "DATE_TRUNC(" + truncData + ")";
            output = output.replace(truncString, truncData);
            isRequired = false;
        }
        return output;
    }

    private static String getTruncDecider(int commaIdx, String truncData) {
        String truncDecider = truncData.substring(commaIdx + 1).trim();
        truncDecider = truncDecider.length() > 2 ? truncDecider.substring(0, 2) : "";
        truncDecider = QueryConversionUtility.toLower(truncDecider);
        return truncDecider;
    }

    public static boolean isGaus100() {
        return ApplicationProperty.getStringProperty("TargetDB").equalsIgnoreCase("GaussDBT");
    }

    public static String getTableName(String input) {
        Matcher matcher;
        if (input.matches("(?i).*?(?<!\\w)table(?!\\w).*") && (matcher = Pattern.compile("(?i).*?(?<!\\w)(?:create|alter)(?!\\w).*?(?<!\\w)table(?!\\w)((\\$?\\s*\\{?\\w+\\s*\\}?\\s*\\.\\s*\\$?\\s*\\{?\\w+\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\".*?\"\\s*\\}?\\s*\\.\\s*\\$?\\s*\\{?\".*?\"\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\".*?\"\\s*\\}?\\s*\\.\\s*\\$?\\s*\\{?\\w+\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\\w+\\s*\\}?\\s*\\.\\s*\\$?\\s*\\{?\".*?\"\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\".*?\"\\}?(?:\\s*\\$\\s*\\{.*?\\})?|\\$?\\s*\\{?\\w+\\}?(?:\\s*\\$\\s*\\{.*?\\})?)).*").matcher(input)).find()) {
            return matcher.group(1);
        }
        return "";
    }

    public static String getLvVariableList(String input, String patternString) {
        ArrayList<String> list = new ArrayList<String>(10);
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            String var = matcher.group(1);
            list.add(var);
        }
        Collections.sort(list, Collections.reverseOrder());
        String output = "(" + String.join((CharSequence)"|", list) + ")";
        return output;
    }

    static {
        range = 0;
        appThreadCount = -1;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, System.getProperty("file.encoding")));
        }
        catch (UnsupportedEncodingException e) {
            logger.error(ErrorLoggerUtility.getExceptionDetails(e) + " Error while creating buffer. " + e.getMessage());
        }
    }
}

