/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.td;

import com.github.vertical_blank.sqlformatter.SqlFormatter;
import com.huawei.db.migration.exception.ParserException;
import com.huawei.db.migration.interfaces.DatabaseConvertor;
import com.huawei.db.migration.interfaces.ISqlString;
import com.huawei.hwclouds.migration.common.config.ApplicationPropertyLoader;
import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.migration.common.util.CommonUtils;
import com.huawei.hwclouds.migration.td.DWSMain;
import com.huawei.hwclouds.migration.td.TdConvertor;
import com.huawei.hwclouds.migration.td.util.SqlString;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DWSMigration
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger(DWSMigration.class);
    private static int fileNumber = 0;
    private final File inputFile;
    private final String outputFile;
    private DatabaseConvertor convertor;
    private final int range;
    private final int countValidFiles;
    private static final Pattern PROC_FINDER = Pattern.compile("(?i)^(CREATE)[\\S+\\s+]*(PROCEDURE|FUNCTION|TRIGGER)(\\s+)(.*?)");
    private static final Pattern BEGIN_FINDER = Pattern.compile("(?i)[\\S+\\s+]*begin(\\s?)");

    DWSMigration(File inFile, String outFile, int rangNum, int countValidFilesNum) {
        this.inputFile = inFile;
        this.outputFile = outFile;
        this.range = rangNum;
        this.countValidFiles = countValidFilesNum;
        this.convertor = new TdConvertor(null);
    }

    @Override
    public void run() {
        try {
            String resSql = DWSMigration.parseFile(this.inputFile, this.convertor, this.range);
            if (resSql == null) {
                DWSMain.FAILED_FILES.incrementAndGet();
                return;
            }
            boolean fileCreate = CommonUtils.createNewFile(this.outputFile, false);
            if (!fileCreate) {
                LOGGER.error("Error while creating file");
                return;
            }
            String encodingFormat = DWSMigration.getEncodingFormat();
            FileUtils.write((File)new File(this.outputFile), (CharSequence)resSql, (String)encodingFormat);
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse " + this.inputFile.getName(), (Throwable)e);
            try {
                FileUtils.copyFile((File)this.inputFile, (File)new File(this.outputFile));
            }
            catch (IOException pe) {
                LOGGER.error("Faild to copy file " + this.inputFile.getName());
            }
            DWSMain.FAILED_FILES.incrementAndGet();
        }
        int percent = 100;
        int status = this.countValidFiles > 0 ? ++fileNumber * 100 / this.countValidFiles : 0;
        DWSMain.printConsoleMessage(status + "% completed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static String parseFile(File inputFile, DatabaseConvertor convertor, int rangeNum) throws IOException {
        resSql = new StringBuilder();
        sb = new StringBuilder();
        encodingFormat = DWSMigration.getEncodingFormat();
        validLength = rangeNum;
        it = FileUtils.lineIterator((File)inputFile, (String)encodingFormat);
lbl6:
        // 2 sources

        try {
            while (it.hasNext()) {
                block12: {
                    line = it.nextLine();
                    if (line == null || !DWSMigration.isSqlComment(line)) break block12;
                    sb.append(line);
                    sb.append(System.lineSeparator());
                    if (!line.trim().startsWith("/*")) continue;
                    while (!line.trim().startsWith("*/") && !line.trim().endsWith("*/") && it.hasNext()) {
                        line = it.nextLine();
                        sb.append(line).append('\n');
                    }
                    ** GOTO lbl6
                }
                if ((line = DWSMigration.getBeginWithEndString(sb, it, line)) == null) continue;
                if (line != null && line.trim().endsWith(";")) {
                    length = line.trim().length();
                    if (length == 1) {
                        lastInput = sb.toString().trim();
                        sb.delete(0, sb.length());
                        sb.append(lastInput);
                    }
                    sb.append(line);
                    inputLen = sb.length();
                    if (inputLen > validLength || inputLen <= 1) {
                        DWSMigration.LOGGER.error("Migration of the following file exceeds the max Sql Length: {}", (Object)inputFile.toString());
                        var11_13 = null;
                        return var11_13;
                    }
                    DWSMigration.parseSql(sb, resSql, inputFile.getName(), convertor);
                    continue;
                }
                sb.append(line);
                if ((line == null || line.isEmpty()) && sb.toString().trim().isEmpty()) {
                    resSql.append(System.lineSeparator());
                    continue;
                }
                sb.append(System.lineSeparator());
            }
            DWSMigration.parseSql(sb, resSql, inputFile.getName(), convertor);
        }
        finally {
            LineIterator.closeQuietly((LineIterator)it);
        }
        beforeFormat = resSql.toString().replaceAll("\\s+", "");
        afterFormat = SqlFormatter.format((String)resSql.toString()).replaceAll("\\s+", "");
        if (beforeFormat.equalsIgnoreCase(afterFormat)) {
            return SqlString.handleErrorRes(SqlFormatter.format((String)resSql.toString()));
        }
        return resSql.toString();
    }

    public static void parseSql(StringBuilder sb, StringBuilder resSql, String inputFile, DatabaseConvertor convertor) {
        String altString = sb.toString().toUpperCase(Locale.ROOT);
        if (altString.contains("SET @@") || altString.contains("SET @")) {
            StringBuilder sql = new StringBuilder();
            LOGGER.error("Sql syntax not supported:PLSQL SET @@/@, FileName:{}", (Object)inputFile);
            DWSMain.FAILED_SQL.incrementAndGet();
            resSql.append((CharSequence)sql.append("/* Sql syntax not supported:PLSQL SET @@/@ \r\n").append((CharSequence)sb).append("*/;"));
        } else {
            DWSMigration.convertSql(sb, resSql, inputFile, convertor);
        }
        resSql.append(System.lineSeparator());
    }

    private static void convertSql(StringBuilder sb, StringBuilder resSql, String inputFile, DatabaseConvertor convertor) {
        try {
            convertor.reset();
            convertor.parse(sb.toString());
            ISqlString str = convertor.convert();
            resSql.append(str.getSql());
        }
        catch (Exception e) {
            DWSMigration.handleException(e, resSql, inputFile, sb);
        }
        sb.delete(0, sb.length());
    }

    private static void handleException(Exception e, StringBuilder resSql, String inputFile, StringBuilder sb) {
        if (e instanceof ParserRuntimeException) {
            ParserRuntimeException exception = (ParserRuntimeException)e;
            LOGGER.warn("Sql syntax not supported,exceptionCode:[{}],exceptionMessage:[{}],FileName:{}.", (Object)exception.getExceptionCode(), (Object)e.getMessage(), (Object)inputFile);
            resSql.append("/* Sql syntax not supported, errorCode: ").append(exception.getExceptionCode()).append(", errorMessage: ").append(e.getMessage()).append("\r\n").append((CharSequence)sb).append("*/;");
        } else if (e instanceof com.huawei.hwclouds.migration.common.util.ParserRuntimeException) {
            com.huawei.hwclouds.migration.common.util.ParserRuntimeException exception = (com.huawei.hwclouds.migration.common.util.ParserRuntimeException)e;
            LOGGER.warn("Sql  not supported,exceptionMessage:[{}],FileName:{}.", (Object)e.getMessage(), (Object)inputFile);
            resSql.append("/* Sql not supported, errorMessage: ").append(e.getMessage()).append("\r\n").append((CharSequence)sb).append("*/;");
        } else if (e instanceof ParserException) {
            LOGGER.warn("Sql parser failed, exceptionCode:[{}],exceptionMessage:[{}],FileName:[{}]", (Object)ParserExceptionDef.SQL_PARSER_EXCEPTION.getExceptionCode(), (Object)e.getMessage(), (Object)inputFile);
            resSql.append("/* Sql parser failed, errorCode: ").append(ParserExceptionDef.SQL_PARSER_EXCEPTION.getExceptionCode()).append(", errorMessage: ").append(e.getMessage()).append("\r\n").append((CharSequence)sb).append("*/;");
        } else {
            LOGGER.warn("Sql convert failed, exceptionCode:[{}],exceptionMessage:[{}],FileName:[{}]", (Object)ParserExceptionDef.UNKNOWN_EXCEPTION.getExceptionCode(), (Object)e.getMessage(), (Object)inputFile);
            resSql.append("/* Sql parser failed, errorCode: ").append(ParserExceptionDef.UNKNOWN_EXCEPTION.getExceptionCode()).append(", errorMessage: ").append(ParserExceptionDef.UNKNOWN_EXCEPTION.getExceptionMessage(new Object[0])).append("\r\n").append((CharSequence)sb).append("*/;");
        }
    }

    private static String getBeginWithEndString(StringBuilder sb, LineIterator it, String line) {
        Matcher prMatcher = PROC_FINDER.matcher(line);
        if (prMatcher.matches()) {
            sb.append(line).append('\n');
            return null;
        }
        Matcher beginMatcher = BEGIN_FINDER.matcher(line);
        if (beginMatcher.matches()) {
            sb.append(line).append('\n');
            if (it.hasNext()) {
                line = it.nextLine();
                while (!line.trim().equalsIgnoreCase("END;")) {
                    sb.append(line).append('\n');
                    if (!it.hasNext()) break;
                    line = it.nextLine();
                }
            }
        }
        return line;
    }

    private static String getEncodingFormat() {
        String encodingFormat = null;
        encodingFormat = ApplicationPropertyLoader.getStringProperty("encodingFormat");
        if (encodingFormat.equals("")) {
            encodingFormat = "UTF8";
            LOGGER.info("Files encoding is set to default UTF8");
        }
        LOGGER.info("Files encoding is set from configuration in Application properties file : {}", (Object)encodingFormat);
        return encodingFormat;
    }

    private static boolean isSqlComment(String sql) {
        String str = sql.trim();
        if (str.startsWith("#")) {
            return true;
        }
        if (str.startsWith("--")) {
            return true;
        }
        if (str.startsWith("*")) {
            return true;
        }
        if (str.startsWith("/*")) {
            return true;
        }
        return str.startsWith("*/");
    }
}

