/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.td.parser.visitor;

import com.huawei.hwclouds.migration.td.nodes.DataType;
import com.huawei.hwclouds.migration.td.nodes.NumericParameter;
import com.huawei.hwclouds.migration.td.nodes.TypeName;
import com.huawei.hwclouds.migration.td.parser.TeradataParser;
import com.huawei.hwclouds.migration.td.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.td.parser.visitor.NumericParameterVisitor;
import java.util.Locale;
import org.antlr.v4.runtime.tree.ParseTree;

public class DataTypeVisitor
extends AbstractVisitor<DataType> {
    private DataType dataType = new DataType();

    @Override
    protected DataType defaultResult() {
        return this.dataType;
    }

    @Override
    public DataType visitSimpleDataType(TeradataParser.SimpleDataTypeContext ctx) {
        if (ctx.typeName() != null) {
            this.dataType.setTypeName(TypeName.getTypeName(ctx.typeName().getText().trim().toUpperCase(Locale.ROOT)));
        }
        return this.defaultResult();
    }

    @Override
    public DataType visitTimeDataType(TeradataParser.TimeDataTypeContext ctx) {
        if (ctx.typeName() != null) {
            this.dataType.setTypeName(TypeName.getTypeName(ctx.typeName().getText().trim().toUpperCase(Locale.ROOT)));
        }
        if (ctx.numericParameter().decimalLiteral() != null) {
            this.dataType.setNumericParameter((NumericParameter)new NumericParameterVisitor().visit((ParseTree)ctx.numericParameter()));
        }
        if (ctx.WITH() != null && ctx.TIME() != null && ctx.ZONE() != null) {
            this.dataType.setWithTimeZone(true);
        }
        return this.defaultResult();
    }
}

