/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.td.parser.visitor;

import com.huawei.hwclouds.migration.td.nodes.ExpressionAtom;
import com.huawei.hwclouds.migration.td.nodes.FunctionCallExpression;
import com.huawei.hwclouds.migration.td.nodes.MathExpressionAtom;
import com.huawei.hwclouds.migration.td.nodes.PostFunctionCallExpression;
import com.huawei.hwclouds.migration.td.nodes.SelectTypeColumn;
import com.huawei.hwclouds.migration.td.parser.TeradataParser;
import com.huawei.hwclouds.migration.td.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.td.parser.visitor.FunctionCallVisitor;
import com.huawei.hwclouds.migration.td.parser.visitor.MathExpressionAtomVisitor;
import com.huawei.hwclouds.migration.td.parser.visitor.PostFunctionCallVisitor;
import com.huawei.hwclouds.migration.td.parser.visitor.SelectTypeColumnVisitor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;

public class ExpressionAtomVisitor
extends AbstractVisitor<ExpressionAtom> {
    private static final Pattern QUOTE_PATTERN = Pattern.compile("'([^']*)'");
    ExpressionAtom result = new ExpressionAtom();

    @Override
    protected ExpressionAtom defaultResult() {
        return this.result;
    }

    @Override
    public ExpressionAtom visitConstantExpressionAtom(TeradataParser.ConstantExpressionAtomContext ctx) {
        if (ctx.fullId() == null) {
            return this.result;
        }
        if (ctx.fullId().uid().simpleId() != null && ctx.fullId().uid().simpleId().HEXADECIMAL_LITERAL() != null) {
            Matcher matcher = QUOTE_PATTERN.matcher(ctx.fullId().uid().simpleId().HEXADECIMAL_LITERAL().getText());
            if (matcher.find()) {
                this.result.setUid("E'\\x" + matcher.group(1) + '\'');
            }
        } else if (ctx.fullId().uid().simpleId() != null && ctx.fullId().uid().simpleId().HEXADECIMAL_LITERAL_BINARY() != null) {
            Matcher matcher = QUOTE_PATTERN.matcher(ctx.fullId().uid().simpleId().HEXADECIMAL_LITERAL_BINARY().getText());
            if (matcher.find()) {
                this.result.setUid("'\\x" + matcher.group(1) + '\'');
            }
        } else {
            this.result.setUid(ctx.fullId().getText());
        }
        return this.result;
    }

    @Override
    public ExpressionAtom visitDecimalExpressionAtom(TeradataParser.DecimalExpressionAtomContext ctx) {
        if (ctx.decimalLiteral() != null) {
            this.result.setDecimal(ctx.decimalLiteral().getText());
        }
        return this.result;
    }

    @Override
    public ExpressionAtom visitSelectTypeColumnAtom(TeradataParser.SelectTypeColumnAtomContext ctx) {
        this.result.setSelectTypeColumn((SelectTypeColumn)new SelectTypeColumnVisitor().visit((ParseTree)ctx));
        return this.result;
    }

    @Override
    public ExpressionAtom visitFunctionCallExpressionAtom(TeradataParser.FunctionCallExpressionAtomContext ctx) {
        this.result.setFunctionCallExpression((FunctionCallExpression)new FunctionCallVisitor().visitChildren((RuleNode)ctx.functionCall()));
        return this.result;
    }

    @Override
    public ExpressionAtom visitPostFunctionCallExpressionAtom(TeradataParser.PostFunctionCallExpressionAtomContext ctx) {
        this.result.setPostFunctionCallExpression((PostFunctionCallExpression)new PostFunctionCallVisitor().visit((ParseTree)ctx));
        return this.result;
    }

    @Override
    public ExpressionAtom visitMathExpressionAtom(TeradataParser.MathExpressionAtomContext ctx) {
        this.result.setMathExpressionAtom((MathExpressionAtom)new MathExpressionAtomVisitor().visit((ParseTree)ctx));
        return this.result;
    }
}

